/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowResourceType;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RegisterTargetWithMaintenanceWindowRequest
extends SsmRequest
implements ToCopyableBuilder<Builder, RegisterTargetWithMaintenanceWindowRequest> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WindowId").getter(RegisterTargetWithMaintenanceWindowRequest.getter(RegisterTargetWithMaintenanceWindowRequest::windowId)).setter(RegisterTargetWithMaintenanceWindowRequest.setter(Builder::windowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(RegisterTargetWithMaintenanceWindowRequest.getter(RegisterTargetWithMaintenanceWindowRequest::resourceTypeAsString)).setter(RegisterTargetWithMaintenanceWindowRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(RegisterTargetWithMaintenanceWindowRequest.getter(RegisterTargetWithMaintenanceWindowRequest::targets)).setter(RegisterTargetWithMaintenanceWindowRequest.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OWNER_INFORMATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerInformation").getter(RegisterTargetWithMaintenanceWindowRequest.getter(RegisterTargetWithMaintenanceWindowRequest::ownerInformation)).setter(RegisterTargetWithMaintenanceWindowRequest.setter(Builder::ownerInformation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerInformation").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(RegisterTargetWithMaintenanceWindowRequest.getter(RegisterTargetWithMaintenanceWindowRequest::name)).setter(RegisterTargetWithMaintenanceWindowRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(RegisterTargetWithMaintenanceWindowRequest.getter(RegisterTargetWithMaintenanceWindowRequest::description)).setter(RegisterTargetWithMaintenanceWindowRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(RegisterTargetWithMaintenanceWindowRequest.getter(RegisterTargetWithMaintenanceWindowRequest::clientToken)).setter(RegisterTargetWithMaintenanceWindowRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, RESOURCE_TYPE_FIELD, TARGETS_FIELD, OWNER_INFORMATION_FIELD, NAME_FIELD, DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD));
    private final String windowId;
    private final String resourceType;
    private final List<Target> targets;
    private final String ownerInformation;
    private final String name;
    private final String description;
    private final String clientToken;

    private RegisterTargetWithMaintenanceWindowRequest(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.resourceType = builder.resourceType;
        this.targets = builder.targets;
        this.ownerInformation = builder.ownerInformation;
        this.name = builder.name;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
    }

    public String windowId() {
        return this.windowId;
    }

    public MaintenanceWindowResourceType resourceType() {
        return MaintenanceWindowResourceType.fromValue(this.resourceType);
    }

    public String resourceTypeAsString() {
        return this.resourceType;
    }

    public boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public List<Target> targets() {
        return this.targets;
    }

    public String ownerInformation() {
        return this.ownerInformation;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTargetWithMaintenanceWindowRequest)) {
            return false;
        }
        RegisterTargetWithMaintenanceWindowRequest other = (RegisterTargetWithMaintenanceWindowRequest)((Object)obj);
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.ownerInformation(), other.ownerInformation()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public String toString() {
        return ToString.builder((String)"RegisterTargetWithMaintenanceWindowRequest").add("WindowId", (Object)this.windowId()).add("ResourceType", (Object)this.resourceTypeAsString()).add("Targets", this.hasTargets() ? this.targets() : null).add("OwnerInformation", (Object)(this.ownerInformation() == null ? null : "*** Sensitive Data Redacted ***")).add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "OwnerInformation": {
                return Optional.ofNullable(clazz.cast(this.ownerInformation()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTargetWithMaintenanceWindowRequest, T> g) {
        return obj -> g.apply((RegisterTargetWithMaintenanceWindowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsmRequest.BuilderImpl
    implements Builder {
        private String windowId;
        private String resourceType;
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private String ownerInformation;
        private String name;
        private String description;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTargetWithMaintenanceWindowRequest model) {
            super(model);
            this.windowId(model.windowId);
            this.resourceType(model.resourceType);
            this.targets(model.targets);
            this.ownerInformation(model.ownerInformation);
            this.name(model.name);
            this.description(model.description);
            this.clientToken(model.clientToken);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(MaintenanceWindowResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<Target.Builder> getTargets() {
            if (this.targets instanceof SdkAutoConstructList) {
                return null;
            }
            return this.targets != null ? (Collection)this.targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getOwnerInformation() {
            return this.ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RegisterTargetWithMaintenanceWindowRequest build() {
            return new RegisterTargetWithMaintenanceWindowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RegisterTargetWithMaintenanceWindowRequest> {
        public Builder windowId(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(MaintenanceWindowResourceType var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder ownerInformation(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

