/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetMaintenanceWindowTaskResponse extends SsmResponse implements
        ToCopyableBuilder<GetMaintenanceWindowTaskResponse.Builder, GetMaintenanceWindowTaskResponse> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowId").getter(getter(GetMaintenanceWindowTaskResponse::windowId)).setter(setter(Builder::windowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()).build();

    private static final SdkField<String> WINDOW_TASK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowTaskId").getter(getter(GetMaintenanceWindowTaskResponse::windowTaskId))
            .setter(setter(Builder::windowTaskId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowTaskId").build()).build();

    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(GetMaintenanceWindowTaskResponse::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TASK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskArn").getter(getter(GetMaintenanceWindowTaskResponse::taskArn)).setter(setter(Builder::taskArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskArn").build()).build();

    private static final SdkField<String> SERVICE_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceRoleArn").getter(getter(GetMaintenanceWindowTaskResponse::serviceRoleArn))
            .setter(setter(Builder::serviceRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRoleArn").build()).build();

    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskType").getter(getter(GetMaintenanceWindowTaskResponse::taskTypeAsString))
            .setter(setter(Builder::taskType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskType").build()).build();

    private static final SdkField<Map<String, MaintenanceWindowTaskParameterValueExpression>> TASK_PARAMETERS_FIELD = SdkField
            .<Map<String, MaintenanceWindowTaskParameterValueExpression>> builder(MarshallingType.MAP)
            .memberName("TaskParameters")
            .getter(getter(GetMaintenanceWindowTaskResponse::taskParameters))
            .setter(setter(Builder::taskParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MaintenanceWindowTaskParameterValueExpression> builder(MarshallingType.SDK_POJO)
                                            .constructor(MaintenanceWindowTaskParameterValueExpression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<MaintenanceWindowTaskInvocationParameters> TASK_INVOCATION_PARAMETERS_FIELD = SdkField
            .<MaintenanceWindowTaskInvocationParameters> builder(MarshallingType.SDK_POJO).memberName("TaskInvocationParameters")
            .getter(getter(GetMaintenanceWindowTaskResponse::taskInvocationParameters))
            .setter(setter(Builder::taskInvocationParameters)).constructor(MaintenanceWindowTaskInvocationParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskInvocationParameters").build())
            .build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Priority").getter(getter(GetMaintenanceWindowTaskResponse::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Priority").build()).build();

    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxConcurrency").getter(getter(GetMaintenanceWindowTaskResponse::maxConcurrency))
            .setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()).build();

    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxErrors").getter(getter(GetMaintenanceWindowTaskResponse::maxErrors))
            .setter(setter(Builder::maxErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()).build();

    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.<LoggingInfo> builder(MarshallingType.SDK_POJO)
            .memberName("LoggingInfo").getter(getter(GetMaintenanceWindowTaskResponse::loggingInfo))
            .setter(setter(Builder::loggingInfo)).constructor(LoggingInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoggingInfo").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetMaintenanceWindowTaskResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetMaintenanceWindowTaskResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD,
            WINDOW_TASK_ID_FIELD, TARGETS_FIELD, TASK_ARN_FIELD, SERVICE_ROLE_ARN_FIELD, TASK_TYPE_FIELD, TASK_PARAMETERS_FIELD,
            TASK_INVOCATION_PARAMETERS_FIELD, PRIORITY_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, LOGGING_INFO_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD));

    private final String windowId;

    private final String windowTaskId;

    private final List<Target> targets;

    private final String taskArn;

    private final String serviceRoleArn;

    private final String taskType;

    private final Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters;

    private final MaintenanceWindowTaskInvocationParameters taskInvocationParameters;

    private final Integer priority;

    private final String maxConcurrency;

    private final String maxErrors;

    private final LoggingInfo loggingInfo;

    private final String name;

    private final String description;

    private GetMaintenanceWindowTaskResponse(BuilderImpl builder) {
        super(builder);
        this.windowId = builder.windowId;
        this.windowTaskId = builder.windowTaskId;
        this.targets = builder.targets;
        this.taskArn = builder.taskArn;
        this.serviceRoleArn = builder.serviceRoleArn;
        this.taskType = builder.taskType;
        this.taskParameters = builder.taskParameters;
        this.taskInvocationParameters = builder.taskInvocationParameters;
        this.priority = builder.priority;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.loggingInfo = builder.loggingInfo;
        this.name = builder.name;
        this.description = builder.description;
    }

    /**
     * <p>
     * The retrieved maintenance window ID.
     * </p>
     * 
     * @return The retrieved maintenance window ID.
     */
    public String windowId() {
        return windowId;
    }

    /**
     * <p>
     * The retrieved maintenance window task ID.
     * </p>
     * 
     * @return The retrieved maintenance window task ID.
     */
    public String windowTaskId() {
        return windowTaskId;
    }

    /**
     * Returns true if the Targets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The targets where the task should run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The targets where the task should run.
     */
    public List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * The resource that the task used during execution. For RUN_COMMAND and AUTOMATION task types, the TaskArn is the
     * Systems Manager Document name/ARN. For LAMBDA tasks, the value is the function name/ARN. For STEP_FUNCTIONS
     * tasks, the value is the state machine ARN.
     * </p>
     * 
     * @return The resource that the task used during execution. For RUN_COMMAND and AUTOMATION task types, the TaskArn
     *         is the Systems Manager Document name/ARN. For LAMBDA tasks, the value is the function name/ARN. For
     *         STEP_FUNCTIONS tasks, the value is the state machine ARN.
     */
    public String taskArn() {
        return taskArn;
    }

    /**
     * <p>
     * The ARN of the IAM service role to use to publish Amazon Simple Notification Service (Amazon SNS) notifications
     * for maintenance window Run Command tasks.
     * </p>
     * 
     * @return The ARN of the IAM service role to use to publish Amazon Simple Notification Service (Amazon SNS)
     *         notifications for maintenance window Run Command tasks.
     */
    public String serviceRoleArn() {
        return serviceRoleArn;
    }

    /**
     * <p>
     * The type of task to run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link MaintenanceWindowTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskTypeAsString}.
     * </p>
     * 
     * @return The type of task to run.
     * @see MaintenanceWindowTaskType
     */
    public MaintenanceWindowTaskType taskType() {
        return MaintenanceWindowTaskType.fromValue(taskType);
    }

    /**
     * <p>
     * The type of task to run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link MaintenanceWindowTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskTypeAsString}.
     * </p>
     * 
     * @return The type of task to run.
     * @see MaintenanceWindowTaskType
     */
    public String taskTypeAsString() {
        return taskType;
    }

    /**
     * Returns true if the TaskParameters property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTaskParameters() {
        return taskParameters != null && !(taskParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters to pass to the task when it runs.
     * </p>
     * <note>
     * <p>
     * <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs, instead
     * use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For information
     * about how Systems Manager handles these options for the supported maintenance window task types, see
     * <a>MaintenanceWindowTaskInvocationParameters</a>.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTaskParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parameters to pass to the task when it runs.</p> <note>
     *         <p>
     *         <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
     *         instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure.
     *         For information about how Systems Manager handles these options for the supported maintenance window task
     *         types, see <a>MaintenanceWindowTaskInvocationParameters</a>.
     *         </p>
     */
    public Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters() {
        return taskParameters;
    }

    /**
     * <p>
     * The parameters to pass to the task when it runs.
     * </p>
     * 
     * @return The parameters to pass to the task when it runs.
     */
    public MaintenanceWindowTaskInvocationParameters taskInvocationParameters() {
        return taskInvocationParameters;
    }

    /**
     * <p>
     * The priority of the task when it runs. The lower the number, the higher the priority. Tasks that have the same
     * priority are scheduled in parallel.
     * </p>
     * 
     * @return The priority of the task when it runs. The lower the number, the higher the priority. Tasks that have the
     *         same priority are scheduled in parallel.
     */
    public Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The maximum number of targets allowed to run this task in parallel.
     * </p>
     * 
     * @return The maximum number of targets allowed to run this task in parallel.
     */
    public String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The maximum number of errors allowed before the task stops being scheduled.
     * </p>
     * 
     * @return The maximum number of errors allowed before the task stops being scheduled.
     */
    public String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The location in Amazon S3 where the task results are logged.
     * </p>
     * <note>
     * <p>
     * <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the
     * <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the
     * <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these options
     * for the supported maintenance window task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.
     * </p>
     * </note>
     * 
     * @return The location in Amazon S3 where the task results are logged.</p> <note>
     *         <p>
     *         <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the
     *         <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the
     *         <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these
     *         options for the supported maintenance window task types, see
     *         <a>MaintenanceWindowTaskInvocationParameters</a>.
     *         </p>
     */
    public LoggingInfo loggingInfo() {
        return loggingInfo;
    }

    /**
     * <p>
     * The retrieved task name.
     * </p>
     * 
     * @return The retrieved task name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The retrieved task description.
     * </p>
     * 
     * @return The retrieved task description.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(windowId());
        hashCode = 31 * hashCode + Objects.hashCode(windowTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskParameters() ? taskParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskInvocationParameters());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMaintenanceWindowTaskResponse)) {
            return false;
        }
        GetMaintenanceWindowTaskResponse other = (GetMaintenanceWindowTaskResponse) obj;
        return Objects.equals(windowId(), other.windowId()) && Objects.equals(windowTaskId(), other.windowTaskId())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && Objects.equals(taskArn(), other.taskArn()) && Objects.equals(serviceRoleArn(), other.serviceRoleArn())
                && Objects.equals(taskTypeAsString(), other.taskTypeAsString())
                && hasTaskParameters() == other.hasTaskParameters() && Objects.equals(taskParameters(), other.taskParameters())
                && Objects.equals(taskInvocationParameters(), other.taskInvocationParameters())
                && Objects.equals(priority(), other.priority()) && Objects.equals(maxConcurrency(), other.maxConcurrency())
                && Objects.equals(maxErrors(), other.maxErrors()) && Objects.equals(loggingInfo(), other.loggingInfo())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetMaintenanceWindowTaskResponse").add("WindowId", windowId())
                .add("WindowTaskId", windowTaskId()).add("Targets", hasTargets() ? targets() : null).add("TaskArn", taskArn())
                .add("ServiceRoleArn", serviceRoleArn()).add("TaskType", taskTypeAsString())
                .add("TaskParameters", taskParameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("TaskInvocationParameters", taskInvocationParameters()).add("Priority", priority())
                .add("MaxConcurrency", maxConcurrency()).add("MaxErrors", maxErrors()).add("LoggingInfo", loggingInfo())
                .add("Name", name()).add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowId":
            return Optional.ofNullable(clazz.cast(windowId()));
        case "WindowTaskId":
            return Optional.ofNullable(clazz.cast(windowTaskId()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "TaskArn":
            return Optional.ofNullable(clazz.cast(taskArn()));
        case "ServiceRoleArn":
            return Optional.ofNullable(clazz.cast(serviceRoleArn()));
        case "TaskType":
            return Optional.ofNullable(clazz.cast(taskTypeAsString()));
        case "TaskParameters":
            return Optional.ofNullable(clazz.cast(taskParameters()));
        case "TaskInvocationParameters":
            return Optional.ofNullable(clazz.cast(taskInvocationParameters()));
        case "Priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "MaxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "MaxErrors":
            return Optional.ofNullable(clazz.cast(maxErrors()));
        case "LoggingInfo":
            return Optional.ofNullable(clazz.cast(loggingInfo()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetMaintenanceWindowTaskResponse, T> g) {
        return obj -> g.apply((GetMaintenanceWindowTaskResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetMaintenanceWindowTaskResponse> {
        /**
         * <p>
         * The retrieved maintenance window ID.
         * </p>
         * 
         * @param windowId
         *        The retrieved maintenance window ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowId(String windowId);

        /**
         * <p>
         * The retrieved maintenance window task ID.
         * </p>
         * 
         * @param windowTaskId
         *        The retrieved maintenance window task ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTaskId(String windowTaskId);

        /**
         * <p>
         * The targets where the task should run.
         * </p>
         * 
         * @param targets
         *        The targets where the task should run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The targets where the task should run.
         * </p>
         * 
         * @param targets
         *        The targets where the task should run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * The targets where the task should run.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Target>.Builder} avoiding the need to
         * create one manually via {@link List<Target>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Target>.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<Target>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * The resource that the task used during execution. For RUN_COMMAND and AUTOMATION task types, the TaskArn is
         * the Systems Manager Document name/ARN. For LAMBDA tasks, the value is the function name/ARN. For
         * STEP_FUNCTIONS tasks, the value is the state machine ARN.
         * </p>
         * 
         * @param taskArn
         *        The resource that the task used during execution. For RUN_COMMAND and AUTOMATION task types, the
         *        TaskArn is the Systems Manager Document name/ARN. For LAMBDA tasks, the value is the function
         *        name/ARN. For STEP_FUNCTIONS tasks, the value is the state machine ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskArn(String taskArn);

        /**
         * <p>
         * The ARN of the IAM service role to use to publish Amazon Simple Notification Service (Amazon SNS)
         * notifications for maintenance window Run Command tasks.
         * </p>
         * 
         * @param serviceRoleArn
         *        The ARN of the IAM service role to use to publish Amazon Simple Notification Service (Amazon SNS)
         *        notifications for maintenance window Run Command tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRoleArn(String serviceRoleArn);

        /**
         * <p>
         * The type of task to run.
         * </p>
         * 
         * @param taskType
         *        The type of task to run.
         * @see MaintenanceWindowTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowTaskType
         */
        Builder taskType(String taskType);

        /**
         * <p>
         * The type of task to run.
         * </p>
         * 
         * @param taskType
         *        The type of task to run.
         * @see MaintenanceWindowTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowTaskType
         */
        Builder taskType(MaintenanceWindowTaskType taskType);

        /**
         * <p>
         * The parameters to pass to the task when it runs.
         * </p>
         * <note>
         * <p>
         * <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
         * instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure. For
         * information about how Systems Manager handles these options for the supported maintenance window task types,
         * see <a>MaintenanceWindowTaskInvocationParameters</a>.
         * </p>
         * </note>
         * 
         * @param taskParameters
         *        The parameters to pass to the task when it runs.</p> <note>
         *        <p>
         *        <code>TaskParameters</code> has been deprecated. To specify parameters to pass to a task when it runs,
         *        instead use the <code>Parameters</code> option in the <code>TaskInvocationParameters</code> structure.
         *        For information about how Systems Manager handles these options for the supported maintenance window
         *        task types, see <a>MaintenanceWindowTaskInvocationParameters</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters);

        /**
         * <p>
         * The parameters to pass to the task when it runs.
         * </p>
         * 
         * @param taskInvocationParameters
         *        The parameters to pass to the task when it runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters);

        /**
         * <p>
         * The parameters to pass to the task when it runs.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link MaintenanceWindowTaskInvocationParameters.Builder} avoiding the need to create one manually via
         * {@link MaintenanceWindowTaskInvocationParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link MaintenanceWindowTaskInvocationParameters.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #taskInvocationParameters(MaintenanceWindowTaskInvocationParameters)}.
         * 
         * @param taskInvocationParameters
         *        a consumer that will call methods on {@link MaintenanceWindowTaskInvocationParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskInvocationParameters(MaintenanceWindowTaskInvocationParameters)
         */
        default Builder taskInvocationParameters(
                Consumer<MaintenanceWindowTaskInvocationParameters.Builder> taskInvocationParameters) {
            return taskInvocationParameters(MaintenanceWindowTaskInvocationParameters.builder()
                    .applyMutation(taskInvocationParameters).build());
        }

        /**
         * <p>
         * The priority of the task when it runs. The lower the number, the higher the priority. Tasks that have the
         * same priority are scheduled in parallel.
         * </p>
         * 
         * @param priority
         *        The priority of the task when it runs. The lower the number, the higher the priority. Tasks that have
         *        the same priority are scheduled in parallel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The maximum number of targets allowed to run this task in parallel.
         * </p>
         * 
         * @param maxConcurrency
         *        The maximum number of targets allowed to run this task in parallel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The maximum number of errors allowed before the task stops being scheduled.
         * </p>
         * 
         * @param maxErrors
         *        The maximum number of errors allowed before the task stops being scheduled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The location in Amazon S3 where the task results are logged.
         * </p>
         * <note>
         * <p>
         * <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the
         * <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the
         * <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these
         * options for the supported maintenance window task types, see
         * <a>MaintenanceWindowTaskInvocationParameters</a>.
         * </p>
         * </note>
         * 
         * @param loggingInfo
         *        The location in Amazon S3 where the task results are logged.</p> <note>
         *        <p>
         *        <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the
         *        <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the
         *        <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles
         *        these options for the supported maintenance window task types, see
         *        <a>MaintenanceWindowTaskInvocationParameters</a>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loggingInfo(LoggingInfo loggingInfo);

        /**
         * <p>
         * The location in Amazon S3 where the task results are logged.
         * </p>
         * <note>
         * <p>
         * <code>LoggingInfo</code> has been deprecated. To specify an S3 bucket to contain logs, instead use the
         * <code>OutputS3BucketName</code> and <code>OutputS3KeyPrefix</code> options in the
         * <code>TaskInvocationParameters</code> structure. For information about how Systems Manager handles these
         * options for the supported maintenance window task types, see
         * <a>MaintenanceWindowTaskInvocationParameters</a>.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link LoggingInfo.Builder} avoiding the need
         * to create one manually via {@link LoggingInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link LoggingInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #loggingInfo(LoggingInfo)}.
         * 
         * @param loggingInfo
         *        a consumer that will call methods on {@link LoggingInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loggingInfo(LoggingInfo)
         */
        default Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return loggingInfo(LoggingInfo.builder().applyMutation(loggingInfo).build());
        }

        /**
         * <p>
         * The retrieved task name.
         * </p>
         * 
         * @param name
         *        The retrieved task name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The retrieved task description.
         * </p>
         * 
         * @param description
         *        The retrieved task description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String windowId;

        private String windowTaskId;

        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private String taskArn;

        private String serviceRoleArn;

        private String taskType;

        private Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters = DefaultSdkAutoConstructMap
                .getInstance();

        private MaintenanceWindowTaskInvocationParameters taskInvocationParameters;

        private Integer priority;

        private String maxConcurrency;

        private String maxErrors;

        private LoggingInfo loggingInfo;

        private String name;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMaintenanceWindowTaskResponse model) {
            super(model);
            windowId(model.windowId);
            windowTaskId(model.windowTaskId);
            targets(model.targets);
            taskArn(model.taskArn);
            serviceRoleArn(model.serviceRoleArn);
            taskType(model.taskType);
            taskParameters(model.taskParameters);
            taskInvocationParameters(model.taskInvocationParameters);
            priority(model.priority);
            maxConcurrency(model.maxConcurrency);
            maxErrors(model.maxErrors);
            loggingInfo(model.loggingInfo);
            name(model.name);
            description(model.description);
        }

        public final String getWindowId() {
            return windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        public final String getWindowTaskId() {
            return windowTaskId;
        }

        @Override
        public final Builder windowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
            return this;
        }

        public final void setWindowTaskId(String windowTaskId) {
            this.windowTaskId = windowTaskId;
        }

        public final Collection<Target.Builder> getTargets() {
            if (targets instanceof SdkAutoConstructList) {
                return null;
            }
            return targets != null ? targets.stream().map(Target::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getTaskArn() {
            return taskArn;
        }

        @Override
        public final Builder taskArn(String taskArn) {
            this.taskArn = taskArn;
            return this;
        }

        public final void setTaskArn(String taskArn) {
            this.taskArn = taskArn;
        }

        public final String getServiceRoleArn() {
            return serviceRoleArn;
        }

        @Override
        public final Builder serviceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
            return this;
        }

        public final void setServiceRoleArn(String serviceRoleArn) {
            this.serviceRoleArn = serviceRoleArn;
        }

        public final String getTaskType() {
            return taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(MaintenanceWindowTaskType taskType) {
            this.taskType(taskType == null ? null : taskType.toString());
            return this;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public final Map<String, MaintenanceWindowTaskParameterValueExpression.Builder> getTaskParameters() {
            if (taskParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return taskParameters != null ? CollectionUtils.mapValues(taskParameters,
                    MaintenanceWindowTaskParameterValueExpression::toBuilder) : null;
        }

        @Override
        public final Builder taskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copy(taskParameters);
            return this;
        }

        public final void setTaskParameters(Map<String, MaintenanceWindowTaskParameterValueExpression.BuilderImpl> taskParameters) {
            this.taskParameters = MaintenanceWindowTaskParametersCopier.copyFromBuilder(taskParameters);
        }

        public final MaintenanceWindowTaskInvocationParameters.Builder getTaskInvocationParameters() {
            return taskInvocationParameters != null ? taskInvocationParameters.toBuilder() : null;
        }

        @Override
        public final Builder taskInvocationParameters(MaintenanceWindowTaskInvocationParameters taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters;
            return this;
        }

        public final void setTaskInvocationParameters(
                MaintenanceWindowTaskInvocationParameters.BuilderImpl taskInvocationParameters) {
            this.taskInvocationParameters = taskInvocationParameters != null ? taskInvocationParameters.build() : null;
        }

        public final Integer getPriority() {
            return priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return loggingInfo != null ? loggingInfo.toBuilder() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public GetMaintenanceWindowTaskResponse build() {
            return new GetMaintenanceWindowTaskResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
