/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration options for sending command output to CloudWatch Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudWatchOutputConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudWatchOutputConfig.Builder, CloudWatchOutputConfig> {
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CloudWatchLogGroupName").getter(getter(CloudWatchOutputConfig::cloudWatchLogGroupName))
            .setter(setter(Builder::cloudWatchLogGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogGroupName").build())
            .build();

    private static final SdkField<Boolean> CLOUD_WATCH_OUTPUT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CloudWatchOutputEnabled").getter(getter(CloudWatchOutputConfig::cloudWatchOutputEnabled))
            .setter(setter(Builder::cloudWatchOutputEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchOutputEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLOUD_WATCH_LOG_GROUP_NAME_FIELD, CLOUD_WATCH_OUTPUT_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String cloudWatchLogGroupName;

    private final Boolean cloudWatchOutputEnabled;

    private CloudWatchOutputConfig(BuilderImpl builder) {
        this.cloudWatchLogGroupName = builder.cloudWatchLogGroupName;
        this.cloudWatchOutputEnabled = builder.cloudWatchOutputEnabled;
    }

    /**
     * <p>
     * The name of the CloudWatch log group where you want to send command output. If you don't specify a group name,
     * Systems Manager automatically creates a log group for you. The log group uses the following naming format:
     * aws/ssm/<i>SystemsManagerDocumentName</i>.
     * </p>
     * 
     * @return The name of the CloudWatch log group where you want to send command output. If you don't specify a group
     *         name, Systems Manager automatically creates a log group for you. The log group uses the following naming
     *         format: aws/ssm/<i>SystemsManagerDocumentName</i>.
     */
    public String cloudWatchLogGroupName() {
        return cloudWatchLogGroupName;
    }

    /**
     * <p>
     * Enables Systems Manager to send command output to CloudWatch Logs.
     * </p>
     * 
     * @return Enables Systems Manager to send command output to CloudWatch Logs.
     */
    public Boolean cloudWatchOutputEnabled() {
        return cloudWatchOutputEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLogGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchOutputEnabled());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchOutputConfig)) {
            return false;
        }
        CloudWatchOutputConfig other = (CloudWatchOutputConfig) obj;
        return Objects.equals(cloudWatchLogGroupName(), other.cloudWatchLogGroupName())
                && Objects.equals(cloudWatchOutputEnabled(), other.cloudWatchOutputEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CloudWatchOutputConfig").add("CloudWatchLogGroupName", cloudWatchLogGroupName())
                .add("CloudWatchOutputEnabled", cloudWatchOutputEnabled()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLogGroupName":
            return Optional.ofNullable(clazz.cast(cloudWatchLogGroupName()));
        case "CloudWatchOutputEnabled":
            return Optional.ofNullable(clazz.cast(cloudWatchOutputEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudWatchOutputConfig, T> g) {
        return obj -> g.apply((CloudWatchOutputConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudWatchOutputConfig> {
        /**
         * <p>
         * The name of the CloudWatch log group where you want to send command output. If you don't specify a group
         * name, Systems Manager automatically creates a log group for you. The log group uses the following naming
         * format: aws/ssm/<i>SystemsManagerDocumentName</i>.
         * </p>
         * 
         * @param cloudWatchLogGroupName
         *        The name of the CloudWatch log group where you want to send command output. If you don't specify a
         *        group name, Systems Manager automatically creates a log group for you. The log group uses the
         *        following naming format: aws/ssm/<i>SystemsManagerDocumentName</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogGroupName(String cloudWatchLogGroupName);

        /**
         * <p>
         * Enables Systems Manager to send command output to CloudWatch Logs.
         * </p>
         * 
         * @param cloudWatchOutputEnabled
         *        Enables Systems Manager to send command output to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchOutputEnabled(Boolean cloudWatchOutputEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String cloudWatchLogGroupName;

        private Boolean cloudWatchOutputEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchOutputConfig model) {
            cloudWatchLogGroupName(model.cloudWatchLogGroupName);
            cloudWatchOutputEnabled(model.cloudWatchOutputEnabled);
        }

        public final String getCloudWatchLogGroupName() {
            return cloudWatchLogGroupName;
        }

        @Override
        public final Builder cloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
            return this;
        }

        public final void setCloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
        }

        public final Boolean getCloudWatchOutputEnabled() {
            return cloudWatchOutputEnabled;
        }

        @Override
        public final Builder cloudWatchOutputEnabled(Boolean cloudWatchOutputEnabled) {
            this.cloudWatchOutputEnabled = cloudWatchOutputEnabled;
            return this;
        }

        public final void setCloudWatchOutputEnabled(Boolean cloudWatchOutputEnabled) {
            this.cloudWatchOutputEnabled = cloudWatchOutputEnabled;
        }

        @Override
        public CloudWatchOutputConfig build() {
            return new CloudWatchOutputConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
