/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Version information about the document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentVersionInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentVersionInfo.Builder, DocumentVersionInfo> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(DocumentVersionInfo::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(DocumentVersionInfo::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionName").getter(getter(DocumentVersionInfo::versionName)).setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(DocumentVersionInfo::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_VERSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefaultVersion").getter(getter(DocumentVersionInfo::isDefaultVersion))
            .setter(setter(Builder::isDefaultVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultVersion").build()).build();

    private static final SdkField<String> DOCUMENT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentFormat").getter(getter(DocumentVersionInfo::documentFormatAsString))
            .setter(setter(Builder::documentFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentFormat").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(DocumentVersionInfo::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_INFORMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusInformation").getter(getter(DocumentVersionInfo::statusInformation))
            .setter(setter(Builder::statusInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusInformation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DOCUMENT_VERSION_FIELD, VERSION_NAME_FIELD, CREATED_DATE_FIELD, IS_DEFAULT_VERSION_FIELD, DOCUMENT_FORMAT_FIELD,
            STATUS_FIELD, STATUS_INFORMATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String documentVersion;

    private final String versionName;

    private final Instant createdDate;

    private final Boolean isDefaultVersion;

    private final String documentFormat;

    private final String status;

    private final String statusInformation;

    private DocumentVersionInfo(BuilderImpl builder) {
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.versionName = builder.versionName;
        this.createdDate = builder.createdDate;
        this.isDefaultVersion = builder.isDefaultVersion;
        this.documentFormat = builder.documentFormat;
        this.status = builder.status;
        this.statusInformation = builder.statusInformation;
    }

    /**
     * <p>
     * The document name.
     * </p>
     * 
     * @return The document name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The document version.
     * </p>
     * 
     * @return The document version.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is
     * unique across all versions of a document, and cannot be changed.
     * </p>
     * 
     * @return The version of the artifact associated with the document. For example, "Release 12, Update 6". This value
     *         is unique across all versions of a document, and cannot be changed.
     */
    public String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The date the document was created.
     * </p>
     * 
     * @return The date the document was created.
     */
    public Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * An identifier for the default version of the document.
     * </p>
     * 
     * @return An identifier for the default version of the document.
     */
    public Boolean isDefaultVersion() {
        return isDefaultVersion;
    }

    /**
     * <p>
     * The document format, either JSON or YAML.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentFormat}
     * will return {@link DocumentFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentFormatAsString}.
     * </p>
     * 
     * @return The document format, either JSON or YAML.
     * @see DocumentFormat
     */
    public DocumentFormat documentFormat() {
        return DocumentFormat.fromValue(documentFormat);
    }

    /**
     * <p>
     * The document format, either JSON or YAML.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentFormat}
     * will return {@link DocumentFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentFormatAsString}.
     * </p>
     * 
     * @return The document format, either JSON or YAML.
     * @see DocumentFormat
     */
    public String documentFormatAsString() {
        return documentFormat;
    }

    /**
     * <p>
     * The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
     * <code>Failed</code>, and <code>Deleting</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DocumentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
     *         <code>Failed</code>, and <code>Deleting</code>.
     * @see DocumentStatus
     */
    public DocumentStatus status() {
        return DocumentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
     * <code>Failed</code>, and <code>Deleting</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DocumentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
     *         <code>Failed</code>, and <code>Deleting</code>.
     * @see DocumentStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message returned by AWS Systems Manager that explains the <code>Status</code> value. For example, a
     * <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
     * "The specified S3 bucket does not exist. Verify that the URL of the S3 bucket is correct."
     * </p>
     * 
     * @return A message returned by AWS Systems Manager that explains the <code>Status</code> value. For example, a
     *         <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
     *         "The specified S3 bucket does not exist. Verify that the URL of the S3 bucket is correct."
     */
    public String statusInformation() {
        return statusInformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultVersion());
        hashCode = 31 * hashCode + Objects.hashCode(documentFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusInformation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentVersionInfo)) {
            return false;
        }
        DocumentVersionInfo other = (DocumentVersionInfo) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(versionName(), other.versionName()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(isDefaultVersion(), other.isDefaultVersion())
                && Objects.equals(documentFormatAsString(), other.documentFormatAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusInformation(), other.statusInformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DocumentVersionInfo").add("Name", name()).add("DocumentVersion", documentVersion())
                .add("VersionName", versionName()).add("CreatedDate", createdDate()).add("IsDefaultVersion", isDefaultVersion())
                .add("DocumentFormat", documentFormatAsString()).add("Status", statusAsString())
                .add("StatusInformation", statusInformation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "IsDefaultVersion":
            return Optional.ofNullable(clazz.cast(isDefaultVersion()));
        case "DocumentFormat":
            return Optional.ofNullable(clazz.cast(documentFormatAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusInformation":
            return Optional.ofNullable(clazz.cast(statusInformation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentVersionInfo, T> g) {
        return obj -> g.apply((DocumentVersionInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentVersionInfo> {
        /**
         * <p>
         * The document name.
         * </p>
         * 
         * @param name
         *        The document name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The document version.
         * </p>
         * 
         * @param documentVersion
         *        The document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is
         * unique across all versions of a document, and cannot be changed.
         * </p>
         * 
         * @param versionName
         *        The version of the artifact associated with the document. For example, "Release 12, Update 6". This
         *        value is unique across all versions of a document, and cannot be changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The date the document was created.
         * </p>
         * 
         * @param createdDate
         *        The date the document was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * An identifier for the default version of the document.
         * </p>
         * 
         * @param isDefaultVersion
         *        An identifier for the default version of the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultVersion(Boolean isDefaultVersion);

        /**
         * <p>
         * The document format, either JSON or YAML.
         * </p>
         * 
         * @param documentFormat
         *        The document format, either JSON or YAML.
         * @see DocumentFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentFormat
         */
        Builder documentFormat(String documentFormat);

        /**
         * <p>
         * The document format, either JSON or YAML.
         * </p>
         * 
         * @param documentFormat
         *        The document format, either JSON or YAML.
         * @see DocumentFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentFormat
         */
        Builder documentFormat(DocumentFormat documentFormat);

        /**
         * <p>
         * The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
         * <code>Failed</code>, and <code>Deleting</code>.
         * </p>
         * 
         * @param status
         *        The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
         *        <code>Failed</code>, and <code>Deleting</code>.
         * @see DocumentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
         * <code>Failed</code>, and <code>Deleting</code>.
         * </p>
         * 
         * @param status
         *        The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
         *        <code>Failed</code>, and <code>Deleting</code>.
         * @see DocumentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentStatus
         */
        Builder status(DocumentStatus status);

        /**
         * <p>
         * A message returned by AWS Systems Manager that explains the <code>Status</code> value. For example, a
         * <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
         * "The specified S3 bucket does not exist. Verify that the URL of the S3 bucket is correct."
         * </p>
         * 
         * @param statusInformation
         *        A message returned by AWS Systems Manager that explains the <code>Status</code> value. For example, a
         *        <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
         *        "The specified S3 bucket does not exist. Verify that the URL of the S3 bucket is correct."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusInformation(String statusInformation);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String documentVersion;

        private String versionName;

        private Instant createdDate;

        private Boolean isDefaultVersion;

        private String documentFormat;

        private String status;

        private String statusInformation;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentVersionInfo model) {
            name(model.name);
            documentVersion(model.documentVersion);
            versionName(model.versionName);
            createdDate(model.createdDate);
            isDefaultVersion(model.isDefaultVersion);
            documentFormat(model.documentFormat);
            status(model.status);
            statusInformation(model.statusInformation);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getVersionName() {
            return versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        public final Boolean getIsDefaultVersion() {
            return isDefaultVersion;
        }

        @Override
        public final Builder isDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
            return this;
        }

        public final void setIsDefaultVersion(Boolean isDefaultVersion) {
            this.isDefaultVersion = isDefaultVersion;
        }

        public final String getDocumentFormat() {
            return documentFormat;
        }

        @Override
        public final Builder documentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
            return this;
        }

        @Override
        public final Builder documentFormat(DocumentFormat documentFormat) {
            this.documentFormat(documentFormat == null ? null : documentFormat.toString());
            return this;
        }

        public final void setDocumentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DocumentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusInformation() {
            return statusInformation;
        }

        @Override
        public final Builder statusInformation(String statusInformation) {
            this.statusInformation = statusInformation;
            return this;
        }

        public final void setStatusInformation(String statusInformation) {
            this.statusInformation = statusInformation;
        }

        @Override
        public DocumentVersionInfo build() {
            return new DocumentVersionInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
