/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInventoryEntriesResponse extends SsmResponse implements
        ToCopyableBuilder<ListInventoryEntriesResponse.Builder, ListInventoryEntriesResponse> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TypeName").getter(getter(ListInventoryEntriesResponse::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TypeName").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(ListInventoryEntriesResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersion").getter(getter(ListInventoryEntriesResponse::schemaVersion))
            .setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersion").build()).build();

    private static final SdkField<String> CAPTURE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CaptureTime").getter(getter(ListInventoryEntriesResponse::captureTime))
            .setter(setter(Builder::captureTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaptureTime").build()).build();

    private static final SdkField<List<Map<String, String>>> ENTRIES_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("Entries")
            .getter(getter(ListInventoryEntriesResponse::entries))
            .setter(setter(Builder::entries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInventoryEntriesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD,
            INSTANCE_ID_FIELD, SCHEMA_VERSION_FIELD, CAPTURE_TIME_FIELD, ENTRIES_FIELD, NEXT_TOKEN_FIELD));

    private final String typeName;

    private final String instanceId;

    private final String schemaVersion;

    private final String captureTime;

    private final List<Map<String, String>> entries;

    private final String nextToken;

    private ListInventoryEntriesResponse(BuilderImpl builder) {
        super(builder);
        this.typeName = builder.typeName;
        this.instanceId = builder.instanceId;
        this.schemaVersion = builder.schemaVersion;
        this.captureTime = builder.captureTime;
        this.entries = builder.entries;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The type of inventory item returned by the request.
     * </p>
     * 
     * @return The type of inventory item returned by the request.
     */
    public String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The instance ID targeted by the request to query inventory information.
     * </p>
     * 
     * @return The instance ID targeted by the request to query inventory information.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The inventory schema version used by the instance(s).
     * </p>
     * 
     * @return The inventory schema version used by the instance(s).
     */
    public String schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The time that inventory information was collected for the instance(s).
     * </p>
     * 
     * @return The time that inventory information was collected for the instance(s).
     */
    public String captureTime() {
        return captureTime;
    }

    /**
     * Returns true if the Entries property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEntries() {
        return entries != null && !(entries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of inventory items on the instance(s).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEntries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of inventory items on the instance(s).
     */
    public List<Map<String, String>> entries() {
        return entries;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(captureTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasEntries() ? entries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInventoryEntriesResponse)) {
            return false;
        }
        ListInventoryEntriesResponse other = (ListInventoryEntriesResponse) obj;
        return Objects.equals(typeName(), other.typeName()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(schemaVersion(), other.schemaVersion()) && Objects.equals(captureTime(), other.captureTime())
                && hasEntries() == other.hasEntries() && Objects.equals(entries(), other.entries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListInventoryEntriesResponse").add("TypeName", typeName()).add("InstanceId", instanceId())
                .add("SchemaVersion", schemaVersion()).add("CaptureTime", captureTime())
                .add("Entries", hasEntries() ? entries() : null).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TypeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "SchemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "CaptureTime":
            return Optional.ofNullable(clazz.cast(captureTime()));
        case "Entries":
            return Optional.ofNullable(clazz.cast(entries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListInventoryEntriesResponse, T> g) {
        return obj -> g.apply((ListInventoryEntriesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListInventoryEntriesResponse> {
        /**
         * <p>
         * The type of inventory item returned by the request.
         * </p>
         * 
         * @param typeName
         *        The type of inventory item returned by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The instance ID targeted by the request to query inventory information.
         * </p>
         * 
         * @param instanceId
         *        The instance ID targeted by the request to query inventory information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The inventory schema version used by the instance(s).
         * </p>
         * 
         * @param schemaVersion
         *        The inventory schema version used by the instance(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The time that inventory information was collected for the instance(s).
         * </p>
         * 
         * @param captureTime
         *        The time that inventory information was collected for the instance(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder captureTime(String captureTime);

        /**
         * <p>
         * A list of inventory items on the instance(s).
         * </p>
         * 
         * @param entries
         *        A list of inventory items on the instance(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<? extends Map<String, String>> entries);

        /**
         * <p>
         * A list of inventory items on the instance(s).
         * </p>
         * 
         * @param entries
         *        A list of inventory items on the instance(s).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Map<String, String>... entries);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String typeName;

        private String instanceId;

        private String schemaVersion;

        private String captureTime;

        private List<Map<String, String>> entries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInventoryEntriesResponse model) {
            super(model);
            typeName(model.typeName);
            instanceId(model.instanceId);
            schemaVersion(model.schemaVersion);
            captureTime(model.captureTime);
            entries(model.entries);
            nextToken(model.nextToken);
        }

        public final String getTypeName() {
            return typeName;
        }

        @Override
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        public final String getCaptureTime() {
            return captureTime;
        }

        @Override
        public final Builder captureTime(String captureTime) {
            this.captureTime = captureTime;
            return this;
        }

        public final void setCaptureTime(String captureTime) {
            this.captureTime = captureTime;
        }

        public final Collection<? extends Map<String, String>> getEntries() {
            if (entries instanceof SdkAutoConstructList) {
                return null;
            }
            return entries;
        }

        @Override
        public final Builder entries(Collection<? extends Map<String, String>> entries) {
            this.entries = InventoryItemEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(Map<String, String>... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<? extends Map<String, String>> entries) {
            this.entries = InventoryItemEntryListCopier.copy(entries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListInventoryEntriesResponse build() {
            return new ListInventoryEntriesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
