/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartChangeRequestExecutionRequest extends SsmRequest implements
        ToCopyableBuilder<StartChangeRequestExecutionRequest.Builder, StartChangeRequestExecutionRequest> {
    private static final SdkField<Instant> SCHEDULED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ScheduledTime").getter(getter(StartChangeRequestExecutionRequest::scheduledTime))
            .setter(setter(Builder::scheduledTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTime").build()).build();

    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentName").getter(getter(StartChangeRequestExecutionRequest::documentName))
            .setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(StartChangeRequestExecutionRequest::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(StartChangeRequestExecutionRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> CHANGE_REQUEST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeRequestName").getter(getter(StartChangeRequestExecutionRequest::changeRequestName))
            .setter(setter(Builder::changeRequestName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeRequestName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(StartChangeRequestExecutionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<List<Runbook>> RUNBOOKS_FIELD = SdkField
            .<List<Runbook>> builder(MarshallingType.LIST)
            .memberName("Runbooks")
            .getter(getter(StartChangeRequestExecutionRequest::runbooks))
            .setter(setter(Builder::runbooks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Runbooks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Runbook> builder(MarshallingType.SDK_POJO)
                                            .constructor(Runbook::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartChangeRequestExecutionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_TIME_FIELD,
            DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, PARAMETERS_FIELD, CHANGE_REQUEST_NAME_FIELD, CLIENT_TOKEN_FIELD,
            RUNBOOKS_FIELD, TAGS_FIELD));

    private final Instant scheduledTime;

    private final String documentName;

    private final String documentVersion;

    private final Map<String, List<String>> parameters;

    private final String changeRequestName;

    private final String clientToken;

    private final List<Runbook> runbooks;

    private final List<Tag> tags;

    private StartChangeRequestExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.scheduledTime = builder.scheduledTime;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.parameters = builder.parameters;
        this.changeRequestName = builder.changeRequestName;
        this.clientToken = builder.clientToken;
        this.runbooks = builder.runbooks;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The date and time specified in the change request to run the Automation runbooks.
     * </p>
     * <note>
     * <p>
     * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change
     * request have been received.
     * </p>
     * </note>
     * 
     * @return The date and time specified in the change request to run the Automation runbooks.</p> <note>
     *         <p>
     *         The Automation runbooks specified for the runbook workflow can't run until all required approvals for the
     *         change request have been received.
     *         </p>
     */
    public Instant scheduledTime() {
        return scheduledTime;
    }

    /**
     * <p>
     * The name of the change template document to run during the runbook workflow.
     * </p>
     * 
     * @return The name of the change template document to run during the runbook workflow.
     */
    public String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The version of the change template document to run during the runbook workflow.
     * </p>
     * 
     * @return The version of the change template document to run during the runbook workflow.
     */
    public String documentVersion() {
        return documentVersion;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map of parameters that match the declared parameters in the change template document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A key-value map of parameters that match the declared parameters in the change template document.
     */
    public Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The name of the change request associated with the runbook workflow to be run.
     * </p>
     * 
     * @return The name of the change request associated with the runbook workflow to be run.
     */
    public String changeRequestName() {
        return changeRequestName;
    }

    /**
     * <p>
     * The user-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and
     * can't be reused.
     * </p>
     * 
     * @return The user-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID
     *         format, and can't be reused.
     */
    public String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the Runbooks property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasRunbooks() {
        return runbooks != null && !(runbooks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the Automation runbooks (Automation documents) that are run during the runbook workflow.
     * </p>
     * <note>
     * <p>
     * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the change
     * request have been received.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRunbooks()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the Automation runbooks (Automation documents) that are run during the runbook
     *         workflow.</p> <note>
     *         <p>
     *         The Automation runbooks specified for the runbook workflow can't run until all required approvals for the
     *         change request have been received.
     *         </p>
     */
    public List<Runbook> runbooks() {
        return runbooks;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. You can specify a maximum of five tags for a change request.
     * Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For
     * example, you might want to tag a change request to identify an environment or target AWS Region. In this case,
     * you could specify the following key-value pairs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=Environment,Value=Production</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Region,Value=us-east-2</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional metadata that you assign to a resource. You can specify a maximum of five tags for a change
     *         request. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or
     *         environment. For example, you might want to tag a change request to identify an environment or target AWS
     *         Region. In this case, you could specify the following key-value pairs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Key=Environment,Value=Production</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Key=Region,Value=us-east-2</code>
     *         </p>
     *         </li>
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduledTime());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(changeRequestName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRunbooks() ? runbooks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartChangeRequestExecutionRequest)) {
            return false;
        }
        StartChangeRequestExecutionRequest other = (StartChangeRequestExecutionRequest) obj;
        return Objects.equals(scheduledTime(), other.scheduledTime()) && Objects.equals(documentName(), other.documentName())
                && Objects.equals(documentVersion(), other.documentVersion()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(changeRequestName(), other.changeRequestName())
                && Objects.equals(clientToken(), other.clientToken()) && hasRunbooks() == other.hasRunbooks()
                && Objects.equals(runbooks(), other.runbooks()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartChangeRequestExecutionRequest").add("ScheduledTime", scheduledTime())
                .add("DocumentName", documentName()).add("DocumentVersion", documentVersion())
                .add("Parameters", hasParameters() ? parameters() : null).add("ChangeRequestName", changeRequestName())
                .add("ClientToken", clientToken()).add("Runbooks", hasRunbooks() ? runbooks() : null)
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledTime":
            return Optional.ofNullable(clazz.cast(scheduledTime()));
        case "DocumentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ChangeRequestName":
            return Optional.ofNullable(clazz.cast(changeRequestName()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Runbooks":
            return Optional.ofNullable(clazz.cast(runbooks()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartChangeRequestExecutionRequest, T> g) {
        return obj -> g.apply((StartChangeRequestExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartChangeRequestExecutionRequest> {
        /**
         * <p>
         * The date and time specified in the change request to run the Automation runbooks.
         * </p>
         * <note>
         * <p>
         * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the
         * change request have been received.
         * </p>
         * </note>
         * 
         * @param scheduledTime
         *        The date and time specified in the change request to run the Automation runbooks.</p> <note>
         *        <p>
         *        The Automation runbooks specified for the runbook workflow can't run until all required approvals for
         *        the change request have been received.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledTime(Instant scheduledTime);

        /**
         * <p>
         * The name of the change template document to run during the runbook workflow.
         * </p>
         * 
         * @param documentName
         *        The name of the change template document to run during the runbook workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The version of the change template document to run during the runbook workflow.
         * </p>
         * 
         * @param documentVersion
         *        The version of the change template document to run during the runbook workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * A key-value map of parameters that match the declared parameters in the change template document.
         * </p>
         * 
         * @param parameters
         *        A key-value map of parameters that match the declared parameters in the change template document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * The name of the change request associated with the runbook workflow to be run.
         * </p>
         * 
         * @param changeRequestName
         *        The name of the change request associated with the runbook workflow to be run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeRequestName(String changeRequestName);

        /**
         * <p>
         * The user-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format,
         * and can't be reused.
         * </p>
         * 
         * @param clientToken
         *        The user-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID
         *        format, and can't be reused.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Information about the Automation runbooks (Automation documents) that are run during the runbook workflow.
         * </p>
         * <note>
         * <p>
         * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the
         * change request have been received.
         * </p>
         * </note>
         * 
         * @param runbooks
         *        Information about the Automation runbooks (Automation documents) that are run during the runbook
         *        workflow.</p> <note>
         *        <p>
         *        The Automation runbooks specified for the runbook workflow can't run until all required approvals for
         *        the change request have been received.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runbooks(Collection<Runbook> runbooks);

        /**
         * <p>
         * Information about the Automation runbooks (Automation documents) that are run during the runbook workflow.
         * </p>
         * <note>
         * <p>
         * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the
         * change request have been received.
         * </p>
         * </note>
         * 
         * @param runbooks
         *        Information about the Automation runbooks (Automation documents) that are run during the runbook
         *        workflow.</p> <note>
         *        <p>
         *        The Automation runbooks specified for the runbook workflow can't run until all required approvals for
         *        the change request have been received.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runbooks(Runbook... runbooks);

        /**
         * <p>
         * Information about the Automation runbooks (Automation documents) that are run during the runbook workflow.
         * </p>
         * <note>
         * <p>
         * The Automation runbooks specified for the runbook workflow can't run until all required approvals for the
         * change request have been received.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Runbook>.Builder} avoiding the need
         * to create one manually via {@link List<Runbook>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Runbook>.Builder#build()} is called immediately and its
         * result is passed to {@link #runbooks(List<Runbook>)}.
         * 
         * @param runbooks
         *        a consumer that will call methods on {@link List<Runbook>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runbooks(List<Runbook>)
         */
        Builder runbooks(Consumer<Runbook.Builder>... runbooks);

        /**
         * <p>
         * Optional metadata that you assign to a resource. You can specify a maximum of five tags for a change request.
         * Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For
         * example, you might want to tag a change request to identify an environment or target AWS Region. In this
         * case, you could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=Environment,Value=Production</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=Region,Value=us-east-2</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. You can specify a maximum of five tags for a change
         *        request. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or
         *        environment. For example, you might want to tag a change request to identify an environment or target
         *        AWS Region. In this case, you could specify the following key-value pairs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key=Environment,Value=Production</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=Region,Value=us-east-2</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Optional metadata that you assign to a resource. You can specify a maximum of five tags for a change request.
         * Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For
         * example, you might want to tag a change request to identify an environment or target AWS Region. In this
         * case, you could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=Environment,Value=Production</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=Region,Value=us-east-2</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. You can specify a maximum of five tags for a change
         *        request. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or
         *        environment. For example, you might want to tag a change request to identify an environment or target
         *        AWS Region. In this case, you could specify the following key-value pairs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key=Environment,Value=Production</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=Region,Value=us-east-2</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Optional metadata that you assign to a resource. You can specify a maximum of five tags for a change request.
         * Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For
         * example, you might want to tag a change request to identify an environment or target AWS Region. In this
         * case, you could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=Environment,Value=Production</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=Region,Value=us-east-2</code>
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private Instant scheduledTime;

        private String documentName;

        private String documentVersion;

        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String changeRequestName;

        private String clientToken;

        private List<Runbook> runbooks = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartChangeRequestExecutionRequest model) {
            super(model);
            scheduledTime(model.scheduledTime);
            documentName(model.documentName);
            documentVersion(model.documentVersion);
            parameters(model.parameters);
            changeRequestName(model.changeRequestName);
            clientToken(model.clientToken);
            runbooks(model.runbooks);
            tags(model.tags);
        }

        public final Instant getScheduledTime() {
            return scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public final void setScheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        public final String getDocumentName() {
            return documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        public final String getChangeRequestName() {
            return changeRequestName;
        }

        @Override
        public final Builder changeRequestName(String changeRequestName) {
            this.changeRequestName = changeRequestName;
            return this;
        }

        public final void setChangeRequestName(String changeRequestName) {
            this.changeRequestName = changeRequestName;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final Collection<Runbook.Builder> getRunbooks() {
            if (runbooks instanceof SdkAutoConstructList) {
                return null;
            }
            return runbooks != null ? runbooks.stream().map(Runbook::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder runbooks(Collection<Runbook> runbooks) {
            this.runbooks = RunbooksCopier.copy(runbooks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runbooks(Runbook... runbooks) {
            runbooks(Arrays.asList(runbooks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder runbooks(Consumer<Runbook.Builder>... runbooks) {
            runbooks(Stream.of(runbooks).map(c -> Runbook.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRunbooks(Collection<Runbook.BuilderImpl> runbooks) {
            this.runbooks = RunbooksCopier.copyFromBuilder(runbooks);
        }

        public final Collection<Tag.Builder> getTags() {
            if (tags instanceof SdkAutoConstructList) {
                return null;
            }
            return tags != null ? tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartChangeRequestExecutionRequest build() {
            return new StartChangeRequestExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
