/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summary information about an OpsItem event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpsItemEventSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OpsItemEventSummary.Builder, OpsItemEventSummary> {
    private static final SdkField<String> OPS_ITEM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsItemId").getter(getter(OpsItemEventSummary::opsItemId)).setter(setter(Builder::opsItemId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsItemId").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EventId").getter(getter(OpsItemEventSummary::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(OpsItemEventSummary::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> DETAIL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DetailType").getter(getter(OpsItemEventSummary::detailType)).setter(setter(Builder::detailType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailType").build()).build();

    private static final SdkField<String> DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Detail")
            .getter(getter(OpsItemEventSummary::detail)).setter(setter(Builder::detail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Detail").build()).build();

    private static final SdkField<OpsItemIdentity> CREATED_BY_FIELD = SdkField
            .<OpsItemIdentity> builder(MarshallingType.SDK_POJO).memberName("CreatedBy")
            .getter(getter(OpsItemEventSummary::createdBy)).setter(setter(Builder::createdBy))
            .constructor(OpsItemIdentity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(OpsItemEventSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_ITEM_ID_FIELD,
            EVENT_ID_FIELD, SOURCE_FIELD, DETAIL_TYPE_FIELD, DETAIL_FIELD, CREATED_BY_FIELD, CREATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String opsItemId;

    private final String eventId;

    private final String source;

    private final String detailType;

    private final String detail;

    private final OpsItemIdentity createdBy;

    private final Instant createdTime;

    private OpsItemEventSummary(BuilderImpl builder) {
        this.opsItemId = builder.opsItemId;
        this.eventId = builder.eventId;
        this.source = builder.source;
        this.detailType = builder.detailType;
        this.detail = builder.detail;
        this.createdBy = builder.createdBy;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * The ID of the OpsItem.
     * </p>
     * 
     * @return The ID of the OpsItem.
     */
    public String opsItemId() {
        return opsItemId;
    }

    /**
     * <p>
     * The ID of the OpsItem event.
     * </p>
     * 
     * @return The ID of the OpsItem event.
     */
    public String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The source of the OpsItem event.
     * </p>
     * 
     * @return The source of the OpsItem event.
     */
    public String source() {
        return source;
    }

    /**
     * <p>
     * The type of information provided as a detail.
     * </p>
     * 
     * @return The type of information provided as a detail.
     */
    public String detailType() {
        return detailType;
    }

    /**
     * <p>
     * Specific information about the OpsItem event.
     * </p>
     * 
     * @return Specific information about the OpsItem event.
     */
    public String detail() {
        return detail;
    }

    /**
     * <p>
     * Information about the user or resource that created the OpsItem event.
     * </p>
     * 
     * @return Information about the user or resource that created the OpsItem event.
     */
    public OpsItemIdentity createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the OpsItem event was created.
     * </p>
     * 
     * @return The date and time the OpsItem event was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(opsItemId());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(detailType());
        hashCode = 31 * hashCode + Objects.hashCode(detail());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpsItemEventSummary)) {
            return false;
        }
        OpsItemEventSummary other = (OpsItemEventSummary) obj;
        return Objects.equals(opsItemId(), other.opsItemId()) && Objects.equals(eventId(), other.eventId())
                && Objects.equals(source(), other.source()) && Objects.equals(detailType(), other.detailType())
                && Objects.equals(detail(), other.detail()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("OpsItemEventSummary").add("OpsItemId", opsItemId()).add("EventId", eventId())
                .add("Source", source()).add("DetailType", detailType()).add("Detail", detail()).add("CreatedBy", createdBy())
                .add("CreatedTime", createdTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpsItemId":
            return Optional.ofNullable(clazz.cast(opsItemId()));
        case "EventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "DetailType":
            return Optional.ofNullable(clazz.cast(detailType()));
        case "Detail":
            return Optional.ofNullable(clazz.cast(detail()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpsItemEventSummary, T> g) {
        return obj -> g.apply((OpsItemEventSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpsItemEventSummary> {
        /**
         * <p>
         * The ID of the OpsItem.
         * </p>
         * 
         * @param opsItemId
         *        The ID of the OpsItem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsItemId(String opsItemId);

        /**
         * <p>
         * The ID of the OpsItem event.
         * </p>
         * 
         * @param eventId
         *        The ID of the OpsItem event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The source of the OpsItem event.
         * </p>
         * 
         * @param source
         *        The source of the OpsItem event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The type of information provided as a detail.
         * </p>
         * 
         * @param detailType
         *        The type of information provided as a detail.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detailType(String detailType);

        /**
         * <p>
         * Specific information about the OpsItem event.
         * </p>
         * 
         * @param detail
         *        Specific information about the OpsItem event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder detail(String detail);

        /**
         * <p>
         * Information about the user or resource that created the OpsItem event.
         * </p>
         * 
         * @param createdBy
         *        Information about the user or resource that created the OpsItem event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(OpsItemIdentity createdBy);

        /**
         * <p>
         * Information about the user or resource that created the OpsItem event.
         * </p>
         * This is a convenience that creates an instance of the {@link OpsItemIdentity.Builder} avoiding the need to
         * create one manually via {@link OpsItemIdentity#builder()}.
         *
         * When the {@link Consumer} completes, {@link OpsItemIdentity.Builder#build()} is called immediately and its
         * result is passed to {@link #createdBy(OpsItemIdentity)}.
         * 
         * @param createdBy
         *        a consumer that will call methods on {@link OpsItemIdentity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdBy(OpsItemIdentity)
         */
        default Builder createdBy(Consumer<OpsItemIdentity.Builder> createdBy) {
            return createdBy(OpsItemIdentity.builder().applyMutation(createdBy).build());
        }

        /**
         * <p>
         * The date and time the OpsItem event was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time the OpsItem event was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);
    }

    static final class BuilderImpl implements Builder {
        private String opsItemId;

        private String eventId;

        private String source;

        private String detailType;

        private String detail;

        private OpsItemIdentity createdBy;

        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(OpsItemEventSummary model) {
            opsItemId(model.opsItemId);
            eventId(model.eventId);
            source(model.source);
            detailType(model.detailType);
            detail(model.detail);
            createdBy(model.createdBy);
            createdTime(model.createdTime);
        }

        public final String getOpsItemId() {
            return opsItemId;
        }

        @Override
        public final Builder opsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
            return this;
        }

        public final void setOpsItemId(String opsItemId) {
            this.opsItemId = opsItemId;
        }

        public final String getEventId() {
            return eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        public final String getSource() {
            return source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        public final String getDetailType() {
            return detailType;
        }

        @Override
        public final Builder detailType(String detailType) {
            this.detailType = detailType;
            return this;
        }

        public final void setDetailType(String detailType) {
            this.detailType = detailType;
        }

        public final String getDetail() {
            return detail;
        }

        @Override
        public final Builder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public final void setDetail(String detail) {
            this.detail = detail;
        }

        public final OpsItemIdentity.Builder getCreatedBy() {
            return createdBy != null ? createdBy.toBuilder() : null;
        }

        @Override
        public final Builder createdBy(OpsItemIdentity createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final void setCreatedBy(OpsItemIdentity.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public OpsItemEventSummary build() {
            return new OpsItemEventSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
