/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAutomationExecutionResponse extends SsmResponse implements
        ToCopyableBuilder<GetAutomationExecutionResponse.Builder, GetAutomationExecutionResponse> {
    private static final SdkField<AutomationExecution> AUTOMATION_EXECUTION_FIELD = SdkField
            .<AutomationExecution> builder(MarshallingType.SDK_POJO).memberName("AutomationExecution")
            .getter(getter(GetAutomationExecutionResponse::automationExecution)).setter(setter(Builder::automationExecution))
            .constructor(AutomationExecution::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationExecution").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTOMATION_EXECUTION_FIELD));

    private final AutomationExecution automationExecution;

    private GetAutomationExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.automationExecution = builder.automationExecution;
    }

    /**
     * <p>
     * Detailed information about the current state of an automation execution.
     * </p>
     * 
     * @return Detailed information about the current state of an automation execution.
     */
    public final AutomationExecution automationExecution() {
        return automationExecution;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(automationExecution());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutomationExecutionResponse)) {
            return false;
        }
        GetAutomationExecutionResponse other = (GetAutomationExecutionResponse) obj;
        return Objects.equals(automationExecution(), other.automationExecution());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAutomationExecutionResponse").add("AutomationExecution", automationExecution()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AutomationExecution":
            return Optional.ofNullable(clazz.cast(automationExecution()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAutomationExecutionResponse, T> g) {
        return obj -> g.apply((GetAutomationExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetAutomationExecutionResponse> {
        /**
         * <p>
         * Detailed information about the current state of an automation execution.
         * </p>
         * 
         * @param automationExecution
         *        Detailed information about the current state of an automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationExecution(AutomationExecution automationExecution);

        /**
         * <p>
         * Detailed information about the current state of an automation execution.
         * </p>
         * This is a convenience that creates an instance of the {@link AutomationExecution.Builder} avoiding the need
         * to create one manually via {@link AutomationExecution#builder()}.
         *
         * When the {@link Consumer} completes, {@link AutomationExecution.Builder#build()} is called immediately and
         * its result is passed to {@link #automationExecution(AutomationExecution)}.
         * 
         * @param automationExecution
         *        a consumer that will call methods on {@link AutomationExecution.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #automationExecution(AutomationExecution)
         */
        default Builder automationExecution(Consumer<AutomationExecution.Builder> automationExecution) {
            return automationExecution(AutomationExecution.builder().applyMutation(automationExecution).build());
        }
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private AutomationExecution automationExecution;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutomationExecutionResponse model) {
            super(model);
            automationExecution(model.automationExecution);
        }

        public final AutomationExecution.Builder getAutomationExecution() {
            return automationExecution != null ? automationExecution.toBuilder() : null;
        }

        @Override
        public final Builder automationExecution(AutomationExecution automationExecution) {
            this.automationExecution = automationExecution;
            return this;
        }

        public final void setAutomationExecution(AutomationExecution.BuilderImpl automationExecution) {
            this.automationExecution = automationExecution != null ? automationExecution.build() : null;
        }

        @Override
        public GetAutomationExecutionResponse build() {
            return new GetAutomationExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
