/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMaintenanceWindowRequest extends SsmRequest implements
        ToCopyableBuilder<CreateMaintenanceWindowRequest.Builder, CreateMaintenanceWindowRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateMaintenanceWindowRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreateMaintenanceWindowRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> START_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StartDate").getter(getter(CreateMaintenanceWindowRequest::startDate)).setter(setter(Builder::startDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartDate").build()).build();

    private static final SdkField<String> END_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EndDate").getter(getter(CreateMaintenanceWindowRequest::endDate)).setter(setter(Builder::endDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndDate").build()).build();

    private static final SdkField<String> SCHEDULE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Schedule").getter(getter(CreateMaintenanceWindowRequest::schedule)).setter(setter(Builder::schedule))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()).build();

    private static final SdkField<String> SCHEDULE_TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleTimezone").getter(getter(CreateMaintenanceWindowRequest::scheduleTimezone))
            .setter(setter(Builder::scheduleTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleTimezone").build()).build();

    private static final SdkField<Integer> SCHEDULE_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ScheduleOffset").getter(getter(CreateMaintenanceWindowRequest::scheduleOffset))
            .setter(setter(Builder::scheduleOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleOffset").build()).build();

    private static final SdkField<Integer> DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Duration").getter(getter(CreateMaintenanceWindowRequest::duration)).setter(setter(Builder::duration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Duration").build()).build();

    private static final SdkField<Integer> CUTOFF_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Cutoff").getter(getter(CreateMaintenanceWindowRequest::cutoff)).setter(setter(Builder::cutoff))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cutoff").build()).build();

    private static final SdkField<Boolean> ALLOW_UNASSOCIATED_TARGETS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AllowUnassociatedTargets").getter(getter(CreateMaintenanceWindowRequest::allowUnassociatedTargets))
            .setter(setter(Builder::allowUnassociatedTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowUnassociatedTargets").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreateMaintenanceWindowRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateMaintenanceWindowRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            START_DATE_FIELD, END_DATE_FIELD, SCHEDULE_FIELD, SCHEDULE_TIMEZONE_FIELD, SCHEDULE_OFFSET_FIELD, DURATION_FIELD,
            CUTOFF_FIELD, ALLOW_UNASSOCIATED_TARGETS_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String name;

    private final String description;

    private final String startDate;

    private final String endDate;

    private final String schedule;

    private final String scheduleTimezone;

    private final Integer scheduleOffset;

    private final Integer duration;

    private final Integer cutoff;

    private final Boolean allowUnassociatedTargets;

    private final String clientToken;

    private final List<Tag> tags;

    private CreateMaintenanceWindowRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.schedule = builder.schedule;
        this.scheduleTimezone = builder.scheduleTimezone;
        this.scheduleOffset = builder.scheduleOffset;
        this.duration = builder.duration;
        this.cutoff = builder.cutoff;
        this.allowUnassociatedTargets = builder.allowUnassociatedTargets;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the maintenance window.
     * </p>
     * 
     * @return The name of the maintenance window.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional description for the maintenance window. We recommend specifying a description to help you organize
     * your maintenance windows.
     * </p>
     * 
     * @return An optional description for the maintenance window. We recommend specifying a description to help you
     *         organize your maintenance windows.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become active.
     * <code>StartDate</code> allows you to delay activation of the maintenance window until the specified future date.
     * </p>
     * 
     * @return The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become
     *         active. <code>StartDate</code> allows you to delay activation of the maintenance window until the
     *         specified future date.
     */
    public final String startDate() {
        return startDate;
    }

    /**
     * <p>
     * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive.
     * <code>EndDate</code> allows you to set a date and time in the future when the maintenance window will no longer
     * run.
     * </p>
     * 
     * @return The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become
     *         inactive. <code>EndDate</code> allows you to set a date and time in the future when the maintenance
     *         window will no longer run.
     */
    public final String endDate() {
        return endDate;
    }

    /**
     * <p>
     * The schedule of the maintenance window in the form of a cron or rate expression.
     * </p>
     * 
     * @return The schedule of the maintenance window in the form of a cron or rate expression.
     */
    public final String schedule() {
        return schedule;
    }

    /**
     * <p>
     * The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers
     * Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information, see
     * the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
     * </p>
     * 
     * @return The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers
     *         Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more
     *         information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA
     *         website.
     */
    public final String scheduleTimezone() {
        return scheduleTimezone;
    }

    /**
     * <p>
     * The number of days to wait after the date and time specified by a cron expression before running the maintenance
     * window.
     * </p>
     * <p>
     * For example, the following cron expression schedules a maintenance window to run on the third Tuesday of every
     * month at 11:30 PM.
     * </p>
     * <p>
     * <code>cron(30 23 ? * TUE#3 *)</code>
     * </p>
     * <p>
     * If the schedule offset is <code>2</code>, the maintenance window won't run until two days later.
     * </p>
     * 
     * @return The number of days to wait after the date and time specified by a cron expression before running the
     *         maintenance window.</p>
     *         <p>
     *         For example, the following cron expression schedules a maintenance window to run on the third Tuesday of
     *         every month at 11:30 PM.
     *         </p>
     *         <p>
     *         <code>cron(30 23 ? * TUE#3 *)</code>
     *         </p>
     *         <p>
     *         If the schedule offset is <code>2</code>, the maintenance window won't run until two days later.
     */
    public final Integer scheduleOffset() {
        return scheduleOffset;
    }

    /**
     * <p>
     * The duration of the maintenance window in hours.
     * </p>
     * 
     * @return The duration of the maintenance window in hours.
     */
    public final Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops
     * scheduling new tasks for execution.
     * </p>
     * 
     * @return The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager
     *         stops scheduling new tasks for execution.
     */
    public final Integer cutoff() {
        return cutoff;
    }

    /**
     * <p>
     * Enables a maintenance window task to run on managed instances, even if you haven't registered those instances as
     * targets. If enabled, then you must specify the unregistered instances (by instance ID) when you register a task
     * with the maintenance window.
     * </p>
     * <p>
     * If you don't enable this option, then you must specify previously-registered targets when you register a task
     * with the maintenance window.
     * </p>
     * 
     * @return Enables a maintenance window task to run on managed instances, even if you haven't registered those
     *         instances as targets. If enabled, then you must specify the unregistered instances (by instance ID) when
     *         you register a task with the maintenance window.</p>
     *         <p>
     *         If you don't enable this option, then you must specify previously-registered targets when you register a
     *         task with the maintenance window.
     */
    public final Boolean allowUnassociatedTargets() {
        return allowUnassociatedTargets;
    }

    /**
     * <p>
     * User-provided idempotency token.
     * </p>
     * 
     * @return User-provided idempotency token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such
     * as by purpose, owner, or environment. For example, you might want to tag a maintenance window to identify the
     * type of tasks it will run, the types of targets, and the environment it will run in. In this case, you could
     * specify the following key-value pairs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=TaskType,Value=AgentUpdate</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=OS,Value=Windows</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Environment,Value=Production</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * To add tags to an existing maintenance window, use the <a>AddTagsToResource</a> operation.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
     *         ways, such as by purpose, owner, or environment. For example, you might want to tag a maintenance window
     *         to identify the type of tasks it will run, the types of targets, and the environment it will run in. In
     *         this case, you could specify the following key-value pairs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Key=TaskType,Value=AgentUpdate</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Key=OS,Value=Windows</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Key=Environment,Value=Production</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         To add tags to an existing maintenance window, use the <a>AddTagsToResource</a> operation.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(startDate());
        hashCode = 31 * hashCode + Objects.hashCode(endDate());
        hashCode = 31 * hashCode + Objects.hashCode(schedule());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleTimezone());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleOffset());
        hashCode = 31 * hashCode + Objects.hashCode(duration());
        hashCode = 31 * hashCode + Objects.hashCode(cutoff());
        hashCode = 31 * hashCode + Objects.hashCode(allowUnassociatedTargets());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMaintenanceWindowRequest)) {
            return false;
        }
        CreateMaintenanceWindowRequest other = (CreateMaintenanceWindowRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(startDate(), other.startDate()) && Objects.equals(endDate(), other.endDate())
                && Objects.equals(schedule(), other.schedule()) && Objects.equals(scheduleTimezone(), other.scheduleTimezone())
                && Objects.equals(scheduleOffset(), other.scheduleOffset()) && Objects.equals(duration(), other.duration())
                && Objects.equals(cutoff(), other.cutoff())
                && Objects.equals(allowUnassociatedTargets(), other.allowUnassociatedTargets())
                && Objects.equals(clientToken(), other.clientToken()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMaintenanceWindowRequest").add("Name", name())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StartDate", startDate()).add("EndDate", endDate()).add("Schedule", schedule())
                .add("ScheduleTimezone", scheduleTimezone()).add("ScheduleOffset", scheduleOffset()).add("Duration", duration())
                .add("Cutoff", cutoff()).add("AllowUnassociatedTargets", allowUnassociatedTargets())
                .add("ClientToken", clientToken()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "StartDate":
            return Optional.ofNullable(clazz.cast(startDate()));
        case "EndDate":
            return Optional.ofNullable(clazz.cast(endDate()));
        case "Schedule":
            return Optional.ofNullable(clazz.cast(schedule()));
        case "ScheduleTimezone":
            return Optional.ofNullable(clazz.cast(scheduleTimezone()));
        case "ScheduleOffset":
            return Optional.ofNullable(clazz.cast(scheduleOffset()));
        case "Duration":
            return Optional.ofNullable(clazz.cast(duration()));
        case "Cutoff":
            return Optional.ofNullable(clazz.cast(cutoff()));
        case "AllowUnassociatedTargets":
            return Optional.ofNullable(clazz.cast(allowUnassociatedTargets()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateMaintenanceWindowRequest, T> g) {
        return obj -> g.apply((CreateMaintenanceWindowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMaintenanceWindowRequest> {
        /**
         * <p>
         * The name of the maintenance window.
         * </p>
         * 
         * @param name
         *        The name of the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description for the maintenance window. We recommend specifying a description to help you
         * organize your maintenance windows.
         * </p>
         * 
         * @param description
         *        An optional description for the maintenance window. We recommend specifying a description to help you
         *        organize your maintenance windows.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become active.
         * <code>StartDate</code> allows you to delay activation of the maintenance window until the specified future
         * date.
         * </p>
         * 
         * @param startDate
         *        The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become
         *        active. <code>StartDate</code> allows you to delay activation of the maintenance window until the
         *        specified future date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startDate(String startDate);

        /**
         * <p>
         * The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become inactive.
         * <code>EndDate</code> allows you to set a date and time in the future when the maintenance window will no
         * longer run.
         * </p>
         * 
         * @param endDate
         *        The date and time, in ISO-8601 Extended format, for when you want the maintenance window to become
         *        inactive. <code>EndDate</code> allows you to set a date and time in the future when the maintenance
         *        window will no longer run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endDate(String endDate);

        /**
         * <p>
         * The schedule of the maintenance window in the form of a cron or rate expression.
         * </p>
         * 
         * @param schedule
         *        The schedule of the maintenance window in the form of a cron or rate expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedule(String schedule);

        /**
         * <p>
         * The time zone that the scheduled maintenance window executions are based on, in Internet Assigned Numbers
         * Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more information,
         * see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA website.
         * </p>
         * 
         * @param scheduleTimezone
         *        The time zone that the scheduled maintenance window executions are based on, in Internet Assigned
         *        Numbers Authority (IANA) format. For example: "America/Los_Angeles", "UTC", or "Asia/Seoul". For more
         *        information, see the <a href="https://www.iana.org/time-zones">Time Zone Database</a> on the IANA
         *        website.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleTimezone(String scheduleTimezone);

        /**
         * <p>
         * The number of days to wait after the date and time specified by a cron expression before running the
         * maintenance window.
         * </p>
         * <p>
         * For example, the following cron expression schedules a maintenance window to run on the third Tuesday of
         * every month at 11:30 PM.
         * </p>
         * <p>
         * <code>cron(30 23 ? * TUE#3 *)</code>
         * </p>
         * <p>
         * If the schedule offset is <code>2</code>, the maintenance window won't run until two days later.
         * </p>
         * 
         * @param scheduleOffset
         *        The number of days to wait after the date and time specified by a cron expression before running the
         *        maintenance window.</p>
         *        <p>
         *        For example, the following cron expression schedules a maintenance window to run on the third Tuesday
         *        of every month at 11:30 PM.
         *        </p>
         *        <p>
         *        <code>cron(30 23 ? * TUE#3 *)</code>
         *        </p>
         *        <p>
         *        If the schedule offset is <code>2</code>, the maintenance window won't run until two days later.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleOffset(Integer scheduleOffset);

        /**
         * <p>
         * The duration of the maintenance window in hours.
         * </p>
         * 
         * @param duration
         *        The duration of the maintenance window in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager stops
         * scheduling new tasks for execution.
         * </p>
         * 
         * @param cutoff
         *        The number of hours before the end of the maintenance window that Amazon Web Services Systems Manager
         *        stops scheduling new tasks for execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cutoff(Integer cutoff);

        /**
         * <p>
         * Enables a maintenance window task to run on managed instances, even if you haven't registered those instances
         * as targets. If enabled, then you must specify the unregistered instances (by instance ID) when you register a
         * task with the maintenance window.
         * </p>
         * <p>
         * If you don't enable this option, then you must specify previously-registered targets when you register a task
         * with the maintenance window.
         * </p>
         * 
         * @param allowUnassociatedTargets
         *        Enables a maintenance window task to run on managed instances, even if you haven't registered those
         *        instances as targets. If enabled, then you must specify the unregistered instances (by instance ID)
         *        when you register a task with the maintenance window.</p>
         *        <p>
         *        If you don't enable this option, then you must specify previously-registered targets when you register
         *        a task with the maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets);

        /**
         * <p>
         * User-provided idempotency token.
         * </p>
         * 
         * @param clientToken
         *        User-provided idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways,
         * such as by purpose, owner, or environment. For example, you might want to tag a maintenance window to
         * identify the type of tasks it will run, the types of targets, and the environment it will run in. In this
         * case, you could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=TaskType,Value=AgentUpdate</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=Environment,Value=Production</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * To add tags to an existing maintenance window, use the <a>AddTagsToResource</a> operation.
         * </p>
         * </note>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
         *        ways, such as by purpose, owner, or environment. For example, you might want to tag a maintenance
         *        window to identify the type of tasks it will run, the types of targets, and the environment it will
         *        run in. In this case, you could specify the following key-value pairs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key=TaskType,Value=AgentUpdate</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=OS,Value=Windows</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=Environment,Value=Production</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        To add tags to an existing maintenance window, use the <a>AddTagsToResource</a> operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways,
         * such as by purpose, owner, or environment. For example, you might want to tag a maintenance window to
         * identify the type of tasks it will run, the types of targets, and the environment it will run in. In this
         * case, you could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=TaskType,Value=AgentUpdate</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=Environment,Value=Production</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * To add tags to an existing maintenance window, use the <a>AddTagsToResource</a> operation.
         * </p>
         * </note>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
         *        ways, such as by purpose, owner, or environment. For example, you might want to tag a maintenance
         *        window to identify the type of tasks it will run, the types of targets, and the environment it will
         *        run in. In this case, you could specify the following key-value pairs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key=TaskType,Value=AgentUpdate</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=OS,Value=Windows</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=Environment,Value=Production</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        To add tags to an existing maintenance window, use the <a>AddTagsToResource</a> operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways,
         * such as by purpose, owner, or environment. For example, you might want to tag a maintenance window to
         * identify the type of tasks it will run, the types of targets, and the environment it will run in. In this
         * case, you could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=TaskType,Value=AgentUpdate</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=Environment,Value=Production</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * To add tags to an existing maintenance window, use the <a>AddTagsToResource</a> operation.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to
         * create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private String startDate;

        private String endDate;

        private String schedule;

        private String scheduleTimezone;

        private Integer scheduleOffset;

        private Integer duration;

        private Integer cutoff;

        private Boolean allowUnassociatedTargets;

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMaintenanceWindowRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            startDate(model.startDate);
            endDate(model.endDate);
            schedule(model.schedule);
            scheduleTimezone(model.scheduleTimezone);
            scheduleOffset(model.scheduleOffset);
            duration(model.duration);
            cutoff(model.cutoff);
            allowUnassociatedTargets(model.allowUnassociatedTargets);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStartDate() {
            return startDate;
        }

        @Override
        public final Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(String startDate) {
            this.startDate = startDate;
        }

        public final String getEndDate() {
            return endDate;
        }

        @Override
        public final Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(String endDate) {
            this.endDate = endDate;
        }

        public final String getSchedule() {
            return schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final String getScheduleTimezone() {
            return scheduleTimezone;
        }

        @Override
        public final Builder scheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
            return this;
        }

        public final void setScheduleTimezone(String scheduleTimezone) {
            this.scheduleTimezone = scheduleTimezone;
        }

        public final Integer getScheduleOffset() {
            return scheduleOffset;
        }

        @Override
        public final Builder scheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
            return this;
        }

        public final void setScheduleOffset(Integer scheduleOffset) {
            this.scheduleOffset = scheduleOffset;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final Integer getCutoff() {
            return cutoff;
        }

        @Override
        public final Builder cutoff(Integer cutoff) {
            this.cutoff = cutoff;
            return this;
        }

        public final void setCutoff(Integer cutoff) {
            this.cutoff = cutoff;
        }

        public final Boolean getAllowUnassociatedTargets() {
            return allowUnassociatedTargets;
        }

        @Override
        public final Builder allowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
            return this;
        }

        public final void setAllowUnassociatedTargets(Boolean allowUnassociatedTargets) {
            this.allowUnassociatedTargets = allowUnassociatedTargets;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMaintenanceWindowRequest build() {
            return new CreateMaintenanceWindowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
