/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An aggregate of step execution statuses displayed in the Amazon Web Services Systems Manager console for a
 * multi-Region and multi-account Automation execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProgressCounters implements SdkPojo, Serializable,
        ToCopyableBuilder<ProgressCounters.Builder, ProgressCounters> {
    private static final SdkField<Integer> TOTAL_STEPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalSteps").getter(getter(ProgressCounters::totalSteps)).setter(setter(Builder::totalSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalSteps").build()).build();

    private static final SdkField<Integer> SUCCESS_STEPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("SuccessSteps").getter(getter(ProgressCounters::successSteps)).setter(setter(Builder::successSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessSteps").build()).build();

    private static final SdkField<Integer> FAILED_STEPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("FailedSteps").getter(getter(ProgressCounters::failedSteps)).setter(setter(Builder::failedSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedSteps").build()).build();

    private static final SdkField<Integer> CANCELLED_STEPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("CancelledSteps").getter(getter(ProgressCounters::cancelledSteps))
            .setter(setter(Builder::cancelledSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CancelledSteps").build()).build();

    private static final SdkField<Integer> TIMED_OUT_STEPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TimedOutSteps").getter(getter(ProgressCounters::timedOutSteps)).setter(setter(Builder::timedOutSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimedOutSteps").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_STEPS_FIELD,
            SUCCESS_STEPS_FIELD, FAILED_STEPS_FIELD, CANCELLED_STEPS_FIELD, TIMED_OUT_STEPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer totalSteps;

    private final Integer successSteps;

    private final Integer failedSteps;

    private final Integer cancelledSteps;

    private final Integer timedOutSteps;

    private ProgressCounters(BuilderImpl builder) {
        this.totalSteps = builder.totalSteps;
        this.successSteps = builder.successSteps;
        this.failedSteps = builder.failedSteps;
        this.cancelledSteps = builder.cancelledSteps;
        this.timedOutSteps = builder.timedOutSteps;
    }

    /**
     * <p>
     * The total number of steps run in all specified Regions and accounts for the current Automation execution.
     * </p>
     * 
     * @return The total number of steps run in all specified Regions and accounts for the current Automation execution.
     */
    public final Integer totalSteps() {
        return totalSteps;
    }

    /**
     * <p>
     * The total number of steps that successfully completed in all specified Regions and accounts for the current
     * Automation execution.
     * </p>
     * 
     * @return The total number of steps that successfully completed in all specified Regions and accounts for the
     *         current Automation execution.
     */
    public final Integer successSteps() {
        return successSteps;
    }

    /**
     * <p>
     * The total number of steps that failed to run in all specified Regions and accounts for the current Automation
     * execution.
     * </p>
     * 
     * @return The total number of steps that failed to run in all specified Regions and accounts for the current
     *         Automation execution.
     */
    public final Integer failedSteps() {
        return failedSteps;
    }

    /**
     * <p>
     * The total number of steps that the system cancelled in all specified Regions and accounts for the current
     * Automation execution.
     * </p>
     * 
     * @return The total number of steps that the system cancelled in all specified Regions and accounts for the current
     *         Automation execution.
     */
    public final Integer cancelledSteps() {
        return cancelledSteps;
    }

    /**
     * <p>
     * The total number of steps that timed out in all specified Regions and accounts for the current Automation
     * execution.
     * </p>
     * 
     * @return The total number of steps that timed out in all specified Regions and accounts for the current Automation
     *         execution.
     */
    public final Integer timedOutSteps() {
        return timedOutSteps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalSteps());
        hashCode = 31 * hashCode + Objects.hashCode(successSteps());
        hashCode = 31 * hashCode + Objects.hashCode(failedSteps());
        hashCode = 31 * hashCode + Objects.hashCode(cancelledSteps());
        hashCode = 31 * hashCode + Objects.hashCode(timedOutSteps());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProgressCounters)) {
            return false;
        }
        ProgressCounters other = (ProgressCounters) obj;
        return Objects.equals(totalSteps(), other.totalSteps()) && Objects.equals(successSteps(), other.successSteps())
                && Objects.equals(failedSteps(), other.failedSteps()) && Objects.equals(cancelledSteps(), other.cancelledSteps())
                && Objects.equals(timedOutSteps(), other.timedOutSteps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProgressCounters").add("TotalSteps", totalSteps()).add("SuccessSteps", successSteps())
                .add("FailedSteps", failedSteps()).add("CancelledSteps", cancelledSteps()).add("TimedOutSteps", timedOutSteps())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TotalSteps":
            return Optional.ofNullable(clazz.cast(totalSteps()));
        case "SuccessSteps":
            return Optional.ofNullable(clazz.cast(successSteps()));
        case "FailedSteps":
            return Optional.ofNullable(clazz.cast(failedSteps()));
        case "CancelledSteps":
            return Optional.ofNullable(clazz.cast(cancelledSteps()));
        case "TimedOutSteps":
            return Optional.ofNullable(clazz.cast(timedOutSteps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProgressCounters, T> g) {
        return obj -> g.apply((ProgressCounters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProgressCounters> {
        /**
         * <p>
         * The total number of steps run in all specified Regions and accounts for the current Automation execution.
         * </p>
         * 
         * @param totalSteps
         *        The total number of steps run in all specified Regions and accounts for the current Automation
         *        execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalSteps(Integer totalSteps);

        /**
         * <p>
         * The total number of steps that successfully completed in all specified Regions and accounts for the current
         * Automation execution.
         * </p>
         * 
         * @param successSteps
         *        The total number of steps that successfully completed in all specified Regions and accounts for the
         *        current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successSteps(Integer successSteps);

        /**
         * <p>
         * The total number of steps that failed to run in all specified Regions and accounts for the current Automation
         * execution.
         * </p>
         * 
         * @param failedSteps
         *        The total number of steps that failed to run in all specified Regions and accounts for the current
         *        Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failedSteps(Integer failedSteps);

        /**
         * <p>
         * The total number of steps that the system cancelled in all specified Regions and accounts for the current
         * Automation execution.
         * </p>
         * 
         * @param cancelledSteps
         *        The total number of steps that the system cancelled in all specified Regions and accounts for the
         *        current Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelledSteps(Integer cancelledSteps);

        /**
         * <p>
         * The total number of steps that timed out in all specified Regions and accounts for the current Automation
         * execution.
         * </p>
         * 
         * @param timedOutSteps
         *        The total number of steps that timed out in all specified Regions and accounts for the current
         *        Automation execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timedOutSteps(Integer timedOutSteps);
    }

    static final class BuilderImpl implements Builder {
        private Integer totalSteps;

        private Integer successSteps;

        private Integer failedSteps;

        private Integer cancelledSteps;

        private Integer timedOutSteps;

        private BuilderImpl() {
        }

        private BuilderImpl(ProgressCounters model) {
            totalSteps(model.totalSteps);
            successSteps(model.successSteps);
            failedSteps(model.failedSteps);
            cancelledSteps(model.cancelledSteps);
            timedOutSteps(model.timedOutSteps);
        }

        public final Integer getTotalSteps() {
            return totalSteps;
        }

        @Override
        public final Builder totalSteps(Integer totalSteps) {
            this.totalSteps = totalSteps;
            return this;
        }

        public final void setTotalSteps(Integer totalSteps) {
            this.totalSteps = totalSteps;
        }

        public final Integer getSuccessSteps() {
            return successSteps;
        }

        @Override
        public final Builder successSteps(Integer successSteps) {
            this.successSteps = successSteps;
            return this;
        }

        public final void setSuccessSteps(Integer successSteps) {
            this.successSteps = successSteps;
        }

        public final Integer getFailedSteps() {
            return failedSteps;
        }

        @Override
        public final Builder failedSteps(Integer failedSteps) {
            this.failedSteps = failedSteps;
            return this;
        }

        public final void setFailedSteps(Integer failedSteps) {
            this.failedSteps = failedSteps;
        }

        public final Integer getCancelledSteps() {
            return cancelledSteps;
        }

        @Override
        public final Builder cancelledSteps(Integer cancelledSteps) {
            this.cancelledSteps = cancelledSteps;
            return this;
        }

        public final void setCancelledSteps(Integer cancelledSteps) {
            this.cancelledSteps = cancelledSteps;
        }

        public final Integer getTimedOutSteps() {
            return timedOutSteps;
        }

        @Override
        public final Builder timedOutSteps(Integer timedOutSteps) {
            this.timedOutSteps = timedOutSteps;
            return this;
        }

        public final void setTimedOutSteps(Integer timedOutSteps) {
            this.timedOutSteps = timedOutSteps;
        }

        @Override
        public ProgressCounters build() {
            return new ProgressCounters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
