/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComplianceItemsResponse extends SsmResponse implements
        ToCopyableBuilder<ListComplianceItemsResponse.Builder, ListComplianceItemsResponse> {
    private static final SdkField<List<ComplianceItem>> COMPLIANCE_ITEMS_FIELD = SdkField
            .<List<ComplianceItem>> builder(MarshallingType.LIST)
            .memberName("ComplianceItems")
            .getter(getter(ListComplianceItemsResponse::complianceItems))
            .setter(setter(Builder::complianceItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceItems").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ComplianceItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ComplianceItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListComplianceItemsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLIANCE_ITEMS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ComplianceItem> complianceItems;

    private final String nextToken;

    private ListComplianceItemsResponse(BuilderImpl builder) {
        super(builder);
        this.complianceItems = builder.complianceItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ComplianceItems property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasComplianceItems() {
        return complianceItems != null && !(complianceItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of compliance information for the specified resource ID.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasComplianceItems()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of compliance information for the specified resource ID.
     */
    public final List<ComplianceItem> complianceItems() {
        return complianceItems;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasComplianceItems() ? complianceItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComplianceItemsResponse)) {
            return false;
        }
        ListComplianceItemsResponse other = (ListComplianceItemsResponse) obj;
        return hasComplianceItems() == other.hasComplianceItems() && Objects.equals(complianceItems(), other.complianceItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComplianceItemsResponse")
                .add("ComplianceItems", hasComplianceItems() ? complianceItems() : null).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ComplianceItems":
            return Optional.ofNullable(clazz.cast(complianceItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComplianceItemsResponse, T> g) {
        return obj -> g.apply((ListComplianceItemsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListComplianceItemsResponse> {
        /**
         * <p>
         * A list of compliance information for the specified resource ID.
         * </p>
         * 
         * @param complianceItems
         *        A list of compliance information for the specified resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceItems(Collection<ComplianceItem> complianceItems);

        /**
         * <p>
         * A list of compliance information for the specified resource ID.
         * </p>
         * 
         * @param complianceItems
         *        A list of compliance information for the specified resource ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder complianceItems(ComplianceItem... complianceItems);

        /**
         * <p>
         * A list of compliance information for the specified resource ID.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ComplianceItem>.Builder} avoiding the need
         * to create one manually via {@link List<ComplianceItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ComplianceItem>.Builder#build()} is called immediately and
         * its result is passed to {@link #complianceItems(List<ComplianceItem>)}.
         * 
         * @param complianceItems
         *        a consumer that will call methods on {@link List<ComplianceItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #complianceItems(List<ComplianceItem>)
         */
        Builder complianceItems(Consumer<ComplianceItem.Builder>... complianceItems);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<ComplianceItem> complianceItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComplianceItemsResponse model) {
            super(model);
            complianceItems(model.complianceItems);
            nextToken(model.nextToken);
        }

        public final Collection<ComplianceItem.Builder> getComplianceItems() {
            if (complianceItems instanceof SdkAutoConstructList) {
                return null;
            }
            return complianceItems != null ? complianceItems.stream().map(ComplianceItem::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder complianceItems(Collection<ComplianceItem> complianceItems) {
            this.complianceItems = ComplianceItemListCopier.copy(complianceItems);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceItems(ComplianceItem... complianceItems) {
            complianceItems(Arrays.asList(complianceItems));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder complianceItems(Consumer<ComplianceItem.Builder>... complianceItems) {
            complianceItems(Stream.of(complianceItems).map(c -> ComplianceItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setComplianceItems(Collection<ComplianceItem.BuilderImpl> complianceItems) {
            this.complianceItems = ComplianceItemListCopier.copyFromBuilder(complianceItems);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListComplianceItemsResponse build() {
            return new ListComplianceItemsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
