/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.ssm.model.AlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.AssociatedInstancesException;
import software.amazon.awssdk.services.ssm.model.AssociationAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.AssociationDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.AssociationExecutionDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.AssociationLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AssociationVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionNotApprovedException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionVersionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationStepNotFoundException;
import software.amazon.awssdk.services.ssm.model.CancelCommandRequest;
import software.amazon.awssdk.services.ssm.model.CancelCommandResponse;
import software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionRequest;
import software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionResponse;
import software.amazon.awssdk.services.ssm.model.ComplianceTypeCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.CreateActivationRequest;
import software.amazon.awssdk.services.ssm.model.CreateActivationResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.CreateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.CreateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.CreateOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.CreateOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.CreateOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.CustomSchemaCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DeleteActivationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteActivationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DeleteInventoryRequest;
import software.amazon.awssdk.services.ssm.model.DeleteInventoryResponse;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeleteOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.DeleteOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParameterRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParameterResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParametersRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParametersResponse;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeParametersRequest;
import software.amazon.awssdk.services.ssm.model.DescribeParametersResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse;
import software.amazon.awssdk.services.ssm.model.DocumentAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.DocumentLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DocumentPermissionLimitException;
import software.amazon.awssdk.services.ssm.model.DocumentVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DoesNotExistException;
import software.amazon.awssdk.services.ssm.model.DuplicateDocumentContentException;
import software.amazon.awssdk.services.ssm.model.DuplicateDocumentVersionNameException;
import software.amazon.awssdk.services.ssm.model.DuplicateInstanceIdException;
import software.amazon.awssdk.services.ssm.model.FeatureNotAvailableException;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetCalendarStateRequest;
import software.amazon.awssdk.services.ssm.model.GetCalendarStateResponse;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetConnectionStatusRequest;
import software.amazon.awssdk.services.ssm.model.GetConnectionStatusResponse;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse;
import software.amazon.awssdk.services.ssm.model.GetDocumentRequest;
import software.amazon.awssdk.services.ssm.model.GetDocumentResponse;
import software.amazon.awssdk.services.ssm.model.GetInventoryRequest;
import software.amazon.awssdk.services.ssm.model.GetInventoryResponse;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.GetServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.GetServiceSettingResponse;
import software.amazon.awssdk.services.ssm.model.HierarchyLevelLimitExceededException;
import software.amazon.awssdk.services.ssm.model.HierarchyTypeMismatchException;
import software.amazon.awssdk.services.ssm.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.ssm.model.IncompatiblePolicyException;
import software.amazon.awssdk.services.ssm.model.InternalServerErrorException;
import software.amazon.awssdk.services.ssm.model.InvalidActivationException;
import software.amazon.awssdk.services.ssm.model.InvalidActivationIdException;
import software.amazon.awssdk.services.ssm.model.InvalidAggregatorException;
import software.amazon.awssdk.services.ssm.model.InvalidAllowedPatternException;
import software.amazon.awssdk.services.ssm.model.InvalidAssociationException;
import software.amazon.awssdk.services.ssm.model.InvalidAssociationVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationExecutionParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationSignalException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationStatusUpdateException;
import software.amazon.awssdk.services.ssm.model.InvalidCommandIdException;
import software.amazon.awssdk.services.ssm.model.InvalidDeleteInventoryParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidDeletionIdException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentContentException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentOperationException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentSchemaVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterKeyException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterOptionException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterValueException;
import software.amazon.awssdk.services.ssm.model.InvalidInstanceIdException;
import software.amazon.awssdk.services.ssm.model.InvalidInstanceInformationFilterValueException;
import software.amazon.awssdk.services.ssm.model.InvalidInventoryGroupException;
import software.amazon.awssdk.services.ssm.model.InvalidInventoryItemContextException;
import software.amazon.awssdk.services.ssm.model.InvalidInventoryRequestException;
import software.amazon.awssdk.services.ssm.model.InvalidItemContentException;
import software.amazon.awssdk.services.ssm.model.InvalidKeyIdException;
import software.amazon.awssdk.services.ssm.model.InvalidNextTokenException;
import software.amazon.awssdk.services.ssm.model.InvalidNotificationConfigException;
import software.amazon.awssdk.services.ssm.model.InvalidOptionException;
import software.amazon.awssdk.services.ssm.model.InvalidOutputFolderException;
import software.amazon.awssdk.services.ssm.model.InvalidOutputLocationException;
import software.amazon.awssdk.services.ssm.model.InvalidParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidPermissionTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidPluginNameException;
import software.amazon.awssdk.services.ssm.model.InvalidPolicyAttributeException;
import software.amazon.awssdk.services.ssm.model.InvalidPolicyTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidResourceIdException;
import software.amazon.awssdk.services.ssm.model.InvalidResourceTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidResultAttributeException;
import software.amazon.awssdk.services.ssm.model.InvalidRoleException;
import software.amazon.awssdk.services.ssm.model.InvalidScheduleException;
import software.amazon.awssdk.services.ssm.model.InvalidTargetException;
import software.amazon.awssdk.services.ssm.model.InvalidTypeNameException;
import software.amazon.awssdk.services.ssm.model.InvalidUpdateException;
import software.amazon.awssdk.services.ssm.model.InvocationDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.ItemContentMismatchException;
import software.amazon.awssdk.services.ssm.model.ItemSizeLimitExceededException;
import software.amazon.awssdk.services.ssm.model.LabelParameterVersionRequest;
import software.amazon.awssdk.services.ssm.model.LabelParameterVersionResponse;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandsResponse;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentsResponse;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssm.model.MaxDocumentSizeExceededException;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.OpsItemAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.OpsItemInvalidParameterException;
import software.amazon.awssdk.services.ssm.model.OpsItemLimitExceededException;
import software.amazon.awssdk.services.ssm.model.OpsItemNotFoundException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataInvalidArgumentException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataKeyLimitExceededException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataLimitExceededException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataNotFoundException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataTooManyUpdatesException;
import software.amazon.awssdk.services.ssm.model.ParameterAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.ParameterLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterMaxVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterNotFoundException;
import software.amazon.awssdk.services.ssm.model.ParameterPatternMismatchException;
import software.amazon.awssdk.services.ssm.model.ParameterVersionLabelLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterVersionNotFoundException;
import software.amazon.awssdk.services.ssm.model.PoliciesLimitExceededException;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsResponse;
import software.amazon.awssdk.services.ssm.model.PutInventoryRequest;
import software.amazon.awssdk.services.ssm.model.PutInventoryResponse;
import software.amazon.awssdk.services.ssm.model.PutParameterRequest;
import software.amazon.awssdk.services.ssm.model.PutParameterResponse;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.ssm.model.ResetServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.ResetServiceSettingResponse;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncConflictException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncCountExceededException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncInvalidConfigurationException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncNotFoundException;
import software.amazon.awssdk.services.ssm.model.ResourceInUseException;
import software.amazon.awssdk.services.ssm.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ResumeSessionRequest;
import software.amazon.awssdk.services.ssm.model.ResumeSessionResponse;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalResponse;
import software.amazon.awssdk.services.ssm.model.SendCommandRequest;
import software.amazon.awssdk.services.ssm.model.SendCommandResponse;
import software.amazon.awssdk.services.ssm.model.ServiceSettingNotFoundException;
import software.amazon.awssdk.services.ssm.model.SsmException;
import software.amazon.awssdk.services.ssm.model.StartAssociationsOnceRequest;
import software.amazon.awssdk.services.ssm.model.StartAssociationsOnceResponse;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionResponse;
import software.amazon.awssdk.services.ssm.model.StartSessionRequest;
import software.amazon.awssdk.services.ssm.model.StartSessionResponse;
import software.amazon.awssdk.services.ssm.model.StatusUnchangedException;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.SubTypeCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.TargetInUseException;
import software.amazon.awssdk.services.ssm.model.TargetNotConnectedException;
import software.amazon.awssdk.services.ssm.model.TerminateSessionRequest;
import software.amazon.awssdk.services.ssm.model.TerminateSessionResponse;
import software.amazon.awssdk.services.ssm.model.TooManyTagsErrorException;
import software.amazon.awssdk.services.ssm.model.TooManyUpdatesException;
import software.amazon.awssdk.services.ssm.model.TotalSizeLimitExceededException;
import software.amazon.awssdk.services.ssm.model.UnsupportedCalendarException;
import software.amazon.awssdk.services.ssm.model.UnsupportedFeatureRequiredException;
import software.amazon.awssdk.services.ssm.model.UnsupportedInventoryItemContextException;
import software.amazon.awssdk.services.ssm.model.UnsupportedInventorySchemaVersionException;
import software.amazon.awssdk.services.ssm.model.UnsupportedOperatingSystemException;
import software.amazon.awssdk.services.ssm.model.UnsupportedParameterTypeException;
import software.amazon.awssdk.services.ssm.model.UnsupportedPlatformTypeException;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskResponse;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleRequest;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleResponse;
import software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.UpdateOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.UpdateServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.UpdateServiceSettingResponse;
import software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselineIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowScheduleIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeSessionsIterable;
import software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable;
import software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable;
import software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryIterable;
import software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryIterable;
import software.amazon.awssdk.services.ssm.paginators.GetParametersByPathIterable;
import software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable;
import software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataIterable;
import software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable;
import software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncIterable;
import software.amazon.awssdk.services.ssm.waiters.SsmWaiter;

/**
 * Service client for accessing Amazon SSM. This can be created using the static {@link #builder()} method.
 *
 * <fullname>AWS Systems Manager</fullname>
 * <p>
 * AWS Systems Manager is a collection of capabilities that helps you automate management tasks such as collecting
 * system inventory, applying operating system (OS) patches, automating the creation of Amazon Machine Images (AMIs),
 * and configuring operating systems (OSs) and applications at scale. Systems Manager lets you remotely and securely
 * manage the configuration of your managed instances. A <i>managed instance</i> is any Amazon Elastic Compute Cloud
 * instance (EC2 instance), or any on-premises server or virtual machine (VM) in your hybrid environment that has been
 * configured for Systems Manager.
 * </p>
 * <p>
 * This reference is intended to be used with the <a
 * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/">AWS Systems Manager User Guide</a>.
 * </p>
 * <p>
 * To get started, verify prerequisites and configure managed instances. For more information, see <a
 * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-setting-up.html">Setting up AWS
 * Systems Manager</a> in the <i>AWS Systems Manager User Guide</i>.
 * </p>
 * <p>
 * For information about other API actions you can perform on EC2 instances, see the <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/">Amazon EC2 API Reference</a>. For information about
 * how to use a Query API, see <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/making-api-requests.html">Making API requests</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SsmClient extends SdkClient {
    String SERVICE_NAME = "ssm";

    /**
     * Create a {@link SsmClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SsmClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SsmClient}.
     */
    static SsmClientBuilder builder() {
        return new DefaultSsmClientBuilder();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource. Tags are metadata that you can assign to your
     * documents, managed instances, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable
     * you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag
     * consists of a key and an optional value, both of which you define. For example, you could define a set of tags
     * for your account's managed instances that helps you track each instance's owner and stack level. For example:
     * Key=Owner and Value=DbAdmin, SysAdmin, or Dev. Or Key=Stack and Value=Production, Pre-Production, or Test.
     * </p>
     * <p>
     * Each resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent
     * set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based
     * on the tags you add. Tags don't have any semantic meaning to and are interpreted strictly as a string of
     * characters.
     * </p>
     * <p>
     * For more information about using tags with EC2 instances, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2 resources</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The resource type is not valid. For example, if you are attempting to tag an instance, the instance must
     *         be a registered, managed instance.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyTagsErrorException
     *         The <code>Targets</code> parameter includes too many tags. Remove one or more tags and try the command
     *         again.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException,
            TooManyTagsErrorException, TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource. Tags are metadata that you can assign to your
     * documents, managed instances, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable
     * you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag
     * consists of a key and an optional value, both of which you define. For example, you could define a set of tags
     * for your account's managed instances that helps you track each instance's owner and stack level. For example:
     * Key=Owner and Value=DbAdmin, SysAdmin, or Dev. Or Key=Stack and Value=Production, Pre-Production, or Test.
     * </p>
     * <p>
     * Each resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent
     * set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based
     * on the tags you add. Tags don't have any semantic meaning to and are interpreted strictly as a string of
     * characters.
     * </p>
     * <p>
     * For more information about using tags with EC2 instances, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2 resources</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToResourceRequest.Builder} to create a request.
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The resource type is not valid. For example, if you are attempting to tag an instance, the instance must
     *         be a registered, managed instance.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyTagsErrorException
     *         The <code>Targets</code> parameter includes too many tags. Remove one or more tags and try the command
     *         again.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default AddTagsToResourceResponse addTagsToResource(Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException,
            TooManyTagsErrorException, TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be
     * terminated and the underlying process stopped.
     * </p>
     *
     * @param cancelCommandRequest
     * @return Result of the CancelCommand operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws DuplicateInstanceIdException
     *         You cannot specify an instance ID in more than one association.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CancelCommand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelCommandResponse cancelCommand(CancelCommandRequest cancelCommandRequest) throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, DuplicateInstanceIdException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be
     * terminated and the underlying process stopped.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelCommandRequest.Builder} avoiding the need to
     * create one manually via {@link CancelCommandRequest#builder()}
     * </p>
     *
     * @param cancelCommandRequest
     *        A {@link Consumer} that will call methods on {@link CancelCommandRequest.Builder} to create a request.
     * @return Result of the CancelCommand operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws DuplicateInstanceIdException
     *         You cannot specify an instance ID in more than one association.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CancelCommand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand" target="_top">AWS API
     *      Documentation</a>
     */
    default CancelCommandResponse cancelCommand(Consumer<CancelCommandRequest.Builder> cancelCommandRequest)
            throws InternalServerErrorException, InvalidCommandIdException, InvalidInstanceIdException,
            DuplicateInstanceIdException, AwsServiceException, SdkClientException, SsmException {
        return cancelCommand(CancelCommandRequest.builder().applyMutation(cancelCommandRequest).build());
    }

    /**
     * <p>
     * Stops a maintenance window execution that is already in progress and cancels any tasks in the window that have
     * not already starting running. (Tasks already in progress will continue to completion.)
     * </p>
     *
     * @param cancelMaintenanceWindowExecutionRequest
     * @return Result of the CancelMaintenanceWindowExecution operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CancelMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMaintenanceWindowExecutionResponse cancelMaintenanceWindowExecution(
            CancelMaintenanceWindowExecutionRequest cancelMaintenanceWindowExecutionRequest) throws InternalServerErrorException,
            DoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a maintenance window execution that is already in progress and cancels any tasks in the window that have
     * not already starting running. (Tasks already in progress will continue to completion.)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMaintenanceWindowExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link CancelMaintenanceWindowExecutionRequest#builder()}
     * </p>
     *
     * @param cancelMaintenanceWindowExecutionRequest
     *        A {@link Consumer} that will call methods on {@link CancelMaintenanceWindowExecutionRequest.Builder} to
     *        create a request.
     * @return Result of the CancelMaintenanceWindowExecution operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CancelMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CancelMaintenanceWindowExecutionResponse cancelMaintenanceWindowExecution(
            Consumer<CancelMaintenanceWindowExecutionRequest.Builder> cancelMaintenanceWindowExecutionRequest)
            throws InternalServerErrorException, DoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        return cancelMaintenanceWindowExecution(CancelMaintenanceWindowExecutionRequest.builder()
                .applyMutation(cancelMaintenanceWindowExecutionRequest).build());
    }

    /**
     * <p>
     * Generates an activation code and activation ID you can use to register your on-premises server or virtual machine
     * (VM) with Systems Manager. Registering these machines with Systems Manager makes it possible to manage them using
     * Systems Manager capabilities. You use the activation code and ID when installing SSM Agent on machines in your
     * hybrid environment. For more information about requirements for managing on-premises instances and VMs using
     * Systems Manager, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting
     * up AWS Systems Manager for hybrid environments</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <note>
     * <p>
     * On-premises servers or VMs that are registered with Systems Manager and EC2 instances that you manage with
     * Systems Manager are all called <i>managed instances</i>.
     * </p>
     * </note>
     *
     * @param createActivationRequest
     * @return Result of the CreateActivation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateActivationResponse createActivation(CreateActivationRequest createActivationRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates an activation code and activation ID you can use to register your on-premises server or virtual machine
     * (VM) with Systems Manager. Registering these machines with Systems Manager makes it possible to manage them using
     * Systems Manager capabilities. You use the activation code and ID when installing SSM Agent on machines in your
     * hybrid environment. For more information about requirements for managing on-premises instances and VMs using
     * Systems Manager, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting
     * up AWS Systems Manager for hybrid environments</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <note>
     * <p>
     * On-premises servers or VMs that are registered with Systems Manager and EC2 instances that you manage with
     * Systems Manager are all called <i>managed instances</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateActivationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateActivationRequest#builder()}
     * </p>
     *
     * @param createActivationRequest
     *        A {@link Consumer} that will call methods on {@link CreateActivationRequest.Builder} to create a request.
     * @return Result of the CreateActivation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateActivationResponse createActivation(Consumer<CreateActivationRequest.Builder> createActivationRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return createActivation(CreateActivationRequest.builder().applyMutation(createActivationRequest).build());
    }

    /**
     * <p>
     * A State Manager association defines the state that you want to maintain on your instances. For example, an
     * association can specify that anti-virus software must be installed and running on your instances, or that certain
     * ports must be closed. For static targets, the association specifies a schedule for when the configuration is
     * reapplied. For dynamic targets, such as an AWS Resource Group or an AWS Autoscaling Group, State Manager applies
     * the configuration when new instances are added to the group. The association also specifies actions to take when
     * applying the configuration. For example, an association for anti-virus software might run once a day. If the
     * software is not installed, then State Manager installs it. If the software is installed, but the service is not
     * running, then the association might instruct State Manager to start the service.
     * </p>
     *
     * @param createAssociationRequest
     * @return Result of the CreateAssociation operation returned by the service.
     * @throws AssociationAlreadyExistsException
     *         The specified association already exists.
     * @throws AssociationLimitExceededException
     *         You can have at most 2,000 active associations.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws UnsupportedPlatformTypeException
     *         The document does not support the platform type of the given instance ID(s). For example, you sent an
     *         document for a Windows instance to a Linux instance.
     * @throws InvalidOutputLocationException
     *         The output location is not valid or does not exist.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the Systems Manager document. You can only supply
     *         values to parameters defined in the Systems Manager document.
     * @throws InvalidTargetException
     *         The target is not valid or does not exist. It might not be configured for Systems Manager or you might
     *         not have permission to perform the operation.
     * @throws InvalidScheduleException
     *         The schedule is invalid. Verify your cron or rate expression and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAssociationResponse createAssociation(CreateAssociationRequest createAssociationRequest)
            throws AssociationAlreadyExistsException, AssociationLimitExceededException, InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, InvalidInstanceIdException,
            UnsupportedPlatformTypeException, InvalidOutputLocationException, InvalidParametersException, InvalidTargetException,
            InvalidScheduleException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A State Manager association defines the state that you want to maintain on your instances. For example, an
     * association can specify that anti-virus software must be installed and running on your instances, or that certain
     * ports must be closed. For static targets, the association specifies a schedule for when the configuration is
     * reapplied. For dynamic targets, such as an AWS Resource Group or an AWS Autoscaling Group, State Manager applies
     * the configuration when new instances are added to the group. The association also specifies actions to take when
     * applying the configuration. For example, an association for anti-virus software might run once a day. If the
     * software is not installed, then State Manager installs it. If the software is installed, but the service is not
     * running, then the association might instruct State Manager to start the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssociationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssociationRequest#builder()}
     * </p>
     *
     * @param createAssociationRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssociationRequest.Builder} to create a request.
     * @return Result of the CreateAssociation operation returned by the service.
     * @throws AssociationAlreadyExistsException
     *         The specified association already exists.
     * @throws AssociationLimitExceededException
     *         You can have at most 2,000 active associations.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws UnsupportedPlatformTypeException
     *         The document does not support the platform type of the given instance ID(s). For example, you sent an
     *         document for a Windows instance to a Linux instance.
     * @throws InvalidOutputLocationException
     *         The output location is not valid or does not exist.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the Systems Manager document. You can only supply
     *         values to parameters defined in the Systems Manager document.
     * @throws InvalidTargetException
     *         The target is not valid or does not exist. It might not be configured for Systems Manager or you might
     *         not have permission to perform the operation.
     * @throws InvalidScheduleException
     *         The schedule is invalid. Verify your cron or rate expression and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAssociationResponse createAssociation(Consumer<CreateAssociationRequest.Builder> createAssociationRequest)
            throws AssociationAlreadyExistsException, AssociationLimitExceededException, InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, InvalidInstanceIdException,
            UnsupportedPlatformTypeException, InvalidOutputLocationException, InvalidParametersException, InvalidTargetException,
            InvalidScheduleException, AwsServiceException, SdkClientException, SsmException {
        return createAssociation(CreateAssociationRequest.builder().applyMutation(createAssociationRequest).build());
    }

    /**
     * <p>
     * Associates the specified Systems Manager document with the specified instances or targets.
     * </p>
     * <p>
     * When you associate a document with one or more instances using instance IDs or tags, SSM Agent running on the
     * instance processes the document and configures the instance as specified.
     * </p>
     * <p>
     * If you associate a document with an instance that already has an associated document, the system returns the
     * AssociationAlreadyExists exception.
     * </p>
     *
     * @param createAssociationBatchRequest
     * @return Result of the CreateAssociationBatch operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the Systems Manager document. You can only supply
     *         values to parameters defined in the Systems Manager document.
     * @throws DuplicateInstanceIdException
     *         You cannot specify an instance ID in more than one association.
     * @throws AssociationLimitExceededException
     *         You can have at most 2,000 active associations.
     * @throws UnsupportedPlatformTypeException
     *         The document does not support the platform type of the given instance ID(s). For example, you sent an
     *         document for a Windows instance to a Linux instance.
     * @throws InvalidOutputLocationException
     *         The output location is not valid or does not exist.
     * @throws InvalidTargetException
     *         The target is not valid or does not exist. It might not be configured for Systems Manager or you might
     *         not have permission to perform the operation.
     * @throws InvalidScheduleException
     *         The schedule is invalid. Verify your cron or rate expression and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateAssociationBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAssociationBatchResponse createAssociationBatch(CreateAssociationBatchRequest createAssociationBatchRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentVersionException,
            InvalidInstanceIdException, InvalidParametersException, DuplicateInstanceIdException,
            AssociationLimitExceededException, UnsupportedPlatformTypeException, InvalidOutputLocationException,
            InvalidTargetException, InvalidScheduleException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified Systems Manager document with the specified instances or targets.
     * </p>
     * <p>
     * When you associate a document with one or more instances using instance IDs or tags, SSM Agent running on the
     * instance processes the document and configures the instance as specified.
     * </p>
     * <p>
     * If you associate a document with an instance that already has an associated document, the system returns the
     * AssociationAlreadyExists exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssociationBatchRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAssociationBatchRequest#builder()}
     * </p>
     *
     * @param createAssociationBatchRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssociationBatchRequest.Builder} to create a
     *        request.
     * @return Result of the CreateAssociationBatch operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the Systems Manager document. You can only supply
     *         values to parameters defined in the Systems Manager document.
     * @throws DuplicateInstanceIdException
     *         You cannot specify an instance ID in more than one association.
     * @throws AssociationLimitExceededException
     *         You can have at most 2,000 active associations.
     * @throws UnsupportedPlatformTypeException
     *         The document does not support the platform type of the given instance ID(s). For example, you sent an
     *         document for a Windows instance to a Linux instance.
     * @throws InvalidOutputLocationException
     *         The output location is not valid or does not exist.
     * @throws InvalidTargetException
     *         The target is not valid or does not exist. It might not be configured for Systems Manager or you might
     *         not have permission to perform the operation.
     * @throws InvalidScheduleException
     *         The schedule is invalid. Verify your cron or rate expression and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateAssociationBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateAssociationBatchResponse createAssociationBatch(
            Consumer<CreateAssociationBatchRequest.Builder> createAssociationBatchRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, InvalidInstanceIdException, InvalidParametersException,
            DuplicateInstanceIdException, AssociationLimitExceededException, UnsupportedPlatformTypeException,
            InvalidOutputLocationException, InvalidTargetException, InvalidScheduleException, AwsServiceException,
            SdkClientException, SsmException {
        return createAssociationBatch(CreateAssociationBatchRequest.builder().applyMutation(createAssociationBatchRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Systems Manager (SSM) document. An SSM document defines the actions that Systems Manager performs on
     * your managed instances. For more information about SSM documents, including information about supported schemas,
     * features, and syntax, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html">AWS Systems Manager
     * Documents</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     *
     * @param createDocumentRequest
     * @return Result of the CreateDocument operation returned by the service.
     * @throws DocumentAlreadyExistsException
     *         The specified document already exists.
     * @throws MaxDocumentSizeExceededException
     *         The size limit of a document is 64 KB.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentContentException
     *         The content for the document is not valid.
     * @throws DocumentLimitExceededException
     *         You can have at most 500 active Systems Manager documents.
     * @throws InvalidDocumentSchemaVersionException
     *         The version of the document schema is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDocumentResponse createDocument(CreateDocumentRequest createDocumentRequest)
            throws DocumentAlreadyExistsException, MaxDocumentSizeExceededException, InternalServerErrorException,
            InvalidDocumentContentException, DocumentLimitExceededException, InvalidDocumentSchemaVersionException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Systems Manager (SSM) document. An SSM document defines the actions that Systems Manager performs on
     * your managed instances. For more information about SSM documents, including information about supported schemas,
     * features, and syntax, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html">AWS Systems Manager
     * Documents</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDocumentRequest#builder()}
     * </p>
     *
     * @param createDocumentRequest
     *        A {@link Consumer} that will call methods on {@link CreateDocumentRequest.Builder} to create a request.
     * @return Result of the CreateDocument operation returned by the service.
     * @throws DocumentAlreadyExistsException
     *         The specified document already exists.
     * @throws MaxDocumentSizeExceededException
     *         The size limit of a document is 64 KB.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentContentException
     *         The content for the document is not valid.
     * @throws DocumentLimitExceededException
     *         You can have at most 500 active Systems Manager documents.
     * @throws InvalidDocumentSchemaVersionException
     *         The version of the document schema is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDocumentResponse createDocument(Consumer<CreateDocumentRequest.Builder> createDocumentRequest)
            throws DocumentAlreadyExistsException, MaxDocumentSizeExceededException, InternalServerErrorException,
            InvalidDocumentContentException, DocumentLimitExceededException, InvalidDocumentSchemaVersionException,
            AwsServiceException, SdkClientException, SsmException {
        return createDocument(CreateDocumentRequest.builder().applyMutation(createDocumentRequest).build());
    }

    /**
     * <p>
     * Creates a new maintenance window.
     * </p>
     * <note>
     * <p>
     * The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based
     * on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the
     * number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the
     * duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window
     * tasks can start after 5 PM.
     * </p>
     * </note>
     *
     * @param createMaintenanceWindowRequest
     * @return Result of the CreateMaintenanceWindow operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource quotas. For example, too many
     *         maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateMaintenanceWindowResponse createMaintenanceWindow(CreateMaintenanceWindowRequest createMaintenanceWindowRequest)
            throws IdempotentParameterMismatchException, ResourceLimitExceededException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new maintenance window.
     * </p>
     * <note>
     * <p>
     * The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based
     * on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the
     * number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the
     * duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window
     * tasks can start after 5 PM.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMaintenanceWindowRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMaintenanceWindowRequest#builder()}
     * </p>
     *
     * @param createMaintenanceWindowRequest
     *        A {@link Consumer} that will call methods on {@link CreateMaintenanceWindowRequest.Builder} to create a
     *        request.
     * @return Result of the CreateMaintenanceWindow operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource quotas. For example, too many
     *         maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateMaintenanceWindowResponse createMaintenanceWindow(
            Consumer<CreateMaintenanceWindowRequest.Builder> createMaintenanceWindowRequest)
            throws IdempotentParameterMismatchException, ResourceLimitExceededException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return createMaintenanceWindow(CreateMaintenanceWindowRequest.builder().applyMutation(createMaintenanceWindowRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new OpsItem. You must have permission in AWS Identity and Access Management (IAM) to create a new
     * OpsItem. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     *
     * @param createOpsItemRequest
     * @return Result of the CreateOpsItem operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemAlreadyExistsException
     *         The OpsItem already exists.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a
     *         href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateOpsItemResponse createOpsItem(CreateOpsItemRequest createOpsItemRequest) throws InternalServerErrorException,
            OpsItemAlreadyExistsException, OpsItemLimitExceededException, OpsItemInvalidParameterException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new OpsItem. You must have permission in AWS Identity and Access Management (IAM) to create a new
     * OpsItem. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOpsItemRequest.Builder} avoiding the need to
     * create one manually via {@link CreateOpsItemRequest#builder()}
     * </p>
     *
     * @param createOpsItemRequest
     *        A {@link Consumer} that will call methods on {@link CreateOpsItemRequest.Builder} to create a request.
     * @return Result of the CreateOpsItem operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemAlreadyExistsException
     *         The OpsItem already exists.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a
     *         href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateOpsItemResponse createOpsItem(Consumer<CreateOpsItemRequest.Builder> createOpsItemRequest)
            throws InternalServerErrorException, OpsItemAlreadyExistsException, OpsItemLimitExceededException,
            OpsItemInvalidParameterException, AwsServiceException, SdkClientException, SsmException {
        return createOpsItem(CreateOpsItemRequest.builder().applyMutation(createOpsItemRequest).build());
    }

    /**
     * <p>
     * If you create a new application in Application Manager, Systems Manager calls this API action to specify
     * information about the new application, including the application type.
     * </p>
     *
     * @param createOpsMetadataRequest
     * @return Result of the CreateOpsMetadata operation returned by the service.
     * @throws OpsMetadataAlreadyExistsException
     *         An OpsMetadata object already exists for the selected resource.
     * @throws OpsMetadataTooManyUpdatesException
     *         The system is processing too many concurrent updates. Wait a few moments and try again.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws OpsMetadataLimitExceededException
     *         Your account reached the maximum number of OpsMetadata objects allowed by Application Manager. The
     *         maximum is 200 OpsMetadata objects. Delete one or more OpsMetadata object and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateOpsMetadataResponse createOpsMetadata(CreateOpsMetadataRequest createOpsMetadataRequest)
            throws OpsMetadataAlreadyExistsException, OpsMetadataTooManyUpdatesException, OpsMetadataInvalidArgumentException,
            OpsMetadataLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If you create a new application in Application Manager, Systems Manager calls this API action to specify
     * information about the new application, including the application type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOpsMetadataRequest.Builder} avoiding the need
     * to create one manually via {@link CreateOpsMetadataRequest#builder()}
     * </p>
     *
     * @param createOpsMetadataRequest
     *        A {@link Consumer} that will call methods on {@link CreateOpsMetadataRequest.Builder} to create a request.
     * @return Result of the CreateOpsMetadata operation returned by the service.
     * @throws OpsMetadataAlreadyExistsException
     *         An OpsMetadata object already exists for the selected resource.
     * @throws OpsMetadataTooManyUpdatesException
     *         The system is processing too many concurrent updates. Wait a few moments and try again.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws OpsMetadataLimitExceededException
     *         Your account reached the maximum number of OpsMetadata objects allowed by Application Manager. The
     *         maximum is 200 OpsMetadata objects. Delete one or more OpsMetadata object and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateOpsMetadataResponse createOpsMetadata(Consumer<CreateOpsMetadataRequest.Builder> createOpsMetadataRequest)
            throws OpsMetadataAlreadyExistsException, OpsMetadataTooManyUpdatesException, OpsMetadataInvalidArgumentException,
            OpsMetadataLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        return createOpsMetadata(CreateOpsMetadataRequest.builder().applyMutation(createOpsMetadataRequest).build());
    }

    /**
     * <p>
     * Creates a patch baseline.
     * </p>
     * <note>
     * <p>
     * For information about valid key and value pairs in <code>PatchFilters</code> for each supported operating system
     * type, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html">PatchFilter</a>.
     * </p>
     * </note>
     *
     * @param createPatchBaselineRequest
     * @return Result of the CreatePatchBaseline operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource quotas. For example, too many
     *         maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreatePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePatchBaselineResponse createPatchBaseline(CreatePatchBaselineRequest createPatchBaselineRequest)
            throws IdempotentParameterMismatchException, ResourceLimitExceededException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a patch baseline.
     * </p>
     * <note>
     * <p>
     * For information about valid key and value pairs in <code>PatchFilters</code> for each supported operating system
     * type, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html">PatchFilter</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePatchBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePatchBaselineRequest#builder()}
     * </p>
     *
     * @param createPatchBaselineRequest
     *        A {@link Consumer} that will call methods on {@link CreatePatchBaselineRequest.Builder} to create a
     *        request.
     * @return Result of the CreatePatchBaseline operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource quotas. For example, too many
     *         maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreatePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CreatePatchBaselineResponse createPatchBaseline(
            Consumer<CreatePatchBaselineRequest.Builder> createPatchBaselineRequest) throws IdempotentParameterMismatchException,
            ResourceLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return createPatchBaseline(CreatePatchBaselineRequest.builder().applyMutation(createPatchBaselineRequest).build());
    }

    /**
     * <p>
     * A resource data sync helps you view data from multiple sources in a single location. Systems Manager offers two
     * types of resource data sync: <code>SyncToDestination</code> and <code>SyncFromSource</code>.
     * </p>
     * <p>
     * You can configure Systems Manager Inventory to use the <code>SyncToDestination</code> type to synchronize
     * Inventory data from multiple AWS Regions to a single S3 bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html">Configuring
     * Resource Data Sync for Inventory</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * You can configure Systems Manager Explorer to use the <code>SyncFromSource</code> type to synchronize operational
     * work items (OpsItems) and operational data (OpsData) from multiple AWS Regions to a single S3 bucket. This type
     * can synchronize OpsItems and OpsData from multiple AWS accounts and Regions or <code>EntireOrganization</code> by
     * using AWS Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up
     * Systems Manager Explorer to display data from multiple accounts and Regions</a> in the <i>AWS Systems Manager
     * User Guide</i>.
     * </p>
     * <p>
     * A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is
     * completed, the system continuously syncs data. To check the status of a sync, use the
     * <a>ListResourceDataSync</a>.
     * </p>
     * <note>
     * <p>
     * By default, data is not encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to
     * ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a
     * restrictive bucket policy.
     * </p>
     * </note>
     *
     * @param createResourceDataSyncRequest
     * @return Result of the CreateResourceDataSync operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncCountExceededException
     *         You have exceeded the allowed maximum sync configurations.
     * @throws ResourceDataSyncAlreadyExistsException
     *         A sync configuration with the same name already exists.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateResourceDataSyncResponse createResourceDataSync(CreateResourceDataSyncRequest createResourceDataSyncRequest)
            throws InternalServerErrorException, ResourceDataSyncCountExceededException, ResourceDataSyncAlreadyExistsException,
            ResourceDataSyncInvalidConfigurationException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A resource data sync helps you view data from multiple sources in a single location. Systems Manager offers two
     * types of resource data sync: <code>SyncToDestination</code> and <code>SyncFromSource</code>.
     * </p>
     * <p>
     * You can configure Systems Manager Inventory to use the <code>SyncToDestination</code> type to synchronize
     * Inventory data from multiple AWS Regions to a single S3 bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html">Configuring
     * Resource Data Sync for Inventory</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * You can configure Systems Manager Explorer to use the <code>SyncFromSource</code> type to synchronize operational
     * work items (OpsItems) and operational data (OpsData) from multiple AWS Regions to a single S3 bucket. This type
     * can synchronize OpsItems and OpsData from multiple AWS accounts and Regions or <code>EntireOrganization</code> by
     * using AWS Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up
     * Systems Manager Explorer to display data from multiple accounts and Regions</a> in the <i>AWS Systems Manager
     * User Guide</i>.
     * </p>
     * <p>
     * A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is
     * completed, the system continuously syncs data. To check the status of a sync, use the
     * <a>ListResourceDataSync</a>.
     * </p>
     * <note>
     * <p>
     * By default, data is not encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to
     * ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a
     * restrictive bucket policy.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceDataSyncRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceDataSyncRequest#builder()}
     * </p>
     *
     * @param createResourceDataSyncRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceDataSyncRequest.Builder} to create a
     *        request.
     * @return Result of the CreateResourceDataSync operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncCountExceededException
     *         You have exceeded the allowed maximum sync configurations.
     * @throws ResourceDataSyncAlreadyExistsException
     *         A sync configuration with the same name already exists.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateResourceDataSyncResponse createResourceDataSync(
            Consumer<CreateResourceDataSyncRequest.Builder> createResourceDataSyncRequest) throws InternalServerErrorException,
            ResourceDataSyncCountExceededException, ResourceDataSyncAlreadyExistsException,
            ResourceDataSyncInvalidConfigurationException, AwsServiceException, SdkClientException, SsmException {
        return createResourceDataSync(CreateResourceDataSyncRequest.builder().applyMutation(createResourceDataSyncRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an activation. You are not required to delete an activation. If you delete an activation, you can no
     * longer use it to register additional managed instances. Deleting an activation does not de-register managed
     * instances. You must manually de-register managed instances.
     * </p>
     *
     * @param deleteActivationRequest
     * @return Result of the DeleteActivation operation returned by the service.
     * @throws InvalidActivationIdException
     *         The activation ID is not valid. Verify the you entered the correct ActivationId or ActivationCode and try
     *         again.
     * @throws InvalidActivationException
     *         The activation is not valid. The activation might have been deleted, or the ActivationId and the
     *         ActivationCode do not match.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteActivationResponse deleteActivation(DeleteActivationRequest deleteActivationRequest)
            throws InvalidActivationIdException, InvalidActivationException, InternalServerErrorException,
            TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an activation. You are not required to delete an activation. If you delete an activation, you can no
     * longer use it to register additional managed instances. Deleting an activation does not de-register managed
     * instances. You must manually de-register managed instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteActivationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteActivationRequest#builder()}
     * </p>
     *
     * @param deleteActivationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteActivationRequest.Builder} to create a request.
     * @return Result of the DeleteActivation operation returned by the service.
     * @throws InvalidActivationIdException
     *         The activation ID is not valid. Verify the you entered the correct ActivationId or ActivationCode and try
     *         again.
     * @throws InvalidActivationException
     *         The activation is not valid. The activation might have been deleted, or the ActivationId and the
     *         ActivationCode do not match.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteActivationResponse deleteActivation(Consumer<DeleteActivationRequest.Builder> deleteActivationRequest)
            throws InvalidActivationIdException, InvalidActivationException, InternalServerErrorException,
            TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        return deleteActivation(DeleteActivationRequest.builder().applyMutation(deleteActivationRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified Systems Manager document from the specified instance.
     * </p>
     * <p>
     * When you disassociate a document from an instance, it does not change the configuration of the instance. To
     * change the configuration state of an instance after you disassociate a document, you must create a new document
     * with the desired configuration and associate it with the instance.
     * </p>
     *
     * @param deleteAssociationRequest
     * @return Result of the DeleteAssociation operation returned by the service.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAssociationResponse deleteAssociation(DeleteAssociationRequest deleteAssociationRequest)
            throws AssociationDoesNotExistException, InternalServerErrorException, InvalidDocumentException,
            InvalidInstanceIdException, TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified Systems Manager document from the specified instance.
     * </p>
     * <p>
     * When you disassociate a document from an instance, it does not change the configuration of the instance. To
     * change the configuration state of an instance after you disassociate a document, you must create a new document
     * with the desired configuration and associate it with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssociationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssociationRequest#builder()}
     * </p>
     *
     * @param deleteAssociationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssociationRequest.Builder} to create a request.
     * @return Result of the DeleteAssociation operation returned by the service.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAssociationResponse deleteAssociation(Consumer<DeleteAssociationRequest.Builder> deleteAssociationRequest)
            throws AssociationDoesNotExistException, InternalServerErrorException, InvalidDocumentException,
            InvalidInstanceIdException, TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        return deleteAssociation(DeleteAssociationRequest.builder().applyMutation(deleteAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the Systems Manager document and all instance associations to the document.
     * </p>
     * <p>
     * Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all instances
     * that are associated with the document.
     * </p>
     *
     * @param deleteDocumentRequest
     * @return Result of the DeleteDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentOperationException
     *         You attempted to delete a document while it is still shared. You must stop sharing the document before
     *         you can delete it.
     * @throws AssociatedInstancesException
     *         You must disassociate a document from all instances before you can delete it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDocumentResponse deleteDocument(DeleteDocumentRequest deleteDocumentRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentOperationException,
            AssociatedInstancesException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Systems Manager document and all instance associations to the document.
     * </p>
     * <p>
     * Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all instances
     * that are associated with the document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDocumentRequest#builder()}
     * </p>
     *
     * @param deleteDocumentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDocumentRequest.Builder} to create a request.
     * @return Result of the DeleteDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentOperationException
     *         You attempted to delete a document while it is still shared. You must stop sharing the document before
     *         you can delete it.
     * @throws AssociatedInstancesException
     *         You must disassociate a document from all instances before you can delete it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDocumentResponse deleteDocument(Consumer<DeleteDocumentRequest.Builder> deleteDocumentRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentOperationException,
            AssociatedInstancesException, AwsServiceException, SdkClientException, SsmException {
        return deleteDocument(DeleteDocumentRequest.builder().applyMutation(deleteDocumentRequest).build());
    }

    /**
     * <p>
     * Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory
     * type is also referred to as deleting a custom inventory schema.
     * </p>
     *
     * @param deleteInventoryRequest
     * @return Result of the DeleteInventory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidOptionException
     *         The delete inventory option specified is not valid. Verify the option and try again.
     * @throws InvalidDeleteInventoryParametersException
     *         One or more of the parameters specified for the delete operation is not valid. Verify all parameters and
     *         try again.
     * @throws InvalidInventoryRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInventoryResponse deleteInventory(DeleteInventoryRequest deleteInventoryRequest)
            throws InternalServerErrorException, InvalidTypeNameException, InvalidOptionException,
            InvalidDeleteInventoryParametersException, InvalidInventoryRequestException, AwsServiceException, SdkClientException,
            SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory
     * type is also referred to as deleting a custom inventory schema.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInventoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteInventoryRequest#builder()}
     * </p>
     *
     * @param deleteInventoryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInventoryRequest.Builder} to create a request.
     * @return Result of the DeleteInventory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidOptionException
     *         The delete inventory option specified is not valid. Verify the option and try again.
     * @throws InvalidDeleteInventoryParametersException
     *         One or more of the parameters specified for the delete operation is not valid. Verify all parameters and
     *         try again.
     * @throws InvalidInventoryRequestException
     *         The request is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteInventoryResponse deleteInventory(Consumer<DeleteInventoryRequest.Builder> deleteInventoryRequest)
            throws InternalServerErrorException, InvalidTypeNameException, InvalidOptionException,
            InvalidDeleteInventoryParametersException, InvalidInventoryRequestException, AwsServiceException, SdkClientException,
            SsmException {
        return deleteInventory(DeleteInventoryRequest.builder().applyMutation(deleteInventoryRequest).build());
    }

    /**
     * <p>
     * Deletes a maintenance window.
     * </p>
     *
     * @param deleteMaintenanceWindowRequest
     * @return Result of the DeleteMaintenanceWindow operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteMaintenanceWindowResponse deleteMaintenanceWindow(DeleteMaintenanceWindowRequest deleteMaintenanceWindowRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMaintenanceWindowRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMaintenanceWindowRequest#builder()}
     * </p>
     *
     * @param deleteMaintenanceWindowRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMaintenanceWindowRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteMaintenanceWindow operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteMaintenanceWindowResponse deleteMaintenanceWindow(
            Consumer<DeleteMaintenanceWindowRequest.Builder> deleteMaintenanceWindowRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return deleteMaintenanceWindow(DeleteMaintenanceWindowRequest.builder().applyMutation(deleteMaintenanceWindowRequest)
                .build());
    }

    /**
     * <p>
     * Delete OpsMetadata related to an application.
     * </p>
     *
     * @param deleteOpsMetadataRequest
     * @return Result of the DeleteOpsMetadata operation returned by the service.
     * @throws OpsMetadataNotFoundException
     *         The OpsMetadata object does not exist.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOpsMetadataResponse deleteOpsMetadata(DeleteOpsMetadataRequest deleteOpsMetadataRequest)
            throws OpsMetadataNotFoundException, OpsMetadataInvalidArgumentException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete OpsMetadata related to an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOpsMetadataRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteOpsMetadataRequest#builder()}
     * </p>
     *
     * @param deleteOpsMetadataRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOpsMetadataRequest.Builder} to create a request.
     * @return Result of the DeleteOpsMetadata operation returned by the service.
     * @throws OpsMetadataNotFoundException
     *         The OpsMetadata object does not exist.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteOpsMetadataResponse deleteOpsMetadata(Consumer<DeleteOpsMetadataRequest.Builder> deleteOpsMetadataRequest)
            throws OpsMetadataNotFoundException, OpsMetadataInvalidArgumentException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return deleteOpsMetadata(DeleteOpsMetadataRequest.builder().applyMutation(deleteOpsMetadataRequest).build());
    }

    /**
     * <p>
     * Delete a parameter from the system.
     * </p>
     *
     * @param deleteParameterRequest
     * @return Result of the DeleteParameter operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteParameterResponse deleteParameter(DeleteParameterRequest deleteParameterRequest)
            throws InternalServerErrorException, ParameterNotFoundException, AwsServiceException, SdkClientException,
            SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a parameter from the system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteParameterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteParameterRequest#builder()}
     * </p>
     *
     * @param deleteParameterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteParameterRequest.Builder} to create a request.
     * @return Result of the DeleteParameter operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteParameterResponse deleteParameter(Consumer<DeleteParameterRequest.Builder> deleteParameterRequest)
            throws InternalServerErrorException, ParameterNotFoundException, AwsServiceException, SdkClientException,
            SsmException {
        return deleteParameter(DeleteParameterRequest.builder().applyMutation(deleteParameterRequest).build());
    }

    /**
     * <p>
     * Delete a list of parameters.
     * </p>
     *
     * @param deleteParametersRequest
     * @return Result of the DeleteParameters operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteParametersResponse deleteParameters(DeleteParametersRequest deleteParametersRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a list of parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteParametersRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteParametersRequest#builder()}
     * </p>
     *
     * @param deleteParametersRequest
     *        A {@link Consumer} that will call methods on {@link DeleteParametersRequest.Builder} to create a request.
     * @return Result of the DeleteParameters operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteParametersResponse deleteParameters(Consumer<DeleteParametersRequest.Builder> deleteParametersRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return deleteParameters(DeleteParametersRequest.builder().applyMutation(deleteParametersRequest).build());
    }

    /**
     * <p>
     * Deletes a patch baseline.
     * </p>
     *
     * @param deletePatchBaselineRequest
     * @return Result of the DeletePatchBaseline operation returned by the service.
     * @throws ResourceInUseException
     *         Error returned if an attempt is made to delete a patch baseline that is registered for a patch group.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeletePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePatchBaselineResponse deletePatchBaseline(DeletePatchBaselineRequest deletePatchBaselineRequest)
            throws ResourceInUseException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePatchBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePatchBaselineRequest#builder()}
     * </p>
     *
     * @param deletePatchBaselineRequest
     *        A {@link Consumer} that will call methods on {@link DeletePatchBaselineRequest.Builder} to create a
     *        request.
     * @return Result of the DeletePatchBaseline operation returned by the service.
     * @throws ResourceInUseException
     *         Error returned if an attempt is made to delete a patch baseline that is registered for a patch group.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeletePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default DeletePatchBaselineResponse deletePatchBaseline(
            Consumer<DeletePatchBaselineRequest.Builder> deletePatchBaselineRequest) throws ResourceInUseException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return deletePatchBaseline(DeletePatchBaselineRequest.builder().applyMutation(deletePatchBaselineRequest).build());
    }

    /**
     * <p>
     * Deletes a Resource Data Sync configuration. After the configuration is deleted, changes to data on managed
     * instances are no longer synced to or from the target. Deleting a sync configuration does not delete data.
     * </p>
     *
     * @param deleteResourceDataSyncRequest
     * @return Result of the DeleteResourceDataSync operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncNotFoundException
     *         The specified sync name was not found.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteResourceDataSyncResponse deleteResourceDataSync(DeleteResourceDataSyncRequest deleteResourceDataSyncRequest)
            throws InternalServerErrorException, ResourceDataSyncNotFoundException,
            ResourceDataSyncInvalidConfigurationException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Resource Data Sync configuration. After the configuration is deleted, changes to data on managed
     * instances are no longer synced to or from the target. Deleting a sync configuration does not delete data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceDataSyncRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceDataSyncRequest#builder()}
     * </p>
     *
     * @param deleteResourceDataSyncRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceDataSyncRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteResourceDataSync operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncNotFoundException
     *         The specified sync name was not found.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteResourceDataSyncResponse deleteResourceDataSync(
            Consumer<DeleteResourceDataSyncRequest.Builder> deleteResourceDataSyncRequest) throws InternalServerErrorException,
            ResourceDataSyncNotFoundException, ResourceDataSyncInvalidConfigurationException, AwsServiceException,
            SdkClientException, SsmException {
        return deleteResourceDataSync(DeleteResourceDataSyncRequest.builder().applyMutation(deleteResourceDataSyncRequest)
                .build());
    }

    /**
     * <p>
     * Removes the server or virtual machine from the list of registered servers. You can reregister the instance again
     * at any time. If you don't plan to use Run Command on the server, we suggest uninstalling SSM Agent first.
     * </p>
     *
     * @param deregisterManagedInstanceRequest
     * @return Result of the DeregisterManagedInstance operation returned by the service.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeregisterManagedInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterManagedInstanceResponse deregisterManagedInstance(
            DeregisterManagedInstanceRequest deregisterManagedInstanceRequest) throws InvalidInstanceIdException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the server or virtual machine from the list of registered servers. You can reregister the instance again
     * at any time. If you don't plan to use Run Command on the server, we suggest uninstalling SSM Agent first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterManagedInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterManagedInstanceRequest#builder()}
     * </p>
     *
     * @param deregisterManagedInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterManagedInstanceRequest.Builder} to create a
     *        request.
     * @return Result of the DeregisterManagedInstance operation returned by the service.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeregisterManagedInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default DeregisterManagedInstanceResponse deregisterManagedInstance(
            Consumer<DeregisterManagedInstanceRequest.Builder> deregisterManagedInstanceRequest)
            throws InvalidInstanceIdException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        return deregisterManagedInstance(DeregisterManagedInstanceRequest.builder()
                .applyMutation(deregisterManagedInstanceRequest).build());
    }

    /**
     * <p>
     * Removes a patch group from a patch baseline.
     * </p>
     *
     * @param deregisterPatchBaselineForPatchGroupRequest
     * @return Result of the DeregisterPatchBaselineForPatchGroup operation returned by the service.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeregisterPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterPatchBaselineForPatchGroupResponse deregisterPatchBaselineForPatchGroup(
            DeregisterPatchBaselineForPatchGroupRequest deregisterPatchBaselineForPatchGroupRequest)
            throws InvalidResourceIdException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a patch group from a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeregisterPatchBaselineForPatchGroupRequest.Builder} avoiding the need to create one manually via
     * {@link DeregisterPatchBaselineForPatchGroupRequest#builder()}
     * </p>
     *
     * @param deregisterPatchBaselineForPatchGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterPatchBaselineForPatchGroupRequest.Builder}
     *        to create a request.
     * @return Result of the DeregisterPatchBaselineForPatchGroup operation returned by the service.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeregisterPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterPatchBaselineForPatchGroupResponse deregisterPatchBaselineForPatchGroup(
            Consumer<DeregisterPatchBaselineForPatchGroupRequest.Builder> deregisterPatchBaselineForPatchGroupRequest)
            throws InvalidResourceIdException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        return deregisterPatchBaselineForPatchGroup(DeregisterPatchBaselineForPatchGroupRequest.builder()
                .applyMutation(deregisterPatchBaselineForPatchGroupRequest).build());
    }

    /**
     * <p>
     * Removes a target from a maintenance window.
     * </p>
     *
     * @param deregisterTargetFromMaintenanceWindowRequest
     * @return Result of the DeregisterTargetFromMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TargetInUseException
     *         You specified the <code>Safe</code> option for the DeregisterTargetFromMaintenanceWindow operation, but
     *         the target is still referenced in a task.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeregisterTargetFromMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterTargetFromMaintenanceWindowResponse deregisterTargetFromMaintenanceWindow(
            DeregisterTargetFromMaintenanceWindowRequest deregisterTargetFromMaintenanceWindowRequest)
            throws DoesNotExistException, InternalServerErrorException, TargetInUseException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a target from a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeregisterTargetFromMaintenanceWindowRequest.Builder} avoiding the need to create one manually via
     * {@link DeregisterTargetFromMaintenanceWindowRequest#builder()}
     * </p>
     *
     * @param deregisterTargetFromMaintenanceWindowRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterTargetFromMaintenanceWindowRequest.Builder}
     *        to create a request.
     * @return Result of the DeregisterTargetFromMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TargetInUseException
     *         You specified the <code>Safe</code> option for the DeregisterTargetFromMaintenanceWindow operation, but
     *         the target is still referenced in a task.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeregisterTargetFromMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterTargetFromMaintenanceWindowResponse deregisterTargetFromMaintenanceWindow(
            Consumer<DeregisterTargetFromMaintenanceWindowRequest.Builder> deregisterTargetFromMaintenanceWindowRequest)
            throws DoesNotExistException, InternalServerErrorException, TargetInUseException, AwsServiceException,
            SdkClientException, SsmException {
        return deregisterTargetFromMaintenanceWindow(DeregisterTargetFromMaintenanceWindowRequest.builder()
                .applyMutation(deregisterTargetFromMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Removes a task from a maintenance window.
     * </p>
     *
     * @param deregisterTaskFromMaintenanceWindowRequest
     * @return Result of the DeregisterTaskFromMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeregisterTaskFromMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterTaskFromMaintenanceWindowResponse deregisterTaskFromMaintenanceWindow(
            DeregisterTaskFromMaintenanceWindowRequest deregisterTaskFromMaintenanceWindowRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a task from a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterTaskFromMaintenanceWindowRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterTaskFromMaintenanceWindowRequest#builder()}
     * </p>
     *
     * @param deregisterTaskFromMaintenanceWindowRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterTaskFromMaintenanceWindowRequest.Builder} to
     *        create a request.
     * @return Result of the DeregisterTaskFromMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeregisterTaskFromMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterTaskFromMaintenanceWindowResponse deregisterTaskFromMaintenanceWindow(
            Consumer<DeregisterTaskFromMaintenanceWindowRequest.Builder> deregisterTaskFromMaintenanceWindowRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return deregisterTaskFromMaintenanceWindow(DeregisterTaskFromMaintenanceWindowRequest.builder()
                .applyMutation(deregisterTaskFromMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the IAM role assigned to the instances in the activation, and the number of instances registered by using
     * this activation.
     * </p>
     *
     * @return Result of the DescribeActivations operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeActivations
     * @see #describeActivations(DescribeActivationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActivationsResponse describeActivations() throws InvalidFilterException, InvalidNextTokenException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeActivations(DescribeActivationsRequest.builder().build());
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the IAM role assigned to the instances in the activation, and the number of instances registered by using
     * this activation.
     * </p>
     *
     * @param describeActivationsRequest
     * @return Result of the DescribeActivations operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActivationsResponse describeActivations(DescribeActivationsRequest describeActivationsRequest)
            throws InvalidFilterException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the IAM role assigned to the instances in the activation, and the number of instances registered by using
     * this activation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActivationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActivationsRequest#builder()}
     * </p>
     *
     * @param describeActivationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActivationsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeActivations operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActivationsResponse describeActivations(
            Consumer<DescribeActivationsRequest.Builder> describeActivationsRequest) throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeActivations(DescribeActivationsRequest.builder().applyMutation(describeActivationsRequest).build());
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the IAM role assigned to the instances in the activation, and the number of instances registered by using
     * this activation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable responses = client.describeActivationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable responses = client
     *             .describeActivationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable responses = client.describeActivationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeActivations
     * @see #describeActivationsPaginator(DescribeActivationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActivationsIterable describeActivationsPaginator() throws InvalidFilterException, InvalidNextTokenException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeActivationsPaginator(DescribeActivationsRequest.builder().build());
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the IAM role assigned to the instances in the activation, and the number of instances registered by using
     * this activation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable responses = client.describeActivationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable responses = client
     *             .describeActivationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable responses = client.describeActivationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation.</b>
     * </p>
     *
     * @param describeActivationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActivationsIterable describeActivationsPaginator(DescribeActivationsRequest describeActivationsRequest)
            throws InvalidFilterException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the IAM role assigned to the instances in the activation, and the number of instances registered by using
     * this activation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable responses = client.describeActivationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable responses = client
     *             .describeActivationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable responses = client.describeActivationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActivationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActivationsRequest#builder()}
     * </p>
     *
     * @param describeActivationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActivationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActivationsIterable describeActivationsPaginator(
            Consumer<DescribeActivationsRequest.Builder> describeActivationsRequest) throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeActivationsPaginator(DescribeActivationsRequest.builder().applyMutation(describeActivationsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the association for the specified target or instance. If you created the association by using the
     * <code>Targets</code> parameter, then you must retrieve the association by using the association ID. If you
     * created the association by specifying an instance ID and a Systems Manager document, then you retrieve the
     * association by specifying the document name and the instance ID.
     * </p>
     *
     * @param describeAssociationRequest
     * @return Result of the DescribeAssociation operation returned by the service.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InvalidAssociationVersionException
     *         The version you specified is not valid. Use ListAssociationVersions to view all versions of an
     *         association according to the association ID. Or, use the <code>&#36LATEST</code> parameter to view the
     *         latest version of the association.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAssociationResponse describeAssociation(DescribeAssociationRequest describeAssociationRequest)
            throws AssociationDoesNotExistException, InvalidAssociationVersionException, InternalServerErrorException,
            InvalidDocumentException, InvalidInstanceIdException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the association for the specified target or instance. If you created the association by using the
     * <code>Targets</code> parameter, then you must retrieve the association by using the association ID. If you
     * created the association by specifying an instance ID and a Systems Manager document, then you retrieve the
     * association by specifying the document name and the instance ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssociationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAssociationRequest#builder()}
     * </p>
     *
     * @param describeAssociationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAssociation operation returned by the service.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InvalidAssociationVersionException
     *         The version you specified is not valid. Use ListAssociationVersions to view all versions of an
     *         association according to the association ID. Or, use the <code>&#36LATEST</code> parameter to view the
     *         latest version of the association.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeAssociationResponse describeAssociation(
            Consumer<DescribeAssociationRequest.Builder> describeAssociationRequest) throws AssociationDoesNotExistException,
            InvalidAssociationVersionException, InternalServerErrorException, InvalidDocumentException,
            InvalidInstanceIdException, AwsServiceException, SdkClientException, SsmException {
        return describeAssociation(DescribeAssociationRequest.builder().applyMutation(describeAssociationRequest).build());
    }

    /**
     * <p>
     * Use this API action to view information about a specific execution of a specific association.
     * </p>
     *
     * @param describeAssociationExecutionTargetsRequest
     * @return Result of the DescribeAssociationExecutionTargets operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws AssociationExecutionDoesNotExistException
     *         The specified execution ID does not exist. Verify the ID number and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociationExecutionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssociationExecutionTargetsResponse describeAssociationExecutionTargets(
            DescribeAssociationExecutionTargetsRequest describeAssociationExecutionTargetsRequest)
            throws InternalServerErrorException, AssociationDoesNotExistException, InvalidNextTokenException,
            AssociationExecutionDoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this API action to view information about a specific execution of a specific association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssociationExecutionTargetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAssociationExecutionTargetsRequest#builder()}
     * </p>
     *
     * @param describeAssociationExecutionTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssociationExecutionTargetsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAssociationExecutionTargets operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws AssociationExecutionDoesNotExistException
     *         The specified execution ID does not exist. Verify the ID number and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociationExecutionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssociationExecutionTargetsResponse describeAssociationExecutionTargets(
            Consumer<DescribeAssociationExecutionTargetsRequest.Builder> describeAssociationExecutionTargetsRequest)
            throws InternalServerErrorException, AssociationDoesNotExistException, InvalidNextTokenException,
            AssociationExecutionDoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        return describeAssociationExecutionTargets(DescribeAssociationExecutionTargetsRequest.builder()
                .applyMutation(describeAssociationExecutionTargetsRequest).build());
    }

    /**
     * <p>
     * Use this API action to view information about a specific execution of a specific association.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAssociationExecutionTargets(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsIterable responses = client.describeAssociationExecutionTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsIterable responses = client
     *             .describeAssociationExecutionTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsIterable responses = client.describeAssociationExecutionTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAssociationExecutionTargets(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAssociationExecutionTargetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws AssociationExecutionDoesNotExistException
     *         The specified execution ID does not exist. Verify the ID number and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociationExecutionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssociationExecutionTargetsIterable describeAssociationExecutionTargetsPaginator(
            DescribeAssociationExecutionTargetsRequest describeAssociationExecutionTargetsRequest)
            throws InternalServerErrorException, AssociationDoesNotExistException, InvalidNextTokenException,
            AssociationExecutionDoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this API action to view information about a specific execution of a specific association.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAssociationExecutionTargets(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsIterable responses = client.describeAssociationExecutionTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsIterable responses = client
     *             .describeAssociationExecutionTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsIterable responses = client.describeAssociationExecutionTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAssociationExecutionTargets(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssociationExecutionTargetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAssociationExecutionTargetsRequest#builder()}
     * </p>
     *
     * @param describeAssociationExecutionTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssociationExecutionTargetsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws AssociationExecutionDoesNotExistException
     *         The specified execution ID does not exist. Verify the ID number and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociationExecutionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssociationExecutionTargetsIterable describeAssociationExecutionTargetsPaginator(
            Consumer<DescribeAssociationExecutionTargetsRequest.Builder> describeAssociationExecutionTargetsRequest)
            throws InternalServerErrorException, AssociationDoesNotExistException, InvalidNextTokenException,
            AssociationExecutionDoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        return describeAssociationExecutionTargetsPaginator(DescribeAssociationExecutionTargetsRequest.builder()
                .applyMutation(describeAssociationExecutionTargetsRequest).build());
    }

    /**
     * <p>
     * Use this API action to view all executions for a specific association ID.
     * </p>
     *
     * @param describeAssociationExecutionsRequest
     * @return Result of the DescribeAssociationExecutions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssociationExecutionsResponse describeAssociationExecutions(
            DescribeAssociationExecutionsRequest describeAssociationExecutionsRequest) throws InternalServerErrorException,
            AssociationDoesNotExistException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this API action to view all executions for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssociationExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAssociationExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAssociationExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssociationExecutionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAssociationExecutions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssociationExecutionsResponse describeAssociationExecutions(
            Consumer<DescribeAssociationExecutionsRequest.Builder> describeAssociationExecutionsRequest)
            throws InternalServerErrorException, AssociationDoesNotExistException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return describeAssociationExecutions(DescribeAssociationExecutionsRequest.builder()
                .applyMutation(describeAssociationExecutionsRequest).build());
    }

    /**
     * <p>
     * Use this API action to view all executions for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAssociationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsIterable responses = client.describeAssociationExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsIterable responses = client
     *             .describeAssociationExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsIterable responses = client.describeAssociationExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAssociationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAssociationExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssociationExecutionsIterable describeAssociationExecutionsPaginator(
            DescribeAssociationExecutionsRequest describeAssociationExecutionsRequest) throws InternalServerErrorException,
            AssociationDoesNotExistException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this API action to view all executions for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAssociationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsIterable responses = client.describeAssociationExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsIterable responses = client
     *             .describeAssociationExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsIterable responses = client.describeAssociationExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAssociationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssociationExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAssociationExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAssociationExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssociationExecutionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssociationExecutionsIterable describeAssociationExecutionsPaginator(
            Consumer<DescribeAssociationExecutionsRequest.Builder> describeAssociationExecutionsRequest)
            throws InternalServerErrorException, AssociationDoesNotExistException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return describeAssociationExecutionsPaginator(DescribeAssociationExecutionsRequest.builder()
                .applyMutation(describeAssociationExecutionsRequest).build());
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     *
     * @return Result of the DescribeAutomationExecutions operation returned by the service.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationExecutions
     * @see #describeAutomationExecutions(DescribeAutomationExecutionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationExecutionsResponse describeAutomationExecutions() throws InvalidFilterKeyException,
            InvalidFilterValueException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        return describeAutomationExecutions(DescribeAutomationExecutionsRequest.builder().build());
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     * @return Result of the DescribeAutomationExecutions operation returned by the service.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationExecutionsResponse describeAutomationExecutions(
            DescribeAutomationExecutionsRequest describeAutomationExecutionsRequest) throws InvalidFilterKeyException,
            InvalidFilterValueException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutomationExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutomationExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAutomationExecutionsRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeAutomationExecutions operation returned by the service.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationExecutionsResponse describeAutomationExecutions(
            Consumer<DescribeAutomationExecutionsRequest.Builder> describeAutomationExecutionsRequest)
            throws InvalidFilterKeyException, InvalidFilterValueException, InvalidNextTokenException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeAutomationExecutions(DescribeAutomationExecutionsRequest.builder()
                .applyMutation(describeAutomationExecutionsRequest).build());
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable responses = client.describeAutomationExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable responses = client
     *             .describeAutomationExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable responses = client.describeAutomationExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationExecutions
     * @see #describeAutomationExecutionsPaginator(DescribeAutomationExecutionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationExecutionsIterable describeAutomationExecutionsPaginator() throws InvalidFilterKeyException,
            InvalidFilterValueException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        return describeAutomationExecutionsPaginator(DescribeAutomationExecutionsRequest.builder().build());
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable responses = client.describeAutomationExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable responses = client
     *             .describeAutomationExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable responses = client.describeAutomationExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationExecutionsIterable describeAutomationExecutionsPaginator(
            DescribeAutomationExecutionsRequest describeAutomationExecutionsRequest) throws InvalidFilterKeyException,
            InvalidFilterValueException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable responses = client.describeAutomationExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable responses = client
     *             .describeAutomationExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable responses = client.describeAutomationExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutomationExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutomationExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAutomationExecutionsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationExecutionsIterable describeAutomationExecutionsPaginator(
            Consumer<DescribeAutomationExecutionsRequest.Builder> describeAutomationExecutionsRequest)
            throws InvalidFilterKeyException, InvalidFilterValueException, InvalidNextTokenException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeAutomationExecutionsPaginator(DescribeAutomationExecutionsRequest.builder()
                .applyMutation(describeAutomationExecutionsRequest).build());
    }

    /**
     * <p>
     * Information about all active and terminated step executions in an Automation workflow.
     * </p>
     *
     * @param describeAutomationStepExecutionsRequest
     * @return Result of the DescribeAutomationStepExecutions operation returned by the service.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationStepExecutionsResponse describeAutomationStepExecutions(
            DescribeAutomationStepExecutionsRequest describeAutomationStepExecutionsRequest)
            throws AutomationExecutionNotFoundException, InvalidNextTokenException, InvalidFilterKeyException,
            InvalidFilterValueException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information about all active and terminated step executions in an Automation workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutomationStepExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutomationStepExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAutomationStepExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAutomationStepExecutionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeAutomationStepExecutions operation returned by the service.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationStepExecutionsResponse describeAutomationStepExecutions(
            Consumer<DescribeAutomationStepExecutionsRequest.Builder> describeAutomationStepExecutionsRequest)
            throws AutomationExecutionNotFoundException, InvalidNextTokenException, InvalidFilterKeyException,
            InvalidFilterValueException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeAutomationStepExecutions(DescribeAutomationStepExecutionsRequest.builder()
                .applyMutation(describeAutomationStepExecutionsRequest).build());
    }

    /**
     * <p>
     * Information about all active and terminated step executions in an Automation workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationStepExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsIterable responses = client.describeAutomationStepExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsIterable responses = client
     *             .describeAutomationStepExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsIterable responses = client.describeAutomationStepExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationStepExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutomationStepExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationStepExecutionsIterable describeAutomationStepExecutionsPaginator(
            DescribeAutomationStepExecutionsRequest describeAutomationStepExecutionsRequest)
            throws AutomationExecutionNotFoundException, InvalidNextTokenException, InvalidFilterKeyException,
            InvalidFilterValueException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information about all active and terminated step executions in an Automation workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationStepExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsIterable responses = client.describeAutomationStepExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsIterable responses = client
     *             .describeAutomationStepExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsIterable responses = client.describeAutomationStepExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationStepExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutomationStepExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutomationStepExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAutomationStepExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAutomationStepExecutionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationStepExecutionsIterable describeAutomationStepExecutionsPaginator(
            Consumer<DescribeAutomationStepExecutionsRequest.Builder> describeAutomationStepExecutionsRequest)
            throws AutomationExecutionNotFoundException, InvalidNextTokenException, InvalidFilterKeyException,
            InvalidFilterValueException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeAutomationStepExecutionsPaginator(DescribeAutomationStepExecutionsRequest.builder()
                .applyMutation(describeAutomationStepExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     *
     * @return Result of the DescribeAvailablePatches operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAvailablePatches
     * @see #describeAvailablePatches(DescribeAvailablePatchesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAvailablePatchesResponse describeAvailablePatches() throws InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        return describeAvailablePatches(DescribeAvailablePatchesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     *
     * @param describeAvailablePatchesRequest
     * @return Result of the DescribeAvailablePatches operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAvailablePatchesResponse describeAvailablePatches(
            DescribeAvailablePatchesRequest describeAvailablePatchesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAvailablePatchesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAvailablePatchesRequest#builder()}
     * </p>
     *
     * @param describeAvailablePatchesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAvailablePatchesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeAvailablePatches operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAvailablePatchesResponse describeAvailablePatches(
            Consumer<DescribeAvailablePatchesRequest.Builder> describeAvailablePatchesRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeAvailablePatches(DescribeAvailablePatchesRequest.builder().applyMutation(describeAvailablePatchesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable responses = client.describeAvailablePatchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable responses = client
     *             .describeAvailablePatchesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable responses = client.describeAvailablePatchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAvailablePatches
     * @see #describeAvailablePatchesPaginator(DescribeAvailablePatchesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAvailablePatchesIterable describeAvailablePatchesPaginator() throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return describeAvailablePatchesPaginator(DescribeAvailablePatchesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable responses = client.describeAvailablePatchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable responses = client
     *             .describeAvailablePatchesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable responses = client.describeAvailablePatchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAvailablePatchesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAvailablePatchesIterable describeAvailablePatchesPaginator(
            DescribeAvailablePatchesRequest describeAvailablePatchesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable responses = client.describeAvailablePatchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable responses = client
     *             .describeAvailablePatchesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable responses = client.describeAvailablePatchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAvailablePatchesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAvailablePatchesRequest#builder()}
     * </p>
     *
     * @param describeAvailablePatchesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAvailablePatchesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAvailablePatchesIterable describeAvailablePatchesPaginator(
            Consumer<DescribeAvailablePatchesRequest.Builder> describeAvailablePatchesRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeAvailablePatchesPaginator(DescribeAvailablePatchesRequest.builder()
                .applyMutation(describeAvailablePatchesRequest).build());
    }

    /**
     * <p>
     * Describes the specified Systems Manager document.
     * </p>
     *
     * @param describeDocumentRequest
     * @return Result of the DescribeDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDocumentResponse describeDocument(DescribeDocumentRequest describeDocumentRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentVersionException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Systems Manager document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDocumentRequest#builder()}
     * </p>
     *
     * @param describeDocumentRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDocumentRequest.Builder} to create a request.
     * @return Result of the DescribeDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeDocumentResponse describeDocument(Consumer<DescribeDocumentRequest.Builder> describeDocumentRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentVersionException, AwsServiceException,
            SdkClientException, SsmException {
        return describeDocument(DescribeDocumentRequest.builder().applyMutation(describeDocumentRequest).build());
    }

    /**
     * <p>
     * Describes the permissions for a Systems Manager document. If you created the document, you are the owner. If a
     * document is shared, it can either be shared privately (by specifying a user's AWS account ID) or publicly
     * (<i>All</i>).
     * </p>
     *
     * @param describeDocumentPermissionRequest
     * @return Result of the DescribeDocumentPermission operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidPermissionTypeException
     *         The permission type is not supported. <i>Share</i> is the only supported permission type.
     * @throws InvalidDocumentOperationException
     *         You attempted to delete a document while it is still shared. You must stop sharing the document before
     *         you can delete it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeDocumentPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentPermissionResponse describeDocumentPermission(
            DescribeDocumentPermissionRequest describeDocumentPermissionRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidNextTokenException, InvalidPermissionTypeException,
            InvalidDocumentOperationException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the permissions for a Systems Manager document. If you created the document, you are the owner. If a
     * document is shared, it can either be shared privately (by specifying a user's AWS account ID) or publicly
     * (<i>All</i>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentPermissionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDocumentPermissionRequest#builder()}
     * </p>
     *
     * @param describeDocumentPermissionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDocumentPermissionRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDocumentPermission operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidPermissionTypeException
     *         The permission type is not supported. <i>Share</i> is the only supported permission type.
     * @throws InvalidDocumentOperationException
     *         You attempted to delete a document while it is still shared. You must stop sharing the document before
     *         you can delete it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeDocumentPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDocumentPermissionResponse describeDocumentPermission(
            Consumer<DescribeDocumentPermissionRequest.Builder> describeDocumentPermissionRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidNextTokenException,
            InvalidPermissionTypeException, InvalidDocumentOperationException, AwsServiceException, SdkClientException,
            SsmException {
        return describeDocumentPermission(DescribeDocumentPermissionRequest.builder()
                .applyMutation(describeDocumentPermissionRequest).build());
    }

    /**
     * <p>
     * All associations for the instance(s).
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     * @return Result of the DescribeEffectiveInstanceAssociations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeEffectiveInstanceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEffectiveInstanceAssociationsResponse describeEffectiveInstanceAssociations(
            DescribeEffectiveInstanceAssociationsRequest describeEffectiveInstanceAssociationsRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * All associations for the instance(s).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEffectiveInstanceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEffectiveInstanceAssociationsRequest#builder()}
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEffectiveInstanceAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeEffectiveInstanceAssociations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeEffectiveInstanceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEffectiveInstanceAssociationsResponse describeEffectiveInstanceAssociations(
            Consumer<DescribeEffectiveInstanceAssociationsRequest.Builder> describeEffectiveInstanceAssociationsRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeEffectiveInstanceAssociations(DescribeEffectiveInstanceAssociationsRequest.builder()
                .applyMutation(describeEffectiveInstanceAssociationsRequest).build());
    }

    /**
     * <p>
     * All associations for the instance(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEffectiveInstanceAssociations(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsIterable responses = client.describeEffectiveInstanceAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsIterable responses = client
     *             .describeEffectiveInstanceAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsIterable responses = client.describeEffectiveInstanceAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEffectiveInstanceAssociations(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeEffectiveInstanceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEffectiveInstanceAssociationsIterable describeEffectiveInstanceAssociationsPaginator(
            DescribeEffectiveInstanceAssociationsRequest describeEffectiveInstanceAssociationsRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * All associations for the instance(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEffectiveInstanceAssociations(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsIterable responses = client.describeEffectiveInstanceAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsIterable responses = client
     *             .describeEffectiveInstanceAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsIterable responses = client.describeEffectiveInstanceAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEffectiveInstanceAssociations(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEffectiveInstanceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEffectiveInstanceAssociationsRequest#builder()}
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEffectiveInstanceAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeEffectiveInstanceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEffectiveInstanceAssociationsIterable describeEffectiveInstanceAssociationsPaginator(
            Consumer<DescribeEffectiveInstanceAssociationsRequest.Builder> describeEffectiveInstanceAssociationsRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeEffectiveInstanceAssociationsPaginator(DescribeEffectiveInstanceAssociationsRequest.builder()
                .applyMutation(describeEffectiveInstanceAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Note
     * that this API applies only to Windows patch baselines.
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     * @return Result of the DescribeEffectivePatchesForPatchBaseline operation returned by the service.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws UnsupportedOperatingSystemException
     *         The operating systems you specified is not supported, or the operation is not supported for the operating
     *         system.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEffectivePatchesForPatchBaselineResponse describeEffectivePatchesForPatchBaseline(
            DescribeEffectivePatchesForPatchBaselineRequest describeEffectivePatchesForPatchBaselineRequest)
            throws InvalidResourceIdException, DoesNotExistException, UnsupportedOperatingSystemException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Note
     * that this API applies only to Windows patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEffectivePatchesForPatchBaselineRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEffectivePatchesForPatchBaselineRequest#builder()}
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeEffectivePatchesForPatchBaselineRequest.Builder} to create a request.
     * @return Result of the DescribeEffectivePatchesForPatchBaseline operation returned by the service.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws UnsupportedOperatingSystemException
     *         The operating systems you specified is not supported, or the operation is not supported for the operating
     *         system.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEffectivePatchesForPatchBaselineResponse describeEffectivePatchesForPatchBaseline(
            Consumer<DescribeEffectivePatchesForPatchBaselineRequest.Builder> describeEffectivePatchesForPatchBaselineRequest)
            throws InvalidResourceIdException, DoesNotExistException, UnsupportedOperatingSystemException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeEffectivePatchesForPatchBaseline(DescribeEffectivePatchesForPatchBaselineRequest.builder()
                .applyMutation(describeEffectivePatchesForPatchBaselineRequest).build());
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Note
     * that this API applies only to Windows patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEffectivePatchesForPatchBaseline(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselineIterable responses = client.describeEffectivePatchesForPatchBaselinePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselineIterable responses = client
     *             .describeEffectivePatchesForPatchBaselinePaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselineIterable responses = client.describeEffectivePatchesForPatchBaselinePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEffectivePatchesForPatchBaseline(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws UnsupportedOperatingSystemException
     *         The operating systems you specified is not supported, or the operation is not supported for the operating
     *         system.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEffectivePatchesForPatchBaselineIterable describeEffectivePatchesForPatchBaselinePaginator(
            DescribeEffectivePatchesForPatchBaselineRequest describeEffectivePatchesForPatchBaselineRequest)
            throws InvalidResourceIdException, DoesNotExistException, UnsupportedOperatingSystemException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Note
     * that this API applies only to Windows patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEffectivePatchesForPatchBaseline(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselineIterable responses = client.describeEffectivePatchesForPatchBaselinePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselineIterable responses = client
     *             .describeEffectivePatchesForPatchBaselinePaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselineIterable responses = client.describeEffectivePatchesForPatchBaselinePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEffectivePatchesForPatchBaseline(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEffectivePatchesForPatchBaselineRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEffectivePatchesForPatchBaselineRequest#builder()}
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeEffectivePatchesForPatchBaselineRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws UnsupportedOperatingSystemException
     *         The operating systems you specified is not supported, or the operation is not supported for the operating
     *         system.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEffectivePatchesForPatchBaselineIterable describeEffectivePatchesForPatchBaselinePaginator(
            Consumer<DescribeEffectivePatchesForPatchBaselineRequest.Builder> describeEffectivePatchesForPatchBaselineRequest)
            throws InvalidResourceIdException, DoesNotExistException, UnsupportedOperatingSystemException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeEffectivePatchesForPatchBaselinePaginator(DescribeEffectivePatchesForPatchBaselineRequest.builder()
                .applyMutation(describeEffectivePatchesForPatchBaselineRequest).build());
    }

    /**
     * <p>
     * The status of the associations for the instance(s).
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     * @return Result of the DescribeInstanceAssociationsStatus operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceAssociationsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceAssociationsStatusResponse describeInstanceAssociationsStatus(
            DescribeInstanceAssociationsStatusRequest describeInstanceAssociationsStatusRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The status of the associations for the instance(s).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceAssociationsStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceAssociationsStatusRequest#builder()}
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstanceAssociationsStatusRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeInstanceAssociationsStatus operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceAssociationsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceAssociationsStatusResponse describeInstanceAssociationsStatus(
            Consumer<DescribeInstanceAssociationsStatusRequest.Builder> describeInstanceAssociationsStatusRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeInstanceAssociationsStatus(DescribeInstanceAssociationsStatusRequest.builder()
                .applyMutation(describeInstanceAssociationsStatusRequest).build());
    }

    /**
     * <p>
     * The status of the associations for the instance(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceAssociationsStatus(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusIterable responses = client.describeInstanceAssociationsStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusIterable responses = client
     *             .describeInstanceAssociationsStatusPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusIterable responses = client.describeInstanceAssociationsStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceAssociationsStatus(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceAssociationsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceAssociationsStatusIterable describeInstanceAssociationsStatusPaginator(
            DescribeInstanceAssociationsStatusRequest describeInstanceAssociationsStatusRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The status of the associations for the instance(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceAssociationsStatus(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusIterable responses = client.describeInstanceAssociationsStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusIterable responses = client
     *             .describeInstanceAssociationsStatusPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusIterable responses = client.describeInstanceAssociationsStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceAssociationsStatus(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceAssociationsStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceAssociationsStatusRequest#builder()}
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstanceAssociationsStatusRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceAssociationsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceAssociationsStatusIterable describeInstanceAssociationsStatusPaginator(
            Consumer<DescribeInstanceAssociationsStatusRequest.Builder> describeInstanceAssociationsStatusRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeInstanceAssociationsStatusPaginator(DescribeInstanceAssociationsStatusRequest.builder()
                .applyMutation(describeInstanceAssociationsStatusRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your instances, including information about the operating system platform, the version
     * of SSM Agent installed on the instance, instance status, and so on.
     * </p>
     * <p>
     * If you specify one or more instance IDs, it returns information for those instances. If you do not specify
     * instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or
     * an instance that you do not own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to
     * on-premises instances. This call does not return the IAM role for EC2 instances.
     * </p>
     * </note>
     *
     * @return Result of the DescribeInstanceInformation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidInstanceInformationFilterValueException
     *         The specified filter value is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceInformation
     * @see #describeInstanceInformation(DescribeInstanceInformationRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceInformationResponse describeInstanceInformation() throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidNextTokenException, InvalidInstanceInformationFilterValueException,
            InvalidFilterKeyException, AwsServiceException, SdkClientException, SsmException {
        return describeInstanceInformation(DescribeInstanceInformationRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more of your instances, including information about the operating system platform, the version
     * of SSM Agent installed on the instance, instance status, and so on.
     * </p>
     * <p>
     * If you specify one or more instance IDs, it returns information for those instances. If you do not specify
     * instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or
     * an instance that you do not own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to
     * on-premises instances. This call does not return the IAM role for EC2 instances.
     * </p>
     * </note>
     *
     * @param describeInstanceInformationRequest
     * @return Result of the DescribeInstanceInformation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidInstanceInformationFilterValueException
     *         The specified filter value is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceInformationResponse describeInstanceInformation(
            DescribeInstanceInformationRequest describeInstanceInformationRequest) throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidNextTokenException, InvalidInstanceInformationFilterValueException,
            InvalidFilterKeyException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your instances, including information about the operating system platform, the version
     * of SSM Agent installed on the instance, instance status, and so on.
     * </p>
     * <p>
     * If you specify one or more instance IDs, it returns information for those instances. If you do not specify
     * instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or
     * an instance that you do not own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to
     * on-premises instances. This call does not return the IAM role for EC2 instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceInformationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceInformationRequest#builder()}
     * </p>
     *
     * @param describeInstanceInformationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstanceInformationRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeInstanceInformation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidInstanceInformationFilterValueException
     *         The specified filter value is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceInformationResponse describeInstanceInformation(
            Consumer<DescribeInstanceInformationRequest.Builder> describeInstanceInformationRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException,
            InvalidInstanceInformationFilterValueException, InvalidFilterKeyException, AwsServiceException, SdkClientException,
            SsmException {
        return describeInstanceInformation(DescribeInstanceInformationRequest.builder()
                .applyMutation(describeInstanceInformationRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your instances, including information about the operating system platform, the version
     * of SSM Agent installed on the instance, instance status, and so on.
     * </p>
     * <p>
     * If you specify one or more instance IDs, it returns information for those instances. If you do not specify
     * instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or
     * an instance that you do not own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to
     * on-premises instances. This call does not return the IAM role for EC2 instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable responses = client.describeInstanceInformationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable responses = client
     *             .describeInstanceInformationPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable responses = client.describeInstanceInformationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidInstanceInformationFilterValueException
     *         The specified filter value is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceInformation
     * @see #describeInstanceInformationPaginator(DescribeInstanceInformationRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceInformationIterable describeInstanceInformationPaginator() throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidNextTokenException, InvalidInstanceInformationFilterValueException,
            InvalidFilterKeyException, AwsServiceException, SdkClientException, SsmException {
        return describeInstanceInformationPaginator(DescribeInstanceInformationRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more of your instances, including information about the operating system platform, the version
     * of SSM Agent installed on the instance, instance status, and so on.
     * </p>
     * <p>
     * If you specify one or more instance IDs, it returns information for those instances. If you do not specify
     * instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or
     * an instance that you do not own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to
     * on-premises instances. This call does not return the IAM role for EC2 instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable responses = client.describeInstanceInformationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable responses = client
     *             .describeInstanceInformationPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable responses = client.describeInstanceInformationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceInformationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidInstanceInformationFilterValueException
     *         The specified filter value is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceInformationIterable describeInstanceInformationPaginator(
            DescribeInstanceInformationRequest describeInstanceInformationRequest) throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidNextTokenException, InvalidInstanceInformationFilterValueException,
            InvalidFilterKeyException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your instances, including information about the operating system platform, the version
     * of SSM Agent installed on the instance, instance status, and so on.
     * </p>
     * <p>
     * If you specify one or more instance IDs, it returns information for those instances. If you do not specify
     * instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or
     * an instance that you do not own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to
     * on-premises instances. This call does not return the IAM role for EC2 instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable responses = client.describeInstanceInformationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable responses = client
     *             .describeInstanceInformationPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable responses = client.describeInstanceInformationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceInformationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceInformationRequest#builder()}
     * </p>
     *
     * @param describeInstanceInformationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstanceInformationRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidInstanceInformationFilterValueException
     *         The specified filter value is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceInformationIterable describeInstanceInformationPaginator(
            Consumer<DescribeInstanceInformationRequest.Builder> describeInstanceInformationRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException,
            InvalidInstanceInformationFilterValueException, InvalidFilterKeyException, AwsServiceException, SdkClientException,
            SsmException {
        return describeInstanceInformationPaginator(DescribeInstanceInformationRequest.builder()
                .applyMutation(describeInstanceInformationRequest).build());
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more instances.
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     * @return Result of the DescribeInstancePatchStates operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatchStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancePatchStatesResponse describeInstancePatchStates(
            DescribeInstancePatchStatesRequest describeInstancePatchStatesRequest) throws InternalServerErrorException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancePatchStatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstancePatchStatesRequest#builder()}
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstancePatchStatesRequest.Builder} to create
     *        a request.
     * @return Result of the DescribeInstancePatchStates operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatchStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancePatchStatesResponse describeInstancePatchStates(
            Consumer<DescribeInstancePatchStatesRequest.Builder> describeInstancePatchStatesRequest)
            throws InternalServerErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return describeInstancePatchStates(DescribeInstancePatchStatesRequest.builder()
                .applyMutation(describeInstancePatchStatesRequest).build());
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatchStates(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesIterable responses = client.describeInstancePatchStatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesIterable responses = client
     *             .describeInstancePatchStatesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesIterable responses = client.describeInstancePatchStatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatchStates(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatchStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancePatchStatesIterable describeInstancePatchStatesPaginator(
            DescribeInstancePatchStatesRequest describeInstancePatchStatesRequest) throws InternalServerErrorException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatchStates(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesIterable responses = client.describeInstancePatchStatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesIterable responses = client
     *             .describeInstancePatchStatesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesIterable responses = client.describeInstancePatchStatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatchStates(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancePatchStatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstancePatchStatesRequest#builder()}
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstancePatchStatesRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatchStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancePatchStatesIterable describeInstancePatchStatesPaginator(
            Consumer<DescribeInstancePatchStatesRequest.Builder> describeInstancePatchStatesRequest)
            throws InternalServerErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return describeInstancePatchStatesPaginator(DescribeInstancePatchStatesRequest.builder()
                .applyMutation(describeInstancePatchStatesRequest).build());
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the instances in the specified patch group.
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     * @return Result of the DescribeInstancePatchStatesForPatchGroup operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancePatchStatesForPatchGroupResponse describeInstancePatchStatesForPatchGroup(
            DescribeInstancePatchStatesForPatchGroupRequest describeInstancePatchStatesForPatchGroupRequest)
            throws InternalServerErrorException, InvalidFilterException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the instances in the specified patch group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeInstancePatchStatesForPatchGroupRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeInstancePatchStatesForPatchGroupRequest#builder()}
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeInstancePatchStatesForPatchGroupRequest.Builder} to create a request.
     * @return Result of the DescribeInstancePatchStatesForPatchGroup operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancePatchStatesForPatchGroupResponse describeInstancePatchStatesForPatchGroup(
            Consumer<DescribeInstancePatchStatesForPatchGroupRequest.Builder> describeInstancePatchStatesForPatchGroupRequest)
            throws InternalServerErrorException, InvalidFilterException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeInstancePatchStatesForPatchGroup(DescribeInstancePatchStatesForPatchGroupRequest.builder()
                .applyMutation(describeInstancePatchStatesForPatchGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the instances in the specified patch group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatchStatesForPatchGroup(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupIterable responses = client.describeInstancePatchStatesForPatchGroupPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupIterable responses = client
     *             .describeInstancePatchStatesForPatchGroupPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupIterable responses = client.describeInstancePatchStatesForPatchGroupPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatchStatesForPatchGroup(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancePatchStatesForPatchGroupIterable describeInstancePatchStatesForPatchGroupPaginator(
            DescribeInstancePatchStatesForPatchGroupRequest describeInstancePatchStatesForPatchGroupRequest)
            throws InternalServerErrorException, InvalidFilterException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the instances in the specified patch group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatchStatesForPatchGroup(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupIterable responses = client.describeInstancePatchStatesForPatchGroupPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupIterable responses = client
     *             .describeInstancePatchStatesForPatchGroupPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupIterable responses = client.describeInstancePatchStatesForPatchGroupPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatchStatesForPatchGroup(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeInstancePatchStatesForPatchGroupRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeInstancePatchStatesForPatchGroupRequest#builder()}
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeInstancePatchStatesForPatchGroupRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancePatchStatesForPatchGroupIterable describeInstancePatchStatesForPatchGroupPaginator(
            Consumer<DescribeInstancePatchStatesForPatchGroupRequest.Builder> describeInstancePatchStatesForPatchGroupRequest)
            throws InternalServerErrorException, InvalidFilterException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeInstancePatchStatesForPatchGroupPaginator(DescribeInstancePatchStatesForPatchGroupRequest.builder()
                .applyMutation(describeInstancePatchStatesForPatchGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified instance and their state relative to the patch baseline
     * being used for the instance.
     * </p>
     *
     * @param describeInstancePatchesRequest
     * @return Result of the DescribeInstancePatches operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstancePatchesResponse describeInstancePatches(DescribeInstancePatchesRequest describeInstancePatchesRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidFilterException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified instance and their state relative to the patch baseline
     * being used for the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancePatchesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstancePatchesRequest#builder()}
     * </p>
     *
     * @param describeInstancePatchesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstancePatchesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeInstancePatches operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstancePatchesResponse describeInstancePatches(
            Consumer<DescribeInstancePatchesRequest.Builder> describeInstancePatchesRequest) throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidFilterException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeInstancePatches(DescribeInstancePatchesRequest.builder().applyMutation(describeInstancePatchesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified instance and their state relative to the patch baseline
     * being used for the instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatches(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesIterable responses = client.describeInstancePatchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesIterable responses = client
     *             .describeInstancePatchesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesIterable responses = client.describeInstancePatchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatches(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancePatchesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstancePatchesIterable describeInstancePatchesPaginator(
            DescribeInstancePatchesRequest describeInstancePatchesRequest) throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidFilterException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified instance and their state relative to the patch baseline
     * being used for the instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatches(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesIterable responses = client.describeInstancePatchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesIterable responses = client
     *             .describeInstancePatchesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesIterable responses = client.describeInstancePatchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatches(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancePatchesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstancePatchesRequest#builder()}
     * </p>
     *
     * @param describeInstancePatchesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstancePatchesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstancePatchesIterable describeInstancePatchesPaginator(
            Consumer<DescribeInstancePatchesRequest.Builder> describeInstancePatchesRequest) throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidFilterException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeInstancePatchesPaginator(DescribeInstancePatchesRequest.builder()
                .applyMutation(describeInstancePatchesRequest).build());
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     *
     * @return Result of the DescribeInventoryDeletions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDeletionIdException
     *         The ID specified for the delete operation does not exist or is not valid. Verify the ID and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInventoryDeletions
     * @see #describeInventoryDeletions(DescribeInventoryDeletionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInventoryDeletionsResponse describeInventoryDeletions() throws InternalServerErrorException,
            InvalidDeletionIdException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return describeInventoryDeletions(DescribeInventoryDeletionsRequest.builder().build());
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     *
     * @param describeInventoryDeletionsRequest
     * @return Result of the DescribeInventoryDeletions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDeletionIdException
     *         The ID specified for the delete operation does not exist or is not valid. Verify the ID and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInventoryDeletionsResponse describeInventoryDeletions(
            DescribeInventoryDeletionsRequest describeInventoryDeletionsRequest) throws InternalServerErrorException,
            InvalidDeletionIdException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInventoryDeletionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInventoryDeletionsRequest#builder()}
     * </p>
     *
     * @param describeInventoryDeletionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInventoryDeletionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeInventoryDeletions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDeletionIdException
     *         The ID specified for the delete operation does not exist or is not valid. Verify the ID and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInventoryDeletionsResponse describeInventoryDeletions(
            Consumer<DescribeInventoryDeletionsRequest.Builder> describeInventoryDeletionsRequest)
            throws InternalServerErrorException, InvalidDeletionIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeInventoryDeletions(DescribeInventoryDeletionsRequest.builder()
                .applyMutation(describeInventoryDeletionsRequest).build());
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable responses = client.describeInventoryDeletionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable responses = client
     *             .describeInventoryDeletionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable responses = client.describeInventoryDeletionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDeletionIdException
     *         The ID specified for the delete operation does not exist or is not valid. Verify the ID and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInventoryDeletions
     * @see #describeInventoryDeletionsPaginator(DescribeInventoryDeletionsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInventoryDeletionsIterable describeInventoryDeletionsPaginator() throws InternalServerErrorException,
            InvalidDeletionIdException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return describeInventoryDeletionsPaginator(DescribeInventoryDeletionsRequest.builder().build());
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable responses = client.describeInventoryDeletionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable responses = client
     *             .describeInventoryDeletionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable responses = client.describeInventoryDeletionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInventoryDeletionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDeletionIdException
     *         The ID specified for the delete operation does not exist or is not valid. Verify the ID and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInventoryDeletionsIterable describeInventoryDeletionsPaginator(
            DescribeInventoryDeletionsRequest describeInventoryDeletionsRequest) throws InternalServerErrorException,
            InvalidDeletionIdException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable responses = client.describeInventoryDeletionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable responses = client
     *             .describeInventoryDeletionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable responses = client.describeInventoryDeletionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInventoryDeletionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInventoryDeletionsRequest#builder()}
     * </p>
     *
     * @param describeInventoryDeletionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInventoryDeletionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDeletionIdException
     *         The ID specified for the delete operation does not exist or is not valid. Verify the ID and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInventoryDeletionsIterable describeInventoryDeletionsPaginator(
            Consumer<DescribeInventoryDeletionsRequest.Builder> describeInventoryDeletionsRequest)
            throws InternalServerErrorException, InvalidDeletionIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeInventoryDeletionsPaginator(DescribeInventoryDeletionsRequest.builder()
                .applyMutation(describeInventoryDeletionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance
     * window execution.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     * @return Result of the DescribeMaintenanceWindowExecutionTaskInvocations operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionTaskInvocationsResponse describeMaintenanceWindowExecutionTaskInvocations(
            DescribeMaintenanceWindowExecutionTaskInvocationsRequest describeMaintenanceWindowExecutionTaskInvocationsRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance
     * window execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder} avoiding the need to create one manually
     * via {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder} to create a request.
     * @return Result of the DescribeMaintenanceWindowExecutionTaskInvocations operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionTaskInvocationsResponse describeMaintenanceWindowExecutionTaskInvocations(
            Consumer<DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder> describeMaintenanceWindowExecutionTaskInvocationsRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowExecutionTaskInvocations(DescribeMaintenanceWindowExecutionTaskInvocationsRequest
                .builder().applyMutation(describeMaintenanceWindowExecutionTaskInvocationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance
     * window execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutionTaskInvocations(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsIterable responses = client.describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsIterable responses = client
     *             .describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsIterable responses = client.describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutionTaskInvocations(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionTaskInvocationsIterable describeMaintenanceWindowExecutionTaskInvocationsPaginator(
            DescribeMaintenanceWindowExecutionTaskInvocationsRequest describeMaintenanceWindowExecutionTaskInvocationsRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance
     * window execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutionTaskInvocations(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsIterable responses = client.describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsIterable responses = client
     *             .describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsIterable responses = client.describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutionTaskInvocations(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder} avoiding the need to create one manually
     * via {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionTaskInvocationsIterable describeMaintenanceWindowExecutionTaskInvocationsPaginator(
            Consumer<DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder> describeMaintenanceWindowExecutionTaskInvocationsRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowExecutionTaskInvocationsPaginator(DescribeMaintenanceWindowExecutionTaskInvocationsRequest
                .builder().applyMutation(describeMaintenanceWindowExecutionTaskInvocationsRequest).build());
    }

    /**
     * <p>
     * For a given maintenance window execution, lists the tasks that were run.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     * @return Result of the DescribeMaintenanceWindowExecutionTasks operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionTasksResponse describeMaintenanceWindowExecutionTasks(
            DescribeMaintenanceWindowExecutionTasksRequest describeMaintenanceWindowExecutionTasksRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given maintenance window execution, lists the tasks that were run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMaintenanceWindowExecutionTasksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMaintenanceWindowExecutionTasksRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeMaintenanceWindowExecutionTasksRequest.Builder} to create a request.
     * @return Result of the DescribeMaintenanceWindowExecutionTasks operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionTasksResponse describeMaintenanceWindowExecutionTasks(
            Consumer<DescribeMaintenanceWindowExecutionTasksRequest.Builder> describeMaintenanceWindowExecutionTasksRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowExecutionTasks(DescribeMaintenanceWindowExecutionTasksRequest.builder()
                .applyMutation(describeMaintenanceWindowExecutionTasksRequest).build());
    }

    /**
     * <p>
     * For a given maintenance window execution, lists the tasks that were run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutionTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksIterable responses = client.describeMaintenanceWindowExecutionTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksIterable responses = client
     *             .describeMaintenanceWindowExecutionTasksPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksIterable responses = client.describeMaintenanceWindowExecutionTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutionTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionTasksIterable describeMaintenanceWindowExecutionTasksPaginator(
            DescribeMaintenanceWindowExecutionTasksRequest describeMaintenanceWindowExecutionTasksRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given maintenance window execution, lists the tasks that were run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutionTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksIterable responses = client.describeMaintenanceWindowExecutionTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksIterable responses = client
     *             .describeMaintenanceWindowExecutionTasksPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksIterable responses = client.describeMaintenanceWindowExecutionTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutionTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMaintenanceWindowExecutionTasksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMaintenanceWindowExecutionTasksRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeMaintenanceWindowExecutionTasksRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionTasksIterable describeMaintenanceWindowExecutionTasksPaginator(
            Consumer<DescribeMaintenanceWindowExecutionTasksRequest.Builder> describeMaintenanceWindowExecutionTasksRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowExecutionTasksPaginator(DescribeMaintenanceWindowExecutionTasksRequest.builder()
                .applyMutation(describeMaintenanceWindowExecutionTasksRequest).build());
    }

    /**
     * <p>
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was
     * scheduled to be active, and information about tasks registered and run with the maintenance window.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     * @return Result of the DescribeMaintenanceWindowExecutions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionsResponse describeMaintenanceWindowExecutions(
            DescribeMaintenanceWindowExecutionsRequest describeMaintenanceWindowExecutionsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was
     * scheduled to be active, and information about tasks registered and run with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowExecutionsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowExecutionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeMaintenanceWindowExecutions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionsResponse describeMaintenanceWindowExecutions(
            Consumer<DescribeMaintenanceWindowExecutionsRequest.Builder> describeMaintenanceWindowExecutionsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowExecutions(DescribeMaintenanceWindowExecutionsRequest.builder()
                .applyMutation(describeMaintenanceWindowExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was
     * scheduled to be active, and information about tasks registered and run with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutions(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsIterable responses = client.describeMaintenanceWindowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsIterable responses = client
     *             .describeMaintenanceWindowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsIterable responses = client.describeMaintenanceWindowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutions(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionsIterable describeMaintenanceWindowExecutionsPaginator(
            DescribeMaintenanceWindowExecutionsRequest describeMaintenanceWindowExecutionsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was
     * scheduled to be active, and information about tasks registered and run with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutions(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsIterable responses = client.describeMaintenanceWindowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsIterable responses = client
     *             .describeMaintenanceWindowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsIterable responses = client.describeMaintenanceWindowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutions(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowExecutionsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowExecutionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionsIterable describeMaintenanceWindowExecutionsPaginator(
            Consumer<DescribeMaintenanceWindowExecutionsRequest.Builder> describeMaintenanceWindowExecutionsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowExecutionsPaginator(DescribeMaintenanceWindowExecutionsRequest.builder()
                .applyMutation(describeMaintenanceWindowExecutionsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about upcoming executions of a maintenance window.
     * </p>
     *
     * @param describeMaintenanceWindowScheduleRequest
     * @return Result of the DescribeMaintenanceWindowSchedule operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowScheduleResponse describeMaintenanceWindowSchedule(
            DescribeMaintenanceWindowScheduleRequest describeMaintenanceWindowScheduleRequest)
            throws InternalServerErrorException, DoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about upcoming executions of a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowScheduleRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowScheduleRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeMaintenanceWindowSchedule operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowScheduleResponse describeMaintenanceWindowSchedule(
            Consumer<DescribeMaintenanceWindowScheduleRequest.Builder> describeMaintenanceWindowScheduleRequest)
            throws InternalServerErrorException, DoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowSchedule(DescribeMaintenanceWindowScheduleRequest.builder()
                .applyMutation(describeMaintenanceWindowScheduleRequest).build());
    }

    /**
     * <p>
     * Retrieves information about upcoming executions of a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowSchedule(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowScheduleIterable responses = client.describeMaintenanceWindowSchedulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowScheduleIterable responses = client
     *             .describeMaintenanceWindowSchedulePaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowScheduleIterable responses = client.describeMaintenanceWindowSchedulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowSchedule(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowScheduleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowScheduleIterable describeMaintenanceWindowSchedulePaginator(
            DescribeMaintenanceWindowScheduleRequest describeMaintenanceWindowScheduleRequest)
            throws InternalServerErrorException, DoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about upcoming executions of a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowSchedule(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowScheduleIterable responses = client.describeMaintenanceWindowSchedulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowScheduleIterable responses = client
     *             .describeMaintenanceWindowSchedulePaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowScheduleIterable responses = client.describeMaintenanceWindowSchedulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowSchedule(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowScheduleRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowScheduleRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowScheduleIterable describeMaintenanceWindowSchedulePaginator(
            Consumer<DescribeMaintenanceWindowScheduleRequest.Builder> describeMaintenanceWindowScheduleRequest)
            throws InternalServerErrorException, DoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowSchedulePaginator(DescribeMaintenanceWindowScheduleRequest.builder()
                .applyMutation(describeMaintenanceWindowScheduleRequest).build());
    }

    /**
     * <p>
     * Lists the targets registered with the maintenance window.
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     * @return Result of the DescribeMaintenanceWindowTargets operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowTargetsResponse describeMaintenanceWindowTargets(
            DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the targets registered with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowTargetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowTargetsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowTargetsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeMaintenanceWindowTargets operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowTargetsResponse describeMaintenanceWindowTargets(
            Consumer<DescribeMaintenanceWindowTargetsRequest.Builder> describeMaintenanceWindowTargetsRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowTargets(DescribeMaintenanceWindowTargetsRequest.builder()
                .applyMutation(describeMaintenanceWindowTargetsRequest).build());
    }

    /**
     * <p>
     * Lists the targets registered with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowTargets(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsIterable responses = client.describeMaintenanceWindowTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsIterable responses = client
     *             .describeMaintenanceWindowTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsIterable responses = client.describeMaintenanceWindowTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowTargets(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowTargetsIterable describeMaintenanceWindowTargetsPaginator(
            DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the targets registered with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowTargets(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsIterable responses = client.describeMaintenanceWindowTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsIterable responses = client
     *             .describeMaintenanceWindowTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsIterable responses = client.describeMaintenanceWindowTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowTargets(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowTargetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowTargetsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowTargetsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowTargetsIterable describeMaintenanceWindowTargetsPaginator(
            Consumer<DescribeMaintenanceWindowTargetsRequest.Builder> describeMaintenanceWindowTargetsRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowTargetsPaginator(DescribeMaintenanceWindowTargetsRequest.builder()
                .applyMutation(describeMaintenanceWindowTargetsRequest).build());
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you cannot supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values do not affect the running of your task and can be
     * ignored.
     * </p>
     * </note>
     *
     * @param describeMaintenanceWindowTasksRequest
     * @return Result of the DescribeMaintenanceWindowTasks operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowTasksResponse describeMaintenanceWindowTasks(
            DescribeMaintenanceWindowTasksRequest describeMaintenanceWindowTasksRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you cannot supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values do not affect the running of your task and can be
     * ignored.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowTasksRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowTasksRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowTasksRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeMaintenanceWindowTasks operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowTasksResponse describeMaintenanceWindowTasks(
            Consumer<DescribeMaintenanceWindowTasksRequest.Builder> describeMaintenanceWindowTasksRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowTasks(DescribeMaintenanceWindowTasksRequest.builder()
                .applyMutation(describeMaintenanceWindowTasksRequest).build());
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you cannot supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values do not affect the running of your task and can be
     * ignored.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksIterable responses = client.describeMaintenanceWindowTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksIterable responses = client
     *             .describeMaintenanceWindowTasksPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksIterable responses = client.describeMaintenanceWindowTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowTasksIterable describeMaintenanceWindowTasksPaginator(
            DescribeMaintenanceWindowTasksRequest describeMaintenanceWindowTasksRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you cannot supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values do not affect the running of your task and can be
     * ignored.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksIterable responses = client.describeMaintenanceWindowTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksIterable responses = client
     *             .describeMaintenanceWindowTasksPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksIterable responses = client.describeMaintenanceWindowTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowTasksRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowTasksRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowTasksRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowTasksIterable describeMaintenanceWindowTasksPaginator(
            Consumer<DescribeMaintenanceWindowTasksRequest.Builder> describeMaintenanceWindowTasksRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowTasksPaginator(DescribeMaintenanceWindowTasksRequest.builder()
                .applyMutation(describeMaintenanceWindowTasksRequest).build());
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an AWS account.
     * </p>
     *
     * @return Result of the DescribeMaintenanceWindows operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindows
     * @see #describeMaintenanceWindows(DescribeMaintenanceWindowsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsResponse describeMaintenanceWindows() throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindows(DescribeMaintenanceWindowsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an AWS account.
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     * @return Result of the DescribeMaintenanceWindows operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsResponse describeMaintenanceWindows(
            DescribeMaintenanceWindowsRequest describeMaintenanceWindowsRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMaintenanceWindowsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeMaintenanceWindows operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsResponse describeMaintenanceWindows(
            Consumer<DescribeMaintenanceWindowsRequest.Builder> describeMaintenanceWindowsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindows(DescribeMaintenanceWindowsRequest.builder()
                .applyMutation(describeMaintenanceWindowsRequest).build());
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable responses = client.describeMaintenanceWindowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable responses = client
     *             .describeMaintenanceWindowsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable responses = client.describeMaintenanceWindowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindows
     * @see #describeMaintenanceWindowsPaginator(DescribeMaintenanceWindowsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsIterable describeMaintenanceWindowsPaginator() throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowsPaginator(DescribeMaintenanceWindowsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable responses = client.describeMaintenanceWindowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable responses = client
     *             .describeMaintenanceWindowsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable responses = client.describeMaintenanceWindowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsIterable describeMaintenanceWindowsPaginator(
            DescribeMaintenanceWindowsRequest describeMaintenanceWindowsRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable responses = client.describeMaintenanceWindowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable responses = client
     *             .describeMaintenanceWindowsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable responses = client.describeMaintenanceWindowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMaintenanceWindowsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsIterable describeMaintenanceWindowsPaginator(
            Consumer<DescribeMaintenanceWindowsRequest.Builder> describeMaintenanceWindowsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowsPaginator(DescribeMaintenanceWindowsRequest.builder()
                .applyMutation(describeMaintenanceWindowsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the maintenance window targets or tasks that an instance is associated with.
     * </p>
     *
     * @param describeMaintenanceWindowsForTargetRequest
     * @return Result of the DescribeMaintenanceWindowsForTarget operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowsForTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsForTargetResponse describeMaintenanceWindowsForTarget(
            DescribeMaintenanceWindowsForTargetRequest describeMaintenanceWindowsForTargetRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the maintenance window targets or tasks that an instance is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowsForTargetRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowsForTargetRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowsForTargetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowsForTargetRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeMaintenanceWindowsForTarget operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowsForTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsForTargetResponse describeMaintenanceWindowsForTarget(
            Consumer<DescribeMaintenanceWindowsForTargetRequest.Builder> describeMaintenanceWindowsForTargetRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowsForTarget(DescribeMaintenanceWindowsForTargetRequest.builder()
                .applyMutation(describeMaintenanceWindowsForTargetRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the maintenance window targets or tasks that an instance is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowsForTarget(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetIterable responses = client.describeMaintenanceWindowsForTargetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetIterable responses = client
     *             .describeMaintenanceWindowsForTargetPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetIterable responses = client.describeMaintenanceWindowsForTargetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowsForTarget(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowsForTargetRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowsForTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsForTargetIterable describeMaintenanceWindowsForTargetPaginator(
            DescribeMaintenanceWindowsForTargetRequest describeMaintenanceWindowsForTargetRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the maintenance window targets or tasks that an instance is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowsForTarget(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetIterable responses = client.describeMaintenanceWindowsForTargetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetIterable responses = client
     *             .describeMaintenanceWindowsForTargetPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetIterable responses = client.describeMaintenanceWindowsForTargetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowsForTarget(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowsForTargetRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowsForTargetRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowsForTargetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowsForTargetRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowsForTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsForTargetIterable describeMaintenanceWindowsForTargetPaginator(
            Consumer<DescribeMaintenanceWindowsForTargetRequest.Builder> describeMaintenanceWindowsForTargetRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeMaintenanceWindowsForTargetPaginator(DescribeMaintenanceWindowsForTargetRequest.builder()
                .applyMutation(describeMaintenanceWindowsForTargetRequest).build());
    }

    /**
     * <p>
     * Query a set of OpsItems. You must have permission in AWS Identity and Access Management (IAM) to query a list of
     * OpsItems. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     *
     * @param describeOpsItemsRequest
     * @return Result of the DescribeOpsItems operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeOpsItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOpsItemsResponse describeOpsItems(DescribeOpsItemsRequest describeOpsItemsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Query a set of OpsItems. You must have permission in AWS Identity and Access Management (IAM) to query a list of
     * OpsItems. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOpsItemsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeOpsItemsRequest#builder()}
     * </p>
     *
     * @param describeOpsItemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOpsItemsRequest.Builder} to create a request.
     * @return Result of the DescribeOpsItems operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeOpsItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOpsItemsResponse describeOpsItems(Consumer<DescribeOpsItemsRequest.Builder> describeOpsItemsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeOpsItems(DescribeOpsItemsRequest.builder().applyMutation(describeOpsItemsRequest).build());
    }

    /**
     * <p>
     * Query a set of OpsItems. You must have permission in AWS Identity and Access Management (IAM) to query a list of
     * OpsItems. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeOpsItems(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsIterable responses = client.describeOpsItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsIterable responses = client.describeOpsItemsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsIterable responses = client.describeOpsItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOpsItems(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest)} operation.</b>
     * </p>
     *
     * @param describeOpsItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeOpsItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOpsItemsIterable describeOpsItemsPaginator(DescribeOpsItemsRequest describeOpsItemsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Query a set of OpsItems. You must have permission in AWS Identity and Access Management (IAM) to query a list of
     * OpsItems. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeOpsItems(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsIterable responses = client.describeOpsItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsIterable responses = client.describeOpsItemsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsIterable responses = client.describeOpsItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOpsItems(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOpsItemsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeOpsItemsRequest#builder()}
     * </p>
     *
     * @param describeOpsItemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOpsItemsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeOpsItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOpsItemsIterable describeOpsItemsPaginator(Consumer<DescribeOpsItemsRequest.Builder> describeOpsItemsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return describeOpsItemsPaginator(DescribeOpsItemsRequest.builder().applyMutation(describeOpsItemsRequest).build());
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note>
     *
     * @return Result of the DescribeParameters operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeParameters
     * @see #describeParameters(DescribeParametersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeParametersResponse describeParameters() throws InternalServerErrorException, InvalidFilterKeyException,
            InvalidFilterOptionException, InvalidFilterValueException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeParameters(DescribeParametersRequest.builder().build());
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note>
     *
     * @param describeParametersRequest
     * @return Result of the DescribeParameters operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeParametersResponse describeParameters(DescribeParametersRequest describeParametersRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidFilterOptionException,
            InvalidFilterValueException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeParametersRequest#builder()}
     * </p>
     *
     * @param describeParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeParametersRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeParameters operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeParametersResponse describeParameters(Consumer<DescribeParametersRequest.Builder> describeParametersRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidFilterOptionException,
            InvalidFilterValueException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return describeParameters(DescribeParametersRequest.builder().applyMutation(describeParametersRequest).build());
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable responses = client.describeParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable responses = client
     *             .describeParametersPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable responses = client.describeParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeParameters
     * @see #describeParametersPaginator(DescribeParametersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeParametersIterable describeParametersPaginator() throws InternalServerErrorException,
            InvalidFilterKeyException, InvalidFilterOptionException, InvalidFilterValueException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return describeParametersPaginator(DescribeParametersRequest.builder().build());
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable responses = client.describeParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable responses = client
     *             .describeParametersPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable responses = client.describeParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation.</b>
     * </p>
     *
     * @param describeParametersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeParametersIterable describeParametersPaginator(DescribeParametersRequest describeParametersRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidFilterOptionException,
            InvalidFilterValueException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable responses = client.describeParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable responses = client
     *             .describeParametersPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable responses = client.describeParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeParametersRequest#builder()}
     * </p>
     *
     * @param describeParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeParametersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeParametersIterable describeParametersPaginator(
            Consumer<DescribeParametersRequest.Builder> describeParametersRequest) throws InternalServerErrorException,
            InvalidFilterKeyException, InvalidFilterOptionException, InvalidFilterValueException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return describeParametersPaginator(DescribeParametersRequest.builder().applyMutation(describeParametersRequest).build());
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     *
     * @return Result of the DescribePatchBaselines operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchBaselines
     * @see #describePatchBaselines(DescribePatchBaselinesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchBaselinesResponse describePatchBaselines() throws InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        return describePatchBaselines(DescribePatchBaselinesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     *
     * @param describePatchBaselinesRequest
     * @return Result of the DescribePatchBaselines operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchBaselinesResponse describePatchBaselines(DescribePatchBaselinesRequest describePatchBaselinesRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchBaselinesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePatchBaselinesRequest#builder()}
     * </p>
     *
     * @param describePatchBaselinesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchBaselinesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePatchBaselines operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchBaselinesResponse describePatchBaselines(
            Consumer<DescribePatchBaselinesRequest.Builder> describePatchBaselinesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return describePatchBaselines(DescribePatchBaselinesRequest.builder().applyMutation(describePatchBaselinesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable responses = client.describePatchBaselinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable responses = client
     *             .describePatchBaselinesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable responses = client.describePatchBaselinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchBaselines
     * @see #describePatchBaselinesPaginator(DescribePatchBaselinesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchBaselinesIterable describePatchBaselinesPaginator() throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return describePatchBaselinesPaginator(DescribePatchBaselinesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable responses = client.describePatchBaselinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable responses = client
     *             .describePatchBaselinesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable responses = client.describePatchBaselinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePatchBaselinesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchBaselinesIterable describePatchBaselinesPaginator(
            DescribePatchBaselinesRequest describePatchBaselinesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable responses = client.describePatchBaselinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable responses = client
     *             .describePatchBaselinesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable responses = client.describePatchBaselinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchBaselinesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePatchBaselinesRequest#builder()}
     * </p>
     *
     * @param describePatchBaselinesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchBaselinesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchBaselinesIterable describePatchBaselinesPaginator(
            Consumer<DescribePatchBaselinesRequest.Builder> describePatchBaselinesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return describePatchBaselinesPaginator(DescribePatchBaselinesRequest.builder()
                .applyMutation(describePatchBaselinesRequest).build());
    }

    /**
     * <p>
     * Returns high-level aggregated patch compliance state for a patch group.
     * </p>
     *
     * @param describePatchGroupStateRequest
     * @return Result of the DescribePatchGroupState operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchGroupState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchGroupStateResponse describePatchGroupState(DescribePatchGroupStateRequest describePatchGroupStateRequest)
            throws InternalServerErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns high-level aggregated patch compliance state for a patch group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchGroupStateRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePatchGroupStateRequest#builder()}
     * </p>
     *
     * @param describePatchGroupStateRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchGroupStateRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePatchGroupState operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchGroupState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchGroupStateResponse describePatchGroupState(
            Consumer<DescribePatchGroupStateRequest.Builder> describePatchGroupStateRequest) throws InternalServerErrorException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return describePatchGroupState(DescribePatchGroupStateRequest.builder().applyMutation(describePatchGroupStateRequest)
                .build());
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     *
     * @return Result of the DescribePatchGroups operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchGroups
     * @see #describePatchGroups(DescribePatchGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePatchGroupsResponse describePatchGroups() throws InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        return describePatchGroups(DescribePatchGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     *
     * @param describePatchGroupsRequest
     * @return Result of the DescribePatchGroups operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePatchGroupsResponse describePatchGroups(DescribePatchGroupsRequest describePatchGroupsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePatchGroupsRequest#builder()}
     * </p>
     *
     * @param describePatchGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchGroupsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePatchGroups operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePatchGroupsResponse describePatchGroups(
            Consumer<DescribePatchGroupsRequest.Builder> describePatchGroupsRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return describePatchGroups(DescribePatchGroupsRequest.builder().applyMutation(describePatchGroupsRequest).build());
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable responses = client.describePatchGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable responses = client
     *             .describePatchGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable responses = client.describePatchGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchGroups
     * @see #describePatchGroupsPaginator(DescribePatchGroupsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePatchGroupsIterable describePatchGroupsPaginator() throws InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        return describePatchGroupsPaginator(DescribePatchGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable responses = client.describePatchGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable responses = client
     *             .describePatchGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable responses = client.describePatchGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation.</b>
     * </p>
     *
     * @param describePatchGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePatchGroupsIterable describePatchGroupsPaginator(DescribePatchGroupsRequest describePatchGroupsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable responses = client.describePatchGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable responses = client
     *             .describePatchGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable responses = client.describePatchGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePatchGroupsRequest#builder()}
     * </p>
     *
     * @param describePatchGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchGroupsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePatchGroupsIterable describePatchGroupsPaginator(
            Consumer<DescribePatchGroupsRequest.Builder> describePatchGroupsRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return describePatchGroupsPaginator(DescribePatchGroupsRequest.builder().applyMutation(describePatchGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the properties of available patches organized by product, product family, classification, severity, and
     * other properties of available patches. You can use the reported properties in the filters you specify in requests
     * for actions such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>, and
     * <a>DescribePatchBaselines</a>.
     * </p>
     * <p>
     * The following section lists the properties that can be used in filters for each major operating system type:
     * </p>
     * <dl>
     * <dt>AMAZON_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>AMAZON_LINUX_2</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>CENTOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>DEBIAN</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>MACOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION
     * </p>
     * </dd>
     * <dt>ORACLE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>REDHAT_ENTERPRISE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>SUSE</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>UBUNTU</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>WINDOWS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRODUCT_FAMILY, CLASSIFICATION, MSRC_SEVERITY
     * </p>
     * </dd>
     * </dl>
     *
     * @param describePatchPropertiesRequest
     * @return Result of the DescribePatchProperties operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchPropertiesResponse describePatchProperties(DescribePatchPropertiesRequest describePatchPropertiesRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the properties of available patches organized by product, product family, classification, severity, and
     * other properties of available patches. You can use the reported properties in the filters you specify in requests
     * for actions such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>, and
     * <a>DescribePatchBaselines</a>.
     * </p>
     * <p>
     * The following section lists the properties that can be used in filters for each major operating system type:
     * </p>
     * <dl>
     * <dt>AMAZON_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>AMAZON_LINUX_2</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>CENTOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>DEBIAN</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>MACOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION
     * </p>
     * </dd>
     * <dt>ORACLE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>REDHAT_ENTERPRISE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>SUSE</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>UBUNTU</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>WINDOWS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRODUCT_FAMILY, CLASSIFICATION, MSRC_SEVERITY
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePatchPropertiesRequest#builder()}
     * </p>
     *
     * @param describePatchPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchPropertiesRequest.Builder} to create a
     *        request.
     * @return Result of the DescribePatchProperties operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchPropertiesResponse describePatchProperties(
            Consumer<DescribePatchPropertiesRequest.Builder> describePatchPropertiesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return describePatchProperties(DescribePatchPropertiesRequest.builder().applyMutation(describePatchPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the properties of available patches organized by product, product family, classification, severity, and
     * other properties of available patches. You can use the reported properties in the filters you specify in requests
     * for actions such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>, and
     * <a>DescribePatchBaselines</a>.
     * </p>
     * <p>
     * The following section lists the properties that can be used in filters for each major operating system type:
     * </p>
     * <dl>
     * <dt>AMAZON_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>AMAZON_LINUX_2</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>CENTOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>DEBIAN</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>MACOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION
     * </p>
     * </dd>
     * <dt>ORACLE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>REDHAT_ENTERPRISE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>SUSE</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>UBUNTU</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>WINDOWS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRODUCT_FAMILY, CLASSIFICATION, MSRC_SEVERITY
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchProperties(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesIterable responses = client.describePatchPropertiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesIterable responses = client
     *             .describePatchPropertiesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesIterable responses = client.describePatchPropertiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchProperties(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePatchPropertiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchPropertiesIterable describePatchPropertiesPaginator(
            DescribePatchPropertiesRequest describePatchPropertiesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the properties of available patches organized by product, product family, classification, severity, and
     * other properties of available patches. You can use the reported properties in the filters you specify in requests
     * for actions such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>, and
     * <a>DescribePatchBaselines</a>.
     * </p>
     * <p>
     * The following section lists the properties that can be used in filters for each major operating system type:
     * </p>
     * <dl>
     * <dt>AMAZON_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>AMAZON_LINUX_2</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>CENTOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>DEBIAN</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>MACOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION
     * </p>
     * </dd>
     * <dt>ORACLE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>REDHAT_ENTERPRISE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>SUSE</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>UBUNTU</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>WINDOWS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRODUCT_FAMILY, CLASSIFICATION, MSRC_SEVERITY
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchProperties(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesIterable responses = client.describePatchPropertiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesIterable responses = client
     *             .describePatchPropertiesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesIterable responses = client.describePatchPropertiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchProperties(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePatchPropertiesRequest#builder()}
     * </p>
     *
     * @param describePatchPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchPropertiesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchPropertiesIterable describePatchPropertiesPaginator(
            Consumer<DescribePatchPropertiesRequest.Builder> describePatchPropertiesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return describePatchPropertiesPaginator(DescribePatchPropertiesRequest.builder()
                .applyMutation(describePatchPropertiesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30
     * days.
     * </p>
     *
     * @param describeSessionsRequest
     * @return Result of the DescribeSessions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSessionsResponse describeSessions(DescribeSessionsRequest describeSessionsRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30
     * days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSessionsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSessionsRequest#builder()}
     * </p>
     *
     * @param describeSessionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSessionsRequest.Builder} to create a request.
     * @return Result of the DescribeSessions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSessionsResponse describeSessions(Consumer<DescribeSessionsRequest.Builder> describeSessionsRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeSessions(DescribeSessionsRequest.builder().applyMutation(describeSessionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30
     * days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeSessions(software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeSessionsIterable responses = client.describeSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeSessionsIterable responses = client.describeSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeSessionsIterable responses = client.describeSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSessions(software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest)} operation.</b>
     * </p>
     *
     * @param describeSessionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSessionsIterable describeSessionsPaginator(DescribeSessionsRequest describeSessionsRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30
     * days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeSessions(software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeSessionsIterable responses = client.describeSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeSessionsIterable responses = client.describeSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeSessionsIterable responses = client.describeSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSessions(software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSessionsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSessionsRequest#builder()}
     * </p>
     *
     * @param describeSessionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSessionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSessionsIterable describeSessionsPaginator(Consumer<DescribeSessionsRequest.Builder> describeSessionsRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return describeSessionsPaginator(DescribeSessionsRequest.builder().applyMutation(describeSessionsRequest).build());
    }

    /**
     * <p>
     * Get detailed information about a particular Automation execution.
     * </p>
     *
     * @param getAutomationExecutionRequest
     * @return Result of the GetAutomationExecution operation returned by the service.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetAutomationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAutomationExecutionResponse getAutomationExecution(GetAutomationExecutionRequest getAutomationExecutionRequest)
            throws AutomationExecutionNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed information about a particular Automation execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAutomationExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link GetAutomationExecutionRequest#builder()}
     * </p>
     *
     * @param getAutomationExecutionRequest
     *        A {@link Consumer} that will call methods on {@link GetAutomationExecutionRequest.Builder} to create a
     *        request.
     * @return Result of the GetAutomationExecution operation returned by the service.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetAutomationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default GetAutomationExecutionResponse getAutomationExecution(
            Consumer<GetAutomationExecutionRequest.Builder> getAutomationExecutionRequest)
            throws AutomationExecutionNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        return getAutomationExecution(GetAutomationExecutionRequest.builder().applyMutation(getAutomationExecutionRequest)
                .build());
    }

    /**
     * <p>
     * Gets the state of the AWS Systems Manager Change Calendar at an optional, specified time. If you specify a time,
     * <code>GetCalendarState</code> returns the state of the calendar at a specific time, and returns the next time
     * that the Change Calendar state will transition. If you do not specify a time, <code>GetCalendarState</code>
     * assumes the current time. Change Calendar entries have two possible states: <code>OPEN</code> or
     * <code>CLOSED</code>.
     * </p>
     * <p>
     * If you specify more than one calendar in a request, the command returns the status of <code>OPEN</code> only if
     * all calendars in the request are open. If one or more calendars in the request are closed, the status returned is
     * <code>CLOSED</code>.
     * </p>
     * <p>
     * For more information about Systems Manager Change Calendar, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html">AWS
     * Systems Manager Change Calendar</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     *
     * @param getCalendarStateRequest
     * @return Result of the GetCalendarState operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentTypeException
     *         The document type is not valid. Valid document types are described in the <code>DocumentType</code>
     *         property.
     * @throws UnsupportedCalendarException
     *         The calendar entry contained in the specified Systems Manager document is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetCalendarState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCalendarState" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCalendarStateResponse getCalendarState(GetCalendarStateRequest getCalendarStateRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentTypeException,
            UnsupportedCalendarException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the state of the AWS Systems Manager Change Calendar at an optional, specified time. If you specify a time,
     * <code>GetCalendarState</code> returns the state of the calendar at a specific time, and returns the next time
     * that the Change Calendar state will transition. If you do not specify a time, <code>GetCalendarState</code>
     * assumes the current time. Change Calendar entries have two possible states: <code>OPEN</code> or
     * <code>CLOSED</code>.
     * </p>
     * <p>
     * If you specify more than one calendar in a request, the command returns the status of <code>OPEN</code> only if
     * all calendars in the request are open. If one or more calendars in the request are closed, the status returned is
     * <code>CLOSED</code>.
     * </p>
     * <p>
     * For more information about Systems Manager Change Calendar, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html">AWS
     * Systems Manager Change Calendar</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCalendarStateRequest.Builder} avoiding the need
     * to create one manually via {@link GetCalendarStateRequest#builder()}
     * </p>
     *
     * @param getCalendarStateRequest
     *        A {@link Consumer} that will call methods on {@link GetCalendarStateRequest.Builder} to create a request.
     * @return Result of the GetCalendarState operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentTypeException
     *         The document type is not valid. Valid document types are described in the <code>DocumentType</code>
     *         property.
     * @throws UnsupportedCalendarException
     *         The calendar entry contained in the specified Systems Manager document is not supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetCalendarState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCalendarState" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCalendarStateResponse getCalendarState(Consumer<GetCalendarStateRequest.Builder> getCalendarStateRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentTypeException,
            UnsupportedCalendarException, AwsServiceException, SdkClientException, SsmException {
        return getCalendarState(GetCalendarStateRequest.builder().applyMutation(getCalendarStateRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about command execution for an invocation or plugin.
     * </p>
     *
     * @param getCommandInvocationRequest
     * @return Result of the GetCommandInvocation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidPluginNameException
     *         The plugin name is not valid.
     * @throws InvocationDoesNotExistException
     *         The command ID and instance ID you specified did not match any invocations. Verify the command ID and the
     *         instance ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetCommandInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCommandInvocationResponse getCommandInvocation(GetCommandInvocationRequest getCommandInvocationRequest)
            throws InternalServerErrorException, InvalidCommandIdException, InvalidInstanceIdException,
            InvalidPluginNameException, InvocationDoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about command execution for an invocation or plugin.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCommandInvocationRequest.Builder} avoiding the
     * need to create one manually via {@link GetCommandInvocationRequest#builder()}
     * </p>
     *
     * @param getCommandInvocationRequest
     *        A {@link Consumer} that will call methods on {@link GetCommandInvocationRequest.Builder} to create a
     *        request.
     * @return Result of the GetCommandInvocation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidPluginNameException
     *         The plugin name is not valid.
     * @throws InvocationDoesNotExistException
     *         The command ID and instance ID you specified did not match any invocations. Verify the command ID and the
     *         instance ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetCommandInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation" target="_top">AWS API
     *      Documentation</a>
     */
    default GetCommandInvocationResponse getCommandInvocation(
            Consumer<GetCommandInvocationRequest.Builder> getCommandInvocationRequest) throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, InvalidPluginNameException, InvocationDoesNotExistException,
            AwsServiceException, SdkClientException, SsmException {
        return getCommandInvocation(GetCommandInvocationRequest.builder().applyMutation(getCommandInvocationRequest).build());
    }

    /**
     * <p>
     * Retrieves the Session Manager connection status for an instance to determine whether it is running and ready to
     * receive Session Manager connections.
     * </p>
     *
     * @param getConnectionStatusRequest
     * @return Result of the GetConnectionStatus operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetConnectionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionStatusResponse getConnectionStatus(GetConnectionStatusRequest getConnectionStatusRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Session Manager connection status for an instance to determine whether it is running and ready to
     * receive Session Manager connections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetConnectionStatusRequest#builder()}
     * </p>
     *
     * @param getConnectionStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectionStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetConnectionStatus operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetConnectionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default GetConnectionStatusResponse getConnectionStatus(
            Consumer<GetConnectionStatusRequest.Builder> getConnectionStatusRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return getConnectionStatus(GetConnectionStatusRequest.builder().applyMutation(getConnectionStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves the default patch baseline. Note that Systems Manager supports creating multiple default patch
     * baselines. For example, you can create a default patch baseline for each operating system.
     * </p>
     * <p>
     * If you do not specify an operating system value, the default patch baseline for Windows is returned.
     * </p>
     *
     * @return Result of the GetDefaultPatchBaseline operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetDefaultPatchBaseline
     * @see #getDefaultPatchBaseline(GetDefaultPatchBaselineRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDefaultPatchBaselineResponse getDefaultPatchBaseline() throws InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        return getDefaultPatchBaseline(GetDefaultPatchBaselineRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the default patch baseline. Note that Systems Manager supports creating multiple default patch
     * baselines. For example, you can create a default patch baseline for each operating system.
     * </p>
     * <p>
     * If you do not specify an operating system value, the default patch baseline for Windows is returned.
     * </p>
     *
     * @param getDefaultPatchBaselineRequest
     * @return Result of the GetDefaultPatchBaseline operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetDefaultPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDefaultPatchBaselineResponse getDefaultPatchBaseline(GetDefaultPatchBaselineRequest getDefaultPatchBaselineRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the default patch baseline. Note that Systems Manager supports creating multiple default patch
     * baselines. For example, you can create a default patch baseline for each operating system.
     * </p>
     * <p>
     * If you do not specify an operating system value, the default patch baseline for Windows is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDefaultPatchBaselineRequest.Builder} avoiding
     * the need to create one manually via {@link GetDefaultPatchBaselineRequest#builder()}
     * </p>
     *
     * @param getDefaultPatchBaselineRequest
     *        A {@link Consumer} that will call methods on {@link GetDefaultPatchBaselineRequest.Builder} to create a
     *        request.
     * @return Result of the GetDefaultPatchBaseline operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetDefaultPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default GetDefaultPatchBaselineResponse getDefaultPatchBaseline(
            Consumer<GetDefaultPatchBaselineRequest.Builder> getDefaultPatchBaselineRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return getDefaultPatchBaseline(GetDefaultPatchBaselineRequest.builder().applyMutation(getDefaultPatchBaselineRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the current snapshot for the patch baseline the instance uses. This API is primarily used by the
     * AWS-RunPatchBaseline Systems Manager document.
     * </p>
     *
     * @param getDeployablePatchSnapshotForInstanceRequest
     * @return Result of the GetDeployablePatchSnapshotForInstance operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws UnsupportedOperatingSystemException
     *         The operating systems you specified is not supported, or the operation is not supported for the operating
     *         system.
     * @throws UnsupportedFeatureRequiredException
     *         Microsoft application patching is only available on EC2 instances and advanced instances. To patch
     *         Microsoft applications on on-premises servers and VMs, you must enable advanced instances. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances-advanced.html"
     *         >Using the advanced-instances tier</a> in the <i>AWS Systems Manager User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetDeployablePatchSnapshotForInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeployablePatchSnapshotForInstanceResponse getDeployablePatchSnapshotForInstance(
            GetDeployablePatchSnapshotForInstanceRequest getDeployablePatchSnapshotForInstanceRequest)
            throws InternalServerErrorException, UnsupportedOperatingSystemException, UnsupportedFeatureRequiredException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current snapshot for the patch baseline the instance uses. This API is primarily used by the
     * AWS-RunPatchBaseline Systems Manager document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetDeployablePatchSnapshotForInstanceRequest.Builder} avoiding the need to create one manually via
     * {@link GetDeployablePatchSnapshotForInstanceRequest#builder()}
     * </p>
     *
     * @param getDeployablePatchSnapshotForInstanceRequest
     *        A {@link Consumer} that will call methods on {@link GetDeployablePatchSnapshotForInstanceRequest.Builder}
     *        to create a request.
     * @return Result of the GetDeployablePatchSnapshotForInstance operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws UnsupportedOperatingSystemException
     *         The operating systems you specified is not supported, or the operation is not supported for the operating
     *         system.
     * @throws UnsupportedFeatureRequiredException
     *         Microsoft application patching is only available on EC2 instances and advanced instances. To patch
     *         Microsoft applications on on-premises servers and VMs, you must enable advanced instances. For more
     *         information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances-advanced.html"
     *         >Using the advanced-instances tier</a> in the <i>AWS Systems Manager User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetDeployablePatchSnapshotForInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDeployablePatchSnapshotForInstanceResponse getDeployablePatchSnapshotForInstance(
            Consumer<GetDeployablePatchSnapshotForInstanceRequest.Builder> getDeployablePatchSnapshotForInstanceRequest)
            throws InternalServerErrorException, UnsupportedOperatingSystemException, UnsupportedFeatureRequiredException,
            AwsServiceException, SdkClientException, SsmException {
        return getDeployablePatchSnapshotForInstance(GetDeployablePatchSnapshotForInstanceRequest.builder()
                .applyMutation(getDeployablePatchSnapshotForInstanceRequest).build());
    }

    /**
     * <p>
     * Gets the contents of the specified Systems Manager document.
     * </p>
     *
     * @param getDocumentRequest
     * @return Result of the GetDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDocumentResponse getDocument(GetDocumentRequest getDocumentRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the contents of the specified Systems Manager document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDocumentRequest#builder()}
     * </p>
     *
     * @param getDocumentRequest
     *        A {@link Consumer} that will call methods on {@link GetDocumentRequest.Builder} to create a request.
     * @return Result of the GetDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDocumentResponse getDocument(Consumer<GetDocumentRequest.Builder> getDocumentRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentVersionException, AwsServiceException,
            SdkClientException, SsmException {
        return getDocument(GetDocumentRequest.builder().applyMutation(getDocumentRequest).build());
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     *
     * @return Result of the GetInventory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidInventoryGroupException
     *         The specified inventory group is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator is not valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws InvalidResultAttributeException
     *         The specified inventory item result attribute is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventory
     * @see #getInventory(GetInventoryRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventoryResponse getInventory() throws InternalServerErrorException, InvalidFilterException,
            InvalidInventoryGroupException, InvalidNextTokenException, InvalidTypeNameException, InvalidAggregatorException,
            InvalidResultAttributeException, AwsServiceException, SdkClientException, SsmException {
        return getInventory(GetInventoryRequest.builder().build());
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     *
     * @param getInventoryRequest
     * @return Result of the GetInventory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidInventoryGroupException
     *         The specified inventory group is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator is not valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws InvalidResultAttributeException
     *         The specified inventory item result attribute is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventoryResponse getInventory(GetInventoryRequest getInventoryRequest) throws InternalServerErrorException,
            InvalidFilterException, InvalidInventoryGroupException, InvalidNextTokenException, InvalidTypeNameException,
            InvalidAggregatorException, InvalidResultAttributeException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInventoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetInventoryRequest#builder()}
     * </p>
     *
     * @param getInventoryRequest
     *        A {@link Consumer} that will call methods on {@link GetInventoryRequest.Builder} to create a request.
     * @return Result of the GetInventory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidInventoryGroupException
     *         The specified inventory group is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator is not valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws InvalidResultAttributeException
     *         The specified inventory item result attribute is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventoryResponse getInventory(Consumer<GetInventoryRequest.Builder> getInventoryRequest)
            throws InternalServerErrorException, InvalidFilterException, InvalidInventoryGroupException,
            InvalidNextTokenException, InvalidTypeNameException, InvalidAggregatorException, InvalidResultAttributeException,
            AwsServiceException, SdkClientException, SsmException {
        return getInventory(GetInventoryRequest.builder().applyMutation(getInventoryRequest).build());
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable responses = client.getInventoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable responses = client.getInventoryPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetInventoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable responses = client.getInventoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidInventoryGroupException
     *         The specified inventory group is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator is not valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws InvalidResultAttributeException
     *         The specified inventory item result attribute is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventory
     * @see #getInventoryPaginator(GetInventoryRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventoryIterable getInventoryPaginator() throws InternalServerErrorException, InvalidFilterException,
            InvalidInventoryGroupException, InvalidNextTokenException, InvalidTypeNameException, InvalidAggregatorException,
            InvalidResultAttributeException, AwsServiceException, SdkClientException, SsmException {
        return getInventoryPaginator(GetInventoryRequest.builder().build());
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable responses = client.getInventoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable responses = client.getInventoryPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetInventoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable responses = client.getInventoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)} operation.</b>
     * </p>
     *
     * @param getInventoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidInventoryGroupException
     *         The specified inventory group is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator is not valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws InvalidResultAttributeException
     *         The specified inventory item result attribute is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventoryIterable getInventoryPaginator(GetInventoryRequest getInventoryRequest)
            throws InternalServerErrorException, InvalidFilterException, InvalidInventoryGroupException,
            InvalidNextTokenException, InvalidTypeNameException, InvalidAggregatorException, InvalidResultAttributeException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable responses = client.getInventoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable responses = client.getInventoryPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetInventoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable responses = client.getInventoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInventoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetInventoryRequest#builder()}
     * </p>
     *
     * @param getInventoryRequest
     *        A {@link Consumer} that will call methods on {@link GetInventoryRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidInventoryGroupException
     *         The specified inventory group is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator is not valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws InvalidResultAttributeException
     *         The specified inventory item result attribute is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventoryIterable getInventoryPaginator(Consumer<GetInventoryRequest.Builder> getInventoryRequest)
            throws InternalServerErrorException, InvalidFilterException, InvalidInventoryGroupException,
            InvalidNextTokenException, InvalidTypeNameException, InvalidAggregatorException, InvalidResultAttributeException,
            AwsServiceException, SdkClientException, SsmException {
        return getInventoryPaginator(GetInventoryRequest.builder().applyMutation(getInventoryRequest).build());
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     *
     * @return Result of the GetInventorySchema operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventorySchema
     * @see #getInventorySchema(GetInventorySchemaRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventorySchemaResponse getInventorySchema() throws InternalServerErrorException, InvalidTypeNameException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return getInventorySchema(GetInventorySchemaRequest.builder().build());
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     *
     * @param getInventorySchemaRequest
     * @return Result of the GetInventorySchema operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventorySchemaResponse getInventorySchema(GetInventorySchemaRequest getInventorySchemaRequest)
            throws InternalServerErrorException, InvalidTypeNameException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInventorySchemaRequest.Builder} avoiding the
     * need to create one manually via {@link GetInventorySchemaRequest#builder()}
     * </p>
     *
     * @param getInventorySchemaRequest
     *        A {@link Consumer} that will call methods on {@link GetInventorySchemaRequest.Builder} to create a
     *        request.
     * @return Result of the GetInventorySchema operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventorySchemaResponse getInventorySchema(Consumer<GetInventorySchemaRequest.Builder> getInventorySchemaRequest)
            throws InternalServerErrorException, InvalidTypeNameException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return getInventorySchema(GetInventorySchemaRequest.builder().applyMutation(getInventorySchemaRequest).build());
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable responses = client.getInventorySchemaPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable responses = client
     *             .getInventorySchemaPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable responses = client.getInventorySchemaPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventorySchema
     * @see #getInventorySchemaPaginator(GetInventorySchemaRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventorySchemaIterable getInventorySchemaPaginator() throws InternalServerErrorException,
            InvalidTypeNameException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return getInventorySchemaPaginator(GetInventorySchemaRequest.builder().build());
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable responses = client.getInventorySchemaPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable responses = client
     *             .getInventorySchemaPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable responses = client.getInventorySchemaPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation.</b>
     * </p>
     *
     * @param getInventorySchemaRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventorySchemaIterable getInventorySchemaPaginator(GetInventorySchemaRequest getInventorySchemaRequest)
            throws InternalServerErrorException, InvalidTypeNameException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable responses = client.getInventorySchemaPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable responses = client
     *             .getInventorySchemaPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable responses = client.getInventorySchemaPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInventorySchemaRequest.Builder} avoiding the
     * need to create one manually via {@link GetInventorySchemaRequest#builder()}
     * </p>
     *
     * @param getInventorySchemaRequest
     *        A {@link Consumer} that will call methods on {@link GetInventorySchemaRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventorySchemaIterable getInventorySchemaPaginator(
            Consumer<GetInventorySchemaRequest.Builder> getInventorySchemaRequest) throws InternalServerErrorException,
            InvalidTypeNameException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return getInventorySchemaPaginator(GetInventorySchemaRequest.builder().applyMutation(getInventorySchemaRequest).build());
    }

    /**
     * <p>
     * Retrieves a maintenance window.
     * </p>
     *
     * @param getMaintenanceWindowRequest
     * @return Result of the GetMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMaintenanceWindowResponse getMaintenanceWindow(GetMaintenanceWindowRequest getMaintenanceWindowRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMaintenanceWindowRequest.Builder} avoiding the
     * need to create one manually via {@link GetMaintenanceWindowRequest#builder()}
     * </p>
     *
     * @param getMaintenanceWindowRequest
     *        A {@link Consumer} that will call methods on {@link GetMaintenanceWindowRequest.Builder} to create a
     *        request.
     * @return Result of the GetMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow" target="_top">AWS API
     *      Documentation</a>
     */
    default GetMaintenanceWindowResponse getMaintenanceWindow(
            Consumer<GetMaintenanceWindowRequest.Builder> getMaintenanceWindowRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return getMaintenanceWindow(GetMaintenanceWindowRequest.builder().applyMutation(getMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a specific a maintenance window execution.
     * </p>
     *
     * @param getMaintenanceWindowExecutionRequest
     * @return Result of the GetMaintenanceWindowExecution operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMaintenanceWindowExecutionResponse getMaintenanceWindowExecution(
            GetMaintenanceWindowExecutionRequest getMaintenanceWindowExecutionRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a specific a maintenance window execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMaintenanceWindowExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link GetMaintenanceWindowExecutionRequest#builder()}
     * </p>
     *
     * @param getMaintenanceWindowExecutionRequest
     *        A {@link Consumer} that will call methods on {@link GetMaintenanceWindowExecutionRequest.Builder} to
     *        create a request.
     * @return Result of the GetMaintenanceWindowExecution operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMaintenanceWindowExecutionResponse getMaintenanceWindowExecution(
            Consumer<GetMaintenanceWindowExecutionRequest.Builder> getMaintenanceWindowExecutionRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return getMaintenanceWindowExecution(GetMaintenanceWindowExecutionRequest.builder()
                .applyMutation(getMaintenanceWindowExecutionRequest).build());
    }

    /**
     * <p>
     * Retrieves the details about a specific task run as part of a maintenance window execution.
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskRequest
     * @return Result of the GetMaintenanceWindowExecutionTask operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindowExecutionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMaintenanceWindowExecutionTaskResponse getMaintenanceWindowExecutionTask(
            GetMaintenanceWindowExecutionTaskRequest getMaintenanceWindowExecutionTaskRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details about a specific task run as part of a maintenance window execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMaintenanceWindowExecutionTaskRequest.Builder}
     * avoiding the need to create one manually via {@link GetMaintenanceWindowExecutionTaskRequest#builder()}
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetMaintenanceWindowExecutionTaskRequest.Builder} to
     *        create a request.
     * @return Result of the GetMaintenanceWindowExecutionTask operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindowExecutionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMaintenanceWindowExecutionTaskResponse getMaintenanceWindowExecutionTask(
            Consumer<GetMaintenanceWindowExecutionTaskRequest.Builder> getMaintenanceWindowExecutionTaskRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return getMaintenanceWindowExecutionTask(GetMaintenanceWindowExecutionTaskRequest.builder()
                .applyMutation(getMaintenanceWindowExecutionTaskRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific task running on a specific target.
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskInvocationRequest
     * @return Result of the GetMaintenanceWindowExecutionTaskInvocation operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindowExecutionTaskInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMaintenanceWindowExecutionTaskInvocationResponse getMaintenanceWindowExecutionTaskInvocation(
            GetMaintenanceWindowExecutionTaskInvocationRequest getMaintenanceWindowExecutionTaskInvocationRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific task running on a specific target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetMaintenanceWindowExecutionTaskInvocationRequest.Builder} avoiding the need to create one manually via
     * {@link GetMaintenanceWindowExecutionTaskInvocationRequest#builder()}
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskInvocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetMaintenanceWindowExecutionTaskInvocationRequest.Builder} to create a request.
     * @return Result of the GetMaintenanceWindowExecutionTaskInvocation operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindowExecutionTaskInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetMaintenanceWindowExecutionTaskInvocationResponse getMaintenanceWindowExecutionTaskInvocation(
            Consumer<GetMaintenanceWindowExecutionTaskInvocationRequest.Builder> getMaintenanceWindowExecutionTaskInvocationRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return getMaintenanceWindowExecutionTaskInvocation(GetMaintenanceWindowExecutionTaskInvocationRequest.builder()
                .applyMutation(getMaintenanceWindowExecutionTaskInvocationRequest).build());
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you cannot supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values do not affect the running of your task and can be
     * ignored.
     * </p>
     * </note>
     *
     * @param getMaintenanceWindowTaskRequest
     * @return Result of the GetMaintenanceWindowTask operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindowTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowTask" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMaintenanceWindowTaskResponse getMaintenanceWindowTask(
            GetMaintenanceWindowTaskRequest getMaintenanceWindowTaskRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you cannot supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values do not affect the running of your task and can be
     * ignored.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMaintenanceWindowTaskRequest.Builder} avoiding
     * the need to create one manually via {@link GetMaintenanceWindowTaskRequest#builder()}
     * </p>
     *
     * @param getMaintenanceWindowTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetMaintenanceWindowTaskRequest.Builder} to create a
     *        request.
     * @return Result of the GetMaintenanceWindowTask operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindowTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowTask" target="_top">AWS
     *      API Documentation</a>
     */
    default GetMaintenanceWindowTaskResponse getMaintenanceWindowTask(
            Consumer<GetMaintenanceWindowTaskRequest.Builder> getMaintenanceWindowTaskRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return getMaintenanceWindowTask(GetMaintenanceWindowTaskRequest.builder().applyMutation(getMaintenanceWindowTaskRequest)
                .build());
    }

    /**
     * <p>
     * Get information about an OpsItem by using the ID. You must have permission in AWS Identity and Access Management
     * (IAM) to view information about an OpsItem. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     *
     * @param getOpsItemRequest
     * @return Result of the GetOpsItem operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOpsItemResponse getOpsItem(GetOpsItemRequest getOpsItemRequest) throws InternalServerErrorException,
            OpsItemNotFoundException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about an OpsItem by using the ID. You must have permission in AWS Identity and Access Management
     * (IAM) to view information about an OpsItem. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpsItemRequest.Builder} avoiding the need to
     * create one manually via {@link GetOpsItemRequest#builder()}
     * </p>
     *
     * @param getOpsItemRequest
     *        A {@link Consumer} that will call methods on {@link GetOpsItemRequest.Builder} to create a request.
     * @return Result of the GetOpsItem operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOpsItemResponse getOpsItem(Consumer<GetOpsItemRequest.Builder> getOpsItemRequest)
            throws InternalServerErrorException, OpsItemNotFoundException, AwsServiceException, SdkClientException, SsmException {
        return getOpsItem(GetOpsItemRequest.builder().applyMutation(getOpsItemRequest).build());
    }

    /**
     * <p>
     * View operational metadata related to an application in Application Manager.
     * </p>
     *
     * @param getOpsMetadataRequest
     * @return Result of the GetOpsMetadata operation returned by the service.
     * @throws OpsMetadataNotFoundException
     *         The OpsMetadata object does not exist.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOpsMetadataResponse getOpsMetadata(GetOpsMetadataRequest getOpsMetadataRequest)
            throws OpsMetadataNotFoundException, OpsMetadataInvalidArgumentException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * View operational metadata related to an application in Application Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpsMetadataRequest.Builder} avoiding the need to
     * create one manually via {@link GetOpsMetadataRequest#builder()}
     * </p>
     *
     * @param getOpsMetadataRequest
     *        A {@link Consumer} that will call methods on {@link GetOpsMetadataRequest.Builder} to create a request.
     * @return Result of the GetOpsMetadata operation returned by the service.
     * @throws OpsMetadataNotFoundException
     *         The OpsMetadata object does not exist.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOpsMetadataResponse getOpsMetadata(Consumer<GetOpsMetadataRequest.Builder> getOpsMetadataRequest)
            throws OpsMetadataNotFoundException, OpsMetadataInvalidArgumentException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return getOpsMetadata(GetOpsMetadataRequest.builder().applyMutation(getOpsMetadataRequest).build());
    }

    /**
     * <p>
     * View a summary of OpsItems based on specified filters and aggregators.
     * </p>
     *
     * @param getOpsSummaryRequest
     * @return Result of the GetOpsSummary operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncNotFoundException
     *         The specified sync name was not found.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator is not valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetOpsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOpsSummaryResponse getOpsSummary(GetOpsSummaryRequest getOpsSummaryRequest) throws InternalServerErrorException,
            ResourceDataSyncNotFoundException, InvalidFilterException, InvalidNextTokenException, InvalidTypeNameException,
            InvalidAggregatorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * View a summary of OpsItems based on specified filters and aggregators.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpsSummaryRequest.Builder} avoiding the need to
     * create one manually via {@link GetOpsSummaryRequest#builder()}
     * </p>
     *
     * @param getOpsSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetOpsSummaryRequest.Builder} to create a request.
     * @return Result of the GetOpsSummary operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncNotFoundException
     *         The specified sync name was not found.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator is not valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetOpsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOpsSummaryResponse getOpsSummary(Consumer<GetOpsSummaryRequest.Builder> getOpsSummaryRequest)
            throws InternalServerErrorException, ResourceDataSyncNotFoundException, InvalidFilterException,
            InvalidNextTokenException, InvalidTypeNameException, InvalidAggregatorException, AwsServiceException,
            SdkClientException, SsmException {
        return getOpsSummary(GetOpsSummaryRequest.builder().applyMutation(getOpsSummaryRequest).build());
    }

    /**
     * <p>
     * View a summary of OpsItems based on specified filters and aggregators.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getOpsSummary(software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryIterable responses = client.getOpsSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryIterable responses = client.getOpsSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryIterable responses = client.getOpsSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOpsSummary(software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest)} operation.</b>
     * </p>
     *
     * @param getOpsSummaryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncNotFoundException
     *         The specified sync name was not found.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator is not valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetOpsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOpsSummaryIterable getOpsSummaryPaginator(GetOpsSummaryRequest getOpsSummaryRequest)
            throws InternalServerErrorException, ResourceDataSyncNotFoundException, InvalidFilterException,
            InvalidNextTokenException, InvalidTypeNameException, InvalidAggregatorException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * View a summary of OpsItems based on specified filters and aggregators.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getOpsSummary(software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryIterable responses = client.getOpsSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryIterable responses = client.getOpsSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryIterable responses = client.getOpsSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOpsSummary(software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpsSummaryRequest.Builder} avoiding the need to
     * create one manually via {@link GetOpsSummaryRequest#builder()}
     * </p>
     *
     * @param getOpsSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetOpsSummaryRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncNotFoundException
     *         The specified sync name was not found.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator is not valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetOpsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOpsSummaryIterable getOpsSummaryPaginator(Consumer<GetOpsSummaryRequest.Builder> getOpsSummaryRequest)
            throws InternalServerErrorException, ResourceDataSyncNotFoundException, InvalidFilterException,
            InvalidNextTokenException, InvalidTypeNameException, InvalidAggregatorException, AwsServiceException,
            SdkClientException, SsmException {
        return getOpsSummaryPaginator(GetOpsSummaryRequest.builder().applyMutation(getOpsSummaryRequest).build());
    }

    /**
     * <p>
     * Get information about a parameter by using the parameter name. Don't confuse this API action with the
     * <a>GetParameters</a> API action.
     * </p>
     *
     * @param getParameterRequest
     * @return Result of the GetParameter operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws ParameterVersionNotFoundException
     *         The specified parameter version was not found. Verify the parameter name and version, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParameterResponse getParameter(GetParameterRequest getParameterRequest) throws InternalServerErrorException,
            InvalidKeyIdException, ParameterNotFoundException, ParameterVersionNotFoundException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a parameter by using the parameter name. Don't confuse this API action with the
     * <a>GetParameters</a> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParameterRequest.Builder} avoiding the need to
     * create one manually via {@link GetParameterRequest#builder()}
     * </p>
     *
     * @param getParameterRequest
     *        A {@link Consumer} that will call methods on {@link GetParameterRequest.Builder} to create a request.
     * @return Result of the GetParameter operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws ParameterVersionNotFoundException
     *         The specified parameter version was not found. Verify the parameter name and version, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParameterResponse getParameter(Consumer<GetParameterRequest.Builder> getParameterRequest)
            throws InternalServerErrorException, InvalidKeyIdException, ParameterNotFoundException,
            ParameterVersionNotFoundException, AwsServiceException, SdkClientException, SsmException {
        return getParameter(GetParameterRequest.builder().applyMutation(getParameterRequest).build());
    }

    /**
     * <p>
     * Retrieves the history of all changes to a parameter.
     * </p>
     *
     * @param getParameterHistoryRequest
     * @return Result of the GetParameterHistory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParameterHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParameterHistoryResponse getParameterHistory(GetParameterHistoryRequest getParameterHistoryRequest)
            throws InternalServerErrorException, ParameterNotFoundException, InvalidNextTokenException, InvalidKeyIdException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the history of all changes to a parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParameterHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link GetParameterHistoryRequest#builder()}
     * </p>
     *
     * @param getParameterHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetParameterHistoryRequest.Builder} to create a
     *        request.
     * @return Result of the GetParameterHistory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParameterHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParameterHistoryResponse getParameterHistory(
            Consumer<GetParameterHistoryRequest.Builder> getParameterHistoryRequest) throws InternalServerErrorException,
            ParameterNotFoundException, InvalidNextTokenException, InvalidKeyIdException, AwsServiceException,
            SdkClientException, SsmException {
        return getParameterHistory(GetParameterHistoryRequest.builder().applyMutation(getParameterHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the history of all changes to a parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getParameterHistory(software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryIterable responses = client.getParameterHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryIterable responses = client
     *             .getParameterHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryIterable responses = client.getParameterHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getParameterHistory(software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest)} operation.</b>
     * </p>
     *
     * @param getParameterHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParameterHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParameterHistoryIterable getParameterHistoryPaginator(GetParameterHistoryRequest getParameterHistoryRequest)
            throws InternalServerErrorException, ParameterNotFoundException, InvalidNextTokenException, InvalidKeyIdException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the history of all changes to a parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getParameterHistory(software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryIterable responses = client.getParameterHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryIterable responses = client
     *             .getParameterHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryIterable responses = client.getParameterHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getParameterHistory(software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParameterHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link GetParameterHistoryRequest#builder()}
     * </p>
     *
     * @param getParameterHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetParameterHistoryRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParameterHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParameterHistoryIterable getParameterHistoryPaginator(
            Consumer<GetParameterHistoryRequest.Builder> getParameterHistoryRequest) throws InternalServerErrorException,
            ParameterNotFoundException, InvalidNextTokenException, InvalidKeyIdException, AwsServiceException,
            SdkClientException, SsmException {
        return getParameterHistoryPaginator(GetParameterHistoryRequest.builder().applyMutation(getParameterHistoryRequest)
                .build());
    }

    /**
     * <p>
     * Get details of a parameter. Don't confuse this API action with the <a>GetParameter</a> API action.
     * </p>
     *
     * @param getParametersRequest
     * @return Result of the GetParameters operation returned by the service.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParametersResponse getParameters(GetParametersRequest getParametersRequest) throws InvalidKeyIdException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get details of a parameter. Don't confuse this API action with the <a>GetParameter</a> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParametersRequest.Builder} avoiding the need to
     * create one manually via {@link GetParametersRequest#builder()}
     * </p>
     *
     * @param getParametersRequest
     *        A {@link Consumer} that will call methods on {@link GetParametersRequest.Builder} to create a request.
     * @return Result of the GetParameters operation returned by the service.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParametersResponse getParameters(Consumer<GetParametersRequest.Builder> getParametersRequest)
            throws InvalidKeyIdException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return getParameters(GetParametersRequest.builder().applyMutation(getParametersRequest).build());
    }

    /**
     * <p>
     * Retrieve information about one or more parameters in a specific hierarchy.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note>
     *
     * @param getParametersByPathRequest
     * @return Result of the GetParametersByPath operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParametersByPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParametersByPathResponse getParametersByPath(GetParametersByPathRequest getParametersByPathRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidFilterOptionException,
            InvalidFilterValueException, InvalidKeyIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve information about one or more parameters in a specific hierarchy.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParametersByPathRequest.Builder} avoiding the
     * need to create one manually via {@link GetParametersByPathRequest#builder()}
     * </p>
     *
     * @param getParametersByPathRequest
     *        A {@link Consumer} that will call methods on {@link GetParametersByPathRequest.Builder} to create a
     *        request.
     * @return Result of the GetParametersByPath operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParametersByPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParametersByPathResponse getParametersByPath(
            Consumer<GetParametersByPathRequest.Builder> getParametersByPathRequest) throws InternalServerErrorException,
            InvalidFilterKeyException, InvalidFilterOptionException, InvalidFilterValueException, InvalidKeyIdException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return getParametersByPath(GetParametersByPathRequest.builder().applyMutation(getParametersByPathRequest).build());
    }

    /**
     * <p>
     * Retrieve information about one or more parameters in a specific hierarchy.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getParametersByPath(software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParametersByPathIterable responses = client.getParametersByPathPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetParametersByPathIterable responses = client
     *             .getParametersByPathPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParametersByPathIterable responses = client.getParametersByPathPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getParametersByPath(software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest)} operation.</b>
     * </p>
     *
     * @param getParametersByPathRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParametersByPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParametersByPathIterable getParametersByPathPaginator(GetParametersByPathRequest getParametersByPathRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidFilterOptionException,
            InvalidFilterValueException, InvalidKeyIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve information about one or more parameters in a specific hierarchy.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getParametersByPath(software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParametersByPathIterable responses = client.getParametersByPathPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetParametersByPathIterable responses = client
     *             .getParametersByPathPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParametersByPathIterable responses = client.getParametersByPathPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getParametersByPath(software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParametersByPathRequest.Builder} avoiding the
     * need to create one manually via {@link GetParametersByPathRequest#builder()}
     * </p>
     *
     * @param getParametersByPathRequest
     *        A {@link Consumer} that will call methods on {@link GetParametersByPathRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option is not valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value is not valid. Verify the value and try again.
     * @throws InvalidKeyIdException
     *         The query key ID is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParametersByPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParametersByPathIterable getParametersByPathPaginator(
            Consumer<GetParametersByPathRequest.Builder> getParametersByPathRequest) throws InternalServerErrorException,
            InvalidFilterKeyException, InvalidFilterOptionException, InvalidFilterValueException, InvalidKeyIdException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return getParametersByPathPaginator(GetParametersByPathRequest.builder().applyMutation(getParametersByPathRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a patch baseline.
     * </p>
     *
     * @param getPatchBaselineRequest
     * @return Result of the GetPatchBaseline operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPatchBaselineResponse getPatchBaseline(GetPatchBaselineRequest getPatchBaselineRequest)
            throws DoesNotExistException, InvalidResourceIdException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPatchBaselineRequest.Builder} avoiding the need
     * to create one manually via {@link GetPatchBaselineRequest#builder()}
     * </p>
     *
     * @param getPatchBaselineRequest
     *        A {@link Consumer} that will call methods on {@link GetPatchBaselineRequest.Builder} to create a request.
     * @return Result of the GetPatchBaseline operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or Patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default GetPatchBaselineResponse getPatchBaseline(Consumer<GetPatchBaselineRequest.Builder> getPatchBaselineRequest)
            throws DoesNotExistException, InvalidResourceIdException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        return getPatchBaseline(GetPatchBaselineRequest.builder().applyMutation(getPatchBaselineRequest).build());
    }

    /**
     * <p>
     * Retrieves the patch baseline that should be used for the specified patch group.
     * </p>
     *
     * @param getPatchBaselineForPatchGroupRequest
     * @return Result of the GetPatchBaselineForPatchGroup operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPatchBaselineForPatchGroupResponse getPatchBaselineForPatchGroup(
            GetPatchBaselineForPatchGroupRequest getPatchBaselineForPatchGroupRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the patch baseline that should be used for the specified patch group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPatchBaselineForPatchGroupRequest.Builder}
     * avoiding the need to create one manually via {@link GetPatchBaselineForPatchGroupRequest#builder()}
     * </p>
     *
     * @param getPatchBaselineForPatchGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetPatchBaselineForPatchGroupRequest.Builder} to
     *        create a request.
     * @return Result of the GetPatchBaselineForPatchGroup operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPatchBaselineForPatchGroupResponse getPatchBaselineForPatchGroup(
            Consumer<GetPatchBaselineForPatchGroupRequest.Builder> getPatchBaselineForPatchGroupRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return getPatchBaselineForPatchGroup(GetPatchBaselineForPatchGroupRequest.builder()
                .applyMutation(getPatchBaselineForPatchGroupRequest).build());
    }

    /**
     * <p>
     * <code>ServiceSetting</code> is an account-level setting for an AWS service. This setting defines how a user
     * interacts with or uses a service or a feature of a service. For example, if an AWS service charges money to the
     * account based on feature or service usage, then the AWS service team might create a default setting of "false".
     * This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for
     * a paid feature.
     * </p>
     * <p>
     * Services map a <code>SettingId</code> object to a setting value. AWS services teams define the default value for
     * a <code>SettingId</code>. You can't create a new <code>SettingId</code>, but you can overwrite the default value
     * if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the
     * <a>UpdateServiceSetting</a> API action to change the default setting. Or use the <a>ResetServiceSetting</a> to
     * change the value back to the original value defined by the AWS service team.
     * </p>
     * <p>
     * Query the current service setting for the account.
     * </p>
     *
     * @param getServiceSettingRequest
     *        The request body of the GetServiceSetting API action.
     * @return Result of the GetServiceSetting operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ServiceSettingNotFoundException
     *         The specified service setting was not found. Either the service name or the setting has not been
     *         provisioned by the AWS service team.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetServiceSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSetting" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServiceSettingResponse getServiceSetting(GetServiceSettingRequest getServiceSettingRequest)
            throws InternalServerErrorException, ServiceSettingNotFoundException, AwsServiceException, SdkClientException,
            SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>ServiceSetting</code> is an account-level setting for an AWS service. This setting defines how a user
     * interacts with or uses a service or a feature of a service. For example, if an AWS service charges money to the
     * account based on feature or service usage, then the AWS service team might create a default setting of "false".
     * This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for
     * a paid feature.
     * </p>
     * <p>
     * Services map a <code>SettingId</code> object to a setting value. AWS services teams define the default value for
     * a <code>SettingId</code>. You can't create a new <code>SettingId</code>, but you can overwrite the default value
     * if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the
     * <a>UpdateServiceSetting</a> API action to change the default setting. Or use the <a>ResetServiceSetting</a> to
     * change the value back to the original value defined by the AWS service team.
     * </p>
     * <p>
     * Query the current service setting for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceSettingRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceSettingRequest#builder()}
     * </p>
     *
     * @param getServiceSettingRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceSettingRequest.Builder} to create a request.
     *        The request body of the GetServiceSetting API action.
     * @return Result of the GetServiceSetting operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ServiceSettingNotFoundException
     *         The specified service setting was not found. Either the service name or the setting has not been
     *         provisioned by the AWS service team.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetServiceSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSetting" target="_top">AWS API
     *      Documentation</a>
     */
    default GetServiceSettingResponse getServiceSetting(Consumer<GetServiceSettingRequest.Builder> getServiceSettingRequest)
            throws InternalServerErrorException, ServiceSettingNotFoundException, AwsServiceException, SdkClientException,
            SsmException {
        return getServiceSetting(GetServiceSettingRequest.builder().applyMutation(getServiceSettingRequest).build());
    }

    /**
     * <p>
     * A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a
     * parameter, Systems Manager automatically saves a new version and increments the version number by one. A label
     * can help you remember the purpose of a parameter when there are multiple versions.
     * </p>
     * <p>
     * Parameter labels have the following requirements and restrictions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A version of a parameter can have a maximum of 10 labels.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't attach the same label to different versions of the same parameter. For example, if version 1 has the
     * label Production, then you can't attach Production to version 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can move a label from one version of a parameter to another.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't create a label when you create a new parameter. You must attach a label to a specific version of a
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't delete a parameter label. If you no longer want to use a parameter label, then you must move it to a
     * different version of a parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A label can have a maximum of 100 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or underscores (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Labels can't begin with a number, "aws," or "ssm" (not case sensitive). If a label fails to meet these
     * requirements, then the label is not associated with a parameter and the system displays it in the list of
     * InvalidLabels.
     * </p>
     * </li>
     * </ul>
     *
     * @param labelParameterVersionRequest
     * @return Result of the LabelParameterVersion operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws ParameterVersionNotFoundException
     *         The specified parameter version was not found. Verify the parameter name and version, and try again.
     * @throws ParameterVersionLabelLimitExceededException
     *         A parameter version can have a maximum of ten labels.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.LabelParameterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/LabelParameterVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default LabelParameterVersionResponse labelParameterVersion(LabelParameterVersionRequest labelParameterVersionRequest)
            throws InternalServerErrorException, TooManyUpdatesException, ParameterNotFoundException,
            ParameterVersionNotFoundException, ParameterVersionLabelLimitExceededException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a
     * parameter, Systems Manager automatically saves a new version and increments the version number by one. A label
     * can help you remember the purpose of a parameter when there are multiple versions.
     * </p>
     * <p>
     * Parameter labels have the following requirements and restrictions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A version of a parameter can have a maximum of 10 labels.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't attach the same label to different versions of the same parameter. For example, if version 1 has the
     * label Production, then you can't attach Production to version 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can move a label from one version of a parameter to another.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't create a label when you create a new parameter. You must attach a label to a specific version of a
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't delete a parameter label. If you no longer want to use a parameter label, then you must move it to a
     * different version of a parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A label can have a maximum of 100 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or underscores (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Labels can't begin with a number, "aws," or "ssm" (not case sensitive). If a label fails to meet these
     * requirements, then the label is not associated with a parameter and the system displays it in the list of
     * InvalidLabels.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link LabelParameterVersionRequest.Builder} avoiding the
     * need to create one manually via {@link LabelParameterVersionRequest#builder()}
     * </p>
     *
     * @param labelParameterVersionRequest
     *        A {@link Consumer} that will call methods on {@link LabelParameterVersionRequest.Builder} to create a
     *        request.
     * @return Result of the LabelParameterVersion operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws ParameterNotFoundException
     *         The parameter could not be found. Verify the name and try again.
     * @throws ParameterVersionNotFoundException
     *         The specified parameter version was not found. Verify the parameter name and version, and try again.
     * @throws ParameterVersionLabelLimitExceededException
     *         A parameter version can have a maximum of ten labels.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.LabelParameterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/LabelParameterVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default LabelParameterVersionResponse labelParameterVersion(
            Consumer<LabelParameterVersionRequest.Builder> labelParameterVersionRequest) throws InternalServerErrorException,
            TooManyUpdatesException, ParameterNotFoundException, ParameterVersionNotFoundException,
            ParameterVersionLabelLimitExceededException, AwsServiceException, SdkClientException, SsmException {
        return labelParameterVersion(LabelParameterVersionRequest.builder().applyMutation(labelParameterVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     *
     * @param listAssociationVersionsRequest
     * @return Result of the ListAssociationVersions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociationVersionsResponse listAssociationVersions(ListAssociationVersionsRequest listAssociationVersionsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, AssociationDoesNotExistException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssociationVersionsRequest#builder()}
     * </p>
     *
     * @param listAssociationVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociationVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssociationVersions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociationVersionsResponse listAssociationVersions(
            Consumer<ListAssociationVersionsRequest.Builder> listAssociationVersionsRequest) throws InternalServerErrorException,
            InvalidNextTokenException, AssociationDoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        return listAssociationVersions(ListAssociationVersionsRequest.builder().applyMutation(listAssociationVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociationVersions(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsIterable responses = client.listAssociationVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsIterable responses = client
     *             .listAssociationVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsIterable responses = client.listAssociationVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociationVersions(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociationVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociationVersionsIterable listAssociationVersionsPaginator(
            ListAssociationVersionsRequest listAssociationVersionsRequest) throws InternalServerErrorException,
            InvalidNextTokenException, AssociationDoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociationVersions(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsIterable responses = client.listAssociationVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsIterable responses = client
     *             .listAssociationVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsIterable responses = client.listAssociationVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociationVersions(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssociationVersionsRequest#builder()}
     * </p>
     *
     * @param listAssociationVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociationVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws AssociationDoesNotExistException
     *         The specified association does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociationVersionsIterable listAssociationVersionsPaginator(
            Consumer<ListAssociationVersionsRequest.Builder> listAssociationVersionsRequest) throws InternalServerErrorException,
            InvalidNextTokenException, AssociationDoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        return listAssociationVersionsPaginator(ListAssociationVersionsRequest.builder()
                .applyMutation(listAssociationVersionsRequest).build());
    }

    /**
     * <p>
     * Returns all State Manager associations in the current AWS account and Region. You can limit the results to a
     * specific State Manager association document or instance by specifying a filter.
     * </p>
     *
     * @return Result of the ListAssociations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociations
     * @see #listAssociations(ListAssociationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssociationsResponse listAssociations() throws InternalServerErrorException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return listAssociations(ListAssociationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns all State Manager associations in the current AWS account and Region. You can limit the results to a
     * specific State Manager association document or instance by specifying a filter.
     * </p>
     *
     * @param listAssociationsRequest
     * @return Result of the ListAssociations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssociationsResponse listAssociations(ListAssociationsRequest listAssociationsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all State Manager associations in the current AWS account and Region. You can limit the results to a
     * specific State Manager association document or instance by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssociationsRequest#builder()}
     * </p>
     *
     * @param listAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociationsRequest.Builder} to create a request.
     * @return Result of the ListAssociations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssociationsResponse listAssociations(Consumer<ListAssociationsRequest.Builder> listAssociationsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return listAssociations(ListAssociationsRequest.builder().applyMutation(listAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns all State Manager associations in the current AWS account and Region. You can limit the results to a
     * specific State Manager association document or instance by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociations
     * @see #listAssociationsPaginator(ListAssociationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssociationsIterable listAssociationsPaginator() throws InternalServerErrorException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return listAssociationsPaginator(ListAssociationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns all State Manager associations in the current AWS account and Region. You can limit the results to a
     * specific State Manager association document or instance by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)} operation.</b>
     * </p>
     *
     * @param listAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssociationsIterable listAssociationsPaginator(ListAssociationsRequest listAssociationsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all State Manager associations in the current AWS account and Region. You can limit the results to a
     * specific State Manager association document or instance by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssociationsRequest#builder()}
     * </p>
     *
     * @param listAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssociationsIterable listAssociationsPaginator(Consumer<ListAssociationsRequest.Builder> listAssociationsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return listAssociationsPaginator(ListAssociationsRequest.builder().applyMutation(listAssociationsRequest).build());
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then
     * a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     *
     * @return Result of the ListCommandInvocations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommandInvocations
     * @see #listCommandInvocations(ListCommandInvocationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCommandInvocationsResponse listCommandInvocations() throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, InvalidFilterKeyException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return listCommandInvocations(ListCommandInvocationsRequest.builder().build());
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then
     * a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     *
     * @param listCommandInvocationsRequest
     * @return Result of the ListCommandInvocations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCommandInvocationsResponse listCommandInvocations(ListCommandInvocationsRequest listCommandInvocationsRequest)
            throws InternalServerErrorException, InvalidCommandIdException, InvalidInstanceIdException,
            InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then
     * a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCommandInvocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCommandInvocationsRequest#builder()}
     * </p>
     *
     * @param listCommandInvocationsRequest
     *        A {@link Consumer} that will call methods on {@link ListCommandInvocationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListCommandInvocations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCommandInvocationsResponse listCommandInvocations(
            Consumer<ListCommandInvocationsRequest.Builder> listCommandInvocationsRequest) throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, InvalidFilterKeyException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return listCommandInvocations(ListCommandInvocationsRequest.builder().applyMutation(listCommandInvocationsRequest)
                .build());
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then
     * a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable responses = client.listCommandInvocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable responses = client
     *             .listCommandInvocationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable responses = client.listCommandInvocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommandInvocations
     * @see #listCommandInvocationsPaginator(ListCommandInvocationsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCommandInvocationsIterable listCommandInvocationsPaginator() throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, InvalidFilterKeyException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return listCommandInvocationsPaginator(ListCommandInvocationsRequest.builder().build());
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then
     * a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable responses = client.listCommandInvocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable responses = client
     *             .listCommandInvocationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable responses = client.listCommandInvocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCommandInvocationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCommandInvocationsIterable listCommandInvocationsPaginator(
            ListCommandInvocationsRequest listCommandInvocationsRequest) throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, InvalidFilterKeyException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then
     * a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable responses = client.listCommandInvocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable responses = client
     *             .listCommandInvocationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable responses = client.listCommandInvocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCommandInvocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCommandInvocationsRequest#builder()}
     * </p>
     *
     * @param listCommandInvocationsRequest
     *        A {@link Consumer} that will call methods on {@link ListCommandInvocationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCommandInvocationsIterable listCommandInvocationsPaginator(
            Consumer<ListCommandInvocationsRequest.Builder> listCommandInvocationsRequest) throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, InvalidFilterKeyException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return listCommandInvocationsPaginator(ListCommandInvocationsRequest.builder()
                .applyMutation(listCommandInvocationsRequest).build());
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     *
     * @return Result of the ListCommands operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommands
     * @see #listCommands(ListCommandsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommandsResponse listCommands() throws InternalServerErrorException, InvalidCommandIdException,
            InvalidInstanceIdException, InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return listCommands(ListCommandsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     *
     * @param listCommandsRequest
     * @return Result of the ListCommands operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommandsResponse listCommands(ListCommandsRequest listCommandsRequest) throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, InvalidFilterKeyException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCommandsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCommandsRequest#builder()}
     * </p>
     *
     * @param listCommandsRequest
     *        A {@link Consumer} that will call methods on {@link ListCommandsRequest.Builder} to create a request.
     * @return Result of the ListCommands operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommandsResponse listCommands(Consumer<ListCommandsRequest.Builder> listCommandsRequest)
            throws InternalServerErrorException, InvalidCommandIdException, InvalidInstanceIdException,
            InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return listCommands(ListCommandsRequest.builder().applyMutation(listCommandsRequest).build());
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable responses = client.listCommandsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable responses = client.listCommandsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListCommandsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable responses = client.listCommandsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommands
     * @see #listCommandsPaginator(ListCommandsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommandsIterable listCommandsPaginator() throws InternalServerErrorException, InvalidCommandIdException,
            InvalidInstanceIdException, InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return listCommandsPaginator(ListCommandsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable responses = client.listCommandsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable responses = client.listCommandsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListCommandsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable responses = client.listCommandsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)} operation.</b>
     * </p>
     *
     * @param listCommandsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommandsIterable listCommandsPaginator(ListCommandsRequest listCommandsRequest)
            throws InternalServerErrorException, InvalidCommandIdException, InvalidInstanceIdException,
            InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable responses = client.listCommandsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable responses = client.listCommandsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListCommandsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable responses = client.listCommandsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCommandsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCommandsRequest#builder()}
     * </p>
     *
     * @param listCommandsRequest
     *        A {@link Consumer} that will call methods on {@link ListCommandsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommandsIterable listCommandsPaginator(Consumer<ListCommandsRequest.Builder> listCommandsRequest)
            throws InternalServerErrorException, InvalidCommandIdException, InvalidInstanceIdException,
            InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return listCommandsPaginator(ListCommandsRequest.builder().applyMutation(listCommandsRequest).build());
    }

    /**
     * <p>
     * For a specified resource ID, this API action returns a list of compliance statuses for different resource types.
     * Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the
     * filter.
     * </p>
     *
     * @param listComplianceItemsRequest
     * @return Result of the ListComplianceItems operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The resource type is not valid. For example, if you are attempting to tag an instance, the instance must
     *         be a registered, managed instance.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComplianceItemsResponse listComplianceItems(ListComplianceItemsRequest listComplianceItemsRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException,
            InvalidFilterException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a specified resource ID, this API action returns a list of compliance statuses for different resource types.
     * Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the
     * filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComplianceItemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListComplianceItemsRequest#builder()}
     * </p>
     *
     * @param listComplianceItemsRequest
     *        A {@link Consumer} that will call methods on {@link ListComplianceItemsRequest.Builder} to create a
     *        request.
     * @return Result of the ListComplianceItems operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The resource type is not valid. For example, if you are attempting to tag an instance, the instance must
     *         be a registered, managed instance.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComplianceItemsResponse listComplianceItems(
            Consumer<ListComplianceItemsRequest.Builder> listComplianceItemsRequest) throws InvalidResourceTypeException,
            InvalidResourceIdException, InternalServerErrorException, InvalidFilterException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return listComplianceItems(ListComplianceItemsRequest.builder().applyMutation(listComplianceItemsRequest).build());
    }

    /**
     * <p>
     * For a specified resource ID, this API action returns a list of compliance statuses for different resource types.
     * Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the
     * filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceItems(software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsIterable responses = client.listComplianceItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsIterable responses = client
     *             .listComplianceItemsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsIterable responses = client.listComplianceItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceItems(software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest)} operation.</b>
     * </p>
     *
     * @param listComplianceItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceTypeException
     *         The resource type is not valid. For example, if you are attempting to tag an instance, the instance must
     *         be a registered, managed instance.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComplianceItemsIterable listComplianceItemsPaginator(ListComplianceItemsRequest listComplianceItemsRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException,
            InvalidFilterException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a specified resource ID, this API action returns a list of compliance statuses for different resource types.
     * Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the
     * filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceItems(software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsIterable responses = client.listComplianceItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsIterable responses = client
     *             .listComplianceItemsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsIterable responses = client.listComplianceItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceItems(software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComplianceItemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListComplianceItemsRequest#builder()}
     * </p>
     *
     * @param listComplianceItemsRequest
     *        A {@link Consumer} that will call methods on {@link ListComplianceItemsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceTypeException
     *         The resource type is not valid. For example, if you are attempting to tag an instance, the instance must
     *         be a registered, managed instance.
     * @throws InvalidResourceIdException
     *         The resource ID is not valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComplianceItemsIterable listComplianceItemsPaginator(
            Consumer<ListComplianceItemsRequest.Builder> listComplianceItemsRequest) throws InvalidResourceTypeException,
            InvalidResourceIdException, InternalServerErrorException, InvalidFilterException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return listComplianceItemsPaginator(ListComplianceItemsRequest.builder().applyMutation(listComplianceItemsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     *
     * @return Result of the ListComplianceSummaries operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceSummaries
     * @see #listComplianceSummaries(ListComplianceSummariesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComplianceSummariesResponse listComplianceSummaries() throws InvalidFilterException, InvalidNextTokenException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return listComplianceSummaries(ListComplianceSummariesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     *
     * @param listComplianceSummariesRequest
     * @return Result of the ListComplianceSummaries operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComplianceSummariesResponse listComplianceSummaries(ListComplianceSummariesRequest listComplianceSummariesRequest)
            throws InvalidFilterException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComplianceSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListComplianceSummariesRequest#builder()}
     * </p>
     *
     * @param listComplianceSummariesRequest
     *        A {@link Consumer} that will call methods on {@link ListComplianceSummariesRequest.Builder} to create a
     *        request.
     * @return Result of the ListComplianceSummaries operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComplianceSummariesResponse listComplianceSummaries(
            Consumer<ListComplianceSummariesRequest.Builder> listComplianceSummariesRequest) throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return listComplianceSummaries(ListComplianceSummariesRequest.builder().applyMutation(listComplianceSummariesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable responses = client.listComplianceSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable responses = client
     *             .listComplianceSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable responses = client.listComplianceSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceSummaries
     * @see #listComplianceSummariesPaginator(ListComplianceSummariesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComplianceSummariesIterable listComplianceSummariesPaginator() throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return listComplianceSummariesPaginator(ListComplianceSummariesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable responses = client.listComplianceSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable responses = client
     *             .listComplianceSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable responses = client.listComplianceSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComplianceSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComplianceSummariesIterable listComplianceSummariesPaginator(
            ListComplianceSummariesRequest listComplianceSummariesRequest) throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable responses = client.listComplianceSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable responses = client
     *             .listComplianceSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable responses = client.listComplianceSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComplianceSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListComplianceSummariesRequest#builder()}
     * </p>
     *
     * @param listComplianceSummariesRequest
     *        A {@link Consumer} that will call methods on {@link ListComplianceSummariesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComplianceSummariesIterable listComplianceSummariesPaginator(
            Consumer<ListComplianceSummariesRequest.Builder> listComplianceSummariesRequest) throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return listComplianceSummariesPaginator(ListComplianceSummariesRequest.builder()
                .applyMutation(listComplianceSummariesRequest).build());
    }

    /**
     * <p>
     * Information about approval reviews for a version of an SSM document.
     * </p>
     *
     * @param listDocumentMetadataHistoryRequest
     * @return Result of the ListDocumentMetadataHistory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocumentMetadataHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentMetadataHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentMetadataHistoryResponse listDocumentMetadataHistory(
            ListDocumentMetadataHistoryRequest listDocumentMetadataHistoryRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information about approval reviews for a version of an SSM document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentMetadataHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link ListDocumentMetadataHistoryRequest#builder()}
     * </p>
     *
     * @param listDocumentMetadataHistoryRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentMetadataHistoryRequest.Builder} to create
     *        a request.
     * @return Result of the ListDocumentMetadataHistory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws InvalidDocumentVersionException
     *         The document version is not valid or does not exist.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocumentMetadataHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentMetadataHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListDocumentMetadataHistoryResponse listDocumentMetadataHistory(
            Consumer<ListDocumentMetadataHistoryRequest.Builder> listDocumentMetadataHistoryRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentVersionException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return listDocumentMetadataHistory(ListDocumentMetadataHistoryRequest.builder()
                .applyMutation(listDocumentMetadataHistoryRequest).build());
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     *
     * @param listDocumentVersionsRequest
     * @return Result of the ListDocumentVersions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentVersionsResponse listDocumentVersions(ListDocumentVersionsRequest listDocumentVersionsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, InvalidDocumentException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDocumentVersionsRequest#builder()}
     * </p>
     *
     * @param listDocumentVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentVersionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListDocumentVersions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentVersionsResponse listDocumentVersions(
            Consumer<ListDocumentVersionsRequest.Builder> listDocumentVersionsRequest) throws InternalServerErrorException,
            InvalidNextTokenException, InvalidDocumentException, AwsServiceException, SdkClientException, SsmException {
        return listDocumentVersions(ListDocumentVersionsRequest.builder().applyMutation(listDocumentVersionsRequest).build());
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentVersions(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsIterable responses = client.listDocumentVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsIterable responses = client
     *             .listDocumentVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsIterable responses = client.listDocumentVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentVersions(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentVersionsIterable listDocumentVersionsPaginator(ListDocumentVersionsRequest listDocumentVersionsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, InvalidDocumentException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentVersions(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsIterable responses = client.listDocumentVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsIterable responses = client
     *             .listDocumentVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsIterable responses = client.listDocumentVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentVersions(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDocumentVersionsRequest#builder()}
     * </p>
     *
     * @param listDocumentVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentVersionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidDocumentException
     *         The specified document does not exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentVersionsIterable listDocumentVersionsPaginator(
            Consumer<ListDocumentVersionsRequest.Builder> listDocumentVersionsRequest) throws InternalServerErrorException,
            InvalidNextTokenException, InvalidDocumentException, AwsServiceException, SdkClientException, SsmException {
        return listDocumentVersionsPaginator(ListDocumentVersionsRequest.builder().applyMutation(listDocumentVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of
     * this request by using a filter.
     * </p>
     *
     * @return Result of the ListDocuments operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocuments
     * @see #listDocuments(ListDocumentsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsResponse listDocuments() throws InternalServerErrorException, InvalidNextTokenException,
            InvalidFilterKeyException, AwsServiceException, SdkClientException, SsmException {
        return listDocuments(ListDocumentsRequest.builder().build());
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of
     * this request by using a filter.
     * </p>
     *
     * @param listDocumentsRequest
     * @return Result of the ListDocuments operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsResponse listDocuments(ListDocumentsRequest listDocumentsRequest) throws InternalServerErrorException,
            InvalidNextTokenException, InvalidFilterKeyException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of
     * this request by using a filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDocumentsRequest#builder()}
     * </p>
     *
     * @param listDocumentsRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentsRequest.Builder} to create a request.
     * @return Result of the ListDocuments operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsResponse listDocuments(Consumer<ListDocumentsRequest.Builder> listDocumentsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, InvalidFilterKeyException, AwsServiceException,
            SdkClientException, SsmException {
        return listDocuments(ListDocumentsRequest.builder().applyMutation(listDocumentsRequest).build());
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of
     * this request by using a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListDocumentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocuments
     * @see #listDocumentsPaginator(ListDocumentsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsIterable listDocumentsPaginator() throws InternalServerErrorException, InvalidNextTokenException,
            InvalidFilterKeyException, AwsServiceException, SdkClientException, SsmException {
        return listDocumentsPaginator(ListDocumentsRequest.builder().build());
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of
     * this request by using a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListDocumentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)} operation.</b>
     * </p>
     *
     * @param listDocumentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsIterable listDocumentsPaginator(ListDocumentsRequest listDocumentsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, InvalidFilterKeyException, AwsServiceException,
            SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of
     * this request by using a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListDocumentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDocumentsRequest#builder()}
     * </p>
     *
     * @param listDocumentsRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InvalidFilterKeyException
     *         The specified key is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsIterable listDocumentsPaginator(Consumer<ListDocumentsRequest.Builder> listDocumentsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, InvalidFilterKeyException, AwsServiceException,
            SdkClientException, SsmException {
        return listDocumentsPaginator(ListDocumentsRequest.builder().applyMutation(listDocumentsRequest).build());
    }

    /**
     * <p>
     * A list of inventory items returned by the request.
     * </p>
     *
     * @param listInventoryEntriesRequest
     * @return Result of the ListInventoryEntries operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListInventoryEntries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInventoryEntriesResponse listInventoryEntries(ListInventoryEntriesRequest listInventoryEntriesRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidTypeNameException, InvalidFilterException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of inventory items returned by the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInventoryEntriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInventoryEntriesRequest#builder()}
     * </p>
     *
     * @param listInventoryEntriesRequest
     *        A {@link Consumer} that will call methods on {@link ListInventoryEntriesRequest.Builder} to create a
     *        request.
     * @return Result of the ListInventoryEntries operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.
     * @throws InvalidTypeNameException
     *         The parameter type name is not valid.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListInventoryEntries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries" target="_top">AWS API
     *      Documentation</a>
     */
    default ListInventoryEntriesResponse listInventoryEntries(
            Consumer<ListInventoryEntriesRequest.Builder> listInventoryEntriesRequest) throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidTypeNameException, InvalidFilterException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return listInventoryEntries(ListInventoryEntriesRequest.builder().applyMutation(listInventoryEntriesRequest).build());
    }

    /**
     * <p>
     * Returns a list of all OpsItem events in the current AWS account and Region. You can limit the results to events
     * associated with specific OpsItems by specifying a filter.
     * </p>
     *
     * @param listOpsItemEventsRequest
     * @return Result of the ListOpsItemEvents operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a
     *         href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsItemEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOpsItemEventsResponse listOpsItemEvents(ListOpsItemEventsRequest listOpsItemEventsRequest)
            throws InternalServerErrorException, OpsItemNotFoundException, OpsItemLimitExceededException,
            OpsItemInvalidParameterException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all OpsItem events in the current AWS account and Region. You can limit the results to events
     * associated with specific OpsItems by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpsItemEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListOpsItemEventsRequest#builder()}
     * </p>
     *
     * @param listOpsItemEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListOpsItemEventsRequest.Builder} to create a request.
     * @return Result of the ListOpsItemEvents operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a
     *         href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsItemEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOpsItemEventsResponse listOpsItemEvents(Consumer<ListOpsItemEventsRequest.Builder> listOpsItemEventsRequest)
            throws InternalServerErrorException, OpsItemNotFoundException, OpsItemLimitExceededException,
            OpsItemInvalidParameterException, AwsServiceException, SdkClientException, SsmException {
        return listOpsItemEvents(ListOpsItemEventsRequest.builder().applyMutation(listOpsItemEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all OpsItem events in the current AWS account and Region. You can limit the results to events
     * associated with specific OpsItems by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOpsItemEvents(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsIterable responses = client.listOpsItemEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsIterable responses = client
     *             .listOpsItemEventsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsIterable responses = client.listOpsItemEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsItemEvents(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest)} operation.</b>
     * </p>
     *
     * @param listOpsItemEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a
     *         href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsItemEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOpsItemEventsIterable listOpsItemEventsPaginator(ListOpsItemEventsRequest listOpsItemEventsRequest)
            throws InternalServerErrorException, OpsItemNotFoundException, OpsItemLimitExceededException,
            OpsItemInvalidParameterException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all OpsItem events in the current AWS account and Region. You can limit the results to events
     * associated with specific OpsItems by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOpsItemEvents(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsIterable responses = client.listOpsItemEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsIterable responses = client
     *             .listOpsItemEventsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsIterable responses = client.listOpsItemEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsItemEvents(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpsItemEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListOpsItemEventsRequest#builder()}
     * </p>
     *
     * @param listOpsItemEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListOpsItemEventsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a
     *         href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsItemEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOpsItemEventsIterable listOpsItemEventsPaginator(
            Consumer<ListOpsItemEventsRequest.Builder> listOpsItemEventsRequest) throws InternalServerErrorException,
            OpsItemNotFoundException, OpsItemLimitExceededException, OpsItemInvalidParameterException, AwsServiceException,
            SdkClientException, SsmException {
        return listOpsItemEventsPaginator(ListOpsItemEventsRequest.builder().applyMutation(listOpsItemEventsRequest).build());
    }

    /**
     * <p>
     * Systems Manager calls this API action when displaying all Application Manager OpsMetadata objects or blobs.
     * </p>
     *
     * @param listOpsMetadataRequest
     * @return Result of the ListOpsMetadata operation returned by the service.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOpsMetadataResponse listOpsMetadata(ListOpsMetadataRequest listOpsMetadataRequest)
            throws OpsMetadataInvalidArgumentException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Systems Manager calls this API action when displaying all Application Manager OpsMetadata objects or blobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpsMetadataRequest.Builder} avoiding the need
     * to create one manually via {@link ListOpsMetadataRequest#builder()}
     * </p>
     *
     * @param listOpsMetadataRequest
     *        A {@link Consumer} that will call methods on {@link ListOpsMetadataRequest.Builder} to create a request.
     * @return Result of the ListOpsMetadata operation returned by the service.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOpsMetadataResponse listOpsMetadata(Consumer<ListOpsMetadataRequest.Builder> listOpsMetadataRequest)
            throws OpsMetadataInvalidArgumentException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        return listOpsMetadata(ListOpsMetadataRequest.builder().applyMutation(listOpsMetadataRequest).build());
    }

    /**
     * <p>
     * Systems Manager calls this API action when displaying all Application Manager OpsMetadata objects or blobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listOpsMetadata(software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataIterable responses = client.listOpsMetadataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataIterable responses = client.listOpsMetadataPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataIterable responses = client.listOpsMetadataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsMetadata(software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest)} operation.</b>
     * </p>
     *
     * @param listOpsMetadataRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOpsMetadataIterable listOpsMetadataPaginator(ListOpsMetadataRequest listOpsMetadataRequest)
            throws OpsMetadataInvalidArgumentException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Systems Manager calls this API action when displaying all Application Manager OpsMetadata objects or blobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listOpsMetadata(software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataIterable responses = client.listOpsMetadataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataIterable responses = client.listOpsMetadataPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataIterable responses = client.listOpsMetadataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsMetadata(software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpsMetadataRequest.Builder} avoiding the need
     * to create one manually via {@link ListOpsMetadataRequest#builder()}
     * </p>
     *
     * @param listOpsMetadataRequest
     *        A {@link Consumer} that will call methods on {@link ListOpsMetadataRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOpsMetadataIterable listOpsMetadataPaginator(Consumer<ListOpsMetadataRequest.Builder> listOpsMetadataRequest)
            throws OpsMetadataInvalidArgumentException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        return listOpsMetadataPaginator(ListOpsMetadataRequest.builder().applyMutation(listOpsMetadataRequest).build());
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     *
     * @return Result of the ListResourceComplianceSummaries operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceComplianceSummaries
     * @see #listResourceComplianceSummaries(ListResourceComplianceSummariesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceComplianceSummariesResponse listResourceComplianceSummaries() throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return listResourceComplianceSummaries(ListResourceComplianceSummariesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     *
     * @param listResourceComplianceSummariesRequest
     * @return Result of the ListResourceComplianceSummaries operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceComplianceSummariesResponse listResourceComplianceSummaries(
            ListResourceComplianceSummariesRequest listResourceComplianceSummariesRequest) throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceComplianceSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceComplianceSummariesRequest#builder()}
     * </p>
     *
     * @param listResourceComplianceSummariesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceComplianceSummariesRequest.Builder} to
     *        create a request.
     * @return Result of the ListResourceComplianceSummaries operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceComplianceSummariesResponse listResourceComplianceSummaries(
            Consumer<ListResourceComplianceSummariesRequest.Builder> listResourceComplianceSummariesRequest)
            throws InvalidFilterException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        return listResourceComplianceSummaries(ListResourceComplianceSummariesRequest.builder()
                .applyMutation(listResourceComplianceSummariesRequest).build());
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable responses = client.listResourceComplianceSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable responses = client
     *             .listResourceComplianceSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable responses = client.listResourceComplianceSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceComplianceSummaries
     * @see #listResourceComplianceSummariesPaginator(ListResourceComplianceSummariesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceComplianceSummariesIterable listResourceComplianceSummariesPaginator() throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return listResourceComplianceSummariesPaginator(ListResourceComplianceSummariesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable responses = client.listResourceComplianceSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable responses = client
     *             .listResourceComplianceSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable responses = client.listResourceComplianceSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceComplianceSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceComplianceSummariesIterable listResourceComplianceSummariesPaginator(
            ListResourceComplianceSummariesRequest listResourceComplianceSummariesRequest) throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable responses = client.listResourceComplianceSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable responses = client
     *             .listResourceComplianceSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable responses = client.listResourceComplianceSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceComplianceSummariesRequest.Builder}
     * avoiding the need to create one manually via {@link ListResourceComplianceSummariesRequest#builder()}
     * </p>
     *
     * @param listResourceComplianceSummariesRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceComplianceSummariesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterException
     *         The filter name is not valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceComplianceSummariesIterable listResourceComplianceSummariesPaginator(
            Consumer<ListResourceComplianceSummariesRequest.Builder> listResourceComplianceSummariesRequest)
            throws InvalidFilterException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        return listResourceComplianceSummariesPaginator(ListResourceComplianceSummariesRequest.builder()
                .applyMutation(listResourceComplianceSummariesRequest).build());
    }

    /**
     * <p>
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start,
     * the last sync status, and the last time a sync successfully completed.
     * </p>
     * <p>
     * The number of sync configurations might be too large to return using a single call to
     * <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the
     * <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the
     * value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request
     * them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call.
     * </p>
     *
     * @return Result of the ListResourceDataSync operation returned by the service.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceDataSync
     * @see #listResourceDataSync(ListResourceDataSyncRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourceDataSyncResponse listResourceDataSync() throws ResourceDataSyncInvalidConfigurationException,
            InternalServerErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return listResourceDataSync(ListResourceDataSyncRequest.builder().build());
    }

    /**
     * <p>
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start,
     * the last sync status, and the last time a sync successfully completed.
     * </p>
     * <p>
     * The number of sync configurations might be too large to return using a single call to
     * <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the
     * <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the
     * value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request
     * them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call.
     * </p>
     *
     * @param listResourceDataSyncRequest
     * @return Result of the ListResourceDataSync operation returned by the service.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourceDataSyncResponse listResourceDataSync(ListResourceDataSyncRequest listResourceDataSyncRequest)
            throws ResourceDataSyncInvalidConfigurationException, InternalServerErrorException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start,
     * the last sync status, and the last time a sync successfully completed.
     * </p>
     * <p>
     * The number of sync configurations might be too large to return using a single call to
     * <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the
     * <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the
     * value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request
     * them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceDataSyncRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceDataSyncRequest#builder()}
     * </p>
     *
     * @param listResourceDataSyncRequest
     *        A {@link Consumer} that will call methods on {@link ListResourceDataSyncRequest.Builder} to create a
     *        request.
     * @return Result of the ListResourceDataSync operation returned by the service.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourceDataSyncResponse listResourceDataSync(
            Consumer<ListResourceDataSyncRequest.Builder> listResourceDataSyncRequest)
            throws ResourceDataSyncInvalidConfigurationException, InternalServerErrorException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return listResourceDataSync(ListResourceDataSyncRequest.builder().applyMutation(listResourceDataSyncRequest).build());
    }

    /**
     * <p>
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start,
     * the last sync status, and the last time a sync successfully completed.
     * </p>
     * <p>
     * The number of sync configurations might be too large to return using a single call to
     * <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the
     * <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the
     * value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request
     * them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceDataSync(software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncIterable responses = client.listResourceDataSyncPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncIterable responses = client
     *             .listResourceDataSyncPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncIterable responses = client.listResourceDataSyncPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceDataSync(software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token is not valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceDataSync
     * @see #listResourceDataSyncPaginator(ListResourceDataSyncRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResourceDataSyncIterable listResourceDataSyncPaginator() throws ResourceDataSyncInvalidConfigurationException,
            InternalServerErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return listResourceDataSyncPaginator(ListResourceDataSyncRequest.builder().build());
    }

    /**
     * <p>
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start,
     * the last sync status, and the last time a sync successfully completed.
     * </p>
     * <p>
     * The number of sync configurations might be too large to return using a single call to
     * <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the
     * <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the
     * value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request
     * them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceDataSync(software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncIterable responses = client.listResourceDataSyncPaginator(request);
