/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum PatchProperty {
    PRODUCT("PRODUCT"),
    PRODUCT_FAMILY("PRODUCT_FAMILY"),
    CLASSIFICATION("CLASSIFICATION"),
    MSRC_SEVERITY("MSRC_SEVERITY"),
    PRIORITY("PRIORITY"),
    SEVERITY("SEVERITY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private PatchProperty(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PatchProperty fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(PatchProperty.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PatchProperty> knownValues() {
        return Stream.of(PatchProperty.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

