/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.ssm.model.CancelCommandRequest;
import software.amazon.awssdk.services.ssm.model.CancelCommandResponse;
import software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionRequest;
import software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionResponse;
import software.amazon.awssdk.services.ssm.model.CreateActivationRequest;
import software.amazon.awssdk.services.ssm.model.CreateActivationResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.CreateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.CreateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.CreateOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.CreateOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.CreateOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.DeleteActivationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteActivationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DeleteInventoryRequest;
import software.amazon.awssdk.services.ssm.model.DeleteInventoryResponse;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeleteOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.DeleteOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParameterRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParameterResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParametersRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParametersResponse;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeParametersRequest;
import software.amazon.awssdk.services.ssm.model.DescribeParametersResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetCalendarStateRequest;
import software.amazon.awssdk.services.ssm.model.GetCalendarStateResponse;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetConnectionStatusRequest;
import software.amazon.awssdk.services.ssm.model.GetConnectionStatusResponse;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse;
import software.amazon.awssdk.services.ssm.model.GetDocumentRequest;
import software.amazon.awssdk.services.ssm.model.GetDocumentResponse;
import software.amazon.awssdk.services.ssm.model.GetInventoryRequest;
import software.amazon.awssdk.services.ssm.model.GetInventoryResponse;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.GetServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.GetServiceSettingResponse;
import software.amazon.awssdk.services.ssm.model.LabelParameterVersionRequest;
import software.amazon.awssdk.services.ssm.model.LabelParameterVersionResponse;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandsResponse;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentsResponse;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsResponse;
import software.amazon.awssdk.services.ssm.model.PutInventoryRequest;
import software.amazon.awssdk.services.ssm.model.PutInventoryResponse;
import software.amazon.awssdk.services.ssm.model.PutParameterRequest;
import software.amazon.awssdk.services.ssm.model.PutParameterResponse;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.ssm.model.ResetServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.ResetServiceSettingResponse;
import software.amazon.awssdk.services.ssm.model.ResumeSessionRequest;
import software.amazon.awssdk.services.ssm.model.ResumeSessionResponse;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalResponse;
import software.amazon.awssdk.services.ssm.model.SendCommandRequest;
import software.amazon.awssdk.services.ssm.model.SendCommandResponse;
import software.amazon.awssdk.services.ssm.model.StartAssociationsOnceRequest;
import software.amazon.awssdk.services.ssm.model.StartAssociationsOnceResponse;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionResponse;
import software.amazon.awssdk.services.ssm.model.StartSessionRequest;
import software.amazon.awssdk.services.ssm.model.StartSessionResponse;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.TerminateSessionRequest;
import software.amazon.awssdk.services.ssm.model.TerminateSessionResponse;
import software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionRequest;
import software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionResponse;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskResponse;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleRequest;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleResponse;
import software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.UpdateOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.UpdateServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.UpdateServiceSettingResponse;
import software.amazon.awssdk.services.ssm.paginators.DescribeActivationsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselinePublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowSchedulePublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeParametersPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesPublisher;
import software.amazon.awssdk.services.ssm.paginators.DescribeSessionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.GetInventoryPublisher;
import software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaPublisher;
import software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryPublisher;
import software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryPublisher;
import software.amazon.awssdk.services.ssm.paginators.GetParametersByPathPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListAssociationsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListCommandsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListDocumentsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesPublisher;
import software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncPublisher;
import software.amazon.awssdk.services.ssm.waiters.SsmAsyncWaiter;

/**
 * Service client for accessing Amazon SSM asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <fullname>AWS Systems Manager</fullname>
 * <p>
 * AWS Systems Manager is a collection of capabilities that helps you automate management tasks such as collecting
 * system inventory, applying operating system (OS) patches, automating the creation of Amazon Machine Images (AMIs),
 * and configuring operating systems (OSs) and applications at scale. Systems Manager lets you remotely and securely
 * manage the configuration of your managed instances. A <i>managed instance</i> is any Amazon Elastic Compute Cloud
 * instance (EC2 instance), or any on-premises server or virtual machine (VM) in your hybrid environment that has been
 * configured for Systems Manager.
 * </p>
 * <p>
 * This reference is intended to be used with the <a
 * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/">AWS Systems Manager User Guide</a>.
 * </p>
 * <p>
 * To get started, verify prerequisites and configure managed instances. For more information, see <a
 * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-setting-up.html">Setting up AWS
 * Systems Manager</a> in the <i>AWS Systems Manager User Guide</i>.
 * </p>
 * <p>
 * For information about other API actions you can perform on EC2 instances, see the <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/">Amazon EC2 API Reference</a>. For information about
 * how to use a Query API, see <a
 * href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/making-api-requests.html">Making API requests</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface SsmAsyncClient extends SdkClient {
    String SERVICE_NAME = "ssm";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "ssm";

    /**
     * Create a {@link SsmAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static SsmAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link SsmAsyncClient}.
     */
    static SsmAsyncClientBuilder builder() {
        return new DefaultSsmAsyncClientBuilder();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource. Tags are metadata that you can assign to your
     * documents, managed instances, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable
     * you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag
     * consists of a key and an optional value, both of which you define. For example, you could define a set of tags
     * for your account's managed instances that helps you track each instance's owner and stack level. For example:
     * Key=Owner and Value=DbAdmin, SysAdmin, or Dev. Or Key=Stack and Value=Production, Pre-Production, or Test.
     * </p>
     * <p>
     * Each resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent
     * set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based
     * on the tags you add. Tags don't have any semantic meaning to and are interpreted strictly as a string of
     * characters.
     * </p>
     * <p>
     * For more information about using tags with EC2 instances, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2 resources</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyTagsErrorException The <code>Targets</code> parameter includes too many tags. Remove one or
     *         more tags and try the command again.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource. Tags are metadata that you can assign to your
     * documents, managed instances, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable
     * you to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag
     * consists of a key and an optional value, both of which you define. For example, you could define a set of tags
     * for your account's managed instances that helps you track each instance's owner and stack level. For example:
     * Key=Owner and Value=DbAdmin, SysAdmin, or Dev. Or Key=Stack and Value=Production, Pre-Production, or Test.
     * </p>
     * <p>
     * Each resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent
     * set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based
     * on the tags you add. Tags don't have any semantic meaning to and are interpreted strictly as a string of
     * characters.
     * </p>
     * <p>
     * For more information about using tags with EC2 instances, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2 resources</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AddTagsToResourceRequest.Builder} avoiding the need
     * to create one manually via {@link AddTagsToResourceRequest#builder()}
     * </p>
     *
     * @param addTagsToResourceRequest
     *        A {@link Consumer} that will call methods on {@link AddTagsToResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AddTagsToResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyTagsErrorException The <code>Targets</code> parameter includes too many tags. Remove one or
     *         more tags and try the command again.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AddTagsToResourceResponse> addTagsToResource(
            Consumer<AddTagsToResourceRequest.Builder> addTagsToResourceRequest) {
        return addTagsToResource(AddTagsToResourceRequest.builder().applyMutation(addTagsToResourceRequest).build());
    }

    /**
     * <p>
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be
     * terminated and the underlying process stopped.
     * </p>
     *
     * @param cancelCommandRequest
     * @return A Java Future containing the result of the CancelCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>DuplicateInstanceIdException You cannot specify an instance ID in more than one association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CancelCommand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelCommandResponse> cancelCommand(CancelCommandRequest cancelCommandRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be
     * terminated and the underlying process stopped.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelCommandRequest.Builder} avoiding the need to
     * create one manually via {@link CancelCommandRequest#builder()}
     * </p>
     *
     * @param cancelCommandRequest
     *        A {@link Consumer} that will call methods on {@link CancelCommandRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelCommand operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>DuplicateInstanceIdException You cannot specify an instance ID in more than one association.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CancelCommand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelCommandResponse> cancelCommand(Consumer<CancelCommandRequest.Builder> cancelCommandRequest) {
        return cancelCommand(CancelCommandRequest.builder().applyMutation(cancelCommandRequest).build());
    }

    /**
     * <p>
     * Stops a maintenance window execution that is already in progress and cancels any tasks in the window that have
     * not already starting running. (Tasks already in progress will continue to completion.)
     * </p>
     *
     * @param cancelMaintenanceWindowExecutionRequest
     * @return A Java Future containing the result of the CancelMaintenanceWindowExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CancelMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMaintenanceWindowExecutionResponse> cancelMaintenanceWindowExecution(
            CancelMaintenanceWindowExecutionRequest cancelMaintenanceWindowExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a maintenance window execution that is already in progress and cancels any tasks in the window that have
     * not already starting running. (Tasks already in progress will continue to completion.)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelMaintenanceWindowExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link CancelMaintenanceWindowExecutionRequest#builder()}
     * </p>
     *
     * @param cancelMaintenanceWindowExecutionRequest
     *        A {@link Consumer} that will call methods on {@link CancelMaintenanceWindowExecutionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CancelMaintenanceWindowExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CancelMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelMaintenanceWindowExecutionResponse> cancelMaintenanceWindowExecution(
            Consumer<CancelMaintenanceWindowExecutionRequest.Builder> cancelMaintenanceWindowExecutionRequest) {
        return cancelMaintenanceWindowExecution(CancelMaintenanceWindowExecutionRequest.builder()
                .applyMutation(cancelMaintenanceWindowExecutionRequest).build());
    }

    /**
     * <p>
     * Generates an activation code and activation ID you can use to register your on-premises server or virtual machine
     * (VM) with Systems Manager. Registering these machines with Systems Manager makes it possible to manage them using
     * Systems Manager capabilities. You use the activation code and ID when installing SSM Agent on machines in your
     * hybrid environment. For more information about requirements for managing on-premises instances and VMs using
     * Systems Manager, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting
     * up AWS Systems Manager for hybrid environments</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <note>
     * <p>
     * On-premises servers or VMs that are registered with Systems Manager and EC2 instances that you manage with
     * Systems Manager are all called <i>managed instances</i>.
     * </p>
     * </note>
     *
     * @param createActivationRequest
     * @return A Java Future containing the result of the CreateActivation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateActivationResponse> createActivation(CreateActivationRequest createActivationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Generates an activation code and activation ID you can use to register your on-premises server or virtual machine
     * (VM) with Systems Manager. Registering these machines with Systems Manager makes it possible to manage them using
     * Systems Manager capabilities. You use the activation code and ID when installing SSM Agent on machines in your
     * hybrid environment. For more information about requirements for managing on-premises instances and VMs using
     * Systems Manager, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting
     * up AWS Systems Manager for hybrid environments</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <note>
     * <p>
     * On-premises servers or VMs that are registered with Systems Manager and EC2 instances that you manage with
     * Systems Manager are all called <i>managed instances</i>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateActivationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateActivationRequest#builder()}
     * </p>
     *
     * @param createActivationRequest
     *        A {@link Consumer} that will call methods on {@link CreateActivationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateActivation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateActivationResponse> createActivation(
            Consumer<CreateActivationRequest.Builder> createActivationRequest) {
        return createActivation(CreateActivationRequest.builder().applyMutation(createActivationRequest).build());
    }

    /**
     * <p>
     * A State Manager association defines the state that you want to maintain on your instances. For example, an
     * association can specify that anti-virus software must be installed and running on your instances, or that certain
     * ports must be closed. For static targets, the association specifies a schedule for when the configuration is
     * reapplied. For dynamic targets, such as an AWS Resource Group or an AWS Autoscaling Group, State Manager applies
     * the configuration when new instances are added to the group. The association also specifies actions to take when
     * applying the configuration. For example, an association for anti-virus software might run once a day. If the
     * software is not installed, then State Manager installs it. If the software is installed, but the service is not
     * running, then the association might instruct State Manager to start the service.
     * </p>
     *
     * @param createAssociationRequest
     * @return A Java Future containing the result of the CreateAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationAlreadyExistsException The specified association already exists.</li>
     *         <li>AssociationLimitExceededException You can have at most 2,000 active associations.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>UnsupportedPlatformTypeException The document does not support the platform type of the given
     *         instance ID(s). For example, you sent an document for a Windows instance to a Linux instance.</li>
     *         <li>InvalidOutputLocationException The output location is not valid or does not exist.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Systems Manager
     *         document. You can only supply values to parameters defined in the Systems Manager document.</li>
     *         <li>InvalidTargetException The target is not valid or does not exist. It might not be configured for
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssociationResponse> createAssociation(CreateAssociationRequest createAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A State Manager association defines the state that you want to maintain on your instances. For example, an
     * association can specify that anti-virus software must be installed and running on your instances, or that certain
     * ports must be closed. For static targets, the association specifies a schedule for when the configuration is
     * reapplied. For dynamic targets, such as an AWS Resource Group or an AWS Autoscaling Group, State Manager applies
     * the configuration when new instances are added to the group. The association also specifies actions to take when
     * applying the configuration. For example, an association for anti-virus software might run once a day. If the
     * software is not installed, then State Manager installs it. If the software is installed, but the service is not
     * running, then the association might instruct State Manager to start the service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssociationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateAssociationRequest#builder()}
     * </p>
     *
     * @param createAssociationRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssociationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationAlreadyExistsException The specified association already exists.</li>
     *         <li>AssociationLimitExceededException You can have at most 2,000 active associations.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>UnsupportedPlatformTypeException The document does not support the platform type of the given
     *         instance ID(s). For example, you sent an document for a Windows instance to a Linux instance.</li>
     *         <li>InvalidOutputLocationException The output location is not valid or does not exist.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Systems Manager
     *         document. You can only supply values to parameters defined in the Systems Manager document.</li>
     *         <li>InvalidTargetException The target is not valid or does not exist. It might not be configured for
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateAssociationResponse> createAssociation(
            Consumer<CreateAssociationRequest.Builder> createAssociationRequest) {
        return createAssociation(CreateAssociationRequest.builder().applyMutation(createAssociationRequest).build());
    }

    /**
     * <p>
     * Associates the specified Systems Manager document with the specified instances or targets.
     * </p>
     * <p>
     * When you associate a document with one or more instances using instance IDs or tags, SSM Agent running on the
     * instance processes the document and configures the instance as specified.
     * </p>
     * <p>
     * If you associate a document with an instance that already has an associated document, the system returns the
     * AssociationAlreadyExists exception.
     * </p>
     *
     * @param createAssociationBatchRequest
     * @return A Java Future containing the result of the CreateAssociationBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Systems Manager
     *         document. You can only supply values to parameters defined in the Systems Manager document.</li>
     *         <li>DuplicateInstanceIdException You cannot specify an instance ID in more than one association.</li>
     *         <li>AssociationLimitExceededException You can have at most 2,000 active associations.</li>
     *         <li>UnsupportedPlatformTypeException The document does not support the platform type of the given
     *         instance ID(s). For example, you sent an document for a Windows instance to a Linux instance.</li>
     *         <li>InvalidOutputLocationException The output location is not valid or does not exist.</li>
     *         <li>InvalidTargetException The target is not valid or does not exist. It might not be configured for
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateAssociationBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssociationBatchResponse> createAssociationBatch(
            CreateAssociationBatchRequest createAssociationBatchRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified Systems Manager document with the specified instances or targets.
     * </p>
     * <p>
     * When you associate a document with one or more instances using instance IDs or tags, SSM Agent running on the
     * instance processes the document and configures the instance as specified.
     * </p>
     * <p>
     * If you associate a document with an instance that already has an associated document, the system returns the
     * AssociationAlreadyExists exception.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAssociationBatchRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAssociationBatchRequest#builder()}
     * </p>
     *
     * @param createAssociationBatchRequest
     *        A {@link Consumer} that will call methods on {@link CreateAssociationBatchRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAssociationBatch operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidParametersException You must specify values for all required parameters in the Systems Manager
     *         document. You can only supply values to parameters defined in the Systems Manager document.</li>
     *         <li>DuplicateInstanceIdException You cannot specify an instance ID in more than one association.</li>
     *         <li>AssociationLimitExceededException You can have at most 2,000 active associations.</li>
     *         <li>UnsupportedPlatformTypeException The document does not support the platform type of the given
     *         instance ID(s). For example, you sent an document for a Windows instance to a Linux instance.</li>
     *         <li>InvalidOutputLocationException The output location is not valid or does not exist.</li>
     *         <li>InvalidTargetException The target is not valid or does not exist. It might not be configured for
     *         Systems Manager or you might not have permission to perform the operation.</li>
     *         <li>InvalidScheduleException The schedule is invalid. Verify your cron or rate expression and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateAssociationBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAssociationBatchResponse> createAssociationBatch(
            Consumer<CreateAssociationBatchRequest.Builder> createAssociationBatchRequest) {
        return createAssociationBatch(CreateAssociationBatchRequest.builder().applyMutation(createAssociationBatchRequest)
                .build());
    }

    /**
     * <p>
     * Creates a Systems Manager (SSM) document. An SSM document defines the actions that Systems Manager performs on
     * your managed instances. For more information about SSM documents, including information about supported schemas,
     * features, and syntax, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html">AWS Systems Manager
     * Documents</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     *
     * @param createDocumentRequest
     * @return A Java Future containing the result of the CreateDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DocumentAlreadyExistsException The specified document already exists.</li>
     *         <li>MaxDocumentSizeExceededException The size limit of a document is 64 KB.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentContentException The content for the document is not valid.</li>
     *         <li>DocumentLimitExceededException You can have at most 500 active Systems Manager documents.</li>
     *         <li>InvalidDocumentSchemaVersionException The version of the document schema is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDocumentResponse> createDocument(CreateDocumentRequest createDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Systems Manager (SSM) document. An SSM document defines the actions that Systems Manager performs on
     * your managed instances. For more information about SSM documents, including information about supported schemas,
     * features, and syntax, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html">AWS Systems Manager
     * Documents</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link CreateDocumentRequest#builder()}
     * </p>
     *
     * @param createDocumentRequest
     *        A {@link Consumer} that will call methods on {@link CreateDocumentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DocumentAlreadyExistsException The specified document already exists.</li>
     *         <li>MaxDocumentSizeExceededException The size limit of a document is 64 KB.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentContentException The content for the document is not valid.</li>
     *         <li>DocumentLimitExceededException You can have at most 500 active Systems Manager documents.</li>
     *         <li>InvalidDocumentSchemaVersionException The version of the document schema is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateDocumentResponse> createDocument(Consumer<CreateDocumentRequest.Builder> createDocumentRequest) {
        return createDocument(CreateDocumentRequest.builder().applyMutation(createDocumentRequest).build());
    }

    /**
     * <p>
     * Creates a new maintenance window.
     * </p>
     * <note>
     * <p>
     * The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based
     * on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the
     * number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the
     * duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window
     * tasks can start after 5 PM.
     * </p>
     * </note>
     *
     * @param createMaintenanceWindowRequest
     * @return A Java Future containing the result of the CreateMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         quotas. For example, too many maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateMaintenanceWindowResponse> createMaintenanceWindow(
            CreateMaintenanceWindowRequest createMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new maintenance window.
     * </p>
     * <note>
     * <p>
     * The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based
     * on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the
     * number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the
     * duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window
     * tasks can start after 5 PM.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMaintenanceWindowRequest.Builder} avoiding
     * the need to create one manually via {@link CreateMaintenanceWindowRequest#builder()}
     * </p>
     *
     * @param createMaintenanceWindowRequest
     *        A {@link Consumer} that will call methods on {@link CreateMaintenanceWindowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         quotas. For example, too many maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateMaintenanceWindowResponse> createMaintenanceWindow(
            Consumer<CreateMaintenanceWindowRequest.Builder> createMaintenanceWindowRequest) {
        return createMaintenanceWindow(CreateMaintenanceWindowRequest.builder().applyMutation(createMaintenanceWindowRequest)
                .build());
    }

    /**
     * <p>
     * Creates a new OpsItem. You must have permission in AWS Identity and Access Management (IAM) to create a new
     * OpsItem. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     *
     * @param createOpsItemRequest
     * @return A Java Future containing the result of the CreateOpsItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemAlreadyExistsException The OpsItem already exists.</li>
     *         <li>OpsItemLimitExceededException The request caused OpsItems to exceed one or more quotas. For
     *         information about OpsItem quotas, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateOpsItemResponse> createOpsItem(CreateOpsItemRequest createOpsItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new OpsItem. You must have permission in AWS Identity and Access Management (IAM) to create a new
     * OpsItem. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOpsItemRequest.Builder} avoiding the need to
     * create one manually via {@link CreateOpsItemRequest#builder()}
     * </p>
     *
     * @param createOpsItemRequest
     *        A {@link Consumer} that will call methods on {@link CreateOpsItemRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateOpsItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemAlreadyExistsException The OpsItem already exists.</li>
     *         <li>OpsItemLimitExceededException The request caused OpsItems to exceed one or more quotas. For
     *         information about OpsItem quotas, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateOpsItemResponse> createOpsItem(Consumer<CreateOpsItemRequest.Builder> createOpsItemRequest) {
        return createOpsItem(CreateOpsItemRequest.builder().applyMutation(createOpsItemRequest).build());
    }

    /**
     * <p>
     * If you create a new application in Application Manager, Systems Manager calls this API action to specify
     * information about the new application, including the application type.
     * </p>
     *
     * @param createOpsMetadataRequest
     * @return A Java Future containing the result of the CreateOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataAlreadyExistsException An OpsMetadata object already exists for the selected resource.</li>
     *         <li>OpsMetadataTooManyUpdatesException The system is processing too many concurrent updates. Wait a few
     *         moments and try again.</li>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>OpsMetadataLimitExceededException Your account reached the maximum number of OpsMetadata objects
     *         allowed by Application Manager. The maximum is 200 OpsMetadata objects. Delete one or more OpsMetadata
     *         object and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateOpsMetadataResponse> createOpsMetadata(CreateOpsMetadataRequest createOpsMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * If you create a new application in Application Manager, Systems Manager calls this API action to specify
     * information about the new application, including the application type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOpsMetadataRequest.Builder} avoiding the need
     * to create one manually via {@link CreateOpsMetadataRequest#builder()}
     * </p>
     *
     * @param createOpsMetadataRequest
     *        A {@link Consumer} that will call methods on {@link CreateOpsMetadataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataAlreadyExistsException An OpsMetadata object already exists for the selected resource.</li>
     *         <li>OpsMetadataTooManyUpdatesException The system is processing too many concurrent updates. Wait a few
     *         moments and try again.</li>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>OpsMetadataLimitExceededException Your account reached the maximum number of OpsMetadata objects
     *         allowed by Application Manager. The maximum is 200 OpsMetadata objects. Delete one or more OpsMetadata
     *         object and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateOpsMetadataResponse> createOpsMetadata(
            Consumer<CreateOpsMetadataRequest.Builder> createOpsMetadataRequest) {
        return createOpsMetadata(CreateOpsMetadataRequest.builder().applyMutation(createOpsMetadataRequest).build());
    }

    /**
     * <p>
     * Creates a patch baseline.
     * </p>
     * <note>
     * <p>
     * For information about valid key and value pairs in <code>PatchFilters</code> for each supported operating system
     * type, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html">PatchFilter</a>.
     * </p>
     * </note>
     *
     * @param createPatchBaselineRequest
     * @return A Java Future containing the result of the CreatePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         quotas. For example, too many maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreatePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePatchBaselineResponse> createPatchBaseline(
            CreatePatchBaselineRequest createPatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a patch baseline.
     * </p>
     * <note>
     * <p>
     * For information about valid key and value pairs in <code>PatchFilters</code> for each supported operating system
     * type, see <a
     * href="http://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html">PatchFilter</a>.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreatePatchBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link CreatePatchBaselineRequest#builder()}
     * </p>
     *
     * @param createPatchBaselineRequest
     *        A {@link Consumer} that will call methods on {@link CreatePatchBaselineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreatePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>IdempotentParameterMismatchException Error returned when an idempotent operation is retried and the
     *         parameters don't match the original call to the API with the same idempotency token.</li>
     *         <li>ResourceLimitExceededException Error returned when the caller has exceeded the default resource
     *         quotas. For example, too many maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreatePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreatePatchBaselineResponse> createPatchBaseline(
            Consumer<CreatePatchBaselineRequest.Builder> createPatchBaselineRequest) {
        return createPatchBaseline(CreatePatchBaselineRequest.builder().applyMutation(createPatchBaselineRequest).build());
    }

    /**
     * <p>
     * A resource data sync helps you view data from multiple sources in a single location. Systems Manager offers two
     * types of resource data sync: <code>SyncToDestination</code> and <code>SyncFromSource</code>.
     * </p>
     * <p>
     * You can configure Systems Manager Inventory to use the <code>SyncToDestination</code> type to synchronize
     * Inventory data from multiple AWS Regions to a single S3 bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html">Configuring
     * Resource Data Sync for Inventory</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * You can configure Systems Manager Explorer to use the <code>SyncFromSource</code> type to synchronize operational
     * work items (OpsItems) and operational data (OpsData) from multiple AWS Regions to a single S3 bucket. This type
     * can synchronize OpsItems and OpsData from multiple AWS accounts and Regions or <code>EntireOrganization</code> by
     * using AWS Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up
     * Systems Manager Explorer to display data from multiple accounts and Regions</a> in the <i>AWS Systems Manager
     * User Guide</i>.
     * </p>
     * <p>
     * A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is
     * completed, the system continuously syncs data. To check the status of a sync, use the
     * <a>ListResourceDataSync</a>.
     * </p>
     * <note>
     * <p>
     * By default, data is not encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to
     * ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a
     * restrictive bucket policy.
     * </p>
     * </note>
     *
     * @param createResourceDataSyncRequest
     * @return A Java Future containing the result of the CreateResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncCountExceededException You have exceeded the allowed maximum sync configurations.</li>
     *         <li>ResourceDataSyncAlreadyExistsException A sync configuration with the same name already exists.</li>
     *         <li>ResourceDataSyncInvalidConfigurationException The specified sync configuration is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateResourceDataSyncResponse> createResourceDataSync(
            CreateResourceDataSyncRequest createResourceDataSyncRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A resource data sync helps you view data from multiple sources in a single location. Systems Manager offers two
     * types of resource data sync: <code>SyncToDestination</code> and <code>SyncFromSource</code>.
     * </p>
     * <p>
     * You can configure Systems Manager Inventory to use the <code>SyncToDestination</code> type to synchronize
     * Inventory data from multiple AWS Regions to a single S3 bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html">Configuring
     * Resource Data Sync for Inventory</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * You can configure Systems Manager Explorer to use the <code>SyncFromSource</code> type to synchronize operational
     * work items (OpsItems) and operational data (OpsData) from multiple AWS Regions to a single S3 bucket. This type
     * can synchronize OpsItems and OpsData from multiple AWS accounts and Regions or <code>EntireOrganization</code> by
     * using AWS Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up
     * Systems Manager Explorer to display data from multiple accounts and Regions</a> in the <i>AWS Systems Manager
     * User Guide</i>.
     * </p>
     * <p>
     * A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is
     * completed, the system continuously syncs data. To check the status of a sync, use the
     * <a>ListResourceDataSync</a>.
     * </p>
     * <note>
     * <p>
     * By default, data is not encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to
     * ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a
     * restrictive bucket policy.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceDataSyncRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceDataSyncRequest#builder()}
     * </p>
     *
     * @param createResourceDataSyncRequest
     *        A {@link Consumer} that will call methods on {@link CreateResourceDataSyncRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncCountExceededException You have exceeded the allowed maximum sync configurations.</li>
     *         <li>ResourceDataSyncAlreadyExistsException A sync configuration with the same name already exists.</li>
     *         <li>ResourceDataSyncInvalidConfigurationException The specified sync configuration is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.CreateResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateResourceDataSyncResponse> createResourceDataSync(
            Consumer<CreateResourceDataSyncRequest.Builder> createResourceDataSyncRequest) {
        return createResourceDataSync(CreateResourceDataSyncRequest.builder().applyMutation(createResourceDataSyncRequest)
                .build());
    }

    /**
     * <p>
     * Deletes an activation. You are not required to delete an activation. If you delete an activation, you can no
     * longer use it to register additional managed instances. Deleting an activation does not de-register managed
     * instances. You must manually de-register managed instances.
     * </p>
     *
     * @param deleteActivationRequest
     * @return A Java Future containing the result of the DeleteActivation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidActivationIdException The activation ID is not valid. Verify the you entered the correct
     *         ActivationId or ActivationCode and try again.</li>
     *         <li>InvalidActivationException The activation is not valid. The activation might have been deleted, or
     *         the ActivationId and the ActivationCode do not match.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteActivationResponse> deleteActivation(DeleteActivationRequest deleteActivationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an activation. You are not required to delete an activation. If you delete an activation, you can no
     * longer use it to register additional managed instances. Deleting an activation does not de-register managed
     * instances. You must manually de-register managed instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteActivationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteActivationRequest#builder()}
     * </p>
     *
     * @param deleteActivationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteActivationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteActivation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidActivationIdException The activation ID is not valid. Verify the you entered the correct
     *         ActivationId or ActivationCode and try again.</li>
     *         <li>InvalidActivationException The activation is not valid. The activation might have been deleted, or
     *         the ActivationId and the ActivationCode do not match.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteActivationResponse> deleteActivation(
            Consumer<DeleteActivationRequest.Builder> deleteActivationRequest) {
        return deleteActivation(DeleteActivationRequest.builder().applyMutation(deleteActivationRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified Systems Manager document from the specified instance.
     * </p>
     * <p>
     * When you disassociate a document from an instance, it does not change the configuration of the instance. To
     * change the configuration state of an instance after you disassociate a document, you must create a new document
     * with the desired configuration and associate it with the instance.
     * </p>
     *
     * @param deleteAssociationRequest
     * @return A Java Future containing the result of the DeleteAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssociationResponse> deleteAssociation(DeleteAssociationRequest deleteAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified Systems Manager document from the specified instance.
     * </p>
     * <p>
     * When you disassociate a document from an instance, it does not change the configuration of the instance. To
     * change the configuration state of an instance after you disassociate a document, you must create a new document
     * with the desired configuration and associate it with the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAssociationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteAssociationRequest#builder()}
     * </p>
     *
     * @param deleteAssociationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAssociationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteAssociationResponse> deleteAssociation(
            Consumer<DeleteAssociationRequest.Builder> deleteAssociationRequest) {
        return deleteAssociation(DeleteAssociationRequest.builder().applyMutation(deleteAssociationRequest).build());
    }

    /**
     * <p>
     * Deletes the Systems Manager document and all instance associations to the document.
     * </p>
     * <p>
     * Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all instances
     * that are associated with the document.
     * </p>
     *
     * @param deleteDocumentRequest
     * @return A Java Future containing the result of the DeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentOperationException You attempted to delete a document while it is still shared. You
     *         must stop sharing the document before you can delete it.</li>
     *         <li>AssociatedInstancesException You must disassociate a document from all instances before you can
     *         delete it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDocumentResponse> deleteDocument(DeleteDocumentRequest deleteDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the Systems Manager document and all instance associations to the document.
     * </p>
     * <p>
     * Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all instances
     * that are associated with the document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteDocumentRequest#builder()}
     * </p>
     *
     * @param deleteDocumentRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDocumentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentOperationException You attempted to delete a document while it is still shared. You
     *         must stop sharing the document before you can delete it.</li>
     *         <li>AssociatedInstancesException You must disassociate a document from all instances before you can
     *         delete it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteDocumentResponse> deleteDocument(Consumer<DeleteDocumentRequest.Builder> deleteDocumentRequest) {
        return deleteDocument(DeleteDocumentRequest.builder().applyMutation(deleteDocumentRequest).build());
    }

    /**
     * <p>
     * Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory
     * type is also referred to as deleting a custom inventory schema.
     * </p>
     *
     * @param deleteInventoryRequest
     * @return A Java Future containing the result of the DeleteInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidOptionException The delete inventory option specified is not valid. Verify the option and try
     *         again.</li>
     *         <li>InvalidDeleteInventoryParametersException One or more of the parameters specified for the delete
     *         operation is not valid. Verify all parameters and try again.</li>
     *         <li>InvalidInventoryRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInventoryResponse> deleteInventory(DeleteInventoryRequest deleteInventoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory
     * type is also referred to as deleting a custom inventory schema.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteInventoryRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteInventoryRequest#builder()}
     * </p>
     *
     * @param deleteInventoryRequest
     *        A {@link Consumer} that will call methods on {@link DeleteInventoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidOptionException The delete inventory option specified is not valid. Verify the option and try
     *         again.</li>
     *         <li>InvalidDeleteInventoryParametersException One or more of the parameters specified for the delete
     *         operation is not valid. Verify all parameters and try again.</li>
     *         <li>InvalidInventoryRequestException The request is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteInventoryResponse> deleteInventory(
            Consumer<DeleteInventoryRequest.Builder> deleteInventoryRequest) {
        return deleteInventory(DeleteInventoryRequest.builder().applyMutation(deleteInventoryRequest).build());
    }

    /**
     * <p>
     * Deletes a maintenance window.
     * </p>
     *
     * @param deleteMaintenanceWindowRequest
     * @return A Java Future containing the result of the DeleteMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteMaintenanceWindowResponse> deleteMaintenanceWindow(
            DeleteMaintenanceWindowRequest deleteMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteMaintenanceWindowRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteMaintenanceWindowRequest#builder()}
     * </p>
     *
     * @param deleteMaintenanceWindowRequest
     *        A {@link Consumer} that will call methods on {@link DeleteMaintenanceWindowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteMaintenanceWindowResponse> deleteMaintenanceWindow(
            Consumer<DeleteMaintenanceWindowRequest.Builder> deleteMaintenanceWindowRequest) {
        return deleteMaintenanceWindow(DeleteMaintenanceWindowRequest.builder().applyMutation(deleteMaintenanceWindowRequest)
                .build());
    }

    /**
     * <p>
     * Delete OpsMetadata related to an application.
     * </p>
     *
     * @param deleteOpsMetadataRequest
     * @return A Java Future containing the result of the DeleteOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataNotFoundException The OpsMetadata object does not exist.</li>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOpsMetadataResponse> deleteOpsMetadata(DeleteOpsMetadataRequest deleteOpsMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete OpsMetadata related to an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteOpsMetadataRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteOpsMetadataRequest#builder()}
     * </p>
     *
     * @param deleteOpsMetadataRequest
     *        A {@link Consumer} that will call methods on {@link DeleteOpsMetadataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataNotFoundException The OpsMetadata object does not exist.</li>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteOpsMetadataResponse> deleteOpsMetadata(
            Consumer<DeleteOpsMetadataRequest.Builder> deleteOpsMetadataRequest) {
        return deleteOpsMetadata(DeleteOpsMetadataRequest.builder().applyMutation(deleteOpsMetadataRequest).build());
    }

    /**
     * <p>
     * Delete a parameter from the system.
     * </p>
     *
     * @param deleteParameterRequest
     * @return A Java Future containing the result of the DeleteParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteParameterResponse> deleteParameter(DeleteParameterRequest deleteParameterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a parameter from the system.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteParameterRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteParameterRequest#builder()}
     * </p>
     *
     * @param deleteParameterRequest
     *        A {@link Consumer} that will call methods on {@link DeleteParameterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteParameterResponse> deleteParameter(
            Consumer<DeleteParameterRequest.Builder> deleteParameterRequest) {
        return deleteParameter(DeleteParameterRequest.builder().applyMutation(deleteParameterRequest).build());
    }

    /**
     * <p>
     * Delete a list of parameters.
     * </p>
     *
     * @param deleteParametersRequest
     * @return A Java Future containing the result of the DeleteParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteParametersResponse> deleteParameters(DeleteParametersRequest deleteParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete a list of parameters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteParametersRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteParametersRequest#builder()}
     * </p>
     *
     * @param deleteParametersRequest
     *        A {@link Consumer} that will call methods on {@link DeleteParametersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteParametersResponse> deleteParameters(
            Consumer<DeleteParametersRequest.Builder> deleteParametersRequest) {
        return deleteParameters(DeleteParametersRequest.builder().applyMutation(deleteParametersRequest).build());
    }

    /**
     * <p>
     * Deletes a patch baseline.
     * </p>
     *
     * @param deletePatchBaselineRequest
     * @return A Java Future containing the result of the DeletePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Error returned if an attempt is made to delete a patch baseline that is
     *         registered for a patch group.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeletePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePatchBaselineResponse> deletePatchBaseline(
            DeletePatchBaselineRequest deletePatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeletePatchBaselineRequest.Builder} avoiding the
     * need to create one manually via {@link DeletePatchBaselineRequest#builder()}
     * </p>
     *
     * @param deletePatchBaselineRequest
     *        A {@link Consumer} that will call methods on {@link DeletePatchBaselineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeletePatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceInUseException Error returned if an attempt is made to delete a patch baseline that is
     *         registered for a patch group.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeletePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeletePatchBaselineResponse> deletePatchBaseline(
            Consumer<DeletePatchBaselineRequest.Builder> deletePatchBaselineRequest) {
        return deletePatchBaseline(DeletePatchBaselineRequest.builder().applyMutation(deletePatchBaselineRequest).build());
    }

    /**
     * <p>
     * Deletes a Resource Data Sync configuration. After the configuration is deleted, changes to data on managed
     * instances are no longer synced to or from the target. Deleting a sync configuration does not delete data.
     * </p>
     *
     * @param deleteResourceDataSyncRequest
     * @return A Java Future containing the result of the DeleteResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncNotFoundException The specified sync name was not found.</li>
     *         <li>ResourceDataSyncInvalidConfigurationException The specified sync configuration is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteResourceDataSyncResponse> deleteResourceDataSync(
            DeleteResourceDataSyncRequest deleteResourceDataSyncRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a Resource Data Sync configuration. After the configuration is deleted, changes to data on managed
     * instances are no longer synced to or from the target. Deleting a sync configuration does not delete data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceDataSyncRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteResourceDataSyncRequest#builder()}
     * </p>
     *
     * @param deleteResourceDataSyncRequest
     *        A {@link Consumer} that will call methods on {@link DeleteResourceDataSyncRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteResourceDataSync operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncNotFoundException The specified sync name was not found.</li>
     *         <li>ResourceDataSyncInvalidConfigurationException The specified sync configuration is invalid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeleteResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteResourceDataSyncResponse> deleteResourceDataSync(
            Consumer<DeleteResourceDataSyncRequest.Builder> deleteResourceDataSyncRequest) {
        return deleteResourceDataSync(DeleteResourceDataSyncRequest.builder().applyMutation(deleteResourceDataSyncRequest)
                .build());
    }

    /**
     * <p>
     * Removes the server or virtual machine from the list of registered servers. You can reregister the instance again
     * at any time. If you don't plan to use Run Command on the server, we suggest uninstalling SSM Agent first.
     * </p>
     *
     * @param deregisterManagedInstanceRequest
     * @return A Java Future containing the result of the DeregisterManagedInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeregisterManagedInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterManagedInstanceResponse> deregisterManagedInstance(
            DeregisterManagedInstanceRequest deregisterManagedInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes the server or virtual machine from the list of registered servers. You can reregister the instance again
     * at any time. If you don't plan to use Run Command on the server, we suggest uninstalling SSM Agent first.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterManagedInstanceRequest.Builder} avoiding
     * the need to create one manually via {@link DeregisterManagedInstanceRequest#builder()}
     * </p>
     *
     * @param deregisterManagedInstanceRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterManagedInstanceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeregisterManagedInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeregisterManagedInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeregisterManagedInstanceResponse> deregisterManagedInstance(
            Consumer<DeregisterManagedInstanceRequest.Builder> deregisterManagedInstanceRequest) {
        return deregisterManagedInstance(DeregisterManagedInstanceRequest.builder()
                .applyMutation(deregisterManagedInstanceRequest).build());
    }

    /**
     * <p>
     * Removes a patch group from a patch baseline.
     * </p>
     *
     * @param deregisterPatchBaselineForPatchGroupRequest
     * @return A Java Future containing the result of the DeregisterPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeregisterPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterPatchBaselineForPatchGroupResponse> deregisterPatchBaselineForPatchGroup(
            DeregisterPatchBaselineForPatchGroupRequest deregisterPatchBaselineForPatchGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a patch group from a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeregisterPatchBaselineForPatchGroupRequest.Builder} avoiding the need to create one manually via
     * {@link DeregisterPatchBaselineForPatchGroupRequest#builder()}
     * </p>
     *
     * @param deregisterPatchBaselineForPatchGroupRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterPatchBaselineForPatchGroupRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeregisterPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeregisterPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterPatchBaselineForPatchGroupResponse> deregisterPatchBaselineForPatchGroup(
            Consumer<DeregisterPatchBaselineForPatchGroupRequest.Builder> deregisterPatchBaselineForPatchGroupRequest) {
        return deregisterPatchBaselineForPatchGroup(DeregisterPatchBaselineForPatchGroupRequest.builder()
                .applyMutation(deregisterPatchBaselineForPatchGroupRequest).build());
    }

    /**
     * <p>
     * Removes a target from a maintenance window.
     * </p>
     *
     * @param deregisterTargetFromMaintenanceWindowRequest
     * @return A Java Future containing the result of the DeregisterTargetFromMaintenanceWindow operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TargetInUseException You specified the <code>Safe</code> option for the
     *         DeregisterTargetFromMaintenanceWindow operation, but the target is still referenced in a task.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeregisterTargetFromMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTargetFromMaintenanceWindowResponse> deregisterTargetFromMaintenanceWindow(
            DeregisterTargetFromMaintenanceWindowRequest deregisterTargetFromMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a target from a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeregisterTargetFromMaintenanceWindowRequest.Builder} avoiding the need to create one manually via
     * {@link DeregisterTargetFromMaintenanceWindowRequest#builder()}
     * </p>
     *
     * @param deregisterTargetFromMaintenanceWindowRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterTargetFromMaintenanceWindowRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeregisterTargetFromMaintenanceWindow operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TargetInUseException You specified the <code>Safe</code> option for the
     *         DeregisterTargetFromMaintenanceWindow operation, but the target is still referenced in a task.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeregisterTargetFromMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTargetFromMaintenanceWindowResponse> deregisterTargetFromMaintenanceWindow(
            Consumer<DeregisterTargetFromMaintenanceWindowRequest.Builder> deregisterTargetFromMaintenanceWindowRequest) {
        return deregisterTargetFromMaintenanceWindow(DeregisterTargetFromMaintenanceWindowRequest.builder()
                .applyMutation(deregisterTargetFromMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Removes a task from a maintenance window.
     * </p>
     *
     * @param deregisterTaskFromMaintenanceWindowRequest
     * @return A Java Future containing the result of the DeregisterTaskFromMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeregisterTaskFromMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTaskFromMaintenanceWindowResponse> deregisterTaskFromMaintenanceWindow(
            DeregisterTaskFromMaintenanceWindowRequest deregisterTaskFromMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a task from a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeregisterTaskFromMaintenanceWindowRequest.Builder}
     * avoiding the need to create one manually via {@link DeregisterTaskFromMaintenanceWindowRequest#builder()}
     * </p>
     *
     * @param deregisterTaskFromMaintenanceWindowRequest
     *        A {@link Consumer} that will call methods on {@link DeregisterTaskFromMaintenanceWindowRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeregisterTaskFromMaintenanceWindow operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DeregisterTaskFromMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterTaskFromMaintenanceWindowResponse> deregisterTaskFromMaintenanceWindow(
            Consumer<DeregisterTaskFromMaintenanceWindowRequest.Builder> deregisterTaskFromMaintenanceWindowRequest) {
        return deregisterTaskFromMaintenanceWindow(DeregisterTaskFromMaintenanceWindowRequest.builder()
                .applyMutation(deregisterTaskFromMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the IAM role assigned to the instances in the activation, and the number of instances registered by using
     * this activation.
     * </p>
     *
     * @param describeActivationsRequest
     * @return A Java Future containing the result of the DescribeActivations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeActivationsResponse> describeActivations(
            DescribeActivationsRequest describeActivationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the IAM role assigned to the instances in the activation, and the number of instances registered by using
     * this activation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActivationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActivationsRequest#builder()}
     * </p>
     *
     * @param describeActivationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActivationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeActivations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeActivationsResponse> describeActivations(
            Consumer<DescribeActivationsRequest.Builder> describeActivationsRequest) {
        return describeActivations(DescribeActivationsRequest.builder().applyMutation(describeActivationsRequest).build());
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the IAM role assigned to the instances in the activation, and the number of instances registered by using
     * this activation.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeActivations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeActivationsResponse> describeActivations() {
        return describeActivations(DescribeActivationsRequest.builder().build());
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the IAM role assigned to the instances in the activation, and the number of instances registered by using
     * this activation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsPublisher publisher = client.describeActivationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsPublisher publisher = client.describeActivationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActivationsPublisher describeActivationsPaginator() {
        return describeActivationsPaginator(DescribeActivationsRequest.builder().build());
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the IAM role assigned to the instances in the activation, and the number of instances registered by using
     * this activation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsPublisher publisher = client.describeActivationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsPublisher publisher = client.describeActivationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation.</b>
     * </p>
     *
     * @param describeActivationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActivationsPublisher describeActivationsPaginator(DescribeActivationsRequest describeActivationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the IAM role assigned to the instances in the activation, and the number of instances registered by using
     * this activation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsPublisher publisher = client.describeActivationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsPublisher publisher = client.describeActivationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeActivationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeActivationsRequest#builder()}
     * </p>
     *
     * @param describeActivationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeActivationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeActivationsPublisher describeActivationsPaginator(
            Consumer<DescribeActivationsRequest.Builder> describeActivationsRequest) {
        return describeActivationsPaginator(DescribeActivationsRequest.builder().applyMutation(describeActivationsRequest)
                .build());
    }

    /**
     * <p>
     * Describes the association for the specified target or instance. If you created the association by using the
     * <code>Targets</code> parameter, then you must retrieve the association by using the association ID. If you
     * created the association by specifying an instance ID and a Systems Manager document, then you retrieve the
     * association by specifying the document name and the instance ID.
     * </p>
     *
     * @param describeAssociationRequest
     * @return A Java Future containing the result of the DescribeAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidAssociationVersionException The version you specified is not valid. Use
     *         ListAssociationVersions to view all versions of an association according to the association ID. Or, use
     *         the <code>&#36LATEST</code> parameter to view the latest version of the association.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAssociationResponse> describeAssociation(
            DescribeAssociationRequest describeAssociationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the association for the specified target or instance. If you created the association by using the
     * <code>Targets</code> parameter, then you must retrieve the association by using the association ID. If you
     * created the association by specifying an instance ID and a Systems Manager document, then you retrieve the
     * association by specifying the document name and the instance ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssociationRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeAssociationRequest#builder()}
     * </p>
     *
     * @param describeAssociationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssociationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAssociation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidAssociationVersionException The version you specified is not valid. Use
     *         ListAssociationVersions to view all versions of an association according to the association ID. Or, use
     *         the <code>&#36LATEST</code> parameter to view the latest version of the association.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeAssociationResponse> describeAssociation(
            Consumer<DescribeAssociationRequest.Builder> describeAssociationRequest) {
        return describeAssociation(DescribeAssociationRequest.builder().applyMutation(describeAssociationRequest).build());
    }

    /**
     * <p>
     * Use this API action to view information about a specific execution of a specific association.
     * </p>
     *
     * @param describeAssociationExecutionTargetsRequest
     * @return A Java Future containing the result of the DescribeAssociationExecutionTargets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>AssociationExecutionDoesNotExistException The specified execution ID does not exist. Verify the ID
     *         number and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociationExecutionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssociationExecutionTargetsResponse> describeAssociationExecutionTargets(
            DescribeAssociationExecutionTargetsRequest describeAssociationExecutionTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this API action to view information about a specific execution of a specific association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssociationExecutionTargetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAssociationExecutionTargetsRequest#builder()}
     * </p>
     *
     * @param describeAssociationExecutionTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssociationExecutionTargetsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAssociationExecutionTargets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>AssociationExecutionDoesNotExistException The specified execution ID does not exist. Verify the ID
     *         number and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociationExecutionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssociationExecutionTargetsResponse> describeAssociationExecutionTargets(
            Consumer<DescribeAssociationExecutionTargetsRequest.Builder> describeAssociationExecutionTargetsRequest) {
        return describeAssociationExecutionTargets(DescribeAssociationExecutionTargetsRequest.builder()
                .applyMutation(describeAssociationExecutionTargetsRequest).build());
    }

    /**
     * <p>
     * Use this API action to view information about a specific execution of a specific association.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAssociationExecutionTargets(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsPublisher publisher = client.describeAssociationExecutionTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsPublisher publisher = client.describeAssociationExecutionTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAssociationExecutionTargets(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAssociationExecutionTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>AssociationExecutionDoesNotExistException The specified execution ID does not exist. Verify the ID
     *         number and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociationExecutionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssociationExecutionTargetsPublisher describeAssociationExecutionTargetsPaginator(
            DescribeAssociationExecutionTargetsRequest describeAssociationExecutionTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this API action to view information about a specific execution of a specific association.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAssociationExecutionTargets(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsPublisher publisher = client.describeAssociationExecutionTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsPublisher publisher = client.describeAssociationExecutionTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAssociationExecutionTargets(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssociationExecutionTargetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAssociationExecutionTargetsRequest#builder()}
     * </p>
     *
     * @param describeAssociationExecutionTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssociationExecutionTargetsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>AssociationExecutionDoesNotExistException The specified execution ID does not exist. Verify the ID
     *         number and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociationExecutionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssociationExecutionTargetsPublisher describeAssociationExecutionTargetsPaginator(
            Consumer<DescribeAssociationExecutionTargetsRequest.Builder> describeAssociationExecutionTargetsRequest) {
        return describeAssociationExecutionTargetsPaginator(DescribeAssociationExecutionTargetsRequest.builder()
                .applyMutation(describeAssociationExecutionTargetsRequest).build());
    }

    /**
     * <p>
     * Use this API action to view all executions for a specific association ID.
     * </p>
     *
     * @param describeAssociationExecutionsRequest
     * @return A Java Future containing the result of the DescribeAssociationExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssociationExecutionsResponse> describeAssociationExecutions(
            DescribeAssociationExecutionsRequest describeAssociationExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this API action to view all executions for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssociationExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAssociationExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAssociationExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssociationExecutionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAssociationExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAssociationExecutionsResponse> describeAssociationExecutions(
            Consumer<DescribeAssociationExecutionsRequest.Builder> describeAssociationExecutionsRequest) {
        return describeAssociationExecutions(DescribeAssociationExecutionsRequest.builder()
                .applyMutation(describeAssociationExecutionsRequest).build());
    }

    /**
     * <p>
     * Use this API action to view all executions for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAssociationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsPublisher publisher = client.describeAssociationExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsPublisher publisher = client.describeAssociationExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAssociationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAssociationExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssociationExecutionsPublisher describeAssociationExecutionsPaginator(
            DescribeAssociationExecutionsRequest describeAssociationExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this API action to view all executions for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAssociationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsPublisher publisher = client.describeAssociationExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsPublisher publisher = client.describeAssociationExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAssociationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAssociationExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAssociationExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAssociationExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAssociationExecutionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAssociationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAssociationExecutionsPublisher describeAssociationExecutionsPaginator(
            Consumer<DescribeAssociationExecutionsRequest.Builder> describeAssociationExecutionsRequest) {
        return describeAssociationExecutionsPaginator(DescribeAssociationExecutionsRequest.builder()
                .applyMutation(describeAssociationExecutionsRequest).build());
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     * @return A Java Future containing the result of the DescribeAutomationExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutomationExecutionsResponse> describeAutomationExecutions(
            DescribeAutomationExecutionsRequest describeAutomationExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutomationExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutomationExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAutomationExecutionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeAutomationExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutomationExecutionsResponse> describeAutomationExecutions(
            Consumer<DescribeAutomationExecutionsRequest.Builder> describeAutomationExecutionsRequest) {
        return describeAutomationExecutions(DescribeAutomationExecutionsRequest.builder()
                .applyMutation(describeAutomationExecutionsRequest).build());
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAutomationExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutomationExecutionsResponse> describeAutomationExecutions() {
        return describeAutomationExecutions(DescribeAutomationExecutionsRequest.builder().build());
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsPublisher publisher = client.describeAutomationExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsPublisher publisher = client.describeAutomationExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationExecutionsPublisher describeAutomationExecutionsPaginator() {
        return describeAutomationExecutionsPaginator(DescribeAutomationExecutionsRequest.builder().build());
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsPublisher publisher = client.describeAutomationExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsPublisher publisher = client.describeAutomationExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationExecutionsPublisher describeAutomationExecutionsPaginator(
            DescribeAutomationExecutionsRequest describeAutomationExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsPublisher publisher = client.describeAutomationExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsPublisher publisher = client.describeAutomationExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutomationExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutomationExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAutomationExecutionsRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationExecutionsPublisher describeAutomationExecutionsPaginator(
            Consumer<DescribeAutomationExecutionsRequest.Builder> describeAutomationExecutionsRequest) {
        return describeAutomationExecutionsPaginator(DescribeAutomationExecutionsRequest.builder()
                .applyMutation(describeAutomationExecutionsRequest).build());
    }

    /**
     * <p>
     * Information about all active and terminated step executions in an Automation workflow.
     * </p>
     *
     * @param describeAutomationStepExecutionsRequest
     * @return A Java Future containing the result of the DescribeAutomationStepExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutomationStepExecutionsResponse> describeAutomationStepExecutions(
            DescribeAutomationStepExecutionsRequest describeAutomationStepExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information about all active and terminated step executions in an Automation workflow.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutomationStepExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutomationStepExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAutomationStepExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAutomationStepExecutionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeAutomationStepExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeAutomationStepExecutionsResponse> describeAutomationStepExecutions(
            Consumer<DescribeAutomationStepExecutionsRequest.Builder> describeAutomationStepExecutionsRequest) {
        return describeAutomationStepExecutions(DescribeAutomationStepExecutionsRequest.builder()
                .applyMutation(describeAutomationStepExecutionsRequest).build());
    }

    /**
     * <p>
     * Information about all active and terminated step executions in an Automation workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationStepExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsPublisher publisher = client.describeAutomationStepExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsPublisher publisher = client.describeAutomationStepExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationStepExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutomationStepExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationStepExecutionsPublisher describeAutomationStepExecutionsPaginator(
            DescribeAutomationStepExecutionsRequest describeAutomationStepExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information about all active and terminated step executions in an Automation workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationStepExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsPublisher publisher = client.describeAutomationStepExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsPublisher publisher = client.describeAutomationStepExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationStepExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAutomationStepExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeAutomationStepExecutionsRequest#builder()}
     * </p>
     *
     * @param describeAutomationStepExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAutomationStepExecutionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAutomationStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeAutomationStepExecutionsPublisher describeAutomationStepExecutionsPaginator(
            Consumer<DescribeAutomationStepExecutionsRequest.Builder> describeAutomationStepExecutionsRequest) {
        return describeAutomationStepExecutionsPaginator(DescribeAutomationStepExecutionsRequest.builder()
                .applyMutation(describeAutomationStepExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     *
     * @param describeAvailablePatchesRequest
     * @return A Java Future containing the result of the DescribeAvailablePatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAvailablePatchesResponse> describeAvailablePatches(
            DescribeAvailablePatchesRequest describeAvailablePatchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAvailablePatchesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAvailablePatchesRequest#builder()}
     * </p>
     *
     * @param describeAvailablePatchesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAvailablePatchesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeAvailablePatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAvailablePatchesResponse> describeAvailablePatches(
            Consumer<DescribeAvailablePatchesRequest.Builder> describeAvailablePatchesRequest) {
        return describeAvailablePatches(DescribeAvailablePatchesRequest.builder().applyMutation(describeAvailablePatchesRequest)
                .build());
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeAvailablePatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeAvailablePatchesResponse> describeAvailablePatches() {
        return describeAvailablePatches(DescribeAvailablePatchesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesPublisher publisher = client.describeAvailablePatchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesPublisher publisher = client.describeAvailablePatchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAvailablePatchesPublisher describeAvailablePatchesPaginator() {
        return describeAvailablePatchesPaginator(DescribeAvailablePatchesRequest.builder().build());
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesPublisher publisher = client.describeAvailablePatchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesPublisher publisher = client.describeAvailablePatchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAvailablePatchesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAvailablePatchesPublisher describeAvailablePatchesPaginator(
            DescribeAvailablePatchesRequest describeAvailablePatchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesPublisher publisher = client.describeAvailablePatchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesPublisher publisher = client.describeAvailablePatchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAvailablePatchesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeAvailablePatchesRequest#builder()}
     * </p>
     *
     * @param describeAvailablePatchesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAvailablePatchesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAvailablePatchesPublisher describeAvailablePatchesPaginator(
            Consumer<DescribeAvailablePatchesRequest.Builder> describeAvailablePatchesRequest) {
        return describeAvailablePatchesPaginator(DescribeAvailablePatchesRequest.builder()
                .applyMutation(describeAvailablePatchesRequest).build());
    }

    /**
     * <p>
     * Describes the specified Systems Manager document.
     * </p>
     *
     * @param describeDocumentRequest
     * @return A Java Future containing the result of the DescribeDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDocumentResponse> describeDocument(DescribeDocumentRequest describeDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the specified Systems Manager document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeDocumentRequest#builder()}
     * </p>
     *
     * @param describeDocumentRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDocumentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeDocumentResponse> describeDocument(
            Consumer<DescribeDocumentRequest.Builder> describeDocumentRequest) {
        return describeDocument(DescribeDocumentRequest.builder().applyMutation(describeDocumentRequest).build());
    }

    /**
     * <p>
     * Describes the permissions for a Systems Manager document. If you created the document, you are the owner. If a
     * document is shared, it can either be shared privately (by specifying a user's AWS account ID) or publicly
     * (<i>All</i>).
     * </p>
     *
     * @param describeDocumentPermissionRequest
     * @return A Java Future containing the result of the DescribeDocumentPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidPermissionTypeException The permission type is not supported. <i>Share</i> is the only
     *         supported permission type.</li>
     *         <li>InvalidDocumentOperationException You attempted to delete a document while it is still shared. You
     *         must stop sharing the document before you can delete it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeDocumentPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDocumentPermissionResponse> describeDocumentPermission(
            DescribeDocumentPermissionRequest describeDocumentPermissionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes the permissions for a Systems Manager document. If you created the document, you are the owner. If a
     * document is shared, it can either be shared privately (by specifying a user's AWS account ID) or publicly
     * (<i>All</i>).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDocumentPermissionRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDocumentPermissionRequest#builder()}
     * </p>
     *
     * @param describeDocumentPermissionRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDocumentPermissionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeDocumentPermission operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidPermissionTypeException The permission type is not supported. <i>Share</i> is the only
     *         supported permission type.</li>
     *         <li>InvalidDocumentOperationException You attempted to delete a document while it is still shared. You
     *         must stop sharing the document before you can delete it.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeDocumentPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeDocumentPermissionResponse> describeDocumentPermission(
            Consumer<DescribeDocumentPermissionRequest.Builder> describeDocumentPermissionRequest) {
        return describeDocumentPermission(DescribeDocumentPermissionRequest.builder()
                .applyMutation(describeDocumentPermissionRequest).build());
    }

    /**
     * <p>
     * All associations for the instance(s).
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     * @return A Java Future containing the result of the DescribeEffectiveInstanceAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeEffectiveInstanceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEffectiveInstanceAssociationsResponse> describeEffectiveInstanceAssociations(
            DescribeEffectiveInstanceAssociationsRequest describeEffectiveInstanceAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * All associations for the instance(s).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEffectiveInstanceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEffectiveInstanceAssociationsRequest#builder()}
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEffectiveInstanceAssociationsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeEffectiveInstanceAssociations operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeEffectiveInstanceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEffectiveInstanceAssociationsResponse> describeEffectiveInstanceAssociations(
            Consumer<DescribeEffectiveInstanceAssociationsRequest.Builder> describeEffectiveInstanceAssociationsRequest) {
        return describeEffectiveInstanceAssociations(DescribeEffectiveInstanceAssociationsRequest.builder()
                .applyMutation(describeEffectiveInstanceAssociationsRequest).build());
    }

    /**
     * <p>
     * All associations for the instance(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEffectiveInstanceAssociations(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsPublisher publisher = client.describeEffectiveInstanceAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsPublisher publisher = client.describeEffectiveInstanceAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEffectiveInstanceAssociations(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeEffectiveInstanceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEffectiveInstanceAssociationsPublisher describeEffectiveInstanceAssociationsPaginator(
            DescribeEffectiveInstanceAssociationsRequest describeEffectiveInstanceAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * All associations for the instance(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEffectiveInstanceAssociations(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsPublisher publisher = client.describeEffectiveInstanceAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsPublisher publisher = client.describeEffectiveInstanceAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEffectiveInstanceAssociations(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEffectiveInstanceAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEffectiveInstanceAssociationsRequest#builder()}
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEffectiveInstanceAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeEffectiveInstanceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEffectiveInstanceAssociationsPublisher describeEffectiveInstanceAssociationsPaginator(
            Consumer<DescribeEffectiveInstanceAssociationsRequest.Builder> describeEffectiveInstanceAssociationsRequest) {
        return describeEffectiveInstanceAssociationsPaginator(DescribeEffectiveInstanceAssociationsRequest.builder()
                .applyMutation(describeEffectiveInstanceAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Note
     * that this API applies only to Windows patch baselines.
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     * @return A Java Future containing the result of the DescribeEffectivePatchesForPatchBaseline operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified is not supported, or the
     *         operation is not supported for the operating system.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEffectivePatchesForPatchBaselineResponse> describeEffectivePatchesForPatchBaseline(
            DescribeEffectivePatchesForPatchBaselineRequest describeEffectivePatchesForPatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Note
     * that this API applies only to Windows patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEffectivePatchesForPatchBaselineRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEffectivePatchesForPatchBaselineRequest#builder()}
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeEffectivePatchesForPatchBaselineRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeEffectivePatchesForPatchBaseline operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified is not supported, or the
     *         operation is not supported for the operating system.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeEffectivePatchesForPatchBaselineResponse> describeEffectivePatchesForPatchBaseline(
            Consumer<DescribeEffectivePatchesForPatchBaselineRequest.Builder> describeEffectivePatchesForPatchBaselineRequest) {
        return describeEffectivePatchesForPatchBaseline(DescribeEffectivePatchesForPatchBaselineRequest.builder()
                .applyMutation(describeEffectivePatchesForPatchBaselineRequest).build());
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Note
     * that this API applies only to Windows patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEffectivePatchesForPatchBaseline(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselinePublisher publisher = client.describeEffectivePatchesForPatchBaselinePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselinePublisher publisher = client.describeEffectivePatchesForPatchBaselinePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEffectivePatchesForPatchBaseline(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified is not supported, or the
     *         operation is not supported for the operating system.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEffectivePatchesForPatchBaselinePublisher describeEffectivePatchesForPatchBaselinePaginator(
            DescribeEffectivePatchesForPatchBaselineRequest describeEffectivePatchesForPatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline. Note
     * that this API applies only to Windows patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEffectivePatchesForPatchBaseline(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselinePublisher publisher = client.describeEffectivePatchesForPatchBaselinePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselinePublisher publisher = client.describeEffectivePatchesForPatchBaselinePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEffectivePatchesForPatchBaseline(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeEffectivePatchesForPatchBaselineRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeEffectivePatchesForPatchBaselineRequest#builder()}
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeEffectivePatchesForPatchBaselineRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified is not supported, or the
     *         operation is not supported for the operating system.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEffectivePatchesForPatchBaselinePublisher describeEffectivePatchesForPatchBaselinePaginator(
            Consumer<DescribeEffectivePatchesForPatchBaselineRequest.Builder> describeEffectivePatchesForPatchBaselineRequest) {
        return describeEffectivePatchesForPatchBaselinePaginator(DescribeEffectivePatchesForPatchBaselineRequest.builder()
                .applyMutation(describeEffectivePatchesForPatchBaselineRequest).build());
    }

    /**
     * <p>
     * The status of the associations for the instance(s).
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     * @return A Java Future containing the result of the DescribeInstanceAssociationsStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceAssociationsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceAssociationsStatusResponse> describeInstanceAssociationsStatus(
            DescribeInstanceAssociationsStatusRequest describeInstanceAssociationsStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The status of the associations for the instance(s).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceAssociationsStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceAssociationsStatusRequest#builder()}
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstanceAssociationsStatusRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeInstanceAssociationsStatus operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceAssociationsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceAssociationsStatusResponse> describeInstanceAssociationsStatus(
            Consumer<DescribeInstanceAssociationsStatusRequest.Builder> describeInstanceAssociationsStatusRequest) {
        return describeInstanceAssociationsStatus(DescribeInstanceAssociationsStatusRequest.builder()
                .applyMutation(describeInstanceAssociationsStatusRequest).build());
    }

    /**
     * <p>
     * The status of the associations for the instance(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceAssociationsStatus(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusPublisher publisher = client.describeInstanceAssociationsStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusPublisher publisher = client.describeInstanceAssociationsStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceAssociationsStatus(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceAssociationsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceAssociationsStatusPublisher describeInstanceAssociationsStatusPaginator(
            DescribeInstanceAssociationsStatusRequest describeInstanceAssociationsStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The status of the associations for the instance(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceAssociationsStatus(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusPublisher publisher = client.describeInstanceAssociationsStatusPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusPublisher publisher = client.describeInstanceAssociationsStatusPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceAssociationsStatus(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceAssociationsStatusRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceAssociationsStatusRequest#builder()}
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstanceAssociationsStatusRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceAssociationsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceAssociationsStatusPublisher describeInstanceAssociationsStatusPaginator(
            Consumer<DescribeInstanceAssociationsStatusRequest.Builder> describeInstanceAssociationsStatusRequest) {
        return describeInstanceAssociationsStatusPaginator(DescribeInstanceAssociationsStatusRequest.builder()
                .applyMutation(describeInstanceAssociationsStatusRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your instances, including information about the operating system platform, the version
     * of SSM Agent installed on the instance, instance status, and so on.
     * </p>
     * <p>
     * If you specify one or more instance IDs, it returns information for those instances. If you do not specify
     * instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or
     * an instance that you do not own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to
     * on-premises instances. This call does not return the IAM role for EC2 instances.
     * </p>
     * </note>
     *
     * @param describeInstanceInformationRequest
     * @return A Java Future containing the result of the DescribeInstanceInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidInstanceInformationFilterValueException The specified filter value is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceInformationResponse> describeInstanceInformation(
            DescribeInstanceInformationRequest describeInstanceInformationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your instances, including information about the operating system platform, the version
     * of SSM Agent installed on the instance, instance status, and so on.
     * </p>
     * <p>
     * If you specify one or more instance IDs, it returns information for those instances. If you do not specify
     * instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or
     * an instance that you do not own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to
     * on-premises instances. This call does not return the IAM role for EC2 instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceInformationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceInformationRequest#builder()}
     * </p>
     *
     * @param describeInstanceInformationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstanceInformationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeInstanceInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidInstanceInformationFilterValueException The specified filter value is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceInformationResponse> describeInstanceInformation(
            Consumer<DescribeInstanceInformationRequest.Builder> describeInstanceInformationRequest) {
        return describeInstanceInformation(DescribeInstanceInformationRequest.builder()
                .applyMutation(describeInstanceInformationRequest).build());
    }

    /**
     * <p>
     * Describes one or more of your instances, including information about the operating system platform, the version
     * of SSM Agent installed on the instance, instance status, and so on.
     * </p>
     * <p>
     * If you specify one or more instance IDs, it returns information for those instances. If you do not specify
     * instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or
     * an instance that you do not own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to
     * on-premises instances. This call does not return the IAM role for EC2 instances.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeInstanceInformation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidInstanceInformationFilterValueException The specified filter value is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstanceInformationResponse> describeInstanceInformation() {
        return describeInstanceInformation(DescribeInstanceInformationRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more of your instances, including information about the operating system platform, the version
     * of SSM Agent installed on the instance, instance status, and so on.
     * </p>
     * <p>
     * If you specify one or more instance IDs, it returns information for those instances. If you do not specify
     * instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or
     * an instance that you do not own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to
     * on-premises instances. This call does not return the IAM role for EC2 instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationPublisher publisher = client.describeInstanceInformationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationPublisher publisher = client.describeInstanceInformationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidInstanceInformationFilterValueException The specified filter value is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceInformationPublisher describeInstanceInformationPaginator() {
        return describeInstanceInformationPaginator(DescribeInstanceInformationRequest.builder().build());
    }

    /**
     * <p>
     * Describes one or more of your instances, including information about the operating system platform, the version
     * of SSM Agent installed on the instance, instance status, and so on.
     * </p>
     * <p>
     * If you specify one or more instance IDs, it returns information for those instances. If you do not specify
     * instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or
     * an instance that you do not own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to
     * on-premises instances. This call does not return the IAM role for EC2 instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationPublisher publisher = client.describeInstanceInformationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationPublisher publisher = client.describeInstanceInformationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceInformationRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidInstanceInformationFilterValueException The specified filter value is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceInformationPublisher describeInstanceInformationPaginator(
            DescribeInstanceInformationRequest describeInstanceInformationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes one or more of your instances, including information about the operating system platform, the version
     * of SSM Agent installed on the instance, instance status, and so on.
     * </p>
     * <p>
     * If you specify one or more instance IDs, it returns information for those instances. If you do not specify
     * instance IDs, it returns information for all your instances. If you specify an instance ID that is not valid or
     * an instance that you do not own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The IamRole field for this API action is the Amazon Identity and Access Management (IAM) role assigned to
     * on-premises instances. This call does not return the IAM role for EC2 instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationPublisher publisher = client.describeInstanceInformationPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationPublisher publisher = client.describeInstanceInformationPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstanceInformationRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstanceInformationRequest#builder()}
     * </p>
     *
     * @param describeInstanceInformationRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstanceInformationRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidInstanceInformationFilterValueException The specified filter value is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstanceInformationPublisher describeInstanceInformationPaginator(
            Consumer<DescribeInstanceInformationRequest.Builder> describeInstanceInformationRequest) {
        return describeInstanceInformationPaginator(DescribeInstanceInformationRequest.builder()
                .applyMutation(describeInstanceInformationRequest).build());
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more instances.
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     * @return A Java Future containing the result of the DescribeInstancePatchStates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatchStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstancePatchStatesResponse> describeInstancePatchStates(
            DescribeInstancePatchStatesRequest describeInstancePatchStatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more instances.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancePatchStatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstancePatchStatesRequest#builder()}
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstancePatchStatesRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DescribeInstancePatchStates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatchStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstancePatchStatesResponse> describeInstancePatchStates(
            Consumer<DescribeInstancePatchStatesRequest.Builder> describeInstancePatchStatesRequest) {
        return describeInstancePatchStates(DescribeInstancePatchStatesRequest.builder()
                .applyMutation(describeInstancePatchStatesRequest).build());
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the instances in the specified patch group.
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     * @return A Java Future containing the result of the DescribeInstancePatchStatesForPatchGroup operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstancePatchStatesForPatchGroupResponse> describeInstancePatchStatesForPatchGroup(
            DescribeInstancePatchStatesForPatchGroupRequest describeInstancePatchStatesForPatchGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the instances in the specified patch group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeInstancePatchStatesForPatchGroupRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeInstancePatchStatesForPatchGroupRequest#builder()}
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeInstancePatchStatesForPatchGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeInstancePatchStatesForPatchGroup operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInstancePatchStatesForPatchGroupResponse> describeInstancePatchStatesForPatchGroup(
            Consumer<DescribeInstancePatchStatesForPatchGroupRequest.Builder> describeInstancePatchStatesForPatchGroupRequest) {
        return describeInstancePatchStatesForPatchGroup(DescribeInstancePatchStatesForPatchGroupRequest.builder()
                .applyMutation(describeInstancePatchStatesForPatchGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the instances in the specified patch group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatchStatesForPatchGroup(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupPublisher publisher = client.describeInstancePatchStatesForPatchGroupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupPublisher publisher = client.describeInstancePatchStatesForPatchGroupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatchStatesForPatchGroup(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancePatchStatesForPatchGroupPublisher describeInstancePatchStatesForPatchGroupPaginator(
            DescribeInstancePatchStatesForPatchGroupRequest describeInstancePatchStatesForPatchGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the instances in the specified patch group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatchStatesForPatchGroup(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupPublisher publisher = client.describeInstancePatchStatesForPatchGroupPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupPublisher publisher = client.describeInstancePatchStatesForPatchGroupPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatchStatesForPatchGroup(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeInstancePatchStatesForPatchGroupRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeInstancePatchStatesForPatchGroupRequest#builder()}
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeInstancePatchStatesForPatchGroupRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancePatchStatesForPatchGroupPublisher describeInstancePatchStatesForPatchGroupPaginator(
            Consumer<DescribeInstancePatchStatesForPatchGroupRequest.Builder> describeInstancePatchStatesForPatchGroupRequest) {
        return describeInstancePatchStatesForPatchGroupPaginator(DescribeInstancePatchStatesForPatchGroupRequest.builder()
                .applyMutation(describeInstancePatchStatesForPatchGroupRequest).build());
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatchStates(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesPublisher publisher = client.describeInstancePatchStatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesPublisher publisher = client.describeInstancePatchStatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatchStates(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatchStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancePatchStatesPublisher describeInstancePatchStatesPaginator(
            DescribeInstancePatchStatesRequest describeInstancePatchStatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more instances.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatchStates(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesPublisher publisher = client.describeInstancePatchStatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesPublisher publisher = client.describeInstancePatchStatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatchStates(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancePatchStatesRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeInstancePatchStatesRequest#builder()}
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstancePatchStatesRequest.Builder} to create
     *        a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatchStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInstancePatchStatesPublisher describeInstancePatchStatesPaginator(
            Consumer<DescribeInstancePatchStatesRequest.Builder> describeInstancePatchStatesRequest) {
        return describeInstancePatchStatesPaginator(DescribeInstancePatchStatesRequest.builder()
                .applyMutation(describeInstancePatchStatesRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified instance and their state relative to the patch baseline
     * being used for the instance.
     * </p>
     *
     * @param describeInstancePatchesRequest
     * @return A Java Future containing the result of the DescribeInstancePatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInstancePatchesResponse> describeInstancePatches(
            DescribeInstancePatchesRequest describeInstancePatchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified instance and their state relative to the patch baseline
     * being used for the instance.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancePatchesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstancePatchesRequest#builder()}
     * </p>
     *
     * @param describeInstancePatchesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstancePatchesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeInstancePatches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeInstancePatchesResponse> describeInstancePatches(
            Consumer<DescribeInstancePatchesRequest.Builder> describeInstancePatchesRequest) {
        return describeInstancePatches(DescribeInstancePatchesRequest.builder().applyMutation(describeInstancePatchesRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified instance and their state relative to the patch baseline
     * being used for the instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatches(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesPublisher publisher = client.describeInstancePatchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesPublisher publisher = client.describeInstancePatchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatches(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancePatchesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstancePatchesPublisher describeInstancePatchesPaginator(
            DescribeInstancePatchesRequest describeInstancePatchesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified instance and their state relative to the patch baseline
     * being used for the instance.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatches(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesPublisher publisher = client.describeInstancePatchesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesPublisher publisher = client.describeInstancePatchesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatches(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInstancePatchesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInstancePatchesRequest#builder()}
     * </p>
     *
     * @param describeInstancePatchesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInstancePatchesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInstancePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeInstancePatchesPublisher describeInstancePatchesPaginator(
            Consumer<DescribeInstancePatchesRequest.Builder> describeInstancePatchesRequest) {
        return describeInstancePatchesPaginator(DescribeInstancePatchesRequest.builder()
                .applyMutation(describeInstancePatchesRequest).build());
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     *
     * @param describeInventoryDeletionsRequest
     * @return A Java Future containing the result of the DescribeInventoryDeletions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDeletionIdException The ID specified for the delete operation does not exist or is not valid.
     *         Verify the ID and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInventoryDeletionsResponse> describeInventoryDeletions(
            DescribeInventoryDeletionsRequest describeInventoryDeletionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInventoryDeletionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInventoryDeletionsRequest#builder()}
     * </p>
     *
     * @param describeInventoryDeletionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInventoryDeletionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeInventoryDeletions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDeletionIdException The ID specified for the delete operation does not exist or is not valid.
     *         Verify the ID and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInventoryDeletionsResponse> describeInventoryDeletions(
            Consumer<DescribeInventoryDeletionsRequest.Builder> describeInventoryDeletionsRequest) {
        return describeInventoryDeletions(DescribeInventoryDeletionsRequest.builder()
                .applyMutation(describeInventoryDeletionsRequest).build());
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeInventoryDeletions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDeletionIdException The ID specified for the delete operation does not exist or is not valid.
     *         Verify the ID and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeInventoryDeletionsResponse> describeInventoryDeletions() {
        return describeInventoryDeletions(DescribeInventoryDeletionsRequest.builder().build());
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsPublisher publisher = client.describeInventoryDeletionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsPublisher publisher = client.describeInventoryDeletionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDeletionIdException The ID specified for the delete operation does not exist or is not valid.
     *         Verify the ID and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInventoryDeletionsPublisher describeInventoryDeletionsPaginator() {
        return describeInventoryDeletionsPaginator(DescribeInventoryDeletionsRequest.builder().build());
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsPublisher publisher = client.describeInventoryDeletionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsPublisher publisher = client.describeInventoryDeletionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInventoryDeletionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDeletionIdException The ID specified for the delete operation does not exist or is not valid.
     *         Verify the ID and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInventoryDeletionsPublisher describeInventoryDeletionsPaginator(
            DescribeInventoryDeletionsRequest describeInventoryDeletionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsPublisher publisher = client.describeInventoryDeletionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsPublisher publisher = client.describeInventoryDeletionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeInventoryDeletionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeInventoryDeletionsRequest#builder()}
     * </p>
     *
     * @param describeInventoryDeletionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeInventoryDeletionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDeletionIdException The ID specified for the delete operation does not exist or is not valid.
     *         Verify the ID and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeInventoryDeletionsPublisher describeInventoryDeletionsPaginator(
            Consumer<DescribeInventoryDeletionsRequest.Builder> describeInventoryDeletionsRequest) {
        return describeInventoryDeletionsPaginator(DescribeInventoryDeletionsRequest.builder()
                .applyMutation(describeInventoryDeletionsRequest).build());
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance
     * window execution.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutionTaskInvocations operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowExecutionTaskInvocationsResponse> describeMaintenanceWindowExecutionTaskInvocations(
            DescribeMaintenanceWindowExecutionTaskInvocationsRequest describeMaintenanceWindowExecutionTaskInvocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance
     * window execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder} avoiding the need to create one manually
     * via {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutionTaskInvocations operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowExecutionTaskInvocationsResponse> describeMaintenanceWindowExecutionTaskInvocations(
            Consumer<DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder> describeMaintenanceWindowExecutionTaskInvocationsRequest) {
        return describeMaintenanceWindowExecutionTaskInvocations(DescribeMaintenanceWindowExecutionTaskInvocationsRequest
                .builder().applyMutation(describeMaintenanceWindowExecutionTaskInvocationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance
     * window execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutionTaskInvocations(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsPublisher publisher = client.describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsPublisher publisher = client.describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutionTaskInvocations(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionTaskInvocationsPublisher describeMaintenanceWindowExecutionTaskInvocationsPaginator(
            DescribeMaintenanceWindowExecutionTaskInvocationsRequest describeMaintenanceWindowExecutionTaskInvocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance
     * window execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutionTaskInvocations(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsPublisher publisher = client.describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsPublisher publisher = client.describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutionTaskInvocations(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder} avoiding the need to create one manually
     * via {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionTaskInvocationsPublisher describeMaintenanceWindowExecutionTaskInvocationsPaginator(
            Consumer<DescribeMaintenanceWindowExecutionTaskInvocationsRequest.Builder> describeMaintenanceWindowExecutionTaskInvocationsRequest) {
        return describeMaintenanceWindowExecutionTaskInvocationsPaginator(DescribeMaintenanceWindowExecutionTaskInvocationsRequest
                .builder().applyMutation(describeMaintenanceWindowExecutionTaskInvocationsRequest).build());
    }

    /**
     * <p>
     * For a given maintenance window execution, lists the tasks that were run.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutionTasks operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowExecutionTasksResponse> describeMaintenanceWindowExecutionTasks(
            DescribeMaintenanceWindowExecutionTasksRequest describeMaintenanceWindowExecutionTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given maintenance window execution, lists the tasks that were run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMaintenanceWindowExecutionTasksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMaintenanceWindowExecutionTasksRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeMaintenanceWindowExecutionTasksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutionTasks operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowExecutionTasksResponse> describeMaintenanceWindowExecutionTasks(
            Consumer<DescribeMaintenanceWindowExecutionTasksRequest.Builder> describeMaintenanceWindowExecutionTasksRequest) {
        return describeMaintenanceWindowExecutionTasks(DescribeMaintenanceWindowExecutionTasksRequest.builder()
                .applyMutation(describeMaintenanceWindowExecutionTasksRequest).build());
    }

    /**
     * <p>
     * For a given maintenance window execution, lists the tasks that were run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutionTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksPublisher publisher = client.describeMaintenanceWindowExecutionTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksPublisher publisher = client.describeMaintenanceWindowExecutionTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutionTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionTasksPublisher describeMaintenanceWindowExecutionTasksPaginator(
            DescribeMaintenanceWindowExecutionTasksRequest describeMaintenanceWindowExecutionTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a given maintenance window execution, lists the tasks that were run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutionTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksPublisher publisher = client.describeMaintenanceWindowExecutionTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksPublisher publisher = client.describeMaintenanceWindowExecutionTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutionTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeMaintenanceWindowExecutionTasksRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeMaintenanceWindowExecutionTasksRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeMaintenanceWindowExecutionTasksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionTasksPublisher describeMaintenanceWindowExecutionTasksPaginator(
            Consumer<DescribeMaintenanceWindowExecutionTasksRequest.Builder> describeMaintenanceWindowExecutionTasksRequest) {
        return describeMaintenanceWindowExecutionTasksPaginator(DescribeMaintenanceWindowExecutionTasksRequest.builder()
                .applyMutation(describeMaintenanceWindowExecutionTasksRequest).build());
    }

    /**
     * <p>
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was
     * scheduled to be active, and information about tasks registered and run with the maintenance window.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowExecutionsResponse> describeMaintenanceWindowExecutions(
            DescribeMaintenanceWindowExecutionsRequest describeMaintenanceWindowExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was
     * scheduled to be active, and information about tasks registered and run with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowExecutionsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowExecutionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeMaintenanceWindowExecutions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowExecutionsResponse> describeMaintenanceWindowExecutions(
            Consumer<DescribeMaintenanceWindowExecutionsRequest.Builder> describeMaintenanceWindowExecutionsRequest) {
        return describeMaintenanceWindowExecutions(DescribeMaintenanceWindowExecutionsRequest.builder()
                .applyMutation(describeMaintenanceWindowExecutionsRequest).build());
    }

    /**
     * <p>
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was
     * scheduled to be active, and information about tasks registered and run with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutions(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsPublisher publisher = client.describeMaintenanceWindowExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsPublisher publisher = client.describeMaintenanceWindowExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutions(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionsPublisher describeMaintenanceWindowExecutionsPaginator(
            DescribeMaintenanceWindowExecutionsRequest describeMaintenanceWindowExecutionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was
     * scheduled to be active, and information about tasks registered and run with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutions(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsPublisher publisher = client.describeMaintenanceWindowExecutionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsPublisher publisher = client.describeMaintenanceWindowExecutionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutions(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowExecutionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowExecutionsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowExecutionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowExecutionsPublisher describeMaintenanceWindowExecutionsPaginator(
            Consumer<DescribeMaintenanceWindowExecutionsRequest.Builder> describeMaintenanceWindowExecutionsRequest) {
        return describeMaintenanceWindowExecutionsPaginator(DescribeMaintenanceWindowExecutionsRequest.builder()
                .applyMutation(describeMaintenanceWindowExecutionsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about upcoming executions of a maintenance window.
     * </p>
     *
     * @param describeMaintenanceWindowScheduleRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowScheduleResponse> describeMaintenanceWindowSchedule(
            DescribeMaintenanceWindowScheduleRequest describeMaintenanceWindowScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about upcoming executions of a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowScheduleRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowScheduleRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeMaintenanceWindowSchedule operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowScheduleResponse> describeMaintenanceWindowSchedule(
            Consumer<DescribeMaintenanceWindowScheduleRequest.Builder> describeMaintenanceWindowScheduleRequest) {
        return describeMaintenanceWindowSchedule(DescribeMaintenanceWindowScheduleRequest.builder()
                .applyMutation(describeMaintenanceWindowScheduleRequest).build());
    }

    /**
     * <p>
     * Retrieves information about upcoming executions of a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowSchedule(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowSchedulePublisher publisher = client.describeMaintenanceWindowSchedulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowSchedulePublisher publisher = client.describeMaintenanceWindowSchedulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowSchedule(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowScheduleRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowSchedulePublisher describeMaintenanceWindowSchedulePaginator(
            DescribeMaintenanceWindowScheduleRequest describeMaintenanceWindowScheduleRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about upcoming executions of a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowSchedule(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowSchedulePublisher publisher = client.describeMaintenanceWindowSchedulePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowSchedulePublisher publisher = client.describeMaintenanceWindowSchedulePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowSchedule(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowScheduleRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowScheduleRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowScheduleRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowScheduleRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowSchedulePublisher describeMaintenanceWindowSchedulePaginator(
            Consumer<DescribeMaintenanceWindowScheduleRequest.Builder> describeMaintenanceWindowScheduleRequest) {
        return describeMaintenanceWindowSchedulePaginator(DescribeMaintenanceWindowScheduleRequest.builder()
                .applyMutation(describeMaintenanceWindowScheduleRequest).build());
    }

    /**
     * <p>
     * Lists the targets registered with the maintenance window.
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowTargets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowTargetsResponse> describeMaintenanceWindowTargets(
            DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the targets registered with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowTargetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowTargetsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowTargetsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeMaintenanceWindowTargets operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowTargetsResponse> describeMaintenanceWindowTargets(
            Consumer<DescribeMaintenanceWindowTargetsRequest.Builder> describeMaintenanceWindowTargetsRequest) {
        return describeMaintenanceWindowTargets(DescribeMaintenanceWindowTargetsRequest.builder()
                .applyMutation(describeMaintenanceWindowTargetsRequest).build());
    }

    /**
     * <p>
     * Lists the targets registered with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowTargets(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsPublisher publisher = client.describeMaintenanceWindowTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsPublisher publisher = client.describeMaintenanceWindowTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowTargets(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowTargetsPublisher describeMaintenanceWindowTargetsPaginator(
            DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the targets registered with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowTargets(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsPublisher publisher = client.describeMaintenanceWindowTargetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsPublisher publisher = client.describeMaintenanceWindowTargetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowTargets(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowTargetsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowTargetsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowTargetsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowTargetsPublisher describeMaintenanceWindowTargetsPaginator(
            Consumer<DescribeMaintenanceWindowTargetsRequest.Builder> describeMaintenanceWindowTargetsRequest) {
        return describeMaintenanceWindowTargetsPaginator(DescribeMaintenanceWindowTargetsRequest.builder()
                .applyMutation(describeMaintenanceWindowTargetsRequest).build());
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you cannot supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values do not affect the running of your task and can be
     * ignored.
     * </p>
     * </note>
     *
     * @param describeMaintenanceWindowTasksRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowTasks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowTasksResponse> describeMaintenanceWindowTasks(
            DescribeMaintenanceWindowTasksRequest describeMaintenanceWindowTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you cannot supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values do not affect the running of your task and can be
     * ignored.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowTasksRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowTasksRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowTasksRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeMaintenanceWindowTasks operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowTasksResponse> describeMaintenanceWindowTasks(
            Consumer<DescribeMaintenanceWindowTasksRequest.Builder> describeMaintenanceWindowTasksRequest) {
        return describeMaintenanceWindowTasks(DescribeMaintenanceWindowTasksRequest.builder()
                .applyMutation(describeMaintenanceWindowTasksRequest).build());
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you cannot supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values do not affect the running of your task and can be
     * ignored.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksPublisher publisher = client.describeMaintenanceWindowTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksPublisher publisher = client.describeMaintenanceWindowTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowTasksPublisher describeMaintenanceWindowTasksPaginator(
            DescribeMaintenanceWindowTasksRequest describeMaintenanceWindowTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you cannot supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values do not affect the running of your task and can be
     * ignored.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksPublisher publisher = client.describeMaintenanceWindowTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksPublisher publisher = client.describeMaintenanceWindowTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowTasksRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowTasksRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowTasksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowTasksRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowTasksPublisher describeMaintenanceWindowTasksPaginator(
            Consumer<DescribeMaintenanceWindowTasksRequest.Builder> describeMaintenanceWindowTasksRequest) {
        return describeMaintenanceWindowTasksPaginator(DescribeMaintenanceWindowTasksRequest.builder()
                .applyMutation(describeMaintenanceWindowTasksRequest).build());
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an AWS account.
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowsResponse> describeMaintenanceWindows(
            DescribeMaintenanceWindowsRequest describeMaintenanceWindowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMaintenanceWindowsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeMaintenanceWindows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowsResponse> describeMaintenanceWindows(
            Consumer<DescribeMaintenanceWindowsRequest.Builder> describeMaintenanceWindowsRequest) {
        return describeMaintenanceWindows(DescribeMaintenanceWindowsRequest.builder()
                .applyMutation(describeMaintenanceWindowsRequest).build());
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribeMaintenanceWindows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowsResponse> describeMaintenanceWindows() {
        return describeMaintenanceWindows(DescribeMaintenanceWindowsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves information about the maintenance window targets or tasks that an instance is associated with.
     * </p>
     *
     * @param describeMaintenanceWindowsForTargetRequest
     * @return A Java Future containing the result of the DescribeMaintenanceWindowsForTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowsForTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowsForTargetResponse> describeMaintenanceWindowsForTarget(
            DescribeMaintenanceWindowsForTargetRequest describeMaintenanceWindowsForTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the maintenance window targets or tasks that an instance is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowsForTargetRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowsForTargetRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowsForTargetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowsForTargetRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DescribeMaintenanceWindowsForTarget operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowsForTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeMaintenanceWindowsForTargetResponse> describeMaintenanceWindowsForTarget(
            Consumer<DescribeMaintenanceWindowsForTargetRequest.Builder> describeMaintenanceWindowsForTargetRequest) {
        return describeMaintenanceWindowsForTarget(DescribeMaintenanceWindowsForTargetRequest.builder()
                .applyMutation(describeMaintenanceWindowsForTargetRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the maintenance window targets or tasks that an instance is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowsForTarget(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetPublisher publisher = client.describeMaintenanceWindowsForTargetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetPublisher publisher = client.describeMaintenanceWindowsForTargetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowsForTarget(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowsForTargetRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowsForTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsForTargetPublisher describeMaintenanceWindowsForTargetPaginator(
            DescribeMaintenanceWindowsForTargetRequest describeMaintenanceWindowsForTargetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the maintenance window targets or tasks that an instance is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowsForTarget(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetPublisher publisher = client.describeMaintenanceWindowsForTargetPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetPublisher publisher = client.describeMaintenanceWindowsForTargetPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowsForTarget(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowsForTargetRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeMaintenanceWindowsForTargetRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowsForTargetRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowsForTargetRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindowsForTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsForTargetPublisher describeMaintenanceWindowsForTargetPaginator(
            Consumer<DescribeMaintenanceWindowsForTargetRequest.Builder> describeMaintenanceWindowsForTargetRequest) {
        return describeMaintenanceWindowsForTargetPaginator(DescribeMaintenanceWindowsForTargetRequest.builder()
                .applyMutation(describeMaintenanceWindowsForTargetRequest).build());
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsPublisher publisher = client.describeMaintenanceWindowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsPublisher publisher = client.describeMaintenanceWindowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsPublisher describeMaintenanceWindowsPaginator() {
        return describeMaintenanceWindowsPaginator(DescribeMaintenanceWindowsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsPublisher publisher = client.describeMaintenanceWindowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsPublisher publisher = client.describeMaintenanceWindowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsPublisher describeMaintenanceWindowsPaginator(
            DescribeMaintenanceWindowsRequest describeMaintenanceWindowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsPublisher publisher = client.describeMaintenanceWindowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsPublisher publisher = client.describeMaintenanceWindowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeMaintenanceWindowsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeMaintenanceWindowsRequest#builder()}
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeMaintenanceWindowsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeMaintenanceWindowsPublisher describeMaintenanceWindowsPaginator(
            Consumer<DescribeMaintenanceWindowsRequest.Builder> describeMaintenanceWindowsRequest) {
        return describeMaintenanceWindowsPaginator(DescribeMaintenanceWindowsRequest.builder()
                .applyMutation(describeMaintenanceWindowsRequest).build());
    }

    /**
     * <p>
     * Query a set of OpsItems. You must have permission in AWS Identity and Access Management (IAM) to query a list of
     * OpsItems. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     *
     * @param describeOpsItemsRequest
     * @return A Java Future containing the result of the DescribeOpsItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeOpsItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeOpsItemsResponse> describeOpsItems(DescribeOpsItemsRequest describeOpsItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Query a set of OpsItems. You must have permission in AWS Identity and Access Management (IAM) to query a list of
     * OpsItems. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOpsItemsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeOpsItemsRequest#builder()}
     * </p>
     *
     * @param describeOpsItemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOpsItemsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeOpsItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeOpsItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeOpsItemsResponse> describeOpsItems(
            Consumer<DescribeOpsItemsRequest.Builder> describeOpsItemsRequest) {
        return describeOpsItems(DescribeOpsItemsRequest.builder().applyMutation(describeOpsItemsRequest).build());
    }

    /**
     * <p>
     * Query a set of OpsItems. You must have permission in AWS Identity and Access Management (IAM) to query a list of
     * OpsItems. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeOpsItems(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsPublisher publisher = client.describeOpsItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsPublisher publisher = client.describeOpsItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOpsItems(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest)} operation.</b>
     * </p>
     *
     * @param describeOpsItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeOpsItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOpsItemsPublisher describeOpsItemsPaginator(DescribeOpsItemsRequest describeOpsItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Query a set of OpsItems. You must have permission in AWS Identity and Access Management (IAM) to query a list of
     * OpsItems. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeOpsItems(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsPublisher publisher = client.describeOpsItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsPublisher publisher = client.describeOpsItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOpsItems(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeOpsItemsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeOpsItemsRequest#builder()}
     * </p>
     *
     * @param describeOpsItemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeOpsItemsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeOpsItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeOpsItemsPublisher describeOpsItemsPaginator(Consumer<DescribeOpsItemsRequest.Builder> describeOpsItemsRequest) {
        return describeOpsItemsPaginator(DescribeOpsItemsRequest.builder().applyMutation(describeOpsItemsRequest).build());
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note>
     *
     * @param describeParametersRequest
     * @return A Java Future containing the result of the DescribeParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeParametersResponse> describeParameters(DescribeParametersRequest describeParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeParametersRequest#builder()}
     * </p>
     *
     * @param describeParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeParametersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeParametersResponse> describeParameters(
            Consumer<DescribeParametersRequest.Builder> describeParametersRequest) {
        return describeParameters(DescribeParametersRequest.builder().applyMutation(describeParametersRequest).build());
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note>
     *
     * @return A Java Future containing the result of the DescribeParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeParametersResponse> describeParameters() {
        return describeParameters(DescribeParametersRequest.builder().build());
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersPublisher publisher = client.describeParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersPublisher publisher = client.describeParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeParametersPublisher describeParametersPaginator() {
        return describeParametersPaginator(DescribeParametersRequest.builder().build());
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersPublisher publisher = client.describeParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersPublisher publisher = client.describeParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation.</b>
     * </p>
     *
     * @param describeParametersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeParametersPublisher describeParametersPaginator(DescribeParametersRequest describeParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersPublisher publisher = client.describeParametersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersPublisher publisher = client.describeParametersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeParametersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeParametersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeParametersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeParametersRequest#builder()}
     * </p>
     *
     * @param describeParametersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeParametersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeParametersPublisher describeParametersPaginator(
            Consumer<DescribeParametersRequest.Builder> describeParametersRequest) {
        return describeParametersPaginator(DescribeParametersRequest.builder().applyMutation(describeParametersRequest).build());
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     *
     * @param describePatchBaselinesRequest
     * @return A Java Future containing the result of the DescribePatchBaselines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePatchBaselinesResponse> describePatchBaselines(
            DescribePatchBaselinesRequest describePatchBaselinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchBaselinesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePatchBaselinesRequest#builder()}
     * </p>
     *
     * @param describePatchBaselinesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchBaselinesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePatchBaselines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePatchBaselinesResponse> describePatchBaselines(
            Consumer<DescribePatchBaselinesRequest.Builder> describePatchBaselinesRequest) {
        return describePatchBaselines(DescribePatchBaselinesRequest.builder().applyMutation(describePatchBaselinesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the DescribePatchBaselines operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePatchBaselinesResponse> describePatchBaselines() {
        return describePatchBaselines(DescribePatchBaselinesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesPublisher publisher = client.describePatchBaselinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesPublisher publisher = client.describePatchBaselinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchBaselinesPublisher describePatchBaselinesPaginator() {
        return describePatchBaselinesPaginator(DescribePatchBaselinesRequest.builder().build());
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesPublisher publisher = client.describePatchBaselinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesPublisher publisher = client.describePatchBaselinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePatchBaselinesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchBaselinesPublisher describePatchBaselinesPaginator(
            DescribePatchBaselinesRequest describePatchBaselinesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the patch baselines in your AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesPublisher publisher = client.describePatchBaselinesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesPublisher publisher = client.describePatchBaselinesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchBaselinesRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePatchBaselinesRequest#builder()}
     * </p>
     *
     * @param describePatchBaselinesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchBaselinesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchBaselinesPublisher describePatchBaselinesPaginator(
            Consumer<DescribePatchBaselinesRequest.Builder> describePatchBaselinesRequest) {
        return describePatchBaselinesPaginator(DescribePatchBaselinesRequest.builder()
                .applyMutation(describePatchBaselinesRequest).build());
    }

    /**
     * <p>
     * Returns high-level aggregated patch compliance state for a patch group.
     * </p>
     *
     * @param describePatchGroupStateRequest
     * @return A Java Future containing the result of the DescribePatchGroupState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchGroupState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePatchGroupStateResponse> describePatchGroupState(
            DescribePatchGroupStateRequest describePatchGroupStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns high-level aggregated patch compliance state for a patch group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchGroupStateRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePatchGroupStateRequest#builder()}
     * </p>
     *
     * @param describePatchGroupStateRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchGroupStateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePatchGroupState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchGroupState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePatchGroupStateResponse> describePatchGroupState(
            Consumer<DescribePatchGroupStateRequest.Builder> describePatchGroupStateRequest) {
        return describePatchGroupState(DescribePatchGroupStateRequest.builder().applyMutation(describePatchGroupStateRequest)
                .build());
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     *
     * @param describePatchGroupsRequest
     * @return A Java Future containing the result of the DescribePatchGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePatchGroupsResponse> describePatchGroups(
            DescribePatchGroupsRequest describePatchGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePatchGroupsRequest#builder()}
     * </p>
     *
     * @param describePatchGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchGroupsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePatchGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePatchGroupsResponse> describePatchGroups(
            Consumer<DescribePatchGroupsRequest.Builder> describePatchGroupsRequest) {
        return describePatchGroups(DescribePatchGroupsRequest.builder().applyMutation(describePatchGroupsRequest).build());
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     *
     * @return A Java Future containing the result of the DescribePatchGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribePatchGroupsResponse> describePatchGroups() {
        return describePatchGroups(DescribePatchGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsPublisher publisher = client.describePatchGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsPublisher publisher = client.describePatchGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePatchGroupsPublisher describePatchGroupsPaginator() {
        return describePatchGroupsPaginator(DescribePatchGroupsRequest.builder().build());
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsPublisher publisher = client.describePatchGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsPublisher publisher = client.describePatchGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation.</b>
     * </p>
     *
     * @param describePatchGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePatchGroupsPublisher describePatchGroupsPaginator(DescribePatchGroupsRequest describePatchGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsPublisher publisher = client.describePatchGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsPublisher publisher = client.describePatchGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchGroupsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribePatchGroupsRequest#builder()}
     * </p>
     *
     * @param describePatchGroupsRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchGroupsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribePatchGroupsPublisher describePatchGroupsPaginator(
            Consumer<DescribePatchGroupsRequest.Builder> describePatchGroupsRequest) {
        return describePatchGroupsPaginator(DescribePatchGroupsRequest.builder().applyMutation(describePatchGroupsRequest)
                .build());
    }

    /**
     * <p>
     * Lists the properties of available patches organized by product, product family, classification, severity, and
     * other properties of available patches. You can use the reported properties in the filters you specify in requests
     * for actions such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>, and
     * <a>DescribePatchBaselines</a>.
     * </p>
     * <p>
     * The following section lists the properties that can be used in filters for each major operating system type:
     * </p>
     * <dl>
     * <dt>AMAZON_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>AMAZON_LINUX_2</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>CENTOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>DEBIAN</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>MACOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION
     * </p>
     * </dd>
     * <dt>ORACLE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>REDHAT_ENTERPRISE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>SUSE</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>UBUNTU</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>WINDOWS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRODUCT_FAMILY, CLASSIFICATION, MSRC_SEVERITY
     * </p>
     * </dd>
     * </dl>
     *
     * @param describePatchPropertiesRequest
     * @return A Java Future containing the result of the DescribePatchProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePatchPropertiesResponse> describePatchProperties(
            DescribePatchPropertiesRequest describePatchPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the properties of available patches organized by product, product family, classification, severity, and
     * other properties of available patches. You can use the reported properties in the filters you specify in requests
     * for actions such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>, and
     * <a>DescribePatchBaselines</a>.
     * </p>
     * <p>
     * The following section lists the properties that can be used in filters for each major operating system type:
     * </p>
     * <dl>
     * <dt>AMAZON_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>AMAZON_LINUX_2</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>CENTOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>DEBIAN</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>MACOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION
     * </p>
     * </dd>
     * <dt>ORACLE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>REDHAT_ENTERPRISE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>SUSE</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>UBUNTU</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>WINDOWS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRODUCT_FAMILY, CLASSIFICATION, MSRC_SEVERITY
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePatchPropertiesRequest#builder()}
     * </p>
     *
     * @param describePatchPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchPropertiesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribePatchProperties operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribePatchPropertiesResponse> describePatchProperties(
            Consumer<DescribePatchPropertiesRequest.Builder> describePatchPropertiesRequest) {
        return describePatchProperties(DescribePatchPropertiesRequest.builder().applyMutation(describePatchPropertiesRequest)
                .build());
    }

    /**
     * <p>
     * Lists the properties of available patches organized by product, product family, classification, severity, and
     * other properties of available patches. You can use the reported properties in the filters you specify in requests
     * for actions such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>, and
     * <a>DescribePatchBaselines</a>.
     * </p>
     * <p>
     * The following section lists the properties that can be used in filters for each major operating system type:
     * </p>
     * <dl>
     * <dt>AMAZON_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>AMAZON_LINUX_2</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>CENTOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>DEBIAN</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>MACOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION
     * </p>
     * </dd>
     * <dt>ORACLE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>REDHAT_ENTERPRISE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>SUSE</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>UBUNTU</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>WINDOWS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRODUCT_FAMILY, CLASSIFICATION, MSRC_SEVERITY
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchProperties(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesPublisher publisher = client.describePatchPropertiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesPublisher publisher = client.describePatchPropertiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchProperties(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePatchPropertiesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchPropertiesPublisher describePatchPropertiesPaginator(
            DescribePatchPropertiesRequest describePatchPropertiesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the properties of available patches organized by product, product family, classification, severity, and
     * other properties of available patches. You can use the reported properties in the filters you specify in requests
     * for actions such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>, and
     * <a>DescribePatchBaselines</a>.
     * </p>
     * <p>
     * The following section lists the properties that can be used in filters for each major operating system type:
     * </p>
     * <dl>
     * <dt>AMAZON_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>AMAZON_LINUX_2</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>CENTOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>DEBIAN</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>MACOS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION
     * </p>
     * </dd>
     * <dt>ORACLE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>REDHAT_ENTERPRISE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>SUSE</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
     * </p>
     * </dd>
     * <dt>UBUNTU</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRIORITY
     * </p>
     * </dd>
     * <dt>WINDOWS</dt>
     * <dd>
     * <p>
     * Valid properties: PRODUCT, PRODUCT_FAMILY, CLASSIFICATION, MSRC_SEVERITY
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchProperties(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesPublisher publisher = client.describePatchPropertiesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesPublisher publisher = client.describePatchPropertiesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchProperties(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribePatchPropertiesRequest.Builder} avoiding
     * the need to create one manually via {@link DescribePatchPropertiesRequest#builder()}
     * </p>
     *
     * @param describePatchPropertiesRequest
     *        A {@link Consumer} that will call methods on {@link DescribePatchPropertiesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribePatchProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribePatchPropertiesPublisher describePatchPropertiesPaginator(
            Consumer<DescribePatchPropertiesRequest.Builder> describePatchPropertiesRequest) {
        return describePatchPropertiesPaginator(DescribePatchPropertiesRequest.builder()
                .applyMutation(describePatchPropertiesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30
     * days.
     * </p>
     *
     * @param describeSessionsRequest
     * @return A Java Future containing the result of the DescribeSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSessionsResponse> describeSessions(DescribeSessionsRequest describeSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30
     * days.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSessionsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSessionsRequest#builder()}
     * </p>
     *
     * @param describeSessionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSessionsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeSessions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSessionsResponse> describeSessions(
            Consumer<DescribeSessionsRequest.Builder> describeSessionsRequest) {
        return describeSessions(DescribeSessionsRequest.builder().applyMutation(describeSessionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30
     * days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeSessions(software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeSessionsPublisher publisher = client.describeSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeSessionsPublisher publisher = client.describeSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSessions(software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest)} operation.</b>
     * </p>
     *
     * @param describeSessionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSessionsPublisher describeSessionsPaginator(DescribeSessionsRequest describeSessionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30
     * days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeSessions(software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeSessionsPublisher publisher = client.describeSessionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeSessionsPublisher publisher = client.describeSessionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSessions(software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSessionsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSessionsRequest#builder()}
     * </p>
     *
     * @param describeSessionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSessionsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSessionsPublisher describeSessionsPaginator(Consumer<DescribeSessionsRequest.Builder> describeSessionsRequest) {
        return describeSessionsPaginator(DescribeSessionsRequest.builder().applyMutation(describeSessionsRequest).build());
    }

    /**
     * <p>
     * Get detailed information about a particular Automation execution.
     * </p>
     *
     * @param getAutomationExecutionRequest
     * @return A Java Future containing the result of the GetAutomationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetAutomationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAutomationExecutionResponse> getAutomationExecution(
            GetAutomationExecutionRequest getAutomationExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get detailed information about a particular Automation execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAutomationExecutionRequest.Builder} avoiding the
     * need to create one manually via {@link GetAutomationExecutionRequest#builder()}
     * </p>
     *
     * @param getAutomationExecutionRequest
     *        A {@link Consumer} that will call methods on {@link GetAutomationExecutionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAutomationExecution operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AutomationExecutionNotFoundException There is no automation execution information for the requested
     *         automation execution ID.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetAutomationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAutomationExecutionResponse> getAutomationExecution(
            Consumer<GetAutomationExecutionRequest.Builder> getAutomationExecutionRequest) {
        return getAutomationExecution(GetAutomationExecutionRequest.builder().applyMutation(getAutomationExecutionRequest)
                .build());
    }

    /**
     * <p>
     * Gets the state of the AWS Systems Manager Change Calendar at an optional, specified time. If you specify a time,
     * <code>GetCalendarState</code> returns the state of the calendar at a specific time, and returns the next time
     * that the Change Calendar state will transition. If you do not specify a time, <code>GetCalendarState</code>
     * assumes the current time. Change Calendar entries have two possible states: <code>OPEN</code> or
     * <code>CLOSED</code>.
     * </p>
     * <p>
     * If you specify more than one calendar in a request, the command returns the status of <code>OPEN</code> only if
     * all calendars in the request are open. If one or more calendars in the request are closed, the status returned is
     * <code>CLOSED</code>.
     * </p>
     * <p>
     * For more information about Systems Manager Change Calendar, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html">AWS
     * Systems Manager Change Calendar</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     *
     * @param getCalendarStateRequest
     * @return A Java Future containing the result of the GetCalendarState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentTypeException The document type is not valid. Valid document types are described in
     *         the <code>DocumentType</code> property.</li>
     *         <li>UnsupportedCalendarException The calendar entry contained in the specified Systems Manager document
     *         is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetCalendarState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCalendarState" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCalendarStateResponse> getCalendarState(GetCalendarStateRequest getCalendarStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the state of the AWS Systems Manager Change Calendar at an optional, specified time. If you specify a time,
     * <code>GetCalendarState</code> returns the state of the calendar at a specific time, and returns the next time
     * that the Change Calendar state will transition. If you do not specify a time, <code>GetCalendarState</code>
     * assumes the current time. Change Calendar entries have two possible states: <code>OPEN</code> or
     * <code>CLOSED</code>.
     * </p>
     * <p>
     * If you specify more than one calendar in a request, the command returns the status of <code>OPEN</code> only if
     * all calendars in the request are open. If one or more calendars in the request are closed, the status returned is
     * <code>CLOSED</code>.
     * </p>
     * <p>
     * For more information about Systems Manager Change Calendar, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html">AWS
     * Systems Manager Change Calendar</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCalendarStateRequest.Builder} avoiding the need
     * to create one manually via {@link GetCalendarStateRequest#builder()}
     * </p>
     *
     * @param getCalendarStateRequest
     *        A {@link Consumer} that will call methods on {@link GetCalendarStateRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetCalendarState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentTypeException The document type is not valid. Valid document types are described in
     *         the <code>DocumentType</code> property.</li>
     *         <li>UnsupportedCalendarException The calendar entry contained in the specified Systems Manager document
     *         is not supported.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetCalendarState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCalendarState" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCalendarStateResponse> getCalendarState(
            Consumer<GetCalendarStateRequest.Builder> getCalendarStateRequest) {
        return getCalendarState(GetCalendarStateRequest.builder().applyMutation(getCalendarStateRequest).build());
    }

    /**
     * <p>
     * Returns detailed information about command execution for an invocation or plugin.
     * </p>
     * <p>
     * <code>GetCommandInvocation</code> only gives the execution status of a plugin in a document. To get the command
     * execution status on a specific instance, use <a>ListCommandInvocations</a>. To get the command execution status
     * across instances, use <a>ListCommands</a>.
     * </p>
     *
     * @param getCommandInvocationRequest
     * @return A Java Future containing the result of the GetCommandInvocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidPluginNameException The plugin name is not valid.</li>
     *         <li>InvocationDoesNotExistException The command ID and instance ID you specified did not match any
     *         invocations. Verify the command ID and the instance ID and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetCommandInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCommandInvocationResponse> getCommandInvocation(
            GetCommandInvocationRequest getCommandInvocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about command execution for an invocation or plugin.
     * </p>
     * <p>
     * <code>GetCommandInvocation</code> only gives the execution status of a plugin in a document. To get the command
     * execution status on a specific instance, use <a>ListCommandInvocations</a>. To get the command execution status
     * across instances, use <a>ListCommands</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetCommandInvocationRequest.Builder} avoiding the
     * need to create one manually via {@link GetCommandInvocationRequest#builder()}
     * </p>
     *
     * @param getCommandInvocationRequest
     *        A {@link Consumer} that will call methods on {@link GetCommandInvocationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetCommandInvocation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidPluginNameException The plugin name is not valid.</li>
     *         <li>InvocationDoesNotExistException The command ID and instance ID you specified did not match any
     *         invocations. Verify the command ID and the instance ID and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetCommandInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetCommandInvocationResponse> getCommandInvocation(
            Consumer<GetCommandInvocationRequest.Builder> getCommandInvocationRequest) {
        return getCommandInvocation(GetCommandInvocationRequest.builder().applyMutation(getCommandInvocationRequest).build());
    }

    /**
     * <p>
     * Retrieves the Session Manager connection status for an instance to determine whether it is running and ready to
     * receive Session Manager connections.
     * </p>
     *
     * @param getConnectionStatusRequest
     * @return A Java Future containing the result of the GetConnectionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetConnectionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectionStatusResponse> getConnectionStatus(
            GetConnectionStatusRequest getConnectionStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the Session Manager connection status for an instance to determine whether it is running and ready to
     * receive Session Manager connections.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetConnectionStatusRequest.Builder} avoiding the
     * need to create one manually via {@link GetConnectionStatusRequest#builder()}
     * </p>
     *
     * @param getConnectionStatusRequest
     *        A {@link Consumer} that will call methods on {@link GetConnectionStatusRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetConnectionStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetConnectionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetConnectionStatusResponse> getConnectionStatus(
            Consumer<GetConnectionStatusRequest.Builder> getConnectionStatusRequest) {
        return getConnectionStatus(GetConnectionStatusRequest.builder().applyMutation(getConnectionStatusRequest).build());
    }

    /**
     * <p>
     * Retrieves the default patch baseline. Note that Systems Manager supports creating multiple default patch
     * baselines. For example, you can create a default patch baseline for each operating system.
     * </p>
     * <p>
     * If you do not specify an operating system value, the default patch baseline for Windows is returned.
     * </p>
     *
     * @param getDefaultPatchBaselineRequest
     * @return A Java Future containing the result of the GetDefaultPatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetDefaultPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDefaultPatchBaselineResponse> getDefaultPatchBaseline(
            GetDefaultPatchBaselineRequest getDefaultPatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the default patch baseline. Note that Systems Manager supports creating multiple default patch
     * baselines. For example, you can create a default patch baseline for each operating system.
     * </p>
     * <p>
     * If you do not specify an operating system value, the default patch baseline for Windows is returned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDefaultPatchBaselineRequest.Builder} avoiding
     * the need to create one manually via {@link GetDefaultPatchBaselineRequest#builder()}
     * </p>
     *
     * @param getDefaultPatchBaselineRequest
     *        A {@link Consumer} that will call methods on {@link GetDefaultPatchBaselineRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetDefaultPatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetDefaultPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDefaultPatchBaselineResponse> getDefaultPatchBaseline(
            Consumer<GetDefaultPatchBaselineRequest.Builder> getDefaultPatchBaselineRequest) {
        return getDefaultPatchBaseline(GetDefaultPatchBaselineRequest.builder().applyMutation(getDefaultPatchBaselineRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the default patch baseline. Note that Systems Manager supports creating multiple default patch
     * baselines. For example, you can create a default patch baseline for each operating system.
     * </p>
     * <p>
     * If you do not specify an operating system value, the default patch baseline for Windows is returned.
     * </p>
     *
     * @return A Java Future containing the result of the GetDefaultPatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetDefaultPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetDefaultPatchBaselineResponse> getDefaultPatchBaseline() {
        return getDefaultPatchBaseline(GetDefaultPatchBaselineRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves the current snapshot for the patch baseline the instance uses. This API is primarily used by the
     * AWS-RunPatchBaseline Systems Manager document.
     * </p>
     *
     * @param getDeployablePatchSnapshotForInstanceRequest
     * @return A Java Future containing the result of the GetDeployablePatchSnapshotForInstance operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified is not supported, or the
     *         operation is not supported for the operating system.</li>
     *         <li>UnsupportedFeatureRequiredException Microsoft application patching is only available on EC2 instances
     *         and advanced instances. To patch Microsoft applications on on-premises servers and VMs, you must enable
     *         advanced instances. For more information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances-advanced.html"
     *         >Using the advanced-instances tier</a> in the <i>AWS Systems Manager User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetDeployablePatchSnapshotForInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeployablePatchSnapshotForInstanceResponse> getDeployablePatchSnapshotForInstance(
            GetDeployablePatchSnapshotForInstanceRequest getDeployablePatchSnapshotForInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current snapshot for the patch baseline the instance uses. This API is primarily used by the
     * AWS-RunPatchBaseline Systems Manager document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetDeployablePatchSnapshotForInstanceRequest.Builder} avoiding the need to create one manually via
     * {@link GetDeployablePatchSnapshotForInstanceRequest#builder()}
     * </p>
     *
     * @param getDeployablePatchSnapshotForInstanceRequest
     *        A {@link Consumer} that will call methods on {@link GetDeployablePatchSnapshotForInstanceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetDeployablePatchSnapshotForInstance operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>UnsupportedOperatingSystemException The operating systems you specified is not supported, or the
     *         operation is not supported for the operating system.</li>
     *         <li>UnsupportedFeatureRequiredException Microsoft application patching is only available on EC2 instances
     *         and advanced instances. To patch Microsoft applications on on-premises servers and VMs, you must enable
     *         advanced instances. For more information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances-advanced.html"
     *         >Using the advanced-instances tier</a> in the <i>AWS Systems Manager User Guide</i>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetDeployablePatchSnapshotForInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetDeployablePatchSnapshotForInstanceResponse> getDeployablePatchSnapshotForInstance(
            Consumer<GetDeployablePatchSnapshotForInstanceRequest.Builder> getDeployablePatchSnapshotForInstanceRequest) {
        return getDeployablePatchSnapshotForInstance(GetDeployablePatchSnapshotForInstanceRequest.builder()
                .applyMutation(getDeployablePatchSnapshotForInstanceRequest).build());
    }

    /**
     * <p>
     * Gets the contents of the specified Systems Manager document.
     * </p>
     *
     * @param getDocumentRequest
     * @return A Java Future containing the result of the GetDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDocumentResponse> getDocument(GetDocumentRequest getDocumentRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the contents of the specified Systems Manager document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDocumentRequest.Builder} avoiding the need to
     * create one manually via {@link GetDocumentRequest#builder()}
     * </p>
     *
     * @param getDocumentRequest
     *        A {@link Consumer} that will call methods on {@link GetDocumentRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetDocument operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetDocumentResponse> getDocument(Consumer<GetDocumentRequest.Builder> getDocumentRequest) {
        return getDocument(GetDocumentRequest.builder().applyMutation(getDocumentRequest).build());
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     *
     * @param getInventoryRequest
     * @return A Java Future containing the result of the GetInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidInventoryGroupException The specified inventory group is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator is not valid for inventory groups. Verify that
     *         the aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>InvalidResultAttributeException The specified inventory item result attribute is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInventoryResponse> getInventory(GetInventoryRequest getInventoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInventoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetInventoryRequest#builder()}
     * </p>
     *
     * @param getInventoryRequest
     *        A {@link Consumer} that will call methods on {@link GetInventoryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidInventoryGroupException The specified inventory group is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator is not valid for inventory groups. Verify that
     *         the aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>InvalidResultAttributeException The specified inventory item result attribute is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInventoryResponse> getInventory(Consumer<GetInventoryRequest.Builder> getInventoryRequest) {
        return getInventory(GetInventoryRequest.builder().applyMutation(getInventoryRequest).build());
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     *
     * @return A Java Future containing the result of the GetInventory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidInventoryGroupException The specified inventory group is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator is not valid for inventory groups. Verify that
     *         the aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>InvalidResultAttributeException The specified inventory item result attribute is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInventoryResponse> getInventory() {
        return getInventory(GetInventoryRequest.builder().build());
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryPublisher publisher = client.getInventoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryPublisher publisher = client.getInventoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetInventoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetInventoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidInventoryGroupException The specified inventory group is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator is not valid for inventory groups. Verify that
     *         the aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>InvalidResultAttributeException The specified inventory item result attribute is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventoryPublisher getInventoryPaginator() {
        return getInventoryPaginator(GetInventoryRequest.builder().build());
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryPublisher publisher = client.getInventoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryPublisher publisher = client.getInventoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetInventoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetInventoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)} operation.</b>
     * </p>
     *
     * @param getInventoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidInventoryGroupException The specified inventory group is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator is not valid for inventory groups. Verify that
     *         the aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>InvalidResultAttributeException The specified inventory item result attribute is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventoryPublisher getInventoryPaginator(GetInventoryRequest getInventoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Query inventory information.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryPublisher publisher = client.getInventoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryPublisher publisher = client.getInventoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetInventoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetInventoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInventoryRequest.Builder} avoiding the need to
     * create one manually via {@link GetInventoryRequest#builder()}
     * </p>
     *
     * @param getInventoryRequest
     *        A {@link Consumer} that will call methods on {@link GetInventoryRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidInventoryGroupException The specified inventory group is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator is not valid for inventory groups. Verify that
     *         the aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>InvalidResultAttributeException The specified inventory item result attribute is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventoryPublisher getInventoryPaginator(Consumer<GetInventoryRequest.Builder> getInventoryRequest) {
        return getInventoryPaginator(GetInventoryRequest.builder().applyMutation(getInventoryRequest).build());
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     *
     * @param getInventorySchemaRequest
     * @return A Java Future containing the result of the GetInventorySchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInventorySchemaResponse> getInventorySchema(GetInventorySchemaRequest getInventorySchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInventorySchemaRequest.Builder} avoiding the
     * need to create one manually via {@link GetInventorySchemaRequest#builder()}
     * </p>
     *
     * @param getInventorySchemaRequest
     *        A {@link Consumer} that will call methods on {@link GetInventorySchemaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetInventorySchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInventorySchemaResponse> getInventorySchema(
            Consumer<GetInventorySchemaRequest.Builder> getInventorySchemaRequest) {
        return getInventorySchema(GetInventorySchemaRequest.builder().applyMutation(getInventorySchemaRequest).build());
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     *
     * @return A Java Future containing the result of the GetInventorySchema operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetInventorySchemaResponse> getInventorySchema() {
        return getInventorySchema(GetInventorySchemaRequest.builder().build());
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaPublisher publisher = client.getInventorySchemaPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaPublisher publisher = client.getInventorySchemaPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventorySchemaPublisher getInventorySchemaPaginator() {
        return getInventorySchemaPaginator(GetInventorySchemaRequest.builder().build());
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaPublisher publisher = client.getInventorySchemaPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaPublisher publisher = client.getInventorySchemaPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation.</b>
     * </p>
     *
     * @param getInventorySchemaRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventorySchemaPublisher getInventorySchemaPaginator(GetInventorySchemaRequest getInventorySchemaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaPublisher publisher = client.getInventorySchemaPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaPublisher publisher = client.getInventorySchemaPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetInventorySchemaRequest.Builder} avoiding the
     * need to create one manually via {@link GetInventorySchemaRequest#builder()}
     * </p>
     *
     * @param getInventorySchemaRequest
     *        A {@link Consumer} that will call methods on {@link GetInventorySchemaRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    default GetInventorySchemaPublisher getInventorySchemaPaginator(
            Consumer<GetInventorySchemaRequest.Builder> getInventorySchemaRequest) {
        return getInventorySchemaPaginator(GetInventorySchemaRequest.builder().applyMutation(getInventorySchemaRequest).build());
    }

    /**
     * <p>
     * Retrieves a maintenance window.
     * </p>
     *
     * @param getMaintenanceWindowRequest
     * @return A Java Future containing the result of the GetMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowResponse> getMaintenanceWindow(
            GetMaintenanceWindowRequest getMaintenanceWindowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMaintenanceWindowRequest.Builder} avoiding the
     * need to create one manually via {@link GetMaintenanceWindowRequest#builder()}
     * </p>
     *
     * @param getMaintenanceWindowRequest
     *        A {@link Consumer} that will call methods on {@link GetMaintenanceWindowRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMaintenanceWindow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowResponse> getMaintenanceWindow(
            Consumer<GetMaintenanceWindowRequest.Builder> getMaintenanceWindowRequest) {
        return getMaintenanceWindow(GetMaintenanceWindowRequest.builder().applyMutation(getMaintenanceWindowRequest).build());
    }

    /**
     * <p>
     * Retrieves details about a specific a maintenance window execution.
     * </p>
     *
     * @param getMaintenanceWindowExecutionRequest
     * @return A Java Future containing the result of the GetMaintenanceWindowExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowExecutionResponse> getMaintenanceWindowExecution(
            GetMaintenanceWindowExecutionRequest getMaintenanceWindowExecutionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about a specific a maintenance window execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMaintenanceWindowExecutionRequest.Builder}
     * avoiding the need to create one manually via {@link GetMaintenanceWindowExecutionRequest#builder()}
     * </p>
     *
     * @param getMaintenanceWindowExecutionRequest
     *        A {@link Consumer} that will call methods on {@link GetMaintenanceWindowExecutionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetMaintenanceWindowExecution operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowExecutionResponse> getMaintenanceWindowExecution(
            Consumer<GetMaintenanceWindowExecutionRequest.Builder> getMaintenanceWindowExecutionRequest) {
        return getMaintenanceWindowExecution(GetMaintenanceWindowExecutionRequest.builder()
                .applyMutation(getMaintenanceWindowExecutionRequest).build());
    }

    /**
     * <p>
     * Retrieves the details about a specific task run as part of a maintenance window execution.
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskRequest
     * @return A Java Future containing the result of the GetMaintenanceWindowExecutionTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindowExecutionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowExecutionTaskResponse> getMaintenanceWindowExecutionTask(
            GetMaintenanceWindowExecutionTaskRequest getMaintenanceWindowExecutionTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details about a specific task run as part of a maintenance window execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMaintenanceWindowExecutionTaskRequest.Builder}
     * avoiding the need to create one manually via {@link GetMaintenanceWindowExecutionTaskRequest#builder()}
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetMaintenanceWindowExecutionTaskRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetMaintenanceWindowExecutionTask operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindowExecutionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowExecutionTaskResponse> getMaintenanceWindowExecutionTask(
            Consumer<GetMaintenanceWindowExecutionTaskRequest.Builder> getMaintenanceWindowExecutionTaskRequest) {
        return getMaintenanceWindowExecutionTask(GetMaintenanceWindowExecutionTaskRequest.builder()
                .applyMutation(getMaintenanceWindowExecutionTaskRequest).build());
    }

    /**
     * <p>
     * Retrieves information about a specific task running on a specific target.
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskInvocationRequest
     * @return A Java Future containing the result of the GetMaintenanceWindowExecutionTaskInvocation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindowExecutionTaskInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowExecutionTaskInvocationResponse> getMaintenanceWindowExecutionTaskInvocation(
            GetMaintenanceWindowExecutionTaskInvocationRequest getMaintenanceWindowExecutionTaskInvocationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a specific task running on a specific target.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetMaintenanceWindowExecutionTaskInvocationRequest.Builder} avoiding the need to create one manually via
     * {@link GetMaintenanceWindowExecutionTaskInvocationRequest#builder()}
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskInvocationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link GetMaintenanceWindowExecutionTaskInvocationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetMaintenanceWindowExecutionTaskInvocation operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindowExecutionTaskInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowExecutionTaskInvocationResponse> getMaintenanceWindowExecutionTaskInvocation(
            Consumer<GetMaintenanceWindowExecutionTaskInvocationRequest.Builder> getMaintenanceWindowExecutionTaskInvocationRequest) {
        return getMaintenanceWindowExecutionTaskInvocation(GetMaintenanceWindowExecutionTaskInvocationRequest.builder()
                .applyMutation(getMaintenanceWindowExecutionTaskInvocationRequest).build());
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you cannot supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values do not affect the running of your task and can be
     * ignored.
     * </p>
     * </note>
     *
     * @param getMaintenanceWindowTaskRequest
     * @return A Java Future containing the result of the GetMaintenanceWindowTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindowTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowTaskResponse> getMaintenanceWindowTask(
            GetMaintenanceWindowTaskRequest getMaintenanceWindowTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you cannot supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values do not affect the running of your task and can be
     * ignored.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetMaintenanceWindowTaskRequest.Builder} avoiding
     * the need to create one manually via {@link GetMaintenanceWindowTaskRequest#builder()}
     * </p>
     *
     * @param getMaintenanceWindowTaskRequest
     *        A {@link Consumer} that will call methods on {@link GetMaintenanceWindowTaskRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetMaintenanceWindowTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetMaintenanceWindowTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowTask" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetMaintenanceWindowTaskResponse> getMaintenanceWindowTask(
            Consumer<GetMaintenanceWindowTaskRequest.Builder> getMaintenanceWindowTaskRequest) {
        return getMaintenanceWindowTask(GetMaintenanceWindowTaskRequest.builder().applyMutation(getMaintenanceWindowTaskRequest)
                .build());
    }

    /**
     * <p>
     * Get information about an OpsItem by using the ID. You must have permission in AWS Identity and Access Management
     * (IAM) to view information about an OpsItem. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     *
     * @param getOpsItemRequest
     * @return A Java Future containing the result of the GetOpsItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemNotFoundException The specified OpsItem ID doesn't exist. Verify the ID and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOpsItemResponse> getOpsItem(GetOpsItemRequest getOpsItemRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about an OpsItem by using the ID. You must have permission in AWS Identity and Access Management
     * (IAM) to view information about an OpsItem. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use OpsCenter to view, investigate, and remediate operational issues
     * impacting the performance and health of their AWS resources. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">AWS Systems Manager
     * OpsCenter</a> in the <i>AWS Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpsItemRequest.Builder} avoiding the need to
     * create one manually via {@link GetOpsItemRequest#builder()}
     * </p>
     *
     * @param getOpsItemRequest
     *        A {@link Consumer} that will call methods on {@link GetOpsItemRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOpsItem operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemNotFoundException The specified OpsItem ID doesn't exist. Verify the ID and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOpsItemResponse> getOpsItem(Consumer<GetOpsItemRequest.Builder> getOpsItemRequest) {
        return getOpsItem(GetOpsItemRequest.builder().applyMutation(getOpsItemRequest).build());
    }

    /**
     * <p>
     * View operational metadata related to an application in Application Manager.
     * </p>
     *
     * @param getOpsMetadataRequest
     * @return A Java Future containing the result of the GetOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataNotFoundException The OpsMetadata object does not exist.</li>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOpsMetadataResponse> getOpsMetadata(GetOpsMetadataRequest getOpsMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * View operational metadata related to an application in Application Manager.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpsMetadataRequest.Builder} avoiding the need to
     * create one manually via {@link GetOpsMetadataRequest#builder()}
     * </p>
     *
     * @param getOpsMetadataRequest
     *        A {@link Consumer} that will call methods on {@link GetOpsMetadataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataNotFoundException The OpsMetadata object does not exist.</li>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOpsMetadataResponse> getOpsMetadata(Consumer<GetOpsMetadataRequest.Builder> getOpsMetadataRequest) {
        return getOpsMetadata(GetOpsMetadataRequest.builder().applyMutation(getOpsMetadataRequest).build());
    }

    /**
     * <p>
     * View a summary of OpsItems based on specified filters and aggregators.
     * </p>
     *
     * @param getOpsSummaryRequest
     * @return A Java Future containing the result of the GetOpsSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncNotFoundException The specified sync name was not found.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator is not valid for inventory groups. Verify that
     *         the aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetOpsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOpsSummaryResponse> getOpsSummary(GetOpsSummaryRequest getOpsSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * View a summary of OpsItems based on specified filters and aggregators.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpsSummaryRequest.Builder} avoiding the need to
     * create one manually via {@link GetOpsSummaryRequest#builder()}
     * </p>
     *
     * @param getOpsSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetOpsSummaryRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetOpsSummary operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncNotFoundException The specified sync name was not found.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator is not valid for inventory groups. Verify that
     *         the aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetOpsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetOpsSummaryResponse> getOpsSummary(Consumer<GetOpsSummaryRequest.Builder> getOpsSummaryRequest) {
        return getOpsSummary(GetOpsSummaryRequest.builder().applyMutation(getOpsSummaryRequest).build());
    }

    /**
     * <p>
     * View a summary of OpsItems based on specified filters and aggregators.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getOpsSummary(software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryPublisher publisher = client.getOpsSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryPublisher publisher = client.getOpsSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOpsSummary(software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest)} operation.</b>
     * </p>
     *
     * @param getOpsSummaryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncNotFoundException The specified sync name was not found.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator is not valid for inventory groups. Verify that
     *         the aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetOpsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOpsSummaryPublisher getOpsSummaryPaginator(GetOpsSummaryRequest getOpsSummaryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * View a summary of OpsItems based on specified filters and aggregators.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getOpsSummary(software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryPublisher publisher = client.getOpsSummaryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryPublisher publisher = client.getOpsSummaryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOpsSummary(software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpsSummaryRequest.Builder} avoiding the need to
     * create one manually via {@link GetOpsSummaryRequest#builder()}
     * </p>
     *
     * @param getOpsSummaryRequest
     *        A {@link Consumer} that will call methods on {@link GetOpsSummaryRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ResourceDataSyncNotFoundException The specified sync name was not found.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidAggregatorException The specified aggregator is not valid for inventory groups. Verify that
     *         the aggregator uses a valid inventory type such as <code>AWS:Application</code> or
     *         <code>AWS:InstanceInformation</code>.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetOpsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary" target="_top">AWS API
     *      Documentation</a>
     */
    default GetOpsSummaryPublisher getOpsSummaryPaginator(Consumer<GetOpsSummaryRequest.Builder> getOpsSummaryRequest) {
        return getOpsSummaryPaginator(GetOpsSummaryRequest.builder().applyMutation(getOpsSummaryRequest).build());
    }

    /**
     * <p>
     * Get information about a parameter by using the parameter name. Don't confuse this API action with the
     * <a>GetParameters</a> API action.
     * </p>
     *
     * @param getParameterRequest
     * @return A Java Future containing the result of the GetParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>ParameterVersionNotFoundException The specified parameter version was not found. Verify the parameter
     *         name and version, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParameterResponse> getParameter(GetParameterRequest getParameterRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get information about a parameter by using the parameter name. Don't confuse this API action with the
     * <a>GetParameters</a> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParameterRequest.Builder} avoiding the need to
     * create one manually via {@link GetParameterRequest#builder()}
     * </p>
     *
     * @param getParameterRequest
     *        A {@link Consumer} that will call methods on {@link GetParameterRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetParameter operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>ParameterVersionNotFoundException The specified parameter version was not found. Verify the parameter
     *         name and version, and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParameterResponse> getParameter(Consumer<GetParameterRequest.Builder> getParameterRequest) {
        return getParameter(GetParameterRequest.builder().applyMutation(getParameterRequest).build());
    }

    /**
     * <p>
     * Retrieves the history of all changes to a parameter.
     * </p>
     *
     * @param getParameterHistoryRequest
     * @return A Java Future containing the result of the GetParameterHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParameterHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParameterHistoryResponse> getParameterHistory(
            GetParameterHistoryRequest getParameterHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the history of all changes to a parameter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParameterHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link GetParameterHistoryRequest#builder()}
     * </p>
     *
     * @param getParameterHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetParameterHistoryRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetParameterHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParameterHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParameterHistoryResponse> getParameterHistory(
            Consumer<GetParameterHistoryRequest.Builder> getParameterHistoryRequest) {
        return getParameterHistory(GetParameterHistoryRequest.builder().applyMutation(getParameterHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the history of all changes to a parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getParameterHistory(software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryPublisher publisher = client.getParameterHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryPublisher publisher = client.getParameterHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getParameterHistory(software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest)} operation.</b>
     * </p>
     *
     * @param getParameterHistoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParameterHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParameterHistoryPublisher getParameterHistoryPaginator(GetParameterHistoryRequest getParameterHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the history of all changes to a parameter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getParameterHistory(software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryPublisher publisher = client.getParameterHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryPublisher publisher = client.getParameterHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getParameterHistory(software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParameterHistoryRequest.Builder} avoiding the
     * need to create one manually via {@link GetParameterHistoryRequest#builder()}
     * </p>
     *
     * @param getParameterHistoryRequest
     *        A {@link Consumer} that will call methods on {@link GetParameterHistoryRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParameterHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParameterHistoryPublisher getParameterHistoryPaginator(
            Consumer<GetParameterHistoryRequest.Builder> getParameterHistoryRequest) {
        return getParameterHistoryPaginator(GetParameterHistoryRequest.builder().applyMutation(getParameterHistoryRequest)
                .build());
    }

    /**
     * <p>
     * Get details of a parameter. Don't confuse this API action with the <a>GetParameter</a> API action.
     * </p>
     *
     * @param getParametersRequest
     * @return A Java Future containing the result of the GetParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParametersResponse> getParameters(GetParametersRequest getParametersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get details of a parameter. Don't confuse this API action with the <a>GetParameter</a> API action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParametersRequest.Builder} avoiding the need to
     * create one manually via {@link GetParametersRequest#builder()}
     * </p>
     *
     * @param getParametersRequest
     *        A {@link Consumer} that will call methods on {@link GetParametersRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetParameters operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParametersResponse> getParameters(Consumer<GetParametersRequest.Builder> getParametersRequest) {
        return getParameters(GetParametersRequest.builder().applyMutation(getParametersRequest).build());
    }

    /**
     * <p>
     * Retrieve information about one or more parameters in a specific hierarchy.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note>
     *
     * @param getParametersByPathRequest
     * @return A Java Future containing the result of the GetParametersByPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParametersByPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParametersByPathResponse> getParametersByPath(
            GetParametersByPathRequest getParametersByPathRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve information about one or more parameters in a specific hierarchy.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParametersByPathRequest.Builder} avoiding the
     * need to create one manually via {@link GetParametersByPathRequest#builder()}
     * </p>
     *
     * @param getParametersByPathRequest
     *        A {@link Consumer} that will call methods on {@link GetParametersByPathRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetParametersByPath operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParametersByPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetParametersByPathResponse> getParametersByPath(
            Consumer<GetParametersByPathRequest.Builder> getParametersByPathRequest) {
        return getParametersByPath(GetParametersByPathRequest.builder().applyMutation(getParametersByPathRequest).build());
    }

    /**
     * <p>
     * Retrieve information about one or more parameters in a specific hierarchy.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getParametersByPath(software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParametersByPathPublisher publisher = client.getParametersByPathPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParametersByPathPublisher publisher = client.getParametersByPathPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getParametersByPath(software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest)} operation.</b>
     * </p>
     *
     * @param getParametersByPathRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParametersByPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParametersByPathPublisher getParametersByPathPaginator(GetParametersByPathRequest getParametersByPathRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieve information about one or more parameters in a specific hierarchy.
     * </p>
     * <note>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #getParametersByPath(software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParametersByPathPublisher publisher = client.getParametersByPathPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParametersByPathPublisher publisher = client.getParametersByPathPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getParametersByPath(software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link GetParametersByPathRequest.Builder} avoiding the
     * need to create one manually via {@link GetParametersByPathRequest#builder()}
     * </p>
     *
     * @param getParametersByPathRequest
     *        A {@link Consumer} that will call methods on {@link GetParametersByPathRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidFilterOptionException The specified filter option is not valid. Valid options are Equals and
     *         BeginsWith. For Path filter, valid options are Recursive and OneLevel.</li>
     *         <li>InvalidFilterValueException The filter value is not valid. Verify the value and try again.</li>
     *         <li>InvalidKeyIdException The query key ID is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetParametersByPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    default GetParametersByPathPublisher getParametersByPathPaginator(
            Consumer<GetParametersByPathRequest.Builder> getParametersByPathRequest) {
        return getParametersByPathPaginator(GetParametersByPathRequest.builder().applyMutation(getParametersByPathRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves information about a patch baseline.
     * </p>
     *
     * @param getPatchBaselineRequest
     * @return A Java Future containing the result of the GetPatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPatchBaselineResponse> getPatchBaseline(GetPatchBaselineRequest getPatchBaselineRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPatchBaselineRequest.Builder} avoiding the need
     * to create one manually via {@link GetPatchBaselineRequest#builder()}
     * </p>
     *
     * @param getPatchBaselineRequest
     *        A {@link Consumer} that will call methods on {@link GetPatchBaselineRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetPatchBaseline operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DoesNotExistException Error returned when the ID specified for a resource, such as a maintenance
     *         window or Patch baseline, doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>AWS General Reference</i>.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetPatchBaselineResponse> getPatchBaseline(
            Consumer<GetPatchBaselineRequest.Builder> getPatchBaselineRequest) {
        return getPatchBaseline(GetPatchBaselineRequest.builder().applyMutation(getPatchBaselineRequest).build());
    }

    /**
     * <p>
     * Retrieves the patch baseline that should be used for the specified patch group.
     * </p>
     *
     * @param getPatchBaselineForPatchGroupRequest
     * @return A Java Future containing the result of the GetPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPatchBaselineForPatchGroupResponse> getPatchBaselineForPatchGroup(
            GetPatchBaselineForPatchGroupRequest getPatchBaselineForPatchGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the patch baseline that should be used for the specified patch group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPatchBaselineForPatchGroupRequest.Builder}
     * avoiding the need to create one manually via {@link GetPatchBaselineForPatchGroupRequest#builder()}
     * </p>
     *
     * @param getPatchBaselineForPatchGroupRequest
     *        A {@link Consumer} that will call methods on {@link GetPatchBaselineForPatchGroupRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetPatchBaselineForPatchGroup operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPatchBaselineForPatchGroupResponse> getPatchBaselineForPatchGroup(
            Consumer<GetPatchBaselineForPatchGroupRequest.Builder> getPatchBaselineForPatchGroupRequest) {
        return getPatchBaselineForPatchGroup(GetPatchBaselineForPatchGroupRequest.builder()
                .applyMutation(getPatchBaselineForPatchGroupRequest).build());
    }

    /**
     * <p>
     * <code>ServiceSetting</code> is an account-level setting for an AWS service. This setting defines how a user
     * interacts with or uses a service or a feature of a service. For example, if an AWS service charges money to the
     * account based on feature or service usage, then the AWS service team might create a default setting of "false".
     * This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for
     * a paid feature.
     * </p>
     * <p>
     * Services map a <code>SettingId</code> object to a setting value. AWS services teams define the default value for
     * a <code>SettingId</code>. You can't create a new <code>SettingId</code>, but you can overwrite the default value
     * if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the
     * <a>UpdateServiceSetting</a> API action to change the default setting. Or use the <a>ResetServiceSetting</a> to
     * change the value back to the original value defined by the AWS service team.
     * </p>
     * <p>
     * Query the current service setting for the account.
     * </p>
     *
     * @param getServiceSettingRequest
     *        The request body of the GetServiceSetting API action.
     * @return A Java Future containing the result of the GetServiceSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ServiceSettingNotFoundException The specified service setting was not found. Either the service name
     *         or the setting has not been provisioned by the AWS service team.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetServiceSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSetting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServiceSettingResponse> getServiceSetting(GetServiceSettingRequest getServiceSettingRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * <code>ServiceSetting</code> is an account-level setting for an AWS service. This setting defines how a user
     * interacts with or uses a service or a feature of a service. For example, if an AWS service charges money to the
     * account based on feature or service usage, then the AWS service team might create a default setting of "false".
     * This means the user can't use this feature unless they change the setting to "true" and intentionally opt in for
     * a paid feature.
     * </p>
     * <p>
     * Services map a <code>SettingId</code> object to a setting value. AWS services teams define the default value for
     * a <code>SettingId</code>. You can't create a new <code>SettingId</code>, but you can overwrite the default value
     * if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the
     * <a>UpdateServiceSetting</a> API action to change the default setting. Or use the <a>ResetServiceSetting</a> to
     * change the value back to the original value defined by the AWS service team.
     * </p>
     * <p>
     * Query the current service setting for the account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceSettingRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceSettingRequest#builder()}
     * </p>
     *
     * @param getServiceSettingRequest
     *        A {@link Consumer} that will call methods on {@link GetServiceSettingRequest.Builder} to create a request.
     *        The request body of the GetServiceSetting API action.
     * @return A Java Future containing the result of the GetServiceSetting operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>ServiceSettingNotFoundException The specified service setting was not found. Either the service name
     *         or the setting has not been provisioned by the AWS service team.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.GetServiceSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSetting" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetServiceSettingResponse> getServiceSetting(
            Consumer<GetServiceSettingRequest.Builder> getServiceSettingRequest) {
        return getServiceSetting(GetServiceSettingRequest.builder().applyMutation(getServiceSettingRequest).build());
    }

    /**
     * <p>
     * A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a
     * parameter, Systems Manager automatically saves a new version and increments the version number by one. A label
     * can help you remember the purpose of a parameter when there are multiple versions.
     * </p>
     * <p>
     * Parameter labels have the following requirements and restrictions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A version of a parameter can have a maximum of 10 labels.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't attach the same label to different versions of the same parameter. For example, if version 1 has the
     * label Production, then you can't attach Production to version 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can move a label from one version of a parameter to another.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't create a label when you create a new parameter. You must attach a label to a specific version of a
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you no longer want to use a parameter label, then you can either delete it or move it to a different version
     * of a parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A label can have a maximum of 100 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or underscores (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Labels can't begin with a number, "aws," or "ssm" (not case sensitive). If a label fails to meet these
     * requirements, then the label is not associated with a parameter and the system displays it in the list of
     * InvalidLabels.
     * </p>
     * </li>
     * </ul>
     *
     * @param labelParameterVersionRequest
     * @return A Java Future containing the result of the LabelParameterVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>ParameterVersionNotFoundException The specified parameter version was not found. Verify the parameter
     *         name and version, and try again.</li>
     *         <li>ParameterVersionLabelLimitExceededException A parameter version can have a maximum of ten labels.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.LabelParameterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/LabelParameterVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<LabelParameterVersionResponse> labelParameterVersion(
            LabelParameterVersionRequest labelParameterVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a
     * parameter, Systems Manager automatically saves a new version and increments the version number by one. A label
     * can help you remember the purpose of a parameter when there are multiple versions.
     * </p>
     * <p>
     * Parameter labels have the following requirements and restrictions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A version of a parameter can have a maximum of 10 labels.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't attach the same label to different versions of the same parameter. For example, if version 1 has the
     * label Production, then you can't attach Production to version 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can move a label from one version of a parameter to another.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't create a label when you create a new parameter. You must attach a label to a specific version of a
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you no longer want to use a parameter label, then you can either delete it or move it to a different version
     * of a parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A label can have a maximum of 100 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or underscores (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Labels can't begin with a number, "aws," or "ssm" (not case sensitive). If a label fails to meet these
     * requirements, then the label is not associated with a parameter and the system displays it in the list of
     * InvalidLabels.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link LabelParameterVersionRequest.Builder} avoiding the
     * need to create one manually via {@link LabelParameterVersionRequest#builder()}
     * </p>
     *
     * @param labelParameterVersionRequest
     *        A {@link Consumer} that will call methods on {@link LabelParameterVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the LabelParameterVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>TooManyUpdatesException There are concurrent updates for a resource that supports one update at a
     *         time.</li>
     *         <li>ParameterNotFoundException The parameter could not be found. Verify the name and try again.</li>
     *         <li>ParameterVersionNotFoundException The specified parameter version was not found. Verify the parameter
     *         name and version, and try again.</li>
     *         <li>ParameterVersionLabelLimitExceededException A parameter version can have a maximum of ten labels.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.LabelParameterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/LabelParameterVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<LabelParameterVersionResponse> labelParameterVersion(
            Consumer<LabelParameterVersionRequest.Builder> labelParameterVersionRequest) {
        return labelParameterVersion(LabelParameterVersionRequest.builder().applyMutation(labelParameterVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     *
     * @param listAssociationVersionsRequest
     * @return A Java Future containing the result of the ListAssociationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssociationVersionsResponse> listAssociationVersions(
            ListAssociationVersionsRequest listAssociationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssociationVersionsRequest#builder()}
     * </p>
     *
     * @param listAssociationVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociationVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAssociationVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAssociationVersionsResponse> listAssociationVersions(
            Consumer<ListAssociationVersionsRequest.Builder> listAssociationVersionsRequest) {
        return listAssociationVersions(ListAssociationVersionsRequest.builder().applyMutation(listAssociationVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociationVersions(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsPublisher publisher = client.listAssociationVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsPublisher publisher = client.listAssociationVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociationVersions(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociationVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociationVersionsPublisher listAssociationVersionsPaginator(
            ListAssociationVersionsRequest listAssociationVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociationVersions(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsPublisher publisher = client.listAssociationVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsPublisher publisher = client.listAssociationVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociationVersions(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociationVersionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAssociationVersionsRequest#builder()}
     * </p>
     *
     * @param listAssociationVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociationVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>AssociationDoesNotExistException The specified association does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAssociationVersionsPublisher listAssociationVersionsPaginator(
            Consumer<ListAssociationVersionsRequest.Builder> listAssociationVersionsRequest) {
        return listAssociationVersionsPaginator(ListAssociationVersionsRequest.builder()
                .applyMutation(listAssociationVersionsRequest).build());
    }

    /**
     * <p>
     * Returns all State Manager associations in the current AWS account and Region. You can limit the results to a
     * specific State Manager association document or instance by specifying a filter.
     * </p>
     *
     * @param listAssociationsRequest
     * @return A Java Future containing the result of the ListAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssociationsResponse> listAssociations(ListAssociationsRequest listAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all State Manager associations in the current AWS account and Region. You can limit the results to a
     * specific State Manager association document or instance by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssociationsRequest#builder()}
     * </p>
     *
     * @param listAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssociationsResponse> listAssociations(
            Consumer<ListAssociationsRequest.Builder> listAssociationsRequest) {
        return listAssociations(ListAssociationsRequest.builder().applyMutation(listAssociationsRequest).build());
    }

    /**
     * <p>
     * Returns all State Manager associations in the current AWS account and Region. You can limit the results to a
     * specific State Manager association document or instance by specifying a filter.
     * </p>
     *
     * @return A Java Future containing the result of the ListAssociations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListAssociationsResponse> listAssociations() {
        return listAssociations(ListAssociationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns all State Manager associations in the current AWS account and Region. You can limit the results to a
     * specific State Manager association document or instance by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsPublisher publisher = client.listAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsPublisher publisher = client.listAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssociationsPublisher listAssociationsPaginator() {
        return listAssociationsPaginator(ListAssociationsRequest.builder().build());
    }

    /**
     * <p>
     * Returns all State Manager associations in the current AWS account and Region. You can limit the results to a
     * specific State Manager association document or instance by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsPublisher publisher = client.listAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsPublisher publisher = client.listAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)} operation.</b>
     * </p>
     *
     * @param listAssociationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssociationsPublisher listAssociationsPaginator(ListAssociationsRequest listAssociationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all State Manager associations in the current AWS account and Region. You can limit the results to a
     * specific State Manager association document or instance by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsPublisher publisher = client.listAssociationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsPublisher publisher = client.listAssociationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListAssociationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListAssociationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListAssociationsRequest#builder()}
     * </p>
     *
     * @param listAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    default ListAssociationsPublisher listAssociationsPaginator(Consumer<ListAssociationsRequest.Builder> listAssociationsRequest) {
        return listAssociationsPaginator(ListAssociationsRequest.builder().applyMutation(listAssociationsRequest).build());
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then
     * a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     *
     * @param listCommandInvocationsRequest
     * @return A Java Future containing the result of the ListCommandInvocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCommandInvocationsResponse> listCommandInvocations(
            ListCommandInvocationsRequest listCommandInvocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then
     * a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCommandInvocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCommandInvocationsRequest#builder()}
     * </p>
     *
     * @param listCommandInvocationsRequest
     *        A {@link Consumer} that will call methods on {@link ListCommandInvocationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListCommandInvocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCommandInvocationsResponse> listCommandInvocations(
            Consumer<ListCommandInvocationsRequest.Builder> listCommandInvocationsRequest) {
        return listCommandInvocations(ListCommandInvocationsRequest.builder().applyMutation(listCommandInvocationsRequest)
                .build());
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then
     * a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     *
     * @return A Java Future containing the result of the ListCommandInvocations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListCommandInvocationsResponse> listCommandInvocations() {
        return listCommandInvocations(ListCommandInvocationsRequest.builder().build());
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then
     * a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsPublisher publisher = client.listCommandInvocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsPublisher publisher = client.listCommandInvocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCommandInvocationsPublisher listCommandInvocationsPaginator() {
        return listCommandInvocationsPaginator(ListCommandInvocationsRequest.builder().build());
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then
     * a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsPublisher publisher = client.listCommandInvocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsPublisher publisher = client.listCommandInvocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCommandInvocationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCommandInvocationsPublisher listCommandInvocationsPaginator(
            ListCommandInvocationsRequest listCommandInvocationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific instance. A command can apply to one or more instances. A
     * command invocation applies to one instance. For example, if a user runs SendCommand against three instances, then
     * a command invocation is created for each requested instance ID. ListCommandInvocations provide status about
     * command execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsPublisher publisher = client.listCommandInvocationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsPublisher publisher = client.listCommandInvocationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCommandInvocationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListCommandInvocationsRequest#builder()}
     * </p>
     *
     * @param listCommandInvocationsRequest
     *        A {@link Consumer} that will call methods on {@link ListCommandInvocationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    default ListCommandInvocationsPublisher listCommandInvocationsPaginator(
            Consumer<ListCommandInvocationsRequest.Builder> listCommandInvocationsRequest) {
        return listCommandInvocationsPaginator(ListCommandInvocationsRequest.builder()
                .applyMutation(listCommandInvocationsRequest).build());
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     *
     * @param listCommandsRequest
     * @return A Java Future containing the result of the ListCommands operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCommandsResponse> listCommands(ListCommandsRequest listCommandsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCommandsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCommandsRequest#builder()}
     * </p>
     *
     * @param listCommandsRequest
     *        A {@link Consumer} that will call methods on {@link ListCommandsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListCommands operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCommandsResponse> listCommands(Consumer<ListCommandsRequest.Builder> listCommandsRequest) {
        return listCommands(ListCommandsRequest.builder().applyMutation(listCommandsRequest).build());
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListCommands operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListCommandsResponse> listCommands() {
        return listCommands(ListCommandsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsPublisher publisher = client.listCommandsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsPublisher publisher = client.listCommandsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListCommandsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListCommandsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommandsPublisher listCommandsPaginator() {
        return listCommandsPaginator(ListCommandsRequest.builder().build());
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsPublisher publisher = client.listCommandsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsPublisher publisher = client.listCommandsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListCommandsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListCommandsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)} operation.</b>
     * </p>
     *
     * @param listCommandsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommandsPublisher listCommandsPaginator(ListCommandsRequest listCommandsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the commands requested by users of the AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsPublisher publisher = client.listCommandsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsPublisher publisher = client.listCommandsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListCommandsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListCommandsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCommandsRequest.Builder} avoiding the need to
     * create one manually via {@link ListCommandsRequest#builder()}
     * </p>
     *
     * @param listCommandsRequest
     *        A {@link Consumer} that will call methods on {@link ListCommandsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidCommandIdException</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    default ListCommandsPublisher listCommandsPaginator(Consumer<ListCommandsRequest.Builder> listCommandsRequest) {
        return listCommandsPaginator(ListCommandsRequest.builder().applyMutation(listCommandsRequest).build());
    }

    /**
     * <p>
     * For a specified resource ID, this API action returns a list of compliance statuses for different resource types.
     * Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the
     * filter.
     * </p>
     *
     * @param listComplianceItemsRequest
     * @return A Java Future containing the result of the ListComplianceItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListComplianceItemsResponse> listComplianceItems(
            ListComplianceItemsRequest listComplianceItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a specified resource ID, this API action returns a list of compliance statuses for different resource types.
     * Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the
     * filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComplianceItemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListComplianceItemsRequest#builder()}
     * </p>
     *
     * @param listComplianceItemsRequest
     *        A {@link Consumer} that will call methods on {@link ListComplianceItemsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListComplianceItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListComplianceItemsResponse> listComplianceItems(
            Consumer<ListComplianceItemsRequest.Builder> listComplianceItemsRequest) {
        return listComplianceItems(ListComplianceItemsRequest.builder().applyMutation(listComplianceItemsRequest).build());
    }

    /**
     * <p>
     * For a specified resource ID, this API action returns a list of compliance statuses for different resource types.
     * Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the
     * filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceItems(software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsPublisher publisher = client.listComplianceItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsPublisher publisher = client.listComplianceItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceItems(software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest)} operation.</b>
     * </p>
     *
     * @param listComplianceItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComplianceItemsPublisher listComplianceItemsPaginator(ListComplianceItemsRequest listComplianceItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * For a specified resource ID, this API action returns a list of compliance statuses for different resource types.
     * Currently, you can only specify one resource ID per call. List results depend on the criteria specified in the
     * filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceItems(software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsPublisher publisher = client.listComplianceItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsPublisher publisher = client.listComplianceItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceItems(software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComplianceItemsRequest.Builder} avoiding the
     * need to create one manually via {@link ListComplianceItemsRequest#builder()}
     * </p>
     *
     * @param listComplianceItemsRequest
     *        A {@link Consumer} that will call methods on {@link ListComplianceItemsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidResourceTypeException The resource type is not valid. For example, if you are attempting to
     *         tag an instance, the instance must be a registered, managed instance.</li>
     *         <li>InvalidResourceIdException The resource ID is not valid. Verify that you entered the correct ID and
     *         try again.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    default ListComplianceItemsPublisher listComplianceItemsPaginator(
            Consumer<ListComplianceItemsRequest.Builder> listComplianceItemsRequest) {
        return listComplianceItemsPaginator(ListComplianceItemsRequest.builder().applyMutation(listComplianceItemsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     *
     * @param listComplianceSummariesRequest
     * @return A Java Future containing the result of the ListComplianceSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComplianceSummariesResponse> listComplianceSummaries(
            ListComplianceSummariesRequest listComplianceSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComplianceSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListComplianceSummariesRequest#builder()}
     * </p>
     *
     * @param listComplianceSummariesRequest
     *        A {@link Consumer} that will call methods on {@link ListComplianceSummariesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListComplianceSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComplianceSummariesResponse> listComplianceSummaries(
            Consumer<ListComplianceSummariesRequest.Builder> listComplianceSummariesRequest) {
        return listComplianceSummaries(ListComplianceSummariesRequest.builder().applyMutation(listComplianceSummariesRequest)
                .build());
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     *
     * @return A Java Future containing the result of the ListComplianceSummaries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListComplianceSummariesResponse> listComplianceSummaries() {
        return listComplianceSummaries(ListComplianceSummariesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesPublisher publisher = client.listComplianceSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesPublisher publisher = client.listComplianceSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComplianceSummariesPublisher listComplianceSummariesPaginator() {
        return listComplianceSummariesPaginator(ListComplianceSummariesRequest.builder().build());
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesPublisher publisher = client.listComplianceSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesPublisher publisher = client.listComplianceSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComplianceSummariesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComplianceSummariesPublisher listComplianceSummariesPaginator(
            ListComplianceSummariesRequest listComplianceSummariesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesPublisher publisher = client.listComplianceSummariesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesPublisher publisher = client.listComplianceSummariesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListComplianceSummariesRequest.Builder} avoiding
     * the need to create one manually via {@link ListComplianceSummariesRequest#builder()}
     * </p>
     *
     * @param listComplianceSummariesRequest
     *        A {@link Consumer} that will call methods on {@link ListComplianceSummariesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    default ListComplianceSummariesPublisher listComplianceSummariesPaginator(
            Consumer<ListComplianceSummariesRequest.Builder> listComplianceSummariesRequest) {
        return listComplianceSummariesPaginator(ListComplianceSummariesRequest.builder()
                .applyMutation(listComplianceSummariesRequest).build());
    }

    /**
     * <p>
     * Information about approval reviews for a version of an SSM document.
     * </p>
     *
     * @param listDocumentMetadataHistoryRequest
     * @return A Java Future containing the result of the ListDocumentMetadataHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocumentMetadataHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentMetadataHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDocumentMetadataHistoryResponse> listDocumentMetadataHistory(
            ListDocumentMetadataHistoryRequest listDocumentMetadataHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Information about approval reviews for a version of an SSM document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentMetadataHistoryRequest.Builder}
     * avoiding the need to create one manually via {@link ListDocumentMetadataHistoryRequest#builder()}
     * </p>
     *
     * @param listDocumentMetadataHistoryRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentMetadataHistoryRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the ListDocumentMetadataHistory operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>InvalidDocumentVersionException The document version is not valid or does not exist.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocumentMetadataHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentMetadataHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListDocumentMetadataHistoryResponse> listDocumentMetadataHistory(
            Consumer<ListDocumentMetadataHistoryRequest.Builder> listDocumentMetadataHistoryRequest) {
        return listDocumentMetadataHistory(ListDocumentMetadataHistoryRequest.builder()
                .applyMutation(listDocumentMetadataHistoryRequest).build());
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     *
     * @param listDocumentVersionsRequest
     * @return A Java Future containing the result of the ListDocumentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDocumentVersionsResponse> listDocumentVersions(
            ListDocumentVersionsRequest listDocumentVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDocumentVersionsRequest#builder()}
     * </p>
     *
     * @param listDocumentVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListDocumentVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDocumentVersionsResponse> listDocumentVersions(
            Consumer<ListDocumentVersionsRequest.Builder> listDocumentVersionsRequest) {
        return listDocumentVersions(ListDocumentVersionsRequest.builder().applyMutation(listDocumentVersionsRequest).build());
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentVersions(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsPublisher publisher = client.listDocumentVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsPublisher publisher = client.listDocumentVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentVersions(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentVersionsPublisher listDocumentVersionsPaginator(ListDocumentVersionsRequest listDocumentVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentVersions(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsPublisher publisher = client.listDocumentVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsPublisher publisher = client.listDocumentVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentVersions(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListDocumentVersionsRequest#builder()}
     * </p>
     *
     * @param listDocumentVersionsRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidDocumentException The specified document does not exist.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentVersionsPublisher listDocumentVersionsPaginator(
            Consumer<ListDocumentVersionsRequest.Builder> listDocumentVersionsRequest) {
        return listDocumentVersionsPaginator(ListDocumentVersionsRequest.builder().applyMutation(listDocumentVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of
     * this request by using a filter.
     * </p>
     *
     * @param listDocumentsRequest
     * @return A Java Future containing the result of the ListDocuments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDocumentsResponse> listDocuments(ListDocumentsRequest listDocumentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of
     * this request by using a filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDocumentsRequest#builder()}
     * </p>
     *
     * @param listDocumentsRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListDocuments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDocumentsResponse> listDocuments(Consumer<ListDocumentsRequest.Builder> listDocumentsRequest) {
        return listDocuments(ListDocumentsRequest.builder().applyMutation(listDocumentsRequest).build());
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of
     * this request by using a filter.
     * </p>
     *
     * @return A Java Future containing the result of the ListDocuments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListDocumentsResponse> listDocuments() {
        return listDocuments(ListDocumentsRequest.builder().build());
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of
     * this request by using a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsPublisher publisher = client.listDocumentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsPublisher publisher = client.listDocumentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListDocumentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListDocumentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)} operation.</b>
     * </p>
     *
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsPublisher listDocumentsPaginator() {
        return listDocumentsPaginator(ListDocumentsRequest.builder().build());
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of
     * this request by using a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsPublisher publisher = client.listDocumentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsPublisher publisher = client.listDocumentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListDocumentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListDocumentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)} operation.</b>
     * </p>
     *
     * @param listDocumentsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsPublisher listDocumentsPaginator(ListDocumentsRequest listDocumentsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current AWS account and Region. You can limit the results of
     * this request by using a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsPublisher publisher = client.listDocumentsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsPublisher publisher = client.listDocumentsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListDocumentsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListDocumentsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDocumentsRequest.Builder} avoiding the need to
     * create one manually via {@link ListDocumentsRequest#builder()}
     * </p>
     *
     * @param listDocumentsRequest
     *        A {@link Consumer} that will call methods on {@link ListDocumentsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>InvalidFilterKeyException The specified key is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDocumentsPublisher listDocumentsPaginator(Consumer<ListDocumentsRequest.Builder> listDocumentsRequest) {
        return listDocumentsPaginator(ListDocumentsRequest.builder().applyMutation(listDocumentsRequest).build());
    }

    /**
     * <p>
     * A list of inventory items returned by the request.
     * </p>
     *
     * @param listInventoryEntriesRequest
     * @return A Java Future containing the result of the ListInventoryEntries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListInventoryEntries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInventoryEntriesResponse> listInventoryEntries(
            ListInventoryEntriesRequest listInventoryEntriesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * A list of inventory items returned by the request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListInventoryEntriesRequest.Builder} avoiding the
     * need to create one manually via {@link ListInventoryEntriesRequest#builder()}
     * </p>
     *
     * @param listInventoryEntriesRequest
     *        A {@link Consumer} that will call methods on {@link ListInventoryEntriesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListInventoryEntries operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>InvalidInstanceIdException The following problems can cause this exception:</p>
     *         <p>
     *         You do not have permission to access the instance.
     *         </p>
     *         <p>
     *         SSM Agent is not running. Verify that SSM Agent is running.
     *         </p>
     *         <p>
     *         SSM Agent is not registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         <p>
     *         The instance is not in valid state. Valid states are: Running, Pending, Stopped, Stopping. Invalid states
     *         are: Shutting-down and Terminated.</li>
     *         <li>InvalidTypeNameException The parameter type name is not valid.</li>
     *         <li>InvalidFilterException The filter name is not valid. Verify the you entered the correct name and try
     *         again.</li>
     *         <li>InvalidNextTokenException The specified token is not valid.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListInventoryEntries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListInventoryEntriesResponse> listInventoryEntries(
            Consumer<ListInventoryEntriesRequest.Builder> listInventoryEntriesRequest) {
        return listInventoryEntries(ListInventoryEntriesRequest.builder().applyMutation(listInventoryEntriesRequest).build());
    }

    /**
     * <p>
     * Returns a list of all OpsItem events in the current AWS account and Region. You can limit the results to events
     * associated with specific OpsItems by specifying a filter.
     * </p>
     *
     * @param listOpsItemEventsRequest
     * @return A Java Future containing the result of the ListOpsItemEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemNotFoundException The specified OpsItem ID doesn't exist. Verify the ID and try again.</li>
     *         <li>OpsItemLimitExceededException The request caused OpsItems to exceed one or more quotas. For
     *         information about OpsItem quotas, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsItemEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOpsItemEventsResponse> listOpsItemEvents(ListOpsItemEventsRequest listOpsItemEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all OpsItem events in the current AWS account and Region. You can limit the results to events
     * associated with specific OpsItems by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpsItemEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListOpsItemEventsRequest#builder()}
     * </p>
     *
     * @param listOpsItemEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListOpsItemEventsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListOpsItemEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemNotFoundException The specified OpsItem ID doesn't exist. Verify the ID and try again.</li>
     *         <li>OpsItemLimitExceededException The request caused OpsItems to exceed one or more quotas. For
     *         information about OpsItem quotas, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsItemEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOpsItemEventsResponse> listOpsItemEvents(
            Consumer<ListOpsItemEventsRequest.Builder> listOpsItemEventsRequest) {
        return listOpsItemEvents(ListOpsItemEventsRequest.builder().applyMutation(listOpsItemEventsRequest).build());
    }

    /**
     * <p>
     * Returns a list of all OpsItem events in the current AWS account and Region. You can limit the results to events
     * associated with specific OpsItems by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOpsItemEvents(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsPublisher publisher = client.listOpsItemEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsPublisher publisher = client.listOpsItemEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsItemEvents(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest)} operation.</b>
     * </p>
     *
     * @param listOpsItemEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemNotFoundException The specified OpsItem ID doesn't exist. Verify the ID and try again.</li>
     *         <li>OpsItemLimitExceededException The request caused OpsItems to exceed one or more quotas. For
     *         information about OpsItem quotas, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsItemEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOpsItemEventsPublisher listOpsItemEventsPaginator(ListOpsItemEventsRequest listOpsItemEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of all OpsItem events in the current AWS account and Region. You can limit the results to events
     * associated with specific OpsItems by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOpsItemEvents(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsPublisher publisher = client.listOpsItemEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsPublisher publisher = client.listOpsItemEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsItemEvents(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpsItemEventsRequest.Builder} avoiding the need
     * to create one manually via {@link ListOpsItemEventsRequest#builder()}
     * </p>
     *
     * @param listOpsItemEventsRequest
     *        A {@link Consumer} that will call methods on {@link ListOpsItemEventsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>OpsItemNotFoundException The specified OpsItem ID doesn't exist. Verify the ID and try again.</li>
     *         <li>OpsItemLimitExceededException The request caused OpsItems to exceed one or more quotas. For
     *         information about OpsItem quotas, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.</li>
     *         <li>OpsItemInvalidParameterException A specified parameter argument isn't valid. Verify the available
     *         arguments and try again.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsItemEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOpsItemEventsPublisher listOpsItemEventsPaginator(
            Consumer<ListOpsItemEventsRequest.Builder> listOpsItemEventsRequest) {
        return listOpsItemEventsPaginator(ListOpsItemEventsRequest.builder().applyMutation(listOpsItemEventsRequest).build());
    }

    /**
     * <p>
     * Systems Manager calls this API action when displaying all Application Manager OpsMetadata objects or blobs.
     * </p>
     *
     * @param listOpsMetadataRequest
     * @return A Java Future containing the result of the ListOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOpsMetadataResponse> listOpsMetadata(ListOpsMetadataRequest listOpsMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Systems Manager calls this API action when displaying all Application Manager OpsMetadata objects or blobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpsMetadataRequest.Builder} avoiding the need
     * to create one manually via {@link ListOpsMetadataRequest#builder()}
     * </p>
     *
     * @param listOpsMetadataRequest
     *        A {@link Consumer} that will call methods on {@link ListOpsMetadataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListOpsMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListOpsMetadataResponse> listOpsMetadata(
            Consumer<ListOpsMetadataRequest.Builder> listOpsMetadataRequest) {
        return listOpsMetadata(ListOpsMetadataRequest.builder().applyMutation(listOpsMetadataRequest).build());
    }

    /**
     * <p>
     * Systems Manager calls this API action when displaying all Application Manager OpsMetadata objects or blobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listOpsMetadata(software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataPublisher publisher = client.listOpsMetadataPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataPublisher publisher = client.listOpsMetadataPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsMetadata(software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest)} operation.</b>
     * </p>
     *
     * @param listOpsMetadataRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OpsMetadataInvalidArgumentException One of the arguments passed is invalid.</li>
     *         <li>InternalServerErrorException An error occurred on the server side.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SsmException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample SsmAsyncClient.ListOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default ListOpsMetadataPublisher listOpsMetadataPaginator(ListOpsMetadataRequest listOpsMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Systems Manager calls this API action when displaying all Application Manager OpsMetadata objects or blobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listOpsMetadata(software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactiv