/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse;
import software.amazon.awssdk.services.ssm.model.InstanceInformation;

public class DescribeInstanceInformationIterable
implements SdkIterable<DescribeInstanceInformationResponse> {
    private final SsmClient client;
    private final DescribeInstanceInformationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstanceInformationIterable(SsmClient client, DescribeInstanceInformationRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstanceInformationResponseFetcher();
    }

    public Iterator<DescribeInstanceInformationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InstanceInformation> instanceInformationList() {
        Function<DescribeInstanceInformationResponse, Iterator> getIterator = response -> {
            if (response != null && response.instanceInformationList() != null) {
                return response.instanceInformationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeInstanceInformationResponseFetcher
    implements SyncPageFetcher<DescribeInstanceInformationResponse> {
        private DescribeInstanceInformationResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstanceInformationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeInstanceInformationResponse nextPage(DescribeInstanceInformationResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstanceInformationIterable.this.client.describeInstanceInformation(DescribeInstanceInformationIterable.this.firstRequest);
            }
            return DescribeInstanceInformationIterable.this.client.describeInstanceInformation((DescribeInstanceInformationRequest)((Object)DescribeInstanceInformationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

