/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAssociationRequest extends SsmRequest implements
        ToCopyableBuilder<UpdateAssociationRequest.Builder, UpdateAssociationRequest> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(UpdateAssociationRequest::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(UpdateAssociationRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(UpdateAssociationRequest::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(UpdateAssociationRequest::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<InstanceAssociationOutputLocation> OUTPUT_LOCATION_FIELD = SdkField
            .<InstanceAssociationOutputLocation> builder(MarshallingType.SDK_POJO).memberName("OutputLocation")
            .getter(getter(UpdateAssociationRequest::outputLocation)).setter(setter(Builder::outputLocation))
            .constructor(InstanceAssociationOutputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(UpdateAssociationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(UpdateAssociationRequest::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ASSOCIATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationName").getter(getter(UpdateAssociationRequest::associationName))
            .setter(setter(Builder::associationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationName").build()).build();

    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationVersion").getter(getter(UpdateAssociationRequest::associationVersion))
            .setter(setter(Builder::associationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build())
            .build();

    private static final SdkField<String> AUTOMATION_TARGET_PARAMETER_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutomationTargetParameterName")
            .getter(getter(UpdateAssociationRequest::automationTargetParameterName))
            .setter(setter(Builder::automationTargetParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationTargetParameterName")
                    .build()).build();

    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxErrors").getter(getter(UpdateAssociationRequest::maxErrors)).setter(setter(Builder::maxErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()).build();

    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxConcurrency").getter(getter(UpdateAssociationRequest::maxConcurrency))
            .setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()).build();

    private static final SdkField<String> COMPLIANCE_SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceSeverity").getter(getter(UpdateAssociationRequest::complianceSeverityAsString))
            .setter(setter(Builder::complianceSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSeverity").build())
            .build();

    private static final SdkField<String> SYNC_COMPLIANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncCompliance").getter(getter(UpdateAssociationRequest::syncComplianceAsString))
            .setter(setter(Builder::syncCompliance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncCompliance").build()).build();

    private static final SdkField<Boolean> APPLY_ONLY_AT_CRON_INTERVAL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ApplyOnlyAtCronInterval")
            .getter(getter(UpdateAssociationRequest::applyOnlyAtCronInterval)).setter(setter(Builder::applyOnlyAtCronInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyOnlyAtCronInterval").build())
            .build();

    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField
            .<List<TargetLocation>> builder(MarshallingType.LIST)
            .memberName("TargetLocations")
            .getter(getter(UpdateAssociationRequest::targetLocations))
            .setter(setter(Builder::targetLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            PARAMETERS_FIELD, DOCUMENT_VERSION_FIELD, SCHEDULE_EXPRESSION_FIELD, OUTPUT_LOCATION_FIELD, NAME_FIELD,
            TARGETS_FIELD, ASSOCIATION_NAME_FIELD, ASSOCIATION_VERSION_FIELD, AUTOMATION_TARGET_PARAMETER_NAME_FIELD,
            MAX_ERRORS_FIELD, MAX_CONCURRENCY_FIELD, COMPLIANCE_SEVERITY_FIELD, SYNC_COMPLIANCE_FIELD,
            APPLY_ONLY_AT_CRON_INTERVAL_FIELD, TARGET_LOCATIONS_FIELD));

    private final String associationId;

    private final Map<String, List<String>> parameters;

    private final String documentVersion;

    private final String scheduleExpression;

    private final InstanceAssociationOutputLocation outputLocation;

    private final String name;

    private final List<Target> targets;

    private final String associationName;

    private final String associationVersion;

    private final String automationTargetParameterName;

    private final String maxErrors;

    private final String maxConcurrency;

    private final String complianceSeverity;

    private final String syncCompliance;

    private final Boolean applyOnlyAtCronInterval;

    private final List<TargetLocation> targetLocations;

    private UpdateAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.parameters = builder.parameters;
        this.documentVersion = builder.documentVersion;
        this.scheduleExpression = builder.scheduleExpression;
        this.outputLocation = builder.outputLocation;
        this.name = builder.name;
        this.targets = builder.targets;
        this.associationName = builder.associationName;
        this.associationVersion = builder.associationVersion;
        this.automationTargetParameterName = builder.automationTargetParameterName;
        this.maxErrors = builder.maxErrors;
        this.maxConcurrency = builder.maxConcurrency;
        this.complianceSeverity = builder.complianceSeverity;
        this.syncCompliance = builder.syncCompliance;
        this.applyOnlyAtCronInterval = builder.applyOnlyAtCronInterval;
        this.targetLocations = builder.targetLocations;
    }

    /**
     * <p>
     * The ID of the association you want to update.
     * </p>
     * 
     * @return The ID of the association you want to update.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * Returns true if the Parameters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The parameters you want to update for the association. If you create a parameter using Parameter Store, you can
     * reference the parameter using {{ssm:parameter-name}}
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasParameters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The parameters you want to update for the association. If you create a parameter using Parameter Store,
     *         you can reference the parameter using {{ssm:parameter-name}}
     */
    public final Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The document version you want update for the association.
     * </p>
     * 
     * @return The document version you want update for the association.
     */
    public final String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The cron expression used to schedule the association that you want to update.
     * </p>
     * 
     * @return The cron expression used to schedule the association that you want to update.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * An S3 bucket where you want to store the results of this request.
     * </p>
     * 
     * @return An S3 bucket where you want to store the results of this request.
     */
    public final InstanceAssociationOutputLocation outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The name of the SSM document that contains the configuration information for the instance. You can specify
     * Command or Automation documents.
     * </p>
     * <p>
     * You can specify AWS-predefined documents, documents you created, or a document that is shared with you from
     * another account.
     * </p>
     * <p>
     * For SSM documents that are shared with you from other AWS accounts, you must specify the complete SSM document
     * ARN, in the following format:
     * </p>
     * <p>
     * <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code>
     * </p>
     * <p>
     * For example:
     * </p>
     * <p>
     * <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
     * </p>
     * <p>
     * For AWS-predefined documents and SSM documents you created in your account, you only need to specify the document
     * name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.
     * </p>
     * 
     * @return The name of the SSM document that contains the configuration information for the instance. You can
     *         specify Command or Automation documents.</p>
     *         <p>
     *         You can specify AWS-predefined documents, documents you created, or a document that is shared with you
     *         from another account.
     *         </p>
     *         <p>
     *         For SSM documents that are shared with you from other AWS accounts, you must specify the complete SSM
     *         document ARN, in the following format:
     *         </p>
     *         <p>
     *         <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code>
     *         </p>
     *         <p>
     *         For example:
     *         </p>
     *         <p>
     *         <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
     *         </p>
     *         <p>
     *         For AWS-predefined documents and SSM documents you created in your account, you only need to specify the
     *         document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * Returns true if the Targets property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The targets of the association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The targets of the association.
     */
    public final List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * The name of the association that you want to update.
     * </p>
     * 
     * @return The name of the association that you want to update.
     */
    public final String associationName() {
        return associationName;
    }

    /**
     * <p>
     * This parameter is provided for concurrency control purposes. You must specify the latest association version in
     * the service. If you want to ensure that this request succeeds, either specify <code>$LATEST</code>, or omit this
     * parameter.
     * </p>
     * 
     * @return This parameter is provided for concurrency control purposes. You must specify the latest association
     *         version in the service. If you want to ensure that this request succeeds, either specify
     *         <code>$LATEST</code>, or omit this parameter.
     */
    public final String associationVersion() {
        return associationVersion;
    }

    /**
     * <p>
     * Specify the target for the association. This target is required for associations that use an Automation document
     * and target resources by using rate controls.
     * </p>
     * 
     * @return Specify the target for the association. This target is required for associations that use an Automation
     *         document and target resources by using rate controls.
     */
    public final String automationTargetParameterName() {
        return automationTargetParameterName;
    }

    /**
     * <p>
     * The number of errors that are allowed before the system stops sending requests to run the association on
     * additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the
     * target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth
     * error is received. If you specify 0, then the system stops sending requests after the first error is returned. If
     * you run an association on 50 instances and set MaxError to 10%, then the system stops sending the request when
     * the sixth error is received.
     * </p>
     * <p>
     * Executions that are already running an association when MaxErrors is reached are allowed to complete, but some of
     * these executions may fail as well. If you need to ensure that there won't be more than max-errors failed
     * executions, set MaxConcurrency to 1 so that executions proceed one at a time.
     * </p>
     * 
     * @return The number of errors that are allowed before the system stops sending requests to run the association on
     *         additional targets. You can specify either an absolute number of errors, for example 10, or a percentage
     *         of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when
     *         the fourth error is received. If you specify 0, then the system stops sending requests after the first
     *         error is returned. If you run an association on 50 instances and set MaxError to 10%, then the system
     *         stops sending the request when the sixth error is received.</p>
     *         <p>
     *         Executions that are already running an association when MaxErrors is reached are allowed to complete, but
     *         some of these executions may fail as well. If you need to ensure that there won't be more than max-errors
     *         failed executions, set MaxConcurrency to 1 so that executions proceed one at a time.
     */
    public final String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The maximum number of targets allowed to run the association at the same time. You can specify a number, for
     * example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all
     * targets run the association at the same time.
     * </p>
     * <p>
     * If a new instance starts and attempts to run an association while Systems Manager is running MaxConcurrency
     * associations, the association is allowed to run. During the next association interval, the new instance will
     * process its association within the limit specified for MaxConcurrency.
     * </p>
     * 
     * @return The maximum number of targets allowed to run the association at the same time. You can specify a number,
     *         for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which
     *         means all targets run the association at the same time.</p>
     *         <p>
     *         If a new instance starts and attempts to run an association while Systems Manager is running
     *         MaxConcurrency associations, the association is allowed to run. During the next association interval, the
     *         new instance will process its association within the limit specified for MaxConcurrency.
     */
    public final String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The severity level to assign to the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #complianceSeverity} will return {@link AssociationComplianceSeverity#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #complianceSeverityAsString}.
     * </p>
     * 
     * @return The severity level to assign to the association.
     * @see AssociationComplianceSeverity
     */
    public final AssociationComplianceSeverity complianceSeverity() {
        return AssociationComplianceSeverity.fromValue(complianceSeverity);
    }

    /**
     * <p>
     * The severity level to assign to the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #complianceSeverity} will return {@link AssociationComplianceSeverity#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #complianceSeverityAsString}.
     * </p>
     * 
     * @return The severity level to assign to the association.
     * @see AssociationComplianceSeverity
     */
    public final String complianceSeverityAsString() {
        return complianceSeverity;
    }

    /**
     * <p>
     * The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In
     * <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance
     * status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the
     * association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.
     * </p>
     * <p>
     * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
     * <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager. It is
     * managed by your direct call to the <a>PutComplianceItems</a> API action.
     * </p>
     * <p>
     * By default, all associations use <code>AUTO</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncCompliance}
     * will return {@link AssociationSyncCompliance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #syncComplianceAsString}.
     * </p>
     * 
     * @return The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>.
     *         In <code>AUTO</code> mode, the system uses the status of the association execution to determine the
     *         compliance status. If the association execution runs successfully, then the association is
     *         <code>COMPLIANT</code>. If the association execution doesn't run successfully, the association is
     *         <code>NON-COMPLIANT</code>.</p>
     *         <p>
     *         In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
     *         <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager. It
     *         is managed by your direct call to the <a>PutComplianceItems</a> API action.
     *         </p>
     *         <p>
     *         By default, all associations use <code>AUTO</code> mode.
     * @see AssociationSyncCompliance
     */
    public final AssociationSyncCompliance syncCompliance() {
        return AssociationSyncCompliance.fromValue(syncCompliance);
    }

    /**
     * <p>
     * The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In
     * <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance
     * status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the
     * association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.
     * </p>
     * <p>
     * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
     * <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager. It is
     * managed by your direct call to the <a>PutComplianceItems</a> API action.
     * </p>
     * <p>
     * By default, all associations use <code>AUTO</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncCompliance}
     * will return {@link AssociationSyncCompliance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #syncComplianceAsString}.
     * </p>
     * 
     * @return The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>.
     *         In <code>AUTO</code> mode, the system uses the status of the association execution to determine the
     *         compliance status. If the association execution runs successfully, then the association is
     *         <code>COMPLIANT</code>. If the association execution doesn't run successfully, the association is
     *         <code>NON-COMPLIANT</code>.</p>
     *         <p>
     *         In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
     *         <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager. It
     *         is managed by your direct call to the <a>PutComplianceItems</a> API action.
     *         </p>
     *         <p>
     *         By default, all associations use <code>AUTO</code> mode.
     * @see AssociationSyncCompliance
     */
    public final String syncComplianceAsString() {
        return syncCompliance;
    }

    /**
     * <p>
     * By default, when you update an association, the system runs it immediately after it is updated and then according
     * to the schedule you specified. Specify this option if you don't want an association to run immediately after you
     * update it. This parameter is not supported for rate expressions.
     * </p>
     * <p>
     * Also, if you specified this option when you created the association, you can reset it. To do so, specify the
     * <code>no-apply-only-at-cron-interval</code> parameter when you update the association from the command line. This
     * parameter forces the association to run immediately after updating it and according to the interval specified.
     * </p>
     * 
     * @return By default, when you update an association, the system runs it immediately after it is updated and then
     *         according to the schedule you specified. Specify this option if you don't want an association to run
     *         immediately after you update it. This parameter is not supported for rate expressions.</p>
     *         <p>
     *         Also, if you specified this option when you created the association, you can reset it. To do so, specify
     *         the <code>no-apply-only-at-cron-interval</code> parameter when you update the association from the
     *         command line. This parameter forces the association to run immediately after updating it and according to
     *         the interval specified.
     */
    public final Boolean applyOnlyAtCronInterval() {
        return applyOnlyAtCronInterval;
    }

    /**
     * Returns true if the TargetLocations property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTargetLocations() {
        return targetLocations != null && !(targetLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A location is a combination of AWS Regions and AWS accounts where you want to run the association. Use this
     * action to update an association in multiple Regions and multiple accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTargetLocations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A location is a combination of AWS Regions and AWS accounts where you want to run the association. Use
     *         this action to update an association in multiple Regions and multiple accounts.
     */
    public final List<TargetLocation> targetLocations() {
        return targetLocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(associationName());
        hashCode = 31 * hashCode + Objects.hashCode(associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(automationTargetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(complianceSeverityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(syncComplianceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applyOnlyAtCronInterval());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetLocations() ? targetLocations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssociationRequest)) {
            return false;
        }
        UpdateAssociationRequest other = (UpdateAssociationRequest) obj;
        return Objects.equals(associationId(), other.associationId()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(outputLocation(), other.outputLocation()) && Objects.equals(name(), other.name())
                && hasTargets() == other.hasTargets() && Objects.equals(targets(), other.targets())
                && Objects.equals(associationName(), other.associationName())
                && Objects.equals(associationVersion(), other.associationVersion())
                && Objects.equals(automationTargetParameterName(), other.automationTargetParameterName())
                && Objects.equals(maxErrors(), other.maxErrors()) && Objects.equals(maxConcurrency(), other.maxConcurrency())
                && Objects.equals(complianceSeverityAsString(), other.complianceSeverityAsString())
                && Objects.equals(syncComplianceAsString(), other.syncComplianceAsString())
                && Objects.equals(applyOnlyAtCronInterval(), other.applyOnlyAtCronInterval())
                && hasTargetLocations() == other.hasTargetLocations()
                && Objects.equals(targetLocations(), other.targetLocations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAssociationRequest").add("AssociationId", associationId())
                .add("Parameters", hasParameters() ? parameters() : null).add("DocumentVersion", documentVersion())
                .add("ScheduleExpression", scheduleExpression()).add("OutputLocation", outputLocation()).add("Name", name())
                .add("Targets", hasTargets() ? targets() : null).add("AssociationName", associationName())
                .add("AssociationVersion", associationVersion())
                .add("AutomationTargetParameterName", automationTargetParameterName()).add("MaxErrors", maxErrors())
                .add("MaxConcurrency", maxConcurrency()).add("ComplianceSeverity", complianceSeverityAsString())
                .add("SyncCompliance", syncComplianceAsString()).add("ApplyOnlyAtCronInterval", applyOnlyAtCronInterval())
                .add("TargetLocations", hasTargetLocations() ? targetLocations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "OutputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "AssociationName":
            return Optional.ofNullable(clazz.cast(associationName()));
        case "AssociationVersion":
            return Optional.ofNullable(clazz.cast(associationVersion()));
        case "AutomationTargetParameterName":
            return Optional.ofNullable(clazz.cast(automationTargetParameterName()));
        case "MaxErrors":
            return Optional.ofNullable(clazz.cast(maxErrors()));
        case "MaxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "ComplianceSeverity":
            return Optional.ofNullable(clazz.cast(complianceSeverityAsString()));
        case "SyncCompliance":
            return Optional.ofNullable(clazz.cast(syncComplianceAsString()));
        case "ApplyOnlyAtCronInterval":
            return Optional.ofNullable(clazz.cast(applyOnlyAtCronInterval()));
        case "TargetLocations":
            return Optional.ofNullable(clazz.cast(targetLocations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssociationRequest, T> g) {
        return obj -> g.apply((UpdateAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAssociationRequest> {
        /**
         * <p>
         * The ID of the association you want to update.
         * </p>
         * 
         * @param associationId
         *        The ID of the association you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The parameters you want to update for the association. If you create a parameter using Parameter Store, you
         * can reference the parameter using {{ssm:parameter-name}}
         * </p>
         * 
         * @param parameters
         *        The parameters you want to update for the association. If you create a parameter using Parameter
         *        Store, you can reference the parameter using {{ssm:parameter-name}}
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * The document version you want update for the association.
         * </p>
         * 
         * @param documentVersion
         *        The document version you want update for the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The cron expression used to schedule the association that you want to update.
         * </p>
         * 
         * @param scheduleExpression
         *        The cron expression used to schedule the association that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * An S3 bucket where you want to store the results of this request.
         * </p>
         * 
         * @param outputLocation
         *        An S3 bucket where you want to store the results of this request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(InstanceAssociationOutputLocation outputLocation);

        /**
         * <p>
         * An S3 bucket where you want to store the results of this request.
         * </p>
         * This is a convenience that creates an instance of the {@link InstanceAssociationOutputLocation.Builder}
         * avoiding the need to create one manually via {@link InstanceAssociationOutputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceAssociationOutputLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #outputLocation(InstanceAssociationOutputLocation)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link InstanceAssociationOutputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(InstanceAssociationOutputLocation)
         */
        default Builder outputLocation(Consumer<InstanceAssociationOutputLocation.Builder> outputLocation) {
            return outputLocation(InstanceAssociationOutputLocation.builder().applyMutation(outputLocation).build());
        }

        /**
         * <p>
         * The name of the SSM document that contains the configuration information for the instance. You can specify
         * Command or Automation documents.
         * </p>
         * <p>
         * You can specify AWS-predefined documents, documents you created, or a document that is shared with you from
         * another account.
         * </p>
         * <p>
         * For SSM documents that are shared with you from other AWS accounts, you must specify the complete SSM
         * document ARN, in the following format:
         * </p>
         * <p>
         * <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code>
         * </p>
         * <p>
         * For example:
         * </p>
         * <p>
         * <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
         * </p>
         * <p>
         * For AWS-predefined documents and SSM documents you created in your account, you only need to specify the
         * document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.
         * </p>
         * 
         * @param name
         *        The name of the SSM document that contains the configuration information for the instance. You can
         *        specify Command or Automation documents.</p>
         *        <p>
         *        You can specify AWS-predefined documents, documents you created, or a document that is shared with you
         *        from another account.
         *        </p>
         *        <p>
         *        For SSM documents that are shared with you from other AWS accounts, you must specify the complete SSM
         *        document ARN, in the following format:
         *        </p>
         *        <p>
         *        <code>arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> </code>
         *        </p>
         *        <p>
         *        For example:
         *        </p>
         *        <p>
         *        <code>arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document</code>
         *        </p>
         *        <p>
         *        For AWS-predefined documents and SSM documents you created in your account, you only need to specify
         *        the document name. For example, <code>AWS-ApplyPatchBaseline</code> or <code>My-Document</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The targets of the association.
         * </p>
         * 
         * @param targets
         *        The targets of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The targets of the association.
         * </p>
         * 
         * @param targets
         *        The targets of the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * The targets of the association.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Target>.Builder} avoiding the need to
         * create one manually via {@link List<Target>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Target>.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<Target>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * The name of the association that you want to update.
         * </p>
         * 
         * @param associationName
         *        The name of the association that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationName(String associationName);

        /**
         * <p>
         * This parameter is provided for concurrency control purposes. You must specify the latest association version
         * in the service. If you want to ensure that this request succeeds, either specify <code>$LATEST</code>, or
         * omit this parameter.
         * </p>
         * 
         * @param associationVersion
         *        This parameter is provided for concurrency control purposes. You must specify the latest association
         *        version in the service. If you want to ensure that this request succeeds, either specify
         *        <code>$LATEST</code>, or omit this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationVersion(String associationVersion);

        /**
         * <p>
         * Specify the target for the association. This target is required for associations that use an Automation
         * document and target resources by using rate controls.
         * </p>
         * 
         * @param automationTargetParameterName
         *        Specify the target for the association. This target is required for associations that use an
         *        Automation document and target resources by using rate controls.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationTargetParameterName(String automationTargetParameterName);

        /**
         * <p>
         * The number of errors that are allowed before the system stops sending requests to run the association on
         * additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of
         * the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the
         * fourth error is received. If you specify 0, then the system stops sending requests after the first error is
         * returned. If you run an association on 50 instances and set MaxError to 10%, then the system stops sending
         * the request when the sixth error is received.
         * </p>
         * <p>
         * Executions that are already running an association when MaxErrors is reached are allowed to complete, but
         * some of these executions may fail as well. If you need to ensure that there won't be more than max-errors
         * failed executions, set MaxConcurrency to 1 so that executions proceed one at a time.
         * </p>
         * 
         * @param maxErrors
         *        The number of errors that are allowed before the system stops sending requests to run the association
         *        on additional targets. You can specify either an absolute number of errors, for example 10, or a
         *        percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending
         *        requests when the fourth error is received. If you specify 0, then the system stops sending requests
         *        after the first error is returned. If you run an association on 50 instances and set MaxError to 10%,
         *        then the system stops sending the request when the sixth error is received.</p>
         *        <p>
         *        Executions that are already running an association when MaxErrors is reached are allowed to complete,
         *        but some of these executions may fail as well. If you need to ensure that there won't be more than
         *        max-errors failed executions, set MaxConcurrency to 1 so that executions proceed one at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The maximum number of targets allowed to run the association at the same time. You can specify a number, for
         * example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all
         * targets run the association at the same time.
         * </p>
         * <p>
         * If a new instance starts and attempts to run an association while Systems Manager is running MaxConcurrency
         * associations, the association is allowed to run. During the next association interval, the new instance will
         * process its association within the limit specified for MaxConcurrency.
         * </p>
         * 
         * @param maxConcurrency
         *        The maximum number of targets allowed to run the association at the same time. You can specify a
         *        number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%,
         *        which means all targets run the association at the same time.</p>
         *        <p>
         *        If a new instance starts and attempts to run an association while Systems Manager is running
         *        MaxConcurrency associations, the association is allowed to run. During the next association interval,
         *        the new instance will process its association within the limit specified for MaxConcurrency.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The severity level to assign to the association.
         * </p>
         * 
         * @param complianceSeverity
         *        The severity level to assign to the association.
         * @see AssociationComplianceSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationComplianceSeverity
         */
        Builder complianceSeverity(String complianceSeverity);

        /**
         * <p>
         * The severity level to assign to the association.
         * </p>
         * 
         * @param complianceSeverity
         *        The severity level to assign to the association.
         * @see AssociationComplianceSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationComplianceSeverity
         */
        Builder complianceSeverity(AssociationComplianceSeverity complianceSeverity);

        /**
         * <p>
         * The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In
         * <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance
         * status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If
         * the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.
         * </p>
         * <p>
         * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
         * <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager. It is
         * managed by your direct call to the <a>PutComplianceItems</a> API action.
         * </p>
         * <p>
         * By default, all associations use <code>AUTO</code> mode.
         * </p>
         * 
         * @param syncCompliance
         *        The mode for generating association compliance. You can specify <code>AUTO</code> or
         *        <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
         *        execution to determine the compliance status. If the association execution runs successfully, then the
         *        association is <code>COMPLIANT</code>. If the association execution doesn't run successfully, the
         *        association is <code>NON-COMPLIANT</code>.</p>
         *        <p>
         *        In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
         *        <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager.
         *        It is managed by your direct call to the <a>PutComplianceItems</a> API action.
         *        </p>
         *        <p>
         *        By default, all associations use <code>AUTO</code> mode.
         * @see AssociationSyncCompliance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationSyncCompliance
         */
        Builder syncCompliance(String syncCompliance);

        /**
         * <p>
         * The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In
         * <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance
         * status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If
         * the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.
         * </p>
         * <p>
         * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
         * <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager. It is
         * managed by your direct call to the <a>PutComplianceItems</a> API action.
         * </p>
         * <p>
         * By default, all associations use <code>AUTO</code> mode.
         * </p>
         * 
         * @param syncCompliance
         *        The mode for generating association compliance. You can specify <code>AUTO</code> or
         *        <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
         *        execution to determine the compliance status. If the association execution runs successfully, then the
         *        association is <code>COMPLIANT</code>. If the association execution doesn't run successfully, the
         *        association is <code>NON-COMPLIANT</code>.</p>
         *        <p>
         *        In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
         *        <a>PutComplianceItems</a> API action. In this case, compliance data is not managed by State Manager.
         *        It is managed by your direct call to the <a>PutComplianceItems</a> API action.
         *        </p>
         *        <p>
         *        By default, all associations use <code>AUTO</code> mode.
         * @see AssociationSyncCompliance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationSyncCompliance
         */
        Builder syncCompliance(AssociationSyncCompliance syncCompliance);

        /**
         * <p>
         * By default, when you update an association, the system runs it immediately after it is updated and then
         * according to the schedule you specified. Specify this option if you don't want an association to run
         * immediately after you update it. This parameter is not supported for rate expressions.
         * </p>
         * <p>
         * Also, if you specified this option when you created the association, you can reset it. To do so, specify the
         * <code>no-apply-only-at-cron-interval</code> parameter when you update the association from the command line.
         * This parameter forces the association to run immediately after updating it and according to the interval
         * specified.
         * </p>
         * 
         * @param applyOnlyAtCronInterval
         *        By default, when you update an association, the system runs it immediately after it is updated and
         *        then according to the schedule you specified. Specify this option if you don't want an association to
         *        run immediately after you update it. This parameter is not supported for rate expressions.</p>
         *        <p>
         *        Also, if you specified this option when you created the association, you can reset it. To do so,
         *        specify the <code>no-apply-only-at-cron-interval</code> parameter when you update the association from
         *        the command line. This parameter forces the association to run immediately after updating it and
         *        according to the interval specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval);

        /**
         * <p>
         * A location is a combination of AWS Regions and AWS accounts where you want to run the association. Use this
         * action to update an association in multiple Regions and multiple accounts.
         * </p>
         * 
         * @param targetLocations
         *        A location is a combination of AWS Regions and AWS accounts where you want to run the association. Use
         *        this action to update an association in multiple Regions and multiple accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocations(Collection<TargetLocation> targetLocations);

        /**
         * <p>
         * A location is a combination of AWS Regions and AWS accounts where you want to run the association. Use this
         * action to update an association in multiple Regions and multiple accounts.
         * </p>
         * 
         * @param targetLocations
         *        A location is a combination of AWS Regions and AWS accounts where you want to run the association. Use
         *        this action to update an association in multiple Regions and multiple accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocations(TargetLocation... targetLocations);

        /**
         * <p>
         * A location is a combination of AWS Regions and AWS accounts where you want to run the association. Use this
         * action to update an association in multiple Regions and multiple accounts.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TargetLocation>.Builder} avoiding the need
         * to create one manually via {@link List<TargetLocation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetLocation>.Builder#build()} is called immediately and
         * its result is passed to {@link #targetLocations(List<TargetLocation>)}.
         * 
         * @param targetLocations
         *        a consumer that will call methods on {@link List<TargetLocation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetLocations(List<TargetLocation>)
         */
        Builder targetLocations(Consumer<TargetLocation.Builder>... targetLocations);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String associationId;

        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String documentVersion;

        private String scheduleExpression;

        private InstanceAssociationOutputLocation outputLocation;

        private String name;

        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private String associationName;

        private String associationVersion;

        private String automationTargetParameterName;

        private String maxErrors;

        private String maxConcurrency;

        private String complianceSeverity;

        private String syncCompliance;

        private Boolean applyOnlyAtCronInterval;

        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssociationRequest model) {
            super(model);
            associationId(model.associationId);
            parameters(model.parameters);
            documentVersion(model.documentVersion);
            scheduleExpression(model.scheduleExpression);
            outputLocation(model.outputLocation);
            name(model.name);
            targets(model.targets);
            associationName(model.associationName);
            associationVersion(model.associationVersion);
            automationTargetParameterName(model.automationTargetParameterName);
            maxErrors(model.maxErrors);
            maxConcurrency(model.maxConcurrency);
            complianceSeverity(model.complianceSeverity);
            syncCompliance(model.syncCompliance);
            applyOnlyAtCronInterval(model.applyOnlyAtCronInterval);
            targetLocations(model.targetLocations);
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final InstanceAssociationOutputLocation.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        @Override
        public final Builder outputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final void setOutputLocation(InstanceAssociationOutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        public final String getAssociationName() {
            return associationName;
        }

        @Override
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        public final String getAssociationVersion() {
            return associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        public final String getAutomationTargetParameterName() {
            return automationTargetParameterName;
        }

        @Override
        public final Builder automationTargetParameterName(String automationTargetParameterName) {
            this.automationTargetParameterName = automationTargetParameterName;
            return this;
        }

        public final void setAutomationTargetParameterName(String automationTargetParameterName) {
            this.automationTargetParameterName = automationTargetParameterName;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        public final String getComplianceSeverity() {
            return complianceSeverity;
        }

        @Override
        public final Builder complianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
            return this;
        }

        @Override
        public final Builder complianceSeverity(AssociationComplianceSeverity complianceSeverity) {
            this.complianceSeverity(complianceSeverity == null ? null : complianceSeverity.toString());
            return this;
        }

        public final void setComplianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
        }

        public final String getSyncCompliance() {
            return syncCompliance;
        }

        @Override
        public final Builder syncCompliance(String syncCompliance) {
            this.syncCompliance = syncCompliance;
            return this;
        }

        @Override
        public final Builder syncCompliance(AssociationSyncCompliance syncCompliance) {
            this.syncCompliance(syncCompliance == null ? null : syncCompliance.toString());
            return this;
        }

        public final void setSyncCompliance(String syncCompliance) {
            this.syncCompliance = syncCompliance;
        }

        public final Boolean getApplyOnlyAtCronInterval() {
            return applyOnlyAtCronInterval;
        }

        @Override
        public final Builder applyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
            return this;
        }

        public final void setApplyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
        }

        public final List<TargetLocation.Builder> getTargetLocations() {
            List<TargetLocation.Builder> result = TargetLocationsCopier.copyToBuilder(this.targetLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(TargetLocation... targetLocations) {
            targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder>... targetLocations) {
            targetLocations(Stream.of(targetLocations).map(c -> TargetLocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssociationRequest build() {
            return new UpdateAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
