/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ssm.model.PatchFilter;
import software.amazon.awssdk.services.ssm.model.PatchFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatchFilterGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PatchFilterGroup> {
    private static final SdkField<List<PatchFilter>> PATCH_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PatchFilters").getter(PatchFilterGroup.getter(PatchFilterGroup::patchFilters)).setter(PatchFilterGroup.setter(Builder::patchFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PatchFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCH_FILTERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<PatchFilter> patchFilters;

    private PatchFilterGroup(BuilderImpl builder) {
        this.patchFilters = builder.patchFilters;
    }

    public final boolean hasPatchFilters() {
        return this.patchFilters != null && !(this.patchFilters instanceof SdkAutoConstructList);
    }

    public final List<PatchFilter> patchFilters() {
        return this.patchFilters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPatchFilters() ? this.patchFilters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchFilterGroup)) {
            return false;
        }
        PatchFilterGroup other = (PatchFilterGroup)obj;
        return this.hasPatchFilters() == other.hasPatchFilters() && Objects.equals(this.patchFilters(), other.patchFilters());
    }

    public final String toString() {
        return ToString.builder((String)"PatchFilterGroup").add("PatchFilters", this.hasPatchFilters() ? this.patchFilters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PatchFilters": {
                return Optional.ofNullable(clazz.cast(this.patchFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchFilterGroup, T> g) {
        return obj -> g.apply((PatchFilterGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PatchFilter> patchFilters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PatchFilterGroup model) {
            this.patchFilters(model.patchFilters);
        }

        public final List<PatchFilter.Builder> getPatchFilters() {
            List<PatchFilter.Builder> result = PatchFilterListCopier.copyToBuilder(this.patchFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder patchFilters(Collection<PatchFilter> patchFilters) {
            this.patchFilters = PatchFilterListCopier.copy(patchFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchFilters(PatchFilter ... patchFilters) {
            this.patchFilters(Arrays.asList(patchFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder patchFilters(Consumer<PatchFilter.Builder> ... patchFilters) {
            this.patchFilters(Stream.of(patchFilters).map(c -> (PatchFilter)((PatchFilter.Builder)PatchFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPatchFilters(Collection<PatchFilter.BuilderImpl> patchFilters) {
            this.patchFilters = PatchFilterListCopier.copyFromBuilder(patchFilters);
        }

        public PatchFilterGroup build() {
            return new PatchFilterGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PatchFilterGroup> {
        public Builder patchFilters(Collection<PatchFilter> var1);

        public Builder patchFilters(PatchFilter ... var1);

        public Builder patchFilters(Consumer<PatchFilter.Builder> ... var1);
    }
}

