/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDocumentResponse extends SsmResponse implements
        ToCopyableBuilder<GetDocumentResponse.Builder, GetDocumentResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetDocumentResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionName").getter(getter(GetDocumentResponse::versionName)).setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionName").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(GetDocumentResponse::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetDocumentResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_INFORMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusInformation").getter(getter(GetDocumentResponse::statusInformation))
            .setter(setter(Builder::statusInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusInformation").build()).build();

    private static final SdkField<String> CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Content")
            .getter(getter(GetDocumentResponse::content)).setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Content").build()).build();

    private static final SdkField<String> DOCUMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentType").getter(getter(GetDocumentResponse::documentTypeAsString))
            .setter(setter(Builder::documentType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentType").build()).build();

    private static final SdkField<String> DOCUMENT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentFormat").getter(getter(GetDocumentResponse::documentFormatAsString))
            .setter(setter(Builder::documentFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentFormat").build()).build();

    private static final SdkField<List<DocumentRequires>> REQUIRES_FIELD = SdkField
            .<List<DocumentRequires>> builder(MarshallingType.LIST)
            .memberName("Requires")
            .getter(getter(GetDocumentResponse::requires))
            .setter(setter(Builder::requires))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requires").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentRequires> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentRequires::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AttachmentContent>> ATTACHMENTS_CONTENT_FIELD = SdkField
            .<List<AttachmentContent>> builder(MarshallingType.LIST)
            .memberName("AttachmentsContent")
            .getter(getter(GetDocumentResponse::attachmentsContent))
            .setter(setter(Builder::attachmentsContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttachmentsContent").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AttachmentContent> builder(MarshallingType.SDK_POJO)
                                            .constructor(AttachmentContent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REVIEW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReviewStatus").getter(getter(GetDocumentResponse::reviewStatusAsString))
            .setter(setter(Builder::reviewStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            VERSION_NAME_FIELD, DOCUMENT_VERSION_FIELD, STATUS_FIELD, STATUS_INFORMATION_FIELD, CONTENT_FIELD,
            DOCUMENT_TYPE_FIELD, DOCUMENT_FORMAT_FIELD, REQUIRES_FIELD, ATTACHMENTS_CONTENT_FIELD, REVIEW_STATUS_FIELD));

    private final String name;

    private final String versionName;

    private final String documentVersion;

    private final String status;

    private final String statusInformation;

    private final String content;

    private final String documentType;

    private final String documentFormat;

    private final List<DocumentRequires> requires;

    private final List<AttachmentContent> attachmentsContent;

    private final String reviewStatus;

    private GetDocumentResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.versionName = builder.versionName;
        this.documentVersion = builder.documentVersion;
        this.status = builder.status;
        this.statusInformation = builder.statusInformation;
        this.content = builder.content;
        this.documentType = builder.documentType;
        this.documentFormat = builder.documentFormat;
        this.requires = builder.requires;
        this.attachmentsContent = builder.attachmentsContent;
        this.reviewStatus = builder.reviewStatus;
    }

    /**
     * <p>
     * The name of the Systems Manager document.
     * </p>
     * 
     * @return The name of the Systems Manager document.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is
     * unique across all versions of a document, and cannot be changed.
     * </p>
     * 
     * @return The version of the artifact associated with the document. For example, "Release 12, Update 6". This value
     *         is unique across all versions of a document, and cannot be changed.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The document version.
     * </p>
     * 
     * @return The document version.
     */
    public final String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
     * <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DocumentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
     *         <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.
     * @see DocumentStatus
     */
    public final DocumentStatus status() {
        return DocumentStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
     * <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link DocumentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
     *         <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.
     * @see DocumentStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A message returned by AWS Systems Manager that explains the <code>Status</code> value. For example, a
     * <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
     * "The specified S3 bucket does not exist. Verify that the URL of the S3 bucket is correct."
     * </p>
     * 
     * @return A message returned by AWS Systems Manager that explains the <code>Status</code> value. For example, a
     *         <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
     *         "The specified S3 bucket does not exist. Verify that the URL of the S3 bucket is correct."
     */
    public final String statusInformation() {
        return statusInformation;
    }

    /**
     * <p>
     * The contents of the Systems Manager document.
     * </p>
     * 
     * @return The contents of the Systems Manager document.
     */
    public final String content() {
        return content;
    }

    /**
     * <p>
     * The document type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentType} will
     * return {@link DocumentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #documentTypeAsString}.
     * </p>
     * 
     * @return The document type.
     * @see DocumentType
     */
    public final DocumentType documentType() {
        return DocumentType.fromValue(documentType);
    }

    /**
     * <p>
     * The document type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentType} will
     * return {@link DocumentType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #documentTypeAsString}.
     * </p>
     * 
     * @return The document type.
     * @see DocumentType
     */
    public final String documentTypeAsString() {
        return documentType;
    }

    /**
     * <p>
     * The document format, either JSON or YAML.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentFormat}
     * will return {@link DocumentFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentFormatAsString}.
     * </p>
     * 
     * @return The document format, either JSON or YAML.
     * @see DocumentFormat
     */
    public final DocumentFormat documentFormat() {
        return DocumentFormat.fromValue(documentFormat);
    }

    /**
     * <p>
     * The document format, either JSON or YAML.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #documentFormat}
     * will return {@link DocumentFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #documentFormatAsString}.
     * </p>
     * 
     * @return The document format, either JSON or YAML.
     * @see DocumentFormat
     */
    public final String documentFormatAsString() {
        return documentFormat;
    }

    /**
     * Returns true if the Requires property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasRequires() {
        return requires != null && !(requires instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code> document
     * requires an <code>ApplicationConfigurationSchema</code> document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequires()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code>
     *         document requires an <code>ApplicationConfigurationSchema</code> document.
     */
    public final List<DocumentRequires> requires() {
        return requires;
    }

    /**
     * Returns true if the AttachmentsContent property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAttachmentsContent() {
        return attachmentsContent != null && !(attachmentsContent instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A description of the document attachments, including names, locations, sizes, and so on.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAttachmentsContent()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A description of the document attachments, including names, locations, sizes, and so on.
     */
    public final List<AttachmentContent> attachmentsContent() {
        return attachmentsContent;
    }

    /**
     * <p>
     * The current review status of a new custom Systems Manager document (SSM document) created by a member of your
     * organization, or of the latest version of an existing SSM document.
     * </p>
     * <p>
     * Only one version of an SSM document can be in the APPROVED state at a time. When a new version is approved, the
     * status of the previous version changes to REJECTED.
     * </p>
     * <p>
     * Only one version of an SSM document can be in review, or PENDING, at a time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reviewStatus} will
     * return {@link ReviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reviewStatusAsString}.
     * </p>
     * 
     * @return The current review status of a new custom Systems Manager document (SSM document) created by a member of
     *         your organization, or of the latest version of an existing SSM document.</p>
     *         <p>
     *         Only one version of an SSM document can be in the APPROVED state at a time. When a new version is
     *         approved, the status of the previous version changes to REJECTED.
     *         </p>
     *         <p>
     *         Only one version of an SSM document can be in review, or PENDING, at a time.
     * @see ReviewStatus
     */
    public final ReviewStatus reviewStatus() {
        return ReviewStatus.fromValue(reviewStatus);
    }

    /**
     * <p>
     * The current review status of a new custom Systems Manager document (SSM document) created by a member of your
     * organization, or of the latest version of an existing SSM document.
     * </p>
     * <p>
     * Only one version of an SSM document can be in the APPROVED state at a time. When a new version is approved, the
     * status of the previous version changes to REJECTED.
     * </p>
     * <p>
     * Only one version of an SSM document can be in review, or PENDING, at a time.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reviewStatus} will
     * return {@link ReviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reviewStatusAsString}.
     * </p>
     * 
     * @return The current review status of a new custom Systems Manager document (SSM document) created by a member of
     *         your organization, or of the latest version of an existing SSM document.</p>
     *         <p>
     *         Only one version of an SSM document can be in the APPROVED state at a time. When a new version is
     *         approved, the status of the previous version changes to REJECTED.
     *         </p>
     *         <p>
     *         Only one version of an SSM document can be in review, or PENDING, at a time.
     * @see ReviewStatus
     */
    public final String reviewStatusAsString() {
        return reviewStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusInformation());
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(documentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(documentFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequires() ? requires() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttachmentsContent() ? attachmentsContent() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reviewStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDocumentResponse)) {
            return false;
        }
        GetDocumentResponse other = (GetDocumentResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusInformation(), other.statusInformation()) && Objects.equals(content(), other.content())
                && Objects.equals(documentTypeAsString(), other.documentTypeAsString())
                && Objects.equals(documentFormatAsString(), other.documentFormatAsString())
                && hasRequires() == other.hasRequires() && Objects.equals(requires(), other.requires())
                && hasAttachmentsContent() == other.hasAttachmentsContent()
                && Objects.equals(attachmentsContent(), other.attachmentsContent())
                && Objects.equals(reviewStatusAsString(), other.reviewStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDocumentResponse").add("Name", name()).add("VersionName", versionName())
                .add("DocumentVersion", documentVersion()).add("Status", statusAsString())
                .add("StatusInformation", statusInformation()).add("Content", content())
                .add("DocumentType", documentTypeAsString()).add("DocumentFormat", documentFormatAsString())
                .add("Requires", hasRequires() ? requires() : null)
                .add("AttachmentsContent", hasAttachmentsContent() ? attachmentsContent() : null)
                .add("ReviewStatus", reviewStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "VersionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusInformation":
            return Optional.ofNullable(clazz.cast(statusInformation()));
        case "Content":
            return Optional.ofNullable(clazz.cast(content()));
        case "DocumentType":
            return Optional.ofNullable(clazz.cast(documentTypeAsString()));
        case "DocumentFormat":
            return Optional.ofNullable(clazz.cast(documentFormatAsString()));
        case "Requires":
            return Optional.ofNullable(clazz.cast(requires()));
        case "AttachmentsContent":
            return Optional.ofNullable(clazz.cast(attachmentsContent()));
        case "ReviewStatus":
            return Optional.ofNullable(clazz.cast(reviewStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDocumentResponse, T> g) {
        return obj -> g.apply((GetDocumentResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDocumentResponse> {
        /**
         * <p>
         * The name of the Systems Manager document.
         * </p>
         * 
         * @param name
         *        The name of the Systems Manager document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the artifact associated with the document. For example, "Release 12, Update 6". This value is
         * unique across all versions of a document, and cannot be changed.
         * </p>
         * 
         * @param versionName
         *        The version of the artifact associated with the document. For example, "Release 12, Update 6". This
         *        value is unique across all versions of a document, and cannot be changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The document version.
         * </p>
         * 
         * @param documentVersion
         *        The document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
         * <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.
         * </p>
         * 
         * @param status
         *        The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
         *        <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.
         * @see DocumentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
         * <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.
         * </p>
         * 
         * @param status
         *        The status of the Systems Manager document, such as <code>Creating</code>, <code>Active</code>,
         *        <code>Updating</code>, <code>Failed</code>, and <code>Deleting</code>.
         * @see DocumentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentStatus
         */
        Builder status(DocumentStatus status);

        /**
         * <p>
         * A message returned by AWS Systems Manager that explains the <code>Status</code> value. For example, a
         * <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
         * "The specified S3 bucket does not exist. Verify that the URL of the S3 bucket is correct."
         * </p>
         * 
         * @param statusInformation
         *        A message returned by AWS Systems Manager that explains the <code>Status</code> value. For example, a
         *        <code>Failed</code> status might be explained by the <code>StatusInformation</code> message,
         *        "The specified S3 bucket does not exist. Verify that the URL of the S3 bucket is correct."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusInformation(String statusInformation);

        /**
         * <p>
         * The contents of the Systems Manager document.
         * </p>
         * 
         * @param content
         *        The contents of the Systems Manager document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(String content);

        /**
         * <p>
         * The document type.
         * </p>
         * 
         * @param documentType
         *        The document type.
         * @see DocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentType
         */
        Builder documentType(String documentType);

        /**
         * <p>
         * The document type.
         * </p>
         * 
         * @param documentType
         *        The document type.
         * @see DocumentType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentType
         */
        Builder documentType(DocumentType documentType);

        /**
         * <p>
         * The document format, either JSON or YAML.
         * </p>
         * 
         * @param documentFormat
         *        The document format, either JSON or YAML.
         * @see DocumentFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentFormat
         */
        Builder documentFormat(String documentFormat);

        /**
         * <p>
         * The document format, either JSON or YAML.
         * </p>
         * 
         * @param documentFormat
         *        The document format, either JSON or YAML.
         * @see DocumentFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentFormat
         */
        Builder documentFormat(DocumentFormat documentFormat);

        /**
         * <p>
         * A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code>
         * document requires an <code>ApplicationConfigurationSchema</code> document.
         * </p>
         * 
         * @param requires
         *        A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code>
         *        document requires an <code>ApplicationConfigurationSchema</code> document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requires(Collection<DocumentRequires> requires);

        /**
         * <p>
         * A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code>
         * document requires an <code>ApplicationConfigurationSchema</code> document.
         * </p>
         * 
         * @param requires
         *        A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code>
         *        document requires an <code>ApplicationConfigurationSchema</code> document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requires(DocumentRequires... requires);

        /**
         * <p>
         * A list of SSM documents required by a document. For example, an <code>ApplicationConfiguration</code>
         * document requires an <code>ApplicationConfigurationSchema</code> document.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentRequires>.Builder} avoiding the
         * need to create one manually via {@link List<DocumentRequires>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentRequires>.Builder#build()} is called immediately and
         * its result is passed to {@link #requires(List<DocumentRequires>)}.
         * 
         * @param requires
         *        a consumer that will call methods on {@link List<DocumentRequires>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requires(List<DocumentRequires>)
         */
        Builder requires(Consumer<DocumentRequires.Builder>... requires);

        /**
         * <p>
         * A description of the document attachments, including names, locations, sizes, and so on.
         * </p>
         * 
         * @param attachmentsContent
         *        A description of the document attachments, including names, locations, sizes, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentsContent(Collection<AttachmentContent> attachmentsContent);

        /**
         * <p>
         * A description of the document attachments, including names, locations, sizes, and so on.
         * </p>
         * 
         * @param attachmentsContent
         *        A description of the document attachments, including names, locations, sizes, and so on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentsContent(AttachmentContent... attachmentsContent);

        /**
         * <p>
         * A description of the document attachments, including names, locations, sizes, and so on.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AttachmentContent>.Builder} avoiding the
         * need to create one manually via {@link List<AttachmentContent>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AttachmentContent>.Builder#build()} is called immediately
         * and its result is passed to {@link #attachmentsContent(List<AttachmentContent>)}.
         * 
         * @param attachmentsContent
         *        a consumer that will call methods on {@link List<AttachmentContent>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attachmentsContent(List<AttachmentContent>)
         */
        Builder attachmentsContent(Consumer<AttachmentContent.Builder>... attachmentsContent);

        /**
         * <p>
         * The current review status of a new custom Systems Manager document (SSM document) created by a member of your
         * organization, or of the latest version of an existing SSM document.
         * </p>
         * <p>
         * Only one version of an SSM document can be in the APPROVED state at a time. When a new version is approved,
         * the status of the previous version changes to REJECTED.
         * </p>
         * <p>
         * Only one version of an SSM document can be in review, or PENDING, at a time.
         * </p>
         * 
         * @param reviewStatus
         *        The current review status of a new custom Systems Manager document (SSM document) created by a member
         *        of your organization, or of the latest version of an existing SSM document.</p>
         *        <p>
         *        Only one version of an SSM document can be in the APPROVED state at a time. When a new version is
         *        approved, the status of the previous version changes to REJECTED.
         *        </p>
         *        <p>
         *        Only one version of an SSM document can be in review, or PENDING, at a time.
         * @see ReviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewStatus
         */
        Builder reviewStatus(String reviewStatus);

        /**
         * <p>
         * The current review status of a new custom Systems Manager document (SSM document) created by a member of your
         * organization, or of the latest version of an existing SSM document.
         * </p>
         * <p>
         * Only one version of an SSM document can be in the APPROVED state at a time. When a new version is approved,
         * the status of the previous version changes to REJECTED.
         * </p>
         * <p>
         * Only one version of an SSM document can be in review, or PENDING, at a time.
         * </p>
         * 
         * @param reviewStatus
         *        The current review status of a new custom Systems Manager document (SSM document) created by a member
         *        of your organization, or of the latest version of an existing SSM document.</p>
         *        <p>
         *        Only one version of an SSM document can be in the APPROVED state at a time. When a new version is
         *        approved, the status of the previous version changes to REJECTED.
         *        </p>
         *        <p>
         *        Only one version of an SSM document can be in review, or PENDING, at a time.
         * @see ReviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewStatus
         */
        Builder reviewStatus(ReviewStatus reviewStatus);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String name;

        private String versionName;

        private String documentVersion;

        private String status;

        private String statusInformation;

        private String content;

        private String documentType;

        private String documentFormat;

        private List<DocumentRequires> requires = DefaultSdkAutoConstructList.getInstance();

        private List<AttachmentContent> attachmentsContent = DefaultSdkAutoConstructList.getInstance();

        private String reviewStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDocumentResponse model) {
            super(model);
            name(model.name);
            versionName(model.versionName);
            documentVersion(model.documentVersion);
            status(model.status);
            statusInformation(model.statusInformation);
            content(model.content);
            documentType(model.documentType);
            documentFormat(model.documentFormat);
            requires(model.requires);
            attachmentsContent(model.attachmentsContent);
            reviewStatus(model.reviewStatus);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getVersionName() {
            return versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DocumentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusInformation() {
            return statusInformation;
        }

        @Override
        public final Builder statusInformation(String statusInformation) {
            this.statusInformation = statusInformation;
            return this;
        }

        public final void setStatusInformation(String statusInformation) {
            this.statusInformation = statusInformation;
        }

        public final String getContent() {
            return content;
        }

        @Override
        public final Builder content(String content) {
            this.content = content;
            return this;
        }

        public final void setContent(String content) {
            this.content = content;
        }

        public final String getDocumentType() {
            return documentType;
        }

        @Override
        public final Builder documentType(String documentType) {
            this.documentType = documentType;
            return this;
        }

        @Override
        public final Builder documentType(DocumentType documentType) {
            this.documentType(documentType == null ? null : documentType.toString());
            return this;
        }

        public final void setDocumentType(String documentType) {
            this.documentType = documentType;
        }

        public final String getDocumentFormat() {
            return documentFormat;
        }

        @Override
        public final Builder documentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
            return this;
        }

        @Override
        public final Builder documentFormat(DocumentFormat documentFormat) {
            this.documentFormat(documentFormat == null ? null : documentFormat.toString());
            return this;
        }

        public final void setDocumentFormat(String documentFormat) {
            this.documentFormat = documentFormat;
        }

        public final List<DocumentRequires.Builder> getRequires() {
            List<DocumentRequires.Builder> result = DocumentRequiresListCopier.copyToBuilder(this.requires);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder requires(Collection<DocumentRequires> requires) {
            this.requires = DocumentRequiresListCopier.copy(requires);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requires(DocumentRequires... requires) {
            requires(Arrays.asList(requires));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requires(Consumer<DocumentRequires.Builder>... requires) {
            requires(Stream.of(requires).map(c -> DocumentRequires.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRequires(Collection<DocumentRequires.BuilderImpl> requires) {
            this.requires = DocumentRequiresListCopier.copyFromBuilder(requires);
        }

        public final List<AttachmentContent.Builder> getAttachmentsContent() {
            List<AttachmentContent.Builder> result = AttachmentContentListCopier.copyToBuilder(this.attachmentsContent);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder attachmentsContent(Collection<AttachmentContent> attachmentsContent) {
            this.attachmentsContent = AttachmentContentListCopier.copy(attachmentsContent);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentsContent(AttachmentContent... attachmentsContent) {
            attachmentsContent(Arrays.asList(attachmentsContent));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachmentsContent(Consumer<AttachmentContent.Builder>... attachmentsContent) {
            attachmentsContent(Stream.of(attachmentsContent).map(c -> AttachmentContent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAttachmentsContent(Collection<AttachmentContent.BuilderImpl> attachmentsContent) {
            this.attachmentsContent = AttachmentContentListCopier.copyFromBuilder(attachmentsContent);
        }

        public final String getReviewStatus() {
            return reviewStatus;
        }

        @Override
        public final Builder reviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
            return this;
        }

        @Override
        public final Builder reviewStatus(ReviewStatus reviewStatus) {
            this.reviewStatus(reviewStatus == null ? null : reviewStatus.toString());
            return this;
        }

        public final void setReviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
        }

        @Override
        public GetDocumentResponse build() {
            return new GetDocumentResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
