/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a filter for a specific list of instances. You can filter instances information by using tags. You specify
 * tags by using a key-value mapping.
 * </p>
 * <p>
 * Use this action instead of the <a>DescribeInstanceInformationRequest$InstanceInformationFilterList</a> method. The
 * <code>InstanceInformationFilterList</code> method is a legacy method and does not support tags.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceInformationFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<InstanceInformationFilter.Builder, InstanceInformationFilter> {
    private static final SdkField<String> KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("key")
            .getter(getter(InstanceInformationFilter::keyAsString)).setter(setter(Builder::key))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()).build();

    private static final SdkField<List<String>> VALUE_SET_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("valueSet")
            .getter(getter(InstanceInformationFilter::valueSet))
            .setter(setter(Builder::valueSet))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("valueSet").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, VALUE_SET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String key;

    private final List<String> valueSet;

    private InstanceInformationFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.valueSet = builder.valueSet;
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link InstanceInformationFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyAsString}.
     * </p>
     * 
     * @return The name of the filter.
     * @see InstanceInformationFilterKey
     */
    public final InstanceInformationFilterKey key() {
        return InstanceInformationFilterKey.fromValue(key);
    }

    /**
     * <p>
     * The name of the filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #key} will return
     * {@link InstanceInformationFilterKey#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #keyAsString}.
     * </p>
     * 
     * @return The name of the filter.
     * @see InstanceInformationFilterKey
     */
    public final String keyAsString() {
        return key;
    }

    /**
     * Returns true if the ValueSet property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasValueSet() {
        return valueSet != null && !(valueSet instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The filter values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValueSet()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The filter values.
     */
    public final List<String> valueSet() {
        return valueSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasValueSet() ? valueSet() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInformationFilter)) {
            return false;
        }
        InstanceInformationFilter other = (InstanceInformationFilter) obj;
        return Objects.equals(keyAsString(), other.keyAsString()) && hasValueSet() == other.hasValueSet()
                && Objects.equals(valueSet(), other.valueSet());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceInformationFilter").add("Key", keyAsString())
                .add("ValueSet", hasValueSet() ? valueSet() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "key":
            return Optional.ofNullable(clazz.cast(keyAsString()));
        case "valueSet":
            return Optional.ofNullable(clazz.cast(valueSet()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceInformationFilter, T> g) {
        return obj -> g.apply((InstanceInformationFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceInformationFilter> {
        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param key
         *        The name of the filter.
         * @see InstanceInformationFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInformationFilterKey
         */
        Builder key(String key);

        /**
         * <p>
         * The name of the filter.
         * </p>
         * 
         * @param key
         *        The name of the filter.
         * @see InstanceInformationFilterKey
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceInformationFilterKey
         */
        Builder key(InstanceInformationFilterKey key);

        /**
         * <p>
         * The filter values.
         * </p>
         * 
         * @param valueSet
         *        The filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueSet(Collection<String> valueSet);

        /**
         * <p>
         * The filter values.
         * </p>
         * 
         * @param valueSet
         *        The filter values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueSet(String... valueSet);
    }

    static final class BuilderImpl implements Builder {
        private String key;

        private List<String> valueSet = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInformationFilter model) {
            key(model.key);
            valueSet(model.valueSet);
        }

        public final String getKey() {
            return key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        @Override
        public final Builder key(InstanceInformationFilterKey key) {
            this.key(key == null ? null : key.toString());
            return this;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        public final Collection<String> getValueSet() {
            if (valueSet instanceof SdkAutoConstructList) {
                return null;
            }
            return valueSet;
        }

        @Override
        public final Builder valueSet(Collection<String> valueSet) {
            this.valueSet = InstanceInformationFilterValueSetCopier.copy(valueSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder valueSet(String... valueSet) {
            valueSet(Arrays.asList(valueSet));
            return this;
        }

        public final void setValueSet(Collection<String> valueSet) {
            this.valueSet = InstanceInformationFilterValueSetCopier.copy(valueSet);
        }

        @Override
        public InstanceInformationFilter build() {
            return new InstanceInformationFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
