/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetInventoryRequest extends SsmRequest implements
        ToCopyableBuilder<GetInventoryRequest.Builder, GetInventoryRequest> {
    private static final SdkField<List<InventoryFilter>> FILTERS_FIELD = SdkField
            .<List<InventoryFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(GetInventoryRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InventoryFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(InventoryFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InventoryAggregator>> AGGREGATORS_FIELD = SdkField
            .<List<InventoryAggregator>> builder(MarshallingType.LIST)
            .memberName("Aggregators")
            .getter(getter(GetInventoryRequest::aggregators))
            .setter(setter(Builder::aggregators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InventoryAggregator> builder(MarshallingType.SDK_POJO)
                                            .constructor(InventoryAggregator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResultAttribute>> RESULT_ATTRIBUTES_FIELD = SdkField
            .<List<ResultAttribute>> builder(MarshallingType.LIST)
            .memberName("ResultAttributes")
            .getter(getter(GetInventoryRequest::resultAttributes))
            .setter(setter(Builder::resultAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResultAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResultAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetInventoryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetInventoryRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD,
            AGGREGATORS_FIELD, RESULT_ATTRIBUTES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final List<InventoryFilter> filters;

    private final List<InventoryAggregator> aggregators;

    private final List<ResultAttribute> resultAttributes;

    private final String nextToken;

    private final Integer maxResults;

    private GetInventoryRequest(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.aggregators = builder.aggregators;
        this.resultAttributes = builder.resultAttributes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters. Use a filter to return a more specific list of results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more filters. Use a filter to return a more specific list of results.
     */
    public final List<InventoryFilter> filters() {
        return filters;
    }

    /**
     * Returns true if the Aggregators property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAggregators() {
        return aggregators != null && !(aggregators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an
     * expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a count of how many
     * Windows and Linux instances exist in your inventoried fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAggregators()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns counts of inventory types based on one or more expressions. For example, if you aggregate by
     *         using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a
     *         count of how many Windows and Linux instances exist in your inventoried fleet.
     */
    public final List<InventoryAggregator> aggregators() {
        return aggregators;
    }

    /**
     * Returns true if the ResultAttributes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasResultAttributes() {
        return resultAttributes != null && !(resultAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of inventory item types to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasResultAttributes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of inventory item types to return.
     */
    public final List<ResultAttribute> resultAttributes() {
        return resultAttributes;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregators() ? aggregators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResultAttributes() ? resultAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInventoryRequest)) {
            return false;
        }
        GetInventoryRequest other = (GetInventoryRequest) obj;
        return hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && hasAggregators() == other.hasAggregators() && Objects.equals(aggregators(), other.aggregators())
                && hasResultAttributes() == other.hasResultAttributes()
                && Objects.equals(resultAttributes(), other.resultAttributes()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetInventoryRequest").add("Filters", hasFilters() ? filters() : null)
                .add("Aggregators", hasAggregators() ? aggregators() : null)
                .add("ResultAttributes", hasResultAttributes() ? resultAttributes() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Aggregators":
            return Optional.ofNullable(clazz.cast(aggregators()));
        case "ResultAttributes":
            return Optional.ofNullable(clazz.cast(resultAttributes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetInventoryRequest, T> g) {
        return obj -> g.apply((GetInventoryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetInventoryRequest> {
        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<InventoryFilter> filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(InventoryFilter... filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of results.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InventoryFilter>.Builder} avoiding the need
         * to create one manually via {@link List<InventoryFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InventoryFilter>.Builder#build()} is called immediately and
         * its result is passed to {@link #filters(List<InventoryFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<InventoryFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<InventoryFilter>)
         */
        Builder filters(Consumer<InventoryFilter.Builder>... filters);

        /**
         * <p>
         * Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an
         * expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a count of how
         * many Windows and Linux instances exist in your inventoried fleet.
         * </p>
         * 
         * @param aggregators
         *        Returns counts of inventory types based on one or more expressions. For example, if you aggregate by
         *        using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see
         *        a count of how many Windows and Linux instances exist in your inventoried fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(Collection<InventoryAggregator> aggregators);

        /**
         * <p>
         * Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an
         * expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a count of how
         * many Windows and Linux instances exist in your inventoried fleet.
         * </p>
         * 
         * @param aggregators
         *        Returns counts of inventory types based on one or more expressions. For example, if you aggregate by
         *        using an expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see
         *        a count of how many Windows and Linux instances exist in your inventoried fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(InventoryAggregator... aggregators);

        /**
         * <p>
         * Returns counts of inventory types based on one or more expressions. For example, if you aggregate by using an
         * expression that uses the <code>AWS:InstanceInformation.PlatformType</code> type, you can see a count of how
         * many Windows and Linux instances exist in your inventoried fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InventoryAggregator>.Builder} avoiding the
         * need to create one manually via {@link List<InventoryAggregator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InventoryAggregator>.Builder#build()} is called immediately
         * and its result is passed to {@link #aggregators(List<InventoryAggregator>)}.
         * 
         * @param aggregators
         *        a consumer that will call methods on {@link List<InventoryAggregator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregators(List<InventoryAggregator>)
         */
        Builder aggregators(Consumer<InventoryAggregator.Builder>... aggregators);

        /**
         * <p>
         * The list of inventory item types to return.
         * </p>
         * 
         * @param resultAttributes
         *        The list of inventory item types to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultAttributes(Collection<ResultAttribute> resultAttributes);

        /**
         * <p>
         * The list of inventory item types to return.
         * </p>
         * 
         * @param resultAttributes
         *        The list of inventory item types to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultAttributes(ResultAttribute... resultAttributes);

        /**
         * <p>
         * The list of inventory item types to return.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResultAttribute>.Builder} avoiding the need
         * to create one manually via {@link List<ResultAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResultAttribute>.Builder#build()} is called immediately and
         * its result is passed to {@link #resultAttributes(List<ResultAttribute>)}.
         * 
         * @param resultAttributes
         *        a consumer that will call methods on {@link List<ResultAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultAttributes(List<ResultAttribute>)
         */
        Builder resultAttributes(Consumer<ResultAttribute.Builder>... resultAttributes);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private List<InventoryFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<InventoryAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();

        private List<ResultAttribute> resultAttributes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInventoryRequest model) {
            super(model);
            filters(model.filters);
            aggregators(model.aggregators);
            resultAttributes(model.resultAttributes);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final List<InventoryFilter.Builder> getFilters() {
            List<InventoryFilter.Builder> result = InventoryFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder filters(Collection<InventoryFilter> filters) {
            this.filters = InventoryFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(InventoryFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<InventoryFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> InventoryFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<InventoryFilter.BuilderImpl> filters) {
            this.filters = InventoryFilterListCopier.copyFromBuilder(filters);
        }

        public final List<InventoryAggregator.Builder> getAggregators() {
            List<InventoryAggregator.Builder> result = InventoryAggregatorListCopier.copyToBuilder(this.aggregators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder aggregators(Collection<InventoryAggregator> aggregators) {
            this.aggregators = InventoryAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(InventoryAggregator... aggregators) {
            aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregators(Consumer<InventoryAggregator.Builder>... aggregators) {
            aggregators(Stream.of(aggregators).map(c -> InventoryAggregator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAggregators(Collection<InventoryAggregator.BuilderImpl> aggregators) {
            this.aggregators = InventoryAggregatorListCopier.copyFromBuilder(aggregators);
        }

        public final List<ResultAttribute.Builder> getResultAttributes() {
            List<ResultAttribute.Builder> result = ResultAttributeListCopier.copyToBuilder(this.resultAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder resultAttributes(Collection<ResultAttribute> resultAttributes) {
            this.resultAttributes = ResultAttributeListCopier.copy(resultAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultAttributes(ResultAttribute... resultAttributes) {
            resultAttributes(Arrays.asList(resultAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultAttributes(Consumer<ResultAttribute.Builder>... resultAttributes) {
            resultAttributes(Stream.of(resultAttributes).map(c -> ResultAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setResultAttributes(Collection<ResultAttribute.BuilderImpl> resultAttributes) {
            this.resultAttributes = ResultAttributeListCopier.copyFromBuilder(resultAttributes);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetInventoryRequest build() {
            return new GetInventoryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
