/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the <code>AwsOrganizationsSource</code> resource data sync source. A sync source of this type can
 * synchronize data from Organizations or, if an Amazon Web Services organization isn't present, from multiple Regions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceDataSyncAwsOrganizationsSource implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceDataSyncAwsOrganizationsSource.Builder, ResourceDataSyncAwsOrganizationsSource> {
    private static final SdkField<String> ORGANIZATION_SOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OrganizationSourceType").getter(getter(ResourceDataSyncAwsOrganizationsSource::organizationSourceType))
            .setter(setter(Builder::organizationSourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationSourceType").build())
            .build();

    private static final SdkField<List<ResourceDataSyncOrganizationalUnit>> ORGANIZATIONAL_UNITS_FIELD = SdkField
            .<List<ResourceDataSyncOrganizationalUnit>> builder(MarshallingType.LIST)
            .memberName("OrganizationalUnits")
            .getter(getter(ResourceDataSyncAwsOrganizationsSource::organizationalUnits))
            .setter(setter(Builder::organizationalUnits))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationalUnits").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceDataSyncOrganizationalUnit> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceDataSyncOrganizationalUnit::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORGANIZATION_SOURCE_TYPE_FIELD, ORGANIZATIONAL_UNITS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String organizationSourceType;

    private final List<ResourceDataSyncOrganizationalUnit> organizationalUnits;

    private ResourceDataSyncAwsOrganizationsSource(BuilderImpl builder) {
        this.organizationSourceType = builder.organizationSourceType;
        this.organizationalUnits = builder.organizationalUnits;
    }

    /**
     * <p>
     * If an Amazon Web Services organization is present, this is either <code>OrganizationalUnits</code> or
     * <code>EntireOrganization</code>. For <code>OrganizationalUnits</code>, the data is aggregated from a set of
     * organization units. For <code>EntireOrganization</code>, the data is aggregated from the entire Amazon Web
     * Services organization.
     * </p>
     * 
     * @return If an Amazon Web Services organization is present, this is either <code>OrganizationalUnits</code> or
     *         <code>EntireOrganization</code>. For <code>OrganizationalUnits</code>, the data is aggregated from a set
     *         of organization units. For <code>EntireOrganization</code>, the data is aggregated from the entire Amazon
     *         Web Services organization.
     */
    public final String organizationSourceType() {
        return organizationSourceType;
    }

    /**
     * Returns true if the OrganizationalUnits property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasOrganizationalUnits() {
        return organizationalUnits != null && !(organizationalUnits instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Organizations organization units included in the sync.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasOrganizationalUnits()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Organizations organization units included in the sync.
     */
    public final List<ResourceDataSyncOrganizationalUnit> organizationalUnits() {
        return organizationalUnits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(organizationSourceType());
        hashCode = 31 * hashCode + Objects.hashCode(hasOrganizationalUnits() ? organizationalUnits() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceDataSyncAwsOrganizationsSource)) {
            return false;
        }
        ResourceDataSyncAwsOrganizationsSource other = (ResourceDataSyncAwsOrganizationsSource) obj;
        return Objects.equals(organizationSourceType(), other.organizationSourceType())
                && hasOrganizationalUnits() == other.hasOrganizationalUnits()
                && Objects.equals(organizationalUnits(), other.organizationalUnits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceDataSyncAwsOrganizationsSource").add("OrganizationSourceType", organizationSourceType())
                .add("OrganizationalUnits", hasOrganizationalUnits() ? organizationalUnits() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OrganizationSourceType":
            return Optional.ofNullable(clazz.cast(organizationSourceType()));
        case "OrganizationalUnits":
            return Optional.ofNullable(clazz.cast(organizationalUnits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ResourceDataSyncAwsOrganizationsSource, T> g) {
        return obj -> g.apply((ResourceDataSyncAwsOrganizationsSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceDataSyncAwsOrganizationsSource> {
        /**
         * <p>
         * If an Amazon Web Services organization is present, this is either <code>OrganizationalUnits</code> or
         * <code>EntireOrganization</code>. For <code>OrganizationalUnits</code>, the data is aggregated from a set of
         * organization units. For <code>EntireOrganization</code>, the data is aggregated from the entire Amazon Web
         * Services organization.
         * </p>
         * 
         * @param organizationSourceType
         *        If an Amazon Web Services organization is present, this is either <code>OrganizationalUnits</code> or
         *        <code>EntireOrganization</code>. For <code>OrganizationalUnits</code>, the data is aggregated from a
         *        set of organization units. For <code>EntireOrganization</code>, the data is aggregated from the entire
         *        Amazon Web Services organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationSourceType(String organizationSourceType);

        /**
         * <p>
         * The Organizations organization units included in the sync.
         * </p>
         * 
         * @param organizationalUnits
         *        The Organizations organization units included in the sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnits(Collection<ResourceDataSyncOrganizationalUnit> organizationalUnits);

        /**
         * <p>
         * The Organizations organization units included in the sync.
         * </p>
         * 
         * @param organizationalUnits
         *        The Organizations organization units included in the sync.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnits(ResourceDataSyncOrganizationalUnit... organizationalUnits);

        /**
         * <p>
         * The Organizations organization units included in the sync.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ResourceDataSyncOrganizationalUnit>.Builder} avoiding the need to create one manually via {@link List
         * <ResourceDataSyncOrganizationalUnit>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceDataSyncOrganizationalUnit>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #organizationalUnits(List<ResourceDataSyncOrganizationalUnit>)}.
         * 
         * @param organizationalUnits
         *        a consumer that will call methods on {@link List<ResourceDataSyncOrganizationalUnit>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationalUnits(List<ResourceDataSyncOrganizationalUnit>)
         */
        Builder organizationalUnits(Consumer<ResourceDataSyncOrganizationalUnit.Builder>... organizationalUnits);
    }

    static final class BuilderImpl implements Builder {
        private String organizationSourceType;

        private List<ResourceDataSyncOrganizationalUnit> organizationalUnits = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceDataSyncAwsOrganizationsSource model) {
            organizationSourceType(model.organizationSourceType);
            organizationalUnits(model.organizationalUnits);
        }

        public final String getOrganizationSourceType() {
            return organizationSourceType;
        }

        @Override
        public final Builder organizationSourceType(String organizationSourceType) {
            this.organizationSourceType = organizationSourceType;
            return this;
        }

        public final void setOrganizationSourceType(String organizationSourceType) {
            this.organizationSourceType = organizationSourceType;
        }

        public final List<ResourceDataSyncOrganizationalUnit.Builder> getOrganizationalUnits() {
            List<ResourceDataSyncOrganizationalUnit.Builder> result = ResourceDataSyncOrganizationalUnitListCopier
                    .copyToBuilder(this.organizationalUnits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder organizationalUnits(Collection<ResourceDataSyncOrganizationalUnit> organizationalUnits) {
            this.organizationalUnits = ResourceDataSyncOrganizationalUnitListCopier.copy(organizationalUnits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(ResourceDataSyncOrganizationalUnit... organizationalUnits) {
            organizationalUnits(Arrays.asList(organizationalUnits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnits(Consumer<ResourceDataSyncOrganizationalUnit.Builder>... organizationalUnits) {
            organizationalUnits(Stream.of(organizationalUnits)
                    .map(c -> ResourceDataSyncOrganizationalUnit.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setOrganizationalUnits(Collection<ResourceDataSyncOrganizationalUnit.BuilderImpl> organizationalUnits) {
            this.organizationalUnits = ResourceDataSyncOrganizationalUnitListCopier.copyFromBuilder(organizationalUnits);
        }

        @Override
        public ResourceDataSyncAwsOrganizationsSource build() {
            return new ResourceDataSyncAwsOrganizationsSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
