/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.InstanceAssociationOutputUrl;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceAssociationStatusInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceAssociationStatusInfo> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(InstanceAssociationStatusInfo.getter(InstanceAssociationStatusInfo::associationId)).setter(InstanceAssociationStatusInfo.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(InstanceAssociationStatusInfo.getter(InstanceAssociationStatusInfo::name)).setter(InstanceAssociationStatusInfo.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DocumentVersion").getter(InstanceAssociationStatusInfo.getter(InstanceAssociationStatusInfo::documentVersion)).setter(InstanceAssociationStatusInfo.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()}).build();
    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationVersion").getter(InstanceAssociationStatusInfo.getter(InstanceAssociationStatusInfo::associationVersion)).setter(InstanceAssociationStatusInfo.setter(Builder::associationVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(InstanceAssociationStatusInfo.getter(InstanceAssociationStatusInfo::instanceId)).setter(InstanceAssociationStatusInfo.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()}).build();
    private static final SdkField<Instant> EXECUTION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExecutionDate").getter(InstanceAssociationStatusInfo.getter(InstanceAssociationStatusInfo::executionDate)).setter(InstanceAssociationStatusInfo.setter(Builder::executionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(InstanceAssociationStatusInfo.getter(InstanceAssociationStatusInfo::status)).setter(InstanceAssociationStatusInfo.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> DETAILED_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DetailedStatus").getter(InstanceAssociationStatusInfo.getter(InstanceAssociationStatusInfo::detailedStatus)).setter(InstanceAssociationStatusInfo.setter(Builder::detailedStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DetailedStatus").build()}).build();
    private static final SdkField<String> EXECUTION_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionSummary").getter(InstanceAssociationStatusInfo.getter(InstanceAssociationStatusInfo::executionSummary)).setter(InstanceAssociationStatusInfo.setter(Builder::executionSummary)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionSummary").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(InstanceAssociationStatusInfo.getter(InstanceAssociationStatusInfo::errorCode)).setter(InstanceAssociationStatusInfo.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<InstanceAssociationOutputUrl> OUTPUT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputUrl").getter(InstanceAssociationStatusInfo.getter(InstanceAssociationStatusInfo::outputUrl)).setter(InstanceAssociationStatusInfo.setter(Builder::outputUrl)).constructor(InstanceAssociationOutputUrl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputUrl").build()}).build();
    private static final SdkField<String> ASSOCIATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationName").getter(InstanceAssociationStatusInfo.getter(InstanceAssociationStatusInfo::associationName)).setter(InstanceAssociationStatusInfo.setter(Builder::associationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD, NAME_FIELD, DOCUMENT_VERSION_FIELD, ASSOCIATION_VERSION_FIELD, INSTANCE_ID_FIELD, EXECUTION_DATE_FIELD, STATUS_FIELD, DETAILED_STATUS_FIELD, EXECUTION_SUMMARY_FIELD, ERROR_CODE_FIELD, OUTPUT_URL_FIELD, ASSOCIATION_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String associationId;
    private final String name;
    private final String documentVersion;
    private final String associationVersion;
    private final String instanceId;
    private final Instant executionDate;
    private final String status;
    private final String detailedStatus;
    private final String executionSummary;
    private final String errorCode;
    private final InstanceAssociationOutputUrl outputUrl;
    private final String associationName;

    private InstanceAssociationStatusInfo(BuilderImpl builder) {
        this.associationId = builder.associationId;
        this.name = builder.name;
        this.documentVersion = builder.documentVersion;
        this.associationVersion = builder.associationVersion;
        this.instanceId = builder.instanceId;
        this.executionDate = builder.executionDate;
        this.status = builder.status;
        this.detailedStatus = builder.detailedStatus;
        this.executionSummary = builder.executionSummary;
        this.errorCode = builder.errorCode;
        this.outputUrl = builder.outputUrl;
        this.associationName = builder.associationName;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final String name() {
        return this.name;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final String associationVersion() {
        return this.associationVersion;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final Instant executionDate() {
        return this.executionDate;
    }

    public final String status() {
        return this.status;
    }

    public final String detailedStatus() {
        return this.detailedStatus;
    }

    public final String executionSummary() {
        return this.executionSummary;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final InstanceAssociationOutputUrl outputUrl() {
        return this.outputUrl;
    }

    public final String associationName() {
        return this.associationName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.detailedStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAssociationStatusInfo)) {
            return false;
        }
        InstanceAssociationStatusInfo other = (InstanceAssociationStatusInfo)obj;
        return Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.documentVersion(), other.documentVersion()) && Objects.equals(this.associationVersion(), other.associationVersion()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.executionDate(), other.executionDate()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.detailedStatus(), other.detailedStatus()) && Objects.equals(this.executionSummary(), other.executionSummary()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.outputUrl(), other.outputUrl()) && Objects.equals(this.associationName(), other.associationName());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceAssociationStatusInfo").add("AssociationId", (Object)this.associationId()).add("Name", (Object)this.name()).add("DocumentVersion", (Object)this.documentVersion()).add("AssociationVersion", (Object)this.associationVersion()).add("InstanceId", (Object)this.instanceId()).add("ExecutionDate", (Object)this.executionDate()).add("Status", (Object)this.status()).add("DetailedStatus", (Object)this.detailedStatus()).add("ExecutionSummary", (Object)this.executionSummary()).add("ErrorCode", (Object)this.errorCode()).add("OutputUrl", (Object)this.outputUrl()).add("AssociationName", (Object)this.associationName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DocumentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "AssociationVersion": {
                return Optional.ofNullable(clazz.cast(this.associationVersion()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "ExecutionDate": {
                return Optional.ofNullable(clazz.cast(this.executionDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "DetailedStatus": {
                return Optional.ofNullable(clazz.cast(this.detailedStatus()));
            }
            case "ExecutionSummary": {
                return Optional.ofNullable(clazz.cast(this.executionSummary()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "OutputUrl": {
                return Optional.ofNullable(clazz.cast(this.outputUrl()));
            }
            case "AssociationName": {
                return Optional.ofNullable(clazz.cast(this.associationName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceAssociationStatusInfo, T> g) {
        return obj -> g.apply((InstanceAssociationStatusInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String associationId;
        private String name;
        private String documentVersion;
        private String associationVersion;
        private String instanceId;
        private Instant executionDate;
        private String status;
        private String detailedStatus;
        private String executionSummary;
        private String errorCode;
        private InstanceAssociationOutputUrl outputUrl;
        private String associationName;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAssociationStatusInfo model) {
            this.associationId(model.associationId);
            this.name(model.name);
            this.documentVersion(model.documentVersion);
            this.associationVersion(model.associationVersion);
            this.instanceId(model.instanceId);
            this.executionDate(model.executionDate);
            this.status(model.status);
            this.detailedStatus(model.detailedStatus);
            this.executionSummary(model.executionSummary);
            this.errorCode(model.errorCode);
            this.outputUrl(model.outputUrl);
            this.associationName(model.associationName);
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        public final String getAssociationVersion() {
            return this.associationVersion;
        }

        @Override
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Instant getExecutionDate() {
            return this.executionDate;
        }

        @Override
        public final Builder executionDate(Instant executionDate) {
            this.executionDate = executionDate;
            return this;
        }

        public final void setExecutionDate(Instant executionDate) {
            this.executionDate = executionDate;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getDetailedStatus() {
            return this.detailedStatus;
        }

        @Override
        public final Builder detailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
            return this;
        }

        public final void setDetailedStatus(String detailedStatus) {
            this.detailedStatus = detailedStatus;
        }

        public final String getExecutionSummary() {
            return this.executionSummary;
        }

        @Override
        public final Builder executionSummary(String executionSummary) {
            this.executionSummary = executionSummary;
            return this;
        }

        public final void setExecutionSummary(String executionSummary) {
            this.executionSummary = executionSummary;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        public final InstanceAssociationOutputUrl.Builder getOutputUrl() {
            return this.outputUrl != null ? this.outputUrl.toBuilder() : null;
        }

        @Override
        public final Builder outputUrl(InstanceAssociationOutputUrl outputUrl) {
            this.outputUrl = outputUrl;
            return this;
        }

        public final void setOutputUrl(InstanceAssociationOutputUrl.BuilderImpl outputUrl) {
            this.outputUrl = outputUrl != null ? outputUrl.build() : null;
        }

        public final String getAssociationName() {
            return this.associationName;
        }

        @Override
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        public InstanceAssociationStatusInfo build() {
            return new InstanceAssociationStatusInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceAssociationStatusInfo> {
        public Builder associationId(String var1);

        public Builder name(String var1);

        public Builder documentVersion(String var1);

        public Builder associationVersion(String var1);

        public Builder instanceId(String var1);

        public Builder executionDate(Instant var1);

        public Builder status(String var1);

        public Builder detailedStatus(String var1);

        public Builder executionSummary(String var1);

        public Builder errorCode(String var1);

        public Builder outputUrl(InstanceAssociationOutputUrl var1);

        default public Builder outputUrl(Consumer<InstanceAssociationOutputUrl.Builder> outputUrl) {
            return this.outputUrl((InstanceAssociationOutputUrl)((InstanceAssociationOutputUrl.Builder)InstanceAssociationOutputUrl.builder().applyMutation(outputUrl)).build());
        }

        public Builder associationName(String var1);
    }
}

