/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.PatchComplianceDataState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PatchComplianceData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PatchComplianceData> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(PatchComplianceData.getter(PatchComplianceData::title)).setter(PatchComplianceData.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> KB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KBId").getter(PatchComplianceData.getter(PatchComplianceData::kbId)).setter(PatchComplianceData.setter(Builder::kbId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KBId").build()}).build();
    private static final SdkField<String> CLASSIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Classification").getter(PatchComplianceData.getter(PatchComplianceData::classification)).setter(PatchComplianceData.setter(Builder::classification)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Classification").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Severity").getter(PatchComplianceData.getter(PatchComplianceData::severity)).setter(PatchComplianceData.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(PatchComplianceData.getter(PatchComplianceData::stateAsString)).setter(PatchComplianceData.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<Instant> INSTALLED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InstalledTime").getter(PatchComplianceData.getter(PatchComplianceData::installedTime)).setter(PatchComplianceData.setter(Builder::installedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstalledTime").build()}).build();
    private static final SdkField<String> CVE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CVEIds").getter(PatchComplianceData.getter(PatchComplianceData::cveIds)).setter(PatchComplianceData.setter(Builder::cveIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CVEIds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, KB_ID_FIELD, CLASSIFICATION_FIELD, SEVERITY_FIELD, STATE_FIELD, INSTALLED_TIME_FIELD, CVE_IDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String title;
    private final String kbId;
    private final String classification;
    private final String severity;
    private final String state;
    private final Instant installedTime;
    private final String cveIds;

    private PatchComplianceData(BuilderImpl builder) {
        this.title = builder.title;
        this.kbId = builder.kbId;
        this.classification = builder.classification;
        this.severity = builder.severity;
        this.state = builder.state;
        this.installedTime = builder.installedTime;
        this.cveIds = builder.cveIds;
    }

    public final String title() {
        return this.title;
    }

    public final String kbId() {
        return this.kbId;
    }

    public final String classification() {
        return this.classification;
    }

    public final String severity() {
        return this.severity;
    }

    public final PatchComplianceDataState state() {
        return PatchComplianceDataState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final Instant installedTime() {
        return this.installedTime;
    }

    public final String cveIds() {
        return this.cveIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.kbId());
        hashCode = 31 * hashCode + Objects.hashCode(this.classification());
        hashCode = 31 * hashCode + Objects.hashCode(this.severity());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.installedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.cveIds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchComplianceData)) {
            return false;
        }
        PatchComplianceData other = (PatchComplianceData)obj;
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.kbId(), other.kbId()) && Objects.equals(this.classification(), other.classification()) && Objects.equals(this.severity(), other.severity()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.installedTime(), other.installedTime()) && Objects.equals(this.cveIds(), other.cveIds());
    }

    public final String toString() {
        return ToString.builder((String)"PatchComplianceData").add("Title", (Object)this.title()).add("KBId", (Object)this.kbId()).add("Classification", (Object)this.classification()).add("Severity", (Object)this.severity()).add("State", (Object)this.stateAsString()).add("InstalledTime", (Object)this.installedTime()).add("CVEIds", (Object)this.cveIds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "KBId": {
                return Optional.ofNullable(clazz.cast(this.kbId()));
            }
            case "Classification": {
                return Optional.ofNullable(clazz.cast(this.classification()));
            }
            case "Severity": {
                return Optional.ofNullable(clazz.cast(this.severity()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "InstalledTime": {
                return Optional.ofNullable(clazz.cast(this.installedTime()));
            }
            case "CVEIds": {
                return Optional.ofNullable(clazz.cast(this.cveIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchComplianceData, T> g) {
        return obj -> g.apply((PatchComplianceData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String title;
        private String kbId;
        private String classification;
        private String severity;
        private String state;
        private Instant installedTime;
        private String cveIds;

        private BuilderImpl() {
        }

        private BuilderImpl(PatchComplianceData model) {
            this.title(model.title);
            this.kbId(model.kbId);
            this.classification(model.classification);
            this.severity(model.severity);
            this.state(model.state);
            this.installedTime(model.installedTime);
            this.cveIds(model.cveIds);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        @Transient
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getKbId() {
            return this.kbId;
        }

        public final void setKbId(String kbId) {
            this.kbId = kbId;
        }

        @Override
        @Transient
        public final Builder kbId(String kbId) {
            this.kbId = kbId;
            return this;
        }

        public final String getClassification() {
            return this.classification;
        }

        public final void setClassification(String classification) {
            this.classification = classification;
        }

        @Override
        @Transient
        public final Builder classification(String classification) {
            this.classification = classification;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        @Transient
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        @Transient
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        @Transient
        public final Builder state(PatchComplianceDataState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Instant getInstalledTime() {
            return this.installedTime;
        }

        public final void setInstalledTime(Instant installedTime) {
            this.installedTime = installedTime;
        }

        @Override
        @Transient
        public final Builder installedTime(Instant installedTime) {
            this.installedTime = installedTime;
            return this;
        }

        public final String getCveIds() {
            return this.cveIds;
        }

        public final void setCveIds(String cveIds) {
            this.cveIds = cveIds;
        }

        @Override
        @Transient
        public final Builder cveIds(String cveIds) {
            this.cveIds = cveIds;
            return this;
        }

        public PatchComplianceData build() {
            return new PatchComplianceData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PatchComplianceData> {
        public Builder title(String var1);

        public Builder kbId(String var1);

        public Builder classification(String var1);

        public Builder severity(String var1);

        public Builder state(String var1);

        public Builder state(PatchComplianceDataState var1);

        public Builder installedTime(Instant var1);

        public Builder cveIds(String var1);
    }
}

