/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisterTargetWithMaintenanceWindowResponse extends SsmResponse implements
        ToCopyableBuilder<RegisterTargetWithMaintenanceWindowResponse.Builder, RegisterTargetWithMaintenanceWindowResponse> {
    private static final SdkField<String> WINDOW_TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowTargetId").getter(getter(RegisterTargetWithMaintenanceWindowResponse::windowTargetId))
            .setter(setter(Builder::windowTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowTargetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_TARGET_ID_FIELD));

    private final String windowTargetId;

    private RegisterTargetWithMaintenanceWindowResponse(BuilderImpl builder) {
        super(builder);
        this.windowTargetId = builder.windowTargetId;
    }

    /**
     * <p>
     * The ID of the target definition in this maintenance window.
     * </p>
     * 
     * @return The ID of the target definition in this maintenance window.
     */
    public final String windowTargetId() {
        return windowTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(windowTargetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTargetWithMaintenanceWindowResponse)) {
            return false;
        }
        RegisterTargetWithMaintenanceWindowResponse other = (RegisterTargetWithMaintenanceWindowResponse) obj;
        return Objects.equals(windowTargetId(), other.windowTargetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisterTargetWithMaintenanceWindowResponse").add("WindowTargetId", windowTargetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowTargetId":
            return Optional.ofNullable(clazz.cast(windowTargetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisterTargetWithMaintenanceWindowResponse, T> g) {
        return obj -> g.apply((RegisterTargetWithMaintenanceWindowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, RegisterTargetWithMaintenanceWindowResponse> {
        /**
         * <p>
         * The ID of the target definition in this maintenance window.
         * </p>
         * 
         * @param windowTargetId
         *        The ID of the target definition in this maintenance window.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTargetId(String windowTargetId);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String windowTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisterTargetWithMaintenanceWindowResponse model) {
            super(model);
            windowTargetId(model.windowTargetId);
        }

        public final String getWindowTargetId() {
            return windowTargetId;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        @Override
        @Transient
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        @Override
        public RegisterTargetWithMaintenanceWindowResponse build() {
            return new RegisterTargetWithMaintenanceWindowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
