/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyDocumentPermissionRequest extends SsmRequest implements
        ToCopyableBuilder<ModifyDocumentPermissionRequest.Builder, ModifyDocumentPermissionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ModifyDocumentPermissionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> PERMISSION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PermissionType").getter(getter(ModifyDocumentPermissionRequest::permissionTypeAsString))
            .setter(setter(Builder::permissionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionType").build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIdsToAdd")
            .getter(getter(ModifyDocumentPermissionRequest::accountIdsToAdd))
            .setter(setter(Builder::accountIdsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIdsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ACCOUNT_IDS_TO_REMOVE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AccountIdsToRemove")
            .getter(getter(ModifyDocumentPermissionRequest::accountIdsToRemove))
            .setter(setter(Builder::accountIdsToRemove))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountIdsToRemove").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SHARED_DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SharedDocumentVersion").getter(getter(ModifyDocumentPermissionRequest::sharedDocumentVersion))
            .setter(setter(Builder::sharedDocumentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedDocumentVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            PERMISSION_TYPE_FIELD, ACCOUNT_IDS_TO_ADD_FIELD, ACCOUNT_IDS_TO_REMOVE_FIELD, SHARED_DOCUMENT_VERSION_FIELD));

    private final String name;

    private final String permissionType;

    private final List<String> accountIdsToAdd;

    private final List<String> accountIdsToRemove;

    private final String sharedDocumentVersion;

    private ModifyDocumentPermissionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.permissionType = builder.permissionType;
        this.accountIdsToAdd = builder.accountIdsToAdd;
        this.accountIdsToRemove = builder.accountIdsToRemove;
        this.sharedDocumentVersion = builder.sharedDocumentVersion;
    }

    /**
     * <p>
     * The name of the document that you want to share.
     * </p>
     * 
     * @return The name of the document that you want to share.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The permission type for the document. The permission type can be <i>Share</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link DocumentPermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return The permission type for the document. The permission type can be <i>Share</i>.
     * @see DocumentPermissionType
     */
    public final DocumentPermissionType permissionType() {
        return DocumentPermissionType.fromValue(permissionType);
    }

    /**
     * <p>
     * The permission type for the document. The permission type can be <i>Share</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permissionType}
     * will return {@link DocumentPermissionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #permissionTypeAsString}.
     * </p>
     * 
     * @return The permission type for the document. The permission type can be <i>Share</i>.
     * @see DocumentPermissionType
     */
    public final String permissionTypeAsString() {
        return permissionType;
    }

    /**
     * Returns true if the AccountIdsToAdd property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAccountIdsToAdd() {
        return accountIdsToAdd != null && !(accountIdsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services user accounts that should have access to the document. The account IDs can either be a
     * group of account IDs or <i>All</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountIdsToAdd()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Web Services user accounts that should have access to the document. The account IDs can either
     *         be a group of account IDs or <i>All</i>.
     */
    public final List<String> accountIdsToAdd() {
        return accountIdsToAdd;
    }

    /**
     * Returns true if the AccountIdsToRemove property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAccountIdsToRemove() {
        return accountIdsToRemove != null && !(accountIdsToRemove instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web Services
     * user account can either be a group of account IDs or <i>All</i>. This action has a higher priority than
     * <i>AccountIdsToAdd</i>. If you specify an account ID to add and the same ID to remove, the system removes access
     * to the document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAccountIdsToRemove()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web
     *         Services user account can either be a group of account IDs or <i>All</i>. This action has a higher
     *         priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add and the same ID to remove, the
     *         system removes access to the document.
     */
    public final List<String> accountIdsToRemove() {
        return accountIdsToRemove;
    }

    /**
     * <p>
     * (Optional) The version of the document to share. If it isn't specified, the system choose the
     * <code>Default</code> version to share.
     * </p>
     * 
     * @return (Optional) The version of the document to share. If it isn't specified, the system choose the
     *         <code>Default</code> version to share.
     */
    public final String sharedDocumentVersion() {
        return sharedDocumentVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(permissionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIdsToAdd() ? accountIdsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAccountIdsToRemove() ? accountIdsToRemove() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sharedDocumentVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyDocumentPermissionRequest)) {
            return false;
        }
        ModifyDocumentPermissionRequest other = (ModifyDocumentPermissionRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(permissionTypeAsString(), other.permissionTypeAsString())
                && hasAccountIdsToAdd() == other.hasAccountIdsToAdd()
                && Objects.equals(accountIdsToAdd(), other.accountIdsToAdd())
                && hasAccountIdsToRemove() == other.hasAccountIdsToRemove()
                && Objects.equals(accountIdsToRemove(), other.accountIdsToRemove())
                && Objects.equals(sharedDocumentVersion(), other.sharedDocumentVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyDocumentPermissionRequest").add("Name", name())
                .add("PermissionType", permissionTypeAsString())
                .add("AccountIdsToAdd", hasAccountIdsToAdd() ? accountIdsToAdd() : null)
                .add("AccountIdsToRemove", hasAccountIdsToRemove() ? accountIdsToRemove() : null)
                .add("SharedDocumentVersion", sharedDocumentVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "PermissionType":
            return Optional.ofNullable(clazz.cast(permissionTypeAsString()));
        case "AccountIdsToAdd":
            return Optional.ofNullable(clazz.cast(accountIdsToAdd()));
        case "AccountIdsToRemove":
            return Optional.ofNullable(clazz.cast(accountIdsToRemove()));
        case "SharedDocumentVersion":
            return Optional.ofNullable(clazz.cast(sharedDocumentVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyDocumentPermissionRequest, T> g) {
        return obj -> g.apply((ModifyDocumentPermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, ModifyDocumentPermissionRequest> {
        /**
         * <p>
         * The name of the document that you want to share.
         * </p>
         * 
         * @param name
         *        The name of the document that you want to share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The permission type for the document. The permission type can be <i>Share</i>.
         * </p>
         * 
         * @param permissionType
         *        The permission type for the document. The permission type can be <i>Share</i>.
         * @see DocumentPermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentPermissionType
         */
        Builder permissionType(String permissionType);

        /**
         * <p>
         * The permission type for the document. The permission type can be <i>Share</i>.
         * </p>
         * 
         * @param permissionType
         *        The permission type for the document. The permission type can be <i>Share</i>.
         * @see DocumentPermissionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DocumentPermissionType
         */
        Builder permissionType(DocumentPermissionType permissionType);

        /**
         * <p>
         * The Amazon Web Services user accounts that should have access to the document. The account IDs can either be
         * a group of account IDs or <i>All</i>.
         * </p>
         * 
         * @param accountIdsToAdd
         *        The Amazon Web Services user accounts that should have access to the document. The account IDs can
         *        either be a group of account IDs or <i>All</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdsToAdd(Collection<String> accountIdsToAdd);

        /**
         * <p>
         * The Amazon Web Services user accounts that should have access to the document. The account IDs can either be
         * a group of account IDs or <i>All</i>.
         * </p>
         * 
         * @param accountIdsToAdd
         *        The Amazon Web Services user accounts that should have access to the document. The account IDs can
         *        either be a group of account IDs or <i>All</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdsToAdd(String... accountIdsToAdd);

        /**
         * <p>
         * The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web
         * Services user account can either be a group of account IDs or <i>All</i>. This action has a higher priority
         * than <i>AccountIdsToAdd</i>. If you specify an account ID to add and the same ID to remove, the system
         * removes access to the document.
         * </p>
         * 
         * @param accountIdsToRemove
         *        The Amazon Web Services user accounts that should no longer have access to the document. The Amazon
         *        Web Services user account can either be a group of account IDs or <i>All</i>. This action has a higher
         *        priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add and the same ID to remove,
         *        the system removes access to the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdsToRemove(Collection<String> accountIdsToRemove);

        /**
         * <p>
         * The Amazon Web Services user accounts that should no longer have access to the document. The Amazon Web
         * Services user account can either be a group of account IDs or <i>All</i>. This action has a higher priority
         * than <i>AccountIdsToAdd</i>. If you specify an account ID to add and the same ID to remove, the system
         * removes access to the document.
         * </p>
         * 
         * @param accountIdsToRemove
         *        The Amazon Web Services user accounts that should no longer have access to the document. The Amazon
         *        Web Services user account can either be a group of account IDs or <i>All</i>. This action has a higher
         *        priority than <i>AccountIdsToAdd</i>. If you specify an account ID to add and the same ID to remove,
         *        the system removes access to the document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountIdsToRemove(String... accountIdsToRemove);

        /**
         * <p>
         * (Optional) The version of the document to share. If it isn't specified, the system choose the
         * <code>Default</code> version to share.
         * </p>
         * 
         * @param sharedDocumentVersion
         *        (Optional) The version of the document to share. If it isn't specified, the system choose the
         *        <code>Default</code> version to share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedDocumentVersion(String sharedDocumentVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String name;

        private String permissionType;

        private List<String> accountIdsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> accountIdsToRemove = DefaultSdkAutoConstructList.getInstance();

        private String sharedDocumentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyDocumentPermissionRequest model) {
            super(model);
            name(model.name);
            permissionType(model.permissionType);
            accountIdsToAdd(model.accountIdsToAdd);
            accountIdsToRemove(model.accountIdsToRemove);
            sharedDocumentVersion(model.sharedDocumentVersion);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPermissionType() {
            return permissionType;
        }

        public final void setPermissionType(String permissionType) {
            this.permissionType = permissionType;
        }

        @Override
        @Transient
        public final Builder permissionType(String permissionType) {
            this.permissionType = permissionType;
            return this;
        }

        @Override
        @Transient
        public final Builder permissionType(DocumentPermissionType permissionType) {
            this.permissionType(permissionType == null ? null : permissionType.toString());
            return this;
        }

        public final Collection<String> getAccountIdsToAdd() {
            if (accountIdsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIdsToAdd;
        }

        public final void setAccountIdsToAdd(Collection<String> accountIdsToAdd) {
            this.accountIdsToAdd = AccountIdListCopier.copy(accountIdsToAdd);
        }

        @Override
        @Transient
        public final Builder accountIdsToAdd(Collection<String> accountIdsToAdd) {
            this.accountIdsToAdd = AccountIdListCopier.copy(accountIdsToAdd);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accountIdsToAdd(String... accountIdsToAdd) {
            accountIdsToAdd(Arrays.asList(accountIdsToAdd));
            return this;
        }

        public final Collection<String> getAccountIdsToRemove() {
            if (accountIdsToRemove instanceof SdkAutoConstructList) {
                return null;
            }
            return accountIdsToRemove;
        }

        public final void setAccountIdsToRemove(Collection<String> accountIdsToRemove) {
            this.accountIdsToRemove = AccountIdListCopier.copy(accountIdsToRemove);
        }

        @Override
        @Transient
        public final Builder accountIdsToRemove(Collection<String> accountIdsToRemove) {
            this.accountIdsToRemove = AccountIdListCopier.copy(accountIdsToRemove);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder accountIdsToRemove(String... accountIdsToRemove) {
            accountIdsToRemove(Arrays.asList(accountIdsToRemove));
            return this;
        }

        public final String getSharedDocumentVersion() {
            return sharedDocumentVersion;
        }

        public final void setSharedDocumentVersion(String sharedDocumentVersion) {
            this.sharedDocumentVersion = sharedDocumentVersion;
        }

        @Override
        @Transient
        public final Builder sharedDocumentVersion(String sharedDocumentVersion) {
            this.sharedDocumentVersion = sharedDocumentVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyDocumentPermissionRequest build() {
            return new ModifyDocumentPermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
