/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceRequest;
import software.amazon.awssdk.services.ssm.model.AddTagsToResourceResponse;
import software.amazon.awssdk.services.ssm.model.AlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemRequest;
import software.amazon.awssdk.services.ssm.model.AssociateOpsItemRelatedItemResponse;
import software.amazon.awssdk.services.ssm.model.AssociatedInstancesException;
import software.amazon.awssdk.services.ssm.model.AssociationAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.AssociationDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.AssociationExecutionDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.AssociationLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AssociationVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionNotApprovedException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationDefinitionVersionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionNotFoundException;
import software.amazon.awssdk.services.ssm.model.AutomationStepNotFoundException;
import software.amazon.awssdk.services.ssm.model.CancelCommandRequest;
import software.amazon.awssdk.services.ssm.model.CancelCommandResponse;
import software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionRequest;
import software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionResponse;
import software.amazon.awssdk.services.ssm.model.ComplianceTypeCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.CreateActivationRequest;
import software.amazon.awssdk.services.ssm.model.CreateActivationResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationBatchResponse;
import software.amazon.awssdk.services.ssm.model.CreateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.CreateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.CreateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.CreateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.CreateOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.CreateOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.CreateOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.CreateOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.CreatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.CustomSchemaCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DeleteActivationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteActivationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DeleteAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DeleteDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DeleteInventoryRequest;
import software.amazon.awssdk.services.ssm.model.DeleteInventoryResponse;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeleteMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeleteOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.DeleteOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParameterRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParameterResponse;
import software.amazon.awssdk.services.ssm.model.DeleteParametersRequest;
import software.amazon.awssdk.services.ssm.model.DeleteParametersResponse;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DeletePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.DeleteResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterManagedInstanceResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.DeregisterTaskFromMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAssociationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentRequest;
import software.amazon.awssdk.services.ssm.model.DescribeDocumentResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse;
import software.amazon.awssdk.services.ssm.model.DescribeParametersRequest;
import software.amazon.awssdk.services.ssm.model.DescribeParametersResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest;
import software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest;
import software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse;
import software.amazon.awssdk.services.ssm.model.DisassociateOpsItemRelatedItemRequest;
import software.amazon.awssdk.services.ssm.model.DisassociateOpsItemRelatedItemResponse;
import software.amazon.awssdk.services.ssm.model.DocumentAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.DocumentLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DocumentPermissionLimitException;
import software.amazon.awssdk.services.ssm.model.DocumentVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.DoesNotExistException;
import software.amazon.awssdk.services.ssm.model.DuplicateDocumentContentException;
import software.amazon.awssdk.services.ssm.model.DuplicateDocumentVersionNameException;
import software.amazon.awssdk.services.ssm.model.DuplicateInstanceIdException;
import software.amazon.awssdk.services.ssm.model.FeatureNotAvailableException;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetCalendarStateRequest;
import software.amazon.awssdk.services.ssm.model.GetCalendarStateResponse;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetCommandInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetConnectionStatusRequest;
import software.amazon.awssdk.services.ssm.model.GetConnectionStatusResponse;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceRequest;
import software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse;
import software.amazon.awssdk.services.ssm.model.GetDocumentRequest;
import software.amazon.awssdk.services.ssm.model.GetDocumentResponse;
import software.amazon.awssdk.services.ssm.model.GetInventoryRequest;
import software.amazon.awssdk.services.ssm.model.GetInventoryResponse;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest;
import software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskInvocationResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskRequest;
import software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowTaskResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest;
import software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse;
import software.amazon.awssdk.services.ssm.model.GetParameterRequest;
import software.amazon.awssdk.services.ssm.model.GetParameterResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse;
import software.amazon.awssdk.services.ssm.model.GetParametersRequest;
import software.amazon.awssdk.services.ssm.model.GetParametersResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.GetPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.GetServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.GetServiceSettingResponse;
import software.amazon.awssdk.services.ssm.model.HierarchyLevelLimitExceededException;
import software.amazon.awssdk.services.ssm.model.HierarchyTypeMismatchException;
import software.amazon.awssdk.services.ssm.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.ssm.model.IncompatiblePolicyException;
import software.amazon.awssdk.services.ssm.model.InternalServerErrorException;
import software.amazon.awssdk.services.ssm.model.InvalidActivationException;
import software.amazon.awssdk.services.ssm.model.InvalidActivationIdException;
import software.amazon.awssdk.services.ssm.model.InvalidAggregatorException;
import software.amazon.awssdk.services.ssm.model.InvalidAllowedPatternException;
import software.amazon.awssdk.services.ssm.model.InvalidAssociationException;
import software.amazon.awssdk.services.ssm.model.InvalidAssociationVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationExecutionParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationSignalException;
import software.amazon.awssdk.services.ssm.model.InvalidAutomationStatusUpdateException;
import software.amazon.awssdk.services.ssm.model.InvalidCommandIdException;
import software.amazon.awssdk.services.ssm.model.InvalidDeleteInventoryParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidDeletionIdException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentContentException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentOperationException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentSchemaVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidDocumentVersionException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterKeyException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterOptionException;
import software.amazon.awssdk.services.ssm.model.InvalidFilterValueException;
import software.amazon.awssdk.services.ssm.model.InvalidInstanceIdException;
import software.amazon.awssdk.services.ssm.model.InvalidInstanceInformationFilterValueException;
import software.amazon.awssdk.services.ssm.model.InvalidInventoryGroupException;
import software.amazon.awssdk.services.ssm.model.InvalidInventoryItemContextException;
import software.amazon.awssdk.services.ssm.model.InvalidInventoryRequestException;
import software.amazon.awssdk.services.ssm.model.InvalidItemContentException;
import software.amazon.awssdk.services.ssm.model.InvalidKeyIdException;
import software.amazon.awssdk.services.ssm.model.InvalidNextTokenException;
import software.amazon.awssdk.services.ssm.model.InvalidNotificationConfigException;
import software.amazon.awssdk.services.ssm.model.InvalidOptionException;
import software.amazon.awssdk.services.ssm.model.InvalidOutputFolderException;
import software.amazon.awssdk.services.ssm.model.InvalidOutputLocationException;
import software.amazon.awssdk.services.ssm.model.InvalidParametersException;
import software.amazon.awssdk.services.ssm.model.InvalidPermissionTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidPluginNameException;
import software.amazon.awssdk.services.ssm.model.InvalidPolicyAttributeException;
import software.amazon.awssdk.services.ssm.model.InvalidPolicyTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidResourceIdException;
import software.amazon.awssdk.services.ssm.model.InvalidResourceTypeException;
import software.amazon.awssdk.services.ssm.model.InvalidResultAttributeException;
import software.amazon.awssdk.services.ssm.model.InvalidRoleException;
import software.amazon.awssdk.services.ssm.model.InvalidScheduleException;
import software.amazon.awssdk.services.ssm.model.InvalidTargetException;
import software.amazon.awssdk.services.ssm.model.InvalidTypeNameException;
import software.amazon.awssdk.services.ssm.model.InvalidUpdateException;
import software.amazon.awssdk.services.ssm.model.InvocationDoesNotExistException;
import software.amazon.awssdk.services.ssm.model.ItemContentMismatchException;
import software.amazon.awssdk.services.ssm.model.ItemSizeLimitExceededException;
import software.amazon.awssdk.services.ssm.model.LabelParameterVersionRequest;
import software.amazon.awssdk.services.ssm.model.LabelParameterVersionResponse;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListAssociationsRequest;
import software.amazon.awssdk.services.ssm.model.ListAssociationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse;
import software.amazon.awssdk.services.ssm.model.ListCommandsRequest;
import software.amazon.awssdk.services.ssm.model.ListCommandsResponse;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentMetadataHistoryResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse;
import software.amazon.awssdk.services.ssm.model.ListDocumentsRequest;
import software.amazon.awssdk.services.ssm.model.ListDocumentsResponse;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesRequest;
import software.amazon.awssdk.services.ssm.model.ListInventoryEntriesResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.ssm.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.ssm.model.MaxDocumentSizeExceededException;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionRequest;
import software.amazon.awssdk.services.ssm.model.ModifyDocumentPermissionResponse;
import software.amazon.awssdk.services.ssm.model.OpsItemAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.OpsItemInvalidParameterException;
import software.amazon.awssdk.services.ssm.model.OpsItemLimitExceededException;
import software.amazon.awssdk.services.ssm.model.OpsItemNotFoundException;
import software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.OpsItemRelatedItemAssociationNotFoundException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataInvalidArgumentException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataKeyLimitExceededException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataLimitExceededException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataNotFoundException;
import software.amazon.awssdk.services.ssm.model.OpsMetadataTooManyUpdatesException;
import software.amazon.awssdk.services.ssm.model.ParameterAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.ParameterLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterMaxVersionLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterNotFoundException;
import software.amazon.awssdk.services.ssm.model.ParameterPatternMismatchException;
import software.amazon.awssdk.services.ssm.model.ParameterVersionLabelLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ParameterVersionNotFoundException;
import software.amazon.awssdk.services.ssm.model.PoliciesLimitExceededException;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.PutComplianceItemsResponse;
import software.amazon.awssdk.services.ssm.model.PutInventoryRequest;
import software.amazon.awssdk.services.ssm.model.PutInventoryResponse;
import software.amazon.awssdk.services.ssm.model.PutParameterRequest;
import software.amazon.awssdk.services.ssm.model.PutParameterResponse;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.RegisterDefaultPatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupRequest;
import software.amazon.awssdk.services.ssm.model.RegisterPatchBaselineForPatchGroupResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceRequest;
import software.amazon.awssdk.services.ssm.model.RemoveTagsFromResourceResponse;
import software.amazon.awssdk.services.ssm.model.ResetServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.ResetServiceSettingResponse;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncAlreadyExistsException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncConflictException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncCountExceededException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncInvalidConfigurationException;
import software.amazon.awssdk.services.ssm.model.ResourceDataSyncNotFoundException;
import software.amazon.awssdk.services.ssm.model.ResourceInUseException;
import software.amazon.awssdk.services.ssm.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.ssm.model.ResumeSessionRequest;
import software.amazon.awssdk.services.ssm.model.ResumeSessionResponse;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalRequest;
import software.amazon.awssdk.services.ssm.model.SendAutomationSignalResponse;
import software.amazon.awssdk.services.ssm.model.SendCommandRequest;
import software.amazon.awssdk.services.ssm.model.SendCommandResponse;
import software.amazon.awssdk.services.ssm.model.ServiceSettingNotFoundException;
import software.amazon.awssdk.services.ssm.model.SsmException;
import software.amazon.awssdk.services.ssm.model.SsmRequest;
import software.amazon.awssdk.services.ssm.model.StartAssociationsOnceRequest;
import software.amazon.awssdk.services.ssm.model.StartAssociationsOnceResponse;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StartAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StartChangeRequestExecutionResponse;
import software.amazon.awssdk.services.ssm.model.StartSessionRequest;
import software.amazon.awssdk.services.ssm.model.StartSessionResponse;
import software.amazon.awssdk.services.ssm.model.StatusUnchangedException;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionRequest;
import software.amazon.awssdk.services.ssm.model.StopAutomationExecutionResponse;
import software.amazon.awssdk.services.ssm.model.SubTypeCountLimitExceededException;
import software.amazon.awssdk.services.ssm.model.TargetInUseException;
import software.amazon.awssdk.services.ssm.model.TargetNotConnectedException;
import software.amazon.awssdk.services.ssm.model.TerminateSessionRequest;
import software.amazon.awssdk.services.ssm.model.TerminateSessionResponse;
import software.amazon.awssdk.services.ssm.model.TooManyTagsErrorException;
import software.amazon.awssdk.services.ssm.model.TooManyUpdatesException;
import software.amazon.awssdk.services.ssm.model.TotalSizeLimitExceededException;
import software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionRequest;
import software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionResponse;
import software.amazon.awssdk.services.ssm.model.UnsupportedCalendarException;
import software.amazon.awssdk.services.ssm.model.UnsupportedFeatureRequiredException;
import software.amazon.awssdk.services.ssm.model.UnsupportedInventoryItemContextException;
import software.amazon.awssdk.services.ssm.model.UnsupportedInventorySchemaVersionException;
import software.amazon.awssdk.services.ssm.model.UnsupportedOperatingSystemException;
import software.amazon.awssdk.services.ssm.model.UnsupportedParameterTypeException;
import software.amazon.awssdk.services.ssm.model.UnsupportedPlatformTypeException;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationResponse;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusRequest;
import software.amazon.awssdk.services.ssm.model.UpdateAssociationStatusResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentDefaultVersionResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentMetadataResponse;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentRequest;
import software.amazon.awssdk.services.ssm.model.UpdateDocumentResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTargetResponse;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskRequest;
import software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskResponse;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleRequest;
import software.amazon.awssdk.services.ssm.model.UpdateManagedInstanceRoleResponse;
import software.amazon.awssdk.services.ssm.model.UpdateOpsItemRequest;
import software.amazon.awssdk.services.ssm.model.UpdateOpsItemResponse;
import software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataRequest;
import software.amazon.awssdk.services.ssm.model.UpdateOpsMetadataResponse;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineRequest;
import software.amazon.awssdk.services.ssm.model.UpdatePatchBaselineResponse;
import software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncRequest;
import software.amazon.awssdk.services.ssm.model.UpdateResourceDataSyncResponse;
import software.amazon.awssdk.services.ssm.model.UpdateServiceSettingRequest;
import software.amazon.awssdk.services.ssm.model.UpdateServiceSettingResponse;
import software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselineIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowScheduleIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesIterable;
import software.amazon.awssdk.services.ssm.paginators.DescribeSessionsIterable;
import software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable;
import software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable;
import software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryIterable;
import software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryIterable;
import software.amazon.awssdk.services.ssm.paginators.GetParametersByPathIterable;
import software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable;
import software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListOpsItemRelatedItemsIterable;
import software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataIterable;
import software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable;
import software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncIterable;
import software.amazon.awssdk.services.ssm.transform.AddTagsToResourceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.AssociateOpsItemRelatedItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CancelCommandRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CancelMaintenanceWindowExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateActivationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateAssociationBatchRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateOpsItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreatePatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.CreateResourceDataSyncRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteActivationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteInventoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteParameterRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteParametersRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeletePatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeleteResourceDataSyncRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterManagedInstanceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterPatchBaselineForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterTargetFromMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DeregisterTaskFromMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeActivationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAssociationExecutionTargetsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAssociationExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAutomationExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAutomationStepExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeAvailablePatchesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeDocumentPermissionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeEffectiveInstanceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeEffectivePatchesForPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstanceAssociationsStatusRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstanceInformationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchStatesForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchStatesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInstancePatchesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeInventoryDeletionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionTaskInvocationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionTasksRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowExecutionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowScheduleRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowTargetsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowTasksRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowsForTargetRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeMaintenanceWindowsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeOpsItemsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeParametersRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchBaselinesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchGroupStateRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchGroupsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribePatchPropertiesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DescribeSessionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.DisassociateOpsItemRelatedItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetAutomationExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetCalendarStateRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetCommandInvocationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetConnectionStatusRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDefaultPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDeployablePatchSnapshotForInstanceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetInventoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetInventorySchemaRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionTaskInvocationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowExecutionTaskRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetMaintenanceWindowTaskRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetOpsItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetOpsSummaryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParameterHistoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParameterRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParametersByPathRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetParametersRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetPatchBaselineForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.GetServiceSettingRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.LabelParameterVersionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListAssociationVersionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListAssociationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListCommandInvocationsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListCommandsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListComplianceItemsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListComplianceSummariesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentMetadataHistoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentVersionsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListDocumentsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListInventoryEntriesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListOpsItemEventsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListOpsItemRelatedItemsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListResourceComplianceSummariesRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListResourceDataSyncRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ModifyDocumentPermissionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.PutComplianceItemsRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.PutInventoryRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.PutParameterRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterDefaultPatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterPatchBaselineForPatchGroupRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterTargetWithMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RegisterTaskWithMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.RemoveTagsFromResourceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ResetServiceSettingRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.ResumeSessionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.SendAutomationSignalRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.SendCommandRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartAssociationsOnceRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartAutomationExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartChangeRequestExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StartSessionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.StopAutomationExecutionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.TerminateSessionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UnlabelParameterVersionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateAssociationRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateAssociationStatusRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentDefaultVersionRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateDocumentRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateMaintenanceWindowRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateMaintenanceWindowTargetRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateMaintenanceWindowTaskRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateManagedInstanceRoleRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateOpsItemRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateOpsMetadataRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdatePatchBaselineRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateResourceDataSyncRequestMarshaller;
import software.amazon.awssdk.services.ssm.transform.UpdateServiceSettingRequestMarshaller;
import software.amazon.awssdk.services.ssm.waiters.SsmWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link SsmClient}.
 *
 * @see SsmClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSsmClient implements SsmClient {
    private static final Logger log = Logger.loggerFor(DefaultSsmClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSsmClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified resource. Tags are metadata that you can assign to your
     * documents, managed nodes, maintenance windows, Parameter Store parameters, and patch baselines. Tags enable you
     * to categorize your resources in different ways, for example, by purpose, owner, or environment. Each tag consists
     * of a key and an optional value, both of which you define. For example, you could define a set of tags for your
     * account's managed nodes that helps you track each node's owner and stack level. For example:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=Owner,Value=DbAdmin</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Owner,Value=SysAdmin</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Owner,Value=Dev</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Stack,Value=Production</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Stack,Value=Pre-Production</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=Stack,Value=Test</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Each resource can have a maximum of 50 tags.
     * </p>
     * <p>
     * We recommend that you devise a set of tag keys that meets your needs for each resource type. Using a consistent
     * set of tag keys makes it easier for you to manage your resources. You can search and filter the resources based
     * on the tags you add. Tags don't have any semantic meaning to and are interpreted strictly as a string of
     * characters.
     * </p>
     * <p>
     * For more information about using tags with Amazon Elastic Compute Cloud (Amazon EC2) instances, see <a
     * href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html">Tagging your Amazon EC2 resources</a>
     * in the <i>Amazon EC2 User Guide</i>.
     * </p>
     *
     * @param addTagsToResourceRequest
     * @return Result of the AddTagsToResource operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the instance
     *         must be a registered managed node.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyTagsErrorException
     *         The <code>Targets</code> parameter includes too many tags. Remove one or more tags and try the command
     *         again.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.AddTagsToResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AddTagsToResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AddTagsToResourceResponse addTagsToResource(AddTagsToResourceRequest addTagsToResourceRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException,
            TooManyTagsErrorException, TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AddTagsToResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AddTagsToResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, addTagsToResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AddTagsToResource");

            return clientHandler.execute(new ClientExecutionParams<AddTagsToResourceRequest, AddTagsToResourceResponse>()
                    .withOperationName("AddTagsToResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(addTagsToResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AddTagsToResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates a related item to a Systems Manager OpsCenter OpsItem. For example, you can associate an Incident
     * Manager incident or analysis with an OpsItem. Incident Manager and OpsCenter are capabilities of Amazon Web
     * Services Systems Manager.
     * </p>
     *
     * @param associateOpsItemRelatedItemRequest
     * @return Result of the AssociateOpsItemRelatedItem operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a
     *         href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws OpsItemRelatedItemAlreadyExistsException
     *         The Amazon Resource Name (ARN) is already associated with the OpsItem.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.AssociateOpsItemRelatedItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/AssociateOpsItemRelatedItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateOpsItemRelatedItemResponse associateOpsItemRelatedItem(
            AssociateOpsItemRelatedItemRequest associateOpsItemRelatedItemRequest) throws InternalServerErrorException,
            OpsItemNotFoundException, OpsItemLimitExceededException, OpsItemInvalidParameterException,
            OpsItemRelatedItemAlreadyExistsException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateOpsItemRelatedItemResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateOpsItemRelatedItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateOpsItemRelatedItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateOpsItemRelatedItem");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateOpsItemRelatedItemRequest, AssociateOpsItemRelatedItemResponse>()
                            .withOperationName("AssociateOpsItemRelatedItem").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(associateOpsItemRelatedItemRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateOpsItemRelatedItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Attempts to cancel the command specified by the Command ID. There is no guarantee that the command will be
     * terminated and the underlying process stopped.
     * </p>
     *
     * @param cancelCommandRequest
     * @return Result of the CancelCommand operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     *         The specified command ID isn't valid. Verify the ID and try again.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws DuplicateInstanceIdException
     *         You can't specify a managed node ID in more than one association.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CancelCommand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelCommand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelCommandResponse cancelCommand(CancelCommandRequest cancelCommandRequest) throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, DuplicateInstanceIdException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelCommandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelCommandResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelCommandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelCommand");

            return clientHandler.execute(new ClientExecutionParams<CancelCommandRequest, CancelCommandResponse>()
                    .withOperationName("CancelCommand").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(cancelCommandRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelCommandRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a maintenance window execution that is already in progress and cancels any tasks in the window that haven't
     * already starting running. Tasks already in progress will continue to completion.
     * </p>
     *
     * @param cancelMaintenanceWindowExecutionRequest
     * @return Result of the CancelMaintenanceWindowExecution operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CancelMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CancelMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelMaintenanceWindowExecutionResponse cancelMaintenanceWindowExecution(
            CancelMaintenanceWindowExecutionRequest cancelMaintenanceWindowExecutionRequest) throws InternalServerErrorException,
            DoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelMaintenanceWindowExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelMaintenanceWindowExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                cancelMaintenanceWindowExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMaintenanceWindowExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<CancelMaintenanceWindowExecutionRequest, CancelMaintenanceWindowExecutionResponse>()
                            .withOperationName("CancelMaintenanceWindowExecution").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(cancelMaintenanceWindowExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelMaintenanceWindowExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates an activation code and activation ID you can use to register your on-premises servers, edge devices, or
     * virtual machine (VM) with Amazon Web Services Systems Manager. Registering these machines with Systems Manager
     * makes it possible to manage them using Systems Manager capabilities. You use the activation code and ID when
     * installing SSM Agent on machines in your hybrid environment. For more information about requirements for managing
     * on-premises machines using Systems Manager, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html">Setting
     * up Amazon Web Services Systems Manager for hybrid environments</a> in the <i>Amazon Web Services Systems Manager
     * User Guide</i>.
     * </p>
     * <note>
     * <p>
     * Amazon Elastic Compute Cloud (Amazon EC2) instances, edge devices, and on-premises servers and VMs that are
     * configured for Systems Manager are all called <i>managed nodes</i>.
     * </p>
     * </note>
     *
     * @param createActivationRequest
     * @return Result of the CreateActivation operation returned by the service.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the Amazon Web Services Systems Manager document
     *         (SSM document). You can only supply values to parameters defined in the SSM document.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateActivation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateActivationResponse createActivation(CreateActivationRequest createActivationRequest)
            throws InvalidParametersException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateActivationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateActivationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createActivationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateActivation");

            return clientHandler.execute(new ClientExecutionParams<CreateActivationRequest, CreateActivationResponse>()
                    .withOperationName("CreateActivation").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createActivationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateActivationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A State Manager association defines the state that you want to maintain on your managed nodes. For example, an
     * association can specify that anti-virus software must be installed and running on your managed nodes, or that
     * certain ports must be closed. For static targets, the association specifies a schedule for when the configuration
     * is reapplied. For dynamic targets, such as an Amazon Web Services resource group or an Amazon Web Services
     * autoscaling group, State Manager, a capability of Amazon Web Services Systems Manager applies the configuration
     * when new managed nodes are added to the group. The association also specifies actions to take when applying the
     * configuration. For example, an association for anti-virus software might run once a day. If the software isn't
     * installed, then State Manager installs it. If the software is installed, but the service isn't running, then the
     * association might instruct State Manager to start the service.
     * </p>
     *
     * @param createAssociationRequest
     * @return Result of the CreateAssociation operation returned by the service.
     * @throws AssociationAlreadyExistsException
     *         The specified association already exists.
     * @throws AssociationLimitExceededException
     *         You can have at most 2,000 active associations.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentVersionException
     *         The document version isn't valid or doesn't exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws UnsupportedPlatformTypeException
     *         The document doesn't support the platform type of the given managed node ID(s). For example, you sent an
     *         document for a Windows managed node to a Linux node.
     * @throws InvalidOutputLocationException
     *         The output location isn't valid or doesn't exist.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the Amazon Web Services Systems Manager document
     *         (SSM document). You can only supply values to parameters defined in the SSM document.
     * @throws InvalidTargetException
     *         The target isn't valid or doesn't exist. It might not be configured for Systems Manager or you might not
     *         have permission to perform the operation.
     * @throws InvalidScheduleException
     *         The schedule is invalid. Verify your cron or rate expression and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAssociationResponse createAssociation(CreateAssociationRequest createAssociationRequest)
            throws AssociationAlreadyExistsException, AssociationLimitExceededException, InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, InvalidInstanceIdException,
            UnsupportedPlatformTypeException, InvalidOutputLocationException, InvalidParametersException, InvalidTargetException,
            InvalidScheduleException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAssociationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssociation");

            return clientHandler.execute(new ClientExecutionParams<CreateAssociationRequest, CreateAssociationResponse>()
                    .withOperationName("CreateAssociation").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAssociationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Associates the specified Amazon Web Services Systems Manager document (SSM document) with the specified managed
     * nodes or targets.
     * </p>
     * <p>
     * When you associate a document with one or more managed nodes using IDs or tags, Amazon Web Services Systems
     * Manager Agent (SSM Agent) running on the managed node processes the document and configures the node as
     * specified.
     * </p>
     * <p>
     * If you associate a document with a managed node that already has an associated document, the system returns the
     * AssociationAlreadyExists exception.
     * </p>
     *
     * @param createAssociationBatchRequest
     * @return Result of the CreateAssociationBatch operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentVersionException
     *         The document version isn't valid or doesn't exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the Amazon Web Services Systems Manager document
     *         (SSM document). You can only supply values to parameters defined in the SSM document.
     * @throws DuplicateInstanceIdException
     *         You can't specify a managed node ID in more than one association.
     * @throws AssociationLimitExceededException
     *         You can have at most 2,000 active associations.
     * @throws UnsupportedPlatformTypeException
     *         The document doesn't support the platform type of the given managed node ID(s). For example, you sent an
     *         document for a Windows managed node to a Linux node.
     * @throws InvalidOutputLocationException
     *         The output location isn't valid or doesn't exist.
     * @throws InvalidTargetException
     *         The target isn't valid or doesn't exist. It might not be configured for Systems Manager or you might not
     *         have permission to perform the operation.
     * @throws InvalidScheduleException
     *         The schedule is invalid. Verify your cron or rate expression and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateAssociationBatch
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateAssociationBatch" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateAssociationBatchResponse createAssociationBatch(CreateAssociationBatchRequest createAssociationBatchRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentVersionException,
            InvalidInstanceIdException, InvalidParametersException, DuplicateInstanceIdException,
            AssociationLimitExceededException, UnsupportedPlatformTypeException, InvalidOutputLocationException,
            InvalidTargetException, InvalidScheduleException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAssociationBatchResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAssociationBatchResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAssociationBatchRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAssociationBatch");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAssociationBatchRequest, CreateAssociationBatchResponse>()
                            .withOperationName("CreateAssociationBatch").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createAssociationBatchRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAssociationBatchRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a Amazon Web Services Systems Manager (SSM document). An SSM document defines the actions that Systems
     * Manager performs on your managed nodes. For more information about SSM documents, including information about
     * supported schemas, features, and syntax, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-ssm-docs.html">Amazon Web Services
     * Systems Manager Documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param createDocumentRequest
     * @return Result of the CreateDocument operation returned by the service.
     * @throws DocumentAlreadyExistsException
     *         The specified document already exists.
     * @throws MaxDocumentSizeExceededException
     *         The size limit of a document is 64 KB.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentContentException
     *         The content for the document isn't valid.
     * @throws DocumentLimitExceededException
     *         You can have at most 500 active SSM documents.
     * @throws InvalidDocumentSchemaVersionException
     *         The version of the document schema isn't supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDocumentResponse createDocument(CreateDocumentRequest createDocumentRequest)
            throws DocumentAlreadyExistsException, MaxDocumentSizeExceededException, InternalServerErrorException,
            InvalidDocumentContentException, DocumentLimitExceededException, InvalidDocumentSchemaVersionException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDocumentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDocumentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDocument");

            return clientHandler.execute(new ClientExecutionParams<CreateDocumentRequest, CreateDocumentResponse>()
                    .withOperationName("CreateDocument").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDocumentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDocumentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new maintenance window.
     * </p>
     * <note>
     * <p>
     * The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based
     * on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the
     * number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the
     * duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window
     * tasks can start after 5 PM.
     * </p>
     * </note>
     *
     * @param createMaintenanceWindowRequest
     * @return Result of the CreateMaintenanceWindow operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource quotas. For example, too many
     *         maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateMaintenanceWindowResponse createMaintenanceWindow(CreateMaintenanceWindowRequest createMaintenanceWindowRequest)
            throws IdempotentParameterMismatchException, ResourceLimitExceededException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMaintenanceWindowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMaintenanceWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMaintenanceWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMaintenanceWindowRequest, CreateMaintenanceWindowResponse>()
                            .withOperationName("CreateMaintenanceWindow").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createMaintenanceWindowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMaintenanceWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate,
     * and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">Amazon Web Services Systems
     * Manager OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param createOpsItemRequest
     * @return Result of the CreateOpsItem operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemAlreadyExistsException
     *         The OpsItem already exists.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a
     *         href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateOpsItemResponse createOpsItem(CreateOpsItemRequest createOpsItemRequest) throws InternalServerErrorException,
            OpsItemAlreadyExistsException, OpsItemLimitExceededException, OpsItemInvalidParameterException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOpsItemResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateOpsItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOpsItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOpsItem");

            return clientHandler.execute(new ClientExecutionParams<CreateOpsItemRequest, CreateOpsItemResponse>()
                    .withOperationName("CreateOpsItem").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createOpsItemRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateOpsItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * If you create a new application in Application Manager, Amazon Web Services Systems Manager calls this API
     * operation to specify information about the new application, including the application type.
     * </p>
     *
     * @param createOpsMetadataRequest
     * @return Result of the CreateOpsMetadata operation returned by the service.
     * @throws OpsMetadataAlreadyExistsException
     *         An OpsMetadata object already exists for the selected resource.
     * @throws OpsMetadataTooManyUpdatesException
     *         The system is processing too many concurrent updates. Wait a few moments and try again.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws OpsMetadataLimitExceededException
     *         Your account reached the maximum number of OpsMetadata objects allowed by Application Manager. The
     *         maximum is 200 OpsMetadata objects. Delete one or more OpsMetadata object and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateOpsMetadataResponse createOpsMetadata(CreateOpsMetadataRequest createOpsMetadataRequest)
            throws OpsMetadataAlreadyExistsException, OpsMetadataTooManyUpdatesException, OpsMetadataInvalidArgumentException,
            OpsMetadataLimitExceededException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOpsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateOpsMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOpsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOpsMetadata");

            return clientHandler.execute(new ClientExecutionParams<CreateOpsMetadataRequest, CreateOpsMetadataResponse>()
                    .withOperationName("CreateOpsMetadata").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createOpsMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateOpsMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a patch baseline.
     * </p>
     * <note>
     * <p>
     * For information about valid key-value pairs in <code>PatchFilters</code> for each supported operating system
     * type, see <a>PatchFilter</a>.
     * </p>
     * </note>
     *
     * @param createPatchBaselineRequest
     * @return Result of the CreatePatchBaseline operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource quotas. For example, too many
     *         maintenance windows or patch baselines have been created.</p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreatePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreatePatchBaselineResponse createPatchBaseline(CreatePatchBaselineRequest createPatchBaselineRequest)
            throws IdempotentParameterMismatchException, ResourceLimitExceededException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreatePatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreatePatchBaselineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createPatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreatePatchBaseline");

            return clientHandler.execute(new ClientExecutionParams<CreatePatchBaselineRequest, CreatePatchBaselineResponse>()
                    .withOperationName("CreatePatchBaseline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createPatchBaselineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreatePatchBaselineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A resource data sync helps you view data from multiple sources in a single location. Amazon Web Services Systems
     * Manager offers two types of resource data sync: <code>SyncToDestination</code> and <code>SyncFromSource</code>.
     * </p>
     * <p>
     * You can configure Systems Manager Inventory to use the <code>SyncToDestination</code> type to synchronize
     * Inventory data from multiple Amazon Web Services Regions to a single Amazon Simple Storage Service (Amazon S3)
     * bucket. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html">Configuring
     * resource data sync for Inventory</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * You can configure Systems Manager Explorer to use the <code>SyncFromSource</code> type to synchronize operational
     * work items (OpsItems) and operational data (OpsData) from multiple Amazon Web Services Regions to a single Amazon
     * S3 bucket. This type can synchronize OpsItems and OpsData from multiple Amazon Web Services accounts and Amazon
     * Web Services Regions or <code>EntireOrganization</code> by using Organizations. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html">Setting up
     * Systems Manager Explorer to display data from multiple accounts and Regions</a> in the <i>Amazon Web Services
     * Systems Manager User Guide</i>.
     * </p>
     * <p>
     * A resource data sync is an asynchronous operation that returns immediately. After a successful initial sync is
     * completed, the system continuously syncs data. To check the status of a sync, use the
     * <a>ListResourceDataSync</a>.
     * </p>
     * <note>
     * <p>
     * By default, data isn't encrypted in Amazon S3. We strongly recommend that you enable encryption in Amazon S3 to
     * ensure secure data storage. We also recommend that you secure access to the Amazon S3 bucket by creating a
     * restrictive bucket policy.
     * </p>
     * </note>
     *
     * @param createResourceDataSyncRequest
     * @return Result of the CreateResourceDataSync operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncCountExceededException
     *         You have exceeded the allowed maximum sync configurations.
     * @throws ResourceDataSyncAlreadyExistsException
     *         A sync configuration with the same name already exists.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.CreateResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/CreateResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateResourceDataSyncResponse createResourceDataSync(CreateResourceDataSyncRequest createResourceDataSyncRequest)
            throws InternalServerErrorException, ResourceDataSyncCountExceededException, ResourceDataSyncAlreadyExistsException,
            ResourceDataSyncInvalidConfigurationException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourceDataSyncResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResourceDataSyncResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceDataSyncRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourceDataSync");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateResourceDataSyncRequest, CreateResourceDataSyncResponse>()
                            .withOperationName("CreateResourceDataSync").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createResourceDataSyncRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateResourceDataSyncRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an activation. You aren't required to delete an activation. If you delete an activation, you can no
     * longer use it to register additional managed nodes. Deleting an activation doesn't de-register managed nodes. You
     * must manually de-register managed nodes.
     * </p>
     *
     * @param deleteActivationRequest
     * @return Result of the DeleteActivation operation returned by the service.
     * @throws InvalidActivationIdException
     *         The activation ID isn't valid. Verify the you entered the correct ActivationId or ActivationCode and try
     *         again.
     * @throws InvalidActivationException
     *         The activation isn't valid. The activation might have been deleted, or the ActivationId and the
     *         ActivationCode don't match.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteActivation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteActivation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteActivationResponse deleteActivation(DeleteActivationRequest deleteActivationRequest)
            throws InvalidActivationIdException, InvalidActivationException, InternalServerErrorException,
            TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteActivationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteActivationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteActivationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteActivation");

            return clientHandler.execute(new ClientExecutionParams<DeleteActivationRequest, DeleteActivationResponse>()
                    .withOperationName("DeleteActivation").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteActivationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteActivationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Disassociates the specified Amazon Web Services Systems Manager document (SSM document) from the specified
     * managed node. If you created the association by using the <code>Targets</code> parameter, then you must delete
     * the association by using the association ID.
     * </p>
     * <p>
     * When you disassociate a document from a managed node, it doesn't change the configuration of the node. To change
     * the configuration state of a managed node after you disassociate a document, you must create a new document with
     * the desired configuration and associate it with the node.
     * </p>
     *
     * @param deleteAssociationRequest
     * @return Result of the DeleteAssociation operation returned by the service.
     * @throws AssociationDoesNotExistException
     *         The specified association doesn't exist.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAssociationResponse deleteAssociation(DeleteAssociationRequest deleteAssociationRequest)
            throws AssociationDoesNotExistException, InternalServerErrorException, InvalidDocumentException,
            InvalidInstanceIdException, TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAssociationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAssociation");

            return clientHandler.execute(new ClientExecutionParams<DeleteAssociationRequest, DeleteAssociationResponse>()
                    .withOperationName("DeleteAssociation").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAssociationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the Amazon Web Services Systems Manager document (SSM document) and all managed node associations to the
     * document.
     * </p>
     * <p>
     * Before you delete the document, we recommend that you use <a>DeleteAssociation</a> to disassociate all managed
     * nodes that are associated with the document.
     * </p>
     *
     * @param deleteDocumentRequest
     * @return Result of the DeleteDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentOperationException
     *         You attempted to delete a document while it is still shared. You must stop sharing the document before
     *         you can delete it.
     * @throws AssociatedInstancesException
     *         You must disassociate a document from all managed nodes before you can delete it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDocumentResponse deleteDocument(DeleteDocumentRequest deleteDocumentRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentOperationException,
            AssociatedInstancesException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDocumentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDocumentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDocument");

            return clientHandler.execute(new ClientExecutionParams<DeleteDocumentRequest, DeleteDocumentResponse>()
                    .withOperationName("DeleteDocument").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDocumentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDocumentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a custom inventory type or the data associated with a custom Inventory type. Deleting a custom inventory
     * type is also referred to as deleting a custom inventory schema.
     * </p>
     *
     * @param deleteInventoryRequest
     * @return Result of the DeleteInventory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name isn't valid.
     * @throws InvalidOptionException
     *         The delete inventory option specified isn't valid. Verify the option and try again.
     * @throws InvalidDeleteInventoryParametersException
     *         One or more of the parameters specified for the delete operation isn't valid. Verify all parameters and
     *         try again.
     * @throws InvalidInventoryRequestException
     *         The request isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteInventory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteInventoryResponse deleteInventory(DeleteInventoryRequest deleteInventoryRequest)
            throws InternalServerErrorException, InvalidTypeNameException, InvalidOptionException,
            InvalidDeleteInventoryParametersException, InvalidInventoryRequestException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteInventoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteInventoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteInventoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteInventory");

            return clientHandler.execute(new ClientExecutionParams<DeleteInventoryRequest, DeleteInventoryResponse>()
                    .withOperationName("DeleteInventory").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteInventoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteInventoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a maintenance window.
     * </p>
     *
     * @param deleteMaintenanceWindowRequest
     * @return Result of the DeleteMaintenanceWindow operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteMaintenanceWindowResponse deleteMaintenanceWindow(DeleteMaintenanceWindowRequest deleteMaintenanceWindowRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteMaintenanceWindowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteMaintenanceWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteMaintenanceWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteMaintenanceWindowRequest, DeleteMaintenanceWindowResponse>()
                            .withOperationName("DeleteMaintenanceWindow").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteMaintenanceWindowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteMaintenanceWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete OpsMetadata related to an application.
     * </p>
     *
     * @param deleteOpsMetadataRequest
     * @return Result of the DeleteOpsMetadata operation returned by the service.
     * @throws OpsMetadataNotFoundException
     *         The OpsMetadata object doesn't exist.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteOpsMetadataResponse deleteOpsMetadata(DeleteOpsMetadataRequest deleteOpsMetadataRequest)
            throws OpsMetadataNotFoundException, OpsMetadataInvalidArgumentException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteOpsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteOpsMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteOpsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteOpsMetadata");

            return clientHandler.execute(new ClientExecutionParams<DeleteOpsMetadataRequest, DeleteOpsMetadataResponse>()
                    .withOperationName("DeleteOpsMetadata").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteOpsMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteOpsMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a parameter from the system. After deleting a parameter, wait for at least 30 seconds to create a
     * parameter with the same name.
     * </p>
     *
     * @param deleteParameterRequest
     * @return Result of the DeleteParameter operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ParameterNotFoundException
     *         The parameter couldn't be found. Verify the name and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteParameterResponse deleteParameter(DeleteParameterRequest deleteParameterRequest)
            throws InternalServerErrorException, ParameterNotFoundException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteParameterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteParameterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteParameterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteParameter");

            return clientHandler.execute(new ClientExecutionParams<DeleteParameterRequest, DeleteParameterResponse>()
                    .withOperationName("DeleteParameter").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteParameterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteParameterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Delete a list of parameters. After deleting a parameter, wait for at least 30 seconds to create a parameter with
     * the same name.
     * </p>
     *
     * @param deleteParametersRequest
     * @return Result of the DeleteParameters operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteParametersResponse deleteParameters(DeleteParametersRequest deleteParametersRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteParametersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteParameters");

            return clientHandler.execute(new ClientExecutionParams<DeleteParametersRequest, DeleteParametersResponse>()
                    .withOperationName("DeleteParameters").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteParametersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a patch baseline.
     * </p>
     *
     * @param deletePatchBaselineRequest
     * @return Result of the DeletePatchBaseline operation returned by the service.
     * @throws ResourceInUseException
     *         Error returned if an attempt is made to delete a patch baseline that is registered for a patch group.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeletePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeletePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeletePatchBaselineResponse deletePatchBaseline(DeletePatchBaselineRequest deletePatchBaselineRequest)
            throws ResourceInUseException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeletePatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeletePatchBaselineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deletePatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeletePatchBaseline");

            return clientHandler.execute(new ClientExecutionParams<DeletePatchBaselineRequest, DeletePatchBaselineResponse>()
                    .withOperationName("DeletePatchBaseline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deletePatchBaselineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeletePatchBaselineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a resource data sync configuration. After the configuration is deleted, changes to data on managed nodes
     * are no longer synced to or from the target. Deleting a sync configuration doesn't delete data.
     * </p>
     *
     * @param deleteResourceDataSyncRequest
     * @return Result of the DeleteResourceDataSync operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncNotFoundException
     *         The specified sync name wasn't found.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeleteResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeleteResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteResourceDataSyncResponse deleteResourceDataSync(DeleteResourceDataSyncRequest deleteResourceDataSyncRequest)
            throws InternalServerErrorException, ResourceDataSyncNotFoundException,
            ResourceDataSyncInvalidConfigurationException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourceDataSyncResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourceDataSyncResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceDataSyncRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourceDataSync");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceDataSyncRequest, DeleteResourceDataSyncResponse>()
                            .withOperationName("DeleteResourceDataSync").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteResourceDataSyncRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteResourceDataSyncRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes the server or virtual machine from the list of registered servers. You can reregister the node again at
     * any time. If you don't plan to use Run Command on the server, we suggest uninstalling SSM Agent first.
     * </p>
     *
     * @param deregisterManagedInstanceRequest
     * @return Result of the DeregisterManagedInstance operation returned by the service.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeregisterManagedInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterManagedInstance" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeregisterManagedInstanceResponse deregisterManagedInstance(
            DeregisterManagedInstanceRequest deregisterManagedInstanceRequest) throws InvalidInstanceIdException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterManagedInstanceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeregisterManagedInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deregisterManagedInstanceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterManagedInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterManagedInstanceRequest, DeregisterManagedInstanceResponse>()
                            .withOperationName("DeregisterManagedInstance").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deregisterManagedInstanceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterManagedInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a patch group from a patch baseline.
     * </p>
     *
     * @param deregisterPatchBaselineForPatchGroupRequest
     * @return Result of the DeregisterPatchBaselineForPatchGroup operation returned by the service.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeregisterPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterPatchBaselineForPatchGroupResponse deregisterPatchBaselineForPatchGroup(
            DeregisterPatchBaselineForPatchGroupRequest deregisterPatchBaselineForPatchGroupRequest)
            throws InvalidResourceIdException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterPatchBaselineForPatchGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeregisterPatchBaselineForPatchGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deregisterPatchBaselineForPatchGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterPatchBaselineForPatchGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterPatchBaselineForPatchGroupRequest, DeregisterPatchBaselineForPatchGroupResponse>()
                            .withOperationName("DeregisterPatchBaselineForPatchGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(deregisterPatchBaselineForPatchGroupRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterPatchBaselineForPatchGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a target from a maintenance window.
     * </p>
     *
     * @param deregisterTargetFromMaintenanceWindowRequest
     * @return Result of the DeregisterTargetFromMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TargetInUseException
     *         You specified the <code>Safe</code> option for the DeregisterTargetFromMaintenanceWindow operation, but
     *         the target is still referenced in a task.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeregisterTargetFromMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTargetFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterTargetFromMaintenanceWindowResponse deregisterTargetFromMaintenanceWindow(
            DeregisterTargetFromMaintenanceWindowRequest deregisterTargetFromMaintenanceWindowRequest)
            throws DoesNotExistException, InternalServerErrorException, TargetInUseException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterTargetFromMaintenanceWindowResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DeregisterTargetFromMaintenanceWindowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deregisterTargetFromMaintenanceWindowRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterTargetFromMaintenanceWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterTargetFromMaintenanceWindowRequest, DeregisterTargetFromMaintenanceWindowResponse>()
                            .withOperationName("DeregisterTargetFromMaintenanceWindow").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(deregisterTargetFromMaintenanceWindowRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterTargetFromMaintenanceWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a task from a maintenance window.
     * </p>
     *
     * @param deregisterTaskFromMaintenanceWindowRequest
     * @return Result of the DeregisterTaskFromMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DeregisterTaskFromMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DeregisterTaskFromMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeregisterTaskFromMaintenanceWindowResponse deregisterTaskFromMaintenanceWindow(
            DeregisterTaskFromMaintenanceWindowRequest deregisterTaskFromMaintenanceWindowRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeregisterTaskFromMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeregisterTaskFromMaintenanceWindowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deregisterTaskFromMaintenanceWindowRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeregisterTaskFromMaintenanceWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<DeregisterTaskFromMaintenanceWindowRequest, DeregisterTaskFromMaintenanceWindowResponse>()
                            .withOperationName("DeregisterTaskFromMaintenanceWindow").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deregisterTaskFromMaintenanceWindowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeregisterTaskFromMaintenanceWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the Identity and Access Management (IAM) role assigned to the managed nodes in the activation, and the
     * number of nodes registered by using this activation.
     * </p>
     *
     * @param describeActivationsRequest
     * @return Result of the DescribeActivations operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeActivationsResponse describeActivations(DescribeActivationsRequest describeActivationsRequest)
            throws InvalidFilterException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeActivationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeActivationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeActivationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeActivations");

            return clientHandler.execute(new ClientExecutionParams<DescribeActivationsRequest, DescribeActivationsResponse>()
                    .withOperationName("DescribeActivations").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeActivationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeActivationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes details about the activation, such as the date and time the activation was created, its expiration
     * date, the Identity and Access Management (IAM) role assigned to the managed nodes in the activation, and the
     * number of nodes registered by using this activation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable responses = client.describeActivationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable responses = client
     *             .describeActivationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeActivationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeActivationsIterable responses = client.describeActivationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeActivations(software.amazon.awssdk.services.ssm.model.DescribeActivationsRequest)} operation.</b>
     * </p>
     *
     * @param describeActivationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeActivations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeActivations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeActivationsIterable describeActivationsPaginator(DescribeActivationsRequest describeActivationsRequest)
            throws InvalidFilterException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        return new DescribeActivationsIterable(this, applyPaginatorUserAgent(describeActivationsRequest));
    }

    /**
     * <p>
     * Describes the association for the specified target or managed node. If you created the association by using the
     * <code>Targets</code> parameter, then you must retrieve the association by using the association ID.
     * </p>
     *
     * @param describeAssociationRequest
     * @return Result of the DescribeAssociation operation returned by the service.
     * @throws AssociationDoesNotExistException
     *         The specified association doesn't exist.
     * @throws InvalidAssociationVersionException
     *         The version you specified isn't valid. Use ListAssociationVersions to view all versions of an association
     *         according to the association ID. Or, use the <code>&#36LATEST</code> parameter to view the latest version
     *         of the association.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeAssociationResponse describeAssociation(DescribeAssociationRequest describeAssociationRequest)
            throws AssociationDoesNotExistException, InvalidAssociationVersionException, InternalServerErrorException,
            InvalidDocumentException, InvalidInstanceIdException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssociation");

            return clientHandler.execute(new ClientExecutionParams<DescribeAssociationRequest, DescribeAssociationResponse>()
                    .withOperationName("DescribeAssociation").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeAssociationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Views information about a specific execution of a specific association.
     * </p>
     *
     * @param describeAssociationExecutionTargetsRequest
     * @return Result of the DescribeAssociationExecutionTargets operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AssociationDoesNotExistException
     *         The specified association doesn't exist.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws AssociationExecutionDoesNotExistException
     *         The specified execution ID doesn't exist. Verify the ID number and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociationExecutionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAssociationExecutionTargetsResponse describeAssociationExecutionTargets(
            DescribeAssociationExecutionTargetsRequest describeAssociationExecutionTargetsRequest)
            throws InternalServerErrorException, AssociationDoesNotExistException, InvalidNextTokenException,
            AssociationExecutionDoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAssociationExecutionTargetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAssociationExecutionTargetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAssociationExecutionTargetsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssociationExecutionTargets");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAssociationExecutionTargetsRequest, DescribeAssociationExecutionTargetsResponse>()
                            .withOperationName("DescribeAssociationExecutionTargets").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAssociationExecutionTargetsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAssociationExecutionTargetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Views information about a specific execution of a specific association.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAssociationExecutionTargets(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsIterable responses = client.describeAssociationExecutionTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsIterable responses = client
     *             .describeAssociationExecutionTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionTargetsIterable responses = client.describeAssociationExecutionTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAssociationExecutionTargets(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAssociationExecutionTargetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AssociationDoesNotExistException
     *         The specified association doesn't exist.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws AssociationExecutionDoesNotExistException
     *         The specified execution ID doesn't exist. Verify the ID number and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociationExecutionTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutionTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAssociationExecutionTargetsIterable describeAssociationExecutionTargetsPaginator(
            DescribeAssociationExecutionTargetsRequest describeAssociationExecutionTargetsRequest)
            throws InternalServerErrorException, AssociationDoesNotExistException, InvalidNextTokenException,
            AssociationExecutionDoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeAssociationExecutionTargetsIterable(this,
                applyPaginatorUserAgent(describeAssociationExecutionTargetsRequest));
    }

    /**
     * <p>
     * Views all executions for a specific association ID.
     * </p>
     *
     * @param describeAssociationExecutionsRequest
     * @return Result of the DescribeAssociationExecutions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AssociationDoesNotExistException
     *         The specified association doesn't exist.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAssociationExecutionsResponse describeAssociationExecutions(
            DescribeAssociationExecutionsRequest describeAssociationExecutionsRequest) throws InternalServerErrorException,
            AssociationDoesNotExistException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAssociationExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAssociationExecutionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAssociationExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAssociationExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAssociationExecutionsRequest, DescribeAssociationExecutionsResponse>()
                            .withOperationName("DescribeAssociationExecutions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAssociationExecutionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAssociationExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Views all executions for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAssociationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsIterable responses = client.describeAssociationExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsIterable responses = client
     *             .describeAssociationExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAssociationExecutionsIterable responses = client.describeAssociationExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAssociationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAssociationExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AssociationDoesNotExistException
     *         The specified association doesn't exist.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAssociationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAssociationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAssociationExecutionsIterable describeAssociationExecutionsPaginator(
            DescribeAssociationExecutionsRequest describeAssociationExecutionsRequest) throws InternalServerErrorException,
            AssociationDoesNotExistException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeAssociationExecutionsIterable(this, applyPaginatorUserAgent(describeAssociationExecutionsRequest));
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     * @return Result of the DescribeAutomationExecutions operation returned by the service.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidFilterValueException
     *         The filter value isn't valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAutomationExecutionsResponse describeAutomationExecutions(
            DescribeAutomationExecutionsRequest describeAutomationExecutionsRequest) throws InvalidFilterKeyException,
            InvalidFilterValueException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAutomationExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAutomationExecutionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAutomationExecutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAutomationExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAutomationExecutionsRequest, DescribeAutomationExecutionsResponse>()
                            .withOperationName("DescribeAutomationExecutions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAutomationExecutionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAutomationExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides details about all active and terminated Automation executions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable responses = client.describeAutomationExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable responses = client
     *             .describeAutomationExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationExecutionsIterable responses = client.describeAutomationExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutomationExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidFilterValueException
     *         The filter value isn't valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAutomationExecutionsIterable describeAutomationExecutionsPaginator(
            DescribeAutomationExecutionsRequest describeAutomationExecutionsRequest) throws InvalidFilterKeyException,
            InvalidFilterValueException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        return new DescribeAutomationExecutionsIterable(this, applyPaginatorUserAgent(describeAutomationExecutionsRequest));
    }

    /**
     * <p>
     * Information about all active and terminated step executions in an Automation workflow.
     * </p>
     *
     * @param describeAutomationStepExecutionsRequest
     * @return Result of the DescribeAutomationStepExecutions operation returned by the service.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidFilterValueException
     *         The filter value isn't valid. Verify the value and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAutomationStepExecutionsResponse describeAutomationStepExecutions(
            DescribeAutomationStepExecutionsRequest describeAutomationStepExecutionsRequest)
            throws AutomationExecutionNotFoundException, InvalidNextTokenException, InvalidFilterKeyException,
            InvalidFilterValueException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAutomationStepExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAutomationStepExecutionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeAutomationStepExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAutomationStepExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAutomationStepExecutionsRequest, DescribeAutomationStepExecutionsResponse>()
                            .withOperationName("DescribeAutomationStepExecutions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAutomationStepExecutionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAutomationStepExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Information about all active and terminated step executions in an Automation workflow.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAutomationStepExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsIterable responses = client.describeAutomationStepExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsIterable responses = client
     *             .describeAutomationStepExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAutomationStepExecutionsIterable responses = client.describeAutomationStepExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAutomationStepExecutions(software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAutomationStepExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidFilterValueException
     *         The filter value isn't valid. Verify the value and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAutomationStepExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAutomationStepExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAutomationStepExecutionsIterable describeAutomationStepExecutionsPaginator(
            DescribeAutomationStepExecutionsRequest describeAutomationStepExecutionsRequest)
            throws AutomationExecutionNotFoundException, InvalidNextTokenException, InvalidFilterKeyException,
            InvalidFilterValueException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeAutomationStepExecutionsIterable(this,
                applyPaginatorUserAgent(describeAutomationStepExecutionsRequest));
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     *
     * @param describeAvailablePatchesRequest
     * @return Result of the DescribeAvailablePatches operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAvailablePatchesResponse describeAvailablePatches(
            DescribeAvailablePatchesRequest describeAvailablePatchesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAvailablePatchesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAvailablePatchesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAvailablePatchesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAvailablePatches");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAvailablePatchesRequest, DescribeAvailablePatchesResponse>()
                            .withOperationName("DescribeAvailablePatches").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAvailablePatchesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAvailablePatchesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all patches eligible to be included in a patch baseline.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable responses = client.describeAvailablePatchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable responses = client
     *             .describeAvailablePatchesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeAvailablePatchesIterable responses = client.describeAvailablePatchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeAvailablePatches(software.amazon.awssdk.services.ssm.model.DescribeAvailablePatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeAvailablePatchesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeAvailablePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeAvailablePatches" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAvailablePatchesIterable describeAvailablePatchesPaginator(
            DescribeAvailablePatchesRequest describeAvailablePatchesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return new DescribeAvailablePatchesIterable(this, applyPaginatorUserAgent(describeAvailablePatchesRequest));
    }

    /**
     * <p>
     * Describes the specified Amazon Web Services Systems Manager document (SSM document).
     * </p>
     *
     * @param describeDocumentRequest
     * @return Result of the DescribeDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentVersionException
     *         The document version isn't valid or doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeDocumentResponse describeDocument(DescribeDocumentRequest describeDocumentRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentVersionException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDocumentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeDocumentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDocument");

            return clientHandler.execute(new ClientExecutionParams<DescribeDocumentRequest, DescribeDocumentResponse>()
                    .withOperationName("DescribeDocument").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeDocumentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDocumentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the permissions for a Amazon Web Services Systems Manager document (SSM document). If you created the
     * document, you are the owner. If a document is shared, it can either be shared privately (by specifying a user's
     * Amazon Web Services account ID) or publicly (<i>All</i>).
     * </p>
     *
     * @param describeDocumentPermissionRequest
     * @return Result of the DescribeDocumentPermission operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidPermissionTypeException
     *         The permission type isn't supported. <i>Share</i> is the only supported permission type.
     * @throws InvalidDocumentOperationException
     *         You attempted to delete a document while it is still shared. You must stop sharing the document before
     *         you can delete it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeDocumentPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeDocumentPermission"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDocumentPermissionResponse describeDocumentPermission(
            DescribeDocumentPermissionRequest describeDocumentPermissionRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidNextTokenException, InvalidPermissionTypeException,
            InvalidDocumentOperationException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDocumentPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDocumentPermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDocumentPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDocumentPermission");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDocumentPermissionRequest, DescribeDocumentPermissionResponse>()
                            .withOperationName("DescribeDocumentPermission").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDocumentPermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDocumentPermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * All associations for the managed node(s).
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     * @return Result of the DescribeEffectiveInstanceAssociations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeEffectiveInstanceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEffectiveInstanceAssociationsResponse describeEffectiveInstanceAssociations(
            DescribeEffectiveInstanceAssociationsRequest describeEffectiveInstanceAssociationsRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEffectiveInstanceAssociationsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeEffectiveInstanceAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEffectiveInstanceAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEffectiveInstanceAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEffectiveInstanceAssociationsRequest, DescribeEffectiveInstanceAssociationsResponse>()
                            .withOperationName("DescribeEffectiveInstanceAssociations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeEffectiveInstanceAssociationsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEffectiveInstanceAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * All associations for the managed node(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEffectiveInstanceAssociations(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsIterable responses = client.describeEffectiveInstanceAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsIterable responses = client
     *             .describeEffectiveInstanceAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectiveInstanceAssociationsIterable responses = client.describeEffectiveInstanceAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEffectiveInstanceAssociations(software.amazon.awssdk.services.ssm.model.DescribeEffectiveInstanceAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEffectiveInstanceAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeEffectiveInstanceAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectiveInstanceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEffectiveInstanceAssociationsIterable describeEffectiveInstanceAssociationsPaginator(
            DescribeEffectiveInstanceAssociationsRequest describeEffectiveInstanceAssociationsRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return new DescribeEffectiveInstanceAssociationsIterable(this,
                applyPaginatorUserAgent(describeEffectiveInstanceAssociationsRequest));
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline.
     * Applies to patch baselines for Windows only.
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     * @return Result of the DescribeEffectivePatchesForPatchBaseline operation returned by the service.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws UnsupportedOperatingSystemException
     *         The operating systems you specified isn't supported, or the operation isn't supported for the operating
     *         system.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEffectivePatchesForPatchBaselineResponse describeEffectivePatchesForPatchBaseline(
            DescribeEffectivePatchesForPatchBaselineRequest describeEffectivePatchesForPatchBaselineRequest)
            throws InvalidResourceIdException, DoesNotExistException, UnsupportedOperatingSystemException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeEffectivePatchesForPatchBaselineResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeEffectivePatchesForPatchBaselineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeEffectivePatchesForPatchBaselineRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeEffectivePatchesForPatchBaseline");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeEffectivePatchesForPatchBaselineRequest, DescribeEffectivePatchesForPatchBaselineResponse>()
                            .withOperationName("DescribeEffectivePatchesForPatchBaseline").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeEffectivePatchesForPatchBaselineRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeEffectivePatchesForPatchBaselineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the current effective patches (the patch and the approval state) for the specified patch baseline.
     * Applies to patch baselines for Windows only.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeEffectivePatchesForPatchBaseline(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselineIterable responses = client.describeEffectivePatchesForPatchBaselinePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselineIterable responses = client
     *             .describeEffectivePatchesForPatchBaselinePaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeEffectivePatchesForPatchBaselineIterable responses = client.describeEffectivePatchesForPatchBaselinePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeEffectivePatchesForPatchBaseline(software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeEffectivePatchesForPatchBaselineRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws UnsupportedOperatingSystemException
     *         The operating systems you specified isn't supported, or the operation isn't supported for the operating
     *         system.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeEffectivePatchesForPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeEffectivePatchesForPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeEffectivePatchesForPatchBaselineIterable describeEffectivePatchesForPatchBaselinePaginator(
            DescribeEffectivePatchesForPatchBaselineRequest describeEffectivePatchesForPatchBaselineRequest)
            throws InvalidResourceIdException, DoesNotExistException, UnsupportedOperatingSystemException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeEffectivePatchesForPatchBaselineIterable(this,
                applyPaginatorUserAgent(describeEffectivePatchesForPatchBaselineRequest));
    }

    /**
     * <p>
     * The status of the associations for the managed node(s).
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     * @return Result of the DescribeInstanceAssociationsStatus operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceAssociationsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstanceAssociationsStatusResponse describeInstanceAssociationsStatus(
            DescribeInstanceAssociationsStatusRequest describeInstanceAssociationsStatusRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInstanceAssociationsStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeInstanceAssociationsStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeInstanceAssociationsStatusRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstanceAssociationsStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceAssociationsStatusRequest, DescribeInstanceAssociationsStatusResponse>()
                            .withOperationName("DescribeInstanceAssociationsStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeInstanceAssociationsStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeInstanceAssociationsStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The status of the associations for the managed node(s).
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceAssociationsStatus(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusIterable responses = client.describeInstanceAssociationsStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusIterable responses = client
     *             .describeInstanceAssociationsStatusPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceAssociationsStatusIterable responses = client.describeInstanceAssociationsStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceAssociationsStatus(software.amazon.awssdk.services.ssm.model.DescribeInstanceAssociationsStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceAssociationsStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceAssociationsStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceAssociationsStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstanceAssociationsStatusIterable describeInstanceAssociationsStatusPaginator(
            DescribeInstanceAssociationsStatusRequest describeInstanceAssociationsStatusRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return new DescribeInstanceAssociationsStatusIterable(this,
                applyPaginatorUserAgent(describeInstanceAssociationsStatusRequest));
    }

    /**
     * <p>
     * Describes one or more of your managed nodes, including information about the operating system platform, the
     * version of SSM Agent installed on the managed node, node status, and so on.
     * </p>
     * <p>
     * If you specify one or more managed node IDs, it returns information for those managed nodes. If you don't specify
     * node IDs, it returns information for all your managed nodes. If you specify a node ID that isn't valid or a node
     * that you don't own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The <code>IamRole</code> field for this API operation is the Identity and Access Management (IAM) role assigned
     * to on-premises managed nodes. This call doesn't return the IAM role for EC2 instances.
     * </p>
     * </note>
     *
     * @param describeInstanceInformationRequest
     * @return Result of the DescribeInstanceInformation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidInstanceInformationFilterValueException
     *         The specified filter value isn't valid.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstanceInformationResponse describeInstanceInformation(
            DescribeInstanceInformationRequest describeInstanceInformationRequest) throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidNextTokenException, InvalidInstanceInformationFilterValueException,
            InvalidFilterKeyException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInstanceInformationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeInstanceInformationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInstanceInformationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstanceInformation");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeInstanceInformationRequest, DescribeInstanceInformationResponse>()
                            .withOperationName("DescribeInstanceInformation").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeInstanceInformationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeInstanceInformationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes one or more of your managed nodes, including information about the operating system platform, the
     * version of SSM Agent installed on the managed node, node status, and so on.
     * </p>
     * <p>
     * If you specify one or more managed node IDs, it returns information for those managed nodes. If you don't specify
     * node IDs, it returns information for all your managed nodes. If you specify a node ID that isn't valid or a node
     * that you don't own, you receive an error.
     * </p>
     * <note>
     * <p>
     * The <code>IamRole</code> field for this API operation is the Identity and Access Management (IAM) role assigned
     * to on-premises managed nodes. This call doesn't return the IAM role for EC2 instances.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable responses = client.describeInstanceInformationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable responses = client
     *             .describeInstanceInformationPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstanceInformationIterable responses = client.describeInstanceInformationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstanceInformation(software.amazon.awssdk.services.ssm.model.DescribeInstanceInformationRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstanceInformationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidInstanceInformationFilterValueException
     *         The specified filter value isn't valid.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstanceInformation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstanceInformation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstanceInformationIterable describeInstanceInformationPaginator(
            DescribeInstanceInformationRequest describeInstanceInformationRequest) throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidNextTokenException, InvalidInstanceInformationFilterValueException,
            InvalidFilterKeyException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeInstanceInformationIterable(this, applyPaginatorUserAgent(describeInstanceInformationRequest));
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more managed nodes.
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     * @return Result of the DescribeInstancePatchStates operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatchStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstancePatchStatesResponse describeInstancePatchStates(
            DescribeInstancePatchStatesRequest describeInstancePatchStatesRequest) throws InternalServerErrorException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInstancePatchStatesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeInstancePatchStatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInstancePatchStatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstancePatchStates");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeInstancePatchStatesRequest, DescribeInstancePatchStatesResponse>()
                            .withOperationName("DescribeInstancePatchStates").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeInstancePatchStatesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeInstancePatchStatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the high-level patch state of one or more managed nodes.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatchStates(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesIterable responses = client.describeInstancePatchStatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesIterable responses = client
     *             .describeInstancePatchStatesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesIterable responses = client.describeInstancePatchStatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatchStates(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancePatchStatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatchStates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStates"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstancePatchStatesIterable describeInstancePatchStatesPaginator(
            DescribeInstancePatchStatesRequest describeInstancePatchStatesRequest) throws InternalServerErrorException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeInstancePatchStatesIterable(this, applyPaginatorUserAgent(describeInstancePatchStatesRequest));
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the managed nodes in the specified patch group.
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     * @return Result of the DescribeInstancePatchStatesForPatchGroup operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstancePatchStatesForPatchGroupResponse describeInstancePatchStatesForPatchGroup(
            DescribeInstancePatchStatesForPatchGroupRequest describeInstancePatchStatesForPatchGroupRequest)
            throws InternalServerErrorException, InvalidFilterException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInstancePatchStatesForPatchGroupResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeInstancePatchStatesForPatchGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeInstancePatchStatesForPatchGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstancePatchStatesForPatchGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeInstancePatchStatesForPatchGroupRequest, DescribeInstancePatchStatesForPatchGroupResponse>()
                            .withOperationName("DescribeInstancePatchStatesForPatchGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeInstancePatchStatesForPatchGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeInstancePatchStatesForPatchGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the high-level patch state for the managed nodes in the specified patch group.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatchStatesForPatchGroup(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupIterable responses = client.describeInstancePatchStatesForPatchGroupPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupIterable responses = client
     *             .describeInstancePatchStatesForPatchGroupPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchStatesForPatchGroupIterable responses = client.describeInstancePatchStatesForPatchGroupPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatchStatesForPatchGroup(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchStatesForPatchGroupRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancePatchStatesForPatchGroupRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatchStatesForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatchStatesForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInstancePatchStatesForPatchGroupIterable describeInstancePatchStatesForPatchGroupPaginator(
            DescribeInstancePatchStatesForPatchGroupRequest describeInstancePatchStatesForPatchGroupRequest)
            throws InternalServerErrorException, InvalidFilterException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return new DescribeInstancePatchStatesForPatchGroupIterable(this,
                applyPaginatorUserAgent(describeInstancePatchStatesForPatchGroupRequest));
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified managed node and their state relative to the patch
     * baseline being used for the node.
     * </p>
     *
     * @param describeInstancePatchesRequest
     * @return Result of the DescribeInstancePatches operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeInstancePatchesResponse describeInstancePatches(DescribeInstancePatchesRequest describeInstancePatchesRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidFilterException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInstancePatchesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeInstancePatchesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInstancePatchesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInstancePatches");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeInstancePatchesRequest, DescribeInstancePatchesResponse>()
                            .withOperationName("DescribeInstancePatches").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeInstancePatchesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeInstancePatchesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the patches on the specified managed node and their state relative to the patch
     * baseline being used for the node.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInstancePatches(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesIterable responses = client.describeInstancePatchesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesIterable responses = client
     *             .describeInstancePatchesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInstancePatchesIterable responses = client.describeInstancePatchesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInstancePatches(software.amazon.awssdk.services.ssm.model.DescribeInstancePatchesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInstancePatchesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInstancePatches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInstancePatches" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeInstancePatchesIterable describeInstancePatchesPaginator(
            DescribeInstancePatchesRequest describeInstancePatchesRequest) throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidFilterException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return new DescribeInstancePatchesIterable(this, applyPaginatorUserAgent(describeInstancePatchesRequest));
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     *
     * @param describeInventoryDeletionsRequest
     * @return Result of the DescribeInventoryDeletions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDeletionIdException
     *         The ID specified for the delete operation doesn't exist or isn't valid. Verify the ID and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInventoryDeletionsResponse describeInventoryDeletions(
            DescribeInventoryDeletionsRequest describeInventoryDeletionsRequest) throws InternalServerErrorException,
            InvalidDeletionIdException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeInventoryDeletionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeInventoryDeletionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeInventoryDeletionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeInventoryDeletions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeInventoryDeletionsRequest, DescribeInventoryDeletionsResponse>()
                            .withOperationName("DescribeInventoryDeletions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeInventoryDeletionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeInventoryDeletionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a specific delete inventory operation.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable responses = client.describeInventoryDeletionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable responses = client
     *             .describeInventoryDeletionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeInventoryDeletionsIterable responses = client.describeInventoryDeletionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeInventoryDeletions(software.amazon.awssdk.services.ssm.model.DescribeInventoryDeletionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeInventoryDeletionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDeletionIdException
     *         The ID specified for the delete operation doesn't exist or isn't valid. Verify the ID and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeInventoryDeletions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeInventoryDeletions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeInventoryDeletionsIterable describeInventoryDeletionsPaginator(
            DescribeInventoryDeletionsRequest describeInventoryDeletionsRequest) throws InternalServerErrorException,
            InvalidDeletionIdException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeInventoryDeletionsIterable(this, applyPaginatorUserAgent(describeInventoryDeletionsRequest));
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance
     * window execution.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     * @return Result of the DescribeMaintenanceWindowExecutionTaskInvocations operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowExecutionTaskInvocationsResponse describeMaintenanceWindowExecutionTaskInvocations(
            DescribeMaintenanceWindowExecutionTaskInvocationsRequest describeMaintenanceWindowExecutionTaskInvocationsRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMaintenanceWindowExecutionTaskInvocationsResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeMaintenanceWindowExecutionTaskInvocationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowExecutionTaskInvocationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowExecutionTaskInvocations");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowExecutionTaskInvocationsRequest, DescribeMaintenanceWindowExecutionTaskInvocationsResponse>()
                            .withOperationName("DescribeMaintenanceWindowExecutionTaskInvocations")
                            .withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeMaintenanceWindowExecutionTaskInvocationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(
                                    new DescribeMaintenanceWindowExecutionTaskInvocationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the individual task executions (one per target) for a particular task run as part of a maintenance
     * window execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutionTaskInvocations(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsIterable responses = client.describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsIterable responses = client
     *             .describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTaskInvocationsIterable responses = client.describeMaintenanceWindowExecutionTaskInvocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutionTaskInvocations(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTaskInvocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTaskInvocationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutionTaskInvocations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTaskInvocations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowExecutionTaskInvocationsIterable describeMaintenanceWindowExecutionTaskInvocationsPaginator(
            DescribeMaintenanceWindowExecutionTaskInvocationsRequest describeMaintenanceWindowExecutionTaskInvocationsRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeMaintenanceWindowExecutionTaskInvocationsIterable(this,
                applyPaginatorUserAgent(describeMaintenanceWindowExecutionTaskInvocationsRequest));
    }

    /**
     * <p>
     * For a given maintenance window execution, lists the tasks that were run.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     * @return Result of the DescribeMaintenanceWindowExecutionTasks operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowExecutionTasksResponse describeMaintenanceWindowExecutionTasks(
            DescribeMaintenanceWindowExecutionTasksRequest describeMaintenanceWindowExecutionTasksRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMaintenanceWindowExecutionTasksResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, DescribeMaintenanceWindowExecutionTasksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowExecutionTasksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowExecutionTasks");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowExecutionTasksRequest, DescribeMaintenanceWindowExecutionTasksResponse>()
                            .withOperationName("DescribeMaintenanceWindowExecutionTasks").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(describeMaintenanceWindowExecutionTasksRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeMaintenanceWindowExecutionTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * For a given maintenance window execution, lists the tasks that were run.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutionTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksIterable responses = client.describeMaintenanceWindowExecutionTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksIterable responses = client
     *             .describeMaintenanceWindowExecutionTasksPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionTasksIterable responses = client.describeMaintenanceWindowExecutionTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutionTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowExecutionTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutionTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutionTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowExecutionTasksIterable describeMaintenanceWindowExecutionTasksPaginator(
            DescribeMaintenanceWindowExecutionTasksRequest describeMaintenanceWindowExecutionTasksRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeMaintenanceWindowExecutionTasksIterable(this,
                applyPaginatorUserAgent(describeMaintenanceWindowExecutionTasksRequest));
    }

    /**
     * <p>
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was
     * scheduled to be active, and information about tasks registered and run with the maintenance window.
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     * @return Result of the DescribeMaintenanceWindowExecutions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowExecutionsResponse describeMaintenanceWindowExecutions(
            DescribeMaintenanceWindowExecutionsRequest describeMaintenanceWindowExecutionsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMaintenanceWindowExecutionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeMaintenanceWindowExecutionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowExecutionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowExecutions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowExecutionsRequest, DescribeMaintenanceWindowExecutionsResponse>()
                            .withOperationName("DescribeMaintenanceWindowExecutions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeMaintenanceWindowExecutionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeMaintenanceWindowExecutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the executions of a maintenance window. This includes information about when the maintenance window was
     * scheduled to be active, and information about tasks registered and run with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowExecutions(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsIterable responses = client.describeMaintenanceWindowExecutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsIterable responses = client
     *             .describeMaintenanceWindowExecutionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowExecutionsIterable responses = client.describeMaintenanceWindowExecutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowExecutions(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowExecutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowExecutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowExecutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowExecutionsIterable describeMaintenanceWindowExecutionsPaginator(
            DescribeMaintenanceWindowExecutionsRequest describeMaintenanceWindowExecutionsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeMaintenanceWindowExecutionsIterable(this,
                applyPaginatorUserAgent(describeMaintenanceWindowExecutionsRequest));
    }

    /**
     * <p>
     * Retrieves information about upcoming executions of a maintenance window.
     * </p>
     *
     * @param describeMaintenanceWindowScheduleRequest
     * @return Result of the DescribeMaintenanceWindowSchedule operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowScheduleResponse describeMaintenanceWindowSchedule(
            DescribeMaintenanceWindowScheduleRequest describeMaintenanceWindowScheduleRequest)
            throws InternalServerErrorException, DoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMaintenanceWindowScheduleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeMaintenanceWindowScheduleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowScheduleRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowSchedule");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowScheduleRequest, DescribeMaintenanceWindowScheduleResponse>()
                            .withOperationName("DescribeMaintenanceWindowSchedule").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeMaintenanceWindowScheduleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeMaintenanceWindowScheduleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about upcoming executions of a maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowSchedule(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowScheduleIterable responses = client.describeMaintenanceWindowSchedulePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowScheduleIterable responses = client
     *             .describeMaintenanceWindowSchedulePaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowScheduleIterable responses = client.describeMaintenanceWindowSchedulePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowSchedule(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowScheduleRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowSchedule
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowSchedule"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowScheduleIterable describeMaintenanceWindowSchedulePaginator(
            DescribeMaintenanceWindowScheduleRequest describeMaintenanceWindowScheduleRequest)
            throws InternalServerErrorException, DoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeMaintenanceWindowScheduleIterable(this,
                applyPaginatorUserAgent(describeMaintenanceWindowScheduleRequest));
    }

    /**
     * <p>
     * Lists the targets registered with the maintenance window.
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     * @return Result of the DescribeMaintenanceWindowTargets operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowTargetsResponse describeMaintenanceWindowTargets(
            DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMaintenanceWindowTargetsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeMaintenanceWindowTargetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowTargetsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowTargets");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowTargetsRequest, DescribeMaintenanceWindowTargetsResponse>()
                            .withOperationName("DescribeMaintenanceWindowTargets").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeMaintenanceWindowTargetsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeMaintenanceWindowTargetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the targets registered with the maintenance window.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowTargets(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsIterable responses = client.describeMaintenanceWindowTargetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsIterable responses = client
     *             .describeMaintenanceWindowTargetsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTargetsIterable responses = client.describeMaintenanceWindowTargetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowTargets(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTargetsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowTargetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowTargets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTargets"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowTargetsIterable describeMaintenanceWindowTargetsPaginator(
            DescribeMaintenanceWindowTargetsRequest describeMaintenanceWindowTargetsRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeMaintenanceWindowTargetsIterable(this,
                applyPaginatorUserAgent(describeMaintenanceWindowTargetsRequest));
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you can't supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values don't affect the running of your task and can be
     * ignored.
     * </p>
     * </note>
     *
     * @param describeMaintenanceWindowTasksRequest
     * @return Result of the DescribeMaintenanceWindowTasks operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowTasksResponse describeMaintenanceWindowTasks(
            DescribeMaintenanceWindowTasksRequest describeMaintenanceWindowTasksRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMaintenanceWindowTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeMaintenanceWindowTasksResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowTasksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowTasks");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowTasksRequest, DescribeMaintenanceWindowTasksResponse>()
                            .withOperationName("DescribeMaintenanceWindowTasks").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeMaintenanceWindowTasksRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeMaintenanceWindowTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you can't supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values don't affect the running of your task and can be
     * ignored.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksIterable responses = client.describeMaintenanceWindowTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksIterable responses = client
     *             .describeMaintenanceWindowTasksPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowTasksIterable responses = client.describeMaintenanceWindowTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowTasks(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowTasksIterable describeMaintenanceWindowTasksPaginator(
            DescribeMaintenanceWindowTasksRequest describeMaintenanceWindowTasksRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeMaintenanceWindowTasksIterable(this, applyPaginatorUserAgent(describeMaintenanceWindowTasksRequest));
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an Amazon Web Services account.
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     * @return Result of the DescribeMaintenanceWindows operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowsResponse describeMaintenanceWindows(
            DescribeMaintenanceWindowsRequest describeMaintenanceWindowsRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMaintenanceWindowsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeMaintenanceWindowsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeMaintenanceWindowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindows");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowsRequest, DescribeMaintenanceWindowsResponse>()
                            .withOperationName("DescribeMaintenanceWindows").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeMaintenanceWindowsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeMaintenanceWindowsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the maintenance windows in an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable responses = client.describeMaintenanceWindowsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable responses = client
     *             .describeMaintenanceWindowsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsIterable responses = client.describeMaintenanceWindowsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindows(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindows"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowsIterable describeMaintenanceWindowsPaginator(
            DescribeMaintenanceWindowsRequest describeMaintenanceWindowsRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return new DescribeMaintenanceWindowsIterable(this, applyPaginatorUserAgent(describeMaintenanceWindowsRequest));
    }

    /**
     * <p>
     * Retrieves information about the maintenance window targets or tasks that a managed node is associated with.
     * </p>
     *
     * @param describeMaintenanceWindowsForTargetRequest
     * @return Result of the DescribeMaintenanceWindowsForTarget operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowsForTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowsForTargetResponse describeMaintenanceWindowsForTarget(
            DescribeMaintenanceWindowsForTargetRequest describeMaintenanceWindowsForTargetRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeMaintenanceWindowsForTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeMaintenanceWindowsForTargetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeMaintenanceWindowsForTargetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeMaintenanceWindowsForTarget");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeMaintenanceWindowsForTargetRequest, DescribeMaintenanceWindowsForTargetResponse>()
                            .withOperationName("DescribeMaintenanceWindowsForTarget").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeMaintenanceWindowsForTargetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeMaintenanceWindowsForTargetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about the maintenance window targets or tasks that a managed node is associated with.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeMaintenanceWindowsForTarget(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetIterable responses = client.describeMaintenanceWindowsForTargetPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetIterable responses = client
     *             .describeMaintenanceWindowsForTargetPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeMaintenanceWindowsForTargetIterable responses = client.describeMaintenanceWindowsForTargetPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeMaintenanceWindowsForTarget(software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsForTargetRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeMaintenanceWindowsForTargetRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeMaintenanceWindowsForTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeMaintenanceWindowsForTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeMaintenanceWindowsForTargetIterable describeMaintenanceWindowsForTargetPaginator(
            DescribeMaintenanceWindowsForTargetRequest describeMaintenanceWindowsForTargetRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeMaintenanceWindowsForTargetIterable(this,
                applyPaginatorUserAgent(describeMaintenanceWindowsForTargetRequest));
    }

    /**
     * <p>
     * Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of
     * OpsItems. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate,
     * and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon
     * Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param describeOpsItemsRequest
     * @return Result of the DescribeOpsItems operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeOpsItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeOpsItemsResponse describeOpsItems(DescribeOpsItemsRequest describeOpsItemsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeOpsItemsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeOpsItemsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeOpsItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeOpsItems");

            return clientHandler.execute(new ClientExecutionParams<DescribeOpsItemsRequest, DescribeOpsItemsResponse>()
                    .withOperationName("DescribeOpsItems").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeOpsItemsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeOpsItemsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Query a set of OpsItems. You must have permission in Identity and Access Management (IAM) to query a list of
     * OpsItems. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate,
     * and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon
     * Web Services Systems Manager User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeOpsItems(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsIterable responses = client.describeOpsItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsIterable responses = client.describeOpsItemsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeOpsItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeOpsItemsIterable responses = client.describeOpsItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeOpsItems(software.amazon.awssdk.services.ssm.model.DescribeOpsItemsRequest)} operation.</b>
     * </p>
     *
     * @param describeOpsItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeOpsItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeOpsItems" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeOpsItemsIterable describeOpsItemsPaginator(DescribeOpsItemsRequest describeOpsItemsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeOpsItemsIterable(this, applyPaginatorUserAgent(describeOpsItemsRequest));
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * <important>
     * <p>
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key
     * alias the parameter uses to reference KMS. Otherwise, <code>DescribeParameters</code> retrieves whatever the
     * original key alias was referencing.
     * </p>
     * </important>
     *
     * @param describeParametersRequest
     * @return Result of the DescribeParameters operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option isn't valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value isn't valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeParametersResponse describeParameters(DescribeParametersRequest describeParametersRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidFilterOptionException,
            InvalidFilterValueException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeParametersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeParameters");

            return clientHandler.execute(new ClientExecutionParams<DescribeParametersRequest, DescribeParametersResponse>()
                    .withOperationName("DescribeParameters").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeParametersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get information about a parameter.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * <important>
     * <p>
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key
     * alias the parameter uses to reference KMS. Otherwise, <code>DescribeParameters</code> retrieves whatever the
     * original key alias was referencing.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable responses = client.describeParametersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable responses = client
     *             .describeParametersPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeParametersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeParametersIterable responses = client.describeParametersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeParameters(software.amazon.awssdk.services.ssm.model.DescribeParametersRequest)} operation.</b>
     * </p>
     *
     * @param describeParametersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option isn't valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value isn't valid. Verify the value and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeParametersIterable describeParametersPaginator(DescribeParametersRequest describeParametersRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidFilterOptionException,
            InvalidFilterValueException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return new DescribeParametersIterable(this, applyPaginatorUserAgent(describeParametersRequest));
    }

    /**
     * <p>
     * Lists the patch baselines in your Amazon Web Services account.
     * </p>
     *
     * @param describePatchBaselinesRequest
     * @return Result of the DescribePatchBaselines operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribePatchBaselinesResponse describePatchBaselines(DescribePatchBaselinesRequest describePatchBaselinesRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePatchBaselinesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePatchBaselinesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePatchBaselinesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePatchBaselines");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePatchBaselinesRequest, DescribePatchBaselinesResponse>()
                            .withOperationName("DescribePatchBaselines").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describePatchBaselinesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePatchBaselinesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the patch baselines in your Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable responses = client.describePatchBaselinesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable responses = client
     *             .describePatchBaselinesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchBaselinesIterable responses = client.describePatchBaselinesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchBaselines(software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePatchBaselinesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchBaselines
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchBaselines" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribePatchBaselinesIterable describePatchBaselinesPaginator(
            DescribePatchBaselinesRequest describePatchBaselinesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return new DescribePatchBaselinesIterable(this, applyPaginatorUserAgent(describePatchBaselinesRequest));
    }

    /**
     * <p>
     * Returns high-level aggregated patch compliance state information for a patch group.
     * </p>
     *
     * @param describePatchGroupStateRequest
     * @return Result of the DescribePatchGroupState operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchGroupState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroupState" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribePatchGroupStateResponse describePatchGroupState(DescribePatchGroupStateRequest describePatchGroupStateRequest)
            throws InternalServerErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePatchGroupStateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePatchGroupStateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePatchGroupStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePatchGroupState");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePatchGroupStateRequest, DescribePatchGroupStateResponse>()
                            .withOperationName("DescribePatchGroupState").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describePatchGroupStateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePatchGroupStateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     *
     * @param describePatchGroupsRequest
     * @return Result of the DescribePatchGroups operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribePatchGroupsResponse describePatchGroups(DescribePatchGroupsRequest describePatchGroupsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePatchGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePatchGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePatchGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePatchGroups");

            return clientHandler.execute(new ClientExecutionParams<DescribePatchGroupsRequest, DescribePatchGroupsResponse>()
                    .withOperationName("DescribePatchGroups").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describePatchGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribePatchGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all patch groups that have been registered with patch baselines.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable responses = client.describePatchGroupsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable responses = client
     *             .describePatchGroupsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribePatchGroupsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchGroupsIterable responses = client.describePatchGroupsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchGroups(software.amazon.awssdk.services.ssm.model.DescribePatchGroupsRequest)} operation.</b>
     * </p>
     *
     * @param describePatchGroupsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribePatchGroupsIterable describePatchGroupsPaginator(DescribePatchGroupsRequest describePatchGroupsRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return new DescribePatchGroupsIterable(this, applyPaginatorUserAgent(describePatchGroupsRequest));
    }

    /**
     * <p>
     * Lists the properties of available patches organized by product, product family, classification, severity, and
     * other properties of available patches. You can use the reported properties in the filters you specify in requests
     * for operations such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>,
     * and <a>DescribePatchBaselines</a>.
     * </p>
     * <p>
     * The following section lists the properties that can be used in filters for each major operating system type:
     * </p>
     * <dl>
     * <dt>AMAZON_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>AMAZON_LINUX_2</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>CENTOS</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>DEBIAN</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code>
     * </p>
     * </dd>
     * <dt>MACOS</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code>
     * </p>
     * </dd>
     * <dt>ORACLE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>REDHAT_ENTERPRISE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>SUSE</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>UBUNTU</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code>
     * </p>
     * </dd>
     * <dt>WINDOWS</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>PRODUCT_FAMILY</code> | <code>CLASSIFICATION</code> |
     * <code>MSRC_SEVERITY</code>
     * </p>
     * </dd>
     * </dl>
     *
     * @param describePatchPropertiesRequest
     * @return Result of the DescribePatchProperties operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribePatchPropertiesResponse describePatchProperties(DescribePatchPropertiesRequest describePatchPropertiesRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribePatchPropertiesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribePatchPropertiesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describePatchPropertiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribePatchProperties");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribePatchPropertiesRequest, DescribePatchPropertiesResponse>()
                            .withOperationName("DescribePatchProperties").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describePatchPropertiesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribePatchPropertiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the properties of available patches organized by product, product family, classification, severity, and
     * other properties of available patches. You can use the reported properties in the filters you specify in requests
     * for operations such as <a>CreatePatchBaseline</a>, <a>UpdatePatchBaseline</a>, <a>DescribeAvailablePatches</a>,
     * and <a>DescribePatchBaselines</a>.
     * </p>
     * <p>
     * The following section lists the properties that can be used in filters for each major operating system type:
     * </p>
     * <dl>
     * <dt>AMAZON_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>AMAZON_LINUX_2</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>CENTOS</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>DEBIAN</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code>
     * </p>
     * </dd>
     * <dt>MACOS</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code>
     * </p>
     * </dd>
     * <dt>ORACLE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>REDHAT_ENTERPRISE_LINUX</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>SUSE</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>CLASSIFICATION</code> | <code>SEVERITY</code>
     * </p>
     * </dd>
     * <dt>UBUNTU</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>PRIORITY</code>
     * </p>
     * </dd>
     * <dt>WINDOWS</dt>
     * <dd>
     * <p>
     * Valid properties: <code>PRODUCT</code> | <code>PRODUCT_FAMILY</code> | <code>CLASSIFICATION</code> |
     * <code>MSRC_SEVERITY</code>
     * </p>
     * </dd>
     * </dl>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describePatchProperties(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesIterable responses = client.describePatchPropertiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesIterable responses = client
     *             .describePatchPropertiesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribePatchPropertiesIterable responses = client.describePatchPropertiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describePatchProperties(software.amazon.awssdk.services.ssm.model.DescribePatchPropertiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describePatchPropertiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribePatchProperties
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribePatchProperties" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribePatchPropertiesIterable describePatchPropertiesPaginator(
            DescribePatchPropertiesRequest describePatchPropertiesRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        return new DescribePatchPropertiesIterable(this, applyPaginatorUserAgent(describePatchPropertiesRequest));
    }

    /**
     * <p>
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30
     * days.
     * </p>
     *
     * @param describeSessionsRequest
     * @return Result of the DescribeSessions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeSessionsResponse describeSessions(DescribeSessionsRequest describeSessionsRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeSessionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeSessionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeSessionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeSessions");

            return clientHandler.execute(new ClientExecutionParams<DescribeSessionsRequest, DescribeSessionsResponse>()
                    .withOperationName("DescribeSessions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeSessionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeSessionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of all active sessions (both connected and disconnected) or terminated sessions from the past 30
     * days.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeSessions(software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeSessionsIterable responses = client.describeSessionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.DescribeSessionsIterable responses = client.describeSessionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.DescribeSessionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.DescribeSessionsIterable responses = client.describeSessionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSessions(software.amazon.awssdk.services.ssm.model.DescribeSessionsRequest)} operation.</b>
     * </p>
     *
     * @param describeSessionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DescribeSessions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeSessionsIterable describeSessionsPaginator(DescribeSessionsRequest describeSessionsRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return new DescribeSessionsIterable(this, applyPaginatorUserAgent(describeSessionsRequest));
    }

    /**
     * <p>
     * Deletes the association between an OpsItem and a related item. For example, this API operation can delete an
     * Incident Manager incident from an OpsItem. Incident Manager is a capability of Amazon Web Services Systems
     * Manager.
     * </p>
     *
     * @param disassociateOpsItemRelatedItemRequest
     * @return Result of the DisassociateOpsItemRelatedItem operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemRelatedItemAssociationNotFoundException
     *         The association wasn't found using the parameters you specified in the call. Verify the information and
     *         try again.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.DisassociateOpsItemRelatedItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/DisassociateOpsItemRelatedItem"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateOpsItemRelatedItemResponse disassociateOpsItemRelatedItem(
            DisassociateOpsItemRelatedItemRequest disassociateOpsItemRelatedItemRequest) throws InternalServerErrorException,
            OpsItemRelatedItemAssociationNotFoundException, OpsItemNotFoundException, OpsItemInvalidParameterException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateOpsItemRelatedItemResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateOpsItemRelatedItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                disassociateOpsItemRelatedItemRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateOpsItemRelatedItem");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateOpsItemRelatedItemRequest, DisassociateOpsItemRelatedItemResponse>()
                            .withOperationName("DisassociateOpsItemRelatedItem").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(disassociateOpsItemRelatedItemRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateOpsItemRelatedItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get detailed information about a particular Automation execution.
     * </p>
     *
     * @param getAutomationExecutionRequest
     * @return Result of the GetAutomationExecution operation returned by the service.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetAutomationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetAutomationExecutionResponse getAutomationExecution(GetAutomationExecutionRequest getAutomationExecutionRequest)
            throws AutomationExecutionNotFoundException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAutomationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAutomationExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAutomationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAutomationExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAutomationExecutionRequest, GetAutomationExecutionResponse>()
                            .withOperationName("GetAutomationExecution").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getAutomationExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAutomationExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the state of a Amazon Web Services Systems Manager change calendar at the current time or a specified time.
     * If you specify a time, <code>GetCalendarState</code> returns the state of the calendar at that specific time, and
     * returns the next time that the change calendar state will transition. If you don't specify a time,
     * <code>GetCalendarState</code> uses the current time. Change Calendar entries have two possible states:
     * <code>OPEN</code> or <code>CLOSED</code>.
     * </p>
     * <p>
     * If you specify more than one calendar in a request, the command returns the status of <code>OPEN</code> only if
     * all calendars in the request are open. If one or more calendars in the request are closed, the status returned is
     * <code>CLOSED</code>.
     * </p>
     * <p>
     * For more information about Change Calendar, a capability of Amazon Web Services Systems Manager, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html">Amazon
     * Web Services Systems Manager Change Calendar</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param getCalendarStateRequest
     * @return Result of the GetCalendarState operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentTypeException
     *         The SSM document type isn't valid. Valid document types are described in the <code>DocumentType</code>
     *         property.
     * @throws UnsupportedCalendarException
     *         The calendar entry contained in the specified SSM document isn't supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetCalendarState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCalendarState" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCalendarStateResponse getCalendarState(GetCalendarStateRequest getCalendarStateRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentTypeException,
            UnsupportedCalendarException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCalendarStateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCalendarStateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCalendarStateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCalendarState");

            return clientHandler.execute(new ClientExecutionParams<GetCalendarStateRequest, GetCalendarStateResponse>()
                    .withOperationName("GetCalendarState").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getCalendarStateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCalendarStateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns detailed information about command execution for an invocation or plugin.
     * </p>
     * <p>
     * <code>GetCommandInvocation</code> only gives the execution status of a plugin in a document. To get the command
     * execution status on a specific managed node, use <a>ListCommandInvocations</a>. To get the command execution
     * status across managed nodes, use <a>ListCommands</a>.
     * </p>
     *
     * @param getCommandInvocationRequest
     * @return Result of the GetCommandInvocation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     *         The specified command ID isn't valid. Verify the ID and try again.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidPluginNameException
     *         The plugin name isn't valid.
     * @throws InvocationDoesNotExistException
     *         The command ID and managed node ID you specified didn't match any invocations. Verify the command ID and
     *         the managed node ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetCommandInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetCommandInvocation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCommandInvocationResponse getCommandInvocation(GetCommandInvocationRequest getCommandInvocationRequest)
            throws InternalServerErrorException, InvalidCommandIdException, InvalidInstanceIdException,
            InvalidPluginNameException, InvocationDoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCommandInvocationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCommandInvocationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCommandInvocationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCommandInvocation");

            return clientHandler.execute(new ClientExecutionParams<GetCommandInvocationRequest, GetCommandInvocationResponse>()
                    .withOperationName("GetCommandInvocation").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getCommandInvocationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCommandInvocationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the Session Manager connection status for a managed node to determine whether it is running and ready
     * to receive Session Manager connections.
     * </p>
     *
     * @param getConnectionStatusRequest
     * @return Result of the GetConnectionStatus operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetConnectionStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetConnectionStatus" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetConnectionStatusResponse getConnectionStatus(GetConnectionStatusRequest getConnectionStatusRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetConnectionStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetConnectionStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getConnectionStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetConnectionStatus");

            return clientHandler.execute(new ClientExecutionParams<GetConnectionStatusRequest, GetConnectionStatusResponse>()
                    .withOperationName("GetConnectionStatus").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getConnectionStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetConnectionStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the default patch baseline. Amazon Web Services Systems Manager supports creating multiple default
     * patch baselines. For example, you can create a default patch baseline for each operating system.
     * </p>
     * <p>
     * If you don't specify an operating system value, the default patch baseline for Windows is returned.
     * </p>
     *
     * @param getDefaultPatchBaselineRequest
     * @return Result of the GetDefaultPatchBaseline operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetDefaultPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDefaultPatchBaseline" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetDefaultPatchBaselineResponse getDefaultPatchBaseline(GetDefaultPatchBaselineRequest getDefaultPatchBaselineRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDefaultPatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDefaultPatchBaselineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDefaultPatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDefaultPatchBaseline");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDefaultPatchBaselineRequest, GetDefaultPatchBaselineResponse>()
                            .withOperationName("GetDefaultPatchBaseline").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getDefaultPatchBaselineRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDefaultPatchBaselineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the current snapshot for the patch baseline the managed node uses. This API is primarily used by the
     * <code>AWS-RunPatchBaseline</code> Systems Manager document (SSM document).
     * </p>
     * <note>
     * <p>
     * If you run the command locally, such as with the Command Line Interface (CLI), the system attempts to use your
     * local Amazon Web Services credentials and the operation fails. To avoid this, you can run the command in the
     * Amazon Web Services Systems Manager console. Use Run Command, a capability of Amazon Web Services Systems
     * Manager, with an SSM document that enables you to target a managed node with a script or command. For example,
     * run the command using the <code>AWS-RunShellScript</code> document or the <code>AWS-RunPowerShellScript</code>
     * document.
     * </p>
     * </note>
     *
     * @param getDeployablePatchSnapshotForInstanceRequest
     * @return Result of the GetDeployablePatchSnapshotForInstance operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws UnsupportedOperatingSystemException
     *         The operating systems you specified isn't supported, or the operation isn't supported for the operating
     *         system.
     * @throws UnsupportedFeatureRequiredException
     *         Patching for applications released by Microsoft is only available on EC2 instances and advanced
     *         instances. To patch applications released by Microsoft on on-premises servers and VMs, you must enable
     *         advanced instances. For more information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances-advanced.html"
     *         >Enabling the advanced-instances tier</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetDeployablePatchSnapshotForInstance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDeployablePatchSnapshotForInstance"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDeployablePatchSnapshotForInstanceResponse getDeployablePatchSnapshotForInstance(
            GetDeployablePatchSnapshotForInstanceRequest getDeployablePatchSnapshotForInstanceRequest)
            throws InternalServerErrorException, UnsupportedOperatingSystemException, UnsupportedFeatureRequiredException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDeployablePatchSnapshotForInstanceResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetDeployablePatchSnapshotForInstanceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getDeployablePatchSnapshotForInstanceRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDeployablePatchSnapshotForInstance");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDeployablePatchSnapshotForInstanceRequest, GetDeployablePatchSnapshotForInstanceResponse>()
                            .withOperationName("GetDeployablePatchSnapshotForInstance").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler)
                            .withInput(getDeployablePatchSnapshotForInstanceRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDeployablePatchSnapshotForInstanceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets the contents of the specified Amazon Web Services Systems Manager document (SSM document).
     * </p>
     *
     * @param getDocumentRequest
     * @return Result of the GetDocument operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentVersionException
     *         The document version isn't valid or doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDocumentResponse getDocument(GetDocumentRequest getDocumentRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDocumentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDocumentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDocument");

            return clientHandler.execute(new ClientExecutionParams<GetDocumentRequest, GetDocumentResponse>()
                    .withOperationName("GetDocument").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDocumentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDocumentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Query inventory information. This includes managed node status, such as <code>Stopped</code> or
     * <code>Terminated</code>.
     * </p>
     *
     * @param getInventoryRequest
     * @return Result of the GetInventory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidInventoryGroupException
     *         The specified inventory group isn't valid.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidTypeNameException
     *         The parameter type name isn't valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator isn't valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws InvalidResultAttributeException
     *         The specified inventory item result attribute isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInventoryResponse getInventory(GetInventoryRequest getInventoryRequest) throws InternalServerErrorException,
            InvalidFilterException, InvalidInventoryGroupException, InvalidNextTokenException, InvalidTypeNameException,
            InvalidAggregatorException, InvalidResultAttributeException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInventoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetInventoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInventoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInventory");

            return clientHandler.execute(new ClientExecutionParams<GetInventoryRequest, GetInventoryResponse>()
                    .withOperationName("GetInventory").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getInventoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetInventoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Query inventory information. This includes managed node status, such as <code>Stopped</code> or
     * <code>Terminated</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable responses = client.getInventoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable responses = client.getInventoryPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetInventoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventoryIterable responses = client.getInventoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventory(software.amazon.awssdk.services.ssm.model.GetInventoryRequest)} operation.</b>
     * </p>
     *
     * @param getInventoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidInventoryGroupException
     *         The specified inventory group isn't valid.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidTypeNameException
     *         The parameter type name isn't valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator isn't valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws InvalidResultAttributeException
     *         The specified inventory item result attribute isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInventoryIterable getInventoryPaginator(GetInventoryRequest getInventoryRequest)
            throws InternalServerErrorException, InvalidFilterException, InvalidInventoryGroupException,
            InvalidNextTokenException, InvalidTypeNameException, InvalidAggregatorException, InvalidResultAttributeException,
            AwsServiceException, SdkClientException, SsmException {
        return new GetInventoryIterable(this, applyPaginatorUserAgent(getInventoryRequest));
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     *
     * @param getInventorySchemaRequest
     * @return Result of the GetInventorySchema operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name isn't valid.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInventorySchemaResponse getInventorySchema(GetInventorySchemaRequest getInventorySchemaRequest)
            throws InternalServerErrorException, InvalidTypeNameException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetInventorySchemaResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetInventorySchemaResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getInventorySchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetInventorySchema");

            return clientHandler.execute(new ClientExecutionParams<GetInventorySchemaRequest, GetInventorySchemaResponse>()
                    .withOperationName("GetInventorySchema").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getInventorySchemaRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetInventorySchemaRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Return a list of inventory type names for the account, or return a list of attribute names for a specific
     * Inventory item type.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable responses = client.getInventorySchemaPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable responses = client
     *             .getInventorySchemaPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetInventorySchemaResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetInventorySchemaIterable responses = client.getInventorySchemaPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInventorySchema(software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest)} operation.</b>
     * </p>
     *
     * @param getInventorySchemaRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidTypeNameException
     *         The parameter type name isn't valid.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetInventorySchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetInventorySchema" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetInventorySchemaIterable getInventorySchemaPaginator(GetInventorySchemaRequest getInventorySchemaRequest)
            throws InternalServerErrorException, InvalidTypeNameException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return new GetInventorySchemaIterable(this, applyPaginatorUserAgent(getInventorySchemaRequest));
    }

    /**
     * <p>
     * Retrieves a maintenance window.
     * </p>
     *
     * @param getMaintenanceWindowRequest
     * @return Result of the GetMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMaintenanceWindowResponse getMaintenanceWindow(GetMaintenanceWindowRequest getMaintenanceWindowRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMaintenanceWindowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMaintenanceWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMaintenanceWindow");

            return clientHandler.execute(new ClientExecutionParams<GetMaintenanceWindowRequest, GetMaintenanceWindowResponse>()
                    .withOperationName("GetMaintenanceWindow").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getMaintenanceWindowRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMaintenanceWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves details about a specific a maintenance window execution.
     * </p>
     *
     * @param getMaintenanceWindowExecutionRequest
     * @return Result of the GetMaintenanceWindowExecution operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindowExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMaintenanceWindowExecutionResponse getMaintenanceWindowExecution(
            GetMaintenanceWindowExecutionRequest getMaintenanceWindowExecutionRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMaintenanceWindowExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMaintenanceWindowExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMaintenanceWindowExecutionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMaintenanceWindowExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<GetMaintenanceWindowExecutionRequest, GetMaintenanceWindowExecutionResponse>()
                            .withOperationName("GetMaintenanceWindowExecution").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getMaintenanceWindowExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetMaintenanceWindowExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the details about a specific task run as part of a maintenance window execution.
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskRequest
     * @return Result of the GetMaintenanceWindowExecutionTask operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindowExecutionTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMaintenanceWindowExecutionTaskResponse getMaintenanceWindowExecutionTask(
            GetMaintenanceWindowExecutionTaskRequest getMaintenanceWindowExecutionTaskRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMaintenanceWindowExecutionTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMaintenanceWindowExecutionTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMaintenanceWindowExecutionTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMaintenanceWindowExecutionTask");

            return clientHandler
                    .execute(new ClientExecutionParams<GetMaintenanceWindowExecutionTaskRequest, GetMaintenanceWindowExecutionTaskResponse>()
                            .withOperationName("GetMaintenanceWindowExecutionTask").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getMaintenanceWindowExecutionTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetMaintenanceWindowExecutionTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves information about a specific task running on a specific target.
     * </p>
     *
     * @param getMaintenanceWindowExecutionTaskInvocationRequest
     * @return Result of the GetMaintenanceWindowExecutionTaskInvocation operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindowExecutionTaskInvocation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowExecutionTaskInvocation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetMaintenanceWindowExecutionTaskInvocationResponse getMaintenanceWindowExecutionTaskInvocation(
            GetMaintenanceWindowExecutionTaskInvocationRequest getMaintenanceWindowExecutionTaskInvocationRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMaintenanceWindowExecutionTaskInvocationResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, GetMaintenanceWindowExecutionTaskInvocationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getMaintenanceWindowExecutionTaskInvocationRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMaintenanceWindowExecutionTaskInvocation");

            return clientHandler
                    .execute(new ClientExecutionParams<GetMaintenanceWindowExecutionTaskInvocationRequest, GetMaintenanceWindowExecutionTaskInvocationResponse>()
                            .withOperationName("GetMaintenanceWindowExecutionTaskInvocation")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getMaintenanceWindowExecutionTaskInvocationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetMaintenanceWindowExecutionTaskInvocationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tasks in a maintenance window.
     * </p>
     * <note>
     * <p>
     * For maintenance window tasks without a specified target, you can't supply values for <code>--max-errors</code>
     * and <code>--max-concurrency</code>. Instead, the system inserts a placeholder value of <code>1</code>, which may
     * be reported in the response to this command. These values don't affect the running of your task and can be
     * ignored.
     * </p>
     * </note>
     *
     * @param getMaintenanceWindowTaskRequest
     * @return Result of the GetMaintenanceWindowTask operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetMaintenanceWindowTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetMaintenanceWindowTask" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetMaintenanceWindowTaskResponse getMaintenanceWindowTask(
            GetMaintenanceWindowTaskRequest getMaintenanceWindowTaskRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMaintenanceWindowTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetMaintenanceWindowTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMaintenanceWindowTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMaintenanceWindowTask");

            return clientHandler
                    .execute(new ClientExecutionParams<GetMaintenanceWindowTaskRequest, GetMaintenanceWindowTaskResponse>()
                            .withOperationName("GetMaintenanceWindowTask").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getMaintenanceWindowTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetMaintenanceWindowTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get information about an OpsItem by using the ID. You must have permission in Identity and Access Management
     * (IAM) to view information about an OpsItem. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate,
     * and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon
     * Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param getOpsItemRequest
     * @return Result of the GetOpsItem operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetOpsItemResponse getOpsItem(GetOpsItemRequest getOpsItemRequest) throws InternalServerErrorException,
            OpsItemNotFoundException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOpsItemResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetOpsItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOpsItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOpsItem");

            return clientHandler
                    .execute(new ClientExecutionParams<GetOpsItemRequest, GetOpsItemResponse>().withOperationName("GetOpsItem")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(getOpsItemRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetOpsItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * View operational metadata related to an application in Application Manager.
     * </p>
     *
     * @param getOpsMetadataRequest
     * @return Result of the GetOpsMetadata operation returned by the service.
     * @throws OpsMetadataNotFoundException
     *         The OpsMetadata object doesn't exist.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetOpsMetadataResponse getOpsMetadata(GetOpsMetadataRequest getOpsMetadataRequest)
            throws OpsMetadataNotFoundException, OpsMetadataInvalidArgumentException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOpsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetOpsMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOpsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOpsMetadata");

            return clientHandler.execute(new ClientExecutionParams<GetOpsMetadataRequest, GetOpsMetadataResponse>()
                    .withOperationName("GetOpsMetadata").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getOpsMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetOpsMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * View a summary of operations metadata (OpsData) based on specified filters and aggregators. OpsData can include
     * information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as well as
     * information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services
     * Systems Manager Explorer.
     * </p>
     *
     * @param getOpsSummaryRequest
     * @return Result of the GetOpsSummary operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncNotFoundException
     *         The specified sync name wasn't found.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidTypeNameException
     *         The parameter type name isn't valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator isn't valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetOpsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetOpsSummaryResponse getOpsSummary(GetOpsSummaryRequest getOpsSummaryRequest) throws InternalServerErrorException,
            ResourceDataSyncNotFoundException, InvalidFilterException, InvalidNextTokenException, InvalidTypeNameException,
            InvalidAggregatorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOpsSummaryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetOpsSummaryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOpsSummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOpsSummary");

            return clientHandler.execute(new ClientExecutionParams<GetOpsSummaryRequest, GetOpsSummaryResponse>()
                    .withOperationName("GetOpsSummary").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getOpsSummaryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetOpsSummaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * View a summary of operations metadata (OpsData) based on specified filters and aggregators. OpsData can include
     * information about Amazon Web Services Systems Manager OpsCenter operational workitems (OpsItems) as well as
     * information about any Amazon Web Services resource or service configured to report OpsData to Amazon Web Services
     * Systems Manager Explorer.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #getOpsSummary(software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryIterable responses = client.getOpsSummaryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryIterable responses = client.getOpsSummaryPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetOpsSummaryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetOpsSummaryIterable responses = client.getOpsSummaryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getOpsSummary(software.amazon.awssdk.services.ssm.model.GetOpsSummaryRequest)} operation.</b>
     * </p>
     *
     * @param getOpsSummaryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ResourceDataSyncNotFoundException
     *         The specified sync name wasn't found.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidTypeNameException
     *         The parameter type name isn't valid.
     * @throws InvalidAggregatorException
     *         The specified aggregator isn't valid for inventory groups. Verify that the aggregator uses a valid
     *         inventory type such as <code>AWS:Application</code> or <code>AWS:InstanceInformation</code>.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetOpsSummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetOpsSummary" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetOpsSummaryIterable getOpsSummaryPaginator(GetOpsSummaryRequest getOpsSummaryRequest)
            throws InternalServerErrorException, ResourceDataSyncNotFoundException, InvalidFilterException,
            InvalidNextTokenException, InvalidTypeNameException, InvalidAggregatorException, AwsServiceException,
            SdkClientException, SsmException {
        return new GetOpsSummaryIterable(this, applyPaginatorUserAgent(getOpsSummaryRequest));
    }

    /**
     * <p>
     * Get information about a single parameter by specifying the parameter name.
     * </p>
     * <note>
     * <p>
     * To get information about more than one parameter at a time, use the <a>GetParameters</a> operation.
     * </p>
     * </note>
     *
     * @param getParameterRequest
     * @return Result of the GetParameter operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidKeyIdException
     *         The query key ID isn't valid.
     * @throws ParameterNotFoundException
     *         The parameter couldn't be found. Verify the name and try again.
     * @throws ParameterVersionNotFoundException
     *         The specified parameter version wasn't found. Verify the parameter name and version, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetParameterResponse getParameter(GetParameterRequest getParameterRequest) throws InternalServerErrorException,
            InvalidKeyIdException, ParameterNotFoundException, ParameterVersionNotFoundException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetParameterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetParameterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getParameterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetParameter");

            return clientHandler.execute(new ClientExecutionParams<GetParameterRequest, GetParameterResponse>()
                    .withOperationName("GetParameter").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getParameterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetParameterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the history of all changes to a parameter.
     * </p>
     * <important>
     * <p>
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key
     * alias the parameter uses to reference KMS. Otherwise, <code>GetParameterHistory</code> retrieves whatever the
     * original key alias was referencing.
     * </p>
     * </important>
     *
     * @param getParameterHistoryRequest
     * @return Result of the GetParameterHistory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ParameterNotFoundException
     *         The parameter couldn't be found. Verify the name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidKeyIdException
     *         The query key ID isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParameterHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetParameterHistoryResponse getParameterHistory(GetParameterHistoryRequest getParameterHistoryRequest)
            throws InternalServerErrorException, ParameterNotFoundException, InvalidNextTokenException, InvalidKeyIdException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetParameterHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetParameterHistoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getParameterHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetParameterHistory");

            return clientHandler.execute(new ClientExecutionParams<GetParameterHistoryRequest, GetParameterHistoryResponse>()
                    .withOperationName("GetParameterHistory").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getParameterHistoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetParameterHistoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the history of all changes to a parameter.
     * </p>
     * <important>
     * <p>
     * If you change the KMS key alias for the KMS key used to encrypt a parameter, then you must also update the key
     * alias the parameter uses to reference KMS. Otherwise, <code>GetParameterHistory</code> retrieves whatever the
     * original key alias was referencing.
     * </p>
     * </important><br/>
     * <p>
     * This is a variant of
     * {@link #getParameterHistory(software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryIterable responses = client.getParameterHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryIterable responses = client
     *             .getParameterHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetParameterHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParameterHistoryIterable responses = client.getParameterHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getParameterHistory(software.amazon.awssdk.services.ssm.model.GetParameterHistoryRequest)} operation.</b>
     * </p>
     *
     * @param getParameterHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ParameterNotFoundException
     *         The parameter couldn't be found. Verify the name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidKeyIdException
     *         The query key ID isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParameterHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameterHistory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetParameterHistoryIterable getParameterHistoryPaginator(GetParameterHistoryRequest getParameterHistoryRequest)
            throws InternalServerErrorException, ParameterNotFoundException, InvalidNextTokenException, InvalidKeyIdException,
            AwsServiceException, SdkClientException, SsmException {
        return new GetParameterHistoryIterable(this, applyPaginatorUserAgent(getParameterHistoryRequest));
    }

    /**
     * <p>
     * Get information about one or more parameters by specifying multiple parameter names.
     * </p>
     * <note>
     * <p>
     * To get information about a single parameter, you can use the <a>GetParameter</a> operation instead.
     * </p>
     * </note>
     *
     * @param getParametersRequest
     * @return Result of the GetParameters operation returned by the service.
     * @throws InvalidKeyIdException
     *         The query key ID isn't valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParameters
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParameters" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetParametersResponse getParameters(GetParametersRequest getParametersRequest) throws InvalidKeyIdException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetParametersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetParametersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getParametersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetParameters");

            return clientHandler.execute(new ClientExecutionParams<GetParametersRequest, GetParametersResponse>()
                    .withOperationName("GetParameters").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getParametersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetParametersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieve information about one or more parameters in a specific hierarchy.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     *
     * @param getParametersByPathRequest
     * @return Result of the GetParametersByPath operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option isn't valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value isn't valid. Verify the value and try again.
     * @throws InvalidKeyIdException
     *         The query key ID isn't valid.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParametersByPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetParametersByPathResponse getParametersByPath(GetParametersByPathRequest getParametersByPathRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidFilterOptionException,
            InvalidFilterValueException, InvalidKeyIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetParametersByPathResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetParametersByPathResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getParametersByPathRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetParametersByPath");

            return clientHandler.execute(new ClientExecutionParams<GetParametersByPathRequest, GetParametersByPathResponse>()
                    .withOperationName("GetParametersByPath").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getParametersByPathRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetParametersByPathRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieve information about one or more parameters in a specific hierarchy.
     * </p>
     * <p>
     * Request results are returned on a best-effort basis. If you specify <code>MaxResults</code> in the request, the
     * response includes information up to the limit specified. The number of items returned, however, can be between
     * zero and the value of <code>MaxResults</code>. If the service reaches an internal limit while processing the
     * results, it stops the operation and returns the matching values up to that point and a <code>NextToken</code>.
     * You can specify the <code>NextToken</code> in a subsequent call to get the next set of results.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getParametersByPath(software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParametersByPathIterable responses = client.getParametersByPathPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.GetParametersByPathIterable responses = client
     *             .getParametersByPathPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.GetParametersByPathResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.GetParametersByPathIterable responses = client.getParametersByPathPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getParametersByPath(software.amazon.awssdk.services.ssm.model.GetParametersByPathRequest)} operation.</b>
     * </p>
     *
     * @param getParametersByPathRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidFilterOptionException
     *         The specified filter option isn't valid. Valid options are Equals and BeginsWith. For Path filter, valid
     *         options are Recursive and OneLevel.
     * @throws InvalidFilterValueException
     *         The filter value isn't valid. Verify the value and try again.
     * @throws InvalidKeyIdException
     *         The query key ID isn't valid.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetParametersByPath
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetParametersByPath" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetParametersByPathIterable getParametersByPathPaginator(GetParametersByPathRequest getParametersByPathRequest)
            throws InternalServerErrorException, InvalidFilterKeyException, InvalidFilterOptionException,
            InvalidFilterValueException, InvalidKeyIdException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        return new GetParametersByPathIterable(this, applyPaginatorUserAgent(getParametersByPathRequest));
    }

    /**
     * <p>
     * Retrieves information about a patch baseline.
     * </p>
     *
     * @param getPatchBaselineRequest
     * @return Result of the GetPatchBaseline operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetPatchBaselineResponse getPatchBaseline(GetPatchBaselineRequest getPatchBaselineRequest)
            throws DoesNotExistException, InvalidResourceIdException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetPatchBaselineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getPatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPatchBaseline");

            return clientHandler.execute(new ClientExecutionParams<GetPatchBaselineRequest, GetPatchBaselineResponse>()
                    .withOperationName("GetPatchBaseline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getPatchBaselineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetPatchBaselineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the patch baseline that should be used for the specified patch group.
     * </p>
     *
     * @param getPatchBaselineForPatchGroupRequest
     * @return Result of the GetPatchBaselineForPatchGroup operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetPatchBaselineForPatchGroupResponse getPatchBaselineForPatchGroup(
            GetPatchBaselineForPatchGroupRequest getPatchBaselineForPatchGroupRequest) throws InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetPatchBaselineForPatchGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetPatchBaselineForPatchGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getPatchBaselineForPatchGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetPatchBaselineForPatchGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<GetPatchBaselineForPatchGroupRequest, GetPatchBaselineForPatchGroupResponse>()
                            .withOperationName("GetPatchBaselineForPatchGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getPatchBaselineForPatchGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetPatchBaselineForPatchGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting defines
     * how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services
     * service charges money to the account based on feature or service usage, then the Amazon Web Services service team
     * might create a default setting of <code>false</code>. This means the user can't use this feature unless they
     * change the setting to <code>true</code> and intentionally opt in for a paid feature.
     * </p>
     * <p>
     * Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define the
     * default value for a <code>SettingId</code>. You can't create a new <code>SettingId</code>, but you can overwrite
     * the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the
     * <a>UpdateServiceSetting</a> API operation to change the default setting. Or use the <a>ResetServiceSetting</a> to
     * change the value back to the original value defined by the Amazon Web Services service team.
     * </p>
     * <p>
     * Query the current service setting for the Amazon Web Services account.
     * </p>
     *
     * @param getServiceSettingRequest
     *        The request body of the GetServiceSetting API operation.
     * @return Result of the GetServiceSetting operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ServiceSettingNotFoundException
     *         The specified service setting wasn't found. Either the service name or the setting hasn't been
     *         provisioned by the Amazon Web Services service team.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.GetServiceSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/GetServiceSetting" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetServiceSettingResponse getServiceSetting(GetServiceSettingRequest getServiceSettingRequest)
            throws InternalServerErrorException, ServiceSettingNotFoundException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetServiceSettingResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetServiceSettingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getServiceSettingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetServiceSetting");

            return clientHandler.execute(new ClientExecutionParams<GetServiceSettingRequest, GetServiceSettingResponse>()
                    .withOperationName("GetServiceSetting").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getServiceSettingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetServiceSettingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * A parameter label is a user-defined alias to help you manage different versions of a parameter. When you modify a
     * parameter, Amazon Web Services Systems Manager automatically saves a new version and increments the version
     * number by one. A label can help you remember the purpose of a parameter when there are multiple versions.
     * </p>
     * <p>
     * Parameter labels have the following requirements and restrictions.
     * </p>
     * <ul>
     * <li>
     * <p>
     * A version of a parameter can have a maximum of 10 labels.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't attach the same label to different versions of the same parameter. For example, if version 1 has the
     * label Production, then you can't attach Production to version 2.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can move a label from one version of a parameter to another.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can't create a label when you create a new parameter. You must attach a label to a specific version of a
     * parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * If you no longer want to use a parameter label, then you can either delete it or move it to a different version
     * of a parameter.
     * </p>
     * </li>
     * <li>
     * <p>
     * A label can have a maximum of 100 characters.
     * </p>
     * </li>
     * <li>
     * <p>
     * Labels can contain letters (case sensitive), numbers, periods (.), hyphens (-), or underscores (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Labels can't begin with a number, "<code>aws</code>" or "<code>ssm</code>" (not case sensitive). If a label fails
     * to meet these requirements, then the label isn't associated with a parameter and the system displays it in the
     * list of InvalidLabels.
     * </p>
     * </li>
     * </ul>
     *
     * @param labelParameterVersionRequest
     * @return Result of the LabelParameterVersion operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws ParameterNotFoundException
     *         The parameter couldn't be found. Verify the name and try again.
     * @throws ParameterVersionNotFoundException
     *         The specified parameter version wasn't found. Verify the parameter name and version, and try again.
     * @throws ParameterVersionLabelLimitExceededException
     *         A parameter version can have a maximum of ten labels.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.LabelParameterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/LabelParameterVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public LabelParameterVersionResponse labelParameterVersion(LabelParameterVersionRequest labelParameterVersionRequest)
            throws InternalServerErrorException, TooManyUpdatesException, ParameterNotFoundException,
            ParameterVersionNotFoundException, ParameterVersionLabelLimitExceededException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<LabelParameterVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, LabelParameterVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, labelParameterVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "LabelParameterVersion");

            return clientHandler.execute(new ClientExecutionParams<LabelParameterVersionRequest, LabelParameterVersionResponse>()
                    .withOperationName("LabelParameterVersion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(labelParameterVersionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new LabelParameterVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     *
     * @param listAssociationVersionsRequest
     * @return Result of the ListAssociationVersions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws AssociationDoesNotExistException
     *         The specified association doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAssociationVersionsResponse listAssociationVersions(ListAssociationVersionsRequest listAssociationVersionsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, AssociationDoesNotExistException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssociationVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAssociationVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssociationVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssociationVersions");

            return clientHandler
                    .execute(new ClientExecutionParams<ListAssociationVersionsRequest, ListAssociationVersionsResponse>()
                            .withOperationName("ListAssociationVersions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listAssociationVersionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAssociationVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves all versions of an association for a specific association ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAssociationVersions(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsIterable responses = client.listAssociationVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsIterable responses = client
     *             .listAssociationVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListAssociationVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationVersionsIterable responses = client.listAssociationVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociationVersions(software.amazon.awssdk.services.ssm.model.ListAssociationVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssociationVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws AssociationDoesNotExistException
     *         The specified association doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociationVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociationVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAssociationVersionsIterable listAssociationVersionsPaginator(
            ListAssociationVersionsRequest listAssociationVersionsRequest) throws InternalServerErrorException,
            InvalidNextTokenException, AssociationDoesNotExistException, AwsServiceException, SdkClientException, SsmException {
        return new ListAssociationVersionsIterable(this, applyPaginatorUserAgent(listAssociationVersionsRequest));
    }

    /**
     * <p>
     * Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region.
     * You can limit the results to a specific State Manager association document or managed node by specifying a
     * filter. State Manager is a capability of Amazon Web Services Systems Manager.
     * </p>
     *
     * @param listAssociationsRequest
     * @return Result of the ListAssociations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAssociationsResponse listAssociations(ListAssociationsRequest listAssociationsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAssociations");

            return clientHandler.execute(new ClientExecutionParams<ListAssociationsRequest, ListAssociationsResponse>()
                    .withOperationName("ListAssociations").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAssociationsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns all State Manager associations in the current Amazon Web Services account and Amazon Web Services Region.
     * You can limit the results to a specific State Manager association document or managed node by specifying a
     * filter. State Manager is a capability of Amazon Web Services Systems Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListAssociationsIterable responses = client.listAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssociations(software.amazon.awssdk.services.ssm.model.ListAssociationsRequest)} operation.</b>
     * </p>
     *
     * @param listAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListAssociations" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAssociationsIterable listAssociationsPaginator(ListAssociationsRequest listAssociationsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return new ListAssociationsIterable(this, applyPaginatorUserAgent(listAssociationsRequest));
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific managed node. A command can apply to one or more managed
     * nodes. A command invocation applies to one managed node. For example, if a user runs <code>SendCommand</code>
     * against three managed nodes, then a command invocation is created for each requested managed node ID.
     * <code>ListCommandInvocations</code> provide status about command execution.
     * </p>
     *
     * @param listCommandInvocationsRequest
     * @return Result of the ListCommandInvocations operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     *         The specified command ID isn't valid. Verify the ID and try again.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListCommandInvocationsResponse listCommandInvocations(ListCommandInvocationsRequest listCommandInvocationsRequest)
            throws InternalServerErrorException, InvalidCommandIdException, InvalidInstanceIdException,
            InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCommandInvocationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListCommandInvocationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCommandInvocationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCommandInvocations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListCommandInvocationsRequest, ListCommandInvocationsResponse>()
                            .withOperationName("ListCommandInvocations").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listCommandInvocationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListCommandInvocationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * An invocation is copy of a command sent to a specific managed node. A command can apply to one or more managed
     * nodes. A command invocation applies to one managed node. For example, if a user runs <code>SendCommand</code>
     * against three managed nodes, then a command invocation is created for each requested managed node ID.
     * <code>ListCommandInvocations</code> provide status about command execution.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable responses = client.listCommandInvocationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable responses = client
     *             .listCommandInvocationsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListCommandInvocationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandInvocationsIterable responses = client.listCommandInvocationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommandInvocations(software.amazon.awssdk.services.ssm.model.ListCommandInvocationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCommandInvocationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     *         The specified command ID isn't valid. Verify the ID and try again.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommandInvocations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommandInvocations" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListCommandInvocationsIterable listCommandInvocationsPaginator(
            ListCommandInvocationsRequest listCommandInvocationsRequest) throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, InvalidFilterKeyException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return new ListCommandInvocationsIterable(this, applyPaginatorUserAgent(listCommandInvocationsRequest));
    }

    /**
     * <p>
     * Lists the commands requested by users of the Amazon Web Services account.
     * </p>
     *
     * @param listCommandsRequest
     * @return Result of the ListCommands operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     *         The specified command ID isn't valid. Verify the ID and try again.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCommandsResponse listCommands(ListCommandsRequest listCommandsRequest) throws InternalServerErrorException,
            InvalidCommandIdException, InvalidInstanceIdException, InvalidFilterKeyException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCommandsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCommandsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCommandsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCommands");

            return clientHandler.execute(new ClientExecutionParams<ListCommandsRequest, ListCommandsResponse>()
                    .withOperationName("ListCommands").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listCommandsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCommandsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the commands requested by users of the Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable responses = client.listCommandsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable responses = client.listCommandsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListCommandsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListCommandsIterable responses = client.listCommandsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCommands(software.amazon.awssdk.services.ssm.model.ListCommandsRequest)} operation.</b>
     * </p>
     *
     * @param listCommandsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidCommandIdException
     *         The specified command ID isn't valid. Verify the ID and try again.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListCommands
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListCommands" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCommandsIterable listCommandsPaginator(ListCommandsRequest listCommandsRequest)
            throws InternalServerErrorException, InvalidCommandIdException, InvalidInstanceIdException,
            InvalidFilterKeyException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return new ListCommandsIterable(this, applyPaginatorUserAgent(listCommandsRequest));
    }

    /**
     * <p>
     * For a specified resource ID, this API operation returns a list of compliance statuses for different resource
     * types. Currently, you can only specify one resource ID per call. List results depend on the criteria specified in
     * the filter.
     * </p>
     *
     * @param listComplianceItemsRequest
     * @return Result of the ListComplianceItems operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the instance
     *         must be a registered managed node.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListComplianceItemsResponse listComplianceItems(ListComplianceItemsRequest listComplianceItemsRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException,
            InvalidFilterException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListComplianceItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListComplianceItemsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComplianceItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComplianceItems");

            return clientHandler.execute(new ClientExecutionParams<ListComplianceItemsRequest, ListComplianceItemsResponse>()
                    .withOperationName("ListComplianceItems").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listComplianceItemsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListComplianceItemsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * For a specified resource ID, this API operation returns a list of compliance statuses for different resource
     * types. Currently, you can only specify one resource ID per call. List results depend on the criteria specified in
     * the filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceItems(software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsIterable responses = client.listComplianceItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsIterable responses = client
     *             .listComplianceItemsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceItemsIterable responses = client.listComplianceItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceItems(software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest)} operation.</b>
     * </p>
     *
     * @param listComplianceItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidResourceTypeException
     *         The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the instance
     *         must be a registered managed node.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListComplianceItemsIterable listComplianceItemsPaginator(ListComplianceItemsRequest listComplianceItemsRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException,
            InvalidFilterException, InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        return new ListComplianceItemsIterable(this, applyPaginatorUserAgent(listComplianceItemsRequest));
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     *
     * @param listComplianceSummariesRequest
     * @return Result of the ListComplianceSummaries operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListComplianceSummariesResponse listComplianceSummaries(ListComplianceSummariesRequest listComplianceSummariesRequest)
            throws InvalidFilterException, InvalidNextTokenException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListComplianceSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListComplianceSummariesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listComplianceSummariesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComplianceSummaries");

            return clientHandler
                    .execute(new ClientExecutionParams<ListComplianceSummariesRequest, ListComplianceSummariesResponse>()
                            .withOperationName("ListComplianceSummaries").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listComplianceSummariesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListComplianceSummariesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a summary count of compliant and non-compliant resources for a compliance type. For example, this call
     * can return State Manager associations, patches, or custom compliance types according to the filter criteria that
     * you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable responses = client.listComplianceSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable responses = client
     *             .listComplianceSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListComplianceSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListComplianceSummariesIterable responses = client.listComplianceSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listComplianceSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListComplianceSummariesIterable listComplianceSummariesPaginator(
            ListComplianceSummariesRequest listComplianceSummariesRequest) throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return new ListComplianceSummariesIterable(this, applyPaginatorUserAgent(listComplianceSummariesRequest));
    }

    /**
     * <p>
     * Information about approval reviews for a version of a change template in Change Manager.
     * </p>
     *
     * @param listDocumentMetadataHistoryRequest
     * @return Result of the ListDocumentMetadataHistory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentVersionException
     *         The document version isn't valid or doesn't exist.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocumentMetadataHistory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentMetadataHistory"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDocumentMetadataHistoryResponse listDocumentMetadataHistory(
            ListDocumentMetadataHistoryRequest listDocumentMetadataHistoryRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, InvalidNextTokenException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDocumentMetadataHistoryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDocumentMetadataHistoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDocumentMetadataHistoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocumentMetadataHistory");

            return clientHandler
                    .execute(new ClientExecutionParams<ListDocumentMetadataHistoryRequest, ListDocumentMetadataHistoryResponse>()
                            .withOperationName("ListDocumentMetadataHistory").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listDocumentMetadataHistoryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListDocumentMetadataHistoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     *
     * @param listDocumentVersionsRequest
     * @return Result of the ListDocumentVersions operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDocumentVersionsResponse listDocumentVersions(ListDocumentVersionsRequest listDocumentVersionsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, InvalidDocumentException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDocumentVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDocumentVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDocumentVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocumentVersions");

            return clientHandler.execute(new ClientExecutionParams<ListDocumentVersionsRequest, ListDocumentVersionsResponse>()
                    .withOperationName("ListDocumentVersions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDocumentVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDocumentVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List all versions for a document.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDocumentVersions(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsIterable responses = client.listDocumentVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsIterable responses = client
     *             .listDocumentVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListDocumentVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentVersionsIterable responses = client.listDocumentVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocumentVersions(software.amazon.awssdk.services.ssm.model.ListDocumentVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDocumentVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocumentVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocumentVersions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDocumentVersionsIterable listDocumentVersionsPaginator(ListDocumentVersionsRequest listDocumentVersionsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, InvalidDocumentException, AwsServiceException,
            SdkClientException, SsmException {
        return new ListDocumentVersionsIterable(this, applyPaginatorUserAgent(listDocumentVersionsRequest));
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services
     * Region. You can limit the results of this request by using a filter.
     * </p>
     *
     * @param listDocumentsRequest
     * @return Result of the ListDocuments operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDocumentsResponse listDocuments(ListDocumentsRequest listDocumentsRequest) throws InternalServerErrorException,
            InvalidNextTokenException, InvalidFilterKeyException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDocumentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDocumentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDocumentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDocuments");

            return clientHandler.execute(new ClientExecutionParams<ListDocumentsRequest, ListDocumentsResponse>()
                    .withOperationName("ListDocuments").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDocumentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDocumentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns all Systems Manager (SSM) documents in the current Amazon Web Services account and Amazon Web Services
     * Region. You can limit the results of this request by using a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListDocumentsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListDocumentsIterable responses = client.listDocumentsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDocuments(software.amazon.awssdk.services.ssm.model.ListDocumentsRequest)} operation.</b>
     * </p>
     *
     * @param listDocumentsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InvalidFilterKeyException
     *         The specified key isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListDocuments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListDocuments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDocumentsIterable listDocumentsPaginator(ListDocumentsRequest listDocumentsRequest)
            throws InternalServerErrorException, InvalidNextTokenException, InvalidFilterKeyException, AwsServiceException,
            SdkClientException, SsmException {
        return new ListDocumentsIterable(this, applyPaginatorUserAgent(listDocumentsRequest));
    }

    /**
     * <p>
     * A list of inventory items returned by the request.
     * </p>
     *
     * @param listInventoryEntriesRequest
     * @return Result of the ListInventoryEntries operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidTypeNameException
     *         The parameter type name isn't valid.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListInventoryEntries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListInventoryEntries" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListInventoryEntriesResponse listInventoryEntries(ListInventoryEntriesRequest listInventoryEntriesRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidTypeNameException, InvalidFilterException,
            InvalidNextTokenException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListInventoryEntriesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListInventoryEntriesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listInventoryEntriesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListInventoryEntries");

            return clientHandler.execute(new ClientExecutionParams<ListInventoryEntriesRequest, ListInventoryEntriesResponse>()
                    .withOperationName("ListInventoryEntries").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listInventoryEntriesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListInventoryEntriesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account.
     * You can limit the results to events associated with specific OpsItems by specifying a filter.
     * </p>
     *
     * @param listOpsItemEventsRequest
     * @return Result of the ListOpsItemEvents operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a
     *         href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsItemEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListOpsItemEventsResponse listOpsItemEvents(ListOpsItemEventsRequest listOpsItemEventsRequest)
            throws InternalServerErrorException, OpsItemNotFoundException, OpsItemLimitExceededException,
            OpsItemInvalidParameterException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOpsItemEventsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListOpsItemEventsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOpsItemEventsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpsItemEvents");

            return clientHandler.execute(new ClientExecutionParams<ListOpsItemEventsRequest, ListOpsItemEventsResponse>()
                    .withOperationName("ListOpsItemEvents").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listOpsItemEventsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListOpsItemEventsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all OpsItem events in the current Amazon Web Services Region and Amazon Web Services account.
     * You can limit the results to events associated with specific OpsItems by specifying a filter.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOpsItemEvents(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsIterable responses = client.listOpsItemEventsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsIterable responses = client
     *             .listOpsItemEventsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListOpsItemEventsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemEventsIterable responses = client.listOpsItemEventsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsItemEvents(software.amazon.awssdk.services.ssm.model.ListOpsItemEventsRequest)} operation.</b>
     * </p>
     *
     * @param listOpsItemEventsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a
     *         href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsItemEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemEvents" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListOpsItemEventsIterable listOpsItemEventsPaginator(ListOpsItemEventsRequest listOpsItemEventsRequest)
            throws InternalServerErrorException, OpsItemNotFoundException, OpsItemLimitExceededException,
            OpsItemInvalidParameterException, AwsServiceException, SdkClientException, SsmException {
        return new ListOpsItemEventsIterable(this, applyPaginatorUserAgent(listOpsItemEventsRequest));
    }

    /**
     * <p>
     * Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem. OpsCenter is a capability
     * of Amazon Web Services Systems Manager.
     * </p>
     *
     * @param listOpsItemRelatedItemsRequest
     * @return Result of the ListOpsItemRelatedItems operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsItemRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemRelatedItems" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListOpsItemRelatedItemsResponse listOpsItemRelatedItems(ListOpsItemRelatedItemsRequest listOpsItemRelatedItemsRequest)
            throws InternalServerErrorException, OpsItemInvalidParameterException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOpsItemRelatedItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListOpsItemRelatedItemsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOpsItemRelatedItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpsItemRelatedItems");

            return clientHandler
                    .execute(new ClientExecutionParams<ListOpsItemRelatedItemsRequest, ListOpsItemRelatedItemsResponse>()
                            .withOperationName("ListOpsItemRelatedItems").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listOpsItemRelatedItemsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListOpsItemRelatedItemsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all related-item resources associated with a Systems Manager OpsCenter OpsItem. OpsCenter is a capability
     * of Amazon Web Services Systems Manager.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOpsItemRelatedItems(software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemRelatedItemsIterable responses = client.listOpsItemRelatedItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListOpsItemRelatedItemsIterable responses = client
     *             .listOpsItemRelatedItemsPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsItemRelatedItemsIterable responses = client.listOpsItemRelatedItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsItemRelatedItems(software.amazon.awssdk.services.ssm.model.ListOpsItemRelatedItemsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOpsItemRelatedItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsItemRelatedItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsItemRelatedItems" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListOpsItemRelatedItemsIterable listOpsItemRelatedItemsPaginator(
            ListOpsItemRelatedItemsRequest listOpsItemRelatedItemsRequest) throws InternalServerErrorException,
            OpsItemInvalidParameterException, AwsServiceException, SdkClientException, SsmException {
        return new ListOpsItemRelatedItemsIterable(this, applyPaginatorUserAgent(listOpsItemRelatedItemsRequest));
    }

    /**
     * <p>
     * Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata
     * objects or blobs.
     * </p>
     *
     * @param listOpsMetadataRequest
     * @return Result of the ListOpsMetadata operation returned by the service.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListOpsMetadataResponse listOpsMetadata(ListOpsMetadataRequest listOpsMetadataRequest)
            throws OpsMetadataInvalidArgumentException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOpsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListOpsMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOpsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpsMetadata");

            return clientHandler.execute(new ClientExecutionParams<ListOpsMetadataRequest, ListOpsMetadataResponse>()
                    .withOperationName("ListOpsMetadata").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listOpsMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListOpsMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Amazon Web Services Systems Manager calls this API operation when displaying all Application Manager OpsMetadata
     * objects or blobs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listOpsMetadata(software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataIterable responses = client.listOpsMetadataPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataIterable responses = client.listOpsMetadataPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListOpsMetadataResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListOpsMetadataIterable responses = client.listOpsMetadataPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpsMetadata(software.amazon.awssdk.services.ssm.model.ListOpsMetadataRequest)} operation.</b>
     * </p>
     *
     * @param listOpsMetadataRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListOpsMetadataIterable listOpsMetadataPaginator(ListOpsMetadataRequest listOpsMetadataRequest)
            throws OpsMetadataInvalidArgumentException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        return new ListOpsMetadataIterable(this, applyPaginatorUserAgent(listOpsMetadataRequest));
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     *
     * @param listResourceComplianceSummariesRequest
     * @return Result of the ListResourceComplianceSummaries operation returned by the service.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourceComplianceSummariesResponse listResourceComplianceSummaries(
            ListResourceComplianceSummariesRequest listResourceComplianceSummariesRequest) throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResourceComplianceSummariesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResourceComplianceSummariesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listResourceComplianceSummariesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceComplianceSummaries");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResourceComplianceSummariesRequest, ListResourceComplianceSummariesResponse>()
                            .withOperationName("ListResourceComplianceSummaries").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listResourceComplianceSummariesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListResourceComplianceSummariesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a resource-level summary count. The summary includes information about compliant and non-compliant
     * statuses and detailed compliance-item severity counts, according to the filter criteria you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable responses = client.listResourceComplianceSummariesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable responses = client
     *             .listResourceComplianceSummariesPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceComplianceSummariesIterable responses = client.listResourceComplianceSummariesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceComplianceSummaries(software.amazon.awssdk.services.ssm.model.ListResourceComplianceSummariesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceComplianceSummariesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidFilterException
     *         The filter name isn't valid. Verify the you entered the correct name and try again.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceComplianceSummaries
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceComplianceSummaries"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourceComplianceSummariesIterable listResourceComplianceSummariesPaginator(
            ListResourceComplianceSummariesRequest listResourceComplianceSummariesRequest) throws InvalidFilterException,
            InvalidNextTokenException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        return new ListResourceComplianceSummariesIterable(this, applyPaginatorUserAgent(listResourceComplianceSummariesRequest));
    }

    /**
     * <p>
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start,
     * the last sync status, and the last time a sync successfully completed.
     * </p>
     * <p>
     * The number of sync configurations might be too large to return using a single call to
     * <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the
     * <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the
     * value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request
     * them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call.
     * </p>
     *
     * @param listResourceDataSyncRequest
     * @return Result of the ListResourceDataSync operation returned by the service.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListResourceDataSyncResponse listResourceDataSync(ListResourceDataSyncRequest listResourceDataSyncRequest)
            throws ResourceDataSyncInvalidConfigurationException, InternalServerErrorException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResourceDataSyncResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResourceDataSyncResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceDataSyncRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceDataSync");

            return clientHandler.execute(new ClientExecutionParams<ListResourceDataSyncRequest, ListResourceDataSyncResponse>()
                    .withOperationName("ListResourceDataSync").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listResourceDataSyncRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListResourceDataSyncRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists your resource data sync configurations. Includes information about the last time a sync attempted to start,
     * the last sync status, and the last time a sync successfully completed.
     * </p>
     * <p>
     * The number of sync configurations might be too large to return using a single call to
     * <code>ListResourceDataSync</code>. You can limit the number of sync configurations returned by using the
     * <code>MaxResults</code> parameter. To determine whether there are more sync configurations to list, check the
     * value of <code>NextToken</code> in the output. If there are more sync configurations to list, you can request
     * them by specifying the <code>NextToken</code> returned in the call to the parameter of a subsequent call.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listResourceDataSync(software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncIterable responses = client.listResourceDataSyncPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncIterable responses = client
     *             .listResourceDataSyncPaginator(request);
     *     for (software.amazon.awssdk.services.ssm.model.ListResourceDataSyncResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.ssm.paginators.ListResourceDataSyncIterable responses = client.listResourceDataSyncPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceDataSync(software.amazon.awssdk.services.ssm.model.ListResourceDataSyncRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceDataSyncRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidNextTokenException
     *         The specified token isn't valid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListResourceDataSync" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListResourceDataSyncIterable listResourceDataSyncPaginator(ListResourceDataSyncRequest listResourceDataSyncRequest)
            throws ResourceDataSyncInvalidConfigurationException, InternalServerErrorException, InvalidNextTokenException,
            AwsServiceException, SdkClientException, SsmException {
        return new ListResourceDataSyncIterable(this, applyPaginatorUserAgent(listResourceDataSyncRequest));
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified resource.
     * </p>
     * <p>
     * For information about the ID format for each supported resource type, see <a>AddTagsToResource</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the instance
     *         must be a registered managed node.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Shares a Amazon Web Services Systems Manager document (SSM document)publicly or privately. If you share a
     * document privately, you must specify the Amazon Web Services user account IDs for those people who can use the
     * document. If you share a document publicly, you must specify <i>All</i> as the account ID.
     * </p>
     *
     * @param modifyDocumentPermissionRequest
     * @return Result of the ModifyDocumentPermission operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidPermissionTypeException
     *         The permission type isn't supported. <i>Share</i> is the only supported permission type.
     * @throws DocumentPermissionLimitException
     *         The document can't be shared with more Amazon Web Services user accounts. You can share a document with a
     *         maximum of 20 accounts. You can publicly share up to five documents. If you need to increase this limit,
     *         contact Amazon Web Services Support.
     * @throws DocumentLimitExceededException
     *         You can have at most 500 active SSM documents.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ModifyDocumentPermission
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ModifyDocumentPermission" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ModifyDocumentPermissionResponse modifyDocumentPermission(
            ModifyDocumentPermissionRequest modifyDocumentPermissionRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidPermissionTypeException, DocumentPermissionLimitException,
            DocumentLimitExceededException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ModifyDocumentPermissionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ModifyDocumentPermissionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, modifyDocumentPermissionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ModifyDocumentPermission");

            return clientHandler
                    .execute(new ClientExecutionParams<ModifyDocumentPermissionRequest, ModifyDocumentPermissionResponse>()
                            .withOperationName("ModifyDocumentPermission").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(modifyDocumentPermissionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ModifyDocumentPermissionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers a compliance type and other compliance details on a designated resource. This operation lets you
     * register custom compliance details with a resource. This call overwrites existing compliance information on the
     * resource, so you must provide a full list of compliance items each time that you send the request.
     * </p>
     * <p>
     * ComplianceType can be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * ExecutionId: The execution ID when the patch, association, or custom compliance item was applied.
     * </p>
     * </li>
     * <li>
     * <p>
     * ExecutionType: Specify patch, association, or Custom:<code>string</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * ExecutionTime. The time the patch, association, or custom compliance item was applied to the managed node.
     * </p>
     * </li>
     * <li>
     * <p>
     * Id: The patch, association, or custom compliance ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * Title: A title.
     * </p>
     * </li>
     * <li>
     * <p>
     * Status: The status of the compliance item. For example, <code>approved</code> for patches, or <code>Failed</code>
     * for associations.
     * </p>
     * </li>
     * <li>
     * <p>
     * Severity: A patch severity. For example, <code>critical</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DocumentName: An SSM document name. For example, <code>AWS-RunPatchBaseline</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * DocumentVersion: An SSM document version number. For example, 4.
     * </p>
     * </li>
     * <li>
     * <p>
     * Classification: A patch classification. For example, <code>security updates</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * PatchBaselineId: A patch baseline ID.
     * </p>
     * </li>
     * <li>
     * <p>
     * PatchSeverity: A patch severity. For example, <code>Critical</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * PatchState: A patch state. For example, <code>InstancesWithFailedPatches</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * PatchGroup: The name of a patch group.
     * </p>
     * </li>
     * <li>
     * <p>
     * InstalledTime: The time the association, patch, or custom compliance item was applied to the resource. Specify
     * the time by using the following format: yyyy-MM-dd'T'HH:mm:ss'Z'
     * </p>
     * </li>
     * </ul>
     *
     * @param putComplianceItemsRequest
     * @return Result of the PutComplianceItems operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidItemContentException
     *         One or more content items isn't valid.
     * @throws TotalSizeLimitExceededException
     *         The size of inventory data has exceeded the total size limit for the resource.
     * @throws ItemSizeLimitExceededException
     *         The inventory item size has exceeded the size limit.
     * @throws ComplianceTypeCountLimitExceededException
     *         You specified too many custom compliance types. You can specify a maximum of 10 different types.
     * @throws InvalidResourceTypeException
     *         The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the instance
     *         must be a registered managed node.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.PutComplianceItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutComplianceItems" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutComplianceItemsResponse putComplianceItems(PutComplianceItemsRequest putComplianceItemsRequest)
            throws InternalServerErrorException, InvalidItemContentException, TotalSizeLimitExceededException,
            ItemSizeLimitExceededException, ComplianceTypeCountLimitExceededException, InvalidResourceTypeException,
            InvalidResourceIdException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutComplianceItemsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutComplianceItemsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putComplianceItemsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutComplianceItems");

            return clientHandler.execute(new ClientExecutionParams<PutComplianceItemsRequest, PutComplianceItemsResponse>()
                    .withOperationName("PutComplianceItems").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putComplianceItemsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutComplianceItemsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Bulk update custom inventory items on one or more managed nodes. The request adds an inventory item, if it
     * doesn't already exist, or updates an inventory item, if it does exist.
     * </p>
     *
     * @param putInventoryRequest
     * @return Result of the PutInventory operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidTypeNameException
     *         The parameter type name isn't valid.
     * @throws InvalidItemContentException
     *         One or more content items isn't valid.
     * @throws TotalSizeLimitExceededException
     *         The size of inventory data has exceeded the total size limit for the resource.
     * @throws ItemSizeLimitExceededException
     *         The inventory item size has exceeded the size limit.
     * @throws ItemContentMismatchException
     *         The inventory item has invalid content.
     * @throws CustomSchemaCountLimitExceededException
     *         You have exceeded the limit for custom schemas. Delete one or more custom schemas and try again.
     * @throws UnsupportedInventorySchemaVersionException
     *         Inventory item type schema version has to match supported versions in the service. Check output of
     *         GetInventorySchema to see the available schema version for each type.
     * @throws UnsupportedInventoryItemContextException
     *         The <code>Context</code> attribute that you specified for the <code>InventoryItem</code> isn't allowed
     *         for this inventory type. You can only use the <code>Context</code> attribute with inventory types like
     *         <code>AWS:ComplianceItem</code>.
     * @throws InvalidInventoryItemContextException
     *         You specified invalid keys or values in the <code>Context</code> attribute for <code>InventoryItem</code>
     *         . Verify the keys and values, and try again.
     * @throws SubTypeCountLimitExceededException
     *         The sub-type count exceeded the limit for the inventory type.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.PutInventory
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutInventory" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutInventoryResponse putInventory(PutInventoryRequest putInventoryRequest) throws InternalServerErrorException,
            InvalidInstanceIdException, InvalidTypeNameException, InvalidItemContentException, TotalSizeLimitExceededException,
            ItemSizeLimitExceededException, ItemContentMismatchException, CustomSchemaCountLimitExceededException,
            UnsupportedInventorySchemaVersionException, UnsupportedInventoryItemContextException,
            InvalidInventoryItemContextException, SubTypeCountLimitExceededException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutInventoryResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutInventoryResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putInventoryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutInventory");

            return clientHandler.execute(new ClientExecutionParams<PutInventoryRequest, PutInventoryResponse>()
                    .withOperationName("PutInventory").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putInventoryRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutInventoryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Add a parameter to the system.
     * </p>
     *
     * @param putParameterRequest
     * @return Result of the PutParameter operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidKeyIdException
     *         The query key ID isn't valid.
     * @throws ParameterLimitExceededException
     *         You have exceeded the number of parameters for this Amazon Web Services account. Delete one or more
     *         parameters and try again.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws ParameterAlreadyExistsException
     *         The parameter already exists. You can't create duplicate parameters.
     * @throws HierarchyLevelLimitExceededException
     *         A hierarchy can have a maximum of 15 levels. For more information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html"
     *         >Requirements and constraints for parameter names</a> in the <i>Amazon Web Services Systems Manager User
     *         Guide</i>.
     * @throws HierarchyTypeMismatchException
     *         Parameter Store doesn't support changing a parameter type in a hierarchy. For example, you can't change a
     *         parameter from a <code>String</code> type to a <code>SecureString</code> type. You must create a new,
     *         unique parameter.
     * @throws InvalidAllowedPatternException
     *         The request doesn't meet the regular expression requirement.
     * @throws ParameterMaxVersionLimitExceededException
     *         Parameter Store retains the 100 most recently created versions of a parameter. After this number of
     *         versions has been created, Parameter Store deletes the oldest version when a new one is created. However,
     *         if the oldest version has a <i>label</i> attached to it, Parameter Store won't delete the version and
     *         instead presents this error message:</p>
     *         <p>
     *         <code>An error occurred (ParameterMaxVersionLimitExceeded) when calling the PutParameter operation: You attempted to create a new version of <i>parameter-name</i> by calling the PutParameter API with the overwrite flag. Version <i>version-number</i>, the oldest version, can't be deleted because it has a label associated with it. Move the label to another version of the parameter, and try again.</code>
     *         </p>
     *         <p>
     *         This safeguard is to prevent parameter versions with mission critical labels assigned to them from being
     *         deleted. To continue creating new parameters, first move the label from the oldest version of the
     *         parameter to a newer one for use in your operations. For information about moving parameter labels, see
     *         <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-console-move"
     *         >Move a parameter label (console)</a> or <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-labels.html#sysman-paramstore-labels-cli-move"
     *         >Move a parameter label (CLI)</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * @throws ParameterPatternMismatchException
     *         The parameter name isn't valid.
     * @throws UnsupportedParameterTypeException
     *         The parameter type isn't supported.
     * @throws PoliciesLimitExceededException
     *         You specified more than the maximum number of allowed policies for the parameter. The maximum is 10.
     * @throws InvalidPolicyTypeException
     *         The policy type isn't supported. Parameter Store supports the following policy types: Expiration,
     *         ExpirationNotification, and NoChangeNotification.
     * @throws InvalidPolicyAttributeException
     *         A policy attribute or its value is invalid.
     * @throws IncompatiblePolicyException
     *         There is a conflict in the policies specified for this parameter. You can't, for example, specify two
     *         Expiration policies for a parameter. Review your policies, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.PutParameter
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/PutParameter" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutParameterResponse putParameter(PutParameterRequest putParameterRequest) throws InternalServerErrorException,
            InvalidKeyIdException, ParameterLimitExceededException, TooManyUpdatesException, ParameterAlreadyExistsException,
            HierarchyLevelLimitExceededException, HierarchyTypeMismatchException, InvalidAllowedPatternException,
            ParameterMaxVersionLimitExceededException, ParameterPatternMismatchException, UnsupportedParameterTypeException,
            PoliciesLimitExceededException, InvalidPolicyTypeException, InvalidPolicyAttributeException,
            IncompatiblePolicyException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutParameterResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutParameterResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putParameterRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutParameter");

            return clientHandler.execute(new ClientExecutionParams<PutParameterRequest, PutParameterResponse>()
                    .withOperationName("PutParameter").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(putParameterRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutParameterRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Defines the default patch baseline for the relevant operating system.
     * </p>
     * <p>
     * To reset the Amazon Web Services-predefined patch baseline as the default, specify the full patch baseline Amazon
     * Resource Name (ARN) as the baseline ID value. For example, for CentOS, specify
     * <code>arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed</code> instead of
     * <code>pb-0574b43a65ea646ed</code>.
     * </p>
     *
     * @param registerDefaultPatchBaselineRequest
     * @return Result of the RegisterDefaultPatchBaseline operation returned by the service.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.RegisterDefaultPatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterDefaultPatchBaseline"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterDefaultPatchBaselineResponse registerDefaultPatchBaseline(
            RegisterDefaultPatchBaselineRequest registerDefaultPatchBaselineRequest) throws InvalidResourceIdException,
            DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterDefaultPatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterDefaultPatchBaselineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerDefaultPatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterDefaultPatchBaseline");

            return clientHandler
                    .execute(new ClientExecutionParams<RegisterDefaultPatchBaselineRequest, RegisterDefaultPatchBaselineResponse>()
                            .withOperationName("RegisterDefaultPatchBaseline").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(registerDefaultPatchBaselineRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RegisterDefaultPatchBaselineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers a patch baseline for a patch group.
     * </p>
     *
     * @param registerPatchBaselineForPatchGroupRequest
     * @return Result of the RegisterPatchBaselineForPatchGroup operation returned by the service.
     * @throws AlreadyExistsException
     *         Error returned if an attempt is made to register a patch group with a patch baseline that is already
     *         registered with a different patch baseline.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource quotas. For example, too many
     *         maintenance windows or patch baselines have been created.
     *         </p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.RegisterPatchBaselineForPatchGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterPatchBaselineForPatchGroup"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterPatchBaselineForPatchGroupResponse registerPatchBaselineForPatchGroup(
            RegisterPatchBaselineForPatchGroupRequest registerPatchBaselineForPatchGroupRequest) throws AlreadyExistsException,
            DoesNotExistException, InvalidResourceIdException, ResourceLimitExceededException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterPatchBaselineForPatchGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterPatchBaselineForPatchGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                registerPatchBaselineForPatchGroupRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterPatchBaselineForPatchGroup");

            return clientHandler
                    .execute(new ClientExecutionParams<RegisterPatchBaselineForPatchGroupRequest, RegisterPatchBaselineForPatchGroupResponse>()
                            .withOperationName("RegisterPatchBaselineForPatchGroup").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(registerPatchBaselineForPatchGroupRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RegisterPatchBaselineForPatchGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Registers a target with a maintenance window.
     * </p>
     *
     * @param registerTargetWithMaintenanceWindowRequest
     * @return Result of the RegisterTargetWithMaintenanceWindow operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource quotas. For example, too many
     *         maintenance windows or patch baselines have been created.
     *         </p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.RegisterTargetWithMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTargetWithMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterTargetWithMaintenanceWindowResponse registerTargetWithMaintenanceWindow(
            RegisterTargetWithMaintenanceWindowRequest registerTargetWithMaintenanceWindowRequest)
            throws IdempotentParameterMismatchException, DoesNotExistException, ResourceLimitExceededException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterTargetWithMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterTargetWithMaintenanceWindowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                registerTargetWithMaintenanceWindowRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterTargetWithMaintenanceWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<RegisterTargetWithMaintenanceWindowRequest, RegisterTargetWithMaintenanceWindowResponse>()
                            .withOperationName("RegisterTargetWithMaintenanceWindow").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(registerTargetWithMaintenanceWindowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RegisterTargetWithMaintenanceWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a new task to a maintenance window.
     * </p>
     *
     * @param registerTaskWithMaintenanceWindowRequest
     * @return Result of the RegisterTaskWithMaintenanceWindow operation returned by the service.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws ResourceLimitExceededException
     *         Error returned when the caller has exceeded the default resource quotas. For example, too many
     *         maintenance windows or patch baselines have been created.
     *         </p>
     *         <p>
     *         For information about resource quotas in Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws FeatureNotAvailableException
     *         You attempted to register a <code>LAMBDA</code> or <code>STEP_FUNCTIONS</code> task in a region where the
     *         corresponding service isn't available.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.RegisterTaskWithMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RegisterTaskWithMaintenanceWindow"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RegisterTaskWithMaintenanceWindowResponse registerTaskWithMaintenanceWindow(
            RegisterTaskWithMaintenanceWindowRequest registerTaskWithMaintenanceWindowRequest)
            throws IdempotentParameterMismatchException, DoesNotExistException, ResourceLimitExceededException,
            FeatureNotAvailableException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterTaskWithMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RegisterTaskWithMaintenanceWindowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                registerTaskWithMaintenanceWindowRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterTaskWithMaintenanceWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<RegisterTaskWithMaintenanceWindowRequest, RegisterTaskWithMaintenanceWindowResponse>()
                            .withOperationName("RegisterTaskWithMaintenanceWindow").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(registerTaskWithMaintenanceWindowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RegisterTaskWithMaintenanceWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes tag keys from the specified resource.
     * </p>
     *
     * @param removeTagsFromResourceRequest
     * @return Result of the RemoveTagsFromResource operation returned by the service.
     * @throws InvalidResourceTypeException
     *         The resource type isn't valid. For example, if you are attempting to tag an EC2 instance, the instance
     *         must be a registered managed node.
     * @throws InvalidResourceIdException
     *         The resource ID isn't valid. Verify that you entered the correct ID and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.RemoveTagsFromResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/RemoveTagsFromResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RemoveTagsFromResourceResponse removeTagsFromResource(RemoveTagsFromResourceRequest removeTagsFromResourceRequest)
            throws InvalidResourceTypeException, InvalidResourceIdException, InternalServerErrorException,
            TooManyUpdatesException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RemoveTagsFromResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RemoveTagsFromResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, removeTagsFromResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RemoveTagsFromResource");

            return clientHandler
                    .execute(new ClientExecutionParams<RemoveTagsFromResourceRequest, RemoveTagsFromResourceResponse>()
                            .withOperationName("RemoveTagsFromResource").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(removeTagsFromResourceRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RemoveTagsFromResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting defines
     * how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services
     * service charges money to the account based on feature or service usage, then the Amazon Web Services service team
     * might create a default setting of "false". This means the user can't use this feature unless they change the
     * setting to "true" and intentionally opt in for a paid feature.
     * </p>
     * <p>
     * Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define the
     * default value for a <code>SettingId</code>. You can't create a new <code>SettingId</code>, but you can overwrite
     * the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the
     * <a>GetServiceSetting</a> API operation to view the current value. Use the <a>UpdateServiceSetting</a> API
     * operation to change the default setting.
     * </p>
     * <p>
     * Reset the service setting for the account to the default value as provisioned by the Amazon Web Services service
     * team.
     * </p>
     *
     * @param resetServiceSettingRequest
     *        The request body of the ResetServiceSetting API operation.
     * @return Result of the ResetServiceSetting operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ServiceSettingNotFoundException
     *         The specified service setting wasn't found. Either the service name or the setting hasn't been
     *         provisioned by the Amazon Web Services service team.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ResetServiceSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ResetServiceSetting" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ResetServiceSettingResponse resetServiceSetting(ResetServiceSettingRequest resetServiceSettingRequest)
            throws InternalServerErrorException, ServiceSettingNotFoundException, TooManyUpdatesException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResetServiceSettingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ResetServiceSettingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resetServiceSettingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResetServiceSetting");

            return clientHandler.execute(new ClientExecutionParams<ResetServiceSettingRequest, ResetServiceSettingResponse>()
                    .withOperationName("ResetServiceSetting").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(resetServiceSettingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ResetServiceSettingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Reconnects a session to a managed node after it has been disconnected. Connections can be resumed for
     * disconnected sessions, but not terminated sessions.
     * </p>
     * <note>
     * <p>
     * This command is primarily for use by client machines to automatically reconnect during intermittent network
     * issues. It isn't intended for any other use.
     * </p>
     * </note>
     *
     * @param resumeSessionRequest
     * @return Result of the ResumeSession operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.ResumeSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ResumeSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ResumeSessionResponse resumeSession(ResumeSessionRequest resumeSessionRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ResumeSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ResumeSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, resumeSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ResumeSession");

            return clientHandler.execute(new ClientExecutionParams<ResumeSessionRequest, ResumeSessionResponse>()
                    .withOperationName("ResumeSession").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(resumeSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ResumeSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Sends a signal to an Automation execution to change the current behavior or status of the execution.
     * </p>
     *
     * @param sendAutomationSignalRequest
     * @return Result of the SendAutomationSignal operation returned by the service.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws AutomationStepNotFoundException
     *         The specified step name and execution ID don't exist. Verify the information and try again.
     * @throws InvalidAutomationSignalException
     *         The signal isn't valid for the current Automation execution.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.SendAutomationSignal
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendAutomationSignal" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SendAutomationSignalResponse sendAutomationSignal(SendAutomationSignalRequest sendAutomationSignalRequest)
            throws AutomationExecutionNotFoundException, AutomationStepNotFoundException, InvalidAutomationSignalException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendAutomationSignalResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, SendAutomationSignalResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendAutomationSignalRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendAutomationSignal");

            return clientHandler.execute(new ClientExecutionParams<SendAutomationSignalRequest, SendAutomationSignalResponse>()
                    .withOperationName("SendAutomationSignal").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(sendAutomationSignalRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SendAutomationSignalRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Runs commands on one or more managed nodes.
     * </p>
     *
     * @param sendCommandRequest
     * @return Result of the SendCommand operation returned by the service.
     * @throws DuplicateInstanceIdException
     *         You can't specify a managed node ID in more than one association.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentVersionException
     *         The document version isn't valid or doesn't exist.
     * @throws InvalidOutputFolderException
     *         The S3 bucket doesn't exist.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the Amazon Web Services Systems Manager document
     *         (SSM document). You can only supply values to parameters defined in the SSM document.
     * @throws UnsupportedPlatformTypeException
     *         The document doesn't support the platform type of the given managed node ID(s). For example, you sent an
     *         document for a Windows managed node to a Linux node.
     * @throws MaxDocumentSizeExceededException
     *         The size limit of a document is 64 KB.
     * @throws InvalidRoleException
     *         The role name can't contain invalid characters. Also verify that you specified an IAM role for
     *         notifications that includes the required trust policy. For information about configuring the IAM role for
     *         Run Command notifications, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/rc-sns-notifications.html">Configuring
     *         Amazon SNS Notifications for Run Command</a> in the <i>Amazon Web Services Systems Manager User
     *         Guide</i>.
     * @throws InvalidNotificationConfigException
     *         One or more configuration items isn't valid. Verify that a valid Amazon Resource Name (ARN) was provided
     *         for an Amazon Simple Notification Service topic.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.SendCommand
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/SendCommand" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SendCommandResponse sendCommand(SendCommandRequest sendCommandRequest) throws DuplicateInstanceIdException,
            InternalServerErrorException, InvalidInstanceIdException, InvalidDocumentException, InvalidDocumentVersionException,
            InvalidOutputFolderException, InvalidParametersException, UnsupportedPlatformTypeException,
            MaxDocumentSizeExceededException, InvalidRoleException, InvalidNotificationConfigException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SendCommandResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SendCommandResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, sendCommandRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SendCommand");

            return clientHandler.execute(new ClientExecutionParams<SendCommandRequest, SendCommandResponse>()
                    .withOperationName("SendCommand").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(sendCommandRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SendCommandRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Runs an association immediately and only one time. This operation can be helpful when troubleshooting
     * associations.
     * </p>
     *
     * @param startAssociationsOnceRequest
     * @return Result of the StartAssociationsOnce operation returned by the service.
     * @throws InvalidAssociationException
     *         The association isn't valid or doesn't exist.
     * @throws AssociationDoesNotExistException
     *         The specified association doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.StartAssociationsOnce
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAssociationsOnce" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartAssociationsOnceResponse startAssociationsOnce(StartAssociationsOnceRequest startAssociationsOnceRequest)
            throws InvalidAssociationException, AssociationDoesNotExistException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartAssociationsOnceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartAssociationsOnceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAssociationsOnceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAssociationsOnce");

            return clientHandler.execute(new ClientExecutionParams<StartAssociationsOnceRequest, StartAssociationsOnceResponse>()
                    .withOperationName("StartAssociationsOnce").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startAssociationsOnceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartAssociationsOnceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Initiates execution of an Automation runbook.
     * </p>
     *
     * @param startAutomationExecutionRequest
     * @return Result of the StartAutomationExecution operation returned by the service.
     * @throws AutomationDefinitionNotFoundException
     *         An Automation runbook with the specified name couldn't be found.
     * @throws InvalidAutomationExecutionParametersException
     *         The supplied parameters for invoking the specified Automation runbook are incorrect. For example, they
     *         may not match the set of parameters permitted for the specified Automation document.
     * @throws AutomationExecutionLimitExceededException
     *         The number of simultaneously running Automation executions exceeded the allowable limit.
     * @throws AutomationDefinitionVersionNotFoundException
     *         An Automation runbook with the specified name and version couldn't be found.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws InvalidTargetException
     *         The target isn't valid or doesn't exist. It might not be configured for Systems Manager or you might not
     *         have permission to perform the operation.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.StartAutomationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartAutomationExecutionResponse startAutomationExecution(
            StartAutomationExecutionRequest startAutomationExecutionRequest) throws AutomationDefinitionNotFoundException,
            InvalidAutomationExecutionParametersException, AutomationExecutionLimitExceededException,
            AutomationDefinitionVersionNotFoundException, IdempotentParameterMismatchException, InvalidTargetException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartAutomationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartAutomationExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAutomationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAutomationExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<StartAutomationExecutionRequest, StartAutomationExecutionResponse>()
                            .withOperationName("StartAutomationExecution").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startAutomationExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartAutomationExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a change request for Change Manager. The Automation runbooks specified in the change request run only
     * after all required approvals for the change request have been received.
     * </p>
     *
     * @param startChangeRequestExecutionRequest
     * @return Result of the StartChangeRequestExecution operation returned by the service.
     * @throws AutomationDefinitionNotFoundException
     *         An Automation runbook with the specified name couldn't be found.
     * @throws InvalidAutomationExecutionParametersException
     *         The supplied parameters for invoking the specified Automation runbook are incorrect. For example, they
     *         may not match the set of parameters permitted for the specified Automation document.
     * @throws AutomationExecutionLimitExceededException
     *         The number of simultaneously running Automation executions exceeded the allowable limit.
     * @throws AutomationDefinitionVersionNotFoundException
     *         An Automation runbook with the specified name and version couldn't be found.
     * @throws IdempotentParameterMismatchException
     *         Error returned when an idempotent operation is retried and the parameters don't match the original call
     *         to the API with the same idempotency token.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws AutomationDefinitionNotApprovedException
     *         Indicates that the Change Manager change template used in the change request was rejected or is still in
     *         a pending state.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.StartChangeRequestExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartChangeRequestExecution"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartChangeRequestExecutionResponse startChangeRequestExecution(
            StartChangeRequestExecutionRequest startChangeRequestExecutionRequest) throws AutomationDefinitionNotFoundException,
            InvalidAutomationExecutionParametersException, AutomationExecutionLimitExceededException,
            AutomationDefinitionVersionNotFoundException, IdempotentParameterMismatchException, InternalServerErrorException,
            AutomationDefinitionNotApprovedException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartChangeRequestExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartChangeRequestExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startChangeRequestExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartChangeRequestExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<StartChangeRequestExecutionRequest, StartChangeRequestExecutionResponse>()
                            .withOperationName("StartChangeRequestExecution").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(startChangeRequestExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartChangeRequestExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Initiates a connection to a target (for example, a managed node) for a Session Manager session. Returns a URL and
     * token that can be used to open a WebSocket connection for sending input and receiving outputs.
     * </p>
     * <note>
     * <p>
     * Amazon Web Services CLI usage: <code>start-session</code> is an interactive command that requires the Session
     * Manager plugin to be installed on the client machine making the call. For information, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html"
     * >Install the Session Manager plugin for the Amazon Web Services CLI</a> in the <i>Amazon Web Services Systems
     * Manager User Guide</i>.
     * </p>
     * <p>
     * Amazon Web Services Tools for PowerShell usage: Start-SSMSession isn't currently supported by Amazon Web Services
     * Tools for PowerShell on Windows local machines.
     * </p>
     * </note>
     *
     * @param startSessionRequest
     * @return Result of the StartSession operation returned by the service.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws TargetNotConnectedException
     *         The specified target managed node for the session isn't fully configured for use with Session Manager.
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-getting-started.html"
     *         >Getting started with Session Manager</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     *         This error is also returned if you attempt to start a session on a managed node that is located in a
     *         different account or Region
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.StartSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StartSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartSessionResponse startSession(StartSessionRequest startSessionRequest) throws InvalidDocumentException,
            TargetNotConnectedException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSession");

            return clientHandler.execute(new ClientExecutionParams<StartSessionRequest, StartSessionResponse>()
                    .withOperationName("StartSession").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stop an Automation that is currently running.
     * </p>
     *
     * @param stopAutomationExecutionRequest
     * @return Result of the StopAutomationExecution operation returned by the service.
     * @throws AutomationExecutionNotFoundException
     *         There is no automation execution information for the requested automation execution ID.
     * @throws InvalidAutomationStatusUpdateException
     *         The specified update status operation isn't valid.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.StopAutomationExecution
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/StopAutomationExecution" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StopAutomationExecutionResponse stopAutomationExecution(StopAutomationExecutionRequest stopAutomationExecutionRequest)
            throws AutomationExecutionNotFoundException, InvalidAutomationStatusUpdateException, InternalServerErrorException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopAutomationExecutionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopAutomationExecutionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopAutomationExecutionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopAutomationExecution");

            return clientHandler
                    .execute(new ClientExecutionParams<StopAutomationExecutionRequest, StopAutomationExecutionResponse>()
                            .withOperationName("StopAutomationExecution").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(stopAutomationExecutionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StopAutomationExecutionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Permanently ends a session and closes the data connection between the Session Manager client and SSM Agent on the
     * managed node. A terminated session can't be resumed.
     * </p>
     *
     * @param terminateSessionRequest
     * @return Result of the TerminateSession operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.TerminateSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/TerminateSession" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TerminateSessionResponse terminateSession(TerminateSessionRequest terminateSessionRequest)
            throws InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TerminateSessionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TerminateSessionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, terminateSessionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TerminateSession");

            return clientHandler.execute(new ClientExecutionParams<TerminateSessionRequest, TerminateSessionResponse>()
                    .withOperationName("TerminateSession").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(terminateSessionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TerminateSessionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Remove a label or labels from a parameter.
     * </p>
     *
     * @param unlabelParameterVersionRequest
     * @return Result of the UnlabelParameterVersion operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws ParameterNotFoundException
     *         The parameter couldn't be found. Verify the name and try again.
     * @throws ParameterVersionNotFoundException
     *         The specified parameter version wasn't found. Verify the parameter name and version, and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UnlabelParameterVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UnlabelParameterVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UnlabelParameterVersionResponse unlabelParameterVersion(UnlabelParameterVersionRequest unlabelParameterVersionRequest)
            throws InternalServerErrorException, TooManyUpdatesException, ParameterNotFoundException,
            ParameterVersionNotFoundException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UnlabelParameterVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UnlabelParameterVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, unlabelParameterVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UnlabelParameterVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<UnlabelParameterVersionRequest, UnlabelParameterVersionResponse>()
                            .withOperationName("UnlabelParameterVersion").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(unlabelParameterVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UnlabelParameterVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an association. You can update the association name and version, the document version, schedule,
     * parameters, and Amazon Simple Storage Service (Amazon S3) output. When you call <code>UpdateAssociation</code>,
     * the system removes all optional parameters from the request and overwrites the association with null values for
     * those parameters. This is by design. You must specify all optional parameters in the call, even if you are not
     * changing the parameters. This includes the <code>Name</code> parameter. Before calling this API action, we
     * recommend that you call the <a>DescribeAssociation</a> API operation and make a note of all optional parameters
     * required for your <code>UpdateAssociation</code> call.
     * </p>
     * <p>
     * In order to call this API operation, your Identity and Access Management (IAM) user account, group, or role must
     * be configured with permission to call the <a>DescribeAssociation</a> API operation. If you don't have permission
     * to call <code>DescribeAssociation</code>, then you receive the following error:
     * <code>An error occurred (AccessDeniedException) when calling the UpdateAssociation operation: User: &lt;user_arn&gt; isn't authorized to perform: ssm:DescribeAssociation on resource: &lt;resource_arn&gt;</code>
     * </p>
     * <important>
     * <p>
     * When you update an association, the association immediately runs against the specified targets. You can add the
     * <code>ApplyOnlyAtCronInterval</code> parameter to run the association during the next schedule run.
     * </p>
     * </important>
     *
     * @param updateAssociationRequest
     * @return Result of the UpdateAssociation operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidScheduleException
     *         The schedule is invalid. Verify your cron or rate expression and try again.
     * @throws InvalidParametersException
     *         You must specify values for all required parameters in the Amazon Web Services Systems Manager document
     *         (SSM document). You can only supply values to parameters defined in the SSM document.
     * @throws InvalidOutputLocationException
     *         The output location isn't valid or doesn't exist.
     * @throws InvalidDocumentVersionException
     *         The document version isn't valid or doesn't exist.
     * @throws AssociationDoesNotExistException
     *         The specified association doesn't exist.
     * @throws InvalidUpdateException
     *         The update isn't valid.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidTargetException
     *         The target isn't valid or doesn't exist. It might not be configured for Systems Manager or you might not
     *         have permission to perform the operation.
     * @throws InvalidAssociationVersionException
     *         The version you specified isn't valid. Use ListAssociationVersions to view all versions of an association
     *         according to the association ID. Or, use the <code>&#36LATEST</code> parameter to view the latest version
     *         of the association.
     * @throws AssociationVersionLimitExceededException
     *         You have reached the maximum number versions allowed for an association. Each association has a limit of
     *         1,000 versions.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAssociationResponse updateAssociation(UpdateAssociationRequest updateAssociationRequest)
            throws InternalServerErrorException, InvalidScheduleException, InvalidParametersException,
            InvalidOutputLocationException, InvalidDocumentVersionException, AssociationDoesNotExistException,
            InvalidUpdateException, TooManyUpdatesException, InvalidDocumentException, InvalidTargetException,
            InvalidAssociationVersionException, AssociationVersionLimitExceededException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAssociationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssociation");

            return clientHandler.execute(new ClientExecutionParams<UpdateAssociationRequest, UpdateAssociationResponse>()
                    .withOperationName("UpdateAssociation").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateAssociationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the status of the Amazon Web Services Systems Manager document (SSM document) associated with the
     * specified managed node.
     * </p>
     * <p>
     * <code>UpdateAssociationStatus</code> is primarily used by the Amazon Web Services Systems Manager Agent (SSM
     * Agent) to report status updates about your associations and is only used for associations created with the
     * <code>InstanceId</code> legacy parameter.
     * </p>
     *
     * @param updateAssociationStatusRequest
     * @return Result of the UpdateAssociationStatus operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws AssociationDoesNotExistException
     *         The specified association doesn't exist.
     * @throws StatusUnchangedException
     *         The updated status is the same as the current status.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateAssociationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateAssociationStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateAssociationStatusResponse updateAssociationStatus(UpdateAssociationStatusRequest updateAssociationStatusRequest)
            throws InternalServerErrorException, InvalidInstanceIdException, InvalidDocumentException,
            AssociationDoesNotExistException, StatusUnchangedException, TooManyUpdatesException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAssociationStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAssociationStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAssociationStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAssociationStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAssociationStatusRequest, UpdateAssociationStatusResponse>()
                            .withOperationName("UpdateAssociationStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateAssociationStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAssociationStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates one or more values for an SSM document.
     * </p>
     *
     * @param updateDocumentRequest
     * @return Result of the UpdateDocument operation returned by the service.
     * @throws MaxDocumentSizeExceededException
     *         The size limit of a document is 64 KB.
     * @throws DocumentVersionLimitExceededException
     *         The document has too many versions. Delete one or more document versions and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws DuplicateDocumentContentException
     *         The content of the association document matches another document. Change the content of the document and
     *         try again.
     * @throws DuplicateDocumentVersionNameException
     *         The version name has already been used in this document. Specify a different version name, and then try
     *         again.
     * @throws InvalidDocumentContentException
     *         The content for the document isn't valid.
     * @throws InvalidDocumentVersionException
     *         The document version isn't valid or doesn't exist.
     * @throws InvalidDocumentSchemaVersionException
     *         The version of the document schema isn't supported.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentOperationException
     *         You attempted to delete a document while it is still shared. You must stop sharing the document before
     *         you can delete it.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateDocument
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocument" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateDocumentResponse updateDocument(UpdateDocumentRequest updateDocumentRequest)
            throws MaxDocumentSizeExceededException, DocumentVersionLimitExceededException, InternalServerErrorException,
            DuplicateDocumentContentException, DuplicateDocumentVersionNameException, InvalidDocumentContentException,
            InvalidDocumentVersionException, InvalidDocumentSchemaVersionException, InvalidDocumentException,
            InvalidDocumentOperationException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDocumentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDocumentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDocumentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDocument");

            return clientHandler.execute(new ClientExecutionParams<UpdateDocumentRequest, UpdateDocumentResponse>()
                    .withOperationName("UpdateDocument").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDocumentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDocumentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Set the default version of a document.
     * </p>
     *
     * @param updateDocumentDefaultVersionRequest
     * @return Result of the UpdateDocumentDefaultVersion operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentVersionException
     *         The document version isn't valid or doesn't exist.
     * @throws InvalidDocumentSchemaVersionException
     *         The version of the document schema isn't supported.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateDocumentDefaultVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentDefaultVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDocumentDefaultVersionResponse updateDocumentDefaultVersion(
            UpdateDocumentDefaultVersionRequest updateDocumentDefaultVersionRequest) throws InternalServerErrorException,
            InvalidDocumentException, InvalidDocumentVersionException, InvalidDocumentSchemaVersionException,
            AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDocumentDefaultVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDocumentDefaultVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDocumentDefaultVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDocumentDefaultVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDocumentDefaultVersionRequest, UpdateDocumentDefaultVersionResponse>()
                            .withOperationName("UpdateDocumentDefaultVersion").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateDocumentDefaultVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDocumentDefaultVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates information related to approval reviews for a specific version of a change template in Change Manager.
     * </p>
     *
     * @param updateDocumentMetadataRequest
     * @return Result of the UpdateDocumentMetadata operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws InvalidDocumentException
     *         The specified SSM document doesn't exist.
     * @throws InvalidDocumentOperationException
     *         You attempted to delete a document while it is still shared. You must stop sharing the document before
     *         you can delete it.
     * @throws InvalidDocumentVersionException
     *         The document version isn't valid or doesn't exist.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateDocumentMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateDocumentMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDocumentMetadataResponse updateDocumentMetadata(UpdateDocumentMetadataRequest updateDocumentMetadataRequest)
            throws InternalServerErrorException, InvalidDocumentException, InvalidDocumentOperationException,
            InvalidDocumentVersionException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDocumentMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDocumentMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDocumentMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDocumentMetadata");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDocumentMetadataRequest, UpdateDocumentMetadataResponse>()
                            .withOperationName("UpdateDocumentMetadata").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateDocumentMetadataRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDocumentMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing maintenance window. Only specified parameters are modified.
     * </p>
     * <note>
     * <p>
     * The value you specify for <code>Duration</code> determines the specific end time for the maintenance window based
     * on the time it begins. No maintenance window tasks are permitted to start after the resulting endtime minus the
     * number of hours you specify for <code>Cutoff</code>. For example, if the maintenance window starts at 3 PM, the
     * duration is three hours, and the value you specify for <code>Cutoff</code> is one hour, no maintenance window
     * tasks can start after 5 PM.
     * </p>
     * </note>
     *
     * @param updateMaintenanceWindowRequest
     * @return Result of the UpdateMaintenanceWindow operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateMaintenanceWindow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindow" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateMaintenanceWindowResponse updateMaintenanceWindow(UpdateMaintenanceWindowRequest updateMaintenanceWindowRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMaintenanceWindowResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateMaintenanceWindowResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMaintenanceWindowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMaintenanceWindow");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateMaintenanceWindowRequest, UpdateMaintenanceWindowResponse>()
                            .withOperationName("UpdateMaintenanceWindow").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateMaintenanceWindowRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateMaintenanceWindowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies the target of an existing maintenance window. You can change the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Name
     * </p>
     * </li>
     * <li>
     * <p>
     * Description
     * </p>
     * </li>
     * <li>
     * <p>
     * Owner
     * </p>
     * </li>
     * <li>
     * <p>
     * IDs for an ID target
     * </p>
     * </li>
     * <li>
     * <p>
     * Tags for a Tag target
     * </p>
     * </li>
     * <li>
     * <p>
     * From any supported tag type to another. The three supported tag types are ID target, Tag target, and resource
     * group. For more information, see <a>Target</a>.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If a parameter is null, then the corresponding field isn't modified.
     * </p>
     * </note>
     *
     * @param updateMaintenanceWindowTargetRequest
     * @return Result of the UpdateMaintenanceWindowTarget operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateMaintenanceWindowTarget
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTarget"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateMaintenanceWindowTargetResponse updateMaintenanceWindowTarget(
            UpdateMaintenanceWindowTargetRequest updateMaintenanceWindowTargetRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMaintenanceWindowTargetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateMaintenanceWindowTargetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateMaintenanceWindowTargetRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMaintenanceWindowTarget");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateMaintenanceWindowTargetRequest, UpdateMaintenanceWindowTargetResponse>()
                            .withOperationName("UpdateMaintenanceWindowTarget").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateMaintenanceWindowTargetRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateMaintenanceWindowTargetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies a task assigned to a maintenance window. You can't change the task type, but you can change the
     * following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>TaskARN</code>. For example, you can change a <code>RUN_COMMAND</code> task from
     * <code>AWS-RunPowerShellScript</code> to <code>AWS-RunShellScript</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ServiceRoleArn</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TaskInvocationParameters</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Priority</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxConcurrency</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>MaxErrors</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * One or more targets must be specified for maintenance window Run Command-type tasks. Depending on the task,
     * targets are optional for other maintenance window task types (Automation, Lambda, and Step Functions). For more
     * information about running tasks that don't specify targets, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/maintenance-windows-targetless-tasks.html"
     * >Registering maintenance window tasks without targets</a> in the <i>Amazon Web Services Systems Manager User
     * Guide</i>.
     * </p>
     * </note>
     * <p>
     * If the value for a parameter in <code>UpdateMaintenanceWindowTask</code> is null, then the corresponding field
     * isn't modified. If you set <code>Replace</code> to true, then all fields required by the
     * <a>RegisterTaskWithMaintenanceWindow</a> operation are required for this request. Optional fields that aren't
     * specified are set to null.
     * </p>
     * <important>
     * <p>
     * When you update a maintenance window task that has options specified in <code>TaskInvocationParameters</code>,
     * you must provide again all the <code>TaskInvocationParameters</code> values that you want to retain. The values
     * you don't specify again are removed. For example, suppose that when you registered a Run Command task, you
     * specified <code>TaskInvocationParameters</code> values for <code>Comment</code>, <code>NotificationConfig</code>,
     * and <code>OutputS3BucketName</code>. If you update the maintenance window task and specify only a different
     * <code>OutputS3BucketName</code> value, the values for <code>Comment</code> and <code>NotificationConfig</code>
     * are removed.
     * </p>
     * </important>
     *
     * @param updateMaintenanceWindowTaskRequest
     * @return Result of the UpdateMaintenanceWindowTask operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateMaintenanceWindowTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateMaintenanceWindowTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateMaintenanceWindowTaskResponse updateMaintenanceWindowTask(
            UpdateMaintenanceWindowTaskRequest updateMaintenanceWindowTaskRequest) throws DoesNotExistException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMaintenanceWindowTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateMaintenanceWindowTaskResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMaintenanceWindowTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMaintenanceWindowTask");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateMaintenanceWindowTaskRequest, UpdateMaintenanceWindowTaskResponse>()
                            .withOperationName("UpdateMaintenanceWindowTask").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateMaintenanceWindowTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateMaintenanceWindowTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes the Identity and Access Management (IAM) role that is assigned to the on-premises server, edge device, or
     * virtual machines (VM). IAM roles are first assigned to these hybrid nodes during the activation process. For more
     * information, see <a>CreateActivation</a>.
     * </p>
     *
     * @param updateManagedInstanceRoleRequest
     * @return Result of the UpdateManagedInstanceRole operation returned by the service.
     * @throws InvalidInstanceIdException
     *         The following problems can cause this exception:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         You don't have permission to access the managed node.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Amazon Web Services Systems Manager Agent(SSM Agent) isn't running. Verify that SSM Agent is running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         SSM Agent isn't registered with the SSM endpoint. Try reinstalling SSM Agent.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The managed node isn't in valid state. Valid states are: <code>Running</code>, <code>Pending</code>,
     *         <code>Stopped</code>, and <code>Stopping</code>. Invalid states are: <code>Shutting-down</code> and
     *         <code>Terminated</code>.
     *         </p>
     *         </li>
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateManagedInstanceRole
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateManagedInstanceRole" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateManagedInstanceRoleResponse updateManagedInstanceRole(
            UpdateManagedInstanceRoleRequest updateManagedInstanceRoleRequest) throws InvalidInstanceIdException,
            InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateManagedInstanceRoleResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateManagedInstanceRoleResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateManagedInstanceRoleRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateManagedInstanceRole");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateManagedInstanceRoleRequest, UpdateManagedInstanceRoleResponse>()
                            .withOperationName("UpdateManagedInstanceRole").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateManagedInstanceRoleRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateManagedInstanceRoleRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Edit or change an OpsItem. You must have permission in Identity and Access Management (IAM) to update an OpsItem.
     * For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html">Getting
     * started with OpsCenter</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Operations engineers and IT professionals use Amazon Web Services Systems Manager OpsCenter to view, investigate,
     * and remediate operational issues impacting the performance and health of their Amazon Web Services resources. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html">OpsCenter</a> in the <i>Amazon
     * Web Services Systems Manager User Guide</i>.
     * </p>
     *
     * @param updateOpsItemRequest
     * @return Result of the UpdateOpsItem operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws OpsItemNotFoundException
     *         The specified OpsItem ID doesn't exist. Verify the ID and try again.
     * @throws OpsItemAlreadyExistsException
     *         The OpsItem already exists.
     * @throws OpsItemLimitExceededException
     *         The request caused OpsItems to exceed one or more quotas. For information about OpsItem quotas, see <a
     *         href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-learn-more.html#OpsCenter-learn-more-limits"
     *         >What are the resource limits for OpsCenter?</a>.
     * @throws OpsItemInvalidParameterException
     *         A specified parameter argument isn't valid. Verify the available arguments and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateOpsItem
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateOpsItem" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateOpsItemResponse updateOpsItem(UpdateOpsItemRequest updateOpsItemRequest) throws InternalServerErrorException,
            OpsItemNotFoundException, OpsItemAlreadyExistsException, OpsItemLimitExceededException,
            OpsItemInvalidParameterException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateOpsItemResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateOpsItemResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOpsItemRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOpsItem");

            return clientHandler.execute(new ClientExecutionParams<UpdateOpsItemRequest, UpdateOpsItemResponse>()
                    .withOperationName("UpdateOpsItem").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateOpsItemRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateOpsItemRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Amazon Web Services Systems Manager calls this API operation when you edit OpsMetadata in Application Manager.
     * </p>
     *
     * @param updateOpsMetadataRequest
     * @return Result of the UpdateOpsMetadata operation returned by the service.
     * @throws OpsMetadataNotFoundException
     *         The OpsMetadata object doesn't exist.
     * @throws OpsMetadataInvalidArgumentException
     *         One of the arguments passed is invalid.
     * @throws OpsMetadataKeyLimitExceededException
     *         The OpsMetadata object exceeds the maximum number of OpsMetadata keys that you can assign to an
     *         application in Application Manager.
     * @throws OpsMetadataTooManyUpdatesException
     *         The system is processing too many concurrent updates. Wait a few moments and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateOpsMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateOpsMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateOpsMetadataResponse updateOpsMetadata(UpdateOpsMetadataRequest updateOpsMetadataRequest)
            throws OpsMetadataNotFoundException, OpsMetadataInvalidArgumentException, OpsMetadataKeyLimitExceededException,
            OpsMetadataTooManyUpdatesException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateOpsMetadataResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateOpsMetadataResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOpsMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOpsMetadata");

            return clientHandler.execute(new ClientExecutionParams<UpdateOpsMetadataRequest, UpdateOpsMetadataResponse>()
                    .withOperationName("UpdateOpsMetadata").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateOpsMetadataRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateOpsMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Modifies an existing patch baseline. Fields not specified in the request are left unchanged.
     * </p>
     * <note>
     * <p>
     * For information about valid key-value pairs in <code>PatchFilters</code> for each supported operating system
     * type, see <a>PatchFilter</a>.
     * </p>
     * </note>
     *
     * @param updatePatchBaselineRequest
     * @return Result of the UpdatePatchBaseline operation returned by the service.
     * @throws DoesNotExistException
     *         Error returned when the ID specified for a resource, such as a maintenance window or patch baseline,
     *         doesn't exist.</p>
     *         <p>
     *         For information about resource quotas in Amazon Web Services Systems Manager, see <a
     *         href="https://docs.aws.amazon.com/general/latest/gr/ssm.html#limits_ssm">Systems Manager service
     *         quotas</a> in the <i>Amazon Web Services General Reference</i>.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdatePatchBaseline
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdatePatchBaseline" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdatePatchBaselineResponse updatePatchBaseline(UpdatePatchBaselineRequest updatePatchBaselineRequest)
            throws DoesNotExistException, InternalServerErrorException, AwsServiceException, SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePatchBaselineResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePatchBaselineResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePatchBaselineRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePatchBaseline");

            return clientHandler.execute(new ClientExecutionParams<UpdatePatchBaselineRequest, UpdatePatchBaselineResponse>()
                    .withOperationName("UpdatePatchBaseline").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updatePatchBaselineRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdatePatchBaselineRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update a resource data sync. After you create a resource data sync for a Region, you can't change the account
     * options for that sync. For example, if you create a sync in the us-east-2 (Ohio) Region and you choose the
     * <code>Include only the current account</code> option, you can't edit that sync later and choose the
     * <code>Include all accounts from my Organizations configuration</code> option. Instead, you must delete the first
     * resource data sync, and create a new one.
     * </p>
     * <note>
     * <p>
     * This API operation only supports a resource data sync that was created with a SyncFromSource
     * <code>SyncType</code>.
     * </p>
     * </note>
     *
     * @param updateResourceDataSyncRequest
     * @return Result of the UpdateResourceDataSync operation returned by the service.
     * @throws ResourceDataSyncNotFoundException
     *         The specified sync name wasn't found.
     * @throws ResourceDataSyncInvalidConfigurationException
     *         The specified sync configuration is invalid.
     * @throws ResourceDataSyncConflictException
     *         Another <code>UpdateResourceDataSync</code> request is being processed. Wait a few minutes and try again.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateResourceDataSync
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateResourceDataSync" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateResourceDataSyncResponse updateResourceDataSync(UpdateResourceDataSyncRequest updateResourceDataSyncRequest)
            throws ResourceDataSyncNotFoundException, ResourceDataSyncInvalidConfigurationException,
            ResourceDataSyncConflictException, InternalServerErrorException, AwsServiceException, SdkClientException,
            SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateResourceDataSyncResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateResourceDataSyncResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResourceDataSyncRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResourceDataSync");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateResourceDataSyncRequest, UpdateResourceDataSyncResponse>()
                            .withOperationName("UpdateResourceDataSync").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateResourceDataSyncRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateResourceDataSyncRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * <code>ServiceSetting</code> is an account-level setting for an Amazon Web Services service. This setting defines
     * how a user interacts with or uses a service or a feature of a service. For example, if an Amazon Web Services
     * service charges money to the account based on feature or service usage, then the Amazon Web Services service team
     * might create a default setting of "false". This means the user can't use this feature unless they change the
     * setting to "true" and intentionally opt in for a paid feature.
     * </p>
     * <p>
     * Services map a <code>SettingId</code> object to a setting value. Amazon Web Services services teams define the
     * default value for a <code>SettingId</code>. You can't create a new <code>SettingId</code>, but you can overwrite
     * the default value if you have the <code>ssm:UpdateServiceSetting</code> permission for the setting. Use the
     * <a>GetServiceSetting</a> API operation to view the current value. Or, use the <a>ResetServiceSetting</a> to
     * change the value back to the original value defined by the Amazon Web Services service team.
     * </p>
     * <p>
     * Update the service setting for the account.
     * </p>
     *
     * @param updateServiceSettingRequest
     *        The request body of the UpdateServiceSetting API operation.
     * @return Result of the UpdateServiceSetting operation returned by the service.
     * @throws InternalServerErrorException
     *         An error occurred on the server side.
     * @throws ServiceSettingNotFoundException
     *         The specified service setting wasn't found. Either the service name or the setting hasn't been
     *         provisioned by the Amazon Web Services service team.
     * @throws TooManyUpdatesException
     *         There are concurrent updates for a resource that supports one update at a time.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SsmException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SsmClient.UpdateServiceSetting
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/UpdateServiceSetting" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateServiceSettingResponse updateServiceSetting(UpdateServiceSettingRequest updateServiceSettingRequest)
            throws InternalServerErrorException, ServiceSettingNotFoundException, TooManyUpdatesException, AwsServiceException,
            SdkClientException, SsmException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateServiceSettingResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateServiceSettingResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateServiceSettingRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "SSM");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateServiceSetting");

            return clientHandler.execute(new ClientExecutionParams<UpdateServiceSettingRequest, UpdateServiceSettingResponse>()
                    .withOperationName("UpdateServiceSetting").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateServiceSettingRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateServiceSettingRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(SsmException::builder)
                .protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetNotConnected")
                                .exceptionBuilderSupplier(TargetNotConnectedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ItemSizeLimitExceededException")
                                .exceptionBuilderSupplier(ItemSizeLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameters")
                                .exceptionBuilderSupplier(InvalidParametersException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterMaxVersionLimitExceeded")
                                .exceptionBuilderSupplier(ParameterMaxVersionLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PoliciesLimitExceededException")
                                .exceptionBuilderSupplier(PoliciesLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidKeyId")
                                .exceptionBuilderSupplier(InvalidKeyIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFilter")
                                .exceptionBuilderSupplier(InvalidFilterException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociationExecutionDoesNotExist")
                                .exceptionBuilderSupplier(AssociationExecutionDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsItemLimitExceededException")
                                .exceptionBuilderSupplier(OpsItemLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidSchedule")
                                .exceptionBuilderSupplier(InvalidScheduleException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedInventorySchemaVersionException")
                                .exceptionBuilderSupplier(UnsupportedInventorySchemaVersionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDataSyncAlreadyExistsException")
                                .exceptionBuilderSupplier(ResourceDataSyncAlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPluginName")
                                .exceptionBuilderSupplier(InvalidPluginNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HierarchyTypeMismatchException")
                                .exceptionBuilderSupplier(HierarchyTypeMismatchException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("FeatureNotAvailableException")
                                .exceptionBuilderSupplier(FeatureNotAvailableException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextToken")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDataSyncInvalidConfigurationException")
                                .exceptionBuilderSupplier(ResourceDataSyncInvalidConfigurationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidActivationId")
                                .exceptionBuilderSupplier(InvalidActivationIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvocationDoesNotExist")
                                .exceptionBuilderSupplier(InvocationDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsItemInvalidParameterException")
                                .exceptionBuilderSupplier(OpsItemInvalidParameterException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AlreadyExistsException")
                                .exceptionBuilderSupplier(AlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsMetadataTooManyUpdatesException")
                                .exceptionBuilderSupplier(OpsMetadataTooManyUpdatesException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SubTypeCountLimitExceededException")
                                .exceptionBuilderSupplier(SubTypeCountLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResourceId")
                                .exceptionBuilderSupplier(InvalidResourceIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterVersionNotFound")
                                .exceptionBuilderSupplier(ParameterVersionNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceSettingNotFound")
                                .exceptionBuilderSupplier(ServiceSettingNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceInUseException")
                                .exceptionBuilderSupplier(ResourceInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDocument")
                                .exceptionBuilderSupplier(InvalidDocumentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDocumentVersion")
                                .exceptionBuilderSupplier(InvalidDocumentVersionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOptionException")
                                .exceptionBuilderSupplier(InvalidOptionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDocumentOperation")
                                .exceptionBuilderSupplier(InvalidDocumentOperationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDataSyncCountExceededException")
                                .exceptionBuilderSupplier(ResourceDataSyncCountExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ComplianceTypeCountLimitExceededException")
                                .exceptionBuilderSupplier(ComplianceTypeCountLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResourceType")
                                .exceptionBuilderSupplier(InvalidResourceTypeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedFeatureRequiredException")
                                .exceptionBuilderSupplier(UnsupportedFeatureRequiredException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AutomationDefinitionNotFoundException")
                                .exceptionBuilderSupplier(AutomationDefinitionNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInstanceId")
                                .exceptionBuilderSupplier(InvalidInstanceIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ItemContentMismatchException")
                                .exceptionBuilderSupplier(ItemContentMismatchException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDataSyncNotFoundException")
                                .exceptionBuilderSupplier(ResourceDataSyncNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsItemAlreadyExistsException")
                                .exceptionBuilderSupplier(OpsItemAlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateInstanceId")
                                .exceptionBuilderSupplier(DuplicateInstanceIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDocumentContent")
                                .exceptionBuilderSupplier(InvalidDocumentContentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AutomationExecutionNotFoundException")
                                .exceptionBuilderSupplier(AutomationExecutionNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedCalendarException")
                                .exceptionBuilderSupplier(UnsupportedCalendarException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociationLimitExceeded")
                                .exceptionBuilderSupplier(AssociationLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsMetadataKeyLimitExceededException")
                                .exceptionBuilderSupplier(OpsMetadataKeyLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceDataSyncConflictException")
                                .exceptionBuilderSupplier(ResourceDataSyncConflictException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInventoryGroupException")
                                .exceptionBuilderSupplier(InvalidInventoryGroupException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociationVersionLimitExceeded")
                                .exceptionBuilderSupplier(AssociationVersionLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTarget")
                                .exceptionBuilderSupplier(InvalidTargetException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsMetadataInvalidArgumentException")
                                .exceptionBuilderSupplier(OpsMetadataInvalidArgumentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AutomationStepNotFoundException")
                                .exceptionBuilderSupplier(AutomationStepNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFilterValue")
                                .exceptionBuilderSupplier(InvalidFilterValueException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DocumentVersionLimitExceeded")
                                .exceptionBuilderSupplier(DocumentVersionLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidItemContentException")
                                .exceptionBuilderSupplier(InvalidItemContentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyTagsError")
                                .exceptionBuilderSupplier(TooManyTagsErrorException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedParameterType")
                                .exceptionBuilderSupplier(UnsupportedParameterTypeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAggregatorException")
                                .exceptionBuilderSupplier(InvalidAggregatorException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedInventoryItemContextException")
                                .exceptionBuilderSupplier(UnsupportedInventoryItemContextException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPolicyAttributeException")
                                .exceptionBuilderSupplier(InvalidPolicyAttributeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IncompatiblePolicyException")
                                .exceptionBuilderSupplier(IncompatiblePolicyException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidUpdate")
                                .exceptionBuilderSupplier(InvalidUpdateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociationAlreadyExists")
                                .exceptionBuilderSupplier(AssociationAlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateDocumentContent")
                                .exceptionBuilderSupplier(DuplicateDocumentContentException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDocumentSchemaVersion")
                                .exceptionBuilderSupplier(InvalidDocumentSchemaVersionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInventoryItemContextException")
                                .exceptionBuilderSupplier(InvalidInventoryItemContextException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAssociation")
                                .exceptionBuilderSupplier(InvalidAssociationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAutomationSignalException")
                                .exceptionBuilderSupplier(InvalidAutomationSignalException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDocumentType")
                                .exceptionBuilderSupplier(InvalidDocumentTypeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdempotentParameterMismatch")
                                .exceptionBuilderSupplier(IdempotentParameterMismatchException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInventoryRequestException")
                                .exceptionBuilderSupplier(InvalidInventoryRequestException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidResultAttributeException")
                                .exceptionBuilderSupplier(InvalidResultAttributeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AutomationDefinitionVersionNotFoundException")
                                .exceptionBuilderSupplier(AutomationDefinitionVersionNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAutomationExecutionParametersException")
                                .exceptionBuilderSupplier(InvalidAutomationExecutionParametersException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceLimitExceededException")
                                .exceptionBuilderSupplier(ResourceLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAllowedPatternException")
                                .exceptionBuilderSupplier(InvalidAllowedPatternException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsItemNotFoundException")
                                .exceptionBuilderSupplier(OpsItemNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeleteInventoryParametersException")
                                .exceptionBuilderSupplier(InvalidDeleteInventoryParametersException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPermissionType")
                                .exceptionBuilderSupplier(InvalidPermissionTypeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedOperatingSystem")
                                .exceptionBuilderSupplier(UnsupportedOperatingSystemException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsMetadataAlreadyExistsException")
                                .exceptionBuilderSupplier(OpsMetadataAlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOutputFolder")
                                .exceptionBuilderSupplier(InvalidOutputFolderException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAssociationNotFoundException")
                                .exceptionBuilderSupplier(OpsItemRelatedItemAssociationNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AutomationExecutionLimitExceededException")
                                .exceptionBuilderSupplier(AutomationExecutionLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DuplicateDocumentVersionName")
                                .exceptionBuilderSupplier(DuplicateDocumentVersionNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNotificationConfig")
                                .exceptionBuilderSupplier(InvalidNotificationConfigException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidCommandId")
                                .exceptionBuilderSupplier(InvalidCommandIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterNotFound")
                                .exceptionBuilderSupplier(ParameterNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterVersionLabelLimitExceeded")
                                .exceptionBuilderSupplier(ParameterVersionLabelLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DocumentPermissionLimit")
                                .exceptionBuilderSupplier(DocumentPermissionLimitException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DocumentLimitExceeded")
                                .exceptionBuilderSupplier(DocumentLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("HierarchyLevelLimitExceededException")
                                .exceptionBuilderSupplier(HierarchyLevelLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TotalSizeLimitExceededException")
                                .exceptionBuilderSupplier(TotalSizeLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsMetadataLimitExceededException")
                                .exceptionBuilderSupplier(OpsMetadataLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidActivation")
                                .exceptionBuilderSupplier(InvalidActivationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsItemRelatedItemAlreadyExistsException")
                                .exceptionBuilderSupplier(OpsItemRelatedItemAlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TooManyUpdates")
                                .exceptionBuilderSupplier(TooManyUpdatesException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("OpsMetadataNotFoundException")
                                .exceptionBuilderSupplier(OpsMetadataNotFoundException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DocumentAlreadyExists")
                                .exceptionBuilderSupplier(DocumentAlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AutomationDefinitionNotApprovedException")
                                .exceptionBuilderSupplier(AutomationDefinitionNotApprovedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidInstanceInformationFilterValue")
                                .exceptionBuilderSupplier(InvalidInstanceInformationFilterValueException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAssociationVersion")
                                .exceptionBuilderSupplier(InvalidAssociationVersionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("StatusUnchanged")
                                .exceptionBuilderSupplier(StatusUnchangedException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("TargetInUseException")
                                .exceptionBuilderSupplier(TargetInUseException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociationDoesNotExist")
                                .exceptionBuilderSupplier(AssociationDoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedPlatformType")
                                .exceptionBuilderSupplier(UnsupportedPlatformTypeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("MaxDocumentSizeExceeded")
                                .exceptionBuilderSupplier(MaxDocumentSizeExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRole")
                                .exceptionBuilderSupplier(InvalidRoleException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidDeletionIdException")
                                .exceptionBuilderSupplier(InvalidDeletionIdException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AssociatedInstances")
                                .exceptionBuilderSupplier(AssociatedInstancesException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidOutputLocation")
                                .exceptionBuilderSupplier(InvalidOutputLocationException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidPolicyTypeException")
                                .exceptionBuilderSupplier(InvalidPolicyTypeException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterLimitExceeded")
                                .exceptionBuilderSupplier(ParameterLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTypeNameException")
                                .exceptionBuilderSupplier(InvalidTypeNameException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidAutomationStatusUpdateException")
                                .exceptionBuilderSupplier(InvalidAutomationStatusUpdateException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DoesNotExistException")
                                .exceptionBuilderSupplier(DoesNotExistException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFilterOption")
                                .exceptionBuilderSupplier(InvalidFilterOptionException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("CustomSchemaCountLimitExceededException")
                                .exceptionBuilderSupplier(CustomSchemaCountLimitExceededException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterPatternMismatchException")
                                .exceptionBuilderSupplier(ParameterPatternMismatchException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ParameterAlreadyExists")
                                .exceptionBuilderSupplier(ParameterAlreadyExistsException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidFilterKey")
                                .exceptionBuilderSupplier(InvalidFilterKeyException::builder).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerError")
                                .exceptionBuilderSupplier(InternalServerErrorException::builder).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends SsmRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    @Override
    public SsmWaiter waiter() {
        return SsmWaiter.builder().client(this).build();
    }
}
