/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeInstanceInformationRequest extends SsmRequest implements
        ToCopyableBuilder<DescribeInstanceInformationRequest.Builder, DescribeInstanceInformationRequest> {
    private static final SdkField<List<InstanceInformationFilter>> INSTANCE_INFORMATION_FILTER_LIST_FIELD = SdkField
            .<List<InstanceInformationFilter>> builder(MarshallingType.LIST)
            .memberName("InstanceInformationFilterList")
            .getter(getter(DescribeInstanceInformationRequest::instanceInformationFilterList))
            .setter(setter(Builder::instanceInformationFilterList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceInformationFilterList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceInformationFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceInformationFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<InstanceInformationStringFilter>> FILTERS_FIELD = SdkField
            .<List<InstanceInformationStringFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeInstanceInformationRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceInformationStringFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceInformationStringFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeInstanceInformationRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeInstanceInformationRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            INSTANCE_INFORMATION_FILTER_LIST_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final List<InstanceInformationFilter> instanceInformationFilterList;

    private final List<InstanceInformationStringFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeInstanceInformationRequest(BuilderImpl builder) {
        super(builder);
        this.instanceInformationFilterList = builder.instanceInformationFilterList;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the InstanceInformationFilterList property was specified by the sender (it may be empty), or
     * false if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender
     * is the AWS service.
     */
    public final boolean hasInstanceInformationFilterList() {
        return instanceInformationFilterList != null && !(instanceInformationFilterList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * This is a legacy method. We recommend that you don't use this method. Instead, use the <code>Filters</code> data
     * type. <code>Filters</code> enables you to return instance information by filtering based on tags applied to
     * managed instances.
     * </p>
     * <note>
     * <p>
     * Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads to an exception
     * error.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasInstanceInformationFilterList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return This is a legacy method. We recommend that you don't use this method. Instead, use the
     *         <code>Filters</code> data type. <code>Filters</code> enables you to return instance information by
     *         filtering based on tags applied to managed instances.</p> <note>
     *         <p>
     *         Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads to an
     *         exception error.
     *         </p>
     */
    public final List<InstanceInformationFilter> instanceInformationFilterList() {
        return instanceInformationFilterList;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One or more filters. Use a filter to return a more specific list of instances. You can filter based on tags
     * applied to EC2 instances. Use this <code>Filters</code> data type instead of
     * <code>InstanceInformationFilterList</code>, which is deprecated.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return One or more filters. Use a filter to return a more specific list of instances. You can filter based on
     *         tags applied to EC2 instances. Use this <code>Filters</code> data type instead of
     *         <code>InstanceInformationFilterList</code>, which is deprecated.
     */
    public final List<InstanceInformationStringFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of items to return. (You received this token from a previous call.)
     * </p>
     * 
     * @return The token for the next set of items to return. (You received this token from a previous call.)
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceInformationFilterList() ? instanceInformationFilterList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstanceInformationRequest)) {
            return false;
        }
        DescribeInstanceInformationRequest other = (DescribeInstanceInformationRequest) obj;
        return hasInstanceInformationFilterList() == other.hasInstanceInformationFilterList()
                && Objects.equals(instanceInformationFilterList(), other.instanceInformationFilterList())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeInstanceInformationRequest")
                .add("InstanceInformationFilterList", hasInstanceInformationFilterList() ? instanceInformationFilterList() : null)
                .add("Filters", hasFilters() ? filters() : null).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceInformationFilterList":
            return Optional.ofNullable(clazz.cast(instanceInformationFilterList()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeInstanceInformationRequest, T> g) {
        return obj -> g.apply((DescribeInstanceInformationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeInstanceInformationRequest> {
        /**
         * <p>
         * This is a legacy method. We recommend that you don't use this method. Instead, use the <code>Filters</code>
         * data type. <code>Filters</code> enables you to return instance information by filtering based on tags applied
         * to managed instances.
         * </p>
         * <note>
         * <p>
         * Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads to an exception
         * error.
         * </p>
         * </note>
         * 
         * @param instanceInformationFilterList
         *        This is a legacy method. We recommend that you don't use this method. Instead, use the
         *        <code>Filters</code> data type. <code>Filters</code> enables you to return instance information by
         *        filtering based on tags applied to managed instances.</p> <note>
         *        <p>
         *        Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads to an
         *        exception error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInformationFilterList(Collection<InstanceInformationFilter> instanceInformationFilterList);

        /**
         * <p>
         * This is a legacy method. We recommend that you don't use this method. Instead, use the <code>Filters</code>
         * data type. <code>Filters</code> enables you to return instance information by filtering based on tags applied
         * to managed instances.
         * </p>
         * <note>
         * <p>
         * Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads to an exception
         * error.
         * </p>
         * </note>
         * 
         * @param instanceInformationFilterList
         *        This is a legacy method. We recommend that you don't use this method. Instead, use the
         *        <code>Filters</code> data type. <code>Filters</code> enables you to return instance information by
         *        filtering based on tags applied to managed instances.</p> <note>
         *        <p>
         *        Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads to an
         *        exception error.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInformationFilterList(InstanceInformationFilter... instanceInformationFilterList);

        /**
         * <p>
         * This is a legacy method. We recommend that you don't use this method. Instead, use the <code>Filters</code>
         * data type. <code>Filters</code> enables you to return instance information by filtering based on tags applied
         * to managed instances.
         * </p>
         * <note>
         * <p>
         * Attempting to use <code>InstanceInformationFilterList</code> and <code>Filters</code> leads to an exception
         * error.
         * </p>
         * </note> This is a convenience that creates an instance of the {@link List<InstanceInformationFilter>.Builder}
         * avoiding the need to create one manually via {@link List<InstanceInformationFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceInformationFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #instanceInformationFilterList(List<InstanceInformationFilter>)}.
         * 
         * @param instanceInformationFilterList
         *        a consumer that will call methods on {@link List<InstanceInformationFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceInformationFilterList(List<InstanceInformationFilter>)
         */
        Builder instanceInformationFilterList(Consumer<InstanceInformationFilter.Builder>... instanceInformationFilterList);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of instances. You can filter based on tags
         * applied to EC2 instances. Use this <code>Filters</code> data type instead of
         * <code>InstanceInformationFilterList</code>, which is deprecated.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of instances. You can filter based on
         *        tags applied to EC2 instances. Use this <code>Filters</code> data type instead of
         *        <code>InstanceInformationFilterList</code>, which is deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<InstanceInformationStringFilter> filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of instances. You can filter based on tags
         * applied to EC2 instances. Use this <code>Filters</code> data type instead of
         * <code>InstanceInformationFilterList</code>, which is deprecated.
         * </p>
         * 
         * @param filters
         *        One or more filters. Use a filter to return a more specific list of instances. You can filter based on
         *        tags applied to EC2 instances. Use this <code>Filters</code> data type instead of
         *        <code>InstanceInformationFilterList</code>, which is deprecated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(InstanceInformationStringFilter... filters);

        /**
         * <p>
         * One or more filters. Use a filter to return a more specific list of instances. You can filter based on tags
         * applied to EC2 instances. Use this <code>Filters</code> data type instead of
         * <code>InstanceInformationFilterList</code>, which is deprecated.
         * </p>
         * This is a convenience that creates an instance of the {@link List<InstanceInformationStringFilter>.Builder}
         * avoiding the need to create one manually via {@link List<InstanceInformationStringFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InstanceInformationStringFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<InstanceInformationStringFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<InstanceInformationStringFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<InstanceInformationStringFilter>)
         */
        Builder filters(Consumer<InstanceInformationStringFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of items to return. (You received this token from a previous call.)
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. (You received this token from a previous call.)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private List<InstanceInformationFilter> instanceInformationFilterList = DefaultSdkAutoConstructList.getInstance();

        private List<InstanceInformationStringFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstanceInformationRequest model) {
            super(model);
            instanceInformationFilterList(model.instanceInformationFilterList);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final List<InstanceInformationFilter.Builder> getInstanceInformationFilterList() {
            List<InstanceInformationFilter.Builder> result = InstanceInformationFilterListCopier
                    .copyToBuilder(this.instanceInformationFilterList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceInformationFilterList(
                Collection<InstanceInformationFilter.BuilderImpl> instanceInformationFilterList) {
            this.instanceInformationFilterList = InstanceInformationFilterListCopier
                    .copyFromBuilder(instanceInformationFilterList);
        }

        @Override
        @Transient
        public final Builder instanceInformationFilterList(Collection<InstanceInformationFilter> instanceInformationFilterList) {
            this.instanceInformationFilterList = InstanceInformationFilterListCopier.copy(instanceInformationFilterList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceInformationFilterList(InstanceInformationFilter... instanceInformationFilterList) {
            instanceInformationFilterList(Arrays.asList(instanceInformationFilterList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder instanceInformationFilterList(
                Consumer<InstanceInformationFilter.Builder>... instanceInformationFilterList) {
            instanceInformationFilterList(Stream.of(instanceInformationFilterList)
                    .map(c -> InstanceInformationFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<InstanceInformationStringFilter.Builder> getFilters() {
            List<InstanceInformationStringFilter.Builder> result = InstanceInformationStringFilterListCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<InstanceInformationStringFilter.BuilderImpl> filters) {
            this.filters = InstanceInformationStringFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<InstanceInformationStringFilter> filters) {
            this.filters = InstanceInformationStringFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(InstanceInformationStringFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<InstanceInformationStringFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> InstanceInformationStringFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeInstanceInformationRequest build() {
            return new DescribeInstanceInformationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
