/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeMaintenanceWindowExecutionTaskInvocationsResponse extends SsmResponse
        implements
        ToCopyableBuilder<DescribeMaintenanceWindowExecutionTaskInvocationsResponse.Builder, DescribeMaintenanceWindowExecutionTaskInvocationsResponse> {
    private static final SdkField<List<MaintenanceWindowExecutionTaskInvocationIdentity>> WINDOW_EXECUTION_TASK_INVOCATION_IDENTITIES_FIELD = SdkField
            .<List<MaintenanceWindowExecutionTaskInvocationIdentity>> builder(MarshallingType.LIST)
            .memberName("WindowExecutionTaskInvocationIdentities")
            .getter(getter(DescribeMaintenanceWindowExecutionTaskInvocationsResponse::windowExecutionTaskInvocationIdentities))
            .setter(setter(Builder::windowExecutionTaskInvocationIdentities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("WindowExecutionTaskInvocationIdentities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MaintenanceWindowExecutionTaskInvocationIdentity> builder(MarshallingType.SDK_POJO)
                                            .constructor(MaintenanceWindowExecutionTaskInvocationIdentity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeMaintenanceWindowExecutionTaskInvocationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            WINDOW_EXECUTION_TASK_INVOCATION_IDENTITIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities;

    private final String nextToken;

    private DescribeMaintenanceWindowExecutionTaskInvocationsResponse(BuilderImpl builder) {
        super(builder);
        this.windowExecutionTaskInvocationIdentities = builder.windowExecutionTaskInvocationIdentities;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the WindowExecutionTaskInvocationIdentities property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public final boolean hasWindowExecutionTaskInvocationIdentities() {
        return windowExecutionTaskInvocationIdentities != null
                && !(windowExecutionTaskInvocationIdentities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the task invocation results per invocation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWindowExecutionTaskInvocationIdentities()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the task invocation results per invocation.
     */
    public final List<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities() {
        return windowExecutionTaskInvocationIdentities;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasWindowExecutionTaskInvocationIdentities() ? windowExecutionTaskInvocationIdentities()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeMaintenanceWindowExecutionTaskInvocationsResponse)) {
            return false;
        }
        DescribeMaintenanceWindowExecutionTaskInvocationsResponse other = (DescribeMaintenanceWindowExecutionTaskInvocationsResponse) obj;
        return hasWindowExecutionTaskInvocationIdentities() == other.hasWindowExecutionTaskInvocationIdentities()
                && Objects.equals(windowExecutionTaskInvocationIdentities(), other.windowExecutionTaskInvocationIdentities())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DescribeMaintenanceWindowExecutionTaskInvocationsResponse")
                .add("WindowExecutionTaskInvocationIdentities",
                        hasWindowExecutionTaskInvocationIdentities() ? windowExecutionTaskInvocationIdentities() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowExecutionTaskInvocationIdentities":
            return Optional.ofNullable(clazz.cast(windowExecutionTaskInvocationIdentities()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeMaintenanceWindowExecutionTaskInvocationsResponse, T> g) {
        return obj -> g.apply((DescribeMaintenanceWindowExecutionTaskInvocationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeMaintenanceWindowExecutionTaskInvocationsResponse> {
        /**
         * <p>
         * Information about the task invocation results per invocation.
         * </p>
         * 
         * @param windowExecutionTaskInvocationIdentities
         *        Information about the task invocation results per invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionTaskInvocationIdentities(
                Collection<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities);

        /**
         * <p>
         * Information about the task invocation results per invocation.
         * </p>
         * 
         * @param windowExecutionTaskInvocationIdentities
         *        Information about the task invocation results per invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionTaskInvocationIdentities(
                MaintenanceWindowExecutionTaskInvocationIdentity... windowExecutionTaskInvocationIdentities);

        /**
         * <p>
         * Information about the task invocation results per invocation.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <MaintenanceWindowExecutionTaskInvocationIdentity>.Builder} avoiding the need to create one manually via
         * {@link List<MaintenanceWindowExecutionTaskInvocationIdentity>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List
         * <MaintenanceWindowExecutionTaskInvocationIdentity>.Builder#build()} is called immediately and its result is
         * passed to {@link
         * #windowExecutionTaskInvocationIdentities(List<MaintenanceWindowExecutionTaskInvocationIdentity>)}.
         * 
         * @param windowExecutionTaskInvocationIdentities
         *        a consumer that will call methods on {@link List
         *        <MaintenanceWindowExecutionTaskInvocationIdentity>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windowExecutionTaskInvocationIdentities(List<MaintenanceWindowExecutionTaskInvocationIdentity>)
         */
        Builder windowExecutionTaskInvocationIdentities(
                Consumer<MaintenanceWindowExecutionTaskInvocationIdentity.Builder>... windowExecutionTaskInvocationIdentities);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeMaintenanceWindowExecutionTaskInvocationsResponse model) {
            super(model);
            windowExecutionTaskInvocationIdentities(model.windowExecutionTaskInvocationIdentities);
            nextToken(model.nextToken);
        }

        public final List<MaintenanceWindowExecutionTaskInvocationIdentity.Builder> getWindowExecutionTaskInvocationIdentities() {
            List<MaintenanceWindowExecutionTaskInvocationIdentity.Builder> result = MaintenanceWindowExecutionTaskInvocationIdentityListCopier
                    .copyToBuilder(this.windowExecutionTaskInvocationIdentities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWindowExecutionTaskInvocationIdentities(
                Collection<MaintenanceWindowExecutionTaskInvocationIdentity.BuilderImpl> windowExecutionTaskInvocationIdentities) {
            this.windowExecutionTaskInvocationIdentities = MaintenanceWindowExecutionTaskInvocationIdentityListCopier
                    .copyFromBuilder(windowExecutionTaskInvocationIdentities);
        }

        @Override
        @Transient
        public final Builder windowExecutionTaskInvocationIdentities(
                Collection<MaintenanceWindowExecutionTaskInvocationIdentity> windowExecutionTaskInvocationIdentities) {
            this.windowExecutionTaskInvocationIdentities = MaintenanceWindowExecutionTaskInvocationIdentityListCopier
                    .copy(windowExecutionTaskInvocationIdentities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder windowExecutionTaskInvocationIdentities(
                MaintenanceWindowExecutionTaskInvocationIdentity... windowExecutionTaskInvocationIdentities) {
            windowExecutionTaskInvocationIdentities(Arrays.asList(windowExecutionTaskInvocationIdentities));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder windowExecutionTaskInvocationIdentities(
                Consumer<MaintenanceWindowExecutionTaskInvocationIdentity.Builder>... windowExecutionTaskInvocationIdentities) {
            windowExecutionTaskInvocationIdentities(Stream.of(windowExecutionTaskInvocationIdentities)
                    .map(c -> MaintenanceWindowExecutionTaskInvocationIdentity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeMaintenanceWindowExecutionTaskInvocationsResponse build() {
            return new DescribeMaintenanceWindowExecutionTaskInvocationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
