/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the parameters for a document.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociationDescription implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociationDescription.Builder, AssociationDescription> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AssociationDescription::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(AssociationDescription::instanceId)).setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> ASSOCIATION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationVersion").getter(getter(AssociationDescription::associationVersion))
            .setter(setter(Builder::associationVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationVersion").build())
            .build();

    private static final SdkField<Instant> DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("Date")
            .getter(getter(AssociationDescription::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_ASSOCIATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("LastUpdateAssociationDate")
            .getter(getter(AssociationDescription::lastUpdateAssociationDate)).setter(setter(Builder::lastUpdateAssociationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateAssociationDate").build())
            .build();

    private static final SdkField<AssociationStatus> STATUS_FIELD = SdkField
            .<AssociationStatus> builder(MarshallingType.SDK_POJO).memberName("Status")
            .getter(getter(AssociationDescription::status)).setter(setter(Builder::status))
            .constructor(AssociationStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<AssociationOverview> OVERVIEW_FIELD = SdkField
            .<AssociationOverview> builder(MarshallingType.SDK_POJO).memberName("Overview")
            .getter(getter(AssociationDescription::overview)).setter(setter(Builder::overview))
            .constructor(AssociationOverview::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Overview").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(AssociationDescription::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<String> AUTOMATION_TARGET_PARAMETER_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("AutomationTargetParameterName")
            .getter(getter(AssociationDescription::automationTargetParameterName))
            .setter(setter(Builder::automationTargetParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomationTargetParameterName")
                    .build()).build();

    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(AssociationDescription::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(AssociationDescription::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(AssociationDescription::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SCHEDULE_EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleExpression").getter(getter(AssociationDescription::scheduleExpression))
            .setter(setter(Builder::scheduleExpression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleExpression").build())
            .build();

    private static final SdkField<InstanceAssociationOutputLocation> OUTPUT_LOCATION_FIELD = SdkField
            .<InstanceAssociationOutputLocation> builder(MarshallingType.SDK_POJO).memberName("OutputLocation")
            .getter(getter(AssociationDescription::outputLocation)).setter(setter(Builder::outputLocation))
            .constructor(InstanceAssociationOutputLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputLocation").build()).build();

    private static final SdkField<Instant> LAST_EXECUTION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastExecutionDate").getter(getter(AssociationDescription::lastExecutionDate))
            .setter(setter(Builder::lastExecutionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastExecutionDate").build()).build();

    private static final SdkField<Instant> LAST_SUCCESSFUL_EXECUTION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastSuccessfulExecutionDate")
            .getter(getter(AssociationDescription::lastSuccessfulExecutionDate))
            .setter(setter(Builder::lastSuccessfulExecutionDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSuccessfulExecutionDate")
                    .build()).build();

    private static final SdkField<String> ASSOCIATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationName").getter(getter(AssociationDescription::associationName))
            .setter(setter(Builder::associationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationName").build()).build();

    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxErrors").getter(getter(AssociationDescription::maxErrors)).setter(setter(Builder::maxErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()).build();

    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxConcurrency").getter(getter(AssociationDescription::maxConcurrency))
            .setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()).build();

    private static final SdkField<String> COMPLIANCE_SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ComplianceSeverity").getter(getter(AssociationDescription::complianceSeverityAsString))
            .setter(setter(Builder::complianceSeverity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComplianceSeverity").build())
            .build();

    private static final SdkField<String> SYNC_COMPLIANCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncCompliance").getter(getter(AssociationDescription::syncComplianceAsString))
            .setter(setter(Builder::syncCompliance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncCompliance").build()).build();

    private static final SdkField<Boolean> APPLY_ONLY_AT_CRON_INTERVAL_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("ApplyOnlyAtCronInterval")
            .getter(getter(AssociationDescription::applyOnlyAtCronInterval)).setter(setter(Builder::applyOnlyAtCronInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplyOnlyAtCronInterval").build())
            .build();

    private static final SdkField<List<String>> CALENDAR_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CalendarNames")
            .getter(getter(AssociationDescription::calendarNames))
            .setter(setter(Builder::calendarNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalendarNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField
            .<List<TargetLocation>> builder(MarshallingType.LIST)
            .memberName("TargetLocations")
            .getter(getter(AssociationDescription::targetLocations))
            .setter(setter(Builder::targetLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INSTANCE_ID_FIELD,
            ASSOCIATION_VERSION_FIELD, DATE_FIELD, LAST_UPDATE_ASSOCIATION_DATE_FIELD, STATUS_FIELD, OVERVIEW_FIELD,
            DOCUMENT_VERSION_FIELD, AUTOMATION_TARGET_PARAMETER_NAME_FIELD, PARAMETERS_FIELD, ASSOCIATION_ID_FIELD,
            TARGETS_FIELD, SCHEDULE_EXPRESSION_FIELD, OUTPUT_LOCATION_FIELD, LAST_EXECUTION_DATE_FIELD,
            LAST_SUCCESSFUL_EXECUTION_DATE_FIELD, ASSOCIATION_NAME_FIELD, MAX_ERRORS_FIELD, MAX_CONCURRENCY_FIELD,
            COMPLIANCE_SEVERITY_FIELD, SYNC_COMPLIANCE_FIELD, APPLY_ONLY_AT_CRON_INTERVAL_FIELD, CALENDAR_NAMES_FIELD,
            TARGET_LOCATIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String instanceId;

    private final String associationVersion;

    private final Instant date;

    private final Instant lastUpdateAssociationDate;

    private final AssociationStatus status;

    private final AssociationOverview overview;

    private final String documentVersion;

    private final String automationTargetParameterName;

    private final Map<String, List<String>> parameters;

    private final String associationId;

    private final List<Target> targets;

    private final String scheduleExpression;

    private final InstanceAssociationOutputLocation outputLocation;

    private final Instant lastExecutionDate;

    private final Instant lastSuccessfulExecutionDate;

    private final String associationName;

    private final String maxErrors;

    private final String maxConcurrency;

    private final String complianceSeverity;

    private final String syncCompliance;

    private final Boolean applyOnlyAtCronInterval;

    private final List<String> calendarNames;

    private final List<TargetLocation> targetLocations;

    private AssociationDescription(BuilderImpl builder) {
        this.name = builder.name;
        this.instanceId = builder.instanceId;
        this.associationVersion = builder.associationVersion;
        this.date = builder.date;
        this.lastUpdateAssociationDate = builder.lastUpdateAssociationDate;
        this.status = builder.status;
        this.overview = builder.overview;
        this.documentVersion = builder.documentVersion;
        this.automationTargetParameterName = builder.automationTargetParameterName;
        this.parameters = builder.parameters;
        this.associationId = builder.associationId;
        this.targets = builder.targets;
        this.scheduleExpression = builder.scheduleExpression;
        this.outputLocation = builder.outputLocation;
        this.lastExecutionDate = builder.lastExecutionDate;
        this.lastSuccessfulExecutionDate = builder.lastSuccessfulExecutionDate;
        this.associationName = builder.associationName;
        this.maxErrors = builder.maxErrors;
        this.maxConcurrency = builder.maxConcurrency;
        this.complianceSeverity = builder.complianceSeverity;
        this.syncCompliance = builder.syncCompliance;
        this.applyOnlyAtCronInterval = builder.applyOnlyAtCronInterval;
        this.calendarNames = builder.calendarNames;
        this.targetLocations = builder.targetLocations;
    }

    /**
     * <p>
     * The name of the SSM document.
     * </p>
     * 
     * @return The name of the SSM document.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The managed node ID.
     * </p>
     * 
     * @return The managed node ID.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The association version.
     * </p>
     * 
     * @return The association version.
     */
    public final String associationVersion() {
        return associationVersion;
    }

    /**
     * <p>
     * The date when the association was made.
     * </p>
     * 
     * @return The date when the association was made.
     */
    public final Instant date() {
        return date;
    }

    /**
     * <p>
     * The date when the association was last updated.
     * </p>
     * 
     * @return The date when the association was last updated.
     */
    public final Instant lastUpdateAssociationDate() {
        return lastUpdateAssociationDate;
    }

    /**
     * <p>
     * The association status.
     * </p>
     * 
     * @return The association status.
     */
    public final AssociationStatus status() {
        return status;
    }

    /**
     * <p>
     * Information about the association.
     * </p>
     * 
     * @return Information about the association.
     */
    public final AssociationOverview overview() {
        return overview;
    }

    /**
     * <p>
     * The document version.
     * </p>
     * 
     * @return The document version.
     */
    public final String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * Choose the parameter that will define how your automation will branch out. This target is required for
     * associations that use an Automation runbook and target resources by using rate controls. Automation is a
     * capability of Amazon Web Services Systems Manager.
     * </p>
     * 
     * @return Choose the parameter that will define how your automation will branch out. This target is required for
     *         associations that use an Automation runbook and target resources by using rate controls. Automation is a
     *         capability of Amazon Web Services Systems Manager.
     */
    public final String automationTargetParameterName() {
        return automationTargetParameterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A description of the parameters for a document.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A description of the parameters for a document.
     */
    public final Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The association ID.
     * </p>
     * 
     * @return The association ID.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The managed nodes targeted by the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return The managed nodes targeted by the request.
     */
    public final List<Target> targets() {
        return targets;
    }

    /**
     * <p>
     * A cron expression that specifies a schedule when the association runs.
     * </p>
     * 
     * @return A cron expression that specifies a schedule when the association runs.
     */
    public final String scheduleExpression() {
        return scheduleExpression;
    }

    /**
     * <p>
     * An S3 bucket where you want to store the output details of the request.
     * </p>
     * 
     * @return An S3 bucket where you want to store the output details of the request.
     */
    public final InstanceAssociationOutputLocation outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The date on which the association was last run.
     * </p>
     * 
     * @return The date on which the association was last run.
     */
    public final Instant lastExecutionDate() {
        return lastExecutionDate;
    }

    /**
     * <p>
     * The last date on which the association was successfully run.
     * </p>
     * 
     * @return The last date on which the association was successfully run.
     */
    public final Instant lastSuccessfulExecutionDate() {
        return lastSuccessfulExecutionDate;
    }

    /**
     * <p>
     * The association name.
     * </p>
     * 
     * @return The association name.
     */
    public final String associationName() {
        return associationName;
    }

    /**
     * <p>
     * The number of errors that are allowed before the system stops sending requests to run the association on
     * additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of the
     * target set, for example 10%. If you specify 3, for example, the system stops sending requests when the fourth
     * error is received. If you specify 0, then the system stops sending requests after the first error is returned. If
     * you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system stops sending
     * the request when the sixth error is received.
     * </p>
     * <p>
     * Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to
     * complete, but some of these executions may fail as well. If you need to ensure that there won't be more than
     * max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.
     * </p>
     * 
     * @return The number of errors that are allowed before the system stops sending requests to run the association on
     *         additional targets. You can specify either an absolute number of errors, for example 10, or a percentage
     *         of the target set, for example 10%. If you specify 3, for example, the system stops sending requests when
     *         the fourth error is received. If you specify 0, then the system stops sending requests after the first
     *         error is returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%,
     *         then the system stops sending the request when the sixth error is received.</p>
     *         <p>
     *         Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to
     *         complete, but some of these executions may fail as well. If you need to ensure that there won't be more
     *         than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at
     *         a time.
     */
    public final String maxErrors() {
        return maxErrors;
    }

    /**
     * <p>
     * The maximum number of targets allowed to run the association at the same time. You can specify a number, for
     * example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all
     * targets run the association at the same time.
     * </p>
     * <p>
     * If a new managed node starts and attempts to run an association while Systems Manager is running
     * <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association
     * interval, the new managed node will process its association within the limit specified for
     * <code>MaxConcurrency</code>.
     * </p>
     * 
     * @return The maximum number of targets allowed to run the association at the same time. You can specify a number,
     *         for example 10, or a percentage of the target set, for example 10%. The default value is 100%, which
     *         means all targets run the association at the same time.</p>
     *         <p>
     *         If a new managed node starts and attempts to run an association while Systems Manager is running
     *         <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association
     *         interval, the new managed node will process its association within the limit specified for
     *         <code>MaxConcurrency</code>.
     */
    public final String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The severity level that is assigned to the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #complianceSeverity} will return {@link AssociationComplianceSeverity#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #complianceSeverityAsString}.
     * </p>
     * 
     * @return The severity level that is assigned to the association.
     * @see AssociationComplianceSeverity
     */
    public final AssociationComplianceSeverity complianceSeverity() {
        return AssociationComplianceSeverity.fromValue(complianceSeverity);
    }

    /**
     * <p>
     * The severity level that is assigned to the association.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #complianceSeverity} will return {@link AssociationComplianceSeverity#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #complianceSeverityAsString}.
     * </p>
     * 
     * @return The severity level that is assigned to the association.
     * @see AssociationComplianceSeverity
     */
    public final String complianceSeverityAsString() {
        return complianceSeverity;
    }

    /**
     * <p>
     * The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In
     * <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance
     * status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the
     * association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.
     * </p>
     * <p>
     * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
     * <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager, a
     * capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
     * <a>PutComplianceItems</a> API operation.
     * </p>
     * <p>
     * By default, all associations use <code>AUTO</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncCompliance}
     * will return {@link AssociationSyncCompliance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #syncComplianceAsString}.
     * </p>
     * 
     * @return The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>.
     *         In <code>AUTO</code> mode, the system uses the status of the association execution to determine the
     *         compliance status. If the association execution runs successfully, then the association is
     *         <code>COMPLIANT</code>. If the association execution doesn't run successfully, the association is
     *         <code>NON-COMPLIANT</code>.</p>
     *         <p>
     *         In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
     *         <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager, a
     *         capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
     *         <a>PutComplianceItems</a> API operation.
     *         </p>
     *         <p>
     *         By default, all associations use <code>AUTO</code> mode.
     * @see AssociationSyncCompliance
     */
    public final AssociationSyncCompliance syncCompliance() {
        return AssociationSyncCompliance.fromValue(syncCompliance);
    }

    /**
     * <p>
     * The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In
     * <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance
     * status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If the
     * association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.
     * </p>
     * <p>
     * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
     * <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager, a
     * capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
     * <a>PutComplianceItems</a> API operation.
     * </p>
     * <p>
     * By default, all associations use <code>AUTO</code> mode.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #syncCompliance}
     * will return {@link AssociationSyncCompliance#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #syncComplianceAsString}.
     * </p>
     * 
     * @return The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>.
     *         In <code>AUTO</code> mode, the system uses the status of the association execution to determine the
     *         compliance status. If the association execution runs successfully, then the association is
     *         <code>COMPLIANT</code>. If the association execution doesn't run successfully, the association is
     *         <code>NON-COMPLIANT</code>.</p>
     *         <p>
     *         In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
     *         <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager, a
     *         capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
     *         <a>PutComplianceItems</a> API operation.
     *         </p>
     *         <p>
     *         By default, all associations use <code>AUTO</code> mode.
     * @see AssociationSyncCompliance
     */
    public final String syncComplianceAsString() {
        return syncCompliance;
    }

    /**
     * <p>
     * By default, when you create a new associations, the system runs it immediately after it is created and then
     * according to the schedule you specified. Specify this option if you don't want an association to run immediately
     * after you create it. This parameter isn't supported for rate expressions.
     * </p>
     * 
     * @return By default, when you create a new associations, the system runs it immediately after it is created and
     *         then according to the schedule you specified. Specify this option if you don't want an association to run
     *         immediately after you create it. This parameter isn't supported for rate expressions.
     */
    public final Boolean applyOnlyAtCronInterval() {
        return applyOnlyAtCronInterval;
    }

    /**
     * For responses, this returns true if the service returned a value for the CalendarNames property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCalendarNames() {
        return calendarNames != null && !(calendarNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated
     * under. The associations only run when that change calendar is open. For more information, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon Web
     * Services Systems Manager Change Calendar</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCalendarNames} method.
     * </p>
     * 
     * @return The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are
     *         gated under. The associations only run when that change calendar is open. For more information, see <a
     *         href
     *         ="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon
     *         Web Services Systems Manager Change Calendar</a>.
     */
    public final List<String> calendarNames() {
        return calendarNames;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetLocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetLocations() {
        return targetLocations != null && !(targetLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
     * association.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetLocations} method.
     * </p>
     * 
     * @return The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
     *         association.
     */
    public final List<TargetLocation> targetLocations() {
        return targetLocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(associationVersion());
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateAssociationDate());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(overview());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(automationTargetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(lastExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastSuccessfulExecutionDate());
        hashCode = 31 * hashCode + Objects.hashCode(associationName());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(complianceSeverityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(syncComplianceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(applyOnlyAtCronInterval());
        hashCode = 31 * hashCode + Objects.hashCode(hasCalendarNames() ? calendarNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetLocations() ? targetLocations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationDescription)) {
            return false;
        }
        AssociationDescription other = (AssociationDescription) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(associationVersion(), other.associationVersion()) && Objects.equals(date(), other.date())
                && Objects.equals(lastUpdateAssociationDate(), other.lastUpdateAssociationDate())
                && Objects.equals(status(), other.status()) && Objects.equals(overview(), other.overview())
                && Objects.equals(documentVersion(), other.documentVersion())
                && Objects.equals(automationTargetParameterName(), other.automationTargetParameterName())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(associationId(), other.associationId()) && hasTargets() == other.hasTargets()
                && Objects.equals(targets(), other.targets()) && Objects.equals(scheduleExpression(), other.scheduleExpression())
                && Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(lastExecutionDate(), other.lastExecutionDate())
                && Objects.equals(lastSuccessfulExecutionDate(), other.lastSuccessfulExecutionDate())
                && Objects.equals(associationName(), other.associationName()) && Objects.equals(maxErrors(), other.maxErrors())
                && Objects.equals(maxConcurrency(), other.maxConcurrency())
                && Objects.equals(complianceSeverityAsString(), other.complianceSeverityAsString())
                && Objects.equals(syncComplianceAsString(), other.syncComplianceAsString())
                && Objects.equals(applyOnlyAtCronInterval(), other.applyOnlyAtCronInterval())
                && hasCalendarNames() == other.hasCalendarNames() && Objects.equals(calendarNames(), other.calendarNames())
                && hasTargetLocations() == other.hasTargetLocations()
                && Objects.equals(targetLocations(), other.targetLocations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociationDescription").add("Name", name()).add("InstanceId", instanceId())
                .add("AssociationVersion", associationVersion()).add("Date", date())
                .add("LastUpdateAssociationDate", lastUpdateAssociationDate()).add("Status", status())
                .add("Overview", overview()).add("DocumentVersion", documentVersion())
                .add("AutomationTargetParameterName", automationTargetParameterName())
                .add("Parameters", parameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AssociationId", associationId()).add("Targets", hasTargets() ? targets() : null)
                .add("ScheduleExpression", scheduleExpression()).add("OutputLocation", outputLocation())
                .add("LastExecutionDate", lastExecutionDate()).add("LastSuccessfulExecutionDate", lastSuccessfulExecutionDate())
                .add("AssociationName", associationName()).add("MaxErrors", maxErrors()).add("MaxConcurrency", maxConcurrency())
                .add("ComplianceSeverity", complianceSeverityAsString()).add("SyncCompliance", syncComplianceAsString())
                .add("ApplyOnlyAtCronInterval", applyOnlyAtCronInterval())
                .add("CalendarNames", hasCalendarNames() ? calendarNames() : null)
                .add("TargetLocations", hasTargetLocations() ? targetLocations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "AssociationVersion":
            return Optional.ofNullable(clazz.cast(associationVersion()));
        case "Date":
            return Optional.ofNullable(clazz.cast(date()));
        case "LastUpdateAssociationDate":
            return Optional.ofNullable(clazz.cast(lastUpdateAssociationDate()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Overview":
            return Optional.ofNullable(clazz.cast(overview()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "AutomationTargetParameterName":
            return Optional.ofNullable(clazz.cast(automationTargetParameterName()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "ScheduleExpression":
            return Optional.ofNullable(clazz.cast(scheduleExpression()));
        case "OutputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "LastExecutionDate":
            return Optional.ofNullable(clazz.cast(lastExecutionDate()));
        case "LastSuccessfulExecutionDate":
            return Optional.ofNullable(clazz.cast(lastSuccessfulExecutionDate()));
        case "AssociationName":
            return Optional.ofNullable(clazz.cast(associationName()));
        case "MaxErrors":
            return Optional.ofNullable(clazz.cast(maxErrors()));
        case "MaxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "ComplianceSeverity":
            return Optional.ofNullable(clazz.cast(complianceSeverityAsString()));
        case "SyncCompliance":
            return Optional.ofNullable(clazz.cast(syncComplianceAsString()));
        case "ApplyOnlyAtCronInterval":
            return Optional.ofNullable(clazz.cast(applyOnlyAtCronInterval()));
        case "CalendarNames":
            return Optional.ofNullable(clazz.cast(calendarNames()));
        case "TargetLocations":
            return Optional.ofNullable(clazz.cast(targetLocations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationDescription, T> g) {
        return obj -> g.apply((AssociationDescription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociationDescription> {
        /**
         * <p>
         * The name of the SSM document.
         * </p>
         * 
         * @param name
         *        The name of the SSM document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The managed node ID.
         * </p>
         * 
         * @param instanceId
         *        The managed node ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The association version.
         * </p>
         * 
         * @param associationVersion
         *        The association version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationVersion(String associationVersion);

        /**
         * <p>
         * The date when the association was made.
         * </p>
         * 
         * @param date
         *        The date when the association was made.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant date);

        /**
         * <p>
         * The date when the association was last updated.
         * </p>
         * 
         * @param lastUpdateAssociationDate
         *        The date when the association was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateAssociationDate(Instant lastUpdateAssociationDate);

        /**
         * <p>
         * The association status.
         * </p>
         * 
         * @param status
         *        The association status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(AssociationStatus status);

        /**
         * <p>
         * The association status.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssociationStatus.Builder} avoiding the
         * need to create one manually via {@link AssociationStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssociationStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(AssociationStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link AssociationStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(AssociationStatus)
         */
        default Builder status(Consumer<AssociationStatus.Builder> status) {
            return status(AssociationStatus.builder().applyMutation(status).build());
        }

        /**
         * <p>
         * Information about the association.
         * </p>
         * 
         * @param overview
         *        Information about the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder overview(AssociationOverview overview);

        /**
         * <p>
         * Information about the association.
         * </p>
         * This is a convenience method that creates an instance of the {@link AssociationOverview.Builder} avoiding the
         * need to create one manually via {@link AssociationOverview#builder()}.
         *
         * When the {@link Consumer} completes, {@link AssociationOverview.Builder#build()} is called immediately and
         * its result is passed to {@link #overview(AssociationOverview)}.
         * 
         * @param overview
         *        a consumer that will call methods on {@link AssociationOverview.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #overview(AssociationOverview)
         */
        default Builder overview(Consumer<AssociationOverview.Builder> overview) {
            return overview(AssociationOverview.builder().applyMutation(overview).build());
        }

        /**
         * <p>
         * The document version.
         * </p>
         * 
         * @param documentVersion
         *        The document version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * Choose the parameter that will define how your automation will branch out. This target is required for
         * associations that use an Automation runbook and target resources by using rate controls. Automation is a
         * capability of Amazon Web Services Systems Manager.
         * </p>
         * 
         * @param automationTargetParameterName
         *        Choose the parameter that will define how your automation will branch out. This target is required for
         *        associations that use an Automation runbook and target resources by using rate controls. Automation is
         *        a capability of Amazon Web Services Systems Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder automationTargetParameterName(String automationTargetParameterName);

        /**
         * <p>
         * A description of the parameters for a document.
         * </p>
         * 
         * @param parameters
         *        A description of the parameters for a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * The association ID.
         * </p>
         * 
         * @param associationId
         *        The association ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The managed nodes targeted by the request.
         * </p>
         * 
         * @param targets
         *        The managed nodes targeted by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * The managed nodes targeted by the request.
         * </p>
         * 
         * @param targets
         *        The managed nodes targeted by the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * The managed nodes targeted by the request.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Target>.Builder} avoiding the need
         * to create one manually via {@link List<Target>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Target>.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<Target>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * A cron expression that specifies a schedule when the association runs.
         * </p>
         * 
         * @param scheduleExpression
         *        A cron expression that specifies a schedule when the association runs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduleExpression(String scheduleExpression);

        /**
         * <p>
         * An S3 bucket where you want to store the output details of the request.
         * </p>
         * 
         * @param outputLocation
         *        An S3 bucket where you want to store the output details of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(InstanceAssociationOutputLocation outputLocation);

        /**
         * <p>
         * An S3 bucket where you want to store the output details of the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link InstanceAssociationOutputLocation.Builder} avoiding the need to create one manually via
         * {@link InstanceAssociationOutputLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link InstanceAssociationOutputLocation.Builder#build()} is called
         * immediately and its result is passed to {@link #outputLocation(InstanceAssociationOutputLocation)}.
         * 
         * @param outputLocation
         *        a consumer that will call methods on {@link InstanceAssociationOutputLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputLocation(InstanceAssociationOutputLocation)
         */
        default Builder outputLocation(Consumer<InstanceAssociationOutputLocation.Builder> outputLocation) {
            return outputLocation(InstanceAssociationOutputLocation.builder().applyMutation(outputLocation).build());
        }

        /**
         * <p>
         * The date on which the association was last run.
         * </p>
         * 
         * @param lastExecutionDate
         *        The date on which the association was last run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastExecutionDate(Instant lastExecutionDate);

        /**
         * <p>
         * The last date on which the association was successfully run.
         * </p>
         * 
         * @param lastSuccessfulExecutionDate
         *        The last date on which the association was successfully run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastSuccessfulExecutionDate(Instant lastSuccessfulExecutionDate);

        /**
         * <p>
         * The association name.
         * </p>
         * 
         * @param associationName
         *        The association name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationName(String associationName);

        /**
         * <p>
         * The number of errors that are allowed before the system stops sending requests to run the association on
         * additional targets. You can specify either an absolute number of errors, for example 10, or a percentage of
         * the target set, for example 10%. If you specify 3, for example, the system stops sending requests when the
         * fourth error is received. If you specify 0, then the system stops sending requests after the first error is
         * returned. If you run an association on 50 managed nodes and set <code>MaxError</code> to 10%, then the system
         * stops sending the request when the sixth error is received.
         * </p>
         * <p>
         * Executions that are already running an association when <code>MaxErrors</code> is reached are allowed to
         * complete, but some of these executions may fail as well. If you need to ensure that there won't be more than
         * max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions proceed one at a time.
         * </p>
         * 
         * @param maxErrors
         *        The number of errors that are allowed before the system stops sending requests to run the association
         *        on additional targets. You can specify either an absolute number of errors, for example 10, or a
         *        percentage of the target set, for example 10%. If you specify 3, for example, the system stops sending
         *        requests when the fourth error is received. If you specify 0, then the system stops sending requests
         *        after the first error is returned. If you run an association on 50 managed nodes and set
         *        <code>MaxError</code> to 10%, then the system stops sending the request when the sixth error is
         *        received.</p>
         *        <p>
         *        Executions that are already running an association when <code>MaxErrors</code> is reached are allowed
         *        to complete, but some of these executions may fail as well. If you need to ensure that there won't be
         *        more than max-errors failed executions, set <code>MaxConcurrency</code> to 1 so that executions
         *        proceed one at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * The maximum number of targets allowed to run the association at the same time. You can specify a number, for
         * example 10, or a percentage of the target set, for example 10%. The default value is 100%, which means all
         * targets run the association at the same time.
         * </p>
         * <p>
         * If a new managed node starts and attempts to run an association while Systems Manager is running
         * <code>MaxConcurrency</code> associations, the association is allowed to run. During the next association
         * interval, the new managed node will process its association within the limit specified for
         * <code>MaxConcurrency</code>.
         * </p>
         * 
         * @param maxConcurrency
         *        The maximum number of targets allowed to run the association at the same time. You can specify a
         *        number, for example 10, or a percentage of the target set, for example 10%. The default value is 100%,
         *        which means all targets run the association at the same time.</p>
         *        <p>
         *        If a new managed node starts and attempts to run an association while Systems Manager is running
         *        <code>MaxConcurrency</code> associations, the association is allowed to run. During the next
         *        association interval, the new managed node will process its association within the limit specified for
         *        <code>MaxConcurrency</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The severity level that is assigned to the association.
         * </p>
         * 
         * @param complianceSeverity
         *        The severity level that is assigned to the association.
         * @see AssociationComplianceSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationComplianceSeverity
         */
        Builder complianceSeverity(String complianceSeverity);

        /**
         * <p>
         * The severity level that is assigned to the association.
         * </p>
         * 
         * @param complianceSeverity
         *        The severity level that is assigned to the association.
         * @see AssociationComplianceSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationComplianceSeverity
         */
        Builder complianceSeverity(AssociationComplianceSeverity complianceSeverity);

        /**
         * <p>
         * The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In
         * <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance
         * status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If
         * the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.
         * </p>
         * <p>
         * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
         * <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager, a
         * capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
         * <a>PutComplianceItems</a> API operation.
         * </p>
         * <p>
         * By default, all associations use <code>AUTO</code> mode.
         * </p>
         * 
         * @param syncCompliance
         *        The mode for generating association compliance. You can specify <code>AUTO</code> or
         *        <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
         *        execution to determine the compliance status. If the association execution runs successfully, then the
         *        association is <code>COMPLIANT</code>. If the association execution doesn't run successfully, the
         *        association is <code>NON-COMPLIANT</code>.</p>
         *        <p>
         *        In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
         *        <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager,
         *        a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
         *        <a>PutComplianceItems</a> API operation.
         *        </p>
         *        <p>
         *        By default, all associations use <code>AUTO</code> mode.
         * @see AssociationSyncCompliance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationSyncCompliance
         */
        Builder syncCompliance(String syncCompliance);

        /**
         * <p>
         * The mode for generating association compliance. You can specify <code>AUTO</code> or <code>MANUAL</code>. In
         * <code>AUTO</code> mode, the system uses the status of the association execution to determine the compliance
         * status. If the association execution runs successfully, then the association is <code>COMPLIANT</code>. If
         * the association execution doesn't run successfully, the association is <code>NON-COMPLIANT</code>.
         * </p>
         * <p>
         * In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
         * <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager, a
         * capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
         * <a>PutComplianceItems</a> API operation.
         * </p>
         * <p>
         * By default, all associations use <code>AUTO</code> mode.
         * </p>
         * 
         * @param syncCompliance
         *        The mode for generating association compliance. You can specify <code>AUTO</code> or
         *        <code>MANUAL</code>. In <code>AUTO</code> mode, the system uses the status of the association
         *        execution to determine the compliance status. If the association execution runs successfully, then the
         *        association is <code>COMPLIANT</code>. If the association execution doesn't run successfully, the
         *        association is <code>NON-COMPLIANT</code>.</p>
         *        <p>
         *        In <code>MANUAL</code> mode, you must specify the <code>AssociationId</code> as a parameter for the
         *        <a>PutComplianceItems</a> API operation. In this case, compliance data isn't managed by State Manager,
         *        a capability of Amazon Web Services Systems Manager. It is managed by your direct call to the
         *        <a>PutComplianceItems</a> API operation.
         *        </p>
         *        <p>
         *        By default, all associations use <code>AUTO</code> mode.
         * @see AssociationSyncCompliance
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationSyncCompliance
         */
        Builder syncCompliance(AssociationSyncCompliance syncCompliance);

        /**
         * <p>
         * By default, when you create a new associations, the system runs it immediately after it is created and then
         * according to the schedule you specified. Specify this option if you don't want an association to run
         * immediately after you create it. This parameter isn't supported for rate expressions.
         * </p>
         * 
         * @param applyOnlyAtCronInterval
         *        By default, when you create a new associations, the system runs it immediately after it is created and
         *        then according to the schedule you specified. Specify this option if you don't want an association to
         *        run immediately after you create it. This parameter isn't supported for rate expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval);

        /**
         * <p>
         * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated
         * under. The associations only run when that change calendar is open. For more information, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon
         * Web Services Systems Manager Change Calendar</a>.
         * </p>
         * 
         * @param calendarNames
         *        The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are
         *        gated under. The associations only run when that change calendar is open. For more information, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">
         *        Amazon Web Services Systems Manager Change Calendar</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calendarNames(Collection<String> calendarNames);

        /**
         * <p>
         * The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are gated
         * under. The associations only run when that change calendar is open. For more information, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">Amazon
         * Web Services Systems Manager Change Calendar</a>.
         * </p>
         * 
         * @param calendarNames
         *        The names or Amazon Resource Names (ARNs) of the Change Calendar type documents your associations are
         *        gated under. The associations only run when that change calendar is open. For more information, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar">
         *        Amazon Web Services Systems Manager Change Calendar</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder calendarNames(String... calendarNames);

        /**
         * <p>
         * The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
         * association.
         * </p>
         * 
         * @param targetLocations
         *        The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run
         *        the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocations(Collection<TargetLocation> targetLocations);

        /**
         * <p>
         * The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
         * association.
         * </p>
         * 
         * @param targetLocations
         *        The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run
         *        the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocations(TargetLocation... targetLocations);

        /**
         * <p>
         * The combination of Amazon Web Services Regions and Amazon Web Services accounts where you want to run the
         * association.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TargetLocation>.Builder} avoiding
         * the need to create one manually via {@link List<TargetLocation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetLocation>.Builder#build()} is called immediately and
         * its result is passed to {@link #targetLocations(List<TargetLocation>)}.
         * 
         * @param targetLocations
         *        a consumer that will call methods on {@link List<TargetLocation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetLocations(List<TargetLocation>)
         */
        Builder targetLocations(Consumer<TargetLocation.Builder>... targetLocations);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String instanceId;

        private String associationVersion;

        private Instant date;

        private Instant lastUpdateAssociationDate;

        private AssociationStatus status;

        private AssociationOverview overview;

        private String documentVersion;

        private String automationTargetParameterName;

        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String associationId;

        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private String scheduleExpression;

        private InstanceAssociationOutputLocation outputLocation;

        private Instant lastExecutionDate;

        private Instant lastSuccessfulExecutionDate;

        private String associationName;

        private String maxErrors;

        private String maxConcurrency;

        private String complianceSeverity;

        private String syncCompliance;

        private Boolean applyOnlyAtCronInterval;

        private List<String> calendarNames = DefaultSdkAutoConstructList.getInstance();

        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationDescription model) {
            name(model.name);
            instanceId(model.instanceId);
            associationVersion(model.associationVersion);
            date(model.date);
            lastUpdateAssociationDate(model.lastUpdateAssociationDate);
            status(model.status);
            overview(model.overview);
            documentVersion(model.documentVersion);
            automationTargetParameterName(model.automationTargetParameterName);
            parameters(model.parameters);
            associationId(model.associationId);
            targets(model.targets);
            scheduleExpression(model.scheduleExpression);
            outputLocation(model.outputLocation);
            lastExecutionDate(model.lastExecutionDate);
            lastSuccessfulExecutionDate(model.lastSuccessfulExecutionDate);
            associationName(model.associationName);
            maxErrors(model.maxErrors);
            maxConcurrency(model.maxConcurrency);
            complianceSeverity(model.complianceSeverity);
            syncCompliance(model.syncCompliance);
            applyOnlyAtCronInterval(model.applyOnlyAtCronInterval);
            calendarNames(model.calendarNames);
            targetLocations(model.targetLocations);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getAssociationVersion() {
            return associationVersion;
        }

        public final void setAssociationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
        }

        @Override
        @Transient
        public final Builder associationVersion(String associationVersion) {
            this.associationVersion = associationVersion;
            return this;
        }

        public final Instant getDate() {
            return date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        @Transient
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final Instant getLastUpdateAssociationDate() {
            return lastUpdateAssociationDate;
        }

        public final void setLastUpdateAssociationDate(Instant lastUpdateAssociationDate) {
            this.lastUpdateAssociationDate = lastUpdateAssociationDate;
        }

        @Override
        @Transient
        public final Builder lastUpdateAssociationDate(Instant lastUpdateAssociationDate) {
            this.lastUpdateAssociationDate = lastUpdateAssociationDate;
            return this;
        }

        public final AssociationStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        public final void setStatus(AssociationStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        @Transient
        public final Builder status(AssociationStatus status) {
            this.status = status;
            return this;
        }

        public final AssociationOverview.Builder getOverview() {
            return overview != null ? overview.toBuilder() : null;
        }

        public final void setOverview(AssociationOverview.BuilderImpl overview) {
            this.overview = overview != null ? overview.build() : null;
        }

        @Override
        @Transient
        public final Builder overview(AssociationOverview overview) {
            this.overview = overview;
            return this;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        @Transient
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final String getAutomationTargetParameterName() {
            return automationTargetParameterName;
        }

        public final void setAutomationTargetParameterName(String automationTargetParameterName) {
            this.automationTargetParameterName = automationTargetParameterName;
        }

        @Override
        @Transient
        public final Builder automationTargetParameterName(String automationTargetParameterName) {
            this.automationTargetParameterName = automationTargetParameterName;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
        }

        @Override
        @Transient
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        @Transient
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        @Transient
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getScheduleExpression() {
            return scheduleExpression;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        @Override
        @Transient
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final InstanceAssociationOutputLocation.Builder getOutputLocation() {
            return outputLocation != null ? outputLocation.toBuilder() : null;
        }

        public final void setOutputLocation(InstanceAssociationOutputLocation.BuilderImpl outputLocation) {
            this.outputLocation = outputLocation != null ? outputLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder outputLocation(InstanceAssociationOutputLocation outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final Instant getLastExecutionDate() {
            return lastExecutionDate;
        }

        public final void setLastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
        }

        @Override
        @Transient
        public final Builder lastExecutionDate(Instant lastExecutionDate) {
            this.lastExecutionDate = lastExecutionDate;
            return this;
        }

        public final Instant getLastSuccessfulExecutionDate() {
            return lastSuccessfulExecutionDate;
        }

        public final void setLastSuccessfulExecutionDate(Instant lastSuccessfulExecutionDate) {
            this.lastSuccessfulExecutionDate = lastSuccessfulExecutionDate;
        }

        @Override
        @Transient
        public final Builder lastSuccessfulExecutionDate(Instant lastSuccessfulExecutionDate) {
            this.lastSuccessfulExecutionDate = lastSuccessfulExecutionDate;
            return this;
        }

        public final String getAssociationName() {
            return associationName;
        }

        public final void setAssociationName(String associationName) {
            this.associationName = associationName;
        }

        @Override
        @Transient
        public final Builder associationName(String associationName) {
            this.associationName = associationName;
            return this;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        @Transient
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        @Transient
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getComplianceSeverity() {
            return complianceSeverity;
        }

        public final void setComplianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
        }

        @Override
        @Transient
        public final Builder complianceSeverity(String complianceSeverity) {
            this.complianceSeverity = complianceSeverity;
            return this;
        }

        @Override
        @Transient
        public final Builder complianceSeverity(AssociationComplianceSeverity complianceSeverity) {
            this.complianceSeverity(complianceSeverity == null ? null : complianceSeverity.toString());
            return this;
        }

        public final String getSyncCompliance() {
            return syncCompliance;
        }

        public final void setSyncCompliance(String syncCompliance) {
            this.syncCompliance = syncCompliance;
        }

        @Override
        @Transient
        public final Builder syncCompliance(String syncCompliance) {
            this.syncCompliance = syncCompliance;
            return this;
        }

        @Override
        @Transient
        public final Builder syncCompliance(AssociationSyncCompliance syncCompliance) {
            this.syncCompliance(syncCompliance == null ? null : syncCompliance.toString());
            return this;
        }

        public final Boolean getApplyOnlyAtCronInterval() {
            return applyOnlyAtCronInterval;
        }

        public final void setApplyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
        }

        @Override
        @Transient
        public final Builder applyOnlyAtCronInterval(Boolean applyOnlyAtCronInterval) {
            this.applyOnlyAtCronInterval = applyOnlyAtCronInterval;
            return this;
        }

        public final Collection<String> getCalendarNames() {
            if (calendarNames instanceof SdkAutoConstructList) {
                return null;
            }
            return calendarNames;
        }

        public final void setCalendarNames(Collection<String> calendarNames) {
            this.calendarNames = CalendarNameOrARNListCopier.copy(calendarNames);
        }

        @Override
        @Transient
        public final Builder calendarNames(Collection<String> calendarNames) {
            this.calendarNames = CalendarNameOrARNListCopier.copy(calendarNames);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder calendarNames(String... calendarNames) {
            calendarNames(Arrays.asList(calendarNames));
            return this;
        }

        public final List<TargetLocation.Builder> getTargetLocations() {
            List<TargetLocation.Builder> result = TargetLocationsCopier.copyToBuilder(this.targetLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        @Override
        @Transient
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetLocations(TargetLocation... targetLocations) {
            targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder>... targetLocations) {
            targetLocations(Stream.of(targetLocations).map(c -> TargetLocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public AssociationDescription build() {
            return new AssociationDescription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
