/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAssociationExecutionTargetsRequest extends SsmRequest implements
        ToCopyableBuilder<DescribeAssociationExecutionTargetsRequest.Builder, DescribeAssociationExecutionTargetsRequest> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssociationId").getter(getter(DescribeAssociationExecutionTargetsRequest::associationId))
            .setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionId").getter(getter(DescribeAssociationExecutionTargetsRequest::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()).build();

    private static final SdkField<List<AssociationExecutionTargetsFilter>> FILTERS_FIELD = SdkField
            .<List<AssociationExecutionTargetsFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(DescribeAssociationExecutionTargetsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AssociationExecutionTargetsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociationExecutionTargetsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(DescribeAssociationExecutionTargetsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAssociationExecutionTargetsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            EXECUTION_ID_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private final String associationId;

    private final String executionId;

    private final List<AssociationExecutionTargetsFilter> filters;

    private final Integer maxResults;

    private final String nextToken;

    private DescribeAssociationExecutionTargetsRequest(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.executionId = builder.executionId;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The association ID that includes the execution for which you want to view details.
     * </p>
     * 
     * @return The association ID that includes the execution for which you want to view details.
     */
    public final String associationId() {
        return associationId;
    }

    /**
     * <p>
     * The execution ID for which you want to view details.
     * </p>
     * 
     * @return The execution ID for which you want to view details.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters for the request. You can specify the following filters and values.
     * </p>
     * <p>
     * Status (EQUAL)
     * </p>
     * <p>
     * ResourceId (EQUAL)
     * </p>
     * <p>
     * ResourceType (EQUAL)
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Filters for the request. You can specify the following filters and values.</p>
     *         <p>
     *         Status (EQUAL)
     *         </p>
     *         <p>
     *         ResourceId (EQUAL)
     *         </p>
     *         <p>
     *         ResourceType (EQUAL)
     */
    public final List<AssociationExecutionTargetsFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A token to start the list. Use this token to get the next set of results.
     * </p>
     * 
     * @return A token to start the list. Use this token to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssociationExecutionTargetsRequest)) {
            return false;
        }
        DescribeAssociationExecutionTargetsRequest other = (DescribeAssociationExecutionTargetsRequest) obj;
        return Objects.equals(associationId(), other.associationId()) && Objects.equals(executionId(), other.executionId())
                && hasFilters() == other.hasFilters() && Objects.equals(filters(), other.filters())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAssociationExecutionTargetsRequest").add("AssociationId", associationId())
                .add("ExecutionId", executionId()).add("Filters", hasFilters() ? filters() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "ExecutionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssociationExecutionTargetsRequest, T> g) {
        return obj -> g.apply((DescribeAssociationExecutionTargetsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAssociationExecutionTargetsRequest> {
        /**
         * <p>
         * The association ID that includes the execution for which you want to view details.
         * </p>
         * 
         * @param associationId
         *        The association ID that includes the execution for which you want to view details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The execution ID for which you want to view details.
         * </p>
         * 
         * @param executionId
         *        The execution ID for which you want to view details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * Filters for the request. You can specify the following filters and values.
         * </p>
         * <p>
         * Status (EQUAL)
         * </p>
         * <p>
         * ResourceId (EQUAL)
         * </p>
         * <p>
         * ResourceType (EQUAL)
         * </p>
         * 
         * @param filters
         *        Filters for the request. You can specify the following filters and values.</p>
         *        <p>
         *        Status (EQUAL)
         *        </p>
         *        <p>
         *        ResourceId (EQUAL)
         *        </p>
         *        <p>
         *        ResourceType (EQUAL)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<AssociationExecutionTargetsFilter> filters);

        /**
         * <p>
         * Filters for the request. You can specify the following filters and values.
         * </p>
         * <p>
         * Status (EQUAL)
         * </p>
         * <p>
         * ResourceId (EQUAL)
         * </p>
         * <p>
         * ResourceType (EQUAL)
         * </p>
         * 
         * @param filters
         *        Filters for the request. You can specify the following filters and values.</p>
         *        <p>
         *        Status (EQUAL)
         *        </p>
         *        <p>
         *        ResourceId (EQUAL)
         *        </p>
         *        <p>
         *        ResourceType (EQUAL)
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(AssociationExecutionTargetsFilter... filters);

        /**
         * <p>
         * Filters for the request. You can specify the following filters and values.
         * </p>
         * <p>
         * Status (EQUAL)
         * </p>
         * <p>
         * ResourceId (EQUAL)
         * </p>
         * <p>
         * ResourceType (EQUAL)
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <AssociationExecutionTargetsFilter>.Builder} avoiding the need to create one manually via {@link List
         * <AssociationExecutionTargetsFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AssociationExecutionTargetsFilter>.Builder#build()} is
         * called immediately and its result is passed to {@link #filters(List<AssociationExecutionTargetsFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<AssociationExecutionTargetsFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<AssociationExecutionTargetsFilter>)
         */
        Builder filters(Consumer<AssociationExecutionTargetsFilter.Builder>... filters);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A token to start the list. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token to start the list. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String associationId;

        private String executionId;

        private List<AssociationExecutionTargetsFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssociationExecutionTargetsRequest model) {
            super(model);
            associationId(model.associationId);
            executionId(model.executionId);
            filters(model.filters);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAssociationId() {
            return associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        @Transient
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        @Transient
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final List<AssociationExecutionTargetsFilter.Builder> getFilters() {
            List<AssociationExecutionTargetsFilter.Builder> result = AssociationExecutionTargetsFilterListCopier
                    .copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<AssociationExecutionTargetsFilter.BuilderImpl> filters) {
            this.filters = AssociationExecutionTargetsFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<AssociationExecutionTargetsFilter> filters) {
            this.filters = AssociationExecutionTargetsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(AssociationExecutionTargetsFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<AssociationExecutionTargetsFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> AssociationExecutionTargetsFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeAssociationExecutionTargetsRequest build() {
            return new DescribeAssociationExecutionTargetsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
