/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAvailablePatchesResponse extends SsmResponse implements
        ToCopyableBuilder<DescribeAvailablePatchesResponse.Builder, DescribeAvailablePatchesResponse> {
    private static final SdkField<List<Patch>> PATCHES_FIELD = SdkField
            .<List<Patch>> builder(MarshallingType.LIST)
            .memberName("Patches")
            .getter(getter(DescribeAvailablePatchesResponse::patches))
            .setter(setter(Builder::patches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Patches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Patch> builder(MarshallingType.SDK_POJO)
                                            .constructor(Patch::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeAvailablePatchesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCHES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<Patch> patches;

    private final String nextToken;

    private DescribeAvailablePatchesResponse(BuilderImpl builder) {
        super(builder);
        this.patches = builder.patches;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Patches property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPatches() {
        return patches != null && !(patches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of patches. Each entry in the array is a patch structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPatches} method.
     * </p>
     * 
     * @return An array of patches. Each entry in the array is a patch structure.
     */
    public final List<Patch> patches() {
        return patches;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPatches() ? patches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailablePatchesResponse)) {
            return false;
        }
        DescribeAvailablePatchesResponse other = (DescribeAvailablePatchesResponse) obj;
        return hasPatches() == other.hasPatches() && Objects.equals(patches(), other.patches())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAvailablePatchesResponse").add("Patches", hasPatches() ? patches() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Patches":
            return Optional.ofNullable(clazz.cast(patches()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAvailablePatchesResponse, T> g) {
        return obj -> g.apply((DescribeAvailablePatchesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAvailablePatchesResponse> {
        /**
         * <p>
         * An array of patches. Each entry in the array is a patch structure.
         * </p>
         * 
         * @param patches
         *        An array of patches. Each entry in the array is a patch structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patches(Collection<Patch> patches);

        /**
         * <p>
         * An array of patches. Each entry in the array is a patch structure.
         * </p>
         * 
         * @param patches
         *        An array of patches. Each entry in the array is a patch structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patches(Patch... patches);

        /**
         * <p>
         * An array of patches. Each entry in the array is a patch structure.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Patch>.Builder} avoiding the need to
         * create one manually via {@link List<Patch>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Patch>.Builder#build()} is called immediately and its result
         * is passed to {@link #patches(List<Patch>)}.
         * 
         * @param patches
         *        a consumer that will call methods on {@link List<Patch>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patches(List<Patch>)
         */
        Builder patches(Consumer<Patch.Builder>... patches);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<Patch> patches = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailablePatchesResponse model) {
            super(model);
            patches(model.patches);
            nextToken(model.nextToken);
        }

        public final List<Patch.Builder> getPatches() {
            List<Patch.Builder> result = PatchListCopier.copyToBuilder(this.patches);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPatches(Collection<Patch.BuilderImpl> patches) {
            this.patches = PatchListCopier.copyFromBuilder(patches);
        }

        @Override
        @Transient
        public final Builder patches(Collection<Patch> patches) {
            this.patches = PatchListCopier.copy(patches);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder patches(Patch... patches) {
            patches(Arrays.asList(patches));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder patches(Consumer<Patch.Builder>... patches) {
            patches(Stream.of(patches).map(c -> Patch.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAvailablePatchesResponse build() {
            return new DescribeAvailablePatchesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
