/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetOpsSummaryRequest extends SsmRequest implements
        ToCopyableBuilder<GetOpsSummaryRequest.Builder, GetOpsSummaryRequest> {
    private static final SdkField<String> SYNC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SyncName").getter(getter(GetOpsSummaryRequest::syncName)).setter(setter(Builder::syncName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SyncName").build()).build();

    private static final SdkField<List<OpsFilter>> FILTERS_FIELD = SdkField
            .<List<OpsFilter>> builder(MarshallingType.LIST)
            .memberName("Filters")
            .getter(getter(GetOpsSummaryRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OpsAggregator>> AGGREGATORS_FIELD = SdkField
            .<List<OpsAggregator>> builder(MarshallingType.LIST)
            .memberName("Aggregators")
            .getter(getter(GetOpsSummaryRequest::aggregators))
            .setter(setter(Builder::aggregators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Aggregators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsAggregator> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsAggregator::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OpsResultAttribute>> RESULT_ATTRIBUTES_FIELD = SdkField
            .<List<OpsResultAttribute>> builder(MarshallingType.LIST)
            .memberName("ResultAttributes")
            .getter(getter(GetOpsSummaryRequest::resultAttributes))
            .setter(setter(Builder::resultAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpsResultAttribute> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpsResultAttribute::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetOpsSummaryRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetOpsSummaryRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNC_NAME_FIELD,
            FILTERS_FIELD, AGGREGATORS_FIELD, RESULT_ATTRIBUTES_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String syncName;

    private final List<OpsFilter> filters;

    private final List<OpsAggregator> aggregators;

    private final List<OpsResultAttribute> resultAttributes;

    private final String nextToken;

    private final Integer maxResults;

    private GetOpsSummaryRequest(BuilderImpl builder) {
        super(builder);
        this.syncName = builder.syncName;
        this.filters = builder.filters;
        this.aggregators = builder.aggregators;
        this.resultAttributes = builder.resultAttributes;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * Specify the name of a resource data sync to get.
     * </p>
     * 
     * @return Specify the name of a resource data sync to get.
     */
    public final String syncName() {
        return syncName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Filters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional filters used to scope down the returned OpsData.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFilters} method.
     * </p>
     * 
     * @return Optional filters used to scope down the returned OpsData.
     */
    public final List<OpsFilter> filters() {
        return filters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Aggregators property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAggregators() {
        return aggregators != null && !(aggregators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional aggregators that return counts of OpsData based on one or more expressions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAggregators} method.
     * </p>
     * 
     * @return Optional aggregators that return counts of OpsData based on one or more expressions.
     */
    public final List<OpsAggregator> aggregators() {
        return aggregators;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResultAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResultAttributes() {
        return resultAttributes != null && !(resultAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The OpsData data type to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResultAttributes} method.
     * </p>
     * 
     * @return The OpsData data type to return.
     */
    public final List<OpsResultAttribute> resultAttributes() {
        return resultAttributes;
    }

    /**
     * <p>
     * A token to start the list. Use this token to get the next set of results.
     * </p>
     * 
     * @return A token to start the list. Use this token to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of items to return for this call. The call also returns a token that you can specify in a
     * subsequent call to get the next set of results.
     * </p>
     * 
     * @return The maximum number of items to return for this call. The call also returns a token that you can specify
     *         in a subsequent call to get the next set of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(syncName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFilters() ? filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAggregators() ? aggregators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasResultAttributes() ? resultAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetOpsSummaryRequest)) {
            return false;
        }
        GetOpsSummaryRequest other = (GetOpsSummaryRequest) obj;
        return Objects.equals(syncName(), other.syncName()) && hasFilters() == other.hasFilters()
                && Objects.equals(filters(), other.filters()) && hasAggregators() == other.hasAggregators()
                && Objects.equals(aggregators(), other.aggregators()) && hasResultAttributes() == other.hasResultAttributes()
                && Objects.equals(resultAttributes(), other.resultAttributes()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetOpsSummaryRequest").add("SyncName", syncName())
                .add("Filters", hasFilters() ? filters() : null).add("Aggregators", hasAggregators() ? aggregators() : null)
                .add("ResultAttributes", hasResultAttributes() ? resultAttributes() : null).add("NextToken", nextToken())
                .add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SyncName":
            return Optional.ofNullable(clazz.cast(syncName()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Aggregators":
            return Optional.ofNullable(clazz.cast(aggregators()));
        case "ResultAttributes":
            return Optional.ofNullable(clazz.cast(resultAttributes()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetOpsSummaryRequest, T> g) {
        return obj -> g.apply((GetOpsSummaryRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetOpsSummaryRequest> {
        /**
         * <p>
         * Specify the name of a resource data sync to get.
         * </p>
         * 
         * @param syncName
         *        Specify the name of a resource data sync to get.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncName(String syncName);

        /**
         * <p>
         * Optional filters used to scope down the returned OpsData.
         * </p>
         * 
         * @param filters
         *        Optional filters used to scope down the returned OpsData.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<OpsFilter> filters);

        /**
         * <p>
         * Optional filters used to scope down the returned OpsData.
         * </p>
         * 
         * @param filters
         *        Optional filters used to scope down the returned OpsData.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(OpsFilter... filters);

        /**
         * <p>
         * Optional filters used to scope down the returned OpsData.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<OpsFilter>.Builder} avoiding the
         * need to create one manually via {@link List<OpsFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OpsFilter>.Builder#build()} is called immediately and its
         * result is passed to {@link #filters(List<OpsFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<OpsFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<OpsFilter>)
         */
        Builder filters(Consumer<OpsFilter.Builder>... filters);

        /**
         * <p>
         * Optional aggregators that return counts of OpsData based on one or more expressions.
         * </p>
         * 
         * @param aggregators
         *        Optional aggregators that return counts of OpsData based on one or more expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(Collection<OpsAggregator> aggregators);

        /**
         * <p>
         * Optional aggregators that return counts of OpsData based on one or more expressions.
         * </p>
         * 
         * @param aggregators
         *        Optional aggregators that return counts of OpsData based on one or more expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aggregators(OpsAggregator... aggregators);

        /**
         * <p>
         * Optional aggregators that return counts of OpsData based on one or more expressions.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<OpsAggregator>.Builder} avoiding the
         * need to create one manually via {@link List<OpsAggregator>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OpsAggregator>.Builder#build()} is called immediately and
         * its result is passed to {@link #aggregators(List<OpsAggregator>)}.
         * 
         * @param aggregators
         *        a consumer that will call methods on {@link List<OpsAggregator>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #aggregators(List<OpsAggregator>)
         */
        Builder aggregators(Consumer<OpsAggregator.Builder>... aggregators);

        /**
         * <p>
         * The OpsData data type to return.
         * </p>
         * 
         * @param resultAttributes
         *        The OpsData data type to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultAttributes(Collection<OpsResultAttribute> resultAttributes);

        /**
         * <p>
         * The OpsData data type to return.
         * </p>
         * 
         * @param resultAttributes
         *        The OpsData data type to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resultAttributes(OpsResultAttribute... resultAttributes);

        /**
         * <p>
         * The OpsData data type to return.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<OpsResultAttribute>.Builder}
         * avoiding the need to create one manually via {@link List<OpsResultAttribute>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<OpsResultAttribute>.Builder#build()} is called immediately
         * and its result is passed to {@link #resultAttributes(List<OpsResultAttribute>)}.
         * 
         * @param resultAttributes
         *        a consumer that will call methods on {@link List<OpsResultAttribute>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resultAttributes(List<OpsResultAttribute>)
         */
        Builder resultAttributes(Consumer<OpsResultAttribute.Builder>... resultAttributes);

        /**
         * <p>
         * A token to start the list. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        A token to start the list. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of items to return for this call. The call also returns a token that you can specify in a
         * subsequent call to get the next set of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to return for this call. The call also returns a token that you can
         *        specify in a subsequent call to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String syncName;

        private List<OpsFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private List<OpsAggregator> aggregators = DefaultSdkAutoConstructList.getInstance();

        private List<OpsResultAttribute> resultAttributes = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetOpsSummaryRequest model) {
            super(model);
            syncName(model.syncName);
            filters(model.filters);
            aggregators(model.aggregators);
            resultAttributes(model.resultAttributes);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getSyncName() {
            return syncName;
        }

        public final void setSyncName(String syncName) {
            this.syncName = syncName;
        }

        @Override
        @Transient
        public final Builder syncName(String syncName) {
            this.syncName = syncName;
            return this;
        }

        public final List<OpsFilter.Builder> getFilters() {
            List<OpsFilter.Builder> result = OpsFilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<OpsFilter.BuilderImpl> filters) {
            this.filters = OpsFilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<OpsFilter> filters) {
            this.filters = OpsFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(OpsFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<OpsFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> OpsFilter.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OpsAggregator.Builder> getAggregators() {
            List<OpsAggregator.Builder> result = OpsAggregatorListCopier.copyToBuilder(this.aggregators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregators(Collection<OpsAggregator.BuilderImpl> aggregators) {
            this.aggregators = OpsAggregatorListCopier.copyFromBuilder(aggregators);
        }

        @Override
        @Transient
        public final Builder aggregators(Collection<OpsAggregator> aggregators) {
            this.aggregators = OpsAggregatorListCopier.copy(aggregators);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder aggregators(OpsAggregator... aggregators) {
            aggregators(Arrays.asList(aggregators));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder aggregators(Consumer<OpsAggregator.Builder>... aggregators) {
            aggregators(Stream.of(aggregators).map(c -> OpsAggregator.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OpsResultAttribute.Builder> getResultAttributes() {
            List<OpsResultAttribute.Builder> result = OpsResultAttributeListCopier.copyToBuilder(this.resultAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResultAttributes(Collection<OpsResultAttribute.BuilderImpl> resultAttributes) {
            this.resultAttributes = OpsResultAttributeListCopier.copyFromBuilder(resultAttributes);
        }

        @Override
        @Transient
        public final Builder resultAttributes(Collection<OpsResultAttribute> resultAttributes) {
            this.resultAttributes = OpsResultAttributeListCopier.copy(resultAttributes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resultAttributes(OpsResultAttribute... resultAttributes) {
            resultAttributes(Arrays.asList(resultAttributes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resultAttributes(Consumer<OpsResultAttribute.Builder>... resultAttributes) {
            resultAttributes(Stream.of(resultAttributes).map(c -> OpsResultAttribute.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetOpsSummaryRequest build() {
            return new GetOpsSummaryRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
