/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceComplianceSummariesResponse extends SsmResponse implements
        ToCopyableBuilder<ListResourceComplianceSummariesResponse.Builder, ListResourceComplianceSummariesResponse> {
    private static final SdkField<List<ResourceComplianceSummaryItem>> RESOURCE_COMPLIANCE_SUMMARY_ITEMS_FIELD = SdkField
            .<List<ResourceComplianceSummaryItem>> builder(MarshallingType.LIST)
            .memberName("ResourceComplianceSummaryItems")
            .getter(getter(ListResourceComplianceSummariesResponse::resourceComplianceSummaryItems))
            .setter(setter(Builder::resourceComplianceSummaryItems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceComplianceSummaryItems")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceComplianceSummaryItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceComplianceSummaryItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceComplianceSummariesResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESOURCE_COMPLIANCE_SUMMARY_ITEMS_FIELD, NEXT_TOKEN_FIELD));

    private final List<ResourceComplianceSummaryItem> resourceComplianceSummaryItems;

    private final String nextToken;

    private ListResourceComplianceSummariesResponse(BuilderImpl builder) {
        super(builder);
        this.resourceComplianceSummaryItems = builder.resourceComplianceSummaryItems;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceComplianceSummaryItems property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResourceComplianceSummaryItems() {
        return resourceComplianceSummaryItems != null && !(resourceComplianceSummaryItems instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A summary count for specified or targeted managed nodes. Summary count includes information about compliant and
     * non-compliant State Manager associations, patch status, or custom items according to the filter criteria that you
     * specify.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceComplianceSummaryItems} method.
     * </p>
     * 
     * @return A summary count for specified or targeted managed nodes. Summary count includes information about
     *         compliant and non-compliant State Manager associations, patch status, or custom items according to the
     *         filter criteria that you specify.
     */
    public final List<ResourceComplianceSummaryItem> resourceComplianceSummaryItems() {
        return resourceComplianceSummaryItems;
    }

    /**
     * <p>
     * The token for the next set of items to return. Use this token to get the next set of results.
     * </p>
     * 
     * @return The token for the next set of items to return. Use this token to get the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasResourceComplianceSummaryItems() ? resourceComplianceSummaryItems() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceComplianceSummariesResponse)) {
            return false;
        }
        ListResourceComplianceSummariesResponse other = (ListResourceComplianceSummariesResponse) obj;
        return hasResourceComplianceSummaryItems() == other.hasResourceComplianceSummaryItems()
                && Objects.equals(resourceComplianceSummaryItems(), other.resourceComplianceSummaryItems())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListResourceComplianceSummariesResponse")
                .add("ResourceComplianceSummaryItems",
                        hasResourceComplianceSummaryItems() ? resourceComplianceSummaryItems() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceComplianceSummaryItems":
            return Optional.ofNullable(clazz.cast(resourceComplianceSummaryItems()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListResourceComplianceSummariesResponse, T> g) {
        return obj -> g.apply((ListResourceComplianceSummariesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceComplianceSummariesResponse> {
        /**
         * <p>
         * A summary count for specified or targeted managed nodes. Summary count includes information about compliant
         * and non-compliant State Manager associations, patch status, or custom items according to the filter criteria
         * that you specify.
         * </p>
         * 
         * @param resourceComplianceSummaryItems
         *        A summary count for specified or targeted managed nodes. Summary count includes information about
         *        compliant and non-compliant State Manager associations, patch status, or custom items according to the
         *        filter criteria that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceComplianceSummaryItems(Collection<ResourceComplianceSummaryItem> resourceComplianceSummaryItems);

        /**
         * <p>
         * A summary count for specified or targeted managed nodes. Summary count includes information about compliant
         * and non-compliant State Manager associations, patch status, or custom items according to the filter criteria
         * that you specify.
         * </p>
         * 
         * @param resourceComplianceSummaryItems
         *        A summary count for specified or targeted managed nodes. Summary count includes information about
         *        compliant and non-compliant State Manager associations, patch status, or custom items according to the
         *        filter criteria that you specify.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceComplianceSummaryItems(ResourceComplianceSummaryItem... resourceComplianceSummaryItems);

        /**
         * <p>
         * A summary count for specified or targeted managed nodes. Summary count includes information about compliant
         * and non-compliant State Manager associations, patch status, or custom items according to the filter criteria
         * that you specify.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <ResourceComplianceSummaryItem>.Builder} avoiding the need to create one manually via {@link List
         * <ResourceComplianceSummaryItem>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourceComplianceSummaryItem>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #resourceComplianceSummaryItems(List<ResourceComplianceSummaryItem>)}.
         * 
         * @param resourceComplianceSummaryItems
         *        a consumer that will call methods on {@link List<ResourceComplianceSummaryItem>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceComplianceSummaryItems(List<ResourceComplianceSummaryItem>)
         */
        Builder resourceComplianceSummaryItems(Consumer<ResourceComplianceSummaryItem.Builder>... resourceComplianceSummaryItems);

        /**
         * <p>
         * The token for the next set of items to return. Use this token to get the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of items to return. Use this token to get the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<ResourceComplianceSummaryItem> resourceComplianceSummaryItems = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceComplianceSummariesResponse model) {
            super(model);
            resourceComplianceSummaryItems(model.resourceComplianceSummaryItems);
            nextToken(model.nextToken);
        }

        public final List<ResourceComplianceSummaryItem.Builder> getResourceComplianceSummaryItems() {
            List<ResourceComplianceSummaryItem.Builder> result = ResourceComplianceSummaryItemListCopier
                    .copyToBuilder(this.resourceComplianceSummaryItems);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceComplianceSummaryItems(
                Collection<ResourceComplianceSummaryItem.BuilderImpl> resourceComplianceSummaryItems) {
            this.resourceComplianceSummaryItems = ResourceComplianceSummaryItemListCopier
                    .copyFromBuilder(resourceComplianceSummaryItems);
        }

        @Override
        @Transient
        public final Builder resourceComplianceSummaryItems(
                Collection<ResourceComplianceSummaryItem> resourceComplianceSummaryItems) {
            this.resourceComplianceSummaryItems = ResourceComplianceSummaryItemListCopier.copy(resourceComplianceSummaryItems);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceComplianceSummaryItems(ResourceComplianceSummaryItem... resourceComplianceSummaryItems) {
            resourceComplianceSummaryItems(Arrays.asList(resourceComplianceSummaryItems));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resourceComplianceSummaryItems(
                Consumer<ResourceComplianceSummaryItem.Builder>... resourceComplianceSummaryItems) {
            resourceComplianceSummaryItems(Stream.of(resourceComplianceSummaryItems)
                    .map(c -> ResourceComplianceSummaryItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListResourceComplianceSummariesResponse build() {
            return new ListResourceComplianceSummariesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
