/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of rules defining the approval rules for a patch baseline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PatchRuleGroup implements SdkPojo, Serializable, ToCopyableBuilder<PatchRuleGroup.Builder, PatchRuleGroup> {
    private static final SdkField<List<PatchRule>> PATCH_RULES_FIELD = SdkField
            .<List<PatchRule>> builder(MarshallingType.LIST)
            .memberName("PatchRules")
            .getter(getter(PatchRuleGroup::patchRules))
            .setter(setter(Builder::patchRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PatchRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PatchRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(PatchRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATCH_RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PatchRule> patchRules;

    private PatchRuleGroup(BuilderImpl builder) {
        this.patchRules = builder.patchRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the PatchRules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasPatchRules() {
        return patchRules != null && !(patchRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The rules that make up the rule group.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPatchRules} method.
     * </p>
     * 
     * @return The rules that make up the rule group.
     */
    public final List<PatchRule> patchRules() {
        return patchRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasPatchRules() ? patchRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PatchRuleGroup)) {
            return false;
        }
        PatchRuleGroup other = (PatchRuleGroup) obj;
        return hasPatchRules() == other.hasPatchRules() && Objects.equals(patchRules(), other.patchRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PatchRuleGroup").add("PatchRules", hasPatchRules() ? patchRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PatchRules":
            return Optional.ofNullable(clazz.cast(patchRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PatchRuleGroup, T> g) {
        return obj -> g.apply((PatchRuleGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PatchRuleGroup> {
        /**
         * <p>
         * The rules that make up the rule group.
         * </p>
         * 
         * @param patchRules
         *        The rules that make up the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchRules(Collection<PatchRule> patchRules);

        /**
         * <p>
         * The rules that make up the rule group.
         * </p>
         * 
         * @param patchRules
         *        The rules that make up the rule group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder patchRules(PatchRule... patchRules);

        /**
         * <p>
         * The rules that make up the rule group.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PatchRule>.Builder} avoiding the
         * need to create one manually via {@link List<PatchRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchRule>.Builder#build()} is called immediately and its
         * result is passed to {@link #patchRules(List<PatchRule>)}.
         * 
         * @param patchRules
         *        a consumer that will call methods on {@link List<PatchRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #patchRules(List<PatchRule>)
         */
        Builder patchRules(Consumer<PatchRule.Builder>... patchRules);
    }

    static final class BuilderImpl implements Builder {
        private List<PatchRule> patchRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PatchRuleGroup model) {
            patchRules(model.patchRules);
        }

        public final List<PatchRule.Builder> getPatchRules() {
            List<PatchRule.Builder> result = PatchRuleListCopier.copyToBuilder(this.patchRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPatchRules(Collection<PatchRule.BuilderImpl> patchRules) {
            this.patchRules = PatchRuleListCopier.copyFromBuilder(patchRules);
        }

        @Override
        @Transient
        public final Builder patchRules(Collection<PatchRule> patchRules) {
            this.patchRules = PatchRuleListCopier.copy(patchRules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder patchRules(PatchRule... patchRules) {
            patchRules(Arrays.asList(patchRules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder patchRules(Consumer<PatchRule.Builder>... patchRules) {
            patchRules(Stream.of(patchRules).map(c -> PatchRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PatchRuleGroup build() {
            return new PatchRuleGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
