/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDocumentDefaultVersionResponse extends SsmResponse implements
        ToCopyableBuilder<UpdateDocumentDefaultVersionResponse.Builder, UpdateDocumentDefaultVersionResponse> {
    private static final SdkField<DocumentDefaultVersionDescription> DESCRIPTION_FIELD = SdkField
            .<DocumentDefaultVersionDescription> builder(MarshallingType.SDK_POJO).memberName("Description")
            .getter(getter(UpdateDocumentDefaultVersionResponse::description)).setter(setter(Builder::description))
            .constructor(DocumentDefaultVersionDescription::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD));

    private final DocumentDefaultVersionDescription description;

    private UpdateDocumentDefaultVersionResponse(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
    }

    /**
     * <p>
     * The description of a custom document that you want to set as the default version.
     * </p>
     * 
     * @return The description of a custom document that you want to set as the default version.
     */
    public final DocumentDefaultVersionDescription description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDocumentDefaultVersionResponse)) {
            return false;
        }
        UpdateDocumentDefaultVersionResponse other = (UpdateDocumentDefaultVersionResponse) obj;
        return Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDocumentDefaultVersionResponse").add("Description", description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDocumentDefaultVersionResponse, T> g) {
        return obj -> g.apply((UpdateDocumentDefaultVersionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateDocumentDefaultVersionResponse> {
        /**
         * <p>
         * The description of a custom document that you want to set as the default version.
         * </p>
         * 
         * @param description
         *        The description of a custom document that you want to set as the default version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(DocumentDefaultVersionDescription description);

        /**
         * <p>
         * The description of a custom document that you want to set as the default version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DocumentDefaultVersionDescription.Builder} avoiding the need to create one manually via
         * {@link DocumentDefaultVersionDescription#builder()}.
         *
         * When the {@link Consumer} completes, {@link DocumentDefaultVersionDescription.Builder#build()} is called
         * immediately and its result is passed to {@link #description(DocumentDefaultVersionDescription)}.
         * 
         * @param description
         *        a consumer that will call methods on {@link DocumentDefaultVersionDescription.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #description(DocumentDefaultVersionDescription)
         */
        default Builder description(Consumer<DocumentDefaultVersionDescription.Builder> description) {
            return description(DocumentDefaultVersionDescription.builder().applyMutation(description).build());
        }
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private DocumentDefaultVersionDescription description;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDocumentDefaultVersionResponse model) {
            super(model);
            description(model.description);
        }

        public final DocumentDefaultVersionDescription.Builder getDescription() {
            return description != null ? description.toBuilder() : null;
        }

        public final void setDescription(DocumentDefaultVersionDescription.BuilderImpl description) {
            this.description = description != null ? description.build() : null;
        }

        @Override
        @Transient
        public final Builder description(DocumentDefaultVersionDescription description) {
            this.description = description;
            return this;
        }

        @Override
        public UpdateDocumentDefaultVersionResponse build() {
            return new UpdateDocumentDefaultVersionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
