/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An activation registers one or more on-premises servers or virtual machines (VMs) with Amazon Web Services so that
 * you can configure those servers or VMs using Run Command. A server or VM that has been registered with Amazon Web
 * Services Systems Manager is called a managed instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Activation implements SdkPojo, Serializable, ToCopyableBuilder<Activation.Builder, Activation> {
    private static final SdkField<String> ACTIVATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActivationId").getter(getter(Activation::activationId)).setter(setter(Builder::activationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivationId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Activation::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DEFAULT_INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultInstanceName").getter(getter(Activation::defaultInstanceName))
            .setter(setter(Builder::defaultInstanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultInstanceName").build())
            .build();

    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRole").getter(getter(Activation::iamRole)).setter(setter(Builder::iamRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()).build();

    private static final SdkField<Integer> REGISTRATION_LIMIT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RegistrationLimit").getter(getter(Activation::registrationLimit))
            .setter(setter(Builder::registrationLimit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationLimit").build()).build();

    private static final SdkField<Integer> REGISTRATIONS_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("RegistrationsCount").getter(getter(Activation::registrationsCount))
            .setter(setter(Builder::registrationsCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegistrationsCount").build())
            .build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationDate").getter(getter(Activation::expirationDate)).setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()).build();

    private static final SdkField<Boolean> EXPIRED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Expired").getter(getter(Activation::expired)).setter(setter(Builder::expired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expired").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate").getter(getter(Activation::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(Activation::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVATION_ID_FIELD,
            DESCRIPTION_FIELD, DEFAULT_INSTANCE_NAME_FIELD, IAM_ROLE_FIELD, REGISTRATION_LIMIT_FIELD, REGISTRATIONS_COUNT_FIELD,
            EXPIRATION_DATE_FIELD, EXPIRED_FIELD, CREATED_DATE_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String activationId;

    private final String description;

    private final String defaultInstanceName;

    private final String iamRole;

    private final Integer registrationLimit;

    private final Integer registrationsCount;

    private final Instant expirationDate;

    private final Boolean expired;

    private final Instant createdDate;

    private final List<Tag> tags;

    private Activation(BuilderImpl builder) {
        this.activationId = builder.activationId;
        this.description = builder.description;
        this.defaultInstanceName = builder.defaultInstanceName;
        this.iamRole = builder.iamRole;
        this.registrationLimit = builder.registrationLimit;
        this.registrationsCount = builder.registrationsCount;
        this.expirationDate = builder.expirationDate;
        this.expired = builder.expired;
        this.createdDate = builder.createdDate;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ID created by Systems Manager when you submitted the activation.
     * </p>
     * 
     * @return The ID created by Systems Manager when you submitted the activation.
     */
    public final String activationId() {
        return activationId;
    }

    /**
     * <p>
     * A user defined description of the activation.
     * </p>
     * 
     * @return A user defined description of the activation.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * A name for the managed instance when it is created.
     * </p>
     * 
     * @return A name for the managed instance when it is created.
     */
    public final String defaultInstanceName() {
        return defaultInstanceName;
    }

    /**
     * <p>
     * The Identity and Access Management (IAM) role to assign to the managed instance.
     * </p>
     * 
     * @return The Identity and Access Management (IAM) role to assign to the managed instance.
     */
    public final String iamRole() {
        return iamRole;
    }

    /**
     * <p>
     * The maximum number of managed instances that can be registered using this activation.
     * </p>
     * 
     * @return The maximum number of managed instances that can be registered using this activation.
     */
    public final Integer registrationLimit() {
        return registrationLimit;
    }

    /**
     * <p>
     * The number of managed instances already registered with this activation.
     * </p>
     * 
     * @return The number of managed instances already registered with this activation.
     */
    public final Integer registrationsCount() {
        return registrationsCount;
    }

    /**
     * <p>
     * The date when this activation can no longer be used to register managed instances.
     * </p>
     * 
     * @return The date when this activation can no longer be used to register managed instances.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * Whether or not the activation is expired.
     * </p>
     * 
     * @return Whether or not the activation is expired.
     */
    public final Boolean expired() {
        return expired;
    }

    /**
     * <p>
     * The date the activation was created.
     * </p>
     * 
     * @return The date the activation was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Tags assigned to the activation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags assigned to the activation.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(activationId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(defaultInstanceName());
        hashCode = 31 * hashCode + Objects.hashCode(iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(registrationLimit());
        hashCode = 31 * hashCode + Objects.hashCode(registrationsCount());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(expired());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Activation)) {
            return false;
        }
        Activation other = (Activation) obj;
        return Objects.equals(activationId(), other.activationId()) && Objects.equals(description(), other.description())
                && Objects.equals(defaultInstanceName(), other.defaultInstanceName())
                && Objects.equals(iamRole(), other.iamRole()) && Objects.equals(registrationLimit(), other.registrationLimit())
                && Objects.equals(registrationsCount(), other.registrationsCount())
                && Objects.equals(expirationDate(), other.expirationDate()) && Objects.equals(expired(), other.expired())
                && Objects.equals(createdDate(), other.createdDate()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Activation").add("ActivationId", activationId()).add("Description", description())
                .add("DefaultInstanceName", defaultInstanceName()).add("IamRole", iamRole())
                .add("RegistrationLimit", registrationLimit()).add("RegistrationsCount", registrationsCount())
                .add("ExpirationDate", expirationDate()).add("Expired", expired()).add("CreatedDate", createdDate())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ActivationId":
            return Optional.ofNullable(clazz.cast(activationId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DefaultInstanceName":
            return Optional.ofNullable(clazz.cast(defaultInstanceName()));
        case "IamRole":
            return Optional.ofNullable(clazz.cast(iamRole()));
        case "RegistrationLimit":
            return Optional.ofNullable(clazz.cast(registrationLimit()));
        case "RegistrationsCount":
            return Optional.ofNullable(clazz.cast(registrationsCount()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "Expired":
            return Optional.ofNullable(clazz.cast(expired()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Activation, T> g) {
        return obj -> g.apply((Activation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Activation> {
        /**
         * <p>
         * The ID created by Systems Manager when you submitted the activation.
         * </p>
         * 
         * @param activationId
         *        The ID created by Systems Manager when you submitted the activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activationId(String activationId);

        /**
         * <p>
         * A user defined description of the activation.
         * </p>
         * 
         * @param description
         *        A user defined description of the activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * A name for the managed instance when it is created.
         * </p>
         * 
         * @param defaultInstanceName
         *        A name for the managed instance when it is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultInstanceName(String defaultInstanceName);

        /**
         * <p>
         * The Identity and Access Management (IAM) role to assign to the managed instance.
         * </p>
         * 
         * @param iamRole
         *        The Identity and Access Management (IAM) role to assign to the managed instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRole(String iamRole);

        /**
         * <p>
         * The maximum number of managed instances that can be registered using this activation.
         * </p>
         * 
         * @param registrationLimit
         *        The maximum number of managed instances that can be registered using this activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationLimit(Integer registrationLimit);

        /**
         * <p>
         * The number of managed instances already registered with this activation.
         * </p>
         * 
         * @param registrationsCount
         *        The number of managed instances already registered with this activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registrationsCount(Integer registrationsCount);

        /**
         * <p>
         * The date when this activation can no longer be used to register managed instances.
         * </p>
         * 
         * @param expirationDate
         *        The date when this activation can no longer be used to register managed instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);

        /**
         * <p>
         * Whether or not the activation is expired.
         * </p>
         * 
         * @param expired
         *        Whether or not the activation is expired.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expired(Boolean expired);

        /**
         * <p>
         * The date the activation was created.
         * </p>
         * 
         * @param createdDate
         *        The date the activation was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * Tags assigned to the activation.
         * </p>
         * 
         * @param tags
         *        Tags assigned to the activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Tags assigned to the activation.
         * </p>
         * 
         * @param tags
         *        Tags assigned to the activation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Tags assigned to the activation.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String activationId;

        private String description;

        private String defaultInstanceName;

        private String iamRole;

        private Integer registrationLimit;

        private Integer registrationsCount;

        private Instant expirationDate;

        private Boolean expired;

        private Instant createdDate;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Activation model) {
            activationId(model.activationId);
            description(model.description);
            defaultInstanceName(model.defaultInstanceName);
            iamRole(model.iamRole);
            registrationLimit(model.registrationLimit);
            registrationsCount(model.registrationsCount);
            expirationDate(model.expirationDate);
            expired(model.expired);
            createdDate(model.createdDate);
            tags(model.tags);
        }

        public final String getActivationId() {
            return activationId;
        }

        public final void setActivationId(String activationId) {
            this.activationId = activationId;
        }

        @Override
        @Transient
        public final Builder activationId(String activationId) {
            this.activationId = activationId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefaultInstanceName() {
            return defaultInstanceName;
        }

        public final void setDefaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
        }

        @Override
        @Transient
        public final Builder defaultInstanceName(String defaultInstanceName) {
            this.defaultInstanceName = defaultInstanceName;
            return this;
        }

        public final String getIamRole() {
            return iamRole;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        @Override
        @Transient
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final Integer getRegistrationLimit() {
            return registrationLimit;
        }

        public final void setRegistrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
        }

        @Override
        @Transient
        public final Builder registrationLimit(Integer registrationLimit) {
            this.registrationLimit = registrationLimit;
            return this;
        }

        public final Integer getRegistrationsCount() {
            return registrationsCount;
        }

        public final void setRegistrationsCount(Integer registrationsCount) {
            this.registrationsCount = registrationsCount;
        }

        @Override
        @Transient
        public final Builder registrationsCount(Integer registrationsCount) {
            this.registrationsCount = registrationsCount;
            return this;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        @Transient
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final Boolean getExpired() {
            return expired;
        }

        public final void setExpired(Boolean expired) {
            this.expired = expired;
        }

        @Override
        @Transient
        public final Builder expired(Boolean expired) {
            this.expired = expired;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        @Transient
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Activation build() {
            return new Activation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
