/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateOpsMetadataRequest extends SsmRequest implements
        ToCopyableBuilder<UpdateOpsMetadataRequest.Builder, UpdateOpsMetadataRequest> {
    private static final SdkField<String> OPS_METADATA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpsMetadataArn").getter(getter(UpdateOpsMetadataRequest::opsMetadataArn))
            .setter(setter(Builder::opsMetadataArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpsMetadataArn").build()).build();

    private static final SdkField<Map<String, MetadataValue>> METADATA_TO_UPDATE_FIELD = SdkField
            .<Map<String, MetadataValue>> builder(MarshallingType.MAP)
            .memberName("MetadataToUpdate")
            .getter(getter(UpdateOpsMetadataRequest::metadataToUpdate))
            .setter(setter(Builder::metadataToUpdate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataToUpdate").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<MetadataValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetadataValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> KEYS_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("KeysToDelete")
            .getter(getter(UpdateOpsMetadataRequest::keysToDelete))
            .setter(setter(Builder::keysToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeysToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPS_METADATA_ARN_FIELD,
            METADATA_TO_UPDATE_FIELD, KEYS_TO_DELETE_FIELD));

    private final String opsMetadataArn;

    private final Map<String, MetadataValue> metadataToUpdate;

    private final List<String> keysToDelete;

    private UpdateOpsMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.opsMetadataArn = builder.opsMetadataArn;
        this.metadataToUpdate = builder.metadataToUpdate;
        this.keysToDelete = builder.keysToDelete;
    }

    /**
     * <p>
     * The Amazon Resoure Name (ARN) of the OpsMetadata Object to update.
     * </p>
     * 
     * @return The Amazon Resoure Name (ARN) of the OpsMetadata Object to update.
     */
    public final String opsMetadataArn() {
        return opsMetadataArn;
    }

    /**
     * Returns true if the MetadataToUpdate property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasMetadataToUpdate() {
        return metadataToUpdate != null && !(metadataToUpdate instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Metadata to add to an OpsMetadata object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasMetadataToUpdate()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Metadata to add to an OpsMetadata object.
     */
    public final Map<String, MetadataValue> metadataToUpdate() {
        return metadataToUpdate;
    }

    /**
     * Returns true if the KeysToDelete property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasKeysToDelete() {
        return keysToDelete != null && !(keysToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The metadata keys to delete from the OpsMetadata object.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasKeysToDelete()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The metadata keys to delete from the OpsMetadata object.
     */
    public final List<String> keysToDelete() {
        return keysToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(opsMetadataArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadataToUpdate() ? metadataToUpdate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasKeysToDelete() ? keysToDelete() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateOpsMetadataRequest)) {
            return false;
        }
        UpdateOpsMetadataRequest other = (UpdateOpsMetadataRequest) obj;
        return Objects.equals(opsMetadataArn(), other.opsMetadataArn()) && hasMetadataToUpdate() == other.hasMetadataToUpdate()
                && Objects.equals(metadataToUpdate(), other.metadataToUpdate()) && hasKeysToDelete() == other.hasKeysToDelete()
                && Objects.equals(keysToDelete(), other.keysToDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateOpsMetadataRequest").add("OpsMetadataArn", opsMetadataArn())
                .add("MetadataToUpdate", hasMetadataToUpdate() ? metadataToUpdate() : null)
                .add("KeysToDelete", hasKeysToDelete() ? keysToDelete() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OpsMetadataArn":
            return Optional.ofNullable(clazz.cast(opsMetadataArn()));
        case "MetadataToUpdate":
            return Optional.ofNullable(clazz.cast(metadataToUpdate()));
        case "KeysToDelete":
            return Optional.ofNullable(clazz.cast(keysToDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateOpsMetadataRequest, T> g) {
        return obj -> g.apply((UpdateOpsMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateOpsMetadataRequest> {
        /**
         * <p>
         * The Amazon Resoure Name (ARN) of the OpsMetadata Object to update.
         * </p>
         * 
         * @param opsMetadataArn
         *        The Amazon Resoure Name (ARN) of the OpsMetadata Object to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opsMetadataArn(String opsMetadataArn);

        /**
         * <p>
         * Metadata to add to an OpsMetadata object.
         * </p>
         * 
         * @param metadataToUpdate
         *        Metadata to add to an OpsMetadata object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataToUpdate(Map<String, MetadataValue> metadataToUpdate);

        /**
         * <p>
         * The metadata keys to delete from the OpsMetadata object.
         * </p>
         * 
         * @param keysToDelete
         *        The metadata keys to delete from the OpsMetadata object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keysToDelete(Collection<String> keysToDelete);

        /**
         * <p>
         * The metadata keys to delete from the OpsMetadata object.
         * </p>
         * 
         * @param keysToDelete
         *        The metadata keys to delete from the OpsMetadata object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keysToDelete(String... keysToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String opsMetadataArn;

        private Map<String, MetadataValue> metadataToUpdate = DefaultSdkAutoConstructMap.getInstance();

        private List<String> keysToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateOpsMetadataRequest model) {
            super(model);
            opsMetadataArn(model.opsMetadataArn);
            metadataToUpdate(model.metadataToUpdate);
            keysToDelete(model.keysToDelete);
        }

        public final String getOpsMetadataArn() {
            return opsMetadataArn;
        }

        public final void setOpsMetadataArn(String opsMetadataArn) {
            this.opsMetadataArn = opsMetadataArn;
        }

        @Override
        @Transient
        public final Builder opsMetadataArn(String opsMetadataArn) {
            this.opsMetadataArn = opsMetadataArn;
            return this;
        }

        public final Map<String, MetadataValue.Builder> getMetadataToUpdate() {
            Map<String, MetadataValue.Builder> result = MetadataMapCopier.copyToBuilder(this.metadataToUpdate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMetadataToUpdate(Map<String, MetadataValue.BuilderImpl> metadataToUpdate) {
            this.metadataToUpdate = MetadataMapCopier.copyFromBuilder(metadataToUpdate);
        }

        @Override
        @Transient
        public final Builder metadataToUpdate(Map<String, MetadataValue> metadataToUpdate) {
            this.metadataToUpdate = MetadataMapCopier.copy(metadataToUpdate);
            return this;
        }

        public final Collection<String> getKeysToDelete() {
            if (keysToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return keysToDelete;
        }

        public final void setKeysToDelete(Collection<String> keysToDelete) {
            this.keysToDelete = MetadataKeysToDeleteListCopier.copy(keysToDelete);
        }

        @Override
        @Transient
        public final Builder keysToDelete(Collection<String> keysToDelete) {
            this.keysToDelete = MetadataKeysToDeleteListCopier.copy(keysToDelete);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder keysToDelete(String... keysToDelete) {
            keysToDelete(Arrays.asList(keysToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateOpsMetadataRequest build() {
            return new UpdateOpsMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
