/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum PatchFilterKey {
    ARCH("ARCH"),

    ADVISORY_ID("ADVISORY_ID"),

    BUGZILLA_ID("BUGZILLA_ID"),

    PATCH_SET("PATCH_SET"),

    PRODUCT("PRODUCT"),

    PRODUCT_FAMILY("PRODUCT_FAMILY"),

    CLASSIFICATION("CLASSIFICATION"),

    CVE_ID("CVE_ID"),

    EPOCH("EPOCH"),

    MSRC_SEVERITY("MSRC_SEVERITY"),

    NAME("NAME"),

    PATCH_ID("PATCH_ID"),

    SECTION("SECTION"),

    PRIORITY("PRIORITY"),

    REPOSITORY("REPOSITORY"),

    RELEASE("RELEASE"),

    SEVERITY("SEVERITY"),

    SECURITY("SECURITY"),

    VERSION("VERSION"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PatchFilterKey> VALUE_MAP = EnumUtils.uniqueIndex(PatchFilterKey.class,
            PatchFilterKey::toString);

    private final String value;

    private PatchFilterKey(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return PatchFilterKey corresponding to the value
     */
    public static PatchFilterKey fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link PatchFilterKey}s
     */
    public static Set<PatchFilterKey> knownValues() {
        Set<PatchFilterKey> knownValues = EnumSet.allOf(PatchFilterKey.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
