/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePatchBaselineRequest extends SsmRequest implements
        ToCopyableBuilder<CreatePatchBaselineRequest.Builder, CreatePatchBaselineRequest> {
    private static final SdkField<String> OPERATING_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OperatingSystem").getter(getter(CreatePatchBaselineRequest::operatingSystemAsString))
            .setter(setter(Builder::operatingSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OperatingSystem").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreatePatchBaselineRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<PatchFilterGroup> GLOBAL_FILTERS_FIELD = SdkField
            .<PatchFilterGroup> builder(MarshallingType.SDK_POJO).memberName("GlobalFilters")
            .getter(getter(CreatePatchBaselineRequest::globalFilters)).setter(setter(Builder::globalFilters))
            .constructor(PatchFilterGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalFilters").build()).build();

    private static final SdkField<PatchRuleGroup> APPROVAL_RULES_FIELD = SdkField
            .<PatchRuleGroup> builder(MarshallingType.SDK_POJO).memberName("ApprovalRules")
            .getter(getter(CreatePatchBaselineRequest::approvalRules)).setter(setter(Builder::approvalRules))
            .constructor(PatchRuleGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalRules").build()).build();

    private static final SdkField<List<String>> APPROVED_PATCHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ApprovedPatches")
            .getter(getter(CreatePatchBaselineRequest::approvedPatches))
            .setter(setter(Builder::approvedPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ApprovedPatchesComplianceLevel")
            .getter(getter(CreatePatchBaselineRequest::approvedPatchesComplianceLevelAsString))
            .setter(setter(Builder::approvedPatchesComplianceLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatchesComplianceLevel")
                    .build()).build();

    private static final SdkField<Boolean> APPROVED_PATCHES_ENABLE_NON_SECURITY_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ApprovedPatchesEnableNonSecurity")
            .getter(getter(CreatePatchBaselineRequest::approvedPatchesEnableNonSecurity))
            .setter(setter(Builder::approvedPatchesEnableNonSecurity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovedPatchesEnableNonSecurity")
                    .build()).build();

    private static final SdkField<List<String>> REJECTED_PATCHES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("RejectedPatches")
            .getter(getter(CreatePatchBaselineRequest::rejectedPatches))
            .setter(setter(Builder::rejectedPatches))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedPatches").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REJECTED_PATCHES_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RejectedPatchesAction").getter(getter(CreatePatchBaselineRequest::rejectedPatchesActionAsString))
            .setter(setter(Builder::rejectedPatchesAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RejectedPatchesAction").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(CreatePatchBaselineRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<List<PatchSource>> SOURCES_FIELD = SdkField
            .<List<PatchSource>> builder(MarshallingType.LIST)
            .memberName("Sources")
            .getter(getter(CreatePatchBaselineRequest::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PatchSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(PatchSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(CreatePatchBaselineRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreatePatchBaselineRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATING_SYSTEM_FIELD,
            NAME_FIELD, GLOBAL_FILTERS_FIELD, APPROVAL_RULES_FIELD, APPROVED_PATCHES_FIELD,
            APPROVED_PATCHES_COMPLIANCE_LEVEL_FIELD, APPROVED_PATCHES_ENABLE_NON_SECURITY_FIELD, REJECTED_PATCHES_FIELD,
            REJECTED_PATCHES_ACTION_FIELD, DESCRIPTION_FIELD, SOURCES_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD));

    private final String operatingSystem;

    private final String name;

    private final PatchFilterGroup globalFilters;

    private final PatchRuleGroup approvalRules;

    private final List<String> approvedPatches;

    private final String approvedPatchesComplianceLevel;

    private final Boolean approvedPatchesEnableNonSecurity;

    private final List<String> rejectedPatches;

    private final String rejectedPatchesAction;

    private final String description;

    private final List<PatchSource> sources;

    private final String clientToken;

    private final List<Tag> tags;

    private CreatePatchBaselineRequest(BuilderImpl builder) {
        super(builder);
        this.operatingSystem = builder.operatingSystem;
        this.name = builder.name;
        this.globalFilters = builder.globalFilters;
        this.approvalRules = builder.approvalRules;
        this.approvedPatches = builder.approvedPatches;
        this.approvedPatchesComplianceLevel = builder.approvedPatchesComplianceLevel;
        this.approvedPatchesEnableNonSecurity = builder.approvedPatchesEnableNonSecurity;
        this.rejectedPatches = builder.rejectedPatches;
        this.rejectedPatchesAction = builder.rejectedPatchesAction;
        this.description = builder.description;
        this.sources = builder.sources;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>.
     * @see OperatingSystem
     */
    public final OperatingSystem operatingSystem() {
        return OperatingSystem.fromValue(operatingSystem);
    }

    /**
     * <p>
     * Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operatingSystem}
     * will return {@link OperatingSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #operatingSystemAsString}.
     * </p>
     * 
     * @return Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>.
     * @see OperatingSystem
     */
    public final String operatingSystemAsString() {
        return operatingSystem;
    }

    /**
     * <p>
     * The name of the patch baseline.
     * </p>
     * 
     * @return The name of the patch baseline.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A set of global filters used to include patches in the baseline.
     * </p>
     * 
     * @return A set of global filters used to include patches in the baseline.
     */
    public final PatchFilterGroup globalFilters() {
        return globalFilters;
    }

    /**
     * <p>
     * A set of rules used to include patches in the baseline.
     * </p>
     * 
     * @return A set of rules used to include patches in the baseline.
     */
    public final PatchRuleGroup approvalRules() {
        return approvalRules;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApprovedPatches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasApprovedPatches() {
        return approvedPatches != null && !(approvedPatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of explicitly approved patches for the baseline.
     * </p>
     * <p>
     * For information about accepted formats for lists of approved patches and rejected patches, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html"
     * >About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems
     * Manager User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApprovedPatches} method.
     * </p>
     * 
     * @return A list of explicitly approved patches for the baseline.</p>
     *         <p>
     *         For information about accepted formats for lists of approved patches and rejected patches, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html"
     *         >About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services
     *         Systems Manager User Guide</i>.
     */
    public final List<String> approvedPatches() {
        return approvedPatches;
    }

    /**
     * <p>
     * Defines the compliance level for approved patches. When an approved patch is reported as missing, this value
     * describes the severity of the compliance violation. The default value is <code>UNSPECIFIED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approvedPatchesComplianceLevel} will return {@link PatchComplianceLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #approvedPatchesComplianceLevelAsString}.
     * </p>
     * 
     * @return Defines the compliance level for approved patches. When an approved patch is reported as missing, this
     *         value describes the severity of the compliance violation. The default value is <code>UNSPECIFIED</code>.
     * @see PatchComplianceLevel
     */
    public final PatchComplianceLevel approvedPatchesComplianceLevel() {
        return PatchComplianceLevel.fromValue(approvedPatchesComplianceLevel);
    }

    /**
     * <p>
     * Defines the compliance level for approved patches. When an approved patch is reported as missing, this value
     * describes the severity of the compliance violation. The default value is <code>UNSPECIFIED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #approvedPatchesComplianceLevel} will return {@link PatchComplianceLevel#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #approvedPatchesComplianceLevelAsString}.
     * </p>
     * 
     * @return Defines the compliance level for approved patches. When an approved patch is reported as missing, this
     *         value describes the severity of the compliance violation. The default value is <code>UNSPECIFIED</code>.
     * @see PatchComplianceLevel
     */
    public final String approvedPatchesComplianceLevelAsString() {
        return approvedPatchesComplianceLevel;
    }

    /**
     * <p>
     * Indicates whether the list of approved patches includes non-security updates that should be applied to the
     * managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.
     * </p>
     * 
     * @return Indicates whether the list of approved patches includes non-security updates that should be applied to
     *         the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.
     */
    public final Boolean approvedPatchesEnableNonSecurity() {
        return approvedPatchesEnableNonSecurity;
    }

    /**
     * For responses, this returns true if the service returned a value for the RejectedPatches property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRejectedPatches() {
        return rejectedPatches != null && !(rejectedPatches instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of explicitly rejected patches for the baseline.
     * </p>
     * <p>
     * For information about accepted formats for lists of approved patches and rejected patches, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html"
     * >About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems
     * Manager User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRejectedPatches} method.
     * </p>
     * 
     * @return A list of explicitly rejected patches for the baseline.</p>
     *         <p>
     *         For information about accepted formats for lists of approved patches and rejected patches, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html"
     *         >About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services
     *         Systems Manager User Guide</i>.
     */
    public final List<String> rejectedPatches() {
        return rejectedPatches;
    }

    /**
     * <p>
     * The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is installed only
     * if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is
     * reported as <code>InstalledOther</code>. This is the default action if no option is specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that include them as
     * dependencies, aren't installed under any circumstances. If a package was installed before it was added to the
     * Rejected patches list, it is considered non-compliant with the patch baseline, and its status is reported as
     * <code>InstalledRejected</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #rejectedPatchesAction} will return {@link PatchAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #rejectedPatchesActionAsString}.
     * </p>
     * 
     * @return The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is
     *         installed only if it is a dependency of another package. It is considered compliant with the patch
     *         baseline, and its status is reported as <code>InstalledOther</code>. This is the default action if no
     *         option is specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that include
     *         them as dependencies, aren't installed under any circumstances. If a package was installed before it was
     *         added to the Rejected patches list, it is considered non-compliant with the patch baseline, and its
     *         status is reported as <code>InstalledRejected</code>.
     *         </p>
     *         </li>
     * @see PatchAction
     */
    public final PatchAction rejectedPatchesAction() {
        return PatchAction.fromValue(rejectedPatchesAction);
    }

    /**
     * <p>
     * The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is installed only
     * if it is a dependency of another package. It is considered compliant with the patch baseline, and its status is
     * reported as <code>InstalledOther</code>. This is the default action if no option is specified.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that include them as
     * dependencies, aren't installed under any circumstances. If a package was installed before it was added to the
     * Rejected patches list, it is considered non-compliant with the patch baseline, and its status is reported as
     * <code>InstalledRejected</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #rejectedPatchesAction} will return {@link PatchAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #rejectedPatchesActionAsString}.
     * </p>
     * 
     * @return The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is
     *         installed only if it is a dependency of another package. It is considered compliant with the patch
     *         baseline, and its status is reported as <code>InstalledOther</code>. This is the default action if no
     *         option is specified.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that include
     *         them as dependencies, aren't installed under any circumstances. If a package was installed before it was
     *         added to the Rejected patches list, it is considered non-compliant with the patch baseline, and its
     *         status is reported as <code>InstalledRejected</code>.
     *         </p>
     *         </li>
     * @see PatchAction
     */
    public final String rejectedPatchesActionAsString() {
        return rejectedPatchesAction;
    }

    /**
     * <p>
     * A description of the patch baseline.
     * </p>
     * 
     * @return A description of the patch baseline.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the patches to use to update the managed nodes, including target operating systems and source
     * repositories. Applies to Linux managed nodes only.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSources} method.
     * </p>
     * 
     * @return Information about the patches to use to update the managed nodes, including target operating systems and
     *         source repositories. Applies to Linux managed nodes only.
     */
    public final List<PatchSource> sources() {
        return sources;
    }

    /**
     * <p>
     * User-provided idempotency token.
     * </p>
     * 
     * @return User-provided idempotency token.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways, such
     * as by purpose, owner, or environment. For example, you might want to tag a patch baseline to identify the
     * severity level of patches it specifies and the operating system family it applies to. In this case, you could
     * specify the following key-value pairs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=PatchSeverity,Value=Critical</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=OS,Value=Windows</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * To add tags to an existing patch baseline, use the <a>AddTagsToResource</a> operation.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
     *         ways, such as by purpose, owner, or environment. For example, you might want to tag a patch baseline to
     *         identify the severity level of patches it specifies and the operating system family it applies to. In
     *         this case, you could specify the following key-value pairs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Key=PatchSeverity,Value=Critical</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Key=OS,Value=Windows</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         To add tags to an existing patch baseline, use the <a>AddTagsToResource</a> operation.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(operatingSystemAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(globalFilters());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRules());
        hashCode = 31 * hashCode + Objects.hashCode(hasApprovedPatches() ? approvedPatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(approvedPatchesComplianceLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(approvedPatchesEnableNonSecurity());
        hashCode = 31 * hashCode + Objects.hashCode(hasRejectedPatches() ? rejectedPatches() : null);
        hashCode = 31 * hashCode + Objects.hashCode(rejectedPatchesActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePatchBaselineRequest)) {
            return false;
        }
        CreatePatchBaselineRequest other = (CreatePatchBaselineRequest) obj;
        return Objects.equals(operatingSystemAsString(), other.operatingSystemAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(globalFilters(), other.globalFilters())
                && Objects.equals(approvalRules(), other.approvalRules()) && hasApprovedPatches() == other.hasApprovedPatches()
                && Objects.equals(approvedPatches(), other.approvedPatches())
                && Objects.equals(approvedPatchesComplianceLevelAsString(), other.approvedPatchesComplianceLevelAsString())
                && Objects.equals(approvedPatchesEnableNonSecurity(), other.approvedPatchesEnableNonSecurity())
                && hasRejectedPatches() == other.hasRejectedPatches()
                && Objects.equals(rejectedPatches(), other.rejectedPatches())
                && Objects.equals(rejectedPatchesActionAsString(), other.rejectedPatchesActionAsString())
                && Objects.equals(description(), other.description()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && Objects.equals(clientToken(), other.clientToken())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePatchBaselineRequest").add("OperatingSystem", operatingSystemAsString())
                .add("Name", name()).add("GlobalFilters", globalFilters()).add("ApprovalRules", approvalRules())
                .add("ApprovedPatches", hasApprovedPatches() ? approvedPatches() : null)
                .add("ApprovedPatchesComplianceLevel", approvedPatchesComplianceLevelAsString())
                .add("ApprovedPatchesEnableNonSecurity", approvedPatchesEnableNonSecurity())
                .add("RejectedPatches", hasRejectedPatches() ? rejectedPatches() : null)
                .add("RejectedPatchesAction", rejectedPatchesActionAsString()).add("Description", description())
                .add("Sources", hasSources() ? sources() : null).add("ClientToken", clientToken())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperatingSystem":
            return Optional.ofNullable(clazz.cast(operatingSystemAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "GlobalFilters":
            return Optional.ofNullable(clazz.cast(globalFilters()));
        case "ApprovalRules":
            return Optional.ofNullable(clazz.cast(approvalRules()));
        case "ApprovedPatches":
            return Optional.ofNullable(clazz.cast(approvedPatches()));
        case "ApprovedPatchesComplianceLevel":
            return Optional.ofNullable(clazz.cast(approvedPatchesComplianceLevelAsString()));
        case "ApprovedPatchesEnableNonSecurity":
            return Optional.ofNullable(clazz.cast(approvedPatchesEnableNonSecurity()));
        case "RejectedPatches":
            return Optional.ofNullable(clazz.cast(rejectedPatches()));
        case "RejectedPatchesAction":
            return Optional.ofNullable(clazz.cast(rejectedPatchesActionAsString()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePatchBaselineRequest, T> g) {
        return obj -> g.apply((CreatePatchBaselineRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePatchBaselineRequest> {
        /**
         * <p>
         * Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>.
         * </p>
         * 
         * @param operatingSystem
         *        Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(String operatingSystem);

        /**
         * <p>
         * Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>.
         * </p>
         * 
         * @param operatingSystem
         *        Defines the operating system the patch baseline applies to. The default value is <code>WINDOWS</code>.
         * @see OperatingSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OperatingSystem
         */
        Builder operatingSystem(OperatingSystem operatingSystem);

        /**
         * <p>
         * The name of the patch baseline.
         * </p>
         * 
         * @param name
         *        The name of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A set of global filters used to include patches in the baseline.
         * </p>
         * 
         * @param globalFilters
         *        A set of global filters used to include patches in the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalFilters(PatchFilterGroup globalFilters);

        /**
         * <p>
         * A set of global filters used to include patches in the baseline.
         * </p>
         * This is a convenience method that creates an instance of the {@link PatchFilterGroup.Builder} avoiding the
         * need to create one manually via {@link PatchFilterGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link PatchFilterGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #globalFilters(PatchFilterGroup)}.
         * 
         * @param globalFilters
         *        a consumer that will call methods on {@link PatchFilterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalFilters(PatchFilterGroup)
         */
        default Builder globalFilters(Consumer<PatchFilterGroup.Builder> globalFilters) {
            return globalFilters(PatchFilterGroup.builder().applyMutation(globalFilters).build());
        }

        /**
         * <p>
         * A set of rules used to include patches in the baseline.
         * </p>
         * 
         * @param approvalRules
         *        A set of rules used to include patches in the baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRules(PatchRuleGroup approvalRules);

        /**
         * <p>
         * A set of rules used to include patches in the baseline.
         * </p>
         * This is a convenience method that creates an instance of the {@link PatchRuleGroup.Builder} avoiding the need
         * to create one manually via {@link PatchRuleGroup#builder()}.
         *
         * When the {@link Consumer} completes, {@link PatchRuleGroup.Builder#build()} is called immediately and its
         * result is passed to {@link #approvalRules(PatchRuleGroup)}.
         * 
         * @param approvalRules
         *        a consumer that will call methods on {@link PatchRuleGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalRules(PatchRuleGroup)
         */
        default Builder approvalRules(Consumer<PatchRuleGroup.Builder> approvalRules) {
            return approvalRules(PatchRuleGroup.builder().applyMutation(approvalRules).build());
        }

        /**
         * <p>
         * A list of explicitly approved patches for the baseline.
         * </p>
         * <p>
         * For information about accepted formats for lists of approved patches and rejected patches, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html"
         * >About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems
         * Manager User Guide</i>.
         * </p>
         * 
         * @param approvedPatches
         *        A list of explicitly approved patches for the baseline.</p>
         *        <p>
         *        For information about accepted formats for lists of approved patches and rejected patches, see <a
         *        href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html"
         *        >About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services
         *        Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatches(Collection<String> approvedPatches);

        /**
         * <p>
         * A list of explicitly approved patches for the baseline.
         * </p>
         * <p>
         * For information about accepted formats for lists of approved patches and rejected patches, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html"
         * >About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems
         * Manager User Guide</i>.
         * </p>
         * 
         * @param approvedPatches
         *        A list of explicitly approved patches for the baseline.</p>
         *        <p>
         *        For information about accepted formats for lists of approved patches and rejected patches, see <a
         *        href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html"
         *        >About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services
         *        Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatches(String... approvedPatches);

        /**
         * <p>
         * Defines the compliance level for approved patches. When an approved patch is reported as missing, this value
         * describes the severity of the compliance violation. The default value is <code>UNSPECIFIED</code>.
         * </p>
         * 
         * @param approvedPatchesComplianceLevel
         *        Defines the compliance level for approved patches. When an approved patch is reported as missing, this
         *        value describes the severity of the compliance violation. The default value is
         *        <code>UNSPECIFIED</code>.
         * @see PatchComplianceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchComplianceLevel
         */
        Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel);

        /**
         * <p>
         * Defines the compliance level for approved patches. When an approved patch is reported as missing, this value
         * describes the severity of the compliance violation. The default value is <code>UNSPECIFIED</code>.
         * </p>
         * 
         * @param approvedPatchesComplianceLevel
         *        Defines the compliance level for approved patches. When an approved patch is reported as missing, this
         *        value describes the severity of the compliance violation. The default value is
         *        <code>UNSPECIFIED</code>.
         * @see PatchComplianceLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchComplianceLevel
         */
        Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel);

        /**
         * <p>
         * Indicates whether the list of approved patches includes non-security updates that should be applied to the
         * managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.
         * </p>
         * 
         * @param approvedPatchesEnableNonSecurity
         *        Indicates whether the list of approved patches includes non-security updates that should be applied to
         *        the managed nodes. The default value is <code>false</code>. Applies to Linux managed nodes only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity);

        /**
         * <p>
         * A list of explicitly rejected patches for the baseline.
         * </p>
         * <p>
         * For information about accepted formats for lists of approved patches and rejected patches, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html"
         * >About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems
         * Manager User Guide</i>.
         * </p>
         * 
         * @param rejectedPatches
         *        A list of explicitly rejected patches for the baseline.</p>
         *        <p>
         *        For information about accepted formats for lists of approved patches and rejected patches, see <a
         *        href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html"
         *        >About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services
         *        Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedPatches(Collection<String> rejectedPatches);

        /**
         * <p>
         * A list of explicitly rejected patches for the baseline.
         * </p>
         * <p>
         * For information about accepted formats for lists of approved patches and rejected patches, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html"
         * >About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services Systems
         * Manager User Guide</i>.
         * </p>
         * 
         * @param rejectedPatches
         *        A list of explicitly rejected patches for the baseline.</p>
         *        <p>
         *        For information about accepted formats for lists of approved patches and rejected patches, see <a
         *        href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html"
         *        >About package name formats for approved and rejected patch lists</a> in the <i>Amazon Web Services
         *        Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rejectedPatches(String... rejectedPatches);

        /**
         * <p>
         * The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is installed
         * only if it is a dependency of another package. It is considered compliant with the patch baseline, and its
         * status is reported as <code>InstalledOther</code>. This is the default action if no option is specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that include
         * them as dependencies, aren't installed under any circumstances. If a package was installed before it was
         * added to the Rejected patches list, it is considered non-compliant with the patch baseline, and its status is
         * reported as <code>InstalledRejected</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param rejectedPatchesAction
         *        The action for Patch Manager to take on patches included in the <code>RejectedPackages</code>
         *        list.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is
         *        installed only if it is a dependency of another package. It is considered compliant with the patch
         *        baseline, and its status is reported as <code>InstalledOther</code>. This is the default action if no
         *        option is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that
         *        include them as dependencies, aren't installed under any circumstances. If a package was installed
         *        before it was added to the Rejected patches list, it is considered non-compliant with the patch
         *        baseline, and its status is reported as <code>InstalledRejected</code>.
         *        </p>
         *        </li>
         * @see PatchAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchAction
         */
        Builder rejectedPatchesAction(String rejectedPatchesAction);

        /**
         * <p>
         * The action for Patch Manager to take on patches included in the <code>RejectedPackages</code> list.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is installed
         * only if it is a dependency of another package. It is considered compliant with the patch baseline, and its
         * status is reported as <code>InstalledOther</code>. This is the default action if no option is specified.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that include
         * them as dependencies, aren't installed under any circumstances. If a package was installed before it was
         * added to the Rejected patches list, it is considered non-compliant with the patch baseline, and its status is
         * reported as <code>InstalledRejected</code>.
         * </p>
         * </li>
         * </ul>
         * 
         * @param rejectedPatchesAction
         *        The action for Patch Manager to take on patches included in the <code>RejectedPackages</code>
         *        list.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b> <code>ALLOW_AS_DEPENDENCY</code> </b>: A package in the <code>Rejected</code> patches list is
         *        installed only if it is a dependency of another package. It is considered compliant with the patch
         *        baseline, and its status is reported as <code>InstalledOther</code>. This is the default action if no
         *        option is specified.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b> <code>BLOCK</code> </b>: Packages in the <code>RejectedPatches</code> list, and packages that
         *        include them as dependencies, aren't installed under any circumstances. If a package was installed
         *        before it was added to the Rejected patches list, it is considered non-compliant with the patch
         *        baseline, and its status is reported as <code>InstalledRejected</code>.
         *        </p>
         *        </li>
         * @see PatchAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PatchAction
         */
        Builder rejectedPatchesAction(PatchAction rejectedPatchesAction);

        /**
         * <p>
         * A description of the patch baseline.
         * </p>
         * 
         * @param description
         *        A description of the patch baseline.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Information about the patches to use to update the managed nodes, including target operating systems and
         * source repositories. Applies to Linux managed nodes only.
         * </p>
         * 
         * @param sources
         *        Information about the patches to use to update the managed nodes, including target operating systems
         *        and source repositories. Applies to Linux managed nodes only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<PatchSource> sources);

        /**
         * <p>
         * Information about the patches to use to update the managed nodes, including target operating systems and
         * source repositories. Applies to Linux managed nodes only.
         * </p>
         * 
         * @param sources
         *        Information about the patches to use to update the managed nodes, including target operating systems
         *        and source repositories. Applies to Linux managed nodes only.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(PatchSource... sources);

        /**
         * <p>
         * Information about the patches to use to update the managed nodes, including target operating systems and
         * source repositories. Applies to Linux managed nodes only.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<PatchSource>.Builder} avoiding the
         * need to create one manually via {@link List<PatchSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchSource>.Builder#build()} is called immediately and its
         * result is passed to {@link #sources(List<PatchSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<PatchSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<PatchSource>)
         */
        Builder sources(Consumer<PatchSource.Builder>... sources);

        /**
         * <p>
         * User-provided idempotency token.
         * </p>
         * 
         * @param clientToken
         *        User-provided idempotency token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways,
         * such as by purpose, owner, or environment. For example, you might want to tag a patch baseline to identify
         * the severity level of patches it specifies and the operating system family it applies to. In this case, you
         * could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=PatchSeverity,Value=Critical</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * To add tags to an existing patch baseline, use the <a>AddTagsToResource</a> operation.
         * </p>
         * </note>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
         *        ways, such as by purpose, owner, or environment. For example, you might want to tag a patch baseline
         *        to identify the severity level of patches it specifies and the operating system family it applies to.
         *        In this case, you could specify the following key-value pairs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key=PatchSeverity,Value=Critical</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=OS,Value=Windows</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        To add tags to an existing patch baseline, use the <a>AddTagsToResource</a> operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways,
         * such as by purpose, owner, or environment. For example, you might want to tag a patch baseline to identify
         * the severity level of patches it specifies and the operating system family it applies to. In this case, you
         * could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=PatchSeverity,Value=Critical</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * To add tags to an existing patch baseline, use the <a>AddTagsToResource</a> operation.
         * </p>
         * </note>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different
         *        ways, such as by purpose, owner, or environment. For example, you might want to tag a patch baseline
         *        to identify the severity level of patches it specifies and the operating system family it applies to.
         *        In this case, you could specify the following key-value pairs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key=PatchSeverity,Value=Critical</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=OS,Value=Windows</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        To add tags to an existing patch baseline, use the <a>AddTagsToResource</a> operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Optional metadata that you assign to a resource. Tags enable you to categorize a resource in different ways,
         * such as by purpose, owner, or environment. For example, you might want to tag a patch baseline to identify
         * the severity level of patches it specifies and the operating system family it applies to. In this case, you
         * could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=PatchSeverity,Value=Critical</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * To add tags to an existing patch baseline, use the <a>AddTagsToResource</a> operation.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the
         * need to create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String operatingSystem;

        private String name;

        private PatchFilterGroup globalFilters;

        private PatchRuleGroup approvalRules;

        private List<String> approvedPatches = DefaultSdkAutoConstructList.getInstance();

        private String approvedPatchesComplianceLevel;

        private Boolean approvedPatchesEnableNonSecurity;

        private List<String> rejectedPatches = DefaultSdkAutoConstructList.getInstance();

        private String rejectedPatchesAction;

        private String description;

        private List<PatchSource> sources = DefaultSdkAutoConstructList.getInstance();

        private String clientToken;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePatchBaselineRequest model) {
            super(model);
            operatingSystem(model.operatingSystem);
            name(model.name);
            globalFilters(model.globalFilters);
            approvalRules(model.approvalRules);
            approvedPatches(model.approvedPatches);
            approvedPatchesComplianceLevel(model.approvedPatchesComplianceLevel);
            approvedPatchesEnableNonSecurity(model.approvedPatchesEnableNonSecurity);
            rejectedPatches(model.rejectedPatches);
            rejectedPatchesAction(model.rejectedPatchesAction);
            description(model.description);
            sources(model.sources);
            clientToken(model.clientToken);
            tags(model.tags);
        }

        public final String getOperatingSystem() {
            return operatingSystem;
        }

        public final void setOperatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
        }

        @Override
        public final Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            return this;
        }

        @Override
        public final Builder operatingSystem(OperatingSystem operatingSystem) {
            this.operatingSystem(operatingSystem == null ? null : operatingSystem.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PatchFilterGroup.Builder getGlobalFilters() {
            return globalFilters != null ? globalFilters.toBuilder() : null;
        }

        public final void setGlobalFilters(PatchFilterGroup.BuilderImpl globalFilters) {
            this.globalFilters = globalFilters != null ? globalFilters.build() : null;
        }

        @Override
        public final Builder globalFilters(PatchFilterGroup globalFilters) {
            this.globalFilters = globalFilters;
            return this;
        }

        public final PatchRuleGroup.Builder getApprovalRules() {
            return approvalRules != null ? approvalRules.toBuilder() : null;
        }

        public final void setApprovalRules(PatchRuleGroup.BuilderImpl approvalRules) {
            this.approvalRules = approvalRules != null ? approvalRules.build() : null;
        }

        @Override
        public final Builder approvalRules(PatchRuleGroup approvalRules) {
            this.approvalRules = approvalRules;
            return this;
        }

        public final Collection<String> getApprovedPatches() {
            if (approvedPatches instanceof SdkAutoConstructList) {
                return null;
            }
            return approvedPatches;
        }

        public final void setApprovedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
        }

        @Override
        public final Builder approvedPatches(Collection<String> approvedPatches) {
            this.approvedPatches = PatchIdListCopier.copy(approvedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder approvedPatches(String... approvedPatches) {
            approvedPatches(Arrays.asList(approvedPatches));
            return this;
        }

        public final String getApprovedPatchesComplianceLevel() {
            return approvedPatchesComplianceLevel;
        }

        public final void setApprovedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(String approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel = approvedPatchesComplianceLevel;
            return this;
        }

        @Override
        public final Builder approvedPatchesComplianceLevel(PatchComplianceLevel approvedPatchesComplianceLevel) {
            this.approvedPatchesComplianceLevel(approvedPatchesComplianceLevel == null ? null : approvedPatchesComplianceLevel
                    .toString());
            return this;
        }

        public final Boolean getApprovedPatchesEnableNonSecurity() {
            return approvedPatchesEnableNonSecurity;
        }

        public final void setApprovedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
            this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
        }

        @Override
        public final Builder approvedPatchesEnableNonSecurity(Boolean approvedPatchesEnableNonSecurity) {
            this.approvedPatchesEnableNonSecurity = approvedPatchesEnableNonSecurity;
            return this;
        }

        public final Collection<String> getRejectedPatches() {
            if (rejectedPatches instanceof SdkAutoConstructList) {
                return null;
            }
            return rejectedPatches;
        }

        public final void setRejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
        }

        @Override
        public final Builder rejectedPatches(Collection<String> rejectedPatches) {
            this.rejectedPatches = PatchIdListCopier.copy(rejectedPatches);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rejectedPatches(String... rejectedPatches) {
            rejectedPatches(Arrays.asList(rejectedPatches));
            return this;
        }

        public final String getRejectedPatchesAction() {
            return rejectedPatchesAction;
        }

        public final void setRejectedPatchesAction(String rejectedPatchesAction) {
            this.rejectedPatchesAction = rejectedPatchesAction;
        }

        @Override
        public final Builder rejectedPatchesAction(String rejectedPatchesAction) {
            this.rejectedPatchesAction = rejectedPatchesAction;
            return this;
        }

        @Override
        public final Builder rejectedPatchesAction(PatchAction rejectedPatchesAction) {
            this.rejectedPatchesAction(rejectedPatchesAction == null ? null : rejectedPatchesAction.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<PatchSource.Builder> getSources() {
            List<PatchSource.Builder> result = PatchSourceListCopier.copyToBuilder(this.sources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSources(Collection<PatchSource.BuilderImpl> sources) {
            this.sources = PatchSourceListCopier.copyFromBuilder(sources);
        }

        @Override
        public final Builder sources(Collection<PatchSource> sources) {
            this.sources = PatchSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(PatchSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<PatchSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> PatchSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePatchBaselineRequest build() {
            return new CreatePatchBaselineRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
