/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SessionManagerOutputUrl
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SessionManagerOutputUrl> {
    private static final SdkField<String> S3_OUTPUT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputUrl").getter(SessionManagerOutputUrl.getter(SessionManagerOutputUrl::s3OutputUrl)).setter(SessionManagerOutputUrl.setter(Builder::s3OutputUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputUrl").build()}).build();
    private static final SdkField<String> CLOUD_WATCH_OUTPUT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudWatchOutputUrl").getter(SessionManagerOutputUrl.getter(SessionManagerOutputUrl::cloudWatchOutputUrl)).setter(SessionManagerOutputUrl.setter(Builder::cloudWatchOutputUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchOutputUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_OUTPUT_URL_FIELD, CLOUD_WATCH_OUTPUT_URL_FIELD));
    private static final long serialVersionUID = 1L;
    private final String s3OutputUrl;
    private final String cloudWatchOutputUrl;

    private SessionManagerOutputUrl(BuilderImpl builder) {
        this.s3OutputUrl = builder.s3OutputUrl;
        this.cloudWatchOutputUrl = builder.cloudWatchOutputUrl;
    }

    public final String s3OutputUrl() {
        return this.s3OutputUrl;
    }

    public final String cloudWatchOutputUrl() {
        return this.cloudWatchOutputUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchOutputUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionManagerOutputUrl)) {
            return false;
        }
        SessionManagerOutputUrl other = (SessionManagerOutputUrl)obj;
        return Objects.equals(this.s3OutputUrl(), other.s3OutputUrl()) && Objects.equals(this.cloudWatchOutputUrl(), other.cloudWatchOutputUrl());
    }

    public final String toString() {
        return ToString.builder((String)"SessionManagerOutputUrl").add("S3OutputUrl", (Object)this.s3OutputUrl()).add("CloudWatchOutputUrl", (Object)this.cloudWatchOutputUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "S3OutputUrl": {
                return Optional.ofNullable(clazz.cast(this.s3OutputUrl()));
            }
            case "CloudWatchOutputUrl": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchOutputUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SessionManagerOutputUrl, T> g) {
        return obj -> g.apply((SessionManagerOutputUrl)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String s3OutputUrl;
        private String cloudWatchOutputUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(SessionManagerOutputUrl model) {
            this.s3OutputUrl(model.s3OutputUrl);
            this.cloudWatchOutputUrl(model.cloudWatchOutputUrl);
        }

        public final String getS3OutputUrl() {
            return this.s3OutputUrl;
        }

        public final void setS3OutputUrl(String s3OutputUrl) {
            this.s3OutputUrl = s3OutputUrl;
        }

        @Override
        @Transient
        public final Builder s3OutputUrl(String s3OutputUrl) {
            this.s3OutputUrl = s3OutputUrl;
            return this;
        }

        public final String getCloudWatchOutputUrl() {
            return this.cloudWatchOutputUrl;
        }

        public final void setCloudWatchOutputUrl(String cloudWatchOutputUrl) {
            this.cloudWatchOutputUrl = cloudWatchOutputUrl;
        }

        @Override
        @Transient
        public final Builder cloudWatchOutputUrl(String cloudWatchOutputUrl) {
            this.cloudWatchOutputUrl = cloudWatchOutputUrl;
            return this;
        }

        public SessionManagerOutputUrl build() {
            return new SessionManagerOutputUrl(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SessionManagerOutputUrl> {
        public Builder s3OutputUrl(String var1);

        public Builder cloudWatchOutputUrl(String var1);
    }
}

