/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ssm.SsmClient;
import software.amazon.awssdk.services.ssm.model.ComplianceItem;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsRequest;
import software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse;

public class ListComplianceItemsIterable
implements SdkIterable<ListComplianceItemsResponse> {
    private final SsmClient client;
    private final ListComplianceItemsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComplianceItemsIterable(SsmClient client, ListComplianceItemsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListComplianceItemsResponseFetcher();
    }

    public Iterator<ListComplianceItemsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComplianceItem> complianceItems() {
        Function<ListComplianceItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.complianceItems() != null) {
                return response.complianceItems().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComplianceItemsResponseFetcher
    implements SyncPageFetcher<ListComplianceItemsResponse> {
        private ListComplianceItemsResponseFetcher() {
        }

        public boolean hasNextPage(ListComplianceItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComplianceItemsResponse nextPage(ListComplianceItemsResponse previousPage) {
            if (previousPage == null) {
                return ListComplianceItemsIterable.this.client.listComplianceItems(ListComplianceItemsIterable.this.firstRequest);
            }
            return ListComplianceItemsIterable.this.client.listComplianceItems((ListComplianceItemsRequest)((Object)ListComplianceItemsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

