/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartAutomationExecutionRequest extends SsmRequest implements
        ToCopyableBuilder<StartAutomationExecutionRequest.Builder, StartAutomationExecutionRequest> {
    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentName").getter(getter(StartAutomationExecutionRequest::documentName))
            .setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(StartAutomationExecutionRequest::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<Map<String, List<String>>> PARAMETERS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(StartAutomationExecutionRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClientToken").getter(getter(StartAutomationExecutionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Mode")
            .getter(getter(StartAutomationExecutionRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()).build();

    private static final SdkField<String> TARGET_PARAMETER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetParameterName").getter(getter(StartAutomationExecutionRequest::targetParameterName))
            .setter(setter(Builder::targetParameterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetParameterName").build())
            .build();

    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField
            .<List<Target>> builder(MarshallingType.LIST)
            .memberName("Targets")
            .getter(getter(StartAutomationExecutionRequest::targets))
            .setter(setter(Builder::targets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Target> builder(MarshallingType.SDK_POJO)
                                            .constructor(Target::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Map<String, List<String>>>> TARGET_MAPS_FIELD = SdkField
            .<List<Map<String, List<String>>>> builder(MarshallingType.LIST)
            .memberName("TargetMaps")
            .getter(getter(StartAutomationExecutionRequest::targetMaps))
            .setter(setter(Builder::targetMaps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetMaps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, List<String>>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build(),
                                                                                    ListTrait
                                                                                            .builder()
                                                                                            .memberLocationName(null)
                                                                                            .memberFieldInfo(
                                                                                                    SdkField.<String> builder(
                                                                                                            MarshallingType.STRING)
                                                                                                            .traits(LocationTrait
                                                                                                                    .builder()
                                                                                                                    .location(
                                                                                                                            MarshallLocation.PAYLOAD)
                                                                                                                    .locationName(
                                                                                                                            "member")
                                                                                                                    .build())
                                                                                                            .build()).build())
                                                                            .build()).build()).build()).build()).build();

    private static final SdkField<String> MAX_CONCURRENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxConcurrency").getter(getter(StartAutomationExecutionRequest::maxConcurrency))
            .setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()).build();

    private static final SdkField<String> MAX_ERRORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MaxErrors").getter(getter(StartAutomationExecutionRequest::maxErrors))
            .setter(setter(Builder::maxErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxErrors").build()).build();

    private static final SdkField<List<TargetLocation>> TARGET_LOCATIONS_FIELD = SdkField
            .<List<TargetLocation>> builder(MarshallingType.LIST)
            .memberName("TargetLocations")
            .getter(getter(StartAutomationExecutionRequest::targetLocations))
            .setter(setter(Builder::targetLocations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TargetLocation> builder(MarshallingType.SDK_POJO)
                                            .constructor(TargetLocation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartAutomationExecutionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_NAME_FIELD,
            DOCUMENT_VERSION_FIELD, PARAMETERS_FIELD, CLIENT_TOKEN_FIELD, MODE_FIELD, TARGET_PARAMETER_NAME_FIELD, TARGETS_FIELD,
            TARGET_MAPS_FIELD, MAX_CONCURRENCY_FIELD, MAX_ERRORS_FIELD, TARGET_LOCATIONS_FIELD, TAGS_FIELD));

    private final String documentName;

    private final String documentVersion;

    private final Map<String, List<String>> parameters;

    private final String clientToken;

    private final String mode;

    private final String targetParameterName;

    private final List<Target> targets;

    private final List<Map<String, List<String>>> targetMaps;

    private final String maxConcurrency;

    private final String maxErrors;

    private final List<TargetLocation> targetLocations;

    private final List<Tag> tags;

    private StartAutomationExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.parameters = builder.parameters;
        this.clientToken = builder.clientToken;
        this.mode = builder.mode;
        this.targetParameterName = builder.targetParameterName;
        this.targets = builder.targets;
        this.targetMaps = builder.targetMaps;
        this.maxConcurrency = builder.maxConcurrency;
        this.maxErrors = builder.maxErrors;
        this.targetLocations = builder.targetLocations;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the SSM document to run. This can be a public document or a custom document. To run a shared document
     * belonging to another account, specify the document ARN. For more information about how to use shared documents,
     * see <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared SSM
     * documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * 
     * @return The name of the SSM document to run. This can be a public document or a custom document. To run a shared
     *         document belonging to another account, specify the document ARN. For more information about how to use
     *         shared documents, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared
     *         SSM documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     */
    public final String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The version of the Automation runbook to use for this execution.
     * </p>
     * 
     * @return The version of the Automation runbook to use for this execution.
     */
    public final String documentVersion() {
        return documentVersion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A key-value map of execution parameters, which match the declared parameters in the Automation runbook.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return A key-value map of execution parameters, which match the declared parameters in the Automation runbook.
     */
    public final Map<String, List<String>> parameters() {
        return parameters;
    }

    /**
     * <p>
     * User-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and
     * can't be reused.
     * </p>
     * 
     * @return User-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format,
     *         and can't be reused.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The execution mode of the automation. Valid modes include the following: Auto and Interactive. The default mode
     * is Auto.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The execution mode of the automation. Valid modes include the following: Auto and Interactive. The
     *         default mode is Auto.
     * @see ExecutionMode
     */
    public final ExecutionMode mode() {
        return ExecutionMode.fromValue(mode);
    }

    /**
     * <p>
     * The execution mode of the automation. Valid modes include the following: Auto and Interactive. The default mode
     * is Auto.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The execution mode of the automation. Valid modes include the following: Auto and Interactive. The
     *         default mode is Auto.
     * @see ExecutionMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The name of the parameter used as the target resource for the rate-controlled execution. Required if you specify
     * targets.
     * </p>
     * 
     * @return The name of the parameter used as the target resource for the rate-controlled execution. Required if you
     *         specify targets.
     */
    public final String targetParameterName() {
        return targetParameterName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Targets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargets() {
        return targets != null && !(targets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A key-value mapping to target resources. Required if you specify TargetParameterName.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargets} method.
     * </p>
     * 
     * @return A key-value mapping to target resources. Required if you specify TargetParameterName.
     */
    public final List<Target> targets() {
        return targets;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetMaps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTargetMaps() {
        return targetMaps != null && !(targetMaps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be specified
     * together.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetMaps} method.
     * </p>
     * 
     * @return A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
     *         specified together.
     */
    public final List<Map<String, List<String>>> targetMaps() {
        return targetMaps;
    }

    /**
     * <p>
     * The maximum number of targets allowed to run this task in parallel. You can specify a number, such as 10, or a
     * percentage, such as 10%. The default value is <code>10</code>.
     * </p>
     * 
     * @return The maximum number of targets allowed to run this task in parallel. You can specify a number, such as 10,
     *         or a percentage, such as 10%. The default value is <code>10</code>.
     */
    public final String maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The number of errors that are allowed before the system stops running the automation on additional targets. You
     * can specify either an absolute number of errors, for example 10, or a percentage of the target set, for example
     * 10%. If you specify 3, for example, the system stops running the automation when the fourth error is received. If
     * you specify 0, then the system stops running the automation on additional targets after the first error result is
     * returned. If you run an automation on 50 resources and set max-errors to 10%, then the system stops running the
     * automation on additional targets when the sixth error is received.
     * </p>
     * <p>
     * Executions that are already running an automation when max-errors is reached are allowed to complete, but some of
     * these executions may fail as well. If you need to ensure that there won't be more than max-errors failed
     * executions, set max-concurrency to 1 so the executions proceed one at a time.
     * </p>
     * 
     * @return The number of errors that are allowed before the system stops running the automation on additional
     *         targets. You can specify either an absolute number of errors, for example 10, or a percentage of the
     *         target set, for example 10%. If you specify 3, for example, the system stops running the automation when
     *         the fourth error is received. If you specify 0, then the system stops running the automation on
     *         additional targets after the first error result is returned. If you run an automation on 50 resources and
     *         set max-errors to 10%, then the system stops running the automation on additional targets when the sixth
     *         error is received.</p>
     *         <p>
     *         Executions that are already running an automation when max-errors is reached are allowed to complete, but
     *         some of these executions may fail as well. If you need to ensure that there won't be more than max-errors
     *         failed executions, set max-concurrency to 1 so the executions proceed one at a time.
     */
    public final String maxErrors() {
        return maxErrors;
    }

    /**
     * For responses, this returns true if the service returned a value for the TargetLocations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTargetLocations() {
        return targetLocations != null && !(targetLocations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want to
     * run the automation. Use this operation to start an automation in multiple Amazon Web Services Regions and
     * multiple Amazon Web Services accounts. For more information, see <a href=
     * "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
     * >Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services accounts</a> in the
     * <i>Amazon Web Services Systems Manager User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTargetLocations} method.
     * </p>
     * 
     * @return A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you
     *         want to run the automation. Use this operation to start an automation in multiple Amazon Web Services
     *         Regions and multiple Amazon Web Services accounts. For more information, see <a href=
     *         "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
     *         >Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services
     *         accounts</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     */
    public final List<TargetLocation> targetLocations() {
        return targetLocations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional metadata that you assign to a resource. You can specify a maximum of five tags for an automation. Tags
     * enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For example,
     * you might want to tag an automation to identify an environment or operating system. In this case, you could
     * specify the following key-value pairs:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Key=environment,Value=test</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Key=OS,Value=Windows</code>
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * To add tags to an existing automation, use the <a>AddTagsToResource</a> operation.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional metadata that you assign to a resource. You can specify a maximum of five tags for an
     *         automation. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or
     *         environment. For example, you might want to tag an automation to identify an environment or operating
     *         system. In this case, you could specify the following key-value pairs:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Key=environment,Value=test</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>Key=OS,Value=Windows</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         To add tags to an existing automation, use the <a>AddTagsToResource</a> operation.
     *         </p>
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetParameterName());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargets() ? targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetMaps() ? targetMaps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(maxErrors());
        hashCode = 31 * hashCode + Objects.hashCode(hasTargetLocations() ? targetLocations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartAutomationExecutionRequest)) {
            return false;
        }
        StartAutomationExecutionRequest other = (StartAutomationExecutionRequest) obj;
        return Objects.equals(documentName(), other.documentName()) && Objects.equals(documentVersion(), other.documentVersion())
                && hasParameters() == other.hasParameters() && Objects.equals(parameters(), other.parameters())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(targetParameterName(), other.targetParameterName()) && hasTargets() == other.hasTargets()
                && Objects.equals(targets(), other.targets()) && hasTargetMaps() == other.hasTargetMaps()
                && Objects.equals(targetMaps(), other.targetMaps()) && Objects.equals(maxConcurrency(), other.maxConcurrency())
                && Objects.equals(maxErrors(), other.maxErrors()) && hasTargetLocations() == other.hasTargetLocations()
                && Objects.equals(targetLocations(), other.targetLocations()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartAutomationExecutionRequest").add("DocumentName", documentName())
                .add("DocumentVersion", documentVersion()).add("Parameters", hasParameters() ? parameters() : null)
                .add("ClientToken", clientToken()).add("Mode", modeAsString()).add("TargetParameterName", targetParameterName())
                .add("Targets", hasTargets() ? targets() : null).add("TargetMaps", hasTargetMaps() ? targetMaps() : null)
                .add("MaxConcurrency", maxConcurrency()).add("MaxErrors", maxErrors())
                .add("TargetLocations", hasTargetLocations() ? targetLocations() : null).add("Tags", hasTags() ? tags() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DocumentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "TargetParameterName":
            return Optional.ofNullable(clazz.cast(targetParameterName()));
        case "Targets":
            return Optional.ofNullable(clazz.cast(targets()));
        case "TargetMaps":
            return Optional.ofNullable(clazz.cast(targetMaps()));
        case "MaxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "MaxErrors":
            return Optional.ofNullable(clazz.cast(maxErrors()));
        case "TargetLocations":
            return Optional.ofNullable(clazz.cast(targetLocations()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartAutomationExecutionRequest, T> g) {
        return obj -> g.apply((StartAutomationExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartAutomationExecutionRequest> {
        /**
         * <p>
         * The name of the SSM document to run. This can be a public document or a custom document. To run a shared
         * document belonging to another account, specify the document ARN. For more information about how to use shared
         * documents, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared SSM
         * documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
         * </p>
         * 
         * @param documentName
         *        The name of the SSM document to run. This can be a public document or a custom document. To run a
         *        shared document belonging to another account, specify the document ARN. For more information about how
         *        to use shared documents, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-using-shared.html">Using shared
         *        SSM documents</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The version of the Automation runbook to use for this execution.
         * </p>
         * 
         * @param documentVersion
         *        The version of the Automation runbook to use for this execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * A key-value map of execution parameters, which match the declared parameters in the Automation runbook.
         * </p>
         * 
         * @param parameters
         *        A key-value map of execution parameters, which match the declared parameters in the Automation
         *        runbook.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ? extends Collection<String>> parameters);

        /**
         * <p>
         * User-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID format, and
         * can't be reused.
         * </p>
         * 
         * @param clientToken
         *        User-provided idempotency token. The token must be unique, is case insensitive, enforces the UUID
         *        format, and can't be reused.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The execution mode of the automation. Valid modes include the following: Auto and Interactive. The default
         * mode is Auto.
         * </p>
         * 
         * @param mode
         *        The execution mode of the automation. Valid modes include the following: Auto and Interactive. The
         *        default mode is Auto.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The execution mode of the automation. Valid modes include the following: Auto and Interactive. The default
         * mode is Auto.
         * </p>
         * 
         * @param mode
         *        The execution mode of the automation. Valid modes include the following: Auto and Interactive. The
         *        default mode is Auto.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder mode(ExecutionMode mode);

        /**
         * <p>
         * The name of the parameter used as the target resource for the rate-controlled execution. Required if you
         * specify targets.
         * </p>
         * 
         * @param targetParameterName
         *        The name of the parameter used as the target resource for the rate-controlled execution. Required if
         *        you specify targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetParameterName(String targetParameterName);

        /**
         * <p>
         * A key-value mapping to target resources. Required if you specify TargetParameterName.
         * </p>
         * 
         * @param targets
         *        A key-value mapping to target resources. Required if you specify TargetParameterName.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Collection<Target> targets);

        /**
         * <p>
         * A key-value mapping to target resources. Required if you specify TargetParameterName.
         * </p>
         * 
         * @param targets
         *        A key-value mapping to target resources. Required if you specify TargetParameterName.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targets(Target... targets);

        /**
         * <p>
         * A key-value mapping to target resources. Required if you specify TargetParameterName.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<Target>.Builder} avoiding the need
         * to create one manually via {@link List<Target>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Target>.Builder#build()} is called immediately and its
         * result is passed to {@link #targets(List<Target>)}.
         * 
         * @param targets
         *        a consumer that will call methods on {@link List<Target>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targets(List<Target>)
         */
        Builder targets(Consumer<Target.Builder>... targets);

        /**
         * <p>
         * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
         * specified together.
         * </p>
         * 
         * @param targetMaps
         *        A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
         *        specified together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps);

        /**
         * <p>
         * A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
         * specified together.
         * </p>
         * 
         * @param targetMaps
         *        A key-value mapping of document parameters to target resources. Both Targets and TargetMaps can't be
         *        specified together.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMaps(Map<String, ? extends Collection<String>>... targetMaps);

        /**
         * <p>
         * The maximum number of targets allowed to run this task in parallel. You can specify a number, such as 10, or
         * a percentage, such as 10%. The default value is <code>10</code>.
         * </p>
         * 
         * @param maxConcurrency
         *        The maximum number of targets allowed to run this task in parallel. You can specify a number, such as
         *        10, or a percentage, such as 10%. The default value is <code>10</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(String maxConcurrency);

        /**
         * <p>
         * The number of errors that are allowed before the system stops running the automation on additional targets.
         * You can specify either an absolute number of errors, for example 10, or a percentage of the target set, for
         * example 10%. If you specify 3, for example, the system stops running the automation when the fourth error is
         * received. If you specify 0, then the system stops running the automation on additional targets after the
         * first error result is returned. If you run an automation on 50 resources and set max-errors to 10%, then the
         * system stops running the automation on additional targets when the sixth error is received.
         * </p>
         * <p>
         * Executions that are already running an automation when max-errors is reached are allowed to complete, but
         * some of these executions may fail as well. If you need to ensure that there won't be more than max-errors
         * failed executions, set max-concurrency to 1 so the executions proceed one at a time.
         * </p>
         * 
         * @param maxErrors
         *        The number of errors that are allowed before the system stops running the automation on additional
         *        targets. You can specify either an absolute number of errors, for example 10, or a percentage of the
         *        target set, for example 10%. If you specify 3, for example, the system stops running the automation
         *        when the fourth error is received. If you specify 0, then the system stops running the automation on
         *        additional targets after the first error result is returned. If you run an automation on 50 resources
         *        and set max-errors to 10%, then the system stops running the automation on additional targets when the
         *        sixth error is received.</p>
         *        <p>
         *        Executions that are already running an automation when max-errors is reached are allowed to complete,
         *        but some of these executions may fail as well. If you need to ensure that there won't be more than
         *        max-errors failed executions, set max-concurrency to 1 so the executions proceed one at a time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxErrors(String maxErrors);

        /**
         * <p>
         * A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want
         * to run the automation. Use this operation to start an automation in multiple Amazon Web Services Regions and
         * multiple Amazon Web Services accounts. For more information, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
         * >Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services accounts</a> in
         * the <i>Amazon Web Services Systems Manager User Guide</i>.
         * </p>
         * 
         * @param targetLocations
         *        A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where
         *        you want to run the automation. Use this operation to start an automation in multiple Amazon Web
         *        Services Regions and multiple Amazon Web Services accounts. For more information, see <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
         *        >Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services
         *        accounts</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocations(Collection<TargetLocation> targetLocations);

        /**
         * <p>
         * A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want
         * to run the automation. Use this operation to start an automation in multiple Amazon Web Services Regions and
         * multiple Amazon Web Services accounts. For more information, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
         * >Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services accounts</a> in
         * the <i>Amazon Web Services Systems Manager User Guide</i>.
         * </p>
         * 
         * @param targetLocations
         *        A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where
         *        you want to run the automation. Use this operation to start an automation in multiple Amazon Web
         *        Services Regions and multiple Amazon Web Services accounts. For more information, see <a href=
         *        "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
         *        >Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services
         *        accounts</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocations(TargetLocation... targetLocations);

        /**
         * <p>
         * A location is a combination of Amazon Web Services Regions and/or Amazon Web Services accounts where you want
         * to run the automation. Use this operation to start an automation in multiple Amazon Web Services Regions and
         * multiple Amazon Web Services accounts. For more information, see <a href=
         * "https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html"
         * >Running Automation workflows in multiple Amazon Web Services Regions and Amazon Web Services accounts</a> in
         * the <i>Amazon Web Services Systems Manager User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<TargetLocation>.Builder} avoiding
         * the need to create one manually via {@link List<TargetLocation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TargetLocation>.Builder#build()} is called immediately and
         * its result is passed to {@link #targetLocations(List<TargetLocation>)}.
         * 
         * @param targetLocations
         *        a consumer that will call methods on {@link List<TargetLocation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetLocations(List<TargetLocation>)
         */
        Builder targetLocations(Consumer<TargetLocation.Builder>... targetLocations);

        /**
         * <p>
         * Optional metadata that you assign to a resource. You can specify a maximum of five tags for an automation.
         * Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For
         * example, you might want to tag an automation to identify an environment or operating system. In this case,
         * you could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=environment,Value=test</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * To add tags to an existing automation, use the <a>AddTagsToResource</a> operation.
         * </p>
         * </note>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. You can specify a maximum of five tags for an
         *        automation. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or
         *        environment. For example, you might want to tag an automation to identify an environment or operating
         *        system. In this case, you could specify the following key-value pairs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key=environment,Value=test</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=OS,Value=Windows</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        To add tags to an existing automation, use the <a>AddTagsToResource</a> operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Optional metadata that you assign to a resource. You can specify a maximum of five tags for an automation.
         * Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For
         * example, you might want to tag an automation to identify an environment or operating system. In this case,
         * you could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=environment,Value=test</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * To add tags to an existing automation, use the <a>AddTagsToResource</a> operation.
         * </p>
         * </note>
         * 
         * @param tags
         *        Optional metadata that you assign to a resource. You can specify a maximum of five tags for an
         *        automation. Tags enable you to categorize a resource in different ways, such as by purpose, owner, or
         *        environment. For example, you might want to tag an automation to identify an environment or operating
         *        system. In this case, you could specify the following key-value pairs:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Key=environment,Value=test</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>Key=OS,Value=Windows</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        To add tags to an existing automation, use the <a>AddTagsToResource</a> operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Optional metadata that you assign to a resource. You can specify a maximum of five tags for an automation.
         * Tags enable you to categorize a resource in different ways, such as by purpose, owner, or environment. For
         * example, you might want to tag an automation to identify an environment or operating system. In this case,
         * you could specify the following key-value pairs:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Key=environment,Value=test</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>Key=OS,Value=Windows</code>
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * To add tags to an existing automation, use the <a>AddTagsToResource</a> operation.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link List<Tag>.Builder} avoiding the
         * need to create one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SsmRequest.BuilderImpl implements Builder {
        private String documentName;

        private String documentVersion;

        private Map<String, List<String>> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private String mode;

        private String targetParameterName;

        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();

        private List<Map<String, List<String>>> targetMaps = DefaultSdkAutoConstructList.getInstance();

        private String maxConcurrency;

        private String maxErrors;

        private List<TargetLocation> targetLocations = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartAutomationExecutionRequest model) {
            super(model);
            documentName(model.documentName);
            documentVersion(model.documentVersion);
            parameters(model.parameters);
            clientToken(model.clientToken);
            mode(model.mode);
            targetParameterName(model.targetParameterName);
            targets(model.targets);
            targetMaps(model.targetMaps);
            maxConcurrency(model.maxConcurrency);
            maxErrors(model.maxErrors);
            targetLocations(model.targetLocations);
            tags(model.tags);
        }

        public final String getDocumentName() {
            return documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getParameters() {
            if (parameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return parameters;
        }

        public final void setParameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<String>> parameters) {
            this.parameters = AutomationParameterMapCopier.copy(parameters);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getTargetParameterName() {
            return targetParameterName;
        }

        public final void setTargetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
        }

        @Override
        public final Builder targetParameterName(String targetParameterName) {
            this.targetParameterName = targetParameterName;
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Target... targets) {
            targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder>... targets) {
            targets(Stream.of(targets).map(c -> Target.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<? extends Map<String, ? extends Collection<String>>> getTargetMaps() {
            if (targetMaps instanceof SdkAutoConstructList) {
                return null;
            }
            return targetMaps;
        }

        public final void setTargetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
        }

        @Override
        public final Builder targetMaps(Collection<? extends Map<String, ? extends Collection<String>>> targetMaps) {
            this.targetMaps = TargetMapsCopier.copy(targetMaps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetMaps(Map<String, ? extends Collection<String>>... targetMaps) {
            targetMaps(Arrays.asList(targetMaps));
            return this;
        }

        public final String getMaxConcurrency() {
            return maxConcurrency;
        }

        public final void setMaxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(String maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final String getMaxErrors() {
            return maxErrors;
        }

        public final void setMaxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
        }

        @Override
        public final Builder maxErrors(String maxErrors) {
            this.maxErrors = maxErrors;
            return this;
        }

        public final List<TargetLocation.Builder> getTargetLocations() {
            List<TargetLocation.Builder> result = TargetLocationsCopier.copyToBuilder(this.targetLocations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargetLocations(Collection<TargetLocation.BuilderImpl> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copyFromBuilder(targetLocations);
        }

        @Override
        public final Builder targetLocations(Collection<TargetLocation> targetLocations) {
            this.targetLocations = TargetLocationsCopier.copy(targetLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(TargetLocation... targetLocations) {
            targetLocations(Arrays.asList(targetLocations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetLocations(Consumer<TargetLocation.Builder>... targetLocations) {
            targetLocations(Stream.of(targetLocations).map(c -> TargetLocation.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartAutomationExecutionRequest build() {
            return new StartAutomationExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
