/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociationStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<AssociationStatus.Builder, AssociationStatus> {
    private static final SdkField<Instant> DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("Date")
            .getter(getter(AssociationStatus::date)).setter(setter(Builder::date))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Date").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AssociationStatus::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(AssociationStatus::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<String> ADDITIONAL_INFO_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AdditionalInfo").getter(getter(AssociationStatus::additionalInfo))
            .setter(setter(Builder::additionalInfo))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATE_FIELD, NAME_FIELD,
            MESSAGE_FIELD, ADDITIONAL_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant date;

    private final String name;

    private final String message;

    private final String additionalInfo;

    private AssociationStatus(BuilderImpl builder) {
        this.date = builder.date;
        this.name = builder.name;
        this.message = builder.message;
        this.additionalInfo = builder.additionalInfo;
    }

    /**
     * <p>
     * The date when the status changed.
     * </p>
     * 
     * @return The date when the status changed.
     */
    public final Instant date() {
        return date;
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AssociationStatusName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The status.
     * @see AssociationStatusName
     */
    public final AssociationStatusName name() {
        return AssociationStatusName.fromValue(name);
    }

    /**
     * <p>
     * The status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AssociationStatusName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The status.
     * @see AssociationStatusName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The reason for the status.
     * </p>
     * 
     * @return The reason for the status.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * A user-defined string.
     * </p>
     * 
     * @return A user-defined string.
     */
    public final String additionalInfo() {
        return additionalInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(date());
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(additionalInfo());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociationStatus)) {
            return false;
        }
        AssociationStatus other = (AssociationStatus) obj;
        return Objects.equals(date(), other.date()) && Objects.equals(nameAsString(), other.nameAsString())
                && Objects.equals(message(), other.message()) && Objects.equals(additionalInfo(), other.additionalInfo());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociationStatus").add("Date", date()).add("Name", nameAsString()).add("Message", message())
                .add("AdditionalInfo", additionalInfo()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Date":
            return Optional.ofNullable(clazz.cast(date()));
        case "Name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "AdditionalInfo":
            return Optional.ofNullable(clazz.cast(additionalInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociationStatus, T> g) {
        return obj -> g.apply((AssociationStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AssociationStatus> {
        /**
         * <p>
         * The date when the status changed.
         * </p>
         * 
         * @param date
         *        The date when the status changed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder date(Instant date);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param name
         *        The status.
         * @see AssociationStatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationStatusName
         */
        Builder name(String name);

        /**
         * <p>
         * The status.
         * </p>
         * 
         * @param name
         *        The status.
         * @see AssociationStatusName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationStatusName
         */
        Builder name(AssociationStatusName name);

        /**
         * <p>
         * The reason for the status.
         * </p>
         * 
         * @param message
         *        The reason for the status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * A user-defined string.
         * </p>
         * 
         * @param additionalInfo
         *        A user-defined string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(String additionalInfo);
    }

    static final class BuilderImpl implements Builder {
        private Instant date;

        private String name;

        private String message;

        private String additionalInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociationStatus model) {
            date(model.date);
            name(model.name);
            message(model.message);
            additionalInfo(model.additionalInfo);
        }

        public final Instant getDate() {
            return date;
        }

        public final void setDate(Instant date) {
            this.date = date;
        }

        @Override
        @Transient
        public final Builder date(Instant date) {
            this.date = date;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        @Transient
        public final Builder name(AssociationStatusName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        @Transient
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getAdditionalInfo() {
            return additionalInfo;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        @Override
        @Transient
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        @Override
        public AssociationStatus build() {
            return new AssociationStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
