/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribePatchGroupsResponse extends SsmResponse implements
        ToCopyableBuilder<DescribePatchGroupsResponse.Builder, DescribePatchGroupsResponse> {
    private static final SdkField<List<PatchGroupPatchBaselineMapping>> MAPPINGS_FIELD = SdkField
            .<List<PatchGroupPatchBaselineMapping>> builder(MarshallingType.LIST)
            .memberName("Mappings")
            .getter(getter(DescribePatchGroupsResponse::mappings))
            .setter(setter(Builder::mappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PatchGroupPatchBaselineMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(PatchGroupPatchBaselineMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribePatchGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAPPINGS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PatchGroupPatchBaselineMapping> mappings;

    private final String nextToken;

    private DescribePatchGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.mappings = builder.mappings;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Mappings property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMappings() {
        return mappings != null && !(mappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Each entry in the array contains:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PatchGroup</code>: string (between 1 and 256 characters. Regex:
     * <code>^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMappings} method.
     * </p>
     * 
     * @return Each entry in the array contains:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PatchGroup</code>: string (between 1 and 256 characters. Regex:
     *         <code>^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.
     *         </p>
     *         </li>
     */
    public final List<PatchGroupPatchBaselineMapping> mappings() {
        return mappings;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasMappings() ? mappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribePatchGroupsResponse)) {
            return false;
        }
        DescribePatchGroupsResponse other = (DescribePatchGroupsResponse) obj;
        return hasMappings() == other.hasMappings() && Objects.equals(mappings(), other.mappings())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribePatchGroupsResponse").add("Mappings", hasMappings() ? mappings() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Mappings":
            return Optional.ofNullable(clazz.cast(mappings()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribePatchGroupsResponse, T> g) {
        return obj -> g.apply((DescribePatchGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribePatchGroupsResponse> {
        /**
         * <p>
         * Each entry in the array contains:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PatchGroup</code>: string (between 1 and 256 characters. Regex:
         * <code>^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mappings
         *        Each entry in the array contains:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PatchGroup</code>: string (between 1 and 256 characters. Regex:
         *        <code>^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappings(Collection<PatchGroupPatchBaselineMapping> mappings);

        /**
         * <p>
         * Each entry in the array contains:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PatchGroup</code>: string (between 1 and 256 characters. Regex:
         * <code>^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.
         * </p>
         * </li>
         * </ul>
         * 
         * @param mappings
         *        Each entry in the array contains:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PatchGroup</code>: string (between 1 and 256 characters. Regex:
         *        <code>^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mappings(PatchGroupPatchBaselineMapping... mappings);

        /**
         * <p>
         * Each entry in the array contains:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PatchGroup</code>: string (between 1 and 256 characters. Regex:
         * <code>^([\p{L}\p{Z}\p{N}_.:/=+\-@]*)$)</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PatchBaselineIdentity</code>: A <code>PatchBaselineIdentity</code> element.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link List<PatchGroupPatchBaselineMapping>.Builder}
         * avoiding the need to create one manually via {@link List<PatchGroupPatchBaselineMapping>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PatchGroupPatchBaselineMapping>.Builder#build()} is called
         * immediately and its result is passed to {@link #mappings(List<PatchGroupPatchBaselineMapping>)}.
         * 
         * @param mappings
         *        a consumer that will call methods on {@link List<PatchGroupPatchBaselineMapping>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mappings(List<PatchGroupPatchBaselineMapping>)
         */
        Builder mappings(Consumer<PatchGroupPatchBaselineMapping.Builder>... mappings);

        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private List<PatchGroupPatchBaselineMapping> mappings = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribePatchGroupsResponse model) {
            super(model);
            mappings(model.mappings);
            nextToken(model.nextToken);
        }

        public final List<PatchGroupPatchBaselineMapping.Builder> getMappings() {
            List<PatchGroupPatchBaselineMapping.Builder> result = PatchGroupPatchBaselineMappingListCopier
                    .copyToBuilder(this.mappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMappings(Collection<PatchGroupPatchBaselineMapping.BuilderImpl> mappings) {
            this.mappings = PatchGroupPatchBaselineMappingListCopier.copyFromBuilder(mappings);
        }

        @Override
        @Transient
        public final Builder mappings(Collection<PatchGroupPatchBaselineMapping> mappings) {
            this.mappings = PatchGroupPatchBaselineMappingListCopier.copy(mappings);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mappings(PatchGroupPatchBaselineMapping... mappings) {
            mappings(Arrays.asList(mappings));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder mappings(Consumer<PatchGroupPatchBaselineMapping.Builder>... mappings) {
            mappings(Stream.of(mappings).map(c -> PatchGroupPatchBaselineMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribePatchGroupsResponse build() {
            return new DescribePatchGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
