/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the response to a document review request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DocumentMetadataResponseInfo implements SdkPojo, Serializable,
        ToCopyableBuilder<DocumentMetadataResponseInfo.Builder, DocumentMetadataResponseInfo> {
    private static final SdkField<List<DocumentReviewerResponseSource>> REVIEWER_RESPONSE_FIELD = SdkField
            .<List<DocumentReviewerResponseSource>> builder(MarshallingType.LIST)
            .memberName("ReviewerResponse")
            .getter(getter(DocumentMetadataResponseInfo::reviewerResponse))
            .setter(setter(Builder::reviewerResponse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewerResponse").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentReviewerResponseSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentReviewerResponseSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REVIEWER_RESPONSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<DocumentReviewerResponseSource> reviewerResponse;

    private DocumentMetadataResponseInfo(BuilderImpl builder) {
        this.reviewerResponse = builder.reviewerResponse;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReviewerResponse property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReviewerResponse() {
        return reviewerResponse != null && !(reviewerResponse instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about a reviewer's response to a document review request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReviewerResponse} method.
     * </p>
     * 
     * @return Details about a reviewer's response to a document review request.
     */
    public final List<DocumentReviewerResponseSource> reviewerResponse() {
        return reviewerResponse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasReviewerResponse() ? reviewerResponse() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentMetadataResponseInfo)) {
            return false;
        }
        DocumentMetadataResponseInfo other = (DocumentMetadataResponseInfo) obj;
        return hasReviewerResponse() == other.hasReviewerResponse()
                && Objects.equals(reviewerResponse(), other.reviewerResponse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DocumentMetadataResponseInfo")
                .add("ReviewerResponse", hasReviewerResponse() ? reviewerResponse() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ReviewerResponse":
            return Optional.ofNullable(clazz.cast(reviewerResponse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DocumentMetadataResponseInfo, T> g) {
        return obj -> g.apply((DocumentMetadataResponseInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DocumentMetadataResponseInfo> {
        /**
         * <p>
         * Details about a reviewer's response to a document review request.
         * </p>
         * 
         * @param reviewerResponse
         *        Details about a reviewer's response to a document review request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewerResponse(Collection<DocumentReviewerResponseSource> reviewerResponse);

        /**
         * <p>
         * Details about a reviewer's response to a document review request.
         * </p>
         * 
         * @param reviewerResponse
         *        Details about a reviewer's response to a document review request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewerResponse(DocumentReviewerResponseSource... reviewerResponse);

        /**
         * <p>
         * Details about a reviewer's response to a document review request.
         * </p>
         * This is a convenience method that creates an instance of the {@link List
         * <DocumentReviewerResponseSource>.Builder} avoiding the need to create one manually via {@link List
         * <DocumentReviewerResponseSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentReviewerResponseSource>.Builder#build()} is called
         * immediately and its result is passed to {@link #reviewerResponse(List<DocumentReviewerResponseSource>)}.
         * 
         * @param reviewerResponse
         *        a consumer that will call methods on {@link List<DocumentReviewerResponseSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reviewerResponse(List<DocumentReviewerResponseSource>)
         */
        Builder reviewerResponse(Consumer<DocumentReviewerResponseSource.Builder>... reviewerResponse);
    }

    static final class BuilderImpl implements Builder {
        private List<DocumentReviewerResponseSource> reviewerResponse = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentMetadataResponseInfo model) {
            reviewerResponse(model.reviewerResponse);
        }

        public final List<DocumentReviewerResponseSource.Builder> getReviewerResponse() {
            List<DocumentReviewerResponseSource.Builder> result = DocumentReviewerResponseListCopier
                    .copyToBuilder(this.reviewerResponse);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReviewerResponse(Collection<DocumentReviewerResponseSource.BuilderImpl> reviewerResponse) {
            this.reviewerResponse = DocumentReviewerResponseListCopier.copyFromBuilder(reviewerResponse);
        }

        @Override
        public final Builder reviewerResponse(Collection<DocumentReviewerResponseSource> reviewerResponse) {
            this.reviewerResponse = DocumentReviewerResponseListCopier.copy(reviewerResponse);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewerResponse(DocumentReviewerResponseSource... reviewerResponse) {
            reviewerResponse(Arrays.asList(reviewerResponse));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reviewerResponse(Consumer<DocumentReviewerResponseSource.Builder>... reviewerResponse) {
            reviewerResponse(Stream.of(reviewerResponse)
                    .map(c -> DocumentReviewerResponseSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DocumentMetadataResponseInfo build() {
            return new DocumentMetadataResponseInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
