/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssm.model.MaintenanceWindowExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MaintenanceWindowExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MaintenanceWindowExecution> {
    private static final SdkField<String> WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WindowId").getter(MaintenanceWindowExecution.getter(MaintenanceWindowExecution::windowId)).setter(MaintenanceWindowExecution.setter(Builder::windowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowId").build()}).build();
    private static final SdkField<String> WINDOW_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("WindowExecutionId").getter(MaintenanceWindowExecution.getter(MaintenanceWindowExecution::windowExecutionId)).setter(MaintenanceWindowExecution.setter(Builder::windowExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowExecutionId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(MaintenanceWindowExecution.getter(MaintenanceWindowExecution::statusAsString)).setter(MaintenanceWindowExecution.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusDetails").getter(MaintenanceWindowExecution.getter(MaintenanceWindowExecution::statusDetails)).setter(MaintenanceWindowExecution.setter(Builder::statusDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(MaintenanceWindowExecution.getter(MaintenanceWindowExecution::startTime)).setter(MaintenanceWindowExecution.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(MaintenanceWindowExecution.getter(MaintenanceWindowExecution::endTime)).setter(MaintenanceWindowExecution.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_ID_FIELD, WINDOW_EXECUTION_ID_FIELD, STATUS_FIELD, STATUS_DETAILS_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String windowId;
    private final String windowExecutionId;
    private final String status;
    private final String statusDetails;
    private final Instant startTime;
    private final Instant endTime;

    private MaintenanceWindowExecution(BuilderImpl builder) {
        this.windowId = builder.windowId;
        this.windowExecutionId = builder.windowExecutionId;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public final String windowId() {
        return this.windowId;
    }

    public final String windowExecutionId() {
        return this.windowExecutionId;
    }

    public final MaintenanceWindowExecutionStatus status() {
        return MaintenanceWindowExecutionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusDetails() {
        return this.statusDetails;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.windowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowExecution)) {
            return false;
        }
        MaintenanceWindowExecution other = (MaintenanceWindowExecution)obj;
        return Objects.equals(this.windowId(), other.windowId()) && Objects.equals(this.windowExecutionId(), other.windowExecutionId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusDetails(), other.statusDetails()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"MaintenanceWindowExecution").add("WindowId", (Object)this.windowId()).add("WindowExecutionId", (Object)this.windowExecutionId()).add("Status", (Object)this.statusAsString()).add("StatusDetails", (Object)this.statusDetails()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "WindowId": {
                return Optional.ofNullable(clazz.cast(this.windowId()));
            }
            case "WindowExecutionId": {
                return Optional.ofNullable(clazz.cast(this.windowExecutionId()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusDetails": {
                return Optional.ofNullable(clazz.cast(this.statusDetails()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowExecution, T> g) {
        return obj -> g.apply((MaintenanceWindowExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String windowId;
        private String windowExecutionId;
        private String status;
        private String statusDetails;
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowExecution model) {
            this.windowId(model.windowId);
            this.windowExecutionId(model.windowExecutionId);
            this.status(model.status);
            this.statusDetails(model.statusDetails);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getWindowId() {
            return this.windowId;
        }

        public final void setWindowId(String windowId) {
            this.windowId = windowId;
        }

        @Override
        public final Builder windowId(String windowId) {
            this.windowId = windowId;
            return this;
        }

        public final String getWindowExecutionId() {
            return this.windowExecutionId;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusDetails() {
            return this.statusDetails;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public MaintenanceWindowExecution build() {
            return new MaintenanceWindowExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MaintenanceWindowExecution> {
        public Builder windowId(String var1);

        public Builder windowExecutionId(String var1);

        public Builder status(String var1);

        public Builder status(MaintenanceWindowExecutionStatus var1);

        public Builder statusDetails(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

