/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCommandInvocationResponse extends SsmResponse implements
        ToCopyableBuilder<GetCommandInvocationResponse.Builder, GetCommandInvocationResponse> {
    private static final SdkField<String> COMMAND_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommandId").getter(getter(GetCommandInvocationResponse::commandId)).setter(setter(Builder::commandId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommandId").build()).build();

    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceId").getter(getter(GetCommandInvocationResponse::instanceId))
            .setter(setter(Builder::instanceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Comment")
            .getter(getter(GetCommandInvocationResponse::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Comment").build()).build();

    private static final SdkField<String> DOCUMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentName").getter(getter(GetCommandInvocationResponse::documentName))
            .setter(setter(Builder::documentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentName").build()).build();

    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DocumentVersion").getter(getter(GetCommandInvocationResponse::documentVersion))
            .setter(setter(Builder::documentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentVersion").build()).build();

    private static final SdkField<String> PLUGIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PluginName").getter(getter(GetCommandInvocationResponse::pluginName))
            .setter(setter(Builder::pluginName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PluginName").build()).build();

    private static final SdkField<Integer> RESPONSE_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ResponseCode").getter(getter(GetCommandInvocationResponse::responseCode))
            .setter(setter(Builder::responseCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode").build()).build();

    private static final SdkField<String> EXECUTION_START_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionStartDateTime").getter(getter(GetCommandInvocationResponse::executionStartDateTime))
            .setter(setter(Builder::executionStartDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartDateTime").build())
            .build();

    private static final SdkField<String> EXECUTION_ELAPSED_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionElapsedTime").getter(getter(GetCommandInvocationResponse::executionElapsedTime))
            .setter(setter(Builder::executionElapsedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionElapsedTime").build())
            .build();

    private static final SdkField<String> EXECUTION_END_DATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionEndDateTime").getter(getter(GetCommandInvocationResponse::executionEndDateTime))
            .setter(setter(Builder::executionEndDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndDateTime").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(GetCommandInvocationResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDetails").getter(getter(GetCommandInvocationResponse::statusDetails))
            .setter(setter(Builder::statusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()).build();

    private static final SdkField<String> STANDARD_OUTPUT_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardOutputContent").getter(getter(GetCommandInvocationResponse::standardOutputContent))
            .setter(setter(Builder::standardOutputContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardOutputContent").build())
            .build();

    private static final SdkField<String> STANDARD_OUTPUT_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardOutputUrl").getter(getter(GetCommandInvocationResponse::standardOutputUrl))
            .setter(setter(Builder::standardOutputUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardOutputUrl").build()).build();

    private static final SdkField<String> STANDARD_ERROR_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardErrorContent").getter(getter(GetCommandInvocationResponse::standardErrorContent))
            .setter(setter(Builder::standardErrorContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardErrorContent").build())
            .build();

    private static final SdkField<String> STANDARD_ERROR_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StandardErrorUrl").getter(getter(GetCommandInvocationResponse::standardErrorUrl))
            .setter(setter(Builder::standardErrorUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StandardErrorUrl").build()).build();

    private static final SdkField<CloudWatchOutputConfig> CLOUD_WATCH_OUTPUT_CONFIG_FIELD = SdkField
            .<CloudWatchOutputConfig> builder(MarshallingType.SDK_POJO).memberName("CloudWatchOutputConfig")
            .getter(getter(GetCommandInvocationResponse::cloudWatchOutputConfig)).setter(setter(Builder::cloudWatchOutputConfig))
            .constructor(CloudWatchOutputConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchOutputConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMMAND_ID_FIELD,
            INSTANCE_ID_FIELD, COMMENT_FIELD, DOCUMENT_NAME_FIELD, DOCUMENT_VERSION_FIELD, PLUGIN_NAME_FIELD,
            RESPONSE_CODE_FIELD, EXECUTION_START_DATE_TIME_FIELD, EXECUTION_ELAPSED_TIME_FIELD, EXECUTION_END_DATE_TIME_FIELD,
            STATUS_FIELD, STATUS_DETAILS_FIELD, STANDARD_OUTPUT_CONTENT_FIELD, STANDARD_OUTPUT_URL_FIELD,
            STANDARD_ERROR_CONTENT_FIELD, STANDARD_ERROR_URL_FIELD, CLOUD_WATCH_OUTPUT_CONFIG_FIELD));

    private final String commandId;

    private final String instanceId;

    private final String comment;

    private final String documentName;

    private final String documentVersion;

    private final String pluginName;

    private final Integer responseCode;

    private final String executionStartDateTime;

    private final String executionElapsedTime;

    private final String executionEndDateTime;

    private final String status;

    private final String statusDetails;

    private final String standardOutputContent;

    private final String standardOutputUrl;

    private final String standardErrorContent;

    private final String standardErrorUrl;

    private final CloudWatchOutputConfig cloudWatchOutputConfig;

    private GetCommandInvocationResponse(BuilderImpl builder) {
        super(builder);
        this.commandId = builder.commandId;
        this.instanceId = builder.instanceId;
        this.comment = builder.comment;
        this.documentName = builder.documentName;
        this.documentVersion = builder.documentVersion;
        this.pluginName = builder.pluginName;
        this.responseCode = builder.responseCode;
        this.executionStartDateTime = builder.executionStartDateTime;
        this.executionElapsedTime = builder.executionElapsedTime;
        this.executionEndDateTime = builder.executionEndDateTime;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.standardOutputContent = builder.standardOutputContent;
        this.standardOutputUrl = builder.standardOutputUrl;
        this.standardErrorContent = builder.standardErrorContent;
        this.standardErrorUrl = builder.standardErrorUrl;
        this.cloudWatchOutputConfig = builder.cloudWatchOutputConfig;
    }

    /**
     * <p>
     * The parent command ID of the invocation plugin.
     * </p>
     * 
     * @return The parent command ID of the invocation plugin.
     */
    public final String commandId() {
        return commandId;
    }

    /**
     * <p>
     * The ID of the managed instance targeted by the command. A managed instance can be an EC2 instance or an instance
     * in your hybrid environment that is configured for Systems Manager.
     * </p>
     * 
     * @return The ID of the managed instance targeted by the command. A managed instance can be an EC2 instance or an
     *         instance in your hybrid environment that is configured for Systems Manager.
     */
    public final String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The comment text for the command.
     * </p>
     * 
     * @return The comment text for the command.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The name of the document that was run. For example, <code>AWS-RunShellScript</code>.
     * </p>
     * 
     * @return The name of the document that was run. For example, <code>AWS-RunShellScript</code>.
     */
    public final String documentName() {
        return documentName;
    }

    /**
     * <p>
     * The Systems Manager document (SSM document) version used in the request.
     * </p>
     * 
     * @return The Systems Manager document (SSM document) version used in the request.
     */
    public final String documentVersion() {
        return documentVersion;
    }

    /**
     * <p>
     * The name of the plugin, or <i>step name</i>, for which details are reported. For example,
     * <code>aws:RunShellScript</code> is a plugin.
     * </p>
     * 
     * @return The name of the plugin, or <i>step name</i>, for which details are reported. For example,
     *         <code>aws:RunShellScript</code> is a plugin.
     */
    public final String pluginName() {
        return pluginName;
    }

    /**
     * <p>
     * The error level response code for the plugin script. If the response code is <code>-1</code>, then the command
     * hasn't started running on the instance, or it wasn't received by the instance.
     * </p>
     * 
     * @return The error level response code for the plugin script. If the response code is <code>-1</code>, then the
     *         command hasn't started running on the instance, or it wasn't received by the instance.
     */
    public final Integer responseCode() {
        return responseCode;
    }

    /**
     * <p>
     * The date and time the plugin started running. Date and time are written in ISO 8601 format. For example, June 7,
     * 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the
     * <code>InvokedBefore</code> filter.
     * </p>
     * <p>
     * <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code>
     * </p>
     * <p>
     * If the plugin hasn't started to run, the string is empty.
     * </p>
     * 
     * @return The date and time the plugin started running. Date and time are written in ISO 8601 format. For example,
     *         June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the
     *         <code>InvokedBefore</code> filter.</p>
     *         <p>
     *         <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code>
     *         </p>
     *         <p>
     *         If the plugin hasn't started to run, the string is empty.
     */
    public final String executionStartDateTime() {
        return executionStartDateTime;
    }

    /**
     * <p>
     * Duration since <code>ExecutionStartDateTime</code>.
     * </p>
     * 
     * @return Duration since <code>ExecutionStartDateTime</code>.
     */
    public final String executionElapsedTime() {
        return executionElapsedTime;
    }

    /**
     * <p>
     * The date and time the plugin finished running. Date and time are written in ISO 8601 format. For example, June 7,
     * 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the
     * <code>InvokedAfter</code> filter.
     * </p>
     * <p>
     * <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code>
     * </p>
     * <p>
     * If the plugin hasn't started to run, the string is empty.
     * </p>
     * 
     * @return The date and time the plugin finished running. Date and time are written in ISO 8601 format. For example,
     *         June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the
     *         <code>InvokedAfter</code> filter.</p>
     *         <p>
     *         <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code>
     *         </p>
     *         <p>
     *         If the plugin hasn't started to run, the string is empty.
     */
    public final String executionEndDateTime() {
        return executionEndDateTime;
    }

    /**
     * <p>
     * The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommandInvocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.
     * @see CommandInvocationStatus
     */
    public final CommandInvocationStatus status() {
        return CommandInvocationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CommandInvocationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.
     * @see CommandInvocationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * A detailed status of the command execution for an invocation. <code>StatusDetails</code> includes more
     * information than <code>Status</code> because it includes states resulting from error and concurrency control
     * parameters. <code>StatusDetails</code> can show different results than <code>Status</code>. For more information
     * about these statuses, see <a
     * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding command
     * statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. <code>StatusDetails</code> can be one
     * of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending: The command hasn't been sent to the instance.
     * </p>
     * </li>
     * <li>
     * <p>
     * In Progress: The command has been sent to the instance but hasn't reached a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delayed: The system attempted to send the command to the target, but the target wasn't available. The instance
     * might not be available because of network issues, because the instance was stopped, or for similar reasons. The
     * system will try to send the command again.
     * </p>
     * </li>
     * <li>
     * <p>
     * Success: The command or plugin ran successfully. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delivery Timed Out: The command wasn't delivered to the instance before the delivery timeout expired. Delivery
     * timeouts don't count against the parent command's <code>MaxErrors</code> limit, but they do contribute to whether
     * the parent command status is Success or Incomplete. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Execution Timed Out: The command started to run on the instance, but the execution wasn't complete before the
     * timeout expired. Execution timeouts count against the <code>MaxErrors</code> limit of the parent command. This is
     * a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed: The command wasn't run successfully on the instance. For a plugin, this indicates that the result code
     * wasn't zero. For a command invocation, this indicates that the result code for one or more plugins wasn't zero.
     * Invocation failures count against the <code>MaxErrors</code> limit of the parent command. This is a terminal
     * state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Canceled: The command was terminated before it was completed. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Undeliverable: The command can't be delivered to the instance. The instance might not exist or might not be
     * responding. Undeliverable invocations don't count against the parent command's <code>MaxErrors</code> limit and
     * don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
     * </p>
     * </li>
     * <li>
     * <p>
     * Terminated: The parent command exceeded its <code>MaxErrors</code> limit and subsequent command invocations were
     * canceled by the system. This is a terminal state.
     * </p>
     * </li>
     * </ul>
     * 
     * @return A detailed status of the command execution for an invocation. <code>StatusDetails</code> includes more
     *         information than <code>Status</code> because it includes states resulting from error and concurrency
     *         control parameters. <code>StatusDetails</code> can show different results than <code>Status</code>. For
     *         more information about these statuses, see <a
     *         href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding
     *         command statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
     *         <code>StatusDetails</code> can be one of the following values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending: The command hasn't been sent to the instance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In Progress: The command has been sent to the instance but hasn't reached a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delayed: The system attempted to send the command to the target, but the target wasn't available. The
     *         instance might not be available because of network issues, because the instance was stopped, or for
     *         similar reasons. The system will try to send the command again.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Success: The command or plugin ran successfully. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delivery Timed Out: The command wasn't delivered to the instance before the delivery timeout expired.
     *         Delivery timeouts don't count against the parent command's <code>MaxErrors</code> limit, but they do
     *         contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Execution Timed Out: The command started to run on the instance, but the execution wasn't complete before
     *         the timeout expired. Execution timeouts count against the <code>MaxErrors</code> limit of the parent
     *         command. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed: The command wasn't run successfully on the instance. For a plugin, this indicates that the result
     *         code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins
     *         wasn't zero. Invocation failures count against the <code>MaxErrors</code> limit of the parent command.
     *         This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Canceled: The command was terminated before it was completed. This is a terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Undeliverable: The command can't be delivered to the instance. The instance might not exist or might not
     *         be responding. Undeliverable invocations don't count against the parent command's <code>MaxErrors</code>
     *         limit and don't contribute to whether the parent command status is Success or Incomplete. This is a
     *         terminal state.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Terminated: The parent command exceeded its <code>MaxErrors</code> limit and subsequent command
     *         invocations were canceled by the system. This is a terminal state.
     *         </p>
     *         </li>
     */
    public final String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The first 24,000 characters written by the plugin to <code>stdout</code>. If the command hasn't finished running,
     * if <code>ExecutionStatus</code> is neither Succeeded nor Failed, then this string is empty.
     * </p>
     * 
     * @return The first 24,000 characters written by the plugin to <code>stdout</code>. If the command hasn't finished
     *         running, if <code>ExecutionStatus</code> is neither Succeeded nor Failed, then this string is empty.
     */
    public final String standardOutputContent() {
        return standardOutputContent;
    }

    /**
     * <p>
     * The URL for the complete text written by the plugin to <code>stdout</code> in Amazon Simple Storage Service
     * (Amazon S3). If an S3 bucket wasn't specified, then this string is empty.
     * </p>
     * 
     * @return The URL for the complete text written by the plugin to <code>stdout</code> in Amazon Simple Storage
     *         Service (Amazon S3). If an S3 bucket wasn't specified, then this string is empty.
     */
    public final String standardOutputUrl() {
        return standardOutputUrl;
    }

    /**
     * <p>
     * The first 8,000 characters written by the plugin to <code>stderr</code>. If the command hasn't finished running,
     * then this string is empty.
     * </p>
     * 
     * @return The first 8,000 characters written by the plugin to <code>stderr</code>. If the command hasn't finished
     *         running, then this string is empty.
     */
    public final String standardErrorContent() {
        return standardErrorContent;
    }

    /**
     * <p>
     * The URL for the complete text written by the plugin to <code>stderr</code>. If the command hasn't finished
     * running, then this string is empty.
     * </p>
     * 
     * @return The URL for the complete text written by the plugin to <code>stderr</code>. If the command hasn't
     *         finished running, then this string is empty.
     */
    public final String standardErrorUrl() {
        return standardErrorUrl;
    }

    /**
     * <p>
     * Amazon CloudWatch Logs information where Systems Manager sent the command output.
     * </p>
     * 
     * @return Amazon CloudWatch Logs information where Systems Manager sent the command output.
     */
    public final CloudWatchOutputConfig cloudWatchOutputConfig() {
        return cloudWatchOutputConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(commandId());
        hashCode = 31 * hashCode + Objects.hashCode(instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(documentName());
        hashCode = 31 * hashCode + Objects.hashCode(documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(pluginName());
        hashCode = 31 * hashCode + Objects.hashCode(responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(executionStartDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionElapsedTime());
        hashCode = 31 * hashCode + Objects.hashCode(executionEndDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(standardOutputContent());
        hashCode = 31 * hashCode + Objects.hashCode(standardOutputUrl());
        hashCode = 31 * hashCode + Objects.hashCode(standardErrorContent());
        hashCode = 31 * hashCode + Objects.hashCode(standardErrorUrl());
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchOutputConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCommandInvocationResponse)) {
            return false;
        }
        GetCommandInvocationResponse other = (GetCommandInvocationResponse) obj;
        return Objects.equals(commandId(), other.commandId()) && Objects.equals(instanceId(), other.instanceId())
                && Objects.equals(comment(), other.comment()) && Objects.equals(documentName(), other.documentName())
                && Objects.equals(documentVersion(), other.documentVersion()) && Objects.equals(pluginName(), other.pluginName())
                && Objects.equals(responseCode(), other.responseCode())
                && Objects.equals(executionStartDateTime(), other.executionStartDateTime())
                && Objects.equals(executionElapsedTime(), other.executionElapsedTime())
                && Objects.equals(executionEndDateTime(), other.executionEndDateTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDetails(), other.statusDetails())
                && Objects.equals(standardOutputContent(), other.standardOutputContent())
                && Objects.equals(standardOutputUrl(), other.standardOutputUrl())
                && Objects.equals(standardErrorContent(), other.standardErrorContent())
                && Objects.equals(standardErrorUrl(), other.standardErrorUrl())
                && Objects.equals(cloudWatchOutputConfig(), other.cloudWatchOutputConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCommandInvocationResponse").add("CommandId", commandId()).add("InstanceId", instanceId())
                .add("Comment", comment()).add("DocumentName", documentName()).add("DocumentVersion", documentVersion())
                .add("PluginName", pluginName()).add("ResponseCode", responseCode())
                .add("ExecutionStartDateTime", executionStartDateTime()).add("ExecutionElapsedTime", executionElapsedTime())
                .add("ExecutionEndDateTime", executionEndDateTime()).add("Status", statusAsString())
                .add("StatusDetails", statusDetails()).add("StandardOutputContent", standardOutputContent())
                .add("StandardOutputUrl", standardOutputUrl()).add("StandardErrorContent", standardErrorContent())
                .add("StandardErrorUrl", standardErrorUrl()).add("CloudWatchOutputConfig", cloudWatchOutputConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CommandId":
            return Optional.ofNullable(clazz.cast(commandId()));
        case "InstanceId":
            return Optional.ofNullable(clazz.cast(instanceId()));
        case "Comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "DocumentName":
            return Optional.ofNullable(clazz.cast(documentName()));
        case "DocumentVersion":
            return Optional.ofNullable(clazz.cast(documentVersion()));
        case "PluginName":
            return Optional.ofNullable(clazz.cast(pluginName()));
        case "ResponseCode":
            return Optional.ofNullable(clazz.cast(responseCode()));
        case "ExecutionStartDateTime":
            return Optional.ofNullable(clazz.cast(executionStartDateTime()));
        case "ExecutionElapsedTime":
            return Optional.ofNullable(clazz.cast(executionElapsedTime()));
        case "ExecutionEndDateTime":
            return Optional.ofNullable(clazz.cast(executionEndDateTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "StandardOutputContent":
            return Optional.ofNullable(clazz.cast(standardOutputContent()));
        case "StandardOutputUrl":
            return Optional.ofNullable(clazz.cast(standardOutputUrl()));
        case "StandardErrorContent":
            return Optional.ofNullable(clazz.cast(standardErrorContent()));
        case "StandardErrorUrl":
            return Optional.ofNullable(clazz.cast(standardErrorUrl()));
        case "CloudWatchOutputConfig":
            return Optional.ofNullable(clazz.cast(cloudWatchOutputConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCommandInvocationResponse, T> g) {
        return obj -> g.apply((GetCommandInvocationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SsmResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCommandInvocationResponse> {
        /**
         * <p>
         * The parent command ID of the invocation plugin.
         * </p>
         * 
         * @param commandId
         *        The parent command ID of the invocation plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandId(String commandId);

        /**
         * <p>
         * The ID of the managed instance targeted by the command. A managed instance can be an EC2 instance or an
         * instance in your hybrid environment that is configured for Systems Manager.
         * </p>
         * 
         * @param instanceId
         *        The ID of the managed instance targeted by the command. A managed instance can be an EC2 instance or
         *        an instance in your hybrid environment that is configured for Systems Manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The comment text for the command.
         * </p>
         * 
         * @param comment
         *        The comment text for the command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The name of the document that was run. For example, <code>AWS-RunShellScript</code>.
         * </p>
         * 
         * @param documentName
         *        The name of the document that was run. For example, <code>AWS-RunShellScript</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentName(String documentName);

        /**
         * <p>
         * The Systems Manager document (SSM document) version used in the request.
         * </p>
         * 
         * @param documentVersion
         *        The Systems Manager document (SSM document) version used in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder documentVersion(String documentVersion);

        /**
         * <p>
         * The name of the plugin, or <i>step name</i>, for which details are reported. For example,
         * <code>aws:RunShellScript</code> is a plugin.
         * </p>
         * 
         * @param pluginName
         *        The name of the plugin, or <i>step name</i>, for which details are reported. For example,
         *        <code>aws:RunShellScript</code> is a plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pluginName(String pluginName);

        /**
         * <p>
         * The error level response code for the plugin script. If the response code is <code>-1</code>, then the
         * command hasn't started running on the instance, or it wasn't received by the instance.
         * </p>
         * 
         * @param responseCode
         *        The error level response code for the plugin script. If the response code is <code>-1</code>, then the
         *        command hasn't started running on the instance, or it wasn't received by the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseCode(Integer responseCode);

        /**
         * <p>
         * The date and time the plugin started running. Date and time are written in ISO 8601 format. For example, June
         * 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the
         * <code>InvokedBefore</code> filter.
         * </p>
         * <p>
         * <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code>
         * </p>
         * <p>
         * If the plugin hasn't started to run, the string is empty.
         * </p>
         * 
         * @param executionStartDateTime
         *        The date and time the plugin started running. Date and time are written in ISO 8601 format. For
         *        example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI
         *        command uses the <code>InvokedBefore</code> filter.</p>
         *        <p>
         *        <code>aws ssm list-commands --filters key=InvokedBefore,value=2017-06-07T00:00:00Z</code>
         *        </p>
         *        <p>
         *        If the plugin hasn't started to run, the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionStartDateTime(String executionStartDateTime);

        /**
         * <p>
         * Duration since <code>ExecutionStartDateTime</code>.
         * </p>
         * 
         * @param executionElapsedTime
         *        Duration since <code>ExecutionStartDateTime</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionElapsedTime(String executionElapsedTime);

        /**
         * <p>
         * The date and time the plugin finished running. Date and time are written in ISO 8601 format. For example,
         * June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI command uses the
         * <code>InvokedAfter</code> filter.
         * </p>
         * <p>
         * <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code>
         * </p>
         * <p>
         * If the plugin hasn't started to run, the string is empty.
         * </p>
         * 
         * @param executionEndDateTime
         *        The date and time the plugin finished running. Date and time are written in ISO 8601 format. For
         *        example, June 7, 2017 is represented as 2017-06-7. The following sample Amazon Web Services CLI
         *        command uses the <code>InvokedAfter</code> filter.</p>
         *        <p>
         *        <code>aws ssm list-commands --filters key=InvokedAfter,value=2017-06-07T00:00:00Z</code>
         *        </p>
         *        <p>
         *        If the plugin hasn't started to run, the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionEndDateTime(String executionEndDateTime);

        /**
         * <p>
         * The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.
         * </p>
         * 
         * @param status
         *        The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.
         * @see CommandInvocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandInvocationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.
         * </p>
         * 
         * @param status
         *        The status of this invocation plugin. This status can be different than <code>StatusDetails</code>.
         * @see CommandInvocationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CommandInvocationStatus
         */
        Builder status(CommandInvocationStatus status);

        /**
         * <p>
         * A detailed status of the command execution for an invocation. <code>StatusDetails</code> includes more
         * information than <code>Status</code> because it includes states resulting from error and concurrency control
         * parameters. <code>StatusDetails</code> can show different results than <code>Status</code>. For more
         * information about these statuses, see <a
         * href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html">Understanding
         * command statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>. <code>StatusDetails</code>
         * can be one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending: The command hasn't been sent to the instance.
         * </p>
         * </li>
         * <li>
         * <p>
         * In Progress: The command has been sent to the instance but hasn't reached a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Delayed: The system attempted to send the command to the target, but the target wasn't available. The
         * instance might not be available because of network issues, because the instance was stopped, or for similar
         * reasons. The system will try to send the command again.
         * </p>
         * </li>
         * <li>
         * <p>
         * Success: The command or plugin ran successfully. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Delivery Timed Out: The command wasn't delivered to the instance before the delivery timeout expired.
         * Delivery timeouts don't count against the parent command's <code>MaxErrors</code> limit, but they do
         * contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Execution Timed Out: The command started to run on the instance, but the execution wasn't complete before the
         * timeout expired. Execution timeouts count against the <code>MaxErrors</code> limit of the parent command.
         * This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed: The command wasn't run successfully on the instance. For a plugin, this indicates that the result
         * code wasn't zero. For a command invocation, this indicates that the result code for one or more plugins
         * wasn't zero. Invocation failures count against the <code>MaxErrors</code> limit of the parent command. This
         * is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Canceled: The command was terminated before it was completed. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Undeliverable: The command can't be delivered to the instance. The instance might not exist or might not be
         * responding. Undeliverable invocations don't count against the parent command's <code>MaxErrors</code> limit
         * and don't contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
         * </p>
         * </li>
         * <li>
         * <p>
         * Terminated: The parent command exceeded its <code>MaxErrors</code> limit and subsequent command invocations
         * were canceled by the system. This is a terminal state.
         * </p>
         * </li>
         * </ul>
         * 
         * @param statusDetails
         *        A detailed status of the command execution for an invocation. <code>StatusDetails</code> includes more
         *        information than <code>Status</code> because it includes states resulting from error and concurrency
         *        control parameters. <code>StatusDetails</code> can show different results than <code>Status</code>.
         *        For more information about these statuses, see <a
         *        href="https://docs.aws.amazon.com/systems-manager/latest/userguide/monitor-commands.html"
         *        >Understanding command statuses</a> in the <i>Amazon Web Services Systems Manager User Guide</i>.
         *        <code>StatusDetails</code> can be one of the following values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending: The command hasn't been sent to the instance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In Progress: The command has been sent to the instance but hasn't reached a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Delayed: The system attempted to send the command to the target, but the target wasn't available. The
         *        instance might not be available because of network issues, because the instance was stopped, or for
         *        similar reasons. The system will try to send the command again.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Success: The command or plugin ran successfully. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Delivery Timed Out: The command wasn't delivered to the instance before the delivery timeout expired.
         *        Delivery timeouts don't count against the parent command's <code>MaxErrors</code> limit, but they do
         *        contribute to whether the parent command status is Success or Incomplete. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Execution Timed Out: The command started to run on the instance, but the execution wasn't complete
         *        before the timeout expired. Execution timeouts count against the <code>MaxErrors</code> limit of the
         *        parent command. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed: The command wasn't run successfully on the instance. For a plugin, this indicates that the
         *        result code wasn't zero. For a command invocation, this indicates that the result code for one or more
         *        plugins wasn't zero. Invocation failures count against the <code>MaxErrors</code> limit of the parent
         *        command. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Canceled: The command was terminated before it was completed. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Undeliverable: The command can't be delivered to the instance. The instance might not exist or might
         *        not be responding. Undeliverable invocations don't count against the parent command's
         *        <code>MaxErrors</code> limit and don't contribute to whether the parent command status is Success or
         *        Incomplete. This is a terminal state.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Terminated: The parent command exceeded its <code>MaxErrors</code> limit and subsequent command
         *        invocations were canceled by the system. This is a terminal state.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * The first 24,000 characters written by the plugin to <code>stdout</code>. If the command hasn't finished
         * running, if <code>ExecutionStatus</code> is neither Succeeded nor Failed, then this string is empty.
         * </p>
         * 
         * @param standardOutputContent
         *        The first 24,000 characters written by the plugin to <code>stdout</code>. If the command hasn't
         *        finished running, if <code>ExecutionStatus</code> is neither Succeeded nor Failed, then this string is
         *        empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardOutputContent(String standardOutputContent);

        /**
         * <p>
         * The URL for the complete text written by the plugin to <code>stdout</code> in Amazon Simple Storage Service
         * (Amazon S3). If an S3 bucket wasn't specified, then this string is empty.
         * </p>
         * 
         * @param standardOutputUrl
         *        The URL for the complete text written by the plugin to <code>stdout</code> in Amazon Simple Storage
         *        Service (Amazon S3). If an S3 bucket wasn't specified, then this string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardOutputUrl(String standardOutputUrl);

        /**
         * <p>
         * The first 8,000 characters written by the plugin to <code>stderr</code>. If the command hasn't finished
         * running, then this string is empty.
         * </p>
         * 
         * @param standardErrorContent
         *        The first 8,000 characters written by the plugin to <code>stderr</code>. If the command hasn't
         *        finished running, then this string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardErrorContent(String standardErrorContent);

        /**
         * <p>
         * The URL for the complete text written by the plugin to <code>stderr</code>. If the command hasn't finished
         * running, then this string is empty.
         * </p>
         * 
         * @param standardErrorUrl
         *        The URL for the complete text written by the plugin to <code>stderr</code>. If the command hasn't
         *        finished running, then this string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder standardErrorUrl(String standardErrorUrl);

        /**
         * <p>
         * Amazon CloudWatch Logs information where Systems Manager sent the command output.
         * </p>
         * 
         * @param cloudWatchOutputConfig
         *        Amazon CloudWatch Logs information where Systems Manager sent the command output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchOutputConfig(CloudWatchOutputConfig cloudWatchOutputConfig);

        /**
         * <p>
         * Amazon CloudWatch Logs information where Systems Manager sent the command output.
         * </p>
         * This is a convenience that creates an instance of the {@link CloudWatchOutputConfig.Builder} avoiding the
         * need to create one manually via {@link CloudWatchOutputConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CloudWatchOutputConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudWatchOutputConfig(CloudWatchOutputConfig)}.
         * 
         * @param cloudWatchOutputConfig
         *        a consumer that will call methods on {@link CloudWatchOutputConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchOutputConfig(CloudWatchOutputConfig)
         */
        default Builder cloudWatchOutputConfig(Consumer<CloudWatchOutputConfig.Builder> cloudWatchOutputConfig) {
            return cloudWatchOutputConfig(CloudWatchOutputConfig.builder().applyMutation(cloudWatchOutputConfig).build());
        }
    }

    static final class BuilderImpl extends SsmResponse.BuilderImpl implements Builder {
        private String commandId;

        private String instanceId;

        private String comment;

        private String documentName;

        private String documentVersion;

        private String pluginName;

        private Integer responseCode;

        private String executionStartDateTime;

        private String executionElapsedTime;

        private String executionEndDateTime;

        private String status;

        private String statusDetails;

        private String standardOutputContent;

        private String standardOutputUrl;

        private String standardErrorContent;

        private String standardErrorUrl;

        private CloudWatchOutputConfig cloudWatchOutputConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCommandInvocationResponse model) {
            super(model);
            commandId(model.commandId);
            instanceId(model.instanceId);
            comment(model.comment);
            documentName(model.documentName);
            documentVersion(model.documentVersion);
            pluginName(model.pluginName);
            responseCode(model.responseCode);
            executionStartDateTime(model.executionStartDateTime);
            executionElapsedTime(model.executionElapsedTime);
            executionEndDateTime(model.executionEndDateTime);
            status(model.status);
            statusDetails(model.statusDetails);
            standardOutputContent(model.standardOutputContent);
            standardOutputUrl(model.standardOutputUrl);
            standardErrorContent(model.standardErrorContent);
            standardErrorUrl(model.standardErrorUrl);
            cloudWatchOutputConfig(model.cloudWatchOutputConfig);
        }

        public final String getCommandId() {
            return commandId;
        }

        public final void setCommandId(String commandId) {
            this.commandId = commandId;
        }

        @Override
        @Transient
        public final Builder commandId(String commandId) {
            this.commandId = commandId;
            return this;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        @Transient
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getDocumentName() {
            return documentName;
        }

        public final void setDocumentName(String documentName) {
            this.documentName = documentName;
        }

        @Override
        @Transient
        public final Builder documentName(String documentName) {
            this.documentName = documentName;
            return this;
        }

        public final String getDocumentVersion() {
            return documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        @Transient
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final String getPluginName() {
            return pluginName;
        }

        public final void setPluginName(String pluginName) {
            this.pluginName = pluginName;
        }

        @Override
        @Transient
        public final Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public final Integer getResponseCode() {
            return responseCode;
        }

        public final void setResponseCode(Integer responseCode) {
            this.responseCode = responseCode;
        }

        @Override
        @Transient
        public final Builder responseCode(Integer responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final String getExecutionStartDateTime() {
            return executionStartDateTime;
        }

        public final void setExecutionStartDateTime(String executionStartDateTime) {
            this.executionStartDateTime = executionStartDateTime;
        }

        @Override
        @Transient
        public final Builder executionStartDateTime(String executionStartDateTime) {
            this.executionStartDateTime = executionStartDateTime;
            return this;
        }

        public final String getExecutionElapsedTime() {
            return executionElapsedTime;
        }

        public final void setExecutionElapsedTime(String executionElapsedTime) {
            this.executionElapsedTime = executionElapsedTime;
        }

        @Override
        @Transient
        public final Builder executionElapsedTime(String executionElapsedTime) {
            this.executionElapsedTime = executionElapsedTime;
            return this;
        }

        public final String getExecutionEndDateTime() {
            return executionEndDateTime;
        }

        public final void setExecutionEndDateTime(String executionEndDateTime) {
            this.executionEndDateTime = executionEndDateTime;
        }

        @Override
        @Transient
        public final Builder executionEndDateTime(String executionEndDateTime) {
            this.executionEndDateTime = executionEndDateTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        @Transient
        public final Builder status(CommandInvocationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        @Override
        @Transient
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final String getStandardOutputContent() {
            return standardOutputContent;
        }

        public final void setStandardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
        }

        @Override
        @Transient
        public final Builder standardOutputContent(String standardOutputContent) {
            this.standardOutputContent = standardOutputContent;
            return this;
        }

        public final String getStandardOutputUrl() {
            return standardOutputUrl;
        }

        public final void setStandardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
        }

        @Override
        @Transient
        public final Builder standardOutputUrl(String standardOutputUrl) {
            this.standardOutputUrl = standardOutputUrl;
            return this;
        }

        public final String getStandardErrorContent() {
            return standardErrorContent;
        }

        public final void setStandardErrorContent(String standardErrorContent) {
            this.standardErrorContent = standardErrorContent;
        }

        @Override
        @Transient
        public final Builder standardErrorContent(String standardErrorContent) {
            this.standardErrorContent = standardErrorContent;
            return this;
        }

        public final String getStandardErrorUrl() {
            return standardErrorUrl;
        }

        public final void setStandardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
        }

        @Override
        @Transient
        public final Builder standardErrorUrl(String standardErrorUrl) {
            this.standardErrorUrl = standardErrorUrl;
            return this;
        }

        public final CloudWatchOutputConfig.Builder getCloudWatchOutputConfig() {
            return cloudWatchOutputConfig != null ? cloudWatchOutputConfig.toBuilder() : null;
        }

        public final void setCloudWatchOutputConfig(CloudWatchOutputConfig.BuilderImpl cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig != null ? cloudWatchOutputConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder cloudWatchOutputConfig(CloudWatchOutputConfig cloudWatchOutputConfig) {
            this.cloudWatchOutputConfig = cloudWatchOutputConfig;
            return this;
        }

        @Override
        public GetCommandInvocationResponse build() {
            return new GetCommandInvocationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
