/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Inventory query results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InventoryResultEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<InventoryResultEntity.Builder, InventoryResultEntity> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(InventoryResultEntity::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Map<String, InventoryResultItem>> DATA_FIELD = SdkField
            .<Map<String, InventoryResultItem>> builder(MarshallingType.MAP)
            .memberName("Data")
            .getter(getter(InventoryResultEntity::data))
            .setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<InventoryResultItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(InventoryResultItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Map<String, InventoryResultItem> data;

    private InventoryResultEntity(BuilderImpl builder) {
        this.id = builder.id;
        this.data = builder.data;
    }

    /**
     * <p>
     * ID of the inventory result entity. For example, for managed instance inventory the result will be the managed
     * instance ID. For EC2 instance inventory, the result will be the instance ID.
     * </p>
     * 
     * @return ID of the inventory result entity. For example, for managed instance inventory the result will be the
     *         managed instance ID. For EC2 instance inventory, the result will be the instance ID.
     */
    public final String id() {
        return id;
    }

    /**
     * For responses, this returns true if the service returned a value for the Data property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasData() {
        return data != null && !(data instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The data section in the inventory result entity JSON.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasData} method.
     * </p>
     * 
     * @return The data section in the inventory result entity JSON.
     */
    public final Map<String, InventoryResultItem> data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(hasData() ? data() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InventoryResultEntity)) {
            return false;
        }
        InventoryResultEntity other = (InventoryResultEntity) obj;
        return Objects.equals(id(), other.id()) && hasData() == other.hasData() && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InventoryResultEntity").add("Id", id()).add("Data", hasData() ? data() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InventoryResultEntity, T> g) {
        return obj -> g.apply((InventoryResultEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InventoryResultEntity> {
        /**
         * <p>
         * ID of the inventory result entity. For example, for managed instance inventory the result will be the managed
         * instance ID. For EC2 instance inventory, the result will be the instance ID.
         * </p>
         * 
         * @param id
         *        ID of the inventory result entity. For example, for managed instance inventory the result will be the
         *        managed instance ID. For EC2 instance inventory, the result will be the instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The data section in the inventory result entity JSON.
         * </p>
         * 
         * @param data
         *        The data section in the inventory result entity JSON.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(Map<String, InventoryResultItem> data);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Map<String, InventoryResultItem> data = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InventoryResultEntity model) {
            id(model.id);
            data(model.data);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Map<String, InventoryResultItem.Builder> getData() {
            Map<String, InventoryResultItem.Builder> result = InventoryResultItemMapCopier.copyToBuilder(this.data);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setData(Map<String, InventoryResultItem.BuilderImpl> data) {
            this.data = InventoryResultItemMapCopier.copyFromBuilder(data);
        }

        @Override
        @Transient
        public final Builder data(Map<String, InventoryResultItem> data) {
            this.data = InventoryResultItemMapCopier.copy(data);
            return this;
        }

        @Override
        public InventoryResultEntity build() {
            return new InventoryResultEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
