/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ssm.model.AutomationExecutionStatus;
import software.amazon.awssdk.services.ssm.model.AutomationParameterMapCopier;
import software.amazon.awssdk.services.ssm.model.FailureDetails;
import software.amazon.awssdk.services.ssm.model.NormalStringMapCopier;
import software.amazon.awssdk.services.ssm.model.Target;
import software.amazon.awssdk.services.ssm.model.TargetLocation;
import software.amazon.awssdk.services.ssm.model.TargetsCopier;
import software.amazon.awssdk.services.ssm.model.ValidNextStepListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StepExecution
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StepExecution> {
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepName").getter(StepExecution.getter(StepExecution::stepName)).setter(StepExecution.setter(Builder::stepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepName").build()}).build();
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(StepExecution.getter(StepExecution::action)).setter(StepExecution.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<Long> TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TimeoutSeconds").getter(StepExecution.getter(StepExecution::timeoutSeconds)).setter(StepExecution.setter(Builder::timeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimeoutSeconds").build()}).build();
    private static final SdkField<String> ON_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OnFailure").getter(StepExecution.getter(StepExecution::onFailure)).setter(StepExecution.setter(Builder::onFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnFailure").build()}).build();
    private static final SdkField<Integer> MAX_ATTEMPTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxAttempts").getter(StepExecution.getter(StepExecution::maxAttempts)).setter(StepExecution.setter(Builder::maxAttempts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAttempts").build()}).build();
    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExecutionStartTime").getter(StepExecution.getter(StepExecution::executionStartTime)).setter(StepExecution.setter(Builder::executionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionStartTime").build()}).build();
    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExecutionEndTime").getter(StepExecution.getter(StepExecution::executionEndTime)).setter(StepExecution.setter(Builder::executionEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionEndTime").build()}).build();
    private static final SdkField<String> STEP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepStatus").getter(StepExecution.getter(StepExecution::stepStatusAsString)).setter(StepExecution.setter(Builder::stepStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepStatus").build()}).build();
    private static final SdkField<String> RESPONSE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResponseCode").getter(StepExecution.getter(StepExecution::responseCode)).setter(StepExecution.setter(Builder::responseCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResponseCode").build()}).build();
    private static final SdkField<Map<String, String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Inputs").getter(StepExecution.getter(StepExecution::inputs)).setter(StepExecution.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, List<String>>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Outputs").getter(StepExecution.getter(StepExecution::outputs)).setter(StepExecution.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Outputs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<String> RESPONSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Response").getter(StepExecution.getter(StepExecution::response)).setter(StepExecution.setter(Builder::response)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Response").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(StepExecution.getter(StepExecution::failureMessage)).setter(StepExecution.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<FailureDetails> FAILURE_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FailureDetails").getter(StepExecution.getter(StepExecution::failureDetails)).setter(StepExecution.setter(Builder::failureDetails)).constructor(FailureDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureDetails").build()}).build();
    private static final SdkField<String> STEP_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StepExecutionId").getter(StepExecution.getter(StepExecution::stepExecutionId)).setter(StepExecution.setter(Builder::stepExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepExecutionId").build()}).build();
    private static final SdkField<Map<String, List<String>>> OVERRIDDEN_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OverriddenParameters").getter(StepExecution.getter(StepExecution::overriddenParameters)).setter(StepExecution.setter(Builder::overriddenParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverriddenParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_END_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsEnd").getter(StepExecution.getter(StepExecution::isEnd)).setter(StepExecution.setter(Builder::isEnd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEnd").build()}).build();
    private static final SdkField<String> NEXT_STEP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextStep").getter(StepExecution.getter(StepExecution::nextStep)).setter(StepExecution.setter(Builder::nextStep)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextStep").build()}).build();
    private static final SdkField<Boolean> IS_CRITICAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsCritical").getter(StepExecution.getter(StepExecution::isCritical)).setter(StepExecution.setter(Builder::isCritical)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsCritical").build()}).build();
    private static final SdkField<List<String>> VALID_NEXT_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ValidNextSteps").getter(StepExecution.getter(StepExecution::validNextSteps)).setter(StepExecution.setter(Builder::validNextSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidNextSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Target>> TARGETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Targets").getter(StepExecution.getter(StepExecution::targets)).setter(StepExecution.setter(Builder::targets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Targets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Target::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TargetLocation> TARGET_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetLocation").getter(StepExecution.getter(StepExecution::targetLocation)).setter(StepExecution.setter(Builder::targetLocation)).constructor(TargetLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetLocation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_NAME_FIELD, ACTION_FIELD, TIMEOUT_SECONDS_FIELD, ON_FAILURE_FIELD, MAX_ATTEMPTS_FIELD, EXECUTION_START_TIME_FIELD, EXECUTION_END_TIME_FIELD, STEP_STATUS_FIELD, RESPONSE_CODE_FIELD, INPUTS_FIELD, OUTPUTS_FIELD, RESPONSE_FIELD, FAILURE_MESSAGE_FIELD, FAILURE_DETAILS_FIELD, STEP_EXECUTION_ID_FIELD, OVERRIDDEN_PARAMETERS_FIELD, IS_END_FIELD, NEXT_STEP_FIELD, IS_CRITICAL_FIELD, VALID_NEXT_STEPS_FIELD, TARGETS_FIELD, TARGET_LOCATION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String stepName;
    private final String action;
    private final Long timeoutSeconds;
    private final String onFailure;
    private final Integer maxAttempts;
    private final Instant executionStartTime;
    private final Instant executionEndTime;
    private final String stepStatus;
    private final String responseCode;
    private final Map<String, String> inputs;
    private final Map<String, List<String>> outputs;
    private final String response;
    private final String failureMessage;
    private final FailureDetails failureDetails;
    private final String stepExecutionId;
    private final Map<String, List<String>> overriddenParameters;
    private final Boolean isEnd;
    private final String nextStep;
    private final Boolean isCritical;
    private final List<String> validNextSteps;
    private final List<Target> targets;
    private final TargetLocation targetLocation;

    private StepExecution(BuilderImpl builder) {
        this.stepName = builder.stepName;
        this.action = builder.action;
        this.timeoutSeconds = builder.timeoutSeconds;
        this.onFailure = builder.onFailure;
        this.maxAttempts = builder.maxAttempts;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.stepStatus = builder.stepStatus;
        this.responseCode = builder.responseCode;
        this.inputs = builder.inputs;
        this.outputs = builder.outputs;
        this.response = builder.response;
        this.failureMessage = builder.failureMessage;
        this.failureDetails = builder.failureDetails;
        this.stepExecutionId = builder.stepExecutionId;
        this.overriddenParameters = builder.overriddenParameters;
        this.isEnd = builder.isEnd;
        this.nextStep = builder.nextStep;
        this.isCritical = builder.isCritical;
        this.validNextSteps = builder.validNextSteps;
        this.targets = builder.targets;
        this.targetLocation = builder.targetLocation;
    }

    public final String stepName() {
        return this.stepName;
    }

    public final String action() {
        return this.action;
    }

    public final Long timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public final String onFailure() {
        return this.onFailure;
    }

    public final Integer maxAttempts() {
        return this.maxAttempts;
    }

    public final Instant executionStartTime() {
        return this.executionStartTime;
    }

    public final Instant executionEndTime() {
        return this.executionEndTime;
    }

    public final AutomationExecutionStatus stepStatus() {
        return AutomationExecutionStatus.fromValue(this.stepStatus);
    }

    public final String stepStatusAsString() {
        return this.stepStatus;
    }

    public final String responseCode() {
        return this.responseCode;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> inputs() {
        return this.inputs;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> outputs() {
        return this.outputs;
    }

    public final String response() {
        return this.response;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final FailureDetails failureDetails() {
        return this.failureDetails;
    }

    public final String stepExecutionId() {
        return this.stepExecutionId;
    }

    public final boolean hasOverriddenParameters() {
        return this.overriddenParameters != null && !(this.overriddenParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> overriddenParameters() {
        return this.overriddenParameters;
    }

    public final Boolean isEnd() {
        return this.isEnd;
    }

    public final String nextStep() {
        return this.nextStep;
    }

    public final Boolean isCritical() {
        return this.isCritical;
    }

    public final boolean hasValidNextSteps() {
        return this.validNextSteps != null && !(this.validNextSteps instanceof SdkAutoConstructList);
    }

    public final List<String> validNextSteps() {
        return this.validNextSteps;
    }

    public final boolean hasTargets() {
        return this.targets != null && !(this.targets instanceof SdkAutoConstructList);
    }

    public final List<Target> targets() {
        return this.targets;
    }

    public final TargetLocation targetLocation() {
        return this.targetLocation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.stepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.action());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.onFailure());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxAttempts());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.response());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOverriddenParameters() ? this.overriddenParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isEnd());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextStep());
        hashCode = 31 * hashCode + Objects.hashCode(this.isCritical());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidNextSteps() ? this.validNextSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTargets() ? this.targets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.targetLocation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepExecution)) {
            return false;
        }
        StepExecution other = (StepExecution)obj;
        return Objects.equals(this.stepName(), other.stepName()) && Objects.equals(this.action(), other.action()) && Objects.equals(this.timeoutSeconds(), other.timeoutSeconds()) && Objects.equals(this.onFailure(), other.onFailure()) && Objects.equals(this.maxAttempts(), other.maxAttempts()) && Objects.equals(this.executionStartTime(), other.executionStartTime()) && Objects.equals(this.executionEndTime(), other.executionEndTime()) && Objects.equals(this.stepStatusAsString(), other.stepStatusAsString()) && Objects.equals(this.responseCode(), other.responseCode()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.response(), other.response()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.failureDetails(), other.failureDetails()) && Objects.equals(this.stepExecutionId(), other.stepExecutionId()) && this.hasOverriddenParameters() == other.hasOverriddenParameters() && Objects.equals(this.overriddenParameters(), other.overriddenParameters()) && Objects.equals(this.isEnd(), other.isEnd()) && Objects.equals(this.nextStep(), other.nextStep()) && Objects.equals(this.isCritical(), other.isCritical()) && this.hasValidNextSteps() == other.hasValidNextSteps() && Objects.equals(this.validNextSteps(), other.validNextSteps()) && this.hasTargets() == other.hasTargets() && Objects.equals(this.targets(), other.targets()) && Objects.equals(this.targetLocation(), other.targetLocation());
    }

    public final String toString() {
        return ToString.builder((String)"StepExecution").add("StepName", (Object)this.stepName()).add("Action", (Object)this.action()).add("TimeoutSeconds", (Object)this.timeoutSeconds()).add("OnFailure", (Object)this.onFailure()).add("MaxAttempts", (Object)this.maxAttempts()).add("ExecutionStartTime", (Object)this.executionStartTime()).add("ExecutionEndTime", (Object)this.executionEndTime()).add("StepStatus", (Object)this.stepStatusAsString()).add("ResponseCode", (Object)this.responseCode()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("Response", (Object)this.response()).add("FailureMessage", (Object)this.failureMessage()).add("FailureDetails", (Object)this.failureDetails()).add("StepExecutionId", (Object)this.stepExecutionId()).add("OverriddenParameters", this.hasOverriddenParameters() ? this.overriddenParameters() : null).add("IsEnd", (Object)this.isEnd()).add("NextStep", (Object)this.nextStep()).add("IsCritical", (Object)this.isCritical()).add("ValidNextSteps", this.hasValidNextSteps() ? this.validNextSteps() : null).add("Targets", this.hasTargets() ? this.targets() : null).add("TargetLocation", (Object)this.targetLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StepName": {
                return Optional.ofNullable(clazz.cast(this.stepName()));
            }
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.action()));
            }
            case "TimeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutSeconds()));
            }
            case "OnFailure": {
                return Optional.ofNullable(clazz.cast(this.onFailure()));
            }
            case "MaxAttempts": {
                return Optional.ofNullable(clazz.cast(this.maxAttempts()));
            }
            case "ExecutionStartTime": {
                return Optional.ofNullable(clazz.cast(this.executionStartTime()));
            }
            case "ExecutionEndTime": {
                return Optional.ofNullable(clazz.cast(this.executionEndTime()));
            }
            case "StepStatus": {
                return Optional.ofNullable(clazz.cast(this.stepStatusAsString()));
            }
            case "ResponseCode": {
                return Optional.ofNullable(clazz.cast(this.responseCode()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "Outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "Response": {
                return Optional.ofNullable(clazz.cast(this.response()));
            }
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "FailureDetails": {
                return Optional.ofNullable(clazz.cast(this.failureDetails()));
            }
            case "StepExecutionId": {
                return Optional.ofNullable(clazz.cast(this.stepExecutionId()));
            }
            case "OverriddenParameters": {
                return Optional.ofNullable(clazz.cast(this.overriddenParameters()));
            }
            case "IsEnd": {
                return Optional.ofNullable(clazz.cast(this.isEnd()));
            }
            case "NextStep": {
                return Optional.ofNullable(clazz.cast(this.nextStep()));
            }
            case "IsCritical": {
                return Optional.ofNullable(clazz.cast(this.isCritical()));
            }
            case "ValidNextSteps": {
                return Optional.ofNullable(clazz.cast(this.validNextSteps()));
            }
            case "Targets": {
                return Optional.ofNullable(clazz.cast(this.targets()));
            }
            case "TargetLocation": {
                return Optional.ofNullable(clazz.cast(this.targetLocation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StepExecution, T> g) {
        return obj -> g.apply((StepExecution)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String stepName;
        private String action;
        private Long timeoutSeconds;
        private String onFailure;
        private Integer maxAttempts;
        private Instant executionStartTime;
        private Instant executionEndTime;
        private String stepStatus;
        private String responseCode;
        private Map<String, String> inputs = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, List<String>> outputs = DefaultSdkAutoConstructMap.getInstance();
        private String response;
        private String failureMessage;
        private FailureDetails failureDetails;
        private String stepExecutionId;
        private Map<String, List<String>> overriddenParameters = DefaultSdkAutoConstructMap.getInstance();
        private Boolean isEnd;
        private String nextStep;
        private Boolean isCritical;
        private List<String> validNextSteps = DefaultSdkAutoConstructList.getInstance();
        private List<Target> targets = DefaultSdkAutoConstructList.getInstance();
        private TargetLocation targetLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(StepExecution model) {
            this.stepName(model.stepName);
            this.action(model.action);
            this.timeoutSeconds(model.timeoutSeconds);
            this.onFailure(model.onFailure);
            this.maxAttempts(model.maxAttempts);
            this.executionStartTime(model.executionStartTime);
            this.executionEndTime(model.executionEndTime);
            this.stepStatus(model.stepStatus);
            this.responseCode(model.responseCode);
            this.inputs(model.inputs);
            this.outputs(model.outputs);
            this.response(model.response);
            this.failureMessage(model.failureMessage);
            this.failureDetails(model.failureDetails);
            this.stepExecutionId(model.stepExecutionId);
            this.overriddenParameters(model.overriddenParameters);
            this.isEnd(model.isEnd);
            this.nextStep(model.nextStep);
            this.isCritical(model.isCritical);
            this.validNextSteps(model.validNextSteps);
            this.targets(model.targets);
            this.targetLocation(model.targetLocation);
        }

        public final String getStepName() {
            return this.stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        @Transient
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        @Transient
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        public final Long getTimeoutSeconds() {
            return this.timeoutSeconds;
        }

        public final void setTimeoutSeconds(Long timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        @Transient
        public final Builder timeoutSeconds(Long timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        public final String getOnFailure() {
            return this.onFailure;
        }

        public final void setOnFailure(String onFailure) {
            this.onFailure = onFailure;
        }

        @Override
        @Transient
        public final Builder onFailure(String onFailure) {
            this.onFailure = onFailure;
            return this;
        }

        public final Integer getMaxAttempts() {
            return this.maxAttempts;
        }

        public final void setMaxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        @Override
        @Transient
        public final Builder maxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public final Instant getExecutionStartTime() {
            return this.executionStartTime;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        @Override
        @Transient
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final Instant getExecutionEndTime() {
            return this.executionEndTime;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        @Override
        @Transient
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final String getStepStatus() {
            return this.stepStatus;
        }

        public final void setStepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
        }

        @Override
        @Transient
        public final Builder stepStatus(String stepStatus) {
            this.stepStatus = stepStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder stepStatus(AutomationExecutionStatus stepStatus) {
            this.stepStatus(stepStatus == null ? null : stepStatus.toString());
            return this;
        }

        public final String getResponseCode() {
            return this.responseCode;
        }

        public final void setResponseCode(String responseCode) {
            this.responseCode = responseCode;
        }

        @Override
        @Transient
        public final Builder responseCode(String responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        public final Map<String, String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Map<String, String> inputs) {
            this.inputs = NormalStringMapCopier.copy(inputs);
        }

        @Override
        @Transient
        public final Builder inputs(Map<String, String> inputs) {
            this.inputs = NormalStringMapCopier.copy(inputs);
            return this;
        }

        public final Map<String, ? extends Collection<String>> getOutputs() {
            if (this.outputs instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.outputs;
        }

        public final void setOutputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
        }

        @Override
        @Transient
        public final Builder outputs(Map<String, ? extends Collection<String>> outputs) {
            this.outputs = AutomationParameterMapCopier.copy(outputs);
            return this;
        }

        public final String getResponse() {
            return this.response;
        }

        public final void setResponse(String response) {
            this.response = response;
        }

        @Override
        @Transient
        public final Builder response(String response) {
            this.response = response;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        @Transient
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final FailureDetails.Builder getFailureDetails() {
            return this.failureDetails != null ? this.failureDetails.toBuilder() : null;
        }

        public final void setFailureDetails(FailureDetails.BuilderImpl failureDetails) {
            this.failureDetails = failureDetails != null ? failureDetails.build() : null;
        }

        @Override
        @Transient
        public final Builder failureDetails(FailureDetails failureDetails) {
            this.failureDetails = failureDetails;
            return this;
        }

        public final String getStepExecutionId() {
            return this.stepExecutionId;
        }

        public final void setStepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
        }

        @Override
        @Transient
        public final Builder stepExecutionId(String stepExecutionId) {
            this.stepExecutionId = stepExecutionId;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getOverriddenParameters() {
            if (this.overriddenParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.overriddenParameters;
        }

        public final void setOverriddenParameters(Map<String, ? extends Collection<String>> overriddenParameters) {
            this.overriddenParameters = AutomationParameterMapCopier.copy(overriddenParameters);
        }

        @Override
        @Transient
        public final Builder overriddenParameters(Map<String, ? extends Collection<String>> overriddenParameters) {
            this.overriddenParameters = AutomationParameterMapCopier.copy(overriddenParameters);
            return this;
        }

        public final Boolean getIsEnd() {
            return this.isEnd;
        }

        public final void setIsEnd(Boolean isEnd) {
            this.isEnd = isEnd;
        }

        @Override
        @Transient
        public final Builder isEnd(Boolean isEnd) {
            this.isEnd = isEnd;
            return this;
        }

        public final String getNextStep() {
            return this.nextStep;
        }

        public final void setNextStep(String nextStep) {
            this.nextStep = nextStep;
        }

        @Override
        @Transient
        public final Builder nextStep(String nextStep) {
            this.nextStep = nextStep;
            return this;
        }

        public final Boolean getIsCritical() {
            return this.isCritical;
        }

        public final void setIsCritical(Boolean isCritical) {
            this.isCritical = isCritical;
        }

        @Override
        @Transient
        public final Builder isCritical(Boolean isCritical) {
            this.isCritical = isCritical;
            return this;
        }

        public final Collection<String> getValidNextSteps() {
            if (this.validNextSteps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validNextSteps;
        }

        public final void setValidNextSteps(Collection<String> validNextSteps) {
            this.validNextSteps = ValidNextStepListCopier.copy(validNextSteps);
        }

        @Override
        @Transient
        public final Builder validNextSteps(Collection<String> validNextSteps) {
            this.validNextSteps = ValidNextStepListCopier.copy(validNextSteps);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder validNextSteps(String ... validNextSteps) {
            this.validNextSteps(Arrays.asList(validNextSteps));
            return this;
        }

        public final List<Target.Builder> getTargets() {
            List<Target.Builder> result = TargetsCopier.copyToBuilder(this.targets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTargets(Collection<Target.BuilderImpl> targets) {
            this.targets = TargetsCopier.copyFromBuilder(targets);
        }

        @Override
        @Transient
        public final Builder targets(Collection<Target> targets) {
            this.targets = TargetsCopier.copy(targets);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(Target ... targets) {
            this.targets(Arrays.asList(targets));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder targets(Consumer<Target.Builder> ... targets) {
            this.targets(Stream.of(targets).map(c -> (Target)((Target.Builder)Target.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TargetLocation.Builder getTargetLocation() {
            return this.targetLocation != null ? this.targetLocation.toBuilder() : null;
        }

        public final void setTargetLocation(TargetLocation.BuilderImpl targetLocation) {
            this.targetLocation = targetLocation != null ? targetLocation.build() : null;
        }

        @Override
        @Transient
        public final Builder targetLocation(TargetLocation targetLocation) {
            this.targetLocation = targetLocation;
            return this;
        }

        public StepExecution build() {
            return new StepExecution(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StepExecution> {
        public Builder stepName(String var1);

        public Builder action(String var1);

        public Builder timeoutSeconds(Long var1);

        public Builder onFailure(String var1);

        public Builder maxAttempts(Integer var1);

        public Builder executionStartTime(Instant var1);

        public Builder executionEndTime(Instant var1);

        public Builder stepStatus(String var1);

        public Builder stepStatus(AutomationExecutionStatus var1);

        public Builder responseCode(String var1);

        public Builder inputs(Map<String, String> var1);

        public Builder outputs(Map<String, ? extends Collection<String>> var1);

        public Builder response(String var1);

        public Builder failureMessage(String var1);

        public Builder failureDetails(FailureDetails var1);

        default public Builder failureDetails(Consumer<FailureDetails.Builder> failureDetails) {
            return this.failureDetails((FailureDetails)((FailureDetails.Builder)FailureDetails.builder().applyMutation(failureDetails)).build());
        }

        public Builder stepExecutionId(String var1);

        public Builder overriddenParameters(Map<String, ? extends Collection<String>> var1);

        public Builder isEnd(Boolean var1);

        public Builder nextStep(String var1);

        public Builder isCritical(Boolean var1);

        public Builder validNextSteps(Collection<String> var1);

        public Builder validNextSteps(String ... var1);

        public Builder targets(Collection<Target> var1);

        public Builder targets(Target ... var1);

        public Builder targets(Consumer<Target.Builder> ... var1);

        public Builder targetLocation(TargetLocation var1);

        default public Builder targetLocation(Consumer<TargetLocation.Builder> targetLocation) {
            return this.targetLocation((TargetLocation)((TargetLocation.Builder)TargetLocation.builder().applyMutation(targetLocation)).build());
        }
    }
}

