/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ssm.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the information about a task invocation for a particular target as part of a task execution performed as
 * part of a maintenance window execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceWindowExecutionTaskInvocationIdentity
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<MaintenanceWindowExecutionTaskInvocationIdentity.Builder, MaintenanceWindowExecutionTaskInvocationIdentity> {
    private static final SdkField<String> WINDOW_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowExecutionId").getter(getter(MaintenanceWindowExecutionTaskInvocationIdentity::windowExecutionId))
            .setter(setter(Builder::windowExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowExecutionId").build()).build();

    private static final SdkField<String> TASK_EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskExecutionId").getter(getter(MaintenanceWindowExecutionTaskInvocationIdentity::taskExecutionId))
            .setter(setter(Builder::taskExecutionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskExecutionId").build()).build();

    private static final SdkField<String> INVOCATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InvocationId").getter(getter(MaintenanceWindowExecutionTaskInvocationIdentity::invocationId))
            .setter(setter(Builder::invocationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InvocationId").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExecutionId").getter(getter(MaintenanceWindowExecutionTaskInvocationIdentity::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionId").build()).build();

    private static final SdkField<String> TASK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskType").getter(getter(MaintenanceWindowExecutionTaskInvocationIdentity::taskTypeAsString))
            .setter(setter(Builder::taskType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskType").build()).build();

    private static final SdkField<String> PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Parameters").getter(getter(MaintenanceWindowExecutionTaskInvocationIdentity::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MaintenanceWindowExecutionTaskInvocationIdentity::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatusDetails").getter(getter(MaintenanceWindowExecutionTaskInvocationIdentity::statusDetails))
            .setter(setter(Builder::statusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusDetails").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(MaintenanceWindowExecutionTaskInvocationIdentity::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(MaintenanceWindowExecutionTaskInvocationIdentity::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> OWNER_INFORMATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OwnerInformation").getter(getter(MaintenanceWindowExecutionTaskInvocationIdentity::ownerInformation))
            .setter(setter(Builder::ownerInformation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerInformation").build()).build();

    private static final SdkField<String> WINDOW_TARGET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WindowTargetId").getter(getter(MaintenanceWindowExecutionTaskInvocationIdentity::windowTargetId))
            .setter(setter(Builder::windowTargetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WindowTargetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WINDOW_EXECUTION_ID_FIELD,
            TASK_EXECUTION_ID_FIELD, INVOCATION_ID_FIELD, EXECUTION_ID_FIELD, TASK_TYPE_FIELD, PARAMETERS_FIELD, STATUS_FIELD,
            STATUS_DETAILS_FIELD, START_TIME_FIELD, END_TIME_FIELD, OWNER_INFORMATION_FIELD, WINDOW_TARGET_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String windowExecutionId;

    private final String taskExecutionId;

    private final String invocationId;

    private final String executionId;

    private final String taskType;

    private final String parameters;

    private final String status;

    private final String statusDetails;

    private final Instant startTime;

    private final Instant endTime;

    private final String ownerInformation;

    private final String windowTargetId;

    private MaintenanceWindowExecutionTaskInvocationIdentity(BuilderImpl builder) {
        this.windowExecutionId = builder.windowExecutionId;
        this.taskExecutionId = builder.taskExecutionId;
        this.invocationId = builder.invocationId;
        this.executionId = builder.executionId;
        this.taskType = builder.taskType;
        this.parameters = builder.parameters;
        this.status = builder.status;
        this.statusDetails = builder.statusDetails;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.ownerInformation = builder.ownerInformation;
        this.windowTargetId = builder.windowTargetId;
    }

    /**
     * <p>
     * The ID of the maintenance window execution that ran the task.
     * </p>
     * 
     * @return The ID of the maintenance window execution that ran the task.
     */
    public final String windowExecutionId() {
        return windowExecutionId;
    }

    /**
     * <p>
     * The ID of the specific task execution in the maintenance window execution.
     * </p>
     * 
     * @return The ID of the specific task execution in the maintenance window execution.
     */
    public final String taskExecutionId() {
        return taskExecutionId;
    }

    /**
     * <p>
     * The ID of the task invocation.
     * </p>
     * 
     * @return The ID of the task invocation.
     */
    public final String invocationId() {
        return invocationId;
    }

    /**
     * <p>
     * The ID of the action performed in the service that actually handled the task invocation. If the task type is
     * <code>RUN_COMMAND</code>, this value is the command ID.
     * </p>
     * 
     * @return The ID of the action performed in the service that actually handled the task invocation. If the task type
     *         is <code>RUN_COMMAND</code>, this value is the command ID.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The task type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link MaintenanceWindowTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskTypeAsString}.
     * </p>
     * 
     * @return The task type.
     * @see MaintenanceWindowTaskType
     */
    public final MaintenanceWindowTaskType taskType() {
        return MaintenanceWindowTaskType.fromValue(taskType);
    }

    /**
     * <p>
     * The task type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskType} will
     * return {@link MaintenanceWindowTaskType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #taskTypeAsString}.
     * </p>
     * 
     * @return The task type.
     * @see MaintenanceWindowTaskType
     */
    public final String taskTypeAsString() {
        return taskType;
    }

    /**
     * <p>
     * The parameters that were provided for the invocation when it was run.
     * </p>
     * 
     * @return The parameters that were provided for the invocation when it was run.
     */
    public final String parameters() {
        return parameters;
    }

    /**
     * <p>
     * The status of the task invocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MaintenanceWindowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task invocation.
     * @see MaintenanceWindowExecutionStatus
     */
    public final MaintenanceWindowExecutionStatus status() {
        return MaintenanceWindowExecutionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the task invocation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MaintenanceWindowExecutionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the task invocation.
     * @see MaintenanceWindowExecutionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The details explaining the status of the task invocation. Not available for all status values.
     * </p>
     * 
     * @return The details explaining the status of the task invocation. Not available for all status values.
     */
    public final String statusDetails() {
        return statusDetails;
    }

    /**
     * <p>
     * The time the invocation started.
     * </p>
     * 
     * @return The time the invocation started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time the invocation finished.
     * </p>
     * 
     * @return The time the invocation finished.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * User-provided value that was specified when the target was registered with the maintenance window. This was also
     * included in any Amazon CloudWatch Events events raised during the task invocation.
     * </p>
     * 
     * @return User-provided value that was specified when the target was registered with the maintenance window. This
     *         was also included in any Amazon CloudWatch Events events raised during the task invocation.
     */
    public final String ownerInformation() {
        return ownerInformation;
    }

    /**
     * <p>
     * The ID of the target definition in this maintenance window the invocation was performed for.
     * </p>
     * 
     * @return The ID of the target definition in this maintenance window the invocation was performed for.
     */
    public final String windowTargetId() {
        return windowTargetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(windowExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(taskExecutionId());
        hashCode = 31 * hashCode + Objects.hashCode(invocationId());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(taskTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(ownerInformation());
        hashCode = 31 * hashCode + Objects.hashCode(windowTargetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceWindowExecutionTaskInvocationIdentity)) {
            return false;
        }
        MaintenanceWindowExecutionTaskInvocationIdentity other = (MaintenanceWindowExecutionTaskInvocationIdentity) obj;
        return Objects.equals(windowExecutionId(), other.windowExecutionId())
                && Objects.equals(taskExecutionId(), other.taskExecutionId())
                && Objects.equals(invocationId(), other.invocationId()) && Objects.equals(executionId(), other.executionId())
                && Objects.equals(taskTypeAsString(), other.taskTypeAsString())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusDetails(), other.statusDetails()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(ownerInformation(), other.ownerInformation())
                && Objects.equals(windowTargetId(), other.windowTargetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MaintenanceWindowExecutionTaskInvocationIdentity").add("WindowExecutionId", windowExecutionId())
                .add("TaskExecutionId", taskExecutionId()).add("InvocationId", invocationId()).add("ExecutionId", executionId())
                .add("TaskType", taskTypeAsString())
                .add("Parameters", parameters() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Status", statusAsString()).add("StatusDetails", statusDetails()).add("StartTime", startTime())
                .add("EndTime", endTime())
                .add("OwnerInformation", ownerInformation() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WindowTargetId", windowTargetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "WindowExecutionId":
            return Optional.ofNullable(clazz.cast(windowExecutionId()));
        case "TaskExecutionId":
            return Optional.ofNullable(clazz.cast(taskExecutionId()));
        case "InvocationId":
            return Optional.ofNullable(clazz.cast(invocationId()));
        case "ExecutionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "TaskType":
            return Optional.ofNullable(clazz.cast(taskTypeAsString()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "StatusDetails":
            return Optional.ofNullable(clazz.cast(statusDetails()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "OwnerInformation":
            return Optional.ofNullable(clazz.cast(ownerInformation()));
        case "WindowTargetId":
            return Optional.ofNullable(clazz.cast(windowTargetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceWindowExecutionTaskInvocationIdentity, T> g) {
        return obj -> g.apply((MaintenanceWindowExecutionTaskInvocationIdentity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceWindowExecutionTaskInvocationIdentity> {
        /**
         * <p>
         * The ID of the maintenance window execution that ran the task.
         * </p>
         * 
         * @param windowExecutionId
         *        The ID of the maintenance window execution that ran the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowExecutionId(String windowExecutionId);

        /**
         * <p>
         * The ID of the specific task execution in the maintenance window execution.
         * </p>
         * 
         * @param taskExecutionId
         *        The ID of the specific task execution in the maintenance window execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskExecutionId(String taskExecutionId);

        /**
         * <p>
         * The ID of the task invocation.
         * </p>
         * 
         * @param invocationId
         *        The ID of the task invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invocationId(String invocationId);

        /**
         * <p>
         * The ID of the action performed in the service that actually handled the task invocation. If the task type is
         * <code>RUN_COMMAND</code>, this value is the command ID.
         * </p>
         * 
         * @param executionId
         *        The ID of the action performed in the service that actually handled the task invocation. If the task
         *        type is <code>RUN_COMMAND</code>, this value is the command ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The task type.
         * </p>
         * 
         * @param taskType
         *        The task type.
         * @see MaintenanceWindowTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowTaskType
         */
        Builder taskType(String taskType);

        /**
         * <p>
         * The task type.
         * </p>
         * 
         * @param taskType
         *        The task type.
         * @see MaintenanceWindowTaskType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowTaskType
         */
        Builder taskType(MaintenanceWindowTaskType taskType);

        /**
         * <p>
         * The parameters that were provided for the invocation when it was run.
         * </p>
         * 
         * @param parameters
         *        The parameters that were provided for the invocation when it was run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(String parameters);

        /**
         * <p>
         * The status of the task invocation.
         * </p>
         * 
         * @param status
         *        The status of the task invocation.
         * @see MaintenanceWindowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowExecutionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the task invocation.
         * </p>
         * 
         * @param status
         *        The status of the task invocation.
         * @see MaintenanceWindowExecutionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceWindowExecutionStatus
         */
        Builder status(MaintenanceWindowExecutionStatus status);

        /**
         * <p>
         * The details explaining the status of the task invocation. Not available for all status values.
         * </p>
         * 
         * @param statusDetails
         *        The details explaining the status of the task invocation. Not available for all status values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusDetails(String statusDetails);

        /**
         * <p>
         * The time the invocation started.
         * </p>
         * 
         * @param startTime
         *        The time the invocation started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time the invocation finished.
         * </p>
         * 
         * @param endTime
         *        The time the invocation finished.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * User-provided value that was specified when the target was registered with the maintenance window. This was
         * also included in any Amazon CloudWatch Events events raised during the task invocation.
         * </p>
         * 
         * @param ownerInformation
         *        User-provided value that was specified when the target was registered with the maintenance window.
         *        This was also included in any Amazon CloudWatch Events events raised during the task invocation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerInformation(String ownerInformation);

        /**
         * <p>
         * The ID of the target definition in this maintenance window the invocation was performed for.
         * </p>
         * 
         * @param windowTargetId
         *        The ID of the target definition in this maintenance window the invocation was performed for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windowTargetId(String windowTargetId);
    }

    static final class BuilderImpl implements Builder {
        private String windowExecutionId;

        private String taskExecutionId;

        private String invocationId;

        private String executionId;

        private String taskType;

        private String parameters;

        private String status;

        private String statusDetails;

        private Instant startTime;

        private Instant endTime;

        private String ownerInformation;

        private String windowTargetId;

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceWindowExecutionTaskInvocationIdentity model) {
            windowExecutionId(model.windowExecutionId);
            taskExecutionId(model.taskExecutionId);
            invocationId(model.invocationId);
            executionId(model.executionId);
            taskType(model.taskType);
            parameters(model.parameters);
            status(model.status);
            statusDetails(model.statusDetails);
            startTime(model.startTime);
            endTime(model.endTime);
            ownerInformation(model.ownerInformation);
            windowTargetId(model.windowTargetId);
        }

        public final String getWindowExecutionId() {
            return windowExecutionId;
        }

        @Override
        public final Builder windowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
            return this;
        }

        public final void setWindowExecutionId(String windowExecutionId) {
            this.windowExecutionId = windowExecutionId;
        }

        public final String getTaskExecutionId() {
            return taskExecutionId;
        }

        @Override
        public final Builder taskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
            return this;
        }

        public final void setTaskExecutionId(String taskExecutionId) {
            this.taskExecutionId = taskExecutionId;
        }

        public final String getInvocationId() {
            return invocationId;
        }

        @Override
        public final Builder invocationId(String invocationId) {
            this.invocationId = invocationId;
            return this;
        }

        public final void setInvocationId(String invocationId) {
            this.invocationId = invocationId;
        }

        public final String getExecutionId() {
            return executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        public final String getTaskType() {
            return taskType;
        }

        @Override
        public final Builder taskType(String taskType) {
            this.taskType = taskType;
            return this;
        }

        @Override
        public final Builder taskType(MaintenanceWindowTaskType taskType) {
            this.taskType(taskType == null ? null : taskType.toString());
            return this;
        }

        public final void setTaskType(String taskType) {
            this.taskType = taskType;
        }

        public final String getParameters() {
            return parameters;
        }

        @Override
        public final Builder parameters(String parameters) {
            this.parameters = parameters;
            return this;
        }

        public final void setParameters(String parameters) {
            this.parameters = parameters;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MaintenanceWindowExecutionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getStatusDetails() {
            return statusDetails;
        }

        @Override
        public final Builder statusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
            return this;
        }

        public final void setStatusDetails(String statusDetails) {
            this.statusDetails = statusDetails;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getOwnerInformation() {
            return ownerInformation;
        }

        @Override
        public final Builder ownerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
            return this;
        }

        public final void setOwnerInformation(String ownerInformation) {
            this.ownerInformation = ownerInformation;
        }

        public final String getWindowTargetId() {
            return windowTargetId;
        }

        @Override
        public final Builder windowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
            return this;
        }

        public final void setWindowTargetId(String windowTargetId) {
            this.windowTargetId = windowTargetId;
        }

        @Override
        public MaintenanceWindowExecutionTaskInvocationIdentity build() {
            return new MaintenanceWindowExecutionTaskInvocationIdentity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
